compress =
function(str, size = nchar(str) * 1.01 + 13, level = integer())
{
  minSize = nchar(str) * 1.01 + 13
  if(size < minSize)
    size = minSize 

  .Call(R_compress, str, raw(size), as.integer(level))
}

uncompress =
function(content, size =  length(content)*10, asText = TRUE) 
  .Call(R_uncompress, content, size, as.logical(asText))


gunzip  =
function(content, size = length(content) * 5, asText = TRUE)
{
  if(typeof(content) == "raw")
     .Call(R_gzuncompress, content, as.numeric(size), as.logical(asText))
  else
    stop("to uncompress a file, call the gzip system command or use the gz() function to read the contents into R.")
}  

