<?xml version="1.0"?>

<!-- Copyright the Omegahat Project for Statistical Computing, 2000 -->
<!-- Author: Duncan Temple Lang -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  
                xmlns:r="http://www.r-project.org"
                xmlns:rs="http://www.omegahat.org/RS"
                xmlns:c="http://www.C.org"
                version="1.0">


<!-- 
   This walks through all the code tags that match the language
   of interest and have a file attribute. It then writes this
   to standard output.
  -->

<xsl:param name="language" select="'C'"/>
<xsl:output method="text" omit-xml-declaration="yes" />

<xsl:template match="/">
 <xsl:apply-templates select="//code[@lang=$language and @file]" />
</xsl:template>

<xsl:template match="code">
 <xsl:value-of select="@file" />
</xsl:template>

</xsl:stylesheet>
