### Name: COMAccessors
### Title: COM Object Accesors
### Aliases: COMAccessors $,COMIDispatch-method $<-,COMIDispatch-method
###   [[,COMIDispatch,ANY-method [[,COMIDispatch,numeric-method
###   [[<-,COMIDispatch-method
### Keywords: interface

### ** Examples

 e <- COMCreate("Excel.Application")

  # Boolean/Logical
 e[["Visible"]]
  # Setting a value.
 e[["Visible"]] <- TRUE

  # String
 e[["Path"]]
 e[["Version"]]

  # Double
 e[["Width"]]

  # Long
 e[["SheetsInNewWorkbook"]]
 
  # Object
 books <- e[["Workbooks"]]

 books$Add()

  # Use this as a container, so can have integer indices, 1-based.
 books[[1]]
 e[["Workbooks"]][[1]]

## Not run: 
##D  books$Open("C:\mySheet.xls")
## End(Not run)

 e$CheckSpelling("This is a spell check") # okay
 e$CheckSpelling("This is a spell chck") # error

## Not run: 
##D  
##D  e$SaveWorkspace()
## End(Not run)
 e$Quit()

 rm(list= c("e", "books"))
 gc()




