### Name: comments
### Title: Query elements of word processing document
### Aliases: comments sections footnotes images
### Keywords: IO

### ** Examples


if((tmp <- Sys.getenv("GOOGLE_DOCS_PASSWORD")) != "") {
  tmp = strsplit(tmp, "=")[[1]]
  assign("GoogleDocsPassword", structure(tmp[2], names = tmp[1]), globalenv())
}

if(exists("GoogleDocsPassword")) {
      # getGoogleDocsConnection("my login", "my password")

   con = getGoogleDocsConnection(names(GoogleDocsPassword), GoogleDocsPassword)
   images("Many Parts", con)
   comments("Many Parts", con)

   docs = getDocs(con)
   sections(docs[["Many Parts"]], con)

     # If we want to parse the document just once and then 
     # get the elements without having to go back to Google
     # each time to download the document.
   hdoc = htmlParse(getDocContent("Many Parts", con), asText = TRUE, error = function(...){})
   comments(hdoc)
   images(hdoc)
   sections(hdoc)
   footnotes(hdoc)
}



