### Name: getDocs
### Title: Get a list of available documents
### Aliases: getDocs
### Keywords: IO

### ** Examples

if(exists("GoogleDocsPassword")) {
         # getGoogleDocsConnection("my login", "my password")
cat("Getting documents\n")
  con = getGoogleDocsConnection(names(GoogleDocsPassword), GoogleDocsPassword)

  getDocs(con)  # list of GoogleDocuments
  getDocs(con, TRUE) # a data frame

  con = getGoogleDocsConnection("me", "password", service = "wise")
  getDocs(con)  # just the spreadsheets

    # Get just the word processing documents, i.e. not the spreadsheets, 
  d = getDocs(con, what = "http://docs.google.com/feeds/documents/private/full/-/document")
    # The above should be slightly faster than doing the subsetting in R.
  d = getDocs(con)
  d[sapply(d, is, "GoogleDocument")]

  spreadsheetsDocs = getDocs(con, what = "http://docs.google.com/feeds/documents/private/full/-/spreadsheet")

     # Get the starred spreadsheets
  starredSheets = getDocs(con, what = "http://docs.google.com/feeds/documents/private/full/-/spreadsheet/starred")

      # documents within the directory named MyDir
   o = getDocs(con, what = "http://docs.google.com/feeds/documents/private/full/-/MyDir")

}



