### Name: getZipInfo
### Title: Read table of contents from zip archive
### Aliases: getZipInfo
### Keywords: IO

### ** Examples


  zipFile = system.file("sampleData", "MyZip.zip", package = "Rcompression")
  df = getZipInfo(zipFile)
  df[grep("^R/", rownames(df)), ]
  weekdays(df$date)

  # Treating the files element-wise rather than in a data frame.
  els = getZipInfo(zipFile, FALSE)
  sapply(els, slot, "compressed_size")/sapply(els, slot, "uncompressed_size")

   # Get the month the file was last modified.
   # This is in the tmu_date slot of each element.
  sapply(els, function(x) x@tmu_date@tm_mon)



