### Name: uncompress
### Title: Uncompress in-memory data in either zlib or GNU zip format
### Aliases: uncompress bunzip2 gunzip
### Keywords: IO programming

### ** Examples


 x = "A string to compress"
 g = compress(x)
 uncompress(g) == x

 # Read contents of a GNU zipped file and uncompress the contents
 # directly from memory.  We could do this with gz() directly from R
 # but this is just arranging to get the raw data locally rather than,
 # e.g. from an HTTP request

 f = system.file("sampleData", "NAMESPACE.gz", package = "Rcompression")
 con = file(f, "rb")
 fs = file.info(f)$size
 content  = readBin(con, raw(fs), fs)
 close(con)
 gunzip(content, 10000)




