### Name: gzip
### Title: Perform in-memory gzip compression
### Aliases: gzip
### Keywords: IO

### ** Examples

txt = paste(rep("This is a string", 40), collapse = "\n")
v = gzip(txt)
f = tempfile()
writeBin(v, f)
readLines(gzfile(f))

dev = paste(tempfile(), "pdf", sep = ".")
pdf(dev)
plot(1:10)
dev.off()
vals = readBinaryFile(dev)
writeBin(gzip(vals), paste(dev, "gz", sep = "."))




