### Name: zipArchive
### Title: Constructor for object representing ZIP archive on disk
### Aliases: zipArchive ZipArchive-class $,ZipArchive-method
###   [,ZipArchive,ANY,missing-method [[,ZipArchive,ANY,missing-method
###   [<-.ZipArchive $<-.ZipArchive [[<-,ZipArchive-method
###   length,ZipArchive-method names,ZipArchive-method getZipFileEntry
### Keywords: IO programming

### ** Examples

  f = system.file("sampleData", "MyZip.zip", package = "Rcompression")
  ar = zipArchive(f)
  names(ar)
  length(ar)
  ar[["FAQ.html"]]
  ar[["bunzip"]]  # partial matching
  ar[".*"]  # regular expression

  f = system.file("sampleData", "tests.zip", package = "Rcompression")
  ar = zipArchive(f)
   
  names(ar)
  length(ar)

     # This needs a password to access the contents of any of the file.
     # The password is the string "password" (pretty simple).
  ar[["files.R", password = "password"]]

     # without the password, we'd have an error.
  try(ar[["files.R"]])

    # 
  f = system.file("sampleData", "Empty.docx", package = "Rcompression")
  tgt = paste(tempdir(), "word.docx", sep = .Platform$file.sep)
  file.copy(f, tgt)

  ar = zipArchive(tgt)

  tmp = tempfile()
  cat("This is some text\nin a file", file = tmp)
  ar[["fromFile"]] = tmp

  ar[["fromAsIs"]] = I("Text/that/shouldn't be mistaken for a file")
  ar[["fromText"]] = "more heuristic text"
  names(ar)

  ar["one"] = tmp

  ar[c("two", "fromAsIs")] = list(tmp, I("Text/that/shouldn't be mistaken for a file"))
  names(ar)


   #### 
    # In memory archives

  contents = loadZip(system.file("sampleData", "Empty.docx", package = "Rcompression"))
  ar = zipArchive(contents)
  names(ar)
  length(ar)

  if(require(RCurl)) {

     data = getURLContent('http://www.ecb.int/stats/eurofxref/eurofxref-hist.zip?1a1b5dbb25d31898b347736783bd440a')
     ar = zipArchive(data)
     read.csv(textConnection(ar[[1]]), header = TRUE, na.strings = "N/A")
  }
  



