<?xml version="1.0"?>
<!-- Customization layer -->


<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:r="http://www.r-project.org"
		xmlns:s="http://cm.bell-labs.com/stat/S4"
		xmlns:c="http://www.c.org"
                xmlns:python="http://www.python.org"
                xmlns:perl="http://www.perl.org"
		xmlns:vb="http://www.visualbasic.com"
		xmlns:omegahat="http://www.omegahat.org"
                xmlns:bioc="http://www.bioconductor.org"
		xmlns:com="http://www.microsoft.com"
                version="1.0">

<!-- Use 'chunk.xsl' in line below to chunk files. -->
<xsl:import href="http://www.omegahat.org/XSL/Rstyle.xsl"/>

<xsl:template match="environment">
 <xsl:element name="OBJECT">
  <xsl:attribute name="type">R-push-environment</xsl:attribute>
  <xsl:attribute name="hidden">true</xsl:attribute>
  <xsl:attribute name="name"><xsl:value-of select="@id"/></xsl:attribute>  
<!--XXX  -->
  <xsl:if test="@parent!=''">
   <xsl:element name="param">
    <xsl:attribute name="name">parent</xsl:attribute>
    <xsl:attribute name="value"><xsl:value-of  select="@parent"/></xsl:attribute>  
   </xsl:element>
  </xsl:if>
 </xsl:element>

  <xsl:apply-templates />

 <object type="R-pop-environment" hidden="true"/>
</xsl:template>


<!-- 
 <OBJECT type="R-assign-environment" name="@name">
  <param name="value" value="@value"/>
 </OBJECT>
 -->

<xsl:template name="envirSymbol">
 <xsl:element name="OBJECT">
  <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
  <xsl:attribute name="type">R-assign-environment</xsl:attribute>
  <xsl:element name="param">
   <xsl:attribute name="name">value</xsl:attribute>
   <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
  </xsl:element>
 </xsl:element>
</xsl:template>

<!-- XXX Fixme -->
<!-- 
<xsl:template match="environmentInitialize">
 <xsl:for-each select="./symbol">
  <xsl:call-template name="envirSymbol"/>
 </xsl:for-each>
</xsl:template>
 -->
<xsl:template match="environmentInitialize"> 
<xsl:apply-templates />
</xsl:template>

<xsl:template match="environmentInitialize/s:code">
 <OBJECT type="app/x-R-command" hidden="true">
   <xsl:element name="param">
    <xsl:attribute name="name">init</xsl:attribute>
    <xsl:attribute name="value"><xsl:value-of disable-output-escaping="yes" select="."/></xsl:attribute>
   </xsl:element>
 </OBJECT>
</xsl:template>

<xsl:template match="environmentInitialize/symbol">
 <xsl:element name="OBJECT">
  <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
  <xsl:attribute name="type">R-assign-environment</xsl:attribute>
  <xsl:element name="param">
   <xsl:attribute name="name">value</xsl:attribute>
   <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
  </xsl:element>
 </xsl:element>
</xsl:template>

<xsl:template match="s:figure">
 <xsl:element name="OBJECT">
  <xsl:attribute name="type">app/x-R-device</xsl:attribute>
  <xsl:for-each select="@*">
   <xsl:copy />
  </xsl:for-each>
  
 <xsl:apply-templates/>
 </xsl:element>
</xsl:template>

<!-- Callback for a form. -->
<xsl:template match="form/handler">
<!--
 <xsl:element name="OBJECT">
   <xsl:attribute name="hidden">true</xsl:attribute>
   <xsl:attribute name="type">R-form-callback"</xsl:attribute>
   <xsl:element name="param">
     <xsl:attribute name="name">init</xsl:attribute>
     <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
   </xsl:element>
  </xsl:element>
 <xsl:element name="input">
   <xsl:attribute name="type">hidden</xsl:attribute>
   <xsl:attribute name="name">R_callback</xsl:attribute>
   <xsl:attribute name="value"><xsl:value-of disable-output-escaping="yes" select="text()"/></xsl:attribute>
 </xsl:element>
 -->
</xsl:template>

<xsl:template match="form">
 <xsl:element name="form">
  <xsl:attribute name="ACTION"><xsl:value-of disable-output-escaping="yes" select="handler"/></xsl:attribute>
    <xsl:element name="OBJECT">
      <xsl:attribute name="type">R-form-environment</xsl:attribute>
      <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
      <xsl:element name="param">
       <xsl:attribute name="name">ACTION</xsl:attribute>
       <xsl:attribute name="value"><xsl:value-of disable-output-escaping="yes" select="handler"/></xsl:attribute>
      </xsl:element>
    </xsl:element>

    <xsl:element name="input">
      <xsl:attribute name="type">hidden</xsl:attribute>
      <xsl:attribute name="name">.formName</xsl:attribute>
      <xsl:attribute name="value"><xsl:value-of select="@name"/></xsl:attribute>
    </xsl:element>

  <xsl:if test="@environment!=''">
    <xsl:element name="OBJECT">
      <xsl:attribute name="type">R-push-environment</xsl:attribute>
      <xsl:attribute name="name"><xsl:value-of select="@environment"/></xsl:attribute>
    </xsl:element>
  </xsl:if>

  <xsl:for-each select="@*">
     <xsl:copy />
  </xsl:for-each>
  
  <xsl:apply-templates/>
 </xsl:element>
</xsl:template>

<xsl:template match="textentry">
  <xsl:element name="OBJECT">
   <xsl:attribute name="type">app/x-R-textentry</xsl:attribute>
   <xsl:for-each select="@*">
     <xsl:copy />
   </xsl:for-each>
   <xsl:for-each select="@*">
     <xsl:element name="param">
       <xsl:attribute name="name"><xsl:value-of select="name()"/></xsl:attribute>
       <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
     </xsl:element>
   </xsl:for-each>
  </xsl:element>

</xsl:template>

<xsl:template match="label">
  <xsl:element name="OBJECT">
   <xsl:attribute name="type">app/x-R-label</xsl:attribute>
   <xsl:for-each select="@*">
     <xsl:copy />
   </xsl:for-each>

   <xsl:element name="param">
    <xsl:attribute name="name">call</xsl:attribute>
    <xsl:attribute name="value">gtkLabel('<xsl:value-of select="text()"/>')</xsl:attribute>
   </xsl:element>
  </xsl:element>

   <xsl:for-each select="@*">
     <xsl:element name="param">
       <xsl:attribute name="name"><xsl:value-of select="name()"/></xsl:attribute>
       <xsl:attribute name="value"><xsl:value-of select="."/></xsl:attribute>
     </xsl:element>
   </xsl:for-each>

</xsl:template>

<xsl:template match="s:command">
  <xsl:element name="OBJECT">
   <xsl:attribute name="type">app/x-R-command</xsl:attribute>
   <xsl:for-each select="@*">
     <xsl:copy />
   </xsl:for-each>

   <xsl:element name="param">
    <xsl:attribute name="name">init</xsl:attribute>
    <xsl:attribute name="value"><xsl:value-of select="@value"/></xsl:attribute>
   </xsl:element>   
   </xsl:element>
</xsl:template>
</xsl:stylesheet>

