### Name: genSOAPClientInterface
### Title: Create R functions to access SOAP server methods
### Aliases: genSOAPClientInterface
### Keywords: interface programming

### ** Examples

 kegg = processWSDL("http://soap.genome.jp/KEGG.wsdl")
   # note that we force the use of the 1.1 name spaces to get arrays
   # handled correctly on the server side.
 iface = genSOAPClientInterface(def = kegg, nameSpaces = "1.1")

## Not run: 
##D     # This KEGG.wsdl is out of date
##D  tmp = processWSDL(system.file("examples", "KEGG.wsdl", package = "SSOAP"))
##D  iface = genSOAPClientInterface(tmp@operations[[1]], def = tmp, tmp@name, verbose=FALSE)
## End(Not run)

 setAs("Definition", "character",
         function(from) 
             structure(from@entry_id, names = from@definition))

 setAs("ArrayOfPathwayElement", "character", 
          function(from) sapply(from, as, "character"))

 o = iface@functions$list_organisms()

 as(o, "character")

 cat("See the file", system.file("examples", "KEGG.S", package = "SSOAP"), "for more examples\n")

     # Returns National Weather Service digital weather forecast data. 
  w = processWSDL("http://www.weather.gov/forecasts/xml/SOAP_server/ndfdXMLserver.php?wsdl")
  f = genSOAPClientInterface(,w)

    # For the next 5 days from now.
  str = f@functions$NDFDgenByDay(38.9936, -77.0224, Sys.time() + 60*24*60, 5, "12 hourly")

  xmlToList(xmlParse(str, asText = TRUE))

     # Note that the result is a string containing XML. The WSDL identifies the result
     # as an xsd:string and does not tell us about the structure of the contents.

     ##
     ## WABI
if(FALSE) {
     # This site was not available May 4th.
  w = processWSDL("http://xml.nig.ac.jp/wsdl/ARSA.wsdl")
  f = genSOAPClientInterface(,w )

  f@functions$searchSimple("Homo sapiens", 1, 100)
  x = f@functions$getENTRYbySPECIMEN("ATCC 43049", 1, 100)
  x = f@functions$getENTRYbyScientificName("Escherichia coli", 1, 400)
  els = readLines(textConnection(x))
     # get how many results are available in the database.
  totalCount = as.integer(substring(els[1], nchar("hitscount       = ")+1))
  hits = els[-1]  # the 400 results in the answer

  x = f@functions$searchByXMLPath("/ENTRY/DDBJ/accessions/accn='ab0001'", 
                                  "/ENTRY/DDBJ/primary-accession,/ENTRY/DDBJ/definition", 
                                  1, 100)
  els = unlist(strsplit(x, "\\n"))
  totalCount = as.integer(substring(els[1], nchar("hitscount       = ")+1))

  values = strsplit(els[-1], "\\t")
  ans = structure(sapply(values, `[`, 2), names = sapply(values, `[`, 1))
}



