### Name: combinations
### Title: Combinations of r items from n
### Aliases: combinations
### Keywords: math distribution htest

### ** Examples


 x = combinations(3, 2)

  # A more challenging one with choose(30, 4), 
  # i.e.  27405 combinations.
 x = combinations(30, 4)

## Not run: 
##D   # This is too big. We cannot return the elements as rows of a matrix
##D   # since there are choose(50, 10) (10,272,278,170) elements.
##D   # The matrix is limited to 2^31 - 1/ 8 elements.
##D    
##D  x = combinations(50, 10)
## End(Not run)

# To deal with large numbers of combinations, we can use a callback
# for each combination.
#  Suppose we have a population of size 10000

breaks = 
function(data, range = 3, n = 10,  by  = sigma/(n))
{
  mu = mean(data)
  sigma = range * sd(data)
  seq(mu - sigma, mu + sigma, by = by)
}

streamingHist = 
function(data, bins = breaks(data))
{
  counts <- integer(length(bins))

 list(handler = 
  function(x) {
     m = mean(data[as.logical(x)])
     i = which.max(m < bins)
     counts[i] <<- counts[i] + 1
     NULL  
  },
  counts = function() counts,
  bins = function() bins)
}

 z = rnorm(50)

 f = streamingHist(z)

 combinations(length(z), 4, f$handler)
 f$counts()
 f$bins()

# Same idea, but using CallbackFunction objects to avoid
# providing explicit accessors to the bins and counts "fields"

streamingHist = 
function(data, bins = breaks(data))
{
  counts <- integer(length(bins))

  new("CombinationGeneratorCallback", 
          function(x) {
             m = mean(data[as.logical(x)])
             i = which.max(m < bins)
             counts[i] <<- counts[i] + 1
             NULL  
          })
}

    # Now f is a function with a specialized class.
   f = streamingHist(z)

   combinations(length(z), 4, f)

   # Now we can access the mutable values "directly".
   f$counts
   f$bins



