### Name: permutations
### Title: Enumerate all possible permutations of n items
### Aliases: permutations
### Keywords: math distribution htest

### ** Examples


 permutations(3)  # 6
 permutations(7)  # 5040

 # Executing a simple function for each permutation.
 # The function takes the permutation of indices and
 # turns them into strings. It stores them globally !!!!!!
 # This is very bad, but simplifies the example.
 strings = character()
 permutations(3, function(perm) strings <<- c(strings, paste(perm, collapse = "")))

 unique(strings) == strings

 # Permutation test.

 permMean =
 function(x, y, breaks = seq(-1, 1, length = 100)) {

   counts = integer(length(breaks))

   f =
   function(perm) {
      els = c(x, y)[perm]
      x.prime = els[1:length(x)]
      y.prime = els[seq(length(x), length = length(y))]

      val = (mean(x.prime) - mean(y.prime))/sqrt(var(x.prime)/5 +  var(y.prime)/5)

      i = which.min(val > breaks)
      counts[i] <<- counts[i] + 1

      TRUE
   }

   new("CombinationGeneratorCallback", f)
 }

 # 2 samples of size 2. Small number since this is an example.
 x = rnorm(2, 1)
 y = rnorm(2, .5)
 h = permMean(x, y)

 permutations(length(x) + length(y), h)

 h$counts

 # Generate the permutations in a list so as to be able to
 # avoid holding all of them in a contiguous block of memory
 # in a matrix.

 gen =
 function(n) {
     # Allocate the list with as many elements as there are permutations.
   perms = vector("list", gamma(n + 1))
   ctr <- 1

   # A function that is called each time 
   op =
   function(perm) {
     perms[[ctr]] <<- perm
     ctr <<- ctr + 1
     TRUE
   }

   new("CombinationGeneratorCallback", op)
 }

 f = gen(4)
 permutations(4, f)
 f$perms
 



