### Name: getNameIDs
### Title: Compute the numeric identifiers for DCOM (method) names.
### Aliases: getNameIDs getNameIDs,FunctionDescription,ITypeInfo-method
###   getNameIDs,ITypeInfo,ANY-method getNameIDs,character,ITypeInfo-method
###   getNameIDs,character,COMIDispatch-method
###   getNameIDs,numeric,ITypeInfo-method
### Keywords: programming interface

### ** Examples

## Not run: 
##D 
##D      # FunctionInvokeDescription and an ITypeInfo.
##D    funcs = getFuncs(lib[["_Application"]])
##D    getNameIDs(funcs$Quit, lib[["_Application"]])
##D 
##D     # include parameters, although these will come back as 0, 1, ...
##D    getNameIDs(funcs$GetSaveAsFilename, lib[["_Application"]])
##D 
##D     # Instead of getting the FunctionInvokeDescription object first,
##D     # let getNameIDs do the work.  Works for arbitrary objects
##D     # in the ITypeInfo, not just FunctionInvokeDescription objects,
##D     # but property set and get methods, etc.
##D    getNameIDs("Quit", lib[["_Application"]])
##D 
##D     # Get the name mappings for all the elements of an ITypeInfo,
##D     # e.g. all functions all at once.
##D    getNameIDs(lib[["_Application"]])   
## End(Not run)



