### Name: getTypeDocumentation
### Title: Documentation for Type Element
### Aliases: getTypeDocumentation getTypeDocumentation,ITypeLib-method
###   getTypeDocumentation,ITypeInfo-method
### Keywords: programming

### ** Examples

if(file.exists("c:\\WINNT\\system32\\wmpui.dll")) {
  l = LoadTypeLib("c:\\WINNT\\system32\\wmpui.dll")

  getTypeDocumentation(l, 0)

  getTypeDocumentation(l, 14)

  m <- matrix("", length(l), 3)
  for(i in 1:length(l)) {
   m[i, ] <- getTypeDocumentation(l, i)
  }
  print(m)

  w = COMCreate("Word.Application", existing = TRUE)
  lib = LoadTypeLib(w)
  getTypeDocumentation(lib[["Documents"]], 0)
  getTypeDocumentation(lib[["Documents"]], 1)
  lib = NULL
}



