### Name: xmlFlatListTree
### Title: Constructors for trees stored as flat list of nodes with
###   information about parents and children.
### Aliases: xmlFlatListTree xmlHashTree
### Keywords: IO

### ** Examples

 f = system.file("exampleData", "dataframe.xml", package = "XML")
 tr  = xmlHashTree()
 xmlTreeParse(f, handlers = tr[[".addNode"]])

 tr # print the tree on the screen

  # Get the two child nodes of the dataframe node.
 xmlChildren(tr$dataframe)

  # Find the names of all the nodes.
 objects(tr)
  # Which nodes have children
 objects(tr$.children)

  # Which nodes are leaves, i.e. do not have children
 setdiff(objects(tr), objects(tr$.children))

  # find the class of each of these leaf nodes.
 sapply(setdiff(objects(tr), objects(tr$.children)),
         function(id) class(tr[[id]]))

  # distribution of number of children
 sapply(tr$.children, length)

  # Get the first A node
 tr$A

  # Get is parent node.
 xmlParent(tr$A)



