\name{addToHTMLTemplate}
\alias{addToHTMLTemplate}
\title{Add D3 JavaScript content to an HTML document}
\description{
  This function facilitates inserting D3 (JavaScript) code
  into an HTML document.
  The JavaScript code is typically
  generated by \code{\link{d3Device}} and the R graphics engine.
  The function also allows us to add additional supporting JavaScript code
  and CSS content.
}
\usage{
addToHTMLTemplate(code, outfile = character(),
                  supportCode = system.file("JavaScript", "Plot.js", package = "RD3Device"),
                  html = system.file("template", "template.html", package = "RD3Device"),
                  css = character(), div = "svg",
                  isFile = length(code) == 1 && file.exists(code))
}
\arguments{
  \item{code}{a character vector containing the JavaScript code or
    the name of a file containing the JavaScript code.}
  \item{outfile}{the name of the file to which the HTML document will be
  written. This is different from the template file.}
  \item{supportCode}{the names of one or more JavaScript files which
    should also be included in the HTML document. These are intended for
   supporting code that defines classes and functions used by the
   JavaScript D3 code to creat the display.}
  \item{html}{the name of the template HTML document which we fill in}
  \item{css}{the name of a CSS file or the actual contents of the CSS.
  If specified, the contents are inserted into the \code{head} of the
  HTML document.}
  \item{div}{the identifier (id) of the HTML element (typically a
    \code{div} ) in which the plot will be displayed. This is used to
    position the JavaScript code after this node.
  }
  \item{isFile}{a logical value that indicates whether \code{code} is
    the name of a file or the actual contents. This allows us to put the
  code in a file and then reference that file. This can be useful if we
  want to edit the JavaScript file separately.}
}
\value{
  If \code{out} is not empty, the name of the resulting file.
  If \code{out} is empty, the contents of the HTML document
  as a parsed tree.
}
%\references{}
\author{
Duncan Temple Lang
}

\seealso{
  \code{\link{d3Device}}
  \code{\link{d3Plot}}
}
\examples{
 dev = d3Device()
 with(mtcars, plot(wt, mpg))
 abline(fit <- lm(mpg ~ wt, mtcars), lty = 2, col = "red")
 dev.off()

 code = dev$getCode()
 cir =  names(code) == "circle" 
 code[cir] = mapply(function(code, id) {
             c(code, sprintf("el.append(\"svg:title\").text(\"\%s\");", id))
       }, code[cir], rownames(mtcars), SIMPLIFY = FALSE)

 addToHTMLTemplate(code, "mtcars.html")
}
\keyword{graphics}
\keyword{IO}
