\name{d3Device}
\alias{d3Device}
\alias{d3Plot}
\title{Create a graphics device to generate D3 code}
\description{
  \code{d3Device} creates a graphics device instance.
  All graphics commands sent to this device will generate
  JavaScript code that will render the plot when viewed in a Web
  browser.
  The JavaScript code uses D3 to render the graphical elements.

  \code{d3Plot} is a wrapper function that atomically
  creates a D3 device, evaluates the specified commands
  to generate a graphical display and then closes the device.
}
\usage{
d3Device(dim = c(800, 600), file = character(), svgVarName = "svg",
         div = "svg", plotVarName = sprintf("_\%s", svgVarName))
d3Plot(expr, file = character(), ...)
}
\arguments{
  \item{dim}{a vector of two numbers specifying the width and height of
  the graphics canvas.  The values are number of  pixels.}
  \item{file}{the file to which the D3 JavaScript code will be
  written. This can be omitted and one can retrieve the code after
  closing the device and then post-process it to, for example, add interactivity.}
  \item{svgVarName}{the name of the JavaScript variable to which the
  top-level D3 object for the plot is assigned. This is different from
  the plot object which maintains references to the different types of
  graphical elements.}
  \item{div}{the name of the HTML element in which D3 will add
  the SVG elements}
  \item{plotVarName}{the name of the JavaScript variable to which the
  plot object will be assigned. We can use this variable to add
  JavaScript code to
  process elements of the plot.}
\item{expr}{the R code to create the entire display}
\item{\dots}{additional arguments passed to \code{d3Device}}
}
%\details{}
\value{
  \code{d3Device} creates a new graphics device and makes it active.
  
  Both functions return a list with the following elements:
  \item{dev}{a reference to the C-level \code{DevDesc} object}
  \item{device}{a \code{RDevDescMethods} object which contains the
  functions used to implement the graphics primitives.}
  \item{getCode}{a function that returns the JavaScript code generated
  by the device}
  \item{getCalls}{a function that returns the R call stack for each
  object. This allows us to heuristically determine the purpose of each
  graphical element, e.g. a line created in a call to \code{axis}, or
  tex in a call to \code{legend}.}
  \item{getJSInfo}{a function that returns information about the generated
  JavaScript code, i.e. the names of the JavaScript variables
  (\code{svgVarName}, \code{plotVarName}, \code{divName})}

\code{getCode} and \code{getCalls} are functions that we call after
we have finished creating the graphical display.
These return information about the graphical elements that were
generated by the R graphics engine. The plot is not actually rendered
at this point in that the JavaScript code has not been evaluated.
That is done outside of R in a Web browser. However, these
functions return details about those graphical elements that will be
created in JavaScript.
}
\references{
R graphics devices, D3
}
\author{
Duncan Temple Lang
}

\seealso{
  \code{RGraphicsDevice} package

  \code{\link{addToHTMLTemplate}}
}
\examples{
dev = d3Device()
plot(1:10)
dev.off()
dev$getCode()
}
\keyword{graphics}
\keyword{IO}
