GenesByOldAnnotation = 
function(
`plasmo_annot_status` = 'Changed', `plasmo_new_product` = 'Don\'t care', `plasmo_new_model` = 'Don\'t care', `plasmo_new_go` = 'Don\'t care', `plasmo_new_ec` = 'Don\'t care', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByOldAnnotation.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByOldAnnotation.xml', .convert = NULL, .json = TRUE
)
{
     `plasmo_annot_status` <- checkValues(`plasmo_annot_status`, c("Changed", "New", "Unchanged"), 'plasmo_annot_status', TRUE)
     `plasmo_new_product` <- checkValues(`plasmo_new_product`, c("Yes", "No", "Don't care"), 'plasmo_new_product', FALSE)
     `plasmo_new_model` <- checkValues(`plasmo_new_model`, c("Yes", "No", "Don't care"), 'plasmo_new_model', FALSE)
     `plasmo_new_go` <- checkValues(`plasmo_new_go`, c("Yes", "No", "Don't care"), 'plasmo_new_go', FALSE)
     `plasmo_new_ec` <- checkValues(`plasmo_new_ec`, c("Yes", "No", "Don't care"), 'plasmo_new_ec', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight", "annot_status", "new_product_desc"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'plasmo_annot_status' = `plasmo_annot_status`,
                  'plasmo_new_product' = `plasmo_new_product`,
                  'plasmo_new_model' = `plasmo_new_model`,
                  'plasmo_new_go' = `plasmo_new_go`,
                  'plasmo_new_ec' = `plasmo_new_ec`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByLocation = 
function(
`organism` = 'Plasmodium falciparum', `chromosomeOptional` = 'Choose chromosome', `sequenceId` = 'NULL', `start_point` = '1', `end_point` = '0', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByLocation.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByLocation.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Cryptosporidium parvum", "Encephalitozoon cuniculi", "Encephalitozoon intestinalis", 
                      "Plasmodium berghei", "Plasmodium chabaudi", "Plasmodium knowlesi", 
                      "Plasmodium falciparum", "Plasmodium vivax", "Neospora caninum", 
                      "Toxoplasma gondii", "Leishmania mexicana", "Trypanosoma congolense", 
                      "Trypanosoma cruzi", "Leishmania major", "Trypanosoma vivax", 
                      "Leishmania infantum", "Trypanosoma brucei", "Leishmania braziliensis"
                      ), 'organism', FALSE)
     `chromosomeOptional` <- checkValues(`chromosomeOptional`, c("41", "40", "39", "38", "37", "36", "35", "34", "33", "32", 
                      "31", "30", "29", "28", "27", "26", "25", "24", "23", "22", "21", 
                      "2", "1", "chromosome 11", "chromosome 10", "chromosome 9", "XI", 
                      "X", "IX", "VIII", "VII", "VI", "V", "Choose chromosome", "chromosome 1", 
                      "chromosome 2", "chromosome 3", "chromosome 4", "chromosome 5", 
                      "chromosome 6", "chromosome 7", "chromosome 8", "I", "II", "III", 
                      "IV", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", 
                      "14", "un", "Ia", "Ib", "VIIb", "VIIa", "XII", "15", "16", "17", 
                      "18", "19", "20"), 'chromosomeOptional', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'chromosomeOptional' = `chromosomeOptional`,
                  'start_point' = `start_point`,
                  'end_point' = `end_point`
                )
    
    if(!missing(`sequenceId`))
       params[['sequenceId']] = `sequenceId`
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByGeneType = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Encephalitozoon cuniculi,Encephalitozoon intestinalis,Enterocytozoon bieneusi,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `includePseudogenes` = 'No', `geneType` = 'protein coding', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByGeneType.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByGeneType.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Encephalitozoon cuniculi", 
                      "Encephalitozoon intestinalis", "Enterocytozoon bieneusi", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trypanosoma cruzi", 
                      "Leishmania braziliensis", "Leishmania infantum", "Leishmania major", 
                      "Leishmania mexicana", "Trypanosoma brucei", "Trypanosoma congolense", 
                      "Trypanosoma vivax"), 'organism', TRUE)
     `includePseudogenes` <- checkValues(`includePseudogenes`, c("No", "Yes", "Pseudogenes Only"), 'includePseudogenes', FALSE)
     `geneType` <- checkValues(`geneType`, c("protein coding", "snRNA encoding", "tRNA encoding", "rRNA encoding", 
                      "misc RNA", "snoRNA encoding", "SRP RNA encoding", "RNase P RNA", 
                      "RNase MRP RNA", "repeat region", "scRNA encoding"), 'geneType', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'includePseudogenes' = `includePseudogenes`,
                  'geneType' = `geneType`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByPhenotype = 
function(
`organism` = 'Trypanosoma brucei TREU927', `phenotype` = 'intracellular protein transport,intracellular protein transportabnormal', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByPhenotype.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByPhenotype.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, "Trypanosoma brucei TREU927", 'organism', TRUE)
     `phenotype` <- checkValues(`phenotype`, c("excretionincreased", "intracellular protein transport", "methionyl-tRNA frmyltransferase activity", 
                      "mitochondrial DNA", "RNA editingnormal", "cytosol to ER transportnormal", 
                      "fluid-phase endocytosisnormal", "mitosisnormal", "proteasome assemblynormal", 
                      "polycistronic mRNA processing", "regulation of gene expression", 
                      "regulation of gene expression - epigenetic", "cytokinesisabnormal", 
                      "growth", "cell cycle", "cell morphogenesis", "mitochondrion organization and biogenesis", 
                      "cell morphogenesisnormal", "mitochondrion organization and biogenesisnormal", 
                      "golgi organization and biogenesis", "endocytosis", "regulation of cell motility", 
                      "regulation of cell motilitynormal", "golgi organization and biogenesisnormal", 
                      "endocytosisnormal", "growthnormal", "growthdecreased", "growthlethal", 
                      "cell cyclenormal", "cell cycleabnormal", "cell morphogenesisabnormal", 
                      "enzyme activity", "enzyme activityabsent", "proteosomal ubiquitin-dependent protein catabolic processabsent", 
                      "proteosomal ubiquitin-dependent protein catabolic process", 
                      "cell cyclearrested", "cell motilitydecreased", "cell motility", 
                      "RNA editing", "peptidase activity", "molecular function", "proteasome assembly", 
                      "endocytosisabnormal", "molecular functionabsent", "proteasome assemblydisrupted", 
                      "peptidase activitynormal", "golgi organization and biogenesisabnormal", 
                      "flagellum biogenesisabnormal", "mitochondrion organization and biogenesisabnormal", 
                      "peptidase activitydecreased", "cytokinesis", "flagellum biogenesis", 
                      "RNA splicing", "cytokinesisabsent", "cell movement", "RNA editingdecreased", 
                      "RNA editingabnormal", "RNA splicingabnormal", "cell movementabnormal", 
                      "cytosolic calcium ion homeostasisabnormal", "growthabnormal", 
                      "regulation of RNA stabilityabnormal", "regulation of cell motilityabnormal", 
                      "tRNA synthesisabnormal", "RNA editingabsent", "fluid-phase endocytosisabsent", 
                      "ribosome biogenesisabsent", "growtharrested", "carbon utilization", 
                      "cellular response to phosphate starvation", "cytosolic calcium ion homeostasis", 
                      "mRNA stabilizationdecreased", "fluid-phase endocytosis", "growthincreased", 
                      "cellular response to phosphate starvationincreased sensitivity", 
                      "mRNA stabilization", "mitosis", "regulation of RNA stability", 
                      "ribosome biogenesis", "tRNA synthesis", "chromosomeabnormal", 
                      "regulation of mitochondrial membrane potential", "developmental stageabnormal", 
                      "intracellular protein transportabnormal", "polycistronic mRNA processingabnormal", 
                      "regulation of gene expression - epigeneticabnormal", "regulation of gene expressionabnormal", 
                      "basal body duplicationabsent", "mitosisabsent", "regulation of mitochondrial membrane potentialabsent", 
                      "acidification", "basal body duplication", "cell differation", 
                      "chromosome", "cytosol to ER transport", "RNA splicingdecreased", 
                      "acidificationdecreased", "carbon utilizationdecreased", "endocytosisdecreased", 
                      "enzyme activitydecreased", "exocytosisdecreased", "methionyl-tRNA frmyltransferase activitydecreased", 
                      "mitochondrial DNAdecreased", "developmental stage", "growthdrug insensitive", 
                      "excretion", "exocytosis", "carbon utilizationincreased", "cell differationincreased", 
                      "enzyme activityincreased"), 'phenotype', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'phenotype' = `phenotype`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesWithUpdatedAnnotation = 
function(
`o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesWithUpdatedAnnotation.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesWithUpdatedAnnotation.xml', .convert = NULL, .json = TRUE
)
{
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
    
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByExonCount = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Encephalitozoon cuniculi,Encephalitozoon intestinalis,Enterocytozoon bieneusi,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `num_exons_gte` = '2', `num_exons_lte` = '20', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByExonCount.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByExonCount.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Encephalitozoon cuniculi", 
                      "Encephalitozoon intestinalis", "Enterocytozoon bieneusi", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trypanosoma cruzi", 
                      "Leishmania braziliensis", "Leishmania infantum", "Leishmania major", 
                      "Leishmania mexicana", "Trypanosoma brucei", "Trypanosoma congolense", 
                      "Trypanosoma vivax"), 'organism', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'num_exons_gte' = `num_exons_gte`,
                  'num_exons_lte' = `num_exons_lte`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByIsoelectricPoint = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Encephalitozoon cuniculi,Encephalitozoon intestinalis,Enterocytozoon bieneusi,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `min_isoelectric_point` = '6', `max_isoelectric_point` = '10', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByIsoelectricPoint.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByIsoelectricPoint.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Encephalitozoon cuniculi", 
                      "Encephalitozoon intestinalis", "Enterocytozoon bieneusi", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trypanosoma cruzi", 
                      "Leishmania braziliensis", "Leishmania infantum", "Leishmania major", 
                      "Leishmania mexicana", "Trypanosoma brucei", "Trypanosoma congolense", 
                      "Trypanosoma vivax"), 'organism', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'min_isoelectric_point' = `min_isoelectric_point`,
                  'max_isoelectric_point' = `max_isoelectric_point`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByMolecularWeight = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Encephalitozoon cuniculi,Encephalitozoon intestinalis,Enterocytozoon bieneusi,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `min_molecular_weight` = '10000', `max_molecular_weight` = '50000', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByMolecularWeight.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByMolecularWeight.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Encephalitozoon cuniculi", 
                      "Encephalitozoon intestinalis", "Enterocytozoon bieneusi", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trypanosoma cruzi", 
                      "Leishmania braziliensis", "Leishmania infantum", "Leishmania major", 
                      "Leishmania mexicana", "Trypanosoma brucei", "Trypanosoma congolense", 
                      "Trypanosoma vivax"), 'organism', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'min_molecular_weight' = `min_molecular_weight`,
                  'max_molecular_weight' = `max_molecular_weight`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesBySecondaryStructure = 
function(
`organism` = 'Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Giardia lamblia,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `min_coil` = '0', `max_coil` = '100', `min_strand` = '0', `max_strand` = '100', `min_helix` = '0', `max_helix` = '100', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesBySecondaryStructure.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesBySecondaryStructure.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Giardia lamblia", 
                      "Trichomonas vaginalis", "Trypanosoma cruzi", "Leishmania braziliensis", 
                      "Leishmania infantum", "Leishmania major", "Leishmania mexicana", 
                      "Trypanosoma brucei", "Trypanosoma congolense", "Trypanosoma vivax"
                      ), 'organism', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'min_coil' = `min_coil`,
                  'max_coil' = `max_coil`,
                  'min_strand' = `min_strand`,
                  'max_strand' = `max_strand`,
                  'min_helix' = `min_helix`,
                  'max_helix' = `max_helix`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByEcNumber = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Neospora caninum,Toxoplasma gondii,Trichomonas vaginalis,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma cruzi,Trypanosoma vivax', `ec_number_pattern` = '2.1.1.16', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByEcNumber.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByEcNumber.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Neospora caninum", 
                      "Toxoplasma gondii", "Trichomonas vaginalis", "Leishmania braziliensis", 
                      "Leishmania infantum", "Leishmania major", "Leishmania mexicana", 
                      "Trypanosoma brucei", "Trypanosoma congolense", "Trypanosoma cruzi", 
                      "Trypanosoma vivax"), 'organism', TRUE)
     `ec_number_pattern` <- checkValues(`ec_number_pattern`, "`GenesByEcNumber.ec_number_pattern.options`", 'ec_number_pattern', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'ec_number_pattern' = `ec_number_pattern`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

`GenesByEcNumber.ec_number_pattern.options` = 
  c("2.1.1.16", "1.2.7.1", "2.7.10.2", "6.2.1.13", "6.2.1.3", "6.2.1.26", 
                      "2.7.1.33", "1.6.1.2", "2.6.1.52", "3.4.24.84", "3.4.24.57", 
                      "3.4.24.36", "3.4.24.70", "6.5.1.1", "2.7.4.6", "2.7.6.1", "1.4.1.14", 
                      "1.4.1.1", "3.1.26.11", "2.7.7.22", "3.2.1.14", "3.4.11.4", "1.1.1.149", 
                      "2.7.11.14", "2.6.1.2", "2.6.1.16", "2.6.1.1", "3.1.1.23", "3.4.22.49", 
                      "4.3.1.12", "2.4.1.142", "2.4.1.119", "2.4.1.18", "3.3.1.1", 
                      "3.4.16.2", "3.4.11.2", "3.4.11.21", "3.4.11.9", "3.4.11.18", 
                      "3.4.22.38", "3.4.22.34", "3.4.22.53", "3.4.22.44", "3.4.22.50", 
                      "3.4.22.52", "3.4.22.15", "3.4.22.27", "2.7.1.23", "3.6.3.28", 
                      "3.6.3.1", "3.6.3.30", "3.6.3.31", "3.6.3.14", "3.6.3.8", "3.6.3.16", 
                      "3.6.3.43", "3.6.3.27", "3.6.3.15", "3.1.3.67", "6.3.2.19", "3.1.26.4", 
                      "3.4.22.16", "4.2.99.18", "3.1.1.29", "3.1.1.4", "3.1.1.47", 
                      "2.7.1.6", "2.8.3.16", "1.3.99.5", "2.7.1.24", "3.2.2.1", "3.2.1.10", 
                      "3.1.27.1", "3.2.1.33", "3.2.1.84", "3.2.1.17", "3.2.1.2", "3.2.1.52", 
                      "3.2.1.21", "3.2.1.143", "3.2.1.1", "3.2.1.135", "3.1.21.7", 
                      "3.1.3.71", "3.1.3.2", "3.1.3.36", "3.1.3.57", "3.1.3.25", "3.1.3.48", 
                      "3.1.3.16", "3.1.3.3", "3.1.3.62", "3.1.3.32", "3.4.25.1", "3.4.13.3", 
                      "3.4.13.9", "3.4.19.12", "3.4.19.1", "3.4.17.4", "3.4.14.2", 
                      "3.4.14.5", "3.4.14.4", "2.7.1.68", "2.7.7.14", "2.7.11.17", 
                      "2.1.1.125", "2.2.1.3", "1.8.1.9", "2.7.8.11", "2.3.1.30", "1.1.1.2", 
                      "3.6.4.3", "6.5.1.4", "2.7.7.50", "4.1.1.36", "2.7.2.10", "2.7.2.1", 
                      "2.7.2.3", "2.3.1.50", "2.7.12.1", "1.1.1.38", "1.12.7.2", "2.2.1.1", 
                      "2.7.7.7", "1.1.99.2", "1.1.1.14", "6.4.1.2", "6.3.1.2", "6.3.1.1", 
                      "6.3.1.5", "6.3.4.15", "6.3.2.5", "2.7.8.15", "1.1.1.1", "2.1.3.1", 
                      "4.1.99.1", "4.3.1.1", "1.15.1.1", "1.8.4.11", "1.11.1.15", "1.2.1.3", 
                      "1.2.1.12", "1.2.1.31", "1.5.1.2", "1.3.1.2", "1.2.1.10", "1.2.1.51", 
                      "2.7.1.67", "2.7.1.17", "1.1.1.26", "2.7.11.24", "2.3.1.79", 
                      "2.3.1.4", "2.7.11.7", "2.7.11.12", "2.7.11.25", "2.7.11.21", 
                      "2.7.11.13", "2.7.11.1", "2.7.11.23", "2.7.11.18", "2.7.11.11", 
                      "2.7.4.9", "4.2.1.46", "2.3.1.88", "2.3.1.18", "2.7.1.137", "4.1.2.27", 
                      "2.1.1.36", "4.1.2.13", "4.1.2.4", "2.7.1.48", "2.1.1.48", "2.7.4.21", 
                      "2.7.4.8", "2.7.4.3", "2.7.6.2", "1.1.1.37", "1.1.1.95", "1.1.1.62", 
                      "1.1.1.40", "1.1.1.290", "1.1.1.100", "2.7.8.1", "2.7.8.17", 
                      "4.1.1.18", "4.1.1.17", "4.3.1.19", "2.7.1.134", "2.7.7.1", "2.7.9.1", 
                      "2.3.1.43", "2.3.1.97", "2.1.1.100", "2.1.1.32", "2.1.1.31", 
                      "4.2.1.2", "4.2.1.9", "4.2.1.11", "2.7.7.25", "2.7.7.6", "2.7.7.3", 
                      "2.7.7.41", "2.7.7.19", "2.7.7.9", "2.7.10.1", "2.7.12.2", "2.7.1.20", 
                      "2.7.1.90", "2.7.1.144", "2.7.1.35", "2.7.1.11", "2.7.1.30", 
                      "2.7.1.4", "2.7.1.21", "1.11.1.9", "1.17.4.-", "1.17.4.2", "1.17.4.1", 
                      "1.2.4.2", "1.6.1.1", "1.6.4.5", "1.6.5.3", "1.6.99.3", "1.1.1.8", 
                      "1.1.1.219", "1.1.1.42", "1.1.1.94", "1.1.1.195", "1.1.1.35", 
                      "1.1.1.255", "1.1.1.205", "1.1.1.39", "1.6.2.4", "1.1.99.5", 
                      "1.1.99.1", "1.1.99.16", "1.1.1.178", "1.1.1.27", "1.4.3.6", 
                      "1.10.99.2", "2.5.1.10", "3.1.26.5", "2.1.2.1", "2.1.1.14", "2.1.1.114", 
                      "2.1.1.45", "2.1.1.37", "2.1.1.34", "2.1.1.43", "2.3.1.47", "2.3.1.48", 
                      "2.3.1.51", "2.3.3.1", "2.7.8.8", "3.1.27.-", "3.1.27.9", "2.7.8.5", 
                      "6.3.3.3", "3.4.21.53", "3.6.1.45", "3.6.5.1", "2.5.1.21", "3.4.11.1", 
                      "2.7.1.108", "2.7.1.123", "2.7.1.37", "3.1.3.12", "3.1.22.-", 
                      "3.4.14.11", "3.6.3.36", "3.6.3.6", "6.2.1.5", "6.2.1.1", "4.6.1.2", 
                      "3.6.5.3", "2.7.1.32", "3.4.21.105", "3.5.4.12", "3.2.2.21", 
                      "2.5.1.18", "2.5.1.1", "3.4.14.1", "4.1.2.10", "2.7.9.4", "2.5.1.31", 
                      "2.7.3.2", "4.6.1.1", "3.6.1.7", "3.4.23.1", "3.6.1.6", "3.6.1.13", 
                      "6.3.5.2", "3.2.1.141", "6.3.4.2", "6.3.4.1", "3.2.1.41", "3.2.1.3", 
                      "3.1.11.2", "2.7.13.3", "3.1.3.5", "3.1.3.56", "3.1.3.24", "3.1.3.23", 
                      "3.1.1.1", "3.1.1.3", "2.7.8.2", "4.4.1.-", "1.2.7.-", "1.11.1.-", 
                      "4.1.1.33", "6.3.2.-", "4.2.1.70", "4.3.1.17", "4.1.1.32", "3.1.11.-", 
                      "1.1.1.49", "2.4.1.11", "1.1.1.88", "1.1.1.44", "2.1.3.3", "2.7.1.40", 
                      "2.7.1.15", "2.7.1.82", "2.7.1.25", "2.7.1.31", "2.7.1.107", 
                      "2.7.1.150", "2.8.1.7", "5.4.99.15", "2.7.7.-", "2.7.1.-", "3.4.-.-", 
                      "3.4.99.-", "3.6.3.-", "3.4.22.-", "1.5.1.3", "2.6.1.62", "4.1.1.1", 
                      "4.1.1.35", "4.1.1.31", "4.1.1.65", "3.4.24.-", "2.5.1.-", "1.18.1.2", 
                      "3.4.21.-", "3.1.1.-", "2.7.8.-", "1.-.-.-", "3.-.-.-", "3.6.-.-", 
                      "3.6.1.11", "1.1.1.-", "4.2.1.-", "2.3.-.-", "2.3.1.-", "2.7.-.-", 
                      "5.-.-.-", "4.4.-.-", "2.7.11.-", "1.1.1.22", "2.1.1.64", "2.3.1.15", 
                      "1.12.1.-", "3.4.17.-", "3.4.17.2", "3.4.23.-", "3.4.24.59", 
                      "1.3.5.1", "3.4.24.56", "6.2.1.4", "1.2.1.41", "2.7.4.12", "2.7.7.15", 
                      "2.7.7.13", "2.7.7.49", "2.7.7.63", "2.7.7.23", "2.7.7.21", "2.7.7.56", 
                      "2.7.7.64", "2.7.7.27", "3.6.1.17", "1.1.3.13", "4.2.1.20", "3.6.4.9", 
                      "2.4.1.15", "2.4.1.130", "2.4.1.132", "2.4.1.36", "2.4.1.117", 
                      "2.4.1.242", "2.4.1.221", "2.4.1.141", "4.2.1.3", "4.2.1.32", 
                      "4.2.1.47", "6.1.1.17", "3.4.24.64", "2.7.2.11", "2.4.1.87", 
                      "2.4.1.41", "2.4.2.14", "2.4.2.9", "6.3.4.14", "5.1.3.-", "2.7.4.14", 
                      "2.3.1.20", "3.1.4.17", "1.8.1.4", "1.8.1.7", "3.4.23.34", "3.1.30.-", 
                      "3.1.4.11", "3.1.13.-", "3.6.3.4", "2.3.1.61", "1.14.11.2", "1.14.13.39", 
                      "5.1.3.7", "5.4.2.3", "5.3.1.8", "1.11.1.12", "3.6.4.-", "2.1.1.-", 
                      "3.2.2.-", "2.7.11.26", "3.6.1.-", "3.6.1.3", "3.1.-.-", "3.1.3.-", 
                      "3.6.1.22", "3.6.1.1", "3.6.1.5", "3.6.1.19", "3.6.1.43", "3.6.1.23", 
                      "2.7.1.1", "4.1.1.73", "3.6.4.6", "1.1.1.5", "2.4.1.-", "3.1.13.4", 
                      "3.1.13.1", "5.4.99.-", "1.3.1.-", "2.5.1.29", "2.5.1.46", "2.5.1.8", 
                      "2.5.1.60", "3.1.4.-", "1.16.1.5", "3.5.1.89", "3.2.1.20", "5.99.1.2", 
                      "5.99.1.3", "5.5.1.4", "5.3.1.26", "5.3.1.9", "5.3.1.1", "5.3.4.1", 
                      "5.3.3.2", "5.4.2.1", "5.4.2.8", "5.4.2.2", "5.4.99.12", "5.2.1.8", 
                      "5.1.3.3", "5.1.3.2", "5.1.3.1", "3.2.2.9", "2.4.1.21", "2.5.1.47", 
                      "4.4.1.11", "4.4.1.19", "4.4.1.1", "3.5.1.87", "2.5.1.6", "2.5.1.59", 
                      "2.5.1.58", "3.6.3.44", "2.7.7.4", "2.1.1.98", "2.3.1.28", "2.7.11.20", 
                      "1.1.1.102", "2.4.1.16", "6.1.1.15", "1.18.1.1", "3.5.4.6", "3.5.4.4", 
                      "3.5.4.3", "3.5.4.13", "2.6.1.42", "2.7.1.26", "2.1.1.33", "3.4.21.89", 
                      "3.1.4.46", "3.1.4.4", "2.4.1.1", "2.7.1.153", "6.1.1.18", "1.13.12.7", 
                      "2.4.2.1", "2.4.2.30", "2.4.2.11", "2.4.2.29", "2.4.1.83", "2.4.1.198", 
                      "2.4.1.25", "3.5.2.2", "3.5.99.6", "3.5.3.1", "3.5.1.16", "3.5.1.18", 
                      "6.1.1.22", "6.1.1.10", "6.1.1.7", "6.1.1.16", "6.1.1.6", "6.1.1.20", 
                      "6.1.1.4", "6.1.1.5", "6.1.1.12", "6.1.1.9", "6.1.1.14", "6.1.1.3", 
                      "6.1.1.1", "6.1.1.19", "6.1.1.11", "6.1.1.2", "6.1.1.21", "3.1.2.15", 
                      "1.1.1.21", "2.7.11.22", "2.1.1.56", "3.6.3.10", "2.3.1.9", "5.3.1.6", 
                      "3.1.2.6", "6.3.2.3", "6.3.2.2", "6.3.5.4", "6.3.5.1", "3.1.3.15", 
                      "3.1.3.18", "3.4.22.1", "3.2.2.16", "3.4.21.75", "3.4.24.71", 
                      "3.5.1.1", "3.5.3.6", "3.5.4.1", "3.5.4.5", "1.4.1.4", "2.7.1.36", 
                      "2.7.1.2", "2.3.3.10", "2.7.11.19", "2.7.2.2", "2.7.7.2", "2.8.1.1", 
                      "2.6.1.51", "3.4.23.39", "3.4.21.62", "3.4.21.92", "3.4.17.10", 
                      "3.4.22.68", "3.4.22.2", "1.6.4.2", "4.6.1.4", "1.3.3.3", "3.4.24.55", 
                      "3.4.24.16", "2.1.1.61", "3.6.1.47", "3.6.1.41", "3.6.1.29", 
                      "3.6.1.10", "3.6.1.34", "3.6.1.15", "3.6.4.8", "3.6.3.2", "3.5.2.3", 
                      "3.5.1.19", "3.5.1.31", "3.5.1.98", "3.5.1.88", "3.5.3.4", "3.5.4.9", 
                      "3.5.4.16", "3.4.13.19", "3.4.25.-", "3.4.23.38", "3.4.23.3", 
                      "1.1.1.36", "2.7.1.14", "2.7.1.148", "2.7.1.50", "2.7.1.151", 
                      "2.7.1.71", "2.7.1.49", "1.1.1.271", "4.1.1.49", "4.1.1.23", 
                      "4.1.1.37", "4.1.1.50", "4.3.2.2", "4.3.1.8", "1.14.19.1", "1.14.99.29", 
                      "1.14.99.3", "1.14.11.27", "1.14.11.4", "1.10.2.2", "1.8.3.2", 
                      "1.4.7.1", "2.1.1.66", "1.2.4.4", "2.1.1.29", "2.1.1.103", "2.1.1.35", 
                      "2.1.1.77", "2.1.1.62", "1.5.1.5", "1.5.1.7", "2.5.1.61", "2.5.1.16", 
                      "2.5.1.33", "2.5.1.3", "2.5.1.39", "2.5.1.11", "2.5.1.15", "2.5.1.30", 
                      "2.5.1.19", "1.6.2.2", "1.3.3.4", "1.3.3.1", "2.6.1.85", "2.6.1.57", 
                      "1.3.99.1", "1.7.1.1", "1.7.1.4", "1.7.1.3", "1.2.4.1", "1.3.1.9", 
                      "1.6.6.4", "1.18.1.-", "1.4.1.2", "1.4.3.5", "1.17.4.3", "4.4.1.21", 
                      "4.4.1.5", "4.1.3.37", "4.1.3.7", "4.1.3.38", "3.2.2.17", "3.7.1.-", 
                      "3.1.3.41", "1.9.3.1", "2.2.1.7", "3.1.3.4", "3.1.3.1", "3.1.3.33", 
                      "3.1.11.1", "3.1.21.-", "3.1.4.3", "3.1.4.1", "3.1.16.1", "3.1.2.4", 
                      "3.1.1.31", "3.1.1.5", "3.1.30.1", "4.6.1.12", "6.2.1.2", "5.1.3.8", 
                      "5.1.1.1", "2.3.2.5", "2.3.1.41", "2.3.1.168", "2.3.1.12", "2.3.1.39", 
                      "2.3.1.16", "2.3.1.37", "2.3.1.180", "2.3.1.1", "2.3.1.181", 
                      "2.3.1.24", "1.1.5.3", "2.6.1.13", "1.14.13.-", "3.5.4.-", "1.1.1.267", 
                      "4.1.3.-", "4.1.3.27", "2.3.1.85", "6.3.5.-", "4.2.1.96", "1.14.19.2", 
                      "1.2.1.-", "3.4.11.-", "2.4.2.10", "2.4.2.8", "2.4.1.80", "3.5.1.-", 
                      "6.3.4.4", "3.1.4.12", "2.3.2.6", "2.8.1.-", "3.6.1.50", "1.17.1.2", 
                      "1.4.1.-", "4.1.99.3", "4.4.1.17", "5.3.2.1", "1.11.1.5", "4.2.1.24", 
                      "4.2.1.1", "4.2.1.75", "2.1.2.9", "2.1.2.10", "2.7.4.10", "2.7.4.7", 
                      "2.1.3.2", "6.3.4.16", "6.3.5.7", "6.3.5.5", "6.3.2.22", "6.3.2.12", 
                      "6.3.2.17", "6.3.2.25", "4.2.1.17", "4.99.1.1", "2.7.7.18", "2.7.10.-", 
                      "2.7.6.3", "2.7.8.3", "2.7.8.27", "2.7.8.7", "2.8.1.8", "2.7.9.3", 
                      "2.7.7.60", "4.2.3.12", "4.2.3.5", "1.1.1.153", "1.1.1.157", 
                      "1.1.1.169", "1.1.1.18", "1.1.1.189", "1.1.1.197", "1.1.1.25", 
                      "1.1.1.274", "1.1.1.284", "1.1.1.31", "1.1.1.60", "1.1.1.87", 
                      "1.1.1.91", "1.1.4.1", "1.1.99.10", "1.11.1.6", "1.11.1.8", "1.13.12.3", 
                      "1.14.11.16", "1.14.13.20", "1.14.13.7", "1.14.14.1", "1.14.16.1", 
                      "1.14.16.2", "1.14.16.4", "1.16.1.8", "1.17.7.1", "1.18.1.3", 
                      "1.2.1.11", "1.2.1.24", "1.2.1.27", "1.2.1.8", "1.3.1.26", "1.3.1.33", 
                      "1.3.1.34", "1.3.1.38", "1.3.3.6", "1.3.99.10", "1.3.99.2", "1.3.99.22", 
                      "1.3.99.7", "1.4.3.22", "1.4.3.4", "1.5.1.-", "1.5.1.28", "1.5.1.34", 
                      "1.5.3.11", "1.5.5.1", "1.5.99.8", "1.6.3.1", "1.6.5.4", "1.6.5.5", 
                      "1.8.1.8", "1.8.3.1", "1.8.3.5", "1.8.4.12", "1.8.4.9", "2.1.1.10", 
                      "2.1.1.17", "2.1.1.41", "2.1.1.52", "2.1.2.11", "2.2.1.2", "2.3.1.161", 
                      "2.3.1.165", "2.3.1.176", "2.3.1.179", "2.3.1.23", "2.3.1.26", 
                      "2.3.1.31", "2.3.1.42", "2.3.1.94", "2.3.3.5", "2.3.3.8", "2.4.1.101", 
                      "2.4.1.173", "2.4.1.175", "2.4.1.186", "2.4.1.224", "2.4.1.227", 
                      "2.4.1.244", "2.4.1.34", "2.4.1.37", "2.4.1.67", "2.4.2.3", "2.4.2.31", 
                      "2.5.1.42", "2.5.1.54", "2.7.1.106", "2.7.1.149", "2.7.1.157", 
                      "2.7.1.158", "2.7.1.160", "2.7.1.39", "2.7.1.78", "2.7.11.2", 
                      "2.7.11.4", "2.7.2.4", "2.7.3.3", "2.7.4.24", "2.7.7.39", "2.7.7.48", 
                      "2.7.7.52", "2.7.7.8", "2.7.8.23", "2.7.9.5", "2.8.1.2", "3.1.1.7", 
                      "3.1.1.79", "3.1.11.5", "3.1.13.5", "3.1.21.2", "3.1.3.11", "3.1.3.13", 
                      "3.1.3.43", "3.1.3.7", "3.1.4.35", "3.1.4.45", "3.2.1.106", "3.2.1.22", 
                      "3.2.1.23", "3.2.1.39", "3.2.1.6", "3.2.1.60", "3.2.1.91", "3.4.13.20", 
                      "3.4.17.1", "3.4.17.3", "3.4.19.3", "3.4.19.9", "3.4.21.10", 
                      "3.4.21.101", "3.4.21.108", "3.4.21.22", "3.4.21.26", "3.4.21.27", 
                      "3.4.21.34", "3.4.21.48", "3.4.21.6", "3.4.21.66", "3.4.21.69", 
                      "3.4.21.7", "3.4.21.83", "3.4.21.84", "3.4.21.9", "3.4.22.43", 
                      "3.4.23.2", "3.4.23.45", "3.4.23.5", "3.4.24.11", "3.4.24.12", 
                      "3.4.24.14", "3.4.24.35", "3.4.24.81", "3.4.24.82", "3.4.24.85", 
                      "3.5.1.11", "3.5.1.28", "3.5.1.32", "3.5.1.53", "3.5.2.6", "3.6.3.20", 
                      "3.6.3.24", "3.6.3.25", "3.6.3.29", "3.6.3.3", "3.6.3.41", "3.6.3.42", 
                      "3.6.3.9", "4.1.1.19", "4.1.1.20", "4.1.1.48", "4.1.1.70", "4.1.1.86", 
                      "4.1.3.4", "4.2.1.10", "4.2.1.107", "4.2.1.18", "4.2.1.22", "4.2.1.52", 
                      "4.2.1.79", "4.2.3.1", "4.2.3.4", "4.3.3.2", "4.4.1.16", "5.3.1.23", 
                      "5.3.99.3", "5.4.2.10", "5.4.2.4", "6.1.1.-", "6.1.1.26", "6.2.1.16", 
                      "6.2.1.20", "6.3.-.-", "6.3.2.1", "6.3.3.2", "6.4.1.1", "6.4.1.3", 
                      "6.4.1.4", "6.5.1.2", "6.6.1.1", "6.6.1.2", "1.1.1.29", "1.1.1.133", 
                      "1.1.1.193", "1.1.1.204", "1.1.1.82", "4.1.3.3", "4.1.3.6", "2.7.4.2", 
                      "5.4.2.6", "1.13.11.32", "2.7.1.45", "1.12.1.2", "5.1.3.13", 
                      "2.5.1.17", "2.7.1.12", "2.6.1.5", "4.1.1.5", "4.1.1.15", "4.4.1.14", 
                      "1.2.3.1", "3.5.1.2", "1.2.1.13", "3.1.6.6", "3.2.1.26", "3.2.1.28", 
                      "3.2.1.4", "1.8.4.8", "1.3.99.16", "1.1.-.-", "1.1.1.103", "1.1.1.188", 
                      "1.1.1.19", "1.1.1.249", "1.1.1.3", "1.1.1.34", "1.1.3.21", "1.1.3.8", 
                      "1.11.1.11", "1.13.11.54", "1.14.-.-", "1.14.11.6", "1.14.13.1", 
                      "1.14.13.70", "1.14.13.72", "1.14.14.-", "1.14.99.-", "1.14.99.5", 
                      "1.14.99.7", "1.2.1.22", "1.2.3.-", "1.2.3.4", "1.20.4.1", "1.3.-.-", 
                      "1.3.1.6", "1.3.1.70", "1.3.1.71", "1.3.3.2", "1.3.99.-", "1.3.99.3", 
                      "1.4.1.3", "1.4.4.2", "1.5.1.12", "1.5.1.20", "1.5.1.33", "1.5.3.-", 
                      "1.6.5.-", "1.6.6.1", "1.6.99.13", "1.6.99.7", "1.7.1.7", "1.8.1.12", 
                      "1.8.4.6", "1.8.5.1", "2.1.1.13", "2.1.1.135", "2.1.1.73", "2.3.1.119", 
                      "2.3.1.158", "2.3.1.21", "2.3.1.29", "2.3.1.7", "2.4.1.13", "2.4.1.131", 
                      "2.4.1.14", "2.4.1.232", "2.4.2.-", "2.4.2.22", "2.4.2.6", "2.4.2.7", 
                      "2.5.1.26", "2.7.1.105", "2.7.1.129", "2.7.1.16", "2.7.1.29", 
                      "2.7.1.3", "2.7.1.52", "2.7.1.91", "2.7.1.99", "2.8.3.5", "3.1.1.17", 
                      "3.1.1.32", "3.1.1.69", "3.1.1.73", "3.1.26.3", "3.1.3.37", "3.1.3.46", 
                      "3.1.4.47", "3.2.1.-", "3.2.1.18", "3.2.1.8", "3.2.1.96", "3.2.2.3", 
                      "3.4.11.14", "3.4.15.-", "3.4.16.5", "3.4.17.19", "3.4.22.17", 
                      "3.4.22.5", "3.4.22.51", "3.4.24.15", "3.4.24.3", "3.4.24.6", 
                      "3.4.99.41", "3.5.1.14", "3.5.1.3", "3.5.1.78", "3.5.2.9", "3.5.3.11", 
                      "3.5.4.2", "3.5.5.1", "3.6.1.35", "3.6.1.42", "3.6.4.4", "3.7.1.3", 
                      "4.1.1.-", "4.1.1.25", "4.1.1.74", "4.1.1.9", "4.1.2.-", "4.2.1.109", 
                      "4.2.1.16", "4.4.1.7", "4.4.1.8", "4.6.1.14", "5.1.99.1", "5.3.3.5", 
                      "5.3.3.8", "5.4.2.9", "5.4.99.2", "5.4.99.8", "5.4.99.9", "6.-.-.-", 
                      "6.2.1.12", "6.3.1.8", "6.3.1.9", "6.3.4.3", "6.3.4.5", "6.4.-.-", 
                      "6.5.1.3")

GenesBySnps = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Encephalitozoon cuniculi,Encephalitozoon intestinalis,Enterocytozoon bieneusi,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `snp_strain_a` = 'Cp-IOWA II', `snp_strain_m` = 'Tg-VEG (type III)', `snp_stat` = 'All SNPs', `occurrences_lower` = '0', `occurrences_upper` = 'NULL', `dn_ds_ratio_lower` = '0', `dn_ds_ratio_upper` = 'NULL', `snp_density_lower` = '0', `snp_density_upper` = 'NULL', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesBySnps.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesBySnps.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Encephalitozoon cuniculi", 
                      "Encephalitozoon intestinalis", "Enterocytozoon bieneusi", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trypanosoma cruzi", 
                      "Leishmania braziliensis", "Leishmania infantum", "Leishmania major", 
                      "Leishmania mexicana", "Trypanosoma brucei", "Trypanosoma congolense", 
                      "Trypanosoma vivax"), 'organism', TRUE)
     `snp_strain_a` <- checkValues(`snp_strain_a`, c("Cp-IOWA II", "Cp-TU114", "Cp-MD", "Pf-3D7", "P. reichenowi (vs. 3D7 only)", 
                      "Pf-HB3", "Pf-GHANA1", "Pf-V1_S", "Pf-Dd2", "Pf-7G8", "Pf-RO-33", 
                      "Pf-D10", "Pf-K1", "Pf-D6", "Pf-FCC-2", "Pf-Senegal3404", "Pf-IT", 
                      "Pf-SantaLucia", "Pf-FCB", "Pf-FCR3", "Pf-106_1", "Pf-Senegal3504", 
                      "Pf-Senegal3101", "Pf-Senegal5102", "Pf-Malayan", "Tg-ME49 (type II)", 
                      "Tg-VEG (type III)", "Tg-GT1 (type I)", "Tg-RH (type I)", "TgCkUg2"
                      ), 'snp_strain_a', FALSE)
     `snp_strain_m` <- checkValues(`snp_strain_m`, c("Cp-IOWA II", "Cp-TU114", "Cp-MD", "Pf-3D7", "P. reichenowi (vs. 3D7 only)", 
                      "Pf-HB3", "Pf-GHANA1", "Pf-V1_S", "Pf-Dd2", "Pf-7G8", "Pf-RO-33", 
                      "Pf-D10", "Pf-K1", "Pf-D6", "Pf-FCC-2", "Pf-Senegal3404", "Pf-IT", 
                      "Pf-SantaLucia", "Pf-FCB", "Pf-FCR3", "Pf-106_1", "Pf-Senegal3504", 
                      "Pf-Senegal3101", "Pf-Senegal5102", "Pf-Malayan", "Tg-ME49 (type II)", 
                      "Tg-VEG (type III)", "Tg-GT1 (type I)", "Tg-RH (type I)", "TgCkUg2"
                      ), 'snp_strain_m', FALSE)
     `snp_stat` <- checkValues(`snp_stat`, c("All SNPs", "Coding", "Non-Coding", "Non-Synonymous", "Nonsense", 
                      "Synonymous"), 'snp_stat', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight", "total_snps", "cds_snp_density", "dn_ds_ratio", 
                      "num_synonymous", "num_non_synonymous", "num_nonsense", "num_noncoding"
                      ), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'snp_strain_a' = `snp_strain_a`,
                  'snp_strain_m' = `snp_strain_m`,
                  'snp_stat' = `snp_stat`,
                  'occurrences_lower' = `occurrences_lower`,
                  'dn_ds_ratio_lower' = `dn_ds_ratio_lower`,
                  'snp_density_lower' = `snp_density_lower`
                )
    
    if(!missing(`occurrences_upper`))
       params[['occurrences_upper']] = `occurrences_upper`
    if(!missing(`dn_ds_ratio_upper`))
       params[['dn_ds_ratio_upper']] = `dn_ds_ratio_upper`
    if(!missing(`snp_density_upper`))
       params[['snp_density_upper']] = `snp_density_upper`
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByMassSpec = 
function(
`ms_assay` = 'false', `min_sequence_count` = '1', `min_spectrum_count` = '1', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByMassSpec.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByMassSpec.xml', .convert = NULL, .json = TRUE
)
{
     `ms_assay` <- checkValues(`ms_assay`, c("Ehistolytica", "Phagosome Proteomics data from Huston - 0 mins", 
                      "Phagosome Proteomics data from Huston - 5 mins", "Phagosome Proteomics data from Huston - 10 mins", 
                      "Phagosome Proteomics data from Huston - 30 mins", "Phagosome Proteomics data from Huston - 60 mins", 
                      "Cparvum", "Wastling MassSpec 1D Gel LC-MS/MS", "Wastling MassSpec 2D Gel LC-MS/MS", 
                      "Wastling MassSpec MudPit Soluble", "Wastling MassSpec MudPit Insoluble", 
                      "Lowery MassSpec LC-MS/MS Insoluble Excysted Fraction", "Lowery MassSpec LC-MS/MS Insoluble Non-excysted fraction", 
                      "Lowery MassSpec LC-MS/MS Soluble Excysted and Non-excysted fractions", 
                      "Fiser_Proteomics_14Aug2006_1D_gel", "Fiser_Proteomics_16May2006_1D_gel", 
                      "Fiser_Proteomics_24Jun2006_1D_gel", "Ferrari_Proteomics_LTQ_Oocyst_walls", 
                      "Ferrari_Proteomics_LTQ_intact_oocysts_merged", "Ferrari_Proteomics_LTQ_Sporozoites merged", 
                      "C. parvum mass spec data from Lorenza Putignani", "Pfalciparum", 
                      "Pberghei", "Pvivax", "Pyoelii", "Merozoite", "Trophozoite", 
                      "Gametocyte", "Sporozoite", "Shahid Khan Merozoite Peptides", 
                      "Mosquito Oocyst Peptides", "Mosquito Oocyst-derived Sporozoite Peptides", 
                      "Mosquito Salivary Gland Sporozoite Peptides", "iRBC Membrane", 
                      "P.falciparum Clinical Proteomics", "Pfalciparum_Bowyer_Proteomics_42hrs_Post_Infection", 
                      "Pfalciparum_Bowyer_Proteomics_48hrs_Post_Infection", "Waters Female Gametes", 
                      "Waters Male Gametes", "Waters Mixed  Gametes", "Clinical Proteomics", 
                      "Pf_Lasonder_Proteomics_Blood_Stages_trophozoites_RSRC", "Pf_Lasonder_Proteomics_Blood_Stages_early_gametocytes_RSRC", 
                      "Pf_Lasonder_Proteomics_Blood_Stages_late_gametocytes_RSRC", 
                      "Liver Stage LS40", "Liver Stage LS50", "Tvaginalis", "Hayes-Johnson_Tvag_Proteomics", 
                      "Tgondii", "Wastling 1-D SDS PAGE", "Wastling 1-D SDS PAGE Soluble", 
                      "Wastling 1-D SDS PAGE Insoluble", "Wastling MudPIT Soluble", 
                      "Wastling MudPIT Insoluble", "Wastling Rhoptry", "Wastling Murray Conoid-enriched Fraction", 
                      "Wastling Murray Conoid-depleted Fraction", "1D Gel Tachyzoite Membrane fraction 12-2006", 
                      "1D Gel Tachyzoite Membrane fraction 10-2006", "2DLC MS/MS Tachyzoite Membrane fraction", 
                      "MS Tachyzoite Cytosolic Protein Fractions 05-2007", "MS Tachyzoite Membrane fraction 05-02-2006", 
                      "MS Tachyzoite Membrane fraction 06-2006", "MS Tachyzoite Membrane fraction 05-10-2006", 
                      "MS Tachyzoite Membrane fraction 02-03-2006", "MS Tachyzoite Membrane Protein with  Biotinlyation Purification 05-22-2007", 
                      "MS Carruthers 2destinct peptides", "MS Carruthers MudPIT Twinscan hits", 
                      "RH Mass Spec Data (sample A)", "RH Mass Spec Data (sample G)", 
                      "Glamblia", "DTASelect-filter_032108_Proteomics", "Giardia proteomics data from Tachezy lab", 
                      "Tcruzi", "Esmeraldo-like", "Non-Esmeraldo-like", "Tcruzi Esmeraldo-like Proteomics-Amastigote", 
                      "Tcruzi Non-Esmeraldo-like Proteomics-Amastigote", "Tcruzi Esmeraldo-like Proteomics-Epimastigote", 
                      "Tcruzi Non-Esmeraldo-like Proteomics-Epimastigote", "Tcruzi Esmeraldo-like Proteomics-Metacyclic", 
                      "Tcruzi Non-Esmeraldo-like Proteomics-Metacyclic", "Tcruzi Esmeraldo-like Proteomics-Trypomastigote", 
                      "Tcruzi Non-Esmeraldo-like Proteomics-Trypomastigote", "Tcruzi Esmeraldo-like reservosomes-B1 fraction digested with trypsin and endoproteinase Glu-C", 
                      "Tcruzi NonEsmeraldo-like reservosomes-B1 fraction digested with trypsin and endoproteinase Glu-C", 
                      "Tcruzi Esmeraldo-like reservosomes-B1 fraction digested with trypsin", 
                      "Tcruzi Non-Esmeraldo-like reservosomes-B1 fraction digested with trypsin", 
                      "Tcruzi Esmeraldo-like reservosomes-B1M fraction digested with trypsin", 
                      "Tcruzi Non-Esmeraldo-like reservosomes-B1M fraction digested with trypsin", 
                      "Tcruzi Esmeraldo-like Proteomics-Membrane Protein", "Tcruzi Non-Esmeraldo-like Proteomics-Membrane Protein", 
                      "Tbrucei", "Tbrucei Proteomics Procyclic Form", "Tbrucei Proteomics Bloodstream Form Cytosolic Phosphoproteome", 
                      "Linfantum", "Amastigote", "Promastigote", "ptl", "Linfantum Proteomics PTM-glycosylation", 
                      "Linfantum Proteomics PTM-acetylation", "Linfantum Proteomics PTM-methylation", 
                      "Linfantum Proteomics PTM-phosphorylation", "Linfantum Proteomics SDS Amastigote", 
                      "Linfantum Proteomics 2DGel 6-9 Amastigote", "Linfantum Proteomics 2DGel 6-11 Amastigote", 
                      "Linfantum Proteomics 2DGel 6-9 Promastigote", "Linfantum Proteomics 2DGel 6-11 Promastigote", 
                      "Linfantum Proteomics data from Marc Ouellette", "Linfantum Proteomics Promastigote temperature and pH non-stressed", 
                      "Linfantum Proteomics Promastigote temperature and pH stressed", 
                      "Linfantum Proteomics Amastigote Secreted Protein", "Linfantum Proteomics Promastigote Secreted Protein", 
                      "Lmajor", "L.major Proteomics-Exosomes", "Lbraziliensis", "L. braziliensis Promastigote (secreted)"
                      ), 'ms_assay', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight", "sum_sequence_count", "sum_spectrum_count"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'ms_assay' = `ms_assay`,
                  'min_sequence_count' = `min_sequence_count`,
                  'min_spectrum_count' = `min_spectrum_count`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesWithEpitopes = 
function(
`organism` = 'Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma cruzi,Trypanosoma vivax', `epitope_confidence` = 'High,Medium', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesWithEpitopes.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesWithEpitopes.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Leishmania braziliensis", "Leishmania infantum", 
                      "Leishmania major", "Leishmania mexicana", "Trypanosoma brucei", 
                      "Trypanosoma congolense", "Trypanosoma cruzi", "Trypanosoma vivax"
                      ), 'organism', TRUE)
     `epitope_confidence` <- checkValues(`epitope_confidence`, c("High", "Medium", "Low"), 'epitope_confidence', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight", "count", "confidence"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'epitope_confidence' = `epitope_confidence`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesBySimilarity = 
function(
`BlastDatabaseType` = 'Transcripts', `BlastAlgorithm` = 'blastn', `BlastDatabaseOrganism` = 'Entamoeba histolytica HM-1:IMSS', `BlastQuerySequence`, `-e` = '10', `-v` = '50', `-b` = '50', `-filter` = 'yes', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesBySimilarity.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesBySimilarity.xml', .convert = NULL, .json = TRUE
)
{
     `BlastDatabaseType` <- checkValues(`BlastDatabaseType`, c("Transcripts", "Proteins", "Genome", "ORF", "EST", "Assemblies", 
                      "Isolates", "Genome Survey Sequences"), 'BlastDatabaseType', FALSE)
     `BlastAlgorithm` <- checkValues(`BlastAlgorithm`, c("blastn", "blastp", "blastx", "tblastn", "tblastx"), 'BlastAlgorithm', FALSE)
     `BlastDatabaseOrganism` <- checkValues(`BlastDatabaseOrganism`, c("Entamoeba histolytica HM-1:IMSS", "Entamoeba dispar SAW760", 
                      "Entamoeba invadens IP1", "Encephalitozoon intestinalis", "Encephalitozoon cuniculi GB-M1", 
                      "Enterocytozoon bieneusi H348", "Leishmania major", "Leishmania infantum", 
                      "Leishmania braziliensis", "Trypanosoma brucei gambiense", "Trypanosoma brucei Lister strain 427", 
                      "Trypanosoma brucei TREU927", "Trypanosoma cruzi CL Brener Esmeraldo-like", 
                      "Trypanosoma cruzi CL Brener Non-Esmeraldo-like", "Trypanosoma cruzi unassigned contigs (strain CL Brener)", 
                      "Trypanosoma congolense", "Trypanosoma vivax", "Leishmania mexicana", 
                      "Cryptosporidium parvum", "Cryptosporidium parvum Chr6", "Cryptosporidium hominis", 
                      "Cryptosporidium muris", "Plasmodium berghei", "Plasmodium chabaudi", 
                      "Plasmodium falciparum", "Plasmodium falciparum mitochondrial", 
                      "Plasmodium falciparum plastid", "Plasmodium falciparum (new)", 
                      "Plasmodium knowlesi", "Plasmodium vivax", "Plasmodium vivax mitochondrial", 
                      "Plasmodium yoelii", "Toxoplasma gondii", "Toxoplasma gondii apicoplast", 
                      "Neospora caninum", "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Giardia Assemblage A isolate WB (deprecated)", 
                      "Trichomonas vaginalis", "Trichomonas vaginalis (Repeated Genes)"
                      ), 'BlastDatabaseOrganism', TRUE)
     `-filter` <- checkValues(`-filter`, c("yes", "no"), '-filter', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'BlastDatabaseType' = `BlastDatabaseType`,
                  'BlastAlgorithm' = `BlastAlgorithm`,
                  'BlastDatabaseOrganism' = `BlastDatabaseOrganism`,
                  'BlastQuerySequence' = `BlastQuerySequence`,
                  '-e' = `-e`,
                  '-v' = `-v`,
                  '-b' = `-b`,
                  '-filter' = `-filter`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByMotifSearch = 
function(
`motif_organism` = 'Entamoeba histolytica HM-1:IMSS', `motif_expression` = 'CC6+RK', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByMotifSearch.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByMotifSearch.xml', .convert = NULL, .json = TRUE
)
{
     `motif_organism` <- checkValues(`motif_organism`, c("Entamoeba histolytica HM-1:IMSS", "Entamoeba dispar SAW760", 
                      "Entamoeba invadens IP1", "Encephalitozoon intestinalis", "Encephalitozoon cuniculi GB-M1", 
                      "Enterocytozoon bieneusi H348", "Cryptosporidium parvum", "Cryptosporidium hominis", 
                      "Cryptosporidium muris", "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Giardia Assemblage A isolate WB (deprecated)", 
                      "Plasmodium falciparum", "Plasmodium falciparum mitochondrial", 
                      "Plasmodium falciparum plastid", "Plasmodium vivax", "Plasmodium vivax mitochondrial", 
                      "Plasmodium yoelii", "Plasmodium berghei", "Plasmodium chabaudi", 
                      "Plasmodium knowlesi", "Toxoplasma gondii", "Toxoplasma gondii Apicoplast", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trichomonas vaginalis (repeated genes)", 
                      "Trypanosoma cruzi CL Brener Esmeraldo-like", "Trypanosoma cruzi CL Brener Non-Esmeraldo-like", 
                      "Trypanosoma cruzi unassigned contigs (strain CL Brener)", "Trypanosoma brucei Lister strain 427", 
                      "Trypanosoma brucei TREU927", "Trypanosoma brucei gambiense", 
                      "Leishmania major", "Leishmania infantum", "Leishmania braziliensis", 
                      "Trypanosoma congolense", "Trypanosoma vivax", "Leishmania mexicana"
                      ), 'motif_organism', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight", "Locations", "MatchCount"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'motif_organism' = `motif_organism`,
                  'motif_expression' = `motif_expression`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

GenesByInterproDomain = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Encephalitozoon cuniculi,Encephalitozoon intestinalis,Enterocytozoon bieneusi,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `domain_database` = 'Choose one:', `domain_accession`, `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByInterproDomain.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByInterproDomain.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Encephalitozoon cuniculi", 
                      "Encephalitozoon intestinalis", "Enterocytozoon bieneusi", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trypanosoma cruzi", 
                      "Leishmania braziliensis", "Leishmania infantum", "Leishmania major", 
                      "Leishmania mexicana", "Trypanosoma brucei", "Trypanosoma congolense", 
                      "Trypanosoma vivax"), 'organism', TRUE)
     `domain_database` <- checkValues(`domain_database`, c("Choose one:", "INTERPRO", "PFAM", "PIR", "PRINTS", "PRODOM", 
                      "PROFILE", "SMART", "SUPERFAMILY", "TIGRFAMs"), 'domain_database', FALSE)
     `domain_accession` <- checkValues(`domain_accession`, "`GenesByInterproDomain.domain_accession.options`", 'domain_accession', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight", "e_value"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'domain_database' = `domain_database`,
                  'domain_accession' = `domain_accession`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

`GenesByInterproDomain.domain_accession.options` = 
  c("PF02607 : B12-binding_2", "PF06508 : ExsB", "SSF52540 : 0050274", 
                      "SSF103196 : 0050164", "SSF54001 : 0036389", "TIGR01813 : flavo_cyto_c", 
                      "SSF47203 : 0039700", "PF03345 : DDOST_48kD", "PIRSF000390 :", 
                      "SSF57302 : 0048210", "PF08221 : HTH_9", "PD214295 :", "PF05773 : RWD", 
                      "SSF52788 : 0039517", "PF00892 : DUF6", "SSF51735 : 0038342", 
                      "SSF48452 : 0047256", "SSF46609 : 0051207", "SSF51971 : 0047141", 
                      "PF04433 : SWIRM", "SSF51445 : 0043114", "SSF109604 : 0043677", 
                      "SSF46785 : 0051033", "SSF55298 : 0041942", "SSF48600 : 0051272", 
                      "SSF51011 : 0041134", "SSF111283 : 0050267", "PF07648 : Kazal_2", 
                      "SSF57196 : 0039777", "SSF50156 : 0048900", "SSF51556 : 0039388", 
                      "SSF52833 : 0041805", "SSF47113 : 0037410", "SSF55298 : 0052530", 
                      "SSF50630 : 0045590", "PF03143 : GTP_EFTU_D3", "SSF52374 : 0048499", 
                      "SSF52317 : 0034974", "SSF55681 : 0041426", "SSF53927 : 0051891", 
                      "PF02171 : Piwi", "SSF55008 : 0049356", "SSF53335 : 0052649", 
                      "SSF52218 : 0036656", "SSF51197 : 0041601", "SSF54452 : 0039499", 
                      "SSF48034 : 0038818", "SSF47473 : 0053359", "PF01393 : Chromo_shadow", 
                      "PS50280 : SET", "SSF64307 : 0039494", "SSF50044 : 0046906", 
                      "SSF57059 : 0047245", "SSF46915 : 0050564", "SSF48726 : 0045272", 
                      "SSF54534 : 0037500", "SSF55424 : 0038450", "PF01272 : GreA_GreB", 
                      "SSF50331 : 0042069", "PIRSF016214 :", "SSF51735 : 0039696", 
                      "SSF52833 : 0041391", "SSF53850 : 0044963", "SSF54277 : 0044702", 
                      "SSF48150 : 0041996", "SSF52540 : 0040983", "SSF52799 : 0040439", 
                      "SSF81342 : 0042666", "SSF48613 : 0048277", "SSF49785 : 0044563", 
                      "PD004823 :", "SSF57581 : 0040247", "SSF55874 : 0035110", "TIGR00598 : rad14", 
                      "SSF57196 : 0040564", "SSF50156 : 0040294", "SSF81660 : 0042598", 
                      "PF04177 : TAP42", "PS50297 : ANK_REP_REGION", "SSF51735 : 0042448", 
                      "SSF46458 : 0037761", "SSF57802 : 0050321", "SSF54001 : 0037347", 
                      "SSF55811 : 0051716", "SSF53448 : 0050178", "SSF49899 : 0034853", 
                      "TIGR01746 : Thioester-redct", "SSF54197 : 0051524", "SSF50249 : 0046163", 
                      "SSF53756 : 0047375", "SSF47240 : 0047148", "SSF51735 : 0048863", 
                      "SSF49562 : 0043303", "SSF46785 : 0052506", "SSF69118 : 0040162", 
                      "PD009612 :", "SSF55550 : 0036143", "SSF57016 : 0042204", "SSF53850 : 0037186", 
                      "SSF49695 : 0038409", "SSF56436 : 0049081", "SSF52402 : 0043769", 
                      "SSF69118 : 0051758", "SSF51338 : 0038138", "SSF82549 : 0044459", 
                      "SSF55979 : 0035383", "SSF52540 : 0037230", "SSF52540 : 0037898", 
                      "SSF53613 : 0041662", "SSF55060 : 0037596", "SSF50729 : 0042934", 
                      "SSF54928 : 0049416", "SSF54768 : 0050561", "SSF46785 : 0049777", 
                      "PF03060 : NPD", "SSF69618 : 0050436", "SSF51294 : 0048160", 
                      "SSF46626 : 0035869", "SSF57802 : 0045637", "PR00723 : SUBTILISIN", 
                      "PF02588 : DUF161", "PF09542 : FFD_TFG", "SSF49695 : 0051406", 
                      "SSF101690 : 0043117", "SSF51366 : 0048767", "SSF55729 : 0040637", 
                      "PF06628 : Catalase-rel", "SSF55486 : 0045495", "SSF49854 : 0041548", 
                      "SSF55347 : 0037521", "SSF49329 : 0047610", "SSF53955 : 0035984", 
                      "SSF110217 : 0044113", "SSF46785 : 0038615", "SSF48113 : 0043632", 
                      "PF00658 : PABP", "SSF54826 : 0048743", "SSF47014 : 0045263", 
                      "PF02170 : PAZ", "SSF56235 : 0043435", "SSF52540 : 0042152", 
                      "SSF48208 : 0038939", "PF00686 : CBM_20", "SSF50814 : 0036878", 
                      "SSF54826 : 0043386", "PD001141 :", "SSF53850 : 0050155", "SSF54762 : 0036839", 
                      "SSF48613 : 0050457", "PF08385 : DHC_N1", "SSF53850 : 0042247", 
                      "PD082580 :", "TIGR01146 : ATPsyn_F1gamma", "SSF48726 : 0052419", 
                      "SSF54695 : 0038738", "SSF57424 : 0035070", "SSF50494 : 0038297", 
                      "SSF46966 : 0053304", "SSF51338 : 0052788", "PD000511 :", "SSF57424 : 0039420", 
                      "SSF47473 : 0040528", "SSF54928 : 0049492", "SSF50494 : 0038419", 
                      "SSF51219 : 0035888", "SSF56235 : 0043430", "SSF51621 : 0047660", 
                      "SSF54236 : 0050086", "SSF53167 : 0035892", "PR00765 : CRBOXYPTASEA", 
                      "SSF52833 : 0035499", "TIGR01957 : nuoB_fam", "SSF56784 : 0047938", 
                      "SSF50370 : 0043031", "SSF52151 : 0042071", "PF08623 : TIP120", 
                      "SSF53187 : 0048989", "PF01571 : GCV_T", "PD006662 :", "TIGR02794 : tolA_full", 
                      "SSF52540 : 0035527", "SSF46689 : 0050538", "PF05638 : DUF796", 
                      "SSF50494 : 0040318", "SSF51294 : 0035189", "SSF49562 : 0038166", 
                      "SSF56849 : 0036485", "PF08826 : DMPK_coil", "SSF54211 : 0050714", 
                      "PF08540 : HMG_CoA_synt_C", "SSF51735 : 0040467", "TIGR02685 : pter_reduc_Leis", 
                      "SSF81296 : 0046558", "SSF56645 : 0039177", "SSF46689 : 0037381", 
                      "SSF46894 : 0034798", "SSF48537 : 0045784", "SSF46626 : 0048246", 
                      "SSF47473 : 0053194", "SSF48726 : 0043532", "PF04046 : PSP", 
                      "SSF57829 : 0037554", "PF00808 : CBFD_NFYB_HMF", "SSF51182 : 0043585", 
                      "SSF51430 : 0049299", "SSF52540 : 0039443", "SSF51735 : 0040473", 
                      "SSF63380 : 0037676", "PS50192 : T_SNARE", "SSF47836 : 0035436", 
                      "SSF57716 : 0052408", "SSF55174 : 0037616", "SSF49265 : 0050832", 
                      "SSF56300 : 0043761", "TIGR02967 : guan_deamin", "SSF47113 : 0038404", 
                      "SSF48613 : 0049145", "SSF48726 : 0035931", "SSF51905 : 0042336", 
                      "SSF48113 : 0039188", "PR00869 : DNAPOLX", "PF08616 : SPB_interacting", 
                      "SSF48726 : 0041024", "PF03643 : Vps26", "PF01406 : tRNA-synt_1e", 
                      "SSF52833 : 0037710", "SSF55961 : 0052916", "PF06519 : TolA", 
                      "SSF50891 : 0045227", "SSF56327 : 0041777", "PF09138 : Urm1", 
                      "SSF81496 : 0037292", "SSF53383 : 0045572", "SSF57667 : 0045152", 
                      "SSF50494 : 0049863", "SSF49899 : 0040107", "SSF56784 : 0049302", 
                      "TIGR02487 : NrdD", "PR01874 : DNAREPAIRADA", "SSF47364 : 0043059", 
                      "PD008735 :", "SSF88659 : 0049340", "SSF57889 : 0036774", "SSF48695 : 0052348", 
                      "SSF49695 : 0046581", "PF04061 : ORMDL", "SSF49899 : 0050333", 
                      "SSF53067 : 0050050", "SSF53335 : 0042442", "SSF57440 : 0040397", 
                      "SSF57059 : 0041418", "TIGR01464 : hemE", "SSF51366 : 0052672", 
                      "SSF50249 : 0041282", "PF00430 : ATP-synt_B", "SSF51695 : 0043910", 
                      "SSF52540 : 0046551", "SSF47986 : 0041209", "SSF89837 : 0040909", 
                      "SSF49503 : 0037557", "PF00732 : GMC_oxred_N", "PS50972 : PTERIN_BINDING", 
                      "PIRSF015947 :", "SSF49265 : 0044308", "PF02185 : HR1", "SSF53738 : 0039873", 
                      "SSF47220 : 0049465", "SSF47661 : 0038698", "SSF64182 : 0039146", 
                      "SSF51717 : 0035001", "SSF54593 : 0047830", "PR00078 : G3PDHDRGNASE", 
                      "SSF88697 : 0052541", "SSF46785 : 0045923", "SSF46689 : 0049590", 
                      "SSF53850 : 0052374", "SSF49503 : 0049364", "SSF49265 : 0041236", 
                      "SSF47769 : 0049390", "SSF51735 : 0045379", "SSF47973 : 0038733", 
                      "SSF47413 : 0049284", "SSF55008 : 0045832", "SSF57184 : 0048303", 
                      "PIRSF016396 :", "SSF57196 : 0044576", "SSF50044 : 0041374", 
                      "SSF56059 : 0035215", "SSF49265 : 0039414", "SSF55785 : 0046377", 
                      "SSF48552 : 0039402", "SSF63411 : 0052684", "PF01205 : UPF0029", 
                      "SSF55331 : 0038579", "SSF46626 : 0036186", "SSF48619 : 0043502", 
                      "SSF51905 : 0036654", "PF00202 : Aminotran_3", "SSF54862 : 0043631", 
                      "PF09295 : ChAPs", "SSF53597 : 0049139", "PF07714 : Pkinase_Tyr", 
                      "SSF55846 : 0043642", "SSF56436 : 0048999", "SSF57302 : 0037142", 
                      "SSF53756 : 0049238", "SSF53271 : 0046155", "SSF46458 : 0041985", 
                      "SSF48019 : 0043789", "SSF51658 : 0042983", "SSF53187 : 0048537", 
                      "SSF51161 : 0047244", "SSF52218 : 0049640", "SSF69189 : 0038543", 
                      "PF08160 : NUC156", "SSF54913 : 0049936", "SSF89957 : 0048048", 
                      "SSF55545 : 0041493", "PF02130 : UPF0054", "SSF49417 : 0047380", 
                      "PIRSF037010 :", "PR00305 : 1433ZETA", "PF08318 : COG4", "SSF52499 : 0045018", 
                      "PF10243 : MIP-T3", "SSF56371 : 0043118", "SSF81585 : 0049285", 
                      "SSF46689 : 0049236", "TIGR01511 : ATPase-IB1_Cu", "SSF55979 : 0043900", 
                      "SSF51011 : 0035427", "PF00930 : DPPIV_N", "PIRSF000525 :", "SSF54686 : 0039572", 
                      "SSF75625 : 0041114", "SSF81296 : 0041715", "SSF53448 : 0039815", 
                      "PF00053 : Laminin_EGF", "TIGR00486 : TIGR00486", "SSF51177 : 0048118", 
                      "PF03437 : BtpA", "SSF53098 : 0048444", "PF00237 : Ribosomal_L22", 
                      "SSF50891 : 0045440", "SSF54236 : 0036953", "SSF51294 : 0040944", 
                      "SSF51735 : 0048673", "SSF63411 : 0035488", "SSF51569 : 0041152", 
                      "SSF54452 : 0050009", "SSF57190 : 0047390", "SSF47954 : 0038275", 
                      "SSF51445 : 0040296", "SSF51445 : 0043812", "SSF48403 : 0047365", 
                      "SSF56601 : 0041527", "PR01590 : HTHFIS", "SSF55620 : 0035418", 
                      "PF01645 : Glu_synthase", "SSF54292 : 0039725", "SSF54897 : 0042250", 
                      "SSF47473 : 0036977", "SSF53756 : 0052623", "SSF50129 : 0040183", 
                      "SSF53927 : 0053055", "PF07728 : AAA_5", "SSF55550 : 0045979", 
                      "PR00689 : ACOABINDINGP", "SSF81483 : 0042910", "SSF54001 : 0041295", 
                      "SSF55811 : 0050134", "SSF89733 : 0041611", "PF02874 : ATP-synt_ab_N", 
                      "SSF56436 : 0043955", "SSF81665 : 0043765", "SSF81296 : 0046127", 
                      "SSF51905 : 0049003", "SSF56003 : 0049206", "SSF54452 : 0035808", 
                      "SSF48034 : 0050308", "PF08243 : SPT2", "SSF54736 : 0040877", 
                      "SSF52833 : 0045754", "SSF56935 : 0045370", "SSF46785 : 0035306", 
                      "PF01968 : Hydantoinase_A", "SSF51905 : 0044413", "SSF54495 : 0047527", 
                      "SSF48403 : 0049962", "PF00231 : ATP-synt", "SSF54403 : 0038004", 
                      "SSF55021 : 0052682", "SSF54427 : 0049321", "SSF56112 : 0039603", 
                      "SSF75217 : 0039116", "SSF54001 : 0052048", "SSF48425 : 0035447", 
                      "SSF56854 : 0051392", "SSF52172 : 0051386", "SSF48726 : 0035999", 
                      "SSF56672 : 0047189", "PF00536 : SAM_1", "PS50076 : DNAJ_2", 
                      "SSF63748 : 0041864", "SSF46984 : 0037967", "SSF56281 : 0040757", 
                      "SSF52833 : 0051595", "SSF49899 : 0046260", "PF00156 : Pribosyltran", 
                      "SSF57362 : 0035576", "SSF53098 : 0051402", "SSF48726 : 0034991", 
                      "SSF53613 : 0040500", "SSF48097 : 0041925", "SSF54637 : 0048790", 
                      "SSF47353 : 0042960", "SSF50370 : 0040164", "SSF81923 : 0040095", 
                      "SSF52540 : 0043468", "SSF54631 : 0053224", "SSF56059 : 0053122", 
                      "SSF49265 : 0049877", "PIRSF000111 :", "SSF48726 : 0045839", 
                      "SSF101386 : 0041843", "SSF56219 : 0044964", "SSF56601 : 0037741", 
                      "SSF50729 : 0036336", "PF01751 : Toprim", "SSF55920 : 0035987", 
                      "PF02205 : WH2", "SSF51569 : 0051699", "SSF57424 : 0040464", 
                      "SSF53901 : 0038812", "PIRSF000858 :", "SSF52935 : 0040514", 
                      "SSF46689 : 0035052", "TIGR01393 : lepA", "SSF54452 : 0038554", 
                      "SSF50978 : 0047761", "SSF57362 : 0035577", "SSF55486 : 0039343", 
                      "SSF57095 : 0048299", "SSF55945 : 0035928", "SSF51735 : 0052873", 
                      "SSF55035 : 0042688", "SSF51445 : 0048565", "PR00149 : FUMRATELYASE", 
                      "SSF50182 : 0040203", "SSF55781 : 0049595", "SSF54593 : 0037338", 
                      "SSF51735 : 0044959", "SSF50203 : 0046623", "SSF56784 : 0040401", 
                      "PF01636 : APH", "SSF54211 : 0040129", "SSF48726 : 0048005", 
                      "SSF50084 : 0035675", "SSF48350 : 0037426", "SSF54826 : 0039691", 
                      "PF04424 : DUF544", "PF05834 : Lycopene_cycl", "SSF51045 : 0041717", 
                      "SSF50156 : 0044315", "SSF47655 : 0035511", "PF06071 : DUF933", 
                      "SSF53474 : 0048945", "SSF52467 : 0036433", "PD012151 :", "SSF48557 : 0038817", 
                      "SSF53335 : 0047303", "SSF47031 : 0051790", "PF08015 : Pheromone", 
                      "SSF55785 : 0037219", "SSF57196 : 0038126", "SSF51206 : 0048512", 
                      "SSF53850 : 0040650", "SSF82919 : 0048068", "SSF54001 : 0051256", 
                      "PIRSF000121 :", "SSF54928 : 0036312", "SSF57262 : 0046312", 
                      "SSF57059 : 0043311", "SSF56059 : 0045315", "SSF55811 : 0044768", 
                      "SSF46626 : 0046190", "PF10155 : DUF2363", "SSF50814 : 0049349", 
                      "SSF51445 : 0045960", "PF04950 : DUF663", "SSF54593 : 0035781", 
                      "SSF50692 : 0042709", "SSF53187 : 0051389", "SSF63570 : 0039536", 
                      "SSF52540 : 0049606", "SSF54928 : 0037834", "SSF56003 : 0046330", 
                      "SSF50494 : 0042293", "PF02773 : S-AdoMet_synt_C", "SSF51645 : 0048297", 
                      "SSF47082 : 0038025", "SSF53098 : 0041096", "SSF51182 : 0044379", 
                      "SSF88723 : 0043995", "SSF51445 : 0036924", "SSF53474 : 0046221", 
                      "PD135356 :", "PF10382 : DUF2439", "SSF52540 : 0041531", "SSF51556 : 0038139", 
                      "SSF48508 : 0042191", "PF09334 : tRNA-synt_1g", "SSF52540 : 0047988", 
                      "SSF51445 : 0038607", "SSF48019 : 0043795", "SSF52540 : 0050677", 
                      "SSF81296 : 0039553", "SSF46934 : 0048193", "PR00776 : HEMOGLOBNASE", 
                      "SSF47203 : 0050326", "SSF47266 : 0037217", "SSF55486 : 0039943", 
                      "SSF100895 : 0038364", "SSF50156 : 0050572", "SSF49503 : 0045417", 
                      "PD005242 :", "TIGR00290 : MJ0570_dom", "SSF55021 : 0051577", 
                      "SSF49265 : 0052266", "SSF52949 : 0040436", "SSF51366 : 0034879", 
                      "SSF53955 : 0041358", "PIRSF000349 :", "SSF46894 : 0042937", 
                      "SSF57184 : 0048301", "SSF52058 : 0046297", "SSF51713 : 0042466", 
                      "SSF52788 : 0047572", "SSF57440 : 0036026", "SSF50353 : 0049267", 
                      "SSF88688 : 0047239", "PF00350 : Dynamin_N", "SSF51695 : 0045427", 
                      "PF08920 : SF3b1", "SSF53901 : 0049718", "SSF48619 : 0036043", 
                      "PD001491 :", "SSF88645 : 0035876", "SSF50494 : 0034812", "SSF50939 : 0039096", 
                      "PF03651 : Psf1", "SSF57059 : 0051186", "PF02845 : CUE", "SSF53697 : 0044783", 
                      "TIGR02097 : yccV", "SSF88633 : 0035181", "SSF49785 : 0050331", 
                      "SSF57756 : 0041308", "PR01483 : FASYNTHASE", "PF01399 : PCI", 
                      "SSF57440 : 0045618", "PF03798 : TRAM_LAG1_CLN8", "PF02731 : SKIP_SNW", 
                      "SSF52540 : 0036121", "SSF53597 : 0039349", "SSF53271 : 0051301", 
                      "PD042585 :", "SSF63748 : 0050627", "SSF48034 : 0036127", "SSF51735 : 0044606", 
                      "SSF50998 : 0038411", "SSF49503 : 0039064", "SSF52833 : 0039618", 
                      "SSF46934 : 0050610", "PF00752 : XPG_N", "SSF54631 : 0039485", 
                      "SSF49785 : 0044564", "PS51112 : AMMECR1", "SSF54637 : 0050275", 
                      "SSF48371 : 0038656", "SSF55486 : 0053382", "SSF47240 : 0051609", 
                      "PF00395 : SLH", "PD000039 :", "SSF47323 : 0039227", "SSF57095 : 0041218", 
                      "PF03403 : PAF-AH_p_II", "SSF75001 : 0039704", "SSF52317 : 0038840", 
                      "SSF53756 : 0034950", "SSF57716 : 0052317", "SSF53774 : 0045006", 
                      "SSF46689 : 0047358", "SSF46596 : 0045703", "SSF88633 : 0044052", 
                      "SSF56425 : 0042899", "SSF81343 : 0041346", "SSF52121 : 0036434", 
                      "SSF53697 : 0040766", "PIRSF006392 :", "SSF56634 : 0034869", 
                      "SSF51011 : 0039217", "PS50042 : CNMP_BINDING_3", "SSF47699 : 0038707", 
                      "PF00393 : 6PGD", "SSF56634 : 0035960", "SSF52467 : 0051269", 
                      "SSF49785 : 0044431", "SSF54236 : 0050460", "SSF46458 : 0035399", 
                      "SSF56574 : 0040612", "SSF46626 : 0038594", "PF00708 : Acylphosphatase", 
                      "SSF48726 : 0045941", "SSF52980 : 0035965", "PS50801 : STAS", 
                      "SSF54197 : 0044846", "PIRSF037240 :", "SSF57095 : 0039607", 
                      "SSF52540 : 0035392", "SSF88688 : 0038721", "PF03764 : EFG_IV", 
                      "SSF46689 : 0052177", "PF02815 : MIR", "SSF54160 : 0046932", 
                      "SSF75005 : 0047083", "SSF52440 : 0047321", "SSF49899 : 0035072", 
                      "SSF52540 : 0049266", "PR00332 : HISTRIAD", "PF06144 : DNA_pol3_delta", 
                      "TIGR00004 : TIGR00004", "TIGR01496 : DHPS", "SSF63748 : 0052883", 
                      "SSF53850 : 0045790", "SSF47789 : 0046189", "SSF55120 : 0051811", 
                      "PF10273 : WGG", "SSF57190 : 0048007", "SSF51735 : 0035810", 
                      "PF00204 : DNA_gyraseB", "SSF54919 : 0051862", "SSF46626 : 0037178", 
                      "PS51311 : SCGB", "SSF47616 : 0044592", "PF04111 : APG6", "SSF55909 : 0043408", 
                      "PF06012 : DUF908", "PS50145 : ZF_TRAF", "SSF53659 : 0049813", 
                      "SSF50249 : 0036142", "SSF52540 : 0037666", "SSF57630 : 0042111", 
                      "SSF53850 : 0038704", "SSF51283 : 0050315", "SSF56854 : 0041652", 
                      "PIRSF006588 :", "PR00873 : MTECHINOIDEA", "SSF51351 : 0045083", 
                      "SSF82649 : 0050511", "SSF48498 : 0052799", "PD018365 :", "SSF53067 : 0048592", 
                      "SSF52540 : 0044231", "SSF55957 : 0039876", "PF00201 : UDPGT", 
                      "PIRSF037016 :", "SSF48619 : 0049341", "SSF52129 : 0036168", 
                      "SSF50729 : 0043611", "SSF56327 : 0040995", "SSF54001 : 0037580", 
                      "SSF57095 : 0053171", "PR01576 : PDEFORMYLASE", "SSF55729 : 0036058", 
                      "SSF57667 : 0043688", "SSF51445 : 0047217", "SSF52540 : 0039800", 
                      "SSF51735 : 0046592", "SSF53098 : 0041565", "PF00503 : G-alpha", 
                      "SSF101912 : 0049402", "SSF48726 : 0045512", "PS50235 : UCH_2_3", 
                      "PD003859 :", "PF00241 : Cofilin_ADF", "SSF52540 : 0035281", 
                      "PF00762 : Ferrochelatase", "SSF50249 : 0048170", "SSF51735 : 0048469", 
                      "SSF56235 : 0042627", "SSF49785 : 0050025", "SSF54197 : 0037605", 
                      "SSF52768 : 0035837", "PF00896 : Mtap_PNP", "SSF57256 : 0044288", 
                      "SSF56574 : 0042850", "SSF57277 : 0046902", "SSF48619 : 0038198", 
                      "SSF54909 : 0044129", "SSF103032 : 0042479", "SSF53167 : 0051743", 
                      "PS50949 : HTH_GNTR", "SSF55307 : 0050372", "SSF56534 : 0040662", 
                      "SSF49503 : 0039214", "SSF51322 : 0041164", "SSF57095 : 0038851", 
                      "SSF102405 : 0050464", "SSF50118 : 0048062", "PF07766 : LETM1", 
                      "SSF47794 : 0043875", "SSF52540 : 0041412", "SSF56672 : 0042977", 
                      "SSF49584 : 0042996", "SSF49503 : 0040277", "SSF54966 : 0049483", 
                      "PF08785 : Ku_PK_bind", "TIGR01028 : S7_S5_E_A", "SSF47473 : 0048828", 
                      "SSF54285 : 0043398", "SSF52440 : 0045887", "SSF54427 : 0049938", 
                      "SSF46934 : 0047355", "SSF47095 : 0044636", "SSF51735 : 0048533", 
                      "SSF53383 : 0042809", "SSF54913 : 0048679", "SSF52374 : 0039122", 
                      "PF05017 : TMP", "SSF50156 : 0049781", "SSF51735 : 0051965", 
                      "SSF81524 : 0035457", "PF07162 : B9", "SSF51569 : 0041245", "SSF48592 : 0049413", 
                      "PF07646 : Kelch_2", "SSF63411 : 0035485", "SSF51735 : 0042429", 
                      "TIGR01999 : iscU", "SSF55811 : 0041097", "SSF50729 : 0036997", 
                      "PF08238 : Sel1", "SSF49265 : 0046132", "SSF51735 : 0052329", 
                      "PD014419 :", "SSF51445 : 0048314", "SSF52518 : 0045858", "SSF51445 : 0046607", 
                      "SSF51621 : 0039703", "SSF52096 : 0051040", "SSF49854 : 0043701", 
                      "SSF52833 : 0047050", "SSF55307 : 0037765", "SSF48726 : 0036570", 
                      "SSF55811 : 0039172", "SSF55486 : 0043847", "SSF102462 : 0043300", 
                      "SSF46458 : 0036099", "SSF53597 : 0051896", "SSF50729 : 0053042", 
                      "TIGR01599 : PYST-A", "SSF47616 : 0035533", "SSF54452 : 0045513", 
                      "PIRSF000166 :", "PD000779 :", "SSF56918 : 0040337", "SSF47836 : 0049585", 
                      "SSF55753 : 0041507", "SSF50156 : 0042117", "SSF81296 : 0047603", 
                      "PF08105 : Antimicrobial10", "SSF54236 : 0053295", "SSF49265 : 0037379", 
                      "SSF46458 : 0051062", "SSF51905 : 0038448", "SSF49562 : 0049161", 
                      "PF06201 : DUF1000", "PF08576 : DUF1764", "SSF56601 : 0047476", 
                      "SSF47413 : 0051844", "SSF81483 : 0036660", "SSF56534 : 0040999", 
                      "SSF55874 : 0038146", "SSF51730 : 0044671", "SSF51569 : 0042895", 
                      "TIGR00344 : alaS", "SSF52058 : 0040812", "SSF51366 : 0042332", 
                      "SSF57667 : 0045110", "PF08132 : AdoMetDC_leader", "SSF55729 : 0042589", 
                      "PF07709 : SRR", "SSF64356 : 0038303", "SSF53271 : 0052113", 
                      "SSF49354 : 0042995", "SSF46458 : 0035091", "PD149576 :", "SSF56420 : 0043314", 
                      "SSF57184 : 0040814", "PF02785 : Biotin_carb_C", "PF07393 : Sec10", 
                      "SSF47226 : 0044088", "SSF111278 : 0044041", "SSF47762 : 0037889", 
                      "SSF52540 : 0052548", "SSF55770 : 0046791", "SSF48726 : 0037210", 
                      "SSF81442 : 0041780", "SSF57027 : 0047152", "PIRSF007828 :", 
                      "SSF56784 : 0048300", "SSF47895 : 0051552", "SSF53748 : 0040047", 
                      "SSF52540 : 0043974", "SSF51445 : 0046023", "SSF48256 : 0041736", 
                      "SSF57302 : 0041559", "TIGR01772 : MDH_euk_gproteo", "SSF51445 : 0049050", 
                      "SSF55961 : 0049515", "SSF52283 : 0050091", "SSF52799 : 0042113", 
                      "PS01180 : CUB", "SSF53850 : 0052509", "SSF57362 : 0037040", 
                      "PF06602 : Myotub-related", "PD416840 :", "SSF57262 : 0036383", 
                      "SSF56436 : 0047796", "SSF51735 : 0042342", "SSF51246 : 0050165", 
                      "PF03931 : Skp1_POZ", "SSF49562 : 0043238", "SSF53955 : 0047673", 
                      "SSF55469 : 0053102", "SSF57302 : 0035927", "SSF56112 : 0038941", 
                      "SSF52540 : 0041442", "SSF56371 : 0038757", "SSF103647 : 0044556", 
                      "PF02736 : Myosin_N", "SSF53383 : 0046087", "SSF50814 : 0041814", 
                      "SSF88659 : 0049651", "SSF50475 : 0050360", "SSF55550 : 0034982", 
                      "SSF48439 : 0046296", "SSF51045 : 0044034", "SSF53901 : 0039354", 
                      "TIGR03263 : guanyl_kin", "SSF57095 : 0044353", "SSF50249 : 0049870", 
                      "SSF52540 : 0038431", "SSF52218 : 0042957", "PIRSF037755 :", 
                      "SSF51556 : 0048115", "SSF56672 : 0039569", "SSF52799 : 0045087", 
                      "SSF82919 : 0040746", "SSF49749 : 0040771", "SSF54928 : 0044336", 
                      "SSF51735 : 0051213", "PS50012 : RCC1_3", "PS51265 : ZF_DBF4", 
                      "PF05994 : FragX_IP", "SSF47266 : 0043309", "PF00654 : Voltage_CLC", 
                      "SSF56091 : 0037798", "SSF52833 : 0048298", "SSF56672 : 0040062", 
                      "SSF48264 : 0042621", "SSF54928 : 0038621", "SSF54211 : 0052932", 
                      "SSF56436 : 0049565", "PF01642 : MM_CoA_mutase", "SSF51735 : 0045873", 
                      "SSF53807 : 0051121", "SSF56399 : 0038116", "SSF54452 : 0038348", 
                      "PF01650 : Peptidase_C13", "SSF69318 : 0047693", "PF01761 : DHQ_synthase", 
                      "SSF57783 : 0051787", "SSF54292 : 0045911", "PF07106 : TBPIP", 
                      "PD025321 :", "SSF53756 : 0043364", "PF02852 : Pyr_redox_dim", 
                      "SSF75445 : 0044390", "PF10145 : PhageMin_Tail", "PIRSF000216 :", 
                      "SSF54913 : 0050169", "SSF46785 : 0051849", "SSF52540 : 0048852", 
                      "PF04926 : PAP_RNA-bind", "PF02747 : PCNA_C", "SSF57783 : 0038877", 
                      "SSF102860 : 0044882", "SSF54556 : 0039656", "SSF54358 : 0053109", 
                      "PF04680 : OGFr_III", "SSF54001 : 0036163", "SSF88633 : 0036091", 
                      "SSF47345 : 0038315", "SSF52540 : 0043986", "SSF51430 : 0047069", 
                      "SSF55031 : 0044745", "SSF52540 : 0041174", "PF08795 : DUF1796", 
                      "SSF51735 : 0044808", "SSF51726 : 0044189", "SSF47769 : 0042066", 
                      "SSF52540 : 0042791", "PF01459 : Porin_3", "SSF54117 : 0037022", 
                      "SSF56601 : 0048305", "SSF54897 : 0049437", "PIRSF000137 :", 
                      "SSF57667 : 0045250", "SSF51197 : 0042812", "SSF51230 : 0042816", 
                      "SSF57783 : 0047306", "SSF51445 : 0052139", "SSF46689 : 0039749", 
                      "SSF52490 : 0037764", "PD004900 :", "SSF52467 : 0040861", "SSF47769 : 0042054", 
                      "SSF56496 : 0039477", "PF00149 : Metallophos", "PIRSF005290 :", 
                      "SSF49899 : 0048032", "TIGR00560 : pgsA", "SSF55874 : 0046033", 
                      "SSF50324 : 0044287", "TIGR01557 : myb_SHAQKYF", "SSF57059 : 0047288", 
                      "SSF57903 : 0050471", "SSF48726 : 0041301", "SSF49695 : 0048120", 
                      "PS51130 : PDXT_SNO_2", "SSF56672 : 0047722", "SSF53187 : 0042249", 
                      "SSF53244 : 0039392", "SSF50353 : 0042938", "SSF54637 : 0052337", 
                      "SSF49373 : 0036177", "SSF48695 : 0038376", "SSF51735 : 0041589", 
                      "SSF53474 : 0048194", "SSF50729 : 0051136", "PF09398 : FOP_dimer", 
                      "SSF50923 : 0037476", "SSF49384 : 0042696", "SSF49265 : 0042955", 
                      "SSF52172 : 0048997", "SSF52283 : 0047511", "SSF53137 : 0037621", 
                      "PF04190 : DUF410", "SSF53474 : 0045741", "SSF57716 : 0052191", 
                      "PF05000 : RNA_pol_Rpb1_4", "SSF88645 : 0046092", "SSF52540 : 0038144", 
                      "SSF47060 : 0035059", "SSF47031 : 0038080", "SSF54719 : 0045567", 
                      "SSF53167 : 0049568", "PR00209 : GLIADIN", "SSF49764 : 0037037", 
                      "SSF51735 : 0037887", "SSF56399 : 0037894", "SSF57889 : 0040009", 
                      "SSF48013 : 0044170", "SSF51197 : 0036786", "SSF50494 : 0043604", 
                      "SSF89360 : 0041595", "SSF101790 : 0048427", "SSF56235 : 0039156", 
                      "SSF57302 : 0043996", "SSF49899 : 0042498", "SSF64586 : 0038523", 
                      "SSF51735 : 0047066", "PF10188 : Oscp1", "SSF63515 : 0046680", 
                      "PF02537 : CRCB", "SSF57716 : 0050846", "PD059127 :", "PIRSF001490 :", 
                      "SSF56542 : 0042689", "SSF46785 : 0044212", "SSF57756 : 0037160", 
                      "TIGR00939 : 2a57", "SSF53697 : 0044166", "SSF56091 : 0046865", 
                      "SSF48113 : 0046365", "SSF56176 : 0046342", "SSF55307 : 0043343", 
                      "SSF56784 : 0050797", "SSF75304 : 0041778", "PR00096 : GATASE", 
                      "PIRSF002134 :", "SSF52799 : 0040982", "SSF48445 : 0041748", 
                      "SSF109635 : 0044029", "SSF53474 : 0035629", "SSF54452 : 0038990", 
                      "SSF47473 : 0039153", "PS50240 : TRYPSIN_DOM", "SSF50249 : 0040961", 
                      "SSF48225 : 0046831", "SSF55239 : 0050439", "SSF57048 : 0035844", 
                      "SSF49503 : 0040025", "SSF52540 : 0046248", "SSF46785 : 0043935", 
                      "SSF53187 : 0044553", "SSF53659 : 0043823", "SSF52540 : 0052005", 
                      "SSF52335 : 0035414", "SSF53597 : 0053318", "PD203358 :", "SSF52833 : 0036937", 
                      "PF02480 : Herpes_gE", "SSF55424 : 0041023", "SSF46626 : 0047602", 
                      "SSF57774 : 0045786", "SSF50044 : 0039852", "PF00784 : MyTH4", 
                      "SSF51735 : 0051235", "SSF51735 : 0047481", "SSF55154 : 0036307", 
                      "SSF57667 : 0050858", "SSF57302 : 0035701", "SSF52467 : 0043324", 
                      "SSF49503 : 0045721", "PS50905 : FERRITIN_LIKE", "PD021457 :", 
                      "SSF51735 : 0038557", "SSF54277 : 0048552", "SSF49785 : 0045964", 
                      "SSF51569 : 0049453", "SSF50249 : 0047715", "SSF81296 : 0035977", 
                      "SSF82657 : 0044676", "SSF81296 : 0038118", "SSF53720 : 0035766", 
                      "SSF55103 : 0046489", "PD010497 :", "SSF82866 : 0039248", "SSF54637 : 0041428", 
                      "SSF54001 : 0042902", "SSF50353 : 0047922", "SSF50156 : 0050618", 
                      "SSF52440 : 0047407", "SSF56300 : 0051159", "SSF53955 : 0053219", 
                      "SSF56935 : 0045421", "PF08510 : PIG-P", "PF02934 : GatB_N", 
                      "SSF54495 : 0052597", "SSF51011 : 0035170", "SSF55486 : 0036877", 
                      "SSF51445 : 0039218", "SSF54665 : 0039728", "SSF52821 : 0038171", 
                      "SSF53383 : 0042383", "SSF55729 : 0041332", "SSF53850 : 0035934", 
                      "SSF56854 : 0048570", "SSF48726 : 0037120", "SSF53383 : 0052862", 
                      "SSF52743 : 0038257", "SSF51445 : 0041487", "SSF54768 : 0044374", 
                      "SSF57667 : 0050944", "SSF54637 : 0051233", "SSF52540 : 0046459", 
                      "SSF54506 : 0046029", "SSF49899 : 0052421", "PIRSF005461 :", 
                      "SSF53807 : 0042774", "SSF51604 : 0045367", "PF01843 : DIL", 
                      "SSF50203 : 0048803", "SSF51011 : 0046947", "SSF53474 : 0036443", 
                      "PS51203 : CS", "SSF51045 : 0037434", "SSF48452 : 0051845", "PR01660 : MCMPROTEIN4", 
                      "PF05753 : TRAP_beta", "SSF55729 : 0047280", "PF04716 : ETC_C1_NDUFA5", 
                      "SSF55282 : 0037532", "PR00196 : ANNEXIN", "PR00502 : NUDIXFAMILY", 
                      "SSF82708 : 0041073", "SSF48552 : 0039401", "SSF49899 : 0035289", 
                      "SSF51735 : 0036922", "SSF50692 : 0046625", "SSF52343 : 0046601", 
                      "PF00701 : DHDPS", "SSF48726 : 0040890", "SSF81296 : 0040154", 
                      "SSF74731 : 0038337", "TIGR01018 : rpsD_arch", "SSF52833 : 0039826", 
                      "SSF51316 : 0050863", "PF07228 : SpoIIE", "SSF49503 : 0053159", 
                      "SSF53901 : 0052890", "SSF53182 : 0045822", "SSF51230 : 0038124", 
                      "SSF53098 : 0040018", "SSF52540 : 0048692", "TIGR01068 : thioredoxin", 
                      "SSF50249 : 0037622", "SSF52374 : 0037452", "PF02325 : YGGT", 
                      "SSF53720 : 0037277", "SSF53732 : 0034996", "SSF51445 : 0052352", 
                      "SSF50122 : 0037238", "TIGR00606 : rad50", "SSF54862 : 0052928", 
                      "SSF51735 : 0044811", "SSF49503 : 0035769", "SSF47240 : 0048201", 
                      "SSF47781 : 0051452", "SSF55729 : 0052652", "PF04614 : Pex19", 
                      "SSF54826 : 0041088", "SSF46785 : 0046835", "SSF50249 : 0048641", 
                      "SSF54368 : 0038717", "PS50935 : SSB", "SSF52374 : 0044869", 
                      "SSF52540 : 0038848", "SSF51735 : 0038042", "PIRSF005211 :", 
                      "SSF55486 : 0038739", "SSF57095 : 0047615", "SSF48726 : 0036974", 
                      "SSF51649 : 0049140", "SSF48726 : 0040024", "SSF52833 : 0052631", 
                      "SSF54373 : 0035805", "SSF52833 : 0048366", "SSF53686 : 0048698", 
                      "SSF54768 : 0050799", "SSF49265 : 0039415", "SSF56994 : 0038727", 
                      "PD013594 :", "PF02138 : Beach", "SSF52799 : 0037934", "PIRSF037512 :", 
                      "SSF49265 : 0047336", "SSF56235 : 0043432", "PF03238 : ESAG1", 
                      "SSF54897 : 0048734", "PS50014 : BROMODOMAIN_2", "PF06331 : Tbf5", 
                      "PF03031 : NIF", "SSF53474 : 0035852", "SSF55073 : 0050428", 
                      "SSF53383 : 0044174", "SSF55781 : 0048135", "SSF49503 : 0051890", 
                      "SSF52540 : 0051206", "SSF82109 : 0041217", "SSF109715 : 0042580", 
                      "SSF54236 : 0050738", "SSF81296 : 0036520", "SSF52038 : 0052341", 
                      "SSF55486 : 0042098", "PF09747 : DUF2052", "SSF88659 : 0047915", 
                      "SSF56436 : 0042435", "SSF54814 : 0039833", "SSF51905 : 0046579", 
                      "SSF90229 : 0049157", "SSF55347 : 0053217", "SSF49503 : 0042880", 
                      "SSF51445 : 0042886", "SSF81296 : 0051973", "SSF90234 : 0048287", 
                      "SSF57652 : 0037269", "SSF54980 : 0050452", "SSF50386 : 0037261", 
                      "SSF52540 : 0046916", "SSF48498 : 0048726", "PF05019 : Coq4", 
                      "SSF52540 : 0039711", "SSF56752 : 0037168", "PD000089 :", "SSF57027 : 0048141", 
                      "SSF51604 : 0052170", "SSF50989 : 0046096", "SSF89957 : 0040706", 
                      "TIGR01425 : SRP54_euk", "PF02018 : CBM_4_9", "SSF53300 : 0040754", 
                      "SSF53671 : 0040988", "SSF63393 : 0043436", "SSF56821 : 0038175", 
                      "SSF52518 : 0042410", "SSF46785 : 0044373", "SSF46689 : 0047203", 
                      "SSF54637 : 0042391", "TIGR00234 : tyrS", "SSF54427 : 0052330", 
                      "SSF46934 : 0046543", "TIGR01681 : HAD-SF-IIIC", "PR00421 : THIOREDOXIN", 
                      "PF00240 : ubiquitin", "SSF63825 : 0047378", "PF06650 : DUF1162", 
                      "SSF53706 : 0042561", "PD005595 :", "SSF47266 : 0035537", "PF00275 : EPSP_synthase", 
                      "SSF53335 : 0053107", "SSF48726 : 0046027", "SSF51971 : 0038926", 
                      "SSF46458 : 0046518", "SSF57716 : 0051943", "SSF51161 : 0050963", 
                      "SSF69125 : 0040010", "PIRSF029792 :", "SSF51658 : 0046031", 
                      "SSF110581 : 0044837", "PF01786 : AOX", "SSF46894 : 0040370", 
                      "SSF63562 : 0047316", "SSF57362 : 0043615", "SSF48371 : 0047214", 
                      "SSF48371 : 0051071", "SSF57059 : 0040213", "PIRSF006290 :", 
                      "SSF54909 : 0053111", "SSF50784 : 0045106", "PF03992 : ABM", 
                      "SSF57667 : 0052469", "SSF51182 : 0049913", "PR00114 : STPHPHTASE", 
                      "SSF50891 : 0038362", "SSF63491 : 0043906", "SSF52343 : 0045225", 
                      "SSF57586 : 0046273", "SSF51905 : 0036283", "SSF52540 : 0045157", 
                      "PR00419 : ADXRDTASE", "SSF56784 : 0037518", "SSF54098 : 0038866", 
                      "SSF53155 : 0048153", "SSF49879 : 0050650", "SSF49879 : 0043096", 
                      "SSF57059 : 0047782", "SSF57429 : 0041995", "SSF53067 : 0045198", 
                      "SSF50729 : 0052133", "SSF48726 : 0037723", "SSF52833 : 0034951", 
                      "SSF51658 : 0034805", "TIGR01059 : gyrB", "SSF52833 : 0051503", 
                      "SSF47836 : 0039783", "SSF46565 : 0037467", "SSF52954 : 0050405", 
                      "SSF53335 : 0052709", "SSF50814 : 0038164", "SSF47240 : 0051644", 
                      "PF03731 : Ku_N", "PF06728 : PIG-U", "SSF50129 : 0038706", "SSF48264 : 0041837", 
                      "SSF50800 : 0041702", "SSF54001 : 0050999", "PS50848 : START", 
                      "PF00031 : Cystatin", "SSF50814 : 0037772", "SSF51156 : 0037281", 
                      "PF10453 : NUFIP1", "SSF57716 : 0034917", "SSF52540 : 0039588", 
                      "SSF48726 : 0038772", "SSF57610 : 0038969", "PIRSF016958 :", 
                      "SSF48208 : 0046939", "SSF52317 : 0048482", "SSF52935 : 0042357", 
                      "PIRSF005538 :", "SSF54897 : 0041540", "SSF54495 : 0053118", 
                      "SSF49503 : 0045919", "TIGR01310 : L7", "SSF57933 : 0040415", 
                      "SSF51556 : 0044457", "TIGR01814 : kynureninase", "SSF51445 : 0044488", 
                      "PIRSF000548 :", "SSF51905 : 0042577", "PF01876 : RNase_P_p30", 
                      "SSF53850 : 0047462", "SSF50630 : 0039295", "PS51335 : ELMO", 
                      "SSF50118 : 0048342", "SSF81296 : 0039583", "SSF48230 : 0038641", 
                      "SSF57850 : 0040463", "PF03479 : DUF296", "PR01084 : NAHEXCHNGR", 
                      "PF07819 : PGAP1", "SSF49777 : 0042907", "SSF47031 : 0046535", 
                      "SSF52799 : 0040438", "SSF81338 : 0039367", "SSF51445 : 0036776", 
                      "SSF51679 : 0046666", "PF03590 : AsnA", "SSF52980 : 0049280", 
                      "SSF57667 : 0045696", "SSF53474 : 0037047", "SSF54211 : 0037617", 
                      "PF05020 : zf-NPL4", "SSF55831 : 0035358", "PR00992 : ALARACEMASE", 
                      "SSF55781 : 0049608", "SSF52540 : 0051462", "SSF47459 : 0035112", 
                      "SSF55961 : 0044802", "PF02272 : DHHA1", "SSF56112 : 0040179", 
                      "PF00200 : Disintegrin", "SSF54713 : 0046542", "SSF50249 : 0040977", 
                      "PF03717 : PBP_dimer", "SSF53448 : 0046778", "SSF54534 : 0045075", 
                      "SSF51182 : 0046882", "SSF48371 : 0038301", "SSF50090 : 0042451", 
                      "PS51336 : DM10", "PF06325 : PrmA", "TIGR00545 : lipoyltrans", 
                      "SSF48140 : 0037541", "SSF49313 : 0040374", "SSF51011 : 0038397", 
                      "SSF50203 : 0046829", "SSF53067 : 0042564", "PF02877 : PARP_reg", 
                      "PS50128 : SURP", "SSF47266 : 0037173", "SSF56801 : 0042298", 
                      "SSF48619 : 0039053", "SSF57716 : 0034932", "SSF52540 : 0047839", 
                      "SSF55681 : 0049378", "SSF52402 : 0046213", "SSF52540 : 0050482", 
                      "SSF52402 : 0042558", "SSF48726 : 0037685", "PIRSF000799 :", 
                      "SSF54637 : 0042617", "SSF50044 : 0046957", "PIRSF000440 :", 
                      "PF04488 : Gly_transf_sug", "SSF49417 : 0043880", "SSF52218 : 0036778", 
                      "SSF48619 : 0041980", "PS51194 : HELICASE_CTER", "SSF46689 : 0044446", 
                      "SSF51569 : 0044252", "SSF81585 : 0035657", "SSF49503 : 0049086", 
                      "SSF53659 : 0047222", "SSF53032 : 0034924", "SSF47686 : 0035858", 
                      "SSF53850 : 0035102", "SSF52799 : 0039614", "SSF54511 : 0044381", 
                      "PIRSF000183 :", "PIRSF005669 :", "PF02409 : Omt_N", "SSF52833 : 0050950", 
                      "SSF54637 : 0048175", "PF02678 : Pirin", "SSF82653 : 0040985", 
                      "SSF57429 : 0039635", "PF08541 : ACP_syn_III_C", "SSF54637 : 0052099", 
                      "SSF53167 : 0035404", "SSF56327 : 0038825", "SSF52374 : 0048474", 
                      "SSF46689 : 0053366", "SSF57196 : 0047815", "SSF48726 : 0038942", 
                      "SSF49265 : 0035922", "PF10256 : Erf4", "SSF52540 : 0036958", 
                      "PIRSF015840 :", "SSF51649 : 0053380", "SSF50249 : 0052503", 
                      "PR00125 : ATPASEDELTA", "SSF49329 : 0048853", "PF10687 : DUF2495", 
                      "SSF47473 : 0040246", "SSF63411 : 0038686", "SSF74748 : 0040421", 
                      "SSF51182 : 0042381", "SSF50800 : 0040512", "SSF47616 : 0038305", 
                      "SSF53933 : 0045433", "SSF46785 : 0045032", "SSF52121 : 0043387", 
                      "SSF53137 : 0048651", "PF00533 : BRCT", "SSF46609 : 0036080", 
                      "PF06013 : WXG100", "SSF51604 : 0049411", "SSF52540 : 0045492", 
                      "SSF49785 : 0045051", "SSF47384 : 0035337", "SSF46458 : 0037588", 
                      "SSF51569 : 0045714", "PF00011 : HSP20", "PIRSF000724 :", "SSF50084 : 0035391", 
                      "SSF51182 : 0039374", "SSF50494 : 0048262", "SSF49899 : 0051382", 
                      "SSF49879 : 0042984", "PF06418 : CTP_synth_N", "SSF46689 : 0049392", 
                      "SSF54919 : 0039809", "SSF53067 : 0038604", "SSF50978 : 0039965", 
                      "SSF56512 : 0036914", "SSF52540 : 0034832", "PF04178 : Got1", 
                      "SSF50199 : 0047647", "SSF55770 : 0036110", "PF00392 : GntR", 
                      "SSF47240 : 0048397", "SSF46458 : 0045349", "PF09439 : SRPRB", 
                      "SSF81296 : 0052399", "SSF53448 : 0048137", "SSF57059 : 0039763", 
                      "SSF51161 : 0038636", "SSF81296 : 0035950", "SSF82808 : 0040630", 
                      "SSF51735 : 0037629", "SSF55729 : 0049262", "SSF54675 : 0052614", 
                      "PD005774 :", "SM00288 : VHS_2", "SM00732 : rnase_8s", "SM00470 : ParB_7", 
                      "SM00422 : merrmega3", "SM00180 : lamegf_3", "SM00693 : dysfn", 
                      "SM00694 : dysfc", "SM00267 : duf1_3", "SM00042 : CUB_2", "SM00722 : complete", 
                      "SM00329 : bpi2_2", "SM00644 : ami_2", "SM00665 : 561_7", "SM00461 : WH1_2", 
                      "SM00465 : uri_9", "SM00287 : sh3_bac_9", "SM00091 : pas_2", 
                      "SM00237 : NIbeta_1", "SM00061 : math_3", "SM00192 : LDLa_2", 
                      "SM00388 : HisKA_10", "SM00345 : gntr3", "SM00640 : glyco_32", 
                      "SM00541 : fyrn_3", "SM00542 : fyrc_3", "SM00051 : dsl11", "SM00684 : dm15", 
                      "SM00043 : CY_4", "SM00439 : BAH_4", "SM00756 : vkor_5", "SM00784 : spt2", 
                      "SM00483 : polxneu3", "SM00473 : ntp_6", "SM00257 : LysM_2", 
                      "SM00532 : ligaN3", "SM00559 : ku_4", "SM00507 : HNH_5", "SM00466 : G9a_1", 
                      "SM00063 : FRI_4", "SM00049 : DEP_3", "SM00034 : CLECT_2", "SM00674 : cenpb", 
                      "SM00672 : cap10", "SM00810 : alpha-amyl_c2", "SM00597 : 2118neu4", 
                      "SM00755 : 1grip", "SM00704 : znf_cdgsh", "SM00509 : TFS2_5", 
                      "SM00733 : mt_12", "SM00777 : mad3_bub1_i", "SM00457 : MACPF_8", 
                      "SM00308 : LH2_4", "SM00545 : JmjN_1", "SM00029 : gastr3", "SM00065 : gaf_1", 
                      "SM00274 : FOLN_3", "SM00554 : fasc_3", "SM00695 : dusp", "SM00558 : cupin_9", 
                      "SM00384 : AT_hook_2", "SM00815 : ama_1", "SM00788 : adenylsucc_synt", 
                      "SM00757 : toby_final6", "SM00424 : ste", "SM00555 : spa2_6", 
                      "SM00448 : REC_2", "SM00738 : nusgn_4", "SM00347 : marrlong4", 
                      "SM00421 : luxrmega5", "SM00742 : hr1_7", "SM00339 : forkneu4", 
                      "SM00050 : DISIN_2", "SM00668 : ctlh", "SM00300 : ChS_2", "SM00749 : bon", 
                      "SM00238 : bir_2", "SM00411 : bhlneu", "SM00418 : arsrmega2", 
                      "SM00342 : aracneu4", "SM00586 : 3039neu", "SM00774 : WRKY_cls", 
                      "SM00535 : riboneu5", "SM00502 : RAD_5", "SM00481 : npolultra", 
                      "SM00446 : LRRcap_2", "SM00278 : HhH1_4", "SM00683 : dm16", "SM00676 : dm10", 
                      "SM00116 : cbs_1", "SM00335 : annex3", "SM00394 : akam_3", "SM00631 : zn_carb", 
                      "SM00751 : wurzfinal6", "SM00289 : WR1_2", "SM00602 : vps10", 
                      "SM00333 : TUDOR_7", "SM00209 : TSP1_2", "SM00435 : topeu", "SM00151 : swib_2", 
                      "SM00202 : SR_3", "SM00254 : ShkT_1", "SM00516 : sec14_4", "SM00198 : SCP_3", 
                      "SM00454 : SAM_4", "SM00719 : rtf1", "SM00659 : rpolcxc3", "SM00657 : rpol4neu2", 
                      "SM00508 : PostSET_3", "SM00517 : poly_2", "SM00149 : plcy_3", 
                      "SM00148 : plcx_3", "SM00244 : PHB_4", "SM00758 : pa14_novel", 
                      "SM00702 : p4hc", "SM00004 : NL_2", "SM00139 : MyTH4_1", "SM00698 : morn", 
                      "SM00510 : mid_6", "SM00137 : MAM_2", "SM00464 : lon_5", "SM00775 : lns2", 
                      "SM00603 : lcc", "SM00130 : KR_2", "SM00612 : kelc_smart", "SM00280 : kazal_3", 
                      "SM00015 : iq_5", "SM00306 : hint_7", "SM00761 : hdac_interact2seq4b", 
                      "SM00444 : gyf_5", "SM00060 : FN3_2", "SM00441 : FF_2", "SM00055 : fch_2", 
                      "SM00567 : EZ_HEAT", "SM00479 : exoiiiendus", "SM00477 : endoplus", 
                      "SM00179 : egfca_6", "SM00537 : doub1_11", "SM00044 : cyc_6", 
                      "SM00357 : csp_8", "SM00100 : cnmp_10", "SM00032 : CCP_2", "SM00525 : ccc3", 
                      "SM00225 : BTB_4", "SM00573 : bromneu2", "SM00501 : bright_3", 
                      "SM00223 : APPLE_7", "SM00518 : ap2real3", "SM00259 : A20_3", 
                      "SM00291 : zz_5", "SM00709 : zpr1", "SM00438 : znfxneu3", "SM00451 : ZnF_U1_5", 
                      "SM00290 : Zf_UBP_1", "SM00547 : zf_4", "SM00506 : YBR022w_8", 
                      "SM00485 : xpgn3", "SM00484 : xpgineu", "SM00456 : ww_5", "SM00246 : wh2_8", 
                      "SM00773 : WGR_cls", "SM00320 : WD40_4", "SM00327 : VWA_4", "SM00167 : vps9_2", 
                      "SM00609 : vit", "SM00262 : VILL_6", "SM00153 : VHP_1", "SM00487 : ultradead3", 
                      "SM00726 : uim", "SM00800 : uDENN_cls", "SM00166 : ubx_3", "SM00213 : ubq_7", 
                      "SM00504 : Ubox_2", "SM00212 : ubc_7", "SM00165 : uba_6", "SM00219 : tyrkin_6", 
                      "SM00397 : tSNARE_6", "SM00028 : tpr_5", "SM00493 : toprim5", 
                      "SM00434 : topIV4", "SM00433 : topII5", "SM00436 : topIban2", 
                      "SM00437 : topIaneu2", "SM00208 : TNFR_3", "SM00460 : TG_5", 
                      "SM00531 : tfiie3", "SM00581 : testneu", "SM00164 : tbc_4", "SM00803 : TAF_cls", 
                      "SM00503 : SynN_4", "SM00648 : surpneu2", "SM00234 : START_1", 
                      "SM00449 : SPRY_3", "SM00731 : sprt_6", "SM00318 : SNASE_2", 
                      "SM00463 : SMR_2", "SM00745 : smart", "SM00651 : Sm3", "SM00512 : skp1_3", 
                      "SM00326 : SH3_2", "SM00252 : SH2_5", "SM00317 : set_7", "SM00093 : serpin2", 
                      "SM00220 : serkin_6", "SM00671 : sel1", "SM00222 : sec7_5", "SM00611 : SEC63", 
                      "SM00178 : sar_sub_1", "SM00741 : sapb_4", "SM00513 : sap_9", 
                      "SM00717 : sant", "SM00363 : s4_6", "SM00316 : S1_6", "SM00591 : RWD2001b", 
                      "SM00361 : rrm2_1", "SM00360 : rrm1_1", "SM00662 : rpoldneu2", 
                      "SM00663 : rpolaneu7", "SM00661 : rpol9cneu", "SM00658 : rpol8neu", 
                      "SM00649 : rl11c", "SM00090 : rio_2", "SM00744 : ringv_2", "SM00184 : ring_2", 
                      "SM00458 : ricin_3", "SM00325 : RhoGEF_3", "SM00324 : RhoGAP_3", 
                      "SM00450 : rhod_4", "SM00174 : rho_sub_3", "SM00315 : RGS_3", 
                      "SM00229 : rasgefn_5", "SM00147 : RasGEF_3", "SM00323 : RasGAP_2", 
                      "SM00173 : ras_sub_4", "SM00160 : ranbd_3", "SM00176 : ran_sub_2", 
                      "SM00650 : rADcneu6", "SM00175 : rab_sub_5", "SM00393 : R3H_4", 
                      "SM00312 : PX_2", "SM00293 : PWWP_4", "SM00311 : pwi_2", "SM00396 : push_1", 
                      "SM00025 : pum_5", "SM00359 : pua_5", "SM00194 : PTPc_3", "SM00404 : ptp_7", 
                      "SM00423 : psinew7", "SM00730 : psh_8", "SM00392 : prof_2", "SM00500 : pr04_2", 
                      "SM00331 : PP2C_SIG_2", "SM00332 : PP2C_4", "SM00156 : pp2a_7", 
                      "SM00538 : pop4_2", "SM00486 : polmehr3", "SM00482 : polaultra3", 
                      "SM00563 : plsc_2", "SM00155 : pld_4", "SM00133 : pkinase_C_6", 
                      "SM00330 : PIPK_2", "SM00088 : PINT_4", "SM00753 : PINT", "SM00670 : PIN_9", 
                      "SM00780 : pig_x_1", "SM00144 : pi3k_ras_2", "SM00142 : pi3k_hr3_6", 
                      "SM00145 : pi3k_hr2_4", "SM00146 : pi3k_hr1_6", "SM00249 : PHD_3", 
                      "SM00233 : PH_update", "SM00737 : pgtp_13", "SM00580 : PGNneu", 
                      "SM00645 : pept_c1", "SM00228 : pdz_new", "SM00710 : pbh1", "SM00285 : PBD_5", 
                      "SM00666 : PB1_new", "SM00232 : pad1_6", "SM00562 : ndk_5", "SM00242 : MYSc_2a", 
                      "SM00534 : mutATP5", "SM00472 : mir_2", "SM00729 : MiaB", "SM00350 : mcm", 
                      "SM00530 : mbf_short4", "SM00432 : madsneu2", "SM00544 : ma3_7", 
                      "SM00369 : LRR_typ_2", "SM00365 : LRR_sd22_2", "SM00368 : LRR_RI_2", 
                      "SM00367 : LRR_CC_2", "SM00364 : LRR_bac_2", "SM00226 : LMWPc_2", 
                      "SM00714 : litaf", "SM00667 : Lish", "SM00132 : lim_4", "SM00724 : lag1_27", 
                      "SM00715 : la", "SM00739 : kow_9", "SM00129 : kinesin_4", "SM00322 : kh_6", 
                      "SM00498 : it6_source", "SM00564 : ire1_9", "SM00429 : iptmega2", 
                      "SM00307 : ILWEQ_1", "SM00543 : if4_15", "SM00647 : ibrneu5", 
                      "SM00128 : i5p_5", "SM00415 : hsfneu3", "SM00341 : hrdc7", "SM00389 : HOX_1", 
                      "SM00398 : hmgende2", "SM00387 : HKATPase_4", "SM00279 : HhH_4", 
                      "SM00490 : helicmild6", "SM00119 : hect_3", "SM00471 : hd_13", 
                      "SM00386 : hat_new_1", "SM00417 : h44", "SM00428 : h35", "SM00427 : h2b3", 
                      "SM00414 : h2a4", "SM00568 : gram2001c", "SM00072 : gk_7", "SM00302 : GED_2", 
                      "SM00401 : GATA_3", "SM00275 : galpha_1", "SM00443 : G-patch_5", 
                      "SM00064 : fyve_4", "SM00261 : furin_3", "SM00577 : forpap2", 
                      "SM00557 : flmn_3", "SM00240 : FHA_2", "SM00256 : fbox_2", "SM00553 : faf_3", 
                      "SM00273 : enth_2", "SM00478 : endo3end", "SM00654 : eIF6neu2", 
                      "SM00653 : eIF2Bneu4", "SM00652 : eIF1neu4", "SM00027 : eh_3", 
                      "SM00181 : egf_5", "SM00054 : efh_1", "SM00053 : dynamin_3", 
                      "SM00195 : dsp_5", "SM00271 : dnaj_3", "SM00533 : DNAend", "SM00799 : DENN_cls", 
                      "SM00678 : deltex", "SM00488 : deadxpd", "SM00801 : dDENN_cls", 
                      "SM00045 : dagk_c4b_2", "SM00046 : dagk_c4a_7", "SM00230 : cys_prot_2", 
                      "SM00440 : Cys4_2", "SM00385 : cyclin_7", "SM00491 : Cxpdneu3", 
                      "SM00182 : cul_2", "SM00546 : cue_7", "SM00679 : ctns", "SM00762 : cog4.2seq4", 
                      "SM00299 : CLH_2", "SM00298 : chromo_7", "SM00270 : ChitinBD_3", 
                      "SM00033 : ch_5", "SM00727 : CBM", "SM00521 : cbf3", "SM00673 : carp", 
                      "SM00356 : c3hfinal6", "SM00343 : c2hcfinal6", "SM00734 : c2hc_5", 
                      "SM00355 : c2h2final6", "SM00239 : C2_3c", "SM00109 : c1_12", 
                      "SM00297 : bromo_6", "SM00338 : brlzneu", "SM00292 : BRCT_7", 
                      "SM00635 : bid_2", "SM00336 : bboxneu5", "SM00295 : B41_5", "SM00185 : arm_5", 
                      "SM00177 : arf_sub_2", "SM00105 : arf_gap_3", "SM00248 : ANK_2a", 
                      "SM00154 : AN1_Zf_4", "SM00811 : alpha_kinase", "SM00809 : alpha_adaptinc2", 
                      "SM00102 : adf_2", "SM00552 : adara_8", "SM00268 : actin_3", 
                      "SM00014 : acid_phosph_2", "SM00785 : aarp2cn2", "SM00642 : aamy", 
                      "SM00382 : AAA_5", "SM00582 : 558neu5", "SM00515 : 542_3", "SM00475 : 53exo3", 
                      "SM00746 : 4TRASH", "SM00594 : 45neu3", "SM00474 : 35exoneu6", 
                      "SM00636 : 2g34", "SM00720 : 2cal", "SM00575 : 26again6", "SM00576 : 17neu3", 
                      "SM00101 : 1433_4", "SM00584 : 109ultra", "IPR006113 : 6PGDH_decarbox", 
                      "IPR009161 : 6-phosphofructokinase_euk", "IPR015896 : 4pyrrol_synth_GluRdtase_C", 
                      "IPR017921 : Znf_CTCHY", "IPR004019 : YLP_motif", "IPR013136 : WSTF_Acf1_Cbp146", 
                      "IPR003657 : WRKY_DNA_bd", "IPR009021 : Viral_DNA_bd", "IPR009055 : UvrB_UvrC-bd_C", 
                      "IPR001943 : UvrB/C", "IPR005765 : Ura_phspho_trans", "IPR001441 : UPP_synth-like", 
                      "IPR012404 : UCP036436", "IPR003603 : U2A'_phosphoprotein32A_C", 
                      "IPR010921 : Trp_repressor/repl_initiator", "IPR008880 : Trigger_fac_C_bac", 
                      "IPR000944 : Transcriptional_reg_Rrf2", "IPR014805 : TM_SKG6", 
                      "IPR007829 : TM2", "IPR002155 : Thiolase", "IPR004826 : TF_Maf", 
                      "IPR019136 : TF_IIIC_su-5", "IPR011075 : Tet_transcr_reg_TetR-rel_C", 
                      "IPR003545 : Telomerase_RT", "IPR009852 : Tcp10/CenJ_C", "IPR009578 : Surface_Ag_Streptococcal", 
                      "IPR002828 : SurE-like_Pase/nucleotidase", "IPR014123 : Superoxide_dismutase_Ni-type", 
                      "IPR000917 : Sulfatase", "IPR003663 : Sugar/inositol_transpt", 
                      "IPR009062 : Smac_DIABLO-like", "IPR005131 : Ser_deHydtase_bsu", 
                      "IPR005130 : Ser_deHydtase_asu", "IPR019389 : Selenoprotein_T", 
                      "IPR011116 : SecA_Wing/Scaffold", "IPR011074 : Sec14p-like_N", 
                      "IPR017442 : Se/Thr_pkinase-rel", "IPR011510 : SAM_2", "IPR014886 : RRM_3", 
                      "IPR002156 : RNase_H", "IPR013197 : RNA_polIII_HTH", "IPR008806 : RNA_pol_Rpc82_C", 
                      "IPR007991 : RNA_pol_I_trans_ini_fac_RRN3", "IPR001574 : Ribosome_inactivat_prot", 
                      "IPR017938 : Riboflavin_synthase-like_b-brl", "IPR008805 : RIB43A", 
                      "IPR011539 : RHD", "IPR000477 : Reverse_transcriptase", "IPR000159 : Ras-assoc", 
                      "IPR009290 : Radial_spoke_3", "IPR008963 : Purple_acid_Pase-like_N", 
                      "IPR002884 : PrprotnconvertsP", "IPR000221 : Protamine_P1", "IPR016661 : Prefoldin_su-4", 
                      "IPR016812 : PPase_methylesterase_euk", "IPR008025 : PP1_inhibitor", 
                      "IPR005009 : Pox_mRNA-cap", "IPR007596 : Pox_A_type_inc", "IPR017450 : POLO_box", 
                      "IPR003141 : Pol/His_phosphatase_N", "IPR001666 : PI_transfer", 
                      "IPR004013 : PHP_C", "IPR004570 : Phosphatidylglycerol_P_synth", 
                      "IPR006521 : Phage_tail_protein_I", "IPR014485 : Pesterase_C1039", 
                      "IPR000209 : Peptidase_S8/S53", "IPR000121 : PEP_utilizers", 
                      "IPR008210 : PEP_carboxykinase_N", "IPR008209 : PEP_carboxykinase_GTP", 
                      "IPR006170 : PBP_GOBP", "IPR019399 : Parkin_co-regulated_protein", 
                      "IPR002500 : PAPS_reduct", "IPR001155 : OxRdtase_FMN_N", "IPR008333 : OxRdtase_FAD-bd", 
                      "IPR002292 : Orn_carbamltrans", "IPR006027 : NusB_RsmB_TIM44", 
                      "IPR013918 : Nucleotide_exch_Fes1", "IPR004301 : Nucleoplasmin", 
                      "IPR014824 : NIF_FeS_clus_asmbl_NifU-like_N", "IPR006405 : Nic_PRibTrfase_put", 
                      "IPR006573 : Neu_Z", "IPR014930 : Myotonic_dystrophy_kinase_coil", 
                      "IPR007846 : MPPN", "IPR013684 : Miro-like", "IPR012099 : Midasin", 
                      "IPR018799 : Microtubule/TRAF3/DISC1-bd", "IPR005935 : Mev_diP_decarb", 
                      "IPR002528 : MatE", "IPR003159 : Lyase_8_central_dom", "IPR012970 : Lyase_8_alpha_N", 
                      "IPR011071 : Lyase_8-like_C", "IPR011251 : Luciferase-like", 
                      "IPR016439 : Longevity_assurance_LAG1_LAC1", "IPR001800 : Lipoprotein_6", 
                      "IPR016651 : Leu_CO_MeTrfase_LCTM1", "IPR011015 : LEM-like_fold", 
                      "IPR007213 : LCM_MeTrfase", "IPR011009 : Kinase-like", "IPR001772 : Kinase-assoc_KA1", 
                      "IPR008658 : KAP", "IPR011876 : IsopentenylPP_isomerase_typ1", 
                      "IPR019530 : Intra-flagellar_transport_57", "IPR010998 : Integrase_Lambda-type_N", 
                      "IPR007306 : Init_tRNA_PT", "IPR002348 : IL1_HBGF", "IPR004640 : HscB", 
                      "IPR000861 : HR1-like_rho-bd", "IPR013528 : HMG_CoA_synth_N", 
                      "IPR013746 : HMG_CoA_synt_C", "IPR009029 : HMG_CoA_Rdtase_sub-bd", 
                      "IPR002202 : HMG_CoA_Rdtase_cat", "IPR003583 : Hlx-hairpin-Hlx_DNA-bd_motif", 
                      "IPR006439 : HAD-SF_hydro_IA_v1", "IPR017459 : Glycosyl_Trfase_fam3_N", 
                      "IPR008631 : Glycogen_synth", "IPR000173 : GlycerAld_3-P_DH", 
                      "IPR005615 : Glutathione_synthase_euk", "IPR017933 : Glutathione_S_Trfase/Cl_chnl_C", 
                      "IPR004045 : Glutathione_S-Trfase_N", "IPR011493 : GLUG", "IPR003836 : Glucokinase", 
                      "IPR014362 : Glu_DH", "IPR006097 : Glu/Leu/Phe/Val_DH_dimer", 
                      "IPR006095 : Glu/Leu/Phe/Val_DH", "IPR001282 : Glc-6-P_DH", "IPR004308 : GCS", 
                      "IPR017926 : GATASE_1", "IPR016477 : Fructo-/Ketosamine-3-kinase", 
                      "IPR002666 : Folate_carrier", "IPR001709 : Flavoprot_Pyr_Nucl_cyt_Rdtase", 
                      "IPR001094 : Flavdoxin-like", "IPR016092 : FeS_cluster_insertion", 
                      "IPR000361 : FeS_biogenesis", "IPR017927 : Fd_Rdtase_FAD-bd", 
                      "IPR016166 : FAD-bd_2", "IPR013520 : Exonuclease_RNaseT/DNA_pol3", 
                      "IPR008611 : EspB", "IPR004057 : Epsilon_tubulin", "IPR006816 : Engulfment_cell_motility_ELMO", 
                      "IPR007346 : Endonuclease-I", "IPR008990 : Elect_transpt_accessory", 
                      "IPR006209 : EGF", "IPR018248 : EF_hand", "IPR018940 : EF-1_beta_acid_region_euk", 
                      "IPR016561 : Dynein_light_roadblock-type", "IPR013602 : Dynein_heavy_N-2", 
                      "IPR013594 : Dynein_heavy_N-1", "IPR014003 : DUF_DM16", "IPR006602 : DUF_DM10", 
                      "IPR008476 : DUF757", "IPR007965 : DUF738", "IPR007714 : DUF667", 
                      "IPR019628 : DUF2495", "IPR018794 : DUF2340", "IPR003864 : DUF221", 
                      "IPR006606 : DUF1448", "IPR010736 : DUF1309", "IPR010554 : DUF1126", 
                      "IPR017188 : Ubiquitin-related_modifier_1", "IPR005375 : Ubiquitin-like_Ufm1", 
                      "IPR010233 : UbiG_MeTrfase", "IPR004033 : UbiE/COQ5_MeTrFase", 
                      "IPR000537 : UbiA_prenyltrans", "IPR009060 : UBA_like", "IPR003250 : U_glycsylse_pox", 
                      "IPR003249 : U_glycsylse_notp", "IPR001245 : Tyr_pkinase", "IPR000340 : Tyr_Pase_dual_specific", 
                      "IPR000387 : Tyr_Pase", "IPR002999 : Tudor", "IPR003008 : Tubulin_FtsZ", 
                      "IPR012945 : Tubulin-bd_cofactor_C", "IPR000884 : TSP1", "IPR000458 : Tryp_mucin", 
                      "IPR006654 : Trp_synth_beta", "IPR016904 : tRNAHis_guanylyltransf_euk", 
                      "IPR007537 : tRNAHis_guanylyltransf", "IPR011760 : tRNA_psdUrid_synth_D_core", 
                      "IPR001656 : tRNA_psdUrid_synth_D", "IPR002501 : tRNA_psdUrid_synth_B_N", 
                      "IPR001406 : tRNA_psdUrid_synth", "IPR014816 : tRNA_MeTrfase_GCD14", 
                      "IPR000652 : Triophos_ismrse", "IPR011004 : Trimer_LpxA_like", 
                      "IPR003337 : Trehalose_PPase", "IPR012617 : TRAUB", "IPR016696 : TRAPP_I_complex_Trs31", 
                      "IPR007194 : TRAPP_Bet3", "IPR017258 : Transprt_Chloroquine_res", 
                      "IPR016174 : Transmembr_di-haem_cytochrome", "IPR014038 : Transl_elong_EF1B_B/D_G_exch", 
                      "IPR001983 : Transl-control_tumor", "IPR005475 : Transketo_Cen_R", 
                      "IPR003257 : Transcrpt_antiterm_NusG_arc", "IPR016827 : Transcriptional_adaptor_2", 
                      "IPR008974 : TRAF_like", "IPR012000 : TPP_enzyme_M", "IPR012001 : TPP_bd_enzyme_N", 
                      "IPR006154 : Toprim_sub", "IPR006171 : Toprim_dom", "IPR008336 : TopoI_DNA_bd_euk", 
                      "IPR013500 : TopoI_cat_euk", "IPR013499 : TopoI_C_euk", "IPR001631 : TopoI_C", 
                      "IPR011558 : Topo_IIA_B_cons", "IPR016437 : Tma_RNA-bind_prd", 
                      "IPR015157 : TMA7", "IPR009637 : TM_rcpt_euk", "IPR006634 : TLC", 
                      "IPR001267 : TK_cell", "IPR007725 : TIMELESS_C", "IPR007379 : Tim44-like", 
                      "IPR003397 : Tim17_Tim22", "IPR000062 : Thymidylate_kin", "IPR000398 : Thymidylat_synth_C", 
                      "IPR013766 : Thioredoxin_dom", "IPR006662 : Thiored", "IPR012336 : Thiordxn-like_fd", 
                      "IPR001869 : Thiol_cytolysin", "IPR006683 : Thioestr_supf", "IPR010080 : Thioester_redct", 
                      "IPR010990 : TFIIS/elonginA/CRSP70_N", "IPR002853 : TFIIE_alpha", 
                      "IPR007582 : TFIID_WDA", "IPR003162 : TFIID-31", "IPR000812 : TFIIB_euk_relate", 
                      "IPR004600 : Tfb4", "IPR004598 : Tfb2", "IPR015241 : TF_MotA_C_phage", 
                      "IPR016492 : TF_IIS", "IPR003565 : Tetra_PHTase", "IPR005334 : Tctex", 
                      "IPR004345 : TB2_DP1_HVA22", "IPR007304 : TAP42", "IPR006186 : T_phtase_apaH", 
                      "IPR015208 : T4_recomb_endonuclease_dimer", "IPR001482 : T2SS_protein-E", 
                      "IPR015260 : Syntaxin-6_N", "IPR003121 : SWIB_MDM2", "IPR000436 : Sushi_SCR_CCP", 
                      "IPR011547 : Sulph_transpt", "IPR003663 : Sugar_transpt", "IPR014006 : Succ_Dhase_frdA_Gneg", 
                      "IPR011281 : Succ_DHase_flav_su_fwd", "IPR004489 : Succ_DHase/fum_Rdtase_Fe-S", 
                      "IPR006255 : SucB", "IPR006380 : Suc_6FPP_pln_cyn", "IPR004388 : Sua5_YciO_YrdC", 
                      "IPR001972 : Stomatin", "IPR002645 : STAS", "IPR007146 : SSU_processome_Utp3", 
                      "IPR007319 : SSU_processome_Utp21", "IPR012614 : SspP", "IPR007198 : Ssl1_like", 
                      "IPR007718 : SRP40_C", "IPR001190 : Srcr_rcpt", "IPR001543 : SpoA", 
                      "IPR006917 : SOUL_heme_bd", "IPR008831 : SOH1", "IPR001189 : SODismutase", 
                      "IPR008984 : SMAD_FHA_dom", "IPR015195 : SLIDE", "IPR004015 : SKIP_SNW", 
                      "IPR006886 : Sin_N", "IPR013699 : Signal_recog_part_SRP72_RNA-bd", 
                      "IPR009082 : Sig_transdc_His_kinase_dimeric", "IPR005467 : Sig_transdc_His_kinase_core", 
                      "IPR003661 : Sig_transdc_His_kin_sub1_dim/P", "IPR004358 : Sig_transdc_His_kin-like_C", 
                      "IPR003582 : ShK_toxin", "IPR008374 : SF_assemblin", "IPR015016 : SF3b_su1", 
                      "IPR002290 : Ser_thr_pkinase", "IPR012989 : SEP", "IPR006597 : Sel1_like", 
                      "IPR016126 : Secretoglobin", "IPR004179 : Sec63", "IPR004728 : Sec62", 
                      "IPR008159 : SEC61_g_subunit", "IPR005609 : Sec61_beta", "IPR005606 : Sec20", 
                      "IPR011074 : Sec14p_like_N", "IPR003768 : ScpA", "IPR014044 : SCP-like_extracellular", 
                      "IPR017229 : Scavenger_rcpt_PxSR", "IPR009248 : SbmA_BacA", "IPR002140 : SBDS", 
                      "IPR010516 : SAP18", "IPR010286 : SAM-Mtase_prd", "IPR005097 : Saccharopine_DHase", 
                      "IPR003029 : S1_RNA-bd", "IPR016909 : S-AdoMet-dep_MeTrfase_YbiN_prd", 
                      "IPR010994 : RuvA_2_like", "IPR011054 : Rudment_hybrid_motif", 
                      "IPR006174 : rRNAsub_MeTrfase", "IPR001737 : RRNA_meth_trans", 
                      "IPR011530 : rRNA_A_dimethylase", "IPR002877 : RrmJFtsJ_MeTrfase", 
                      "IPR006569 : RPR", "IPR004591 : Rpa1", "IPR000600 : ROK", "IPR003042 : Rng_hydrolase", 
                      "IPR012337 : RNaseH_fold", "IPR016848 : RNase_P/MRP_p29-subunit_euk", 
                      "IPR002730 : RNase_P/MRP_p29-sub_euk/arc", "IPR004649 : RNase_HII", 
                      "IPR013924 : RNase_H1_ssu", "IPR013223 : RNase_B_OB_N", "IPR011260 : RNAP_alpha_C", 
                      "IPR009674 : RNA_pol_Rpa2-specific", "IPR006591 : RNA_pol_Rbp10", 
                      "IPR016075 : RNA_pol_Pprot-P_XD_paramyxovir", "IPR017152 : RNA_pol_III_tscrpt_repres_MAF1", 
                      "IPR006590 : RNA_pol_II_Rpb4_core", "IPR005574 : RNA_pol_II_Rpb4", 
                      "IPR000684 : RNA_pol_II_repeat_euk", "IPR000722 : RNA_pol_A", 
                      "IPR000228 : RNA3'_term_phos_cycl", "IPR007209 : RLI_metal_bd", 
                      "IPR015285 : RIO2_kinase_wHTH_N", "IPR002661 : Ribosome_recyc_fac", 
                      "IPR013844 : Ribosomal_S4e_N_RNA_bd", "IPR000876 : Ribosomal_S4e", 
                      "IPR008282 : Ribosomal_S3_N", "IPR004037 : Ribosomal_L7Ae", "IPR005998 : Ribosomal_L7_euk", 
                      "IPR002677 : Ribosomal_L32p", "IPR012988 : Ribosomal_L30_N", 
                      "IPR000517 : Ribosomal_L30_core", "IPR016082 : Ribosomal_L30_C", 
                      "IPR002672 : Ribosomal_L28e", "IPR005633 : Ribosomal_L23/L25_N", 
                      "IPR000358 : Ribonucl_redctse", "IPR008926 : Ribnucl_Rdtase_R1-su_N", 
                      "IPR013509 : Ribncl_red_lg_N", "IPR000788 : Ribncl_red_lg_C", 
                      "IPR010999 : Retrovr_matrix_N", "IPR008916 : Retrov_capsid_C", 
                      "IPR013970 : Rep_factor-A_3", "IPR006338 : Reduct_Se", "IPR011941 : Recomb_RAD51", 
                      "IPR001553 : RecA_bac", "IPR007216 : Rcd1", "IPR001806 : Ras_trnsfrmng", 
                      "IPR000156 : RanBP1", "IPR010580 : RAMP4", "IPR013632 : Rad51_C", 
                      "IPR004583 : Rad4", "IPR004806 : Rad23", "IPR004579 : Rad10", 
                      "IPR011041 : Quino_gluc_DHase", "IPR011044 : Quino_amine_DHase_bsu", 
                      "IPR004803 : QtRNA_ribo_trans", "IPR000002 : Fizzy", "IPR002181 : Fibrinogen_a/b/g_C", 
                      "IPR003104 : FH2_actin_bd_DRF", "IPR002713 : FF", "IPR003651 : FeS_bd", 
                      "IPR009078 : Ferritin/RR_like", "IPR011167 : Fe_dep_fumar_hy", 
                      "IPR001670 : Fe_AlcDHase", "IPR014810 : Fcf2", "IPR016156 : FAD/NAD-linked_Rdtase_dimer", 
                      "IPR003097 : FAD-binding_1", "IPR002189 : F-actin_cap_A", "IPR013713 : Exportin_Cse1-like", 
                      "IPR004263 : Exostosin", "IPR006055 : Exonuclease", "IPR013520 : Exonuc_X-T", 
                      "IPR006863 : Evr1_Alr", "IPR006649 : Euk_arc_LSM_core", "IPR007266 : ERO1", 
                      "IPR015090 : Epsilon_antitox", "IPR000781 : Enh_rudimentary", 
                      "IPR001604 : Endonuclease", "IPR003265 : Endo_3c", "IPR004240 : EMP70", 
                      "IPR006816 : ELM", "IPR001884 : EIF5A_hypusine", "IPR011400 : eIF3b", 
                      "IPR007783 : EIF-3_zeta", "IPR006209 : EGF_like", "IPR013091 : EGF_Ca_bd_2", 
                      "IPR001881 : EGF_Ca_bd", "IPR006210 : EGF", "IPR009022 : EFG_III_V", 
                      "IPR004953 : EB1_C", "IPR009039 : EAR", "IPR010309 : E3_ubiquit_lig_DUF908", 
                      "IPR003316 : E2F_TDP", "IPR008250 : E1-E2_ATPase_reg", "IPR001372 : Dynein_light_1/2", 
                      "IPR004942 : Dynein_light-rel", "IPR013602 : Dynein_heavy_N_2", 
                      "IPR013594 : Dynein_heavy_N_1", "IPR004273 : Dynein_heavy", "IPR008603 : Dynactin_p62", 
                      "IPR014891 : DWNN", "IPR011948 : Dullard", "IPR012978 : DUF_NUC173", 
                      "IPR012977 : DUF_NUC130/133_N", "IPR007026 : DUF_CC", "IPR009269 : DUF926", 
                      "IPR010283 : DUF887_TLC", "IPR008590 : DUF872_euk", "IPR008584 : DUF866_euk", 
                      "IPR008521 : DUF803", "IPR008493 : DUF775", "IPR008010 : DUF747_CMV_rcpt", 
                      "IPR007941 : DUF726", "IPR007871 : DUF715", "IPR007808 : DUF701_Zn_bd", 
                      "IPR007785 : DUF689", "IPR006887 : DUF625", "IPR006903 : DUF618", 
                      "IPR006700 : DUF558_MeTrfase_pred", "IPR007317 : DUF410", "IPR005631 : DUF339", 
                      "IPR005181 : DUF303_acetylest", "IPR004353 : DUF254_SAND", "IPR004853 : DUF250", 
                      "IPR008166 : DUF23", "IPR002550 : DUF21", "IPR015399 : DUF1977_DnaJ-like", 
                      "IPR015166 : DUF1922", "IPR015023 : DUF1909", "IPR014934 : DUF1806", 
                      "IPR014806 : DUF1782", "IPR013957 : DUF1777", "IPR013865 : DUF1754_euk", 
                      "IPR013697 : DUF1744", "IPR003750 : DUF171", "IPR012875 : DUF1674", 
                      "IPR003734 : DUF155", "IPR008217 : DUF125_TM", "IPR010541 : DUF1115", 
                      "IPR009378 : DUF1032", "IPR001269 : Du_synth", "IPR007453 : DsrC-like", 
                      "IPR001159 : Ds_RNA_bd", "IPR011430 : DRIM", "IPR012725 : DnaK_prok", 
                      "IPR014939 : DNA_replication_fac_CDT1-like", "IPR016467 : DNA_repair_recomb_RecA-like", 
                      "IPR006166 : DNA_repair_nuc_XPF/helicase", "IPR004340 : DNA_primase_UL52/UL70_Herpvir", 
                      "IPR014052 : DNA_primase_S_euk_arch", "IPR007015 : DNA_pol_V", 
                      "IPR000477 : DNA_pol_RVTase", "IPR008921 : DNA_pol_III_clamp-loader_C", 
                      "IPR017061 : DNA_pol_eta", "IPR010372 : DNA_pol3_delta", "IPR014763 : DNA_mismatch_repair_N", 
                      "IPR017261 : DNA_mismatch_repair_Msh6", "IPR000212 : DNA_helicase_UvrD/REP", 
                      "IPR014017 : DNA_helicase_UvrD-like_C", "IPR004589 : DNA_helicase_ATP-dep_RecQ", 
                      "IPR001529 : DNA-dir_RNA_pol_M/15kDsu", "IPR010996 : DNA-dir_DNA_pol_X_beta-like_N", 
                      "IPR005792 : Disulphide_isom", "IPR005788 : Disulph_isom", "IPR001796 : DHFR_reg", 
                      "IPR012262 : DHFR-TS", "IPR002198 : DHase_sc/Rdtase_SDR", "IPR001017 : DHase_E1", 
                      "IPR008180 : DeoxyUTPase", "IPR014876 : DEK_C", "IPR004177 : DDHD", 
                      "IPR003232 : dCTP_deaminase", "IPR001206 : DAGKc", "IPR000756 : DAGKa", 
                      "IPR007130 : DAGAT", "IPR002219 : DAG_PE_bd", "IPR017117 : D-site_20S_pre-rRNA_nuclease", 
                      "IPR003204 : Cyt_c_ox5A", "IPR010980 : Cyt_c_b562", "IPR006150 : Cys_repeat_1", 
                      "IPR013922 : Cyclin_related_2", "IPR011028 : Cyclin_like", "IPR016159 : Cullin_repeat-like", 
                      "IPR000859 : CUB", "IPR015798 : Cu_amine_oxidase_C", "IPR004468 : CTP_synthase", 
                      "IPR006595 : CTLH_C", "IPR004829 : Csurface_antigen", "IPR002059 : CSP_DNA_bd", 
                      "IPR011129 : CSP", "IPR008273 : CRAL_bd_TRIO_N", "IPR007715 : Coq4", 
                      "IPR013714 : COPI_assoc", "IPR007274 : Cop_transporter", "IPR008985 : ConA_like_lec_gl", 
                      "IPR002108 : Cofilin_actin_bd", "IPR004226 : CofA_tubulin_bd", 
                      "IPR005674 : CocE_NonD_hydro", "IPR006822 : Coatomer_esu", "IPR010714 : Coatomer_asu_C", 
                      "IPR000421 : Coagulation_factor_5/8-type_C", "IPR005811 : CoA_ligase", 
                      "IPR005809 : CoA_lig_beta", "IPR005810 : CoA_lig_alpha", "IPR000595 : cNMP_bd", 
                      "IPR004871 : Cleav_polyA_spec_factor_asu_C", "IPR010953 : Citrate_synthase_typ-II", 
                      "IPR016141 : Citrate_synthase-like_core", "IPR002020 : Citrate_synthase-like", 
                      "IPR004395 : CHP00091", "IPR004383 : CHP00048", "IPR002701 : Chorismate_mut", 
                      "IPR001811 : Chemokine_IL8", "IPR001476 : Chaprnonin_Cpn10", 
                      "IPR003874 : CDC45_like", "IPR013855 : Cdc37_N", "IPR001060 : Cdc15_Fes_CIP4", 
                      "IPR006509 : CC1_SF", "IPR011629 : Cbl_biosynth_CobW-like_C", 
                      "IPR003495 : Cbl_biosynth_CobW-like", "IPR004802 : Cbf5_synth", 
                      "IPR005612 : CBF", "IPR004798 : Cax", "IPR014882 : CathepsinC_exc", 
                      "IPR005043 : CAS_CSE1_C", "IPR000022 : Carboxyl_trans", "IPR000631 : Carbohydrate_kinase", 
                      "IPR002018 : CarbesteraseB", "IPR005481 : CarbamoylP_synth_lsu_N", 
                      "IPR005479 : CarbamoylP_synth_lsu_ATP-bd", "IPR002373 : cAMP/cGMP_kin", 
                      "IPR011038 : Calycin_like", "IPR005782 : Calcium_ATPase", "IPR004324 : BT1", 
                      "IPR002093 : BRCA2_repeat", "IPR011591 : Botulinum", "IPR002634 : BolA", 
                      "IPR002860 : BNR", "IPR005482 : Biotin_COase_C", "IPR004472 : BioD_synth", 
                      "IPR005815 : BioA", "IPR012079 : Bifunc_Ald/AlcDHase", "IPR006994 : bHLH_Nulp1", 
                      "IPR001466 : Beta_lactamase", "IPR011421 : BCNT", "IPR011764 : BC", 
                      "IPR001107 : Band_7", "IPR006560 : AWS", "IPR007243 : Autophagy_prot_6", 
                      "IPR007134 : Autophagy_N", "IPR007135 : Autophagy_C", "IPR003338 : ATPaseVAT_N", 
                      "IPR012089 : ATPase_YdaO", "IPR004908 : ATPase_V1_H", "IPR005772 : ATPase_V1_F_euk", 
                      "IPR004907 : ATPase_V1_c", "IPR005723 : ATPase_V1_B", "IPR005725 : ATPase_V1_A", 
                      "IPR008218 : ATPase_V1/A1_F", "IPR002842 : ATPase_V1/A1_E", "IPR002699 : ATPase_V1/A1_D", 
                      "IPR016727 : ATPase_V0_d", "IPR011555 : ATPase_V0_c_euk", "IPR000245 : ATPase_V0_c", 
                      "IPR002843 : ATPase_V0/A0_c/d", "IPR002490 : ATPase_V0/A0_116", 
                      "IPR004014 : ATPase_P_cat_N", "IPR006068 : ATPase_P_cat_C", "IPR001757 : ATPase_P", 
                      "IPR000711 : ATPase_F1_OSCP/d", "IPR000131 : ATPase_F1_gamma", 
                      "IPR006721 : ATPase_F1_e_mt", "IPR001469 : ATPase_F1_d/e", "IPR005722 : ATPase_F1_b", 
                      "IPR005294 : ATPase_F1_a", "IPR000454 : ATPase_F0_c", "IPR002379 : ATPase_F0/V0_c", 
                      "IPR000194 : ATPase_a_b_nl_bd", "IPR004100 : ATPase_a_b_N", "IPR000793 : ATPase_a_b_C", 
                      "IPR000749 : ATP-gua_Ptrans", "IPR009604 : Ataxin-2_N", "IPR009818 : Ataxin-2_C", 
                      "IPR000637 : AT_hook_DNA_bd", "IPR003348 : ArsA_ATPase", "IPR001606 : ARID", 
                      "IPR000177 : Apple", "IPR001719 : AP_endonuc_F2", "IPR002680 : AOX", 
                      "IPR012513 : Antimicrobial10", "IPR007928 : Antifreeze_CF", "IPR006818 : Anti-silence", 
                      "IPR002110 : ANK", "IPR004839 : Aminotrans_I/II", "IPR005814 : Aminotrans_3", 
                      "IPR002937 : Amino_oxidase", "IPR001283 : Allrgn_V5/Tpx1", "IPR005599 : Alg9_trans", 
                      "IPR004856 : Alg6_Alg8", "IPR000741 : Aldolase_I", "IPR016161 : Ald_DHase/Histidinol_DHase", 
                      "IPR013149 : AlcDHase_Zn-bd", "IPR013154 : AlcDHase_GroES-like", 
                      "IPR002775 : Alba_bd", "IPR007886 : Ala_DHase/PNT_N", "IPR007698 : Ala_DHase/PNT_C", 
                      "IPR013538 : AHSA1", "IPR000866 : AhpC-TSA", "IPR005654 : AFG1_ATPase", 
                      "IPR001055 : Adrenodoxin", "IPR012511 : AdoMetDC_leader", "IPR007862 : Adenylate_kinase_Znf_lid", 
                      "IPR006259 : Adenyl_kin_sub", "IPR002113 : Aden_trnslctor", "IPR000043 : Ad_hcy_hydrolase", 
                      "IPR011769 : Ad_Ct_kin_N", "IPR001792 : Acylphosphatase", "IPR014043 : Acyl_transferase", 
                      "IPR003231 : Acyl_carrier", "IPR000582 : Acyl-CoA-binding_protein", 
                      "IPR004000 : Actin_like", "IPR008999 : Actin_crosslink", "IPR009081 : ACP_like", 
                      "IPR000573 : AconitaseA/IPMdHydase_ssu_swvl", "IPR006249 : Aconitase/Fe_reg_prot_2", 
                      "IPR015928 : Aconitase/3IPM_dehydase_swvl", "IPR001030 : Acoase/IPM_deHydtase_lsu_aba", 
                      "IPR011904 : Ac_CoA_lig_AcsA", "IPR010509 : ABC_Ald_N", "IPR004147 : ABC_1", 
                      "IPR013094 : AB_hydrolase_3", "IPR003089 : AB_hydrolase", "IPR007946 : AAR2", 
                      "IPR005938 : AAA_CDC48", "IPR003959 : AAA_ATPase_core", "IPR011704 : AAA_5", 
                      "IPR013093 : AAA_2", "IPR003593 : AAA+_ATPase_core", "IPR006195 : aa-tRNA-synth_II", 
                      "IPR002314 : aa-tRNA-synt_IIb", "IPR001054 : A/G_cyclase", "IPR008927 : 6DGDH_C_like", 
                      "IPR006179 : 5_nucleotidase", "IPR002421 : 5_3_exonuclease", 
                      "IPR008334 : 5'-Nucleotdase_C", "IPR001450 : 4Fe4S_Fe_S_bd", 
                      "IPR008278 : 4-PPT_transf", "IPR001104 : 3-oxo-5_a-steroid_4-DHase_C", 
                      "IPR011603 : 2oxoglutarate_DHase_E1", "IPR001078 : 2Oxoacid_DHase", 
                      "IPR005123 : 2OG-FeII_Oase", "IPR016642 : 26S_Psome_Rpn2", "IPR016643 : 26S_Psome_Rpn1", 
                      "IPR005937 : 26S_proteasome_P45", "IPR006407 : 1-4-A-glucan_branch_enz_core", 
                      "IPR000433 : Znf_ZZ", "IPR004457 : Znf_ZPR1", "IPR001607 : Znf_UBP", 
                      "IPR013085 : Znf_U1-C", "IPR003604 : Znf_U1", "IPR001293 : Znf_TRAF", 
                      "IPR001222 : Znf_TFIIS", "IPR013137 : Znf_TFIIB", "IPR000197 : Znf_TAZ", 
                      "IPR007527 : Znf_SWIM", "IPR006895 : Znf_Sec23_Sec24", "IPR014857 : Znf_RING-like", 
                      "IPR011016 : Znf_RING-CH", "IPR001841 : Znf_RING", "IPR001876 : Znf_RanBP2", 
                      "IPR006642 : Znf_Rad18_put", "IPR006564 : Znf_PMZ", "IPR019787 : Znf_PHD-finger", 
                      "IPR001965 : Znf_PHD", "IPR001510 : Znf_PARP", "IPR000967 : Znf_NFX1", 
                      "IPR013993 : Znf_N-recognin_met", "IPR003126 : Znf_N-recognin", 
                      "IPR002893 : Znf_MYND", "IPR004181 : Znf_MIZ", "IPR019584 : Znf_LITAF-like", 
                      "IPR001781 : Znf_LIM", "IPR001628 : Znf_hrmn_rcpt", "IPR007529 : Znf_HIT", 
                      "IPR013192 : Znf_HCV_NS5a", "IPR010666 : Znf_GRF", "IPR000679 : Znf_GATA", 
                      "IPR011011 : Znf_FYVE_PHD", "IPR017455 : Znf_FYVE-rel", "IPR000306 : Znf_FYVE", 
                      "IPR001594 : Znf_DHHC", "IPR001878 : Znf_CCHC", "IPR000571 : Znf_CCCH", 
                      "IPR002867 : Znf_C6HC", "IPR018957 : Znf_C3HC4_RING-type", "IPR009349 : Znf_C2HC5", 
                      "IPR000690 : Znf_C2H2_matrin", "IPR014898 : Znf_C2H2_LYAR", "IPR019406 : Znf_C2H2_APLF-like", 
                      "IPR015880 : Znf_C2H2-like", "IPR007087 : Znf_C2H2", "IPR020457 : Znf_B-box_chordata", 
                      "IPR000315 : Znf_B-box", "IPR000058 : Znf_AN1", "IPR003689 : ZIP", 
                      "IPR013880 : Yos1", "IPR006056 : YjgF-like", "IPR004443 : YjeF_N", 
                      "IPR006977 : Yip1", "IPR012506 : YhhN", "IPR005033 : YEATS", 
                      "IPR007214 : YbaK/aa-tRNA-synth-assoc-reg", "IPR006031 : XYPPX", 
                      "IPR001945 : XPGD_DNA_repair", "IPR006084 : XPGC_Rad_DNA_repair", 
                      "IPR001161 : XPGB_DNA_repair", "IPR006086 : XPG_I", "IPR006085 : XPG_DNA_repair_N", 
                      "IPR015360 : XPC-bd", "IPR018123 : WWE-dom_subgr", "IPR004170 : WWE-dom", 
                      "IPR001202 : WW_Rsp5_WWP", "IPR008197 : Whey_acidic_protein_4-diS_core", 
                      "IPR003124 : WH2_actin_bd", "IPR008893 : WGR", "IPR017422 : WD_repeat_p55", 
                      "IPR019781 : WD40_repeat_sg", "IPR017986 : WD40_repeat_dom", 
                      "IPR019782 : WD40_repeat_2", "IPR011046 : WD40_repeat-like_dom", 
                      "IPR001680 : WD40_repeat", "IPR011026 : WASP_C", "IPR002035 : VWF_A", 
                      "IPR013995 : VPS9_sub", "IPR003123 : VPS9", "IPR007234 : Vps53_N", 
                      "IPR014812 : Vps51", "IPR015415 : Vps4_C", "IPR005378 : Vps35", 
                      "IPR005377 : Vps26", "IPR007586 : VP8_pox_nuc_bd", "IPR006587 : VIT_met", 
                      "IPR003365 : Viral_rep_N", "IPR009013 : Viral_attachment_fibre_shaft", 
                      "IPR006077 : Vinculin/catenin", "IPR003128 : Villin_headpiece", 
                      "IPR002014 : VHS", "IPR009008 : Val/Leu/Ile-tRNA-synth_Ia_edit", 
                      "IPR019754 : Val-tRNA_synth_Ia_N", "IPR002303 : Val-tRNA_synth_Ia", 
                      "IPR004353 : Vacuolar_fusion_protein_MON1", "IPR013155 : V/L/I-tRNA-synth_anticodon-bd", 
                      "IPR007705 : V-SNARE", "IPR005124 : V-ATPase_G", "IPR000305 : UvrC_N", 
                      "IPR015221 : Urm1", "IPR000764 : Uridine_kinase", "IPR006035 : Ureohydrolase", 
                      "IPR005122 : Uracil-DNA_glycosylase-like", "IPR000631 : UPF_carb_kinase-rel", 
                      "IPR013887 : UPF0592", "IPR018886 : UPF0547", "IPR018908 : UPF0546", 
                      "IPR019146 : UPF0406", "IPR014999 : UPF0371", "IPR005373 : UPF0183", 
                      "IPR005365 : UPF0171", "IPR004401 : UPF0133", "IPR005343 : UPF0120", 
                      "IPR002737 : UPF0103/Memo-related", "IPR004255 : UPF0089", "IPR001378 : UPF0066", 
                      "IPR000612 : UPF0057", "IPR001602 : UPF0047", "IPR001498 : UPF0029_Impact_N", 
                      "IPR001233 : UPF0027", "IPR000979 : UPF0025", "IPR003402 : Unk_Met10", 
                      "IPR020171 : Uncharacterised_RC0039", "IPR006675 : Unchar_HDIG", 
                      "IPR004521 : Unchar_dom_2", "IPR006266 : UMP_CMP_kinase", "IPR004854 : UFD1", 
                      "IPR016267 : UDPGP_trans_sub", "IPR002618 : UDPGP_trans", "IPR004689 : UDPgal_transpt", 
                      "IPR002043 : UDNA_glycsylse", "IPR005113 : uDENN", "IPR008323 : UCP033563", 
                      "IPR012042 : UCP016487_CYTH-contain", "IPR016607 : UCP013022", 
                      "IPR012033 : UCP006600", "IPR001012 : UBX", "IPR000608 : UBQ-conjugat_E2", 
                      "IPR016135 : UBQ-conjugat/RWD-like", "IPR000011 : UBQ-activ_enz_E1-like", 
                      "IPR018075 : UBQ-activ_enz_E1", "IPR003613 : Ubox_domain", "IPR017390 : Ubiquitinyl_hydrolase_UCH37", 
                      "IPR019955 : Ubiquitin_supergroup", "IPR019956 : Ubiquitin_subgroup", 
                      "IPR003903 : Ubiquitin-int_motif", "IPR019572 : Ubiquitin-activating_enzyme", 
                      "IPR000626 : Ubiquitin", "IPR000127 : UBact_repeat", "IPR015940 : UBA/transl_elong_EF1B_N_euk", 
                      "IPR000449 : UBA/transl_elong_EF1B_N", "IPR009060 : UBA-like", 
                      "IPR019474 : Ub_conjug_fac_E4_core", "IPR018965 : Ub-activating_enz_e1_C", 
                      "IPR006577 : UAS", "IPR013657 : UAA", "IPR016654 : U6_snRNA_Lsm2", 
                      "IPR010280 : U5_MeTrfase", "IPR013949 : U3_snoRNA_assoc-6", "IPR018983 : U3_snoRNA-assocProt_15_C", 
                      "IPR009145 : U2_small", "IPR016485 : TyrRS_arch_euk", "IPR001245 : Tyr_prot_kinase_cat_dom", 
                      "IPR017867 : Tyr_phospatase_low_mol_wt", "IPR000106 : Tyr_phospatase/Ars_reductase", 
                      "IPR000242 : Tyr_Pase_rcpt/non-rcpt", "IPR003595 : Tyr_Pase_cat", 
                      "IPR007482 : Tyr_Pase-like_PTPLA", "IPR002307 : Tyr-tRNA-synth_Ib_bac/mito", 
                      "IPR010347 : Tyr-DNA_phospho", "IPR008983 : Tumour_necrosis_fac-like", 
                      "IPR019746 : Tubulin_FtsZ_N", "IPR003008 : Tubulin_FtsZ_GTPase", 
                      "IPR018316 : Tubulin/FtsZ_2-layer-sand-dom", "IPR000217 : Tubulin", 
                      "IPR000007 : Tubby_C", "IPR004344 : Tub_tyr_ligase", "IPR008280 : Tub_FtsZ_C", 
                      "IPR004647 : TtdB_fumA_fumB", "IPR004646 : TtdA_fumA_fumB", "IPR008883 : Tsg101", 
                      "IPR018227 : Tryptophan/tyrosine_permease", "IPR013059 : Trp_tyr_transpt", 
                      "IPR002306 : Trp-tRNA-synth_Ib", "IPR009080 : tRNAsynth_1a_anticodon-bd", 
                      "IPR012947 : tRNA_SAD", "IPR002616 : tRNA_ribo_trans", "IPR016691 : tRNA_mtfrase_TRM11", 
                      "IPR014816 : tRNA_MeTrfase_cplx_GCD14_su", "IPR016009 : tRNA_m1G_MeTrfase", 
                      "IPR006678 : tRNA_intron_Endonuc_N", "IPR006677 : tRNA_intron_Endonuc_cat-like", 
                      "IPR001269 : tRNA_hU_synthase", "IPR018022 : tRNA_delta_PyrP_Trfase", 
                      "IPR010978 : tRNA_bd_arm", "IPR002547 : tRNA_bd", "IPR003358 : tRNA_(Gua-N-7)_MeTrfase", 
                      "IPR014758 : tRNA-synt_met_N", "IPR002315 : tRNA-synt_gly", "IPR002905 : TRM_MeTrfase", 
                      "IPR000652 : Triosephosphate_isomerase", "IPR011004 : Trimer_LpxA-like", 
                      "IPR011017 : TRASH", "IPR016721 : TRAPP_I_complex_Bet3", "IPR007194 : TRAPP_component", 
                      "IPR004332 : Transposase_MuDR", "IPR002559 : Transposase_11", 
                      "IPR015378 : Transposase-like_Mu_C", "IPR007277 : Transmembrane_adaptor_Erv26", 
                      "IPR019561 : Translocon_Sec61/SecY_plug_dom", "IPR002848 : Translin", 
                      "IPR018105 : Translational_control_tumour_p", "IPR008991 : Translation_prot_SH3-like", 
                      "IPR001983 : Translat-control_tumour-assoc", "IPR010923 : Transl_SUA5", 
                      "IPR016190 : Transl_init_fac_IF2/IF5_Zn-bd", "IPR016189 : Transl_init_fac_IF2/IF5_N", 
                      "IPR002735 : Transl_init_fac_IF2/IF5", "IPR017334 : Transl_init_eIF-3_RNA-bind", 
                      "IPR009000 : Transl_elong_init/rib_B-barrel", "IPR020189 : Transl_elong_IF5A_C", 
                      "IPR001884 : Transl_elong_IF5A", "IPR014038 : Transl_elong_fac_EF1B_bsu/dsu", 
                      "IPR004160 : Transl_elong_EFTu/EF1A_C", "IPR004161 : Transl_elong_EFTu/EF1A_2", 
                      "IPR005517 : Transl_elong_EFG/EF2_IV", "IPR000640 : Transl_elong_EFG/EF2_C", 
                      "IPR004539 : Transl_elong_EF1A_euk/arc", "IPR009001 : Transl_elong_EF1A/Init_IF2_C", 
                      "IPR001662 : Transl_elong_EF1_G_con", "IPR005474 : Transketolase_N", 
                      "IPR005476 : Transketolase_C", "IPR005478 : Transketolase_bac-like", 
                      "IPR005475 : Transketolase-like_Pyr-bd", "IPR009014 : Transketo_C/Pyr-ferredox_oxred", 
                      "IPR008958 : Transglutaminase_C", "IPR002931 : Transglutaminase-like", 
                      "IPR013890 : Transcrip_repressor_Tup1_N", "IPR004333 : Transcpt_factor_SBP-box", 
                      "IPR002792 : TRAM", "IPR008974 : TRAF-like", "IPR019734 : TPR_repeat", 
                      "IPR013026 : TPR_region", "IPR013105 : TPR_2", "IPR001440 : TPR-1", 
                      "IPR011766 : TPP_enzyme_bd_C", "IPR007371 : TPK_catalytic", "IPR007373 : TPK_B1_bd", 
                      "IPR006171 : Toprim_domain", "IPR006154 : Toprim_dom_subgr", 
                      "IPR001154 : TopoII_euk", "IPR009054 : TopoI_insert_euk", "IPR013760 : Topo_IIA_cen", 
                      "IPR002288 : Topo_IIA_B_C", "IPR013506 : Topo_IIA_B_2", "IPR001241 : Topo_IIA_B/N", 
                      "IPR000565 : Topo_IIA_B", "IPR002205 : Topo_IIA_A/C", "IPR003602 : Topo_IA_DNA_bd", 
                      "IPR000380 : Topo_IA_core", "IPR013497 : Topo_IA_cen", "IPR003601 : Topo_IA_2", 
                      "IPR020474 : Toll-like_rcpt_LRR", "IPR014161 : Tol-Pal_TolA", 
                      "IPR001368 : TNFR_Cys_rich_reg", "IPR005016 : TMS_TDE", "IPR006571 : TLDc", 
                      "IPR006634 : TLC-dom", "IPR001187 : Tissue_factor", "IPR010339 : TIP49_C", 
                      "IPR001950 : TIF_SUI1", "IPR001040 : TIF_eIF_4E", "IPR001253 : TIF_eIF-1A", 
                      "IPR000716 : Thyroglobulin_1", "IPR000062 : Thymidylate_kin-like", 
                      "IPR018094 : Thymidylate_kin", "IPR001267 : Thymidine_kinase", 
                      "IPR004114 : THUMP", "IPR005789 : Thr_deHydtase_2", "IPR018163 : Thr/Ala-tRNA-synth_IIc_edit", 
                      "IPR018158 : Thr-tRNA-synth_IIa_cons-reg", "IPR002320 : Thr-tRNA-synth_IIa", 
                      "IPR013766 : Thioredoxin_domain", "IPR006662 : Thioredoxin-like_subdom", 
                      "IPR012336 : Thioredoxin-like_fold", "IPR017936 : Thioredoxin-like", 
                      "IPR005746 : Thioredoxin", "IPR005982 : Thioredox_Rdtase", "IPR016039 : Thiolase-like", 
                      "IPR002818 : ThiJ/PfpI", "IPR000594 : ThiF_NAD_FAD_bd", "IPR006282 : Thi_PPkinase", 
                      "IPR001938 : Thaumatin", "IPR012676 : TGS-like", "IPR004095 : TGS", 
                      "IPR003618 : TFIIS_centre", "IPR007309 : TFIIIC_Bblock_bd", "IPR004595 : TFIIH_C1_C", 
                      "IPR017935 : TFIIE_bsu-like_DNA-bd", "IPR005936 : Pept_M41_FtsH", 
                      "IPR002467 : Pept_M24A_MAP1", "IPR010168 : Pept_M20D_amidohydro", 
                      "IPR017439 : Pept_M20D_AA028/carboxypep-Ss1", "IPR001309 : Pept_C14_ICE_p20", 
                      "IPR011600 : Pept_C14_cat", "IPR009007 : Pept_Aspartc_cat", "IPR001449 : PEP_COase", 
                      "IPR004405 : PelA", "IPR001478 : PDZ", "IPR002073 : PDEase", 
                      "IPR000682 : PCMT", "IPR016720 : PC_Trfase_euk", "IPR004155 : PBS_lyase_HEAT", 
                      "IPR004545 : Pap_1", "IPR003609 : Pan_app", "IPR003014 : PAN", 
                      "IPR016657 : PAGM", "IPR006515 : PABP_1234", "IPR011658 : PA14", 
                      "IPR008907 : P25-alpha", "IPR001433 : OxRdtase_FAD/NAD_bd", "IPR006844 : OST3_OST6", 
                      "IPR007220 : ORC2", "IPR012904 : OGG_N", "IPR005549 : Nuf2", 
                      "IPR000086 : NUDIX_hydrolase_core", "IPR015797 : NUDIX", "IPR007758 : Nucleoporin_Nsp1_C", 
                      "IPR015194 : Nucl_remodel_ATPase_ISWI_HAND", "IPR013346 : NrdE_NrdA", 
                      "IPR000800 : Notch_region", "IPR007276 : Nop14", "IPR002873 : Non-struct_prot_NSP3_Rotavir", 
                      "IPR004030 : NO_synthase_oxygenase_reg", "IPR013255 : Ndc80_Spc25", 
                      "IPR005550 : Ndc80_HEC", "IPR016641 : Nas_poly-pep-assoc_cplx_asu", 
                      "IPR006109 : NAD_Gly3P_DHase_C", "IPR011128 : NAD-dep_Gly3P_DHase_N", 
                      "IPR006168 : NAD-dep_Gly3P_DHase", "IPR016040 : NAD(P)-bd", "IPR006153 : Na_H_porter", 
                      "IPR002941 : N6/N4_Mtase", "IPR002296 : N12N6_MeTrfase", "IPR011322 : N-reg_PII-like_a/b", 
                      "IPR000857 : MyTH4", "IPR011057 : Mss4_like", "IPR006797 : MSF1", 
                      "IPR011014 : MscS_channel_TM-2", "IPR013170 : mRNA_splic_Cwf21", 
                      "IPR007281 : Mre11_DNA_bd", "IPR005304 : Mra1", "IPR007248 : Mpv17_PMP22", 
                      "IPR003639 : Mov34-1", "IPR003409 : MORN", "IPR016124 : Mog1/PsbP/DUF1795_a/b/a-sand", 
                      "IPR007681 : Mog1", "IPR009036 : MoeB", "IPR002938 : mOase_FAD_bd", 
                      "IPR013878 : Mo25", "IPR013646 : MMR_HSR1_C", "IPR015222 : Mmp37", 
                      "IPR001993 : Mitoch_carrier", "IPR006466 : MiaB_like_B", "IPR016196 : MFS_gen_sb_transpt", 
                      "IPR007114 : MFS", "IPR003358 : MeTrfase_4", "IPR013048 : Meiotic_Spo11", 
                      "IPR007018 : Mediator_cplx_su-6", "IPR009244 : MED7", "IPR001208 : MCM", 
                      "IPR013729 : MBF1_N", "IPR002083 : MATH", "IPR007315 : Mannosyl_trans2", 
                      "IPR001229 : Mannose-bd_lectin", "IPR007704 : Mannos_trans_DXD", 
                      "IPR000998 : MAM", "IPR016036 : Malonyl_transacylase_ACP-bd", 
                      "IPR011275 : Malate_DHase_NAD-dep_bac", "IPR000535 : Major_sperm", 
                      "IPR015257 : Maf1", "IPR016688 : M_At2g17000_prd", "IPR004882 : LUC7_rel", 
                      "IPR007307 : LTV", "IPR003591 : LRR_sub-typ", "IPR006553 : LRR_cys_sub-typ", 
                      "IPR013101 : LRR_2", "IPR001611 : LRR", "IPR011012 : Longin_like", 
                      "IPR013209 : LNS2", "IPR004562 : Lipoyltrans", "IPR001024 : LipOase_LH2", 
                      "IPR006258 : Lipoamide_DHase", "IPR007651 : Lipin_N", "IPR011685 : LETM1", 
                      "IPR004043 : LCCL", "IPR005547 : LAG1", "IPR015955 : Lactate_DHase/Glyco_Ohase_4_C", 
                      "IPR001236 : Lactate/malate_DHase", "IPR001557 : L-lactate/malate_DHase", 
                      "IPR013806 : Kringle-like", "IPR000001 : Kringle", "IPR007851 : Kri1", 
                      "IPR003101 : KIX", "IPR011009 : Kinase_like", "IPR013926 : Kinase_bd_CGI-121", 
                      "IPR014030 : Ketoacyl_synth_N", "IPR014031 : Ketoacyl_synth_C", 
                      "IPR013518 : K_chnl_inward-rec_Kir_cyto", "IPR013521 : K_chnl_inward-rec_Kir_Cr2", 
                      "IPR003929 : K_chnl_Ca-activ_BK_asu", "IPR006155 : Josephin", 
                      "IPR008654 : IWS1_C", "IPR001804 : IsoCit_IM_DHase", "IPR004790 : IsoCit_DHase_NADP-dep_euk", 
                      "IPR011339 : ISC_FeS_clus_asmbl_IscU", "IPR011593 : IPPtrans_like", 
                      "IPR004323 : Ion_tolerance_CutA1", "IPR008964 : Invasin_intimin", 
                      "IPR006141 : Intein_splicing_site", "IPR016133 : Insect_antifreeze_prot", 
                      "IPR000760 : Inositol_P", "IPR002652 : Importin-a-like_IBB-bd", 
                      "IPR001093 : IMP_DHase_GMPRtase", "IPR003891 : IF_eIF4G_MA3", 
                      "IPR001404 : Hsp90", "IPR004491 : HslU", "IPR006562 : HSA", "IPR009643 : HS1_bd", 
                      "IPR010997 : HRDC_like", "IPR002121 : HRDC", "IPR009057 : Homeodomain_like", 
                      "IPR000135 : HMG_1/2_box_subgr", "IPR000910 : HMG_1/2_box", "IPR009071 : HMG-box", 
                      "IPR001310 : HIT", "IPR015418 : Hist_AcTrfase_NuA4_cplx", "IPR000445 : HhH", 
                      "IPR000815 : Hg_reductase", "IPR000361 : HesB_yadR_yfhF-like", 
                      "IPR002660 : Herpes_UL6", "IPR011722 : Hemryth_DNA_bd", "IPR014016 : Helicase_SF1_UvrD-rel", 
                      "IPR014012 : Helicase/SANT-assoc_DNA_bd", "IPR003587 : Hedgehog_hint_N", 
                      "IPR016153 : Heat_shock_Hsp33_N", "IPR009073 : Heat_shock_cognate_B_oligo_C", 
                      "IPR013194 : HDAC_interact", "IPR006370 : HB_polyprenyl-transferase", 
                      "IPR013999 : HAS_subgroup", "IPR002637 : Ham1p_like", "IPR006861 : HABP4_PAIRBP1_bd", 
                      "IPR012562 : GUCT", "IPR005289 : GTP_bd", "IPR004046 : GST_C", 
                      "IPR009012 : GrpE_head", "IPR000740 : GrpE", "IPR011032 : GroES_like", 
                      "IPR008950 : GroEL-ATPase", "IPR012723 : GroEL", "IPR001437 : GreA_GreB_reg", 
                      "IPR007583 : GRASP55_65", "IPR002076 : GNS1_SUR4", "IPR004739 : GMP_synth_N", 
                      "IPR001674 : GMP_synth_C", "IPR007867 : GMC_OxRtase_C", "IPR000172 : GMC_OxRdtase_N", 
                      "IPR012132 : GMC_OxRdtase", "IPR014830 : Glycolipid_transfer_prot", 
                      "IPR000715 : Glyco_trans_4", "IPR001830 : Glyco_trans_20", "IPR006424 : Glyceraldehyde-3-P_DHase_1", 
                      "IPR000173 : GlycerAld_3-P_DHase", "IPR001085 : Gly_HO-MeTrfase", 
                      "IPR004480 : Glutredox-rel", "IPR014025 : Glutaredoxin_sub", 
                      "IPR000889 : Glut_peroxidase", "IPR011529 : Glu_5kinase_bact", 
                      "IPR001057 : Glu_5kinase", "IPR000924 : Glu/Gln-tRNA-synth_Ic", 
                      "IPR012134 : Glu-5-SA_DHase", "IPR009050 : Globin_like", "IPR004809 : Gln_synth_I", 
                      "IPR008147 : Gln_synt_beta", "IPR005855 : GlmS_trans", "IPR002347 : Glc/ribitol_DHase", 
                      "IPR010492 : GINS_Psf3", "IPR000965 : Gglut_pp_reduct", "IPR004129 : GDPD", 
                      "IPR000991 : GATase_class1_C", "IPR011702 : GATASE", "IPR007504 : Gar1_RNA_bd", 
                      "IPR015299 : Gamete_antigen_PLAspp", "IPR011024 : G_crystallin_rel", 
                      "IPR004112 : Fum_Rdtase/Succ_DHase_flav_C", "IPR015939 : Fum_Rdtase/Succ_DH_flav-like_C", 
                      "IPR003378 : Fringe-like", "IPR002908 : Frataxin_like", "IPR001709 : FPN_cyt_redctse", 
                      "IPR003961 : FN_III", "IPR001678 : Fmu_NOL1/Nop2p", "IPR006539 : Flippase", 
                      "IPR001094 : Flavdoxin_like", "IPR004327 : Phstyr_phstse_ac", 
                      "IPR006163 : Phsphopanteth_bd", "IPR000909 : Phospholipase_C_Pinositol-sp_X", 
                      "IPR007000 : Phospholipase_B-like", "IPR016090 : Phospholipase_A2", 
                      "IPR001576 : Phosphoglycerate_kinase", "IPR000023 : Phosphofructokinase", 
                      "IPR014019 : Phosphatase_tensin-typ", "IPR001200 : Phosducin", 
                      "IPR005345 : PHF5", "IPR002319 : Phenylalanyl-tRNA_Synthase_acu", 
                      "IPR004531 : Phe-tRNA-synth_IIc_bsu_arc", "IPR004529 : Phe-tRNA-synth_IIc_asu", 
                      "IPR005995 : Pgm_bpd_ind", "IPR013078 : PG_mutase", "IPR011183 : PfpB_PPi_PFK", 
                      "IPR002777 : PFD_beta-like", "IPR004127 : PFD_alpha-like", "IPR011599 : PFD_alpha", 
                      "IPR006708 : Pex19", "IPR006785 : Pex14_N", "IPR001667 : Pesterase_RecJ", 
                      "IPR003156 : Pesterase_DHHA1", "IPR010613 : Pescadillo_N", "IPR019479 : Peroxiredoxin_C", 
                      "IPR004841 : Permease_region", "IPR009765 : Pericardin_rpt", 
                      "IPR002477 : Peptidoglycan-bd-like", "IPR002569 : Peptide_Met_Sox_Rdtase_MsrA", 
                      "IPR004106 : Peptidase_S9A_N", "IPR001375 : Peptidase_S9", "IPR007230 : Peptidase_S59", 
                      "IPR002610 : Peptidase_S54_rhomboid", "IPR008758 : Peptidase_S28", 
                      "IPR001733 : Peptidase_S26B", "IPR015927 : Peptidase_S24_S26A/B/C", 
                      "IPR019759 : Peptidase_S24_S26_cons-reg", "IPR001984 : Peptidase_S16_C", 
                      "IPR001577 : Peptidase_M8", "IPR001915 : Peptidase_M48", "IPR017861 : Peptidase_M22_subgr", 
                      "IPR000905 : Peptidase_M22", "IPR001160 : Peptidase_M20C", "IPR010161 : Peptidase_M20B", 
                      "IPR011650 : Peptidase_M20_dimer", "IPR002933 : Peptidase_M20", 
                      "IPR014782 : Peptidase_M1_N", "IPR001948 : Peptidase_M18", "IPR013578 : Peptidase_M16C_assoc", 
                      "IPR007863 : Peptidase_M16_C", "IPR001506 : Peptidase_M12A", 
                      "IPR007280 : Peptidase_C_arc/bac", "IPR005078 : Peptidase_C54", 
                      "IPR005314 : Peptidase_C50", "IPR003653 : Peptidase_C48", "IPR001300 : Peptidase_C2", 
                      "IPR000668 : Peptidase_C1A_C", "IPR001394 : Peptidase_C19", "IPR001096 : Peptidase_C13", 
                      "IPR001578 : Peptidase_C12", "IPR019103 : Peptidase_aspartic_euk-pred", 
                      "IPR009007 : Peptidase_aspartic_catalytic", "IPR001995 : Peptidase_A2_cat", 
                      "IPR007369 : Peptidase_A22B_SPP", "IPR001108 : Peptidase_A22A", 
                      "IPR006639 : Peptidase_A22", "IPR000243 : Pept_T1A_subB", "IPR005317 : Pept_M49_dipeptidyl-peptIII", 
                      "IPR001567 : Pept_M3A_M3B", "IPR007865 : Pept_M24B_aminopep_P", 
                      "IPR002468 : Pept_M24A_MAP2", "IPR000994 : Pept_M24_structural-domain", 
                      "IPR001714 : Pept_M24_MAP", "IPR011765 : Pept_M16_N", "IPR006615 : Pept_C19_DUSP", 
                      "IPR016526 : Pept_49_dipeptidyl-pept-3_euk", "IPR000121 : PEP_utilisers", 
                      "IPR002833 : Pep_tRNA_hydro_PTH2", "IPR008279 : PEP_mobile", 
                      "IPR002885 : Pentatricopeptide_repeat", "IPR007318 : PEMT", "IPR011050 : Pectin_lyase_fold/virulence", 
                      "IPR001478 : PDZ/DHR/GLGF", "IPR007320 : PDCD2_C", "IPR000717 : PCI", 
                      "IPR000374 : PC_trans", "IPR003173 : PC4", "IPR006626 : PbH1", 
                      "IPR003100 : PAZ", "IPR003392 : Patched", "IPR002641 : Patatin", 
                      "IPR004102 : PARP_reg", "IPR012317 : PARP_catalytic", "IPR003977 : Parkin", 
                      "IPR008962 : PapD-like", "IPR000592 : Ribosomal_S27e", "IPR002906 : Ribosomal_S27a", 
                      "IPR000892 : Ribosomal_S26e", "IPR004977 : Ribosomal_S25", "IPR001976 : Ribosomal_S24e", 
                      "IPR005680 : Ribosomal_S23_euk/arc", "IPR001931 : Ribosomal_S21e", 
                      "IPR001865 : Ribosomal_S2", "IPR001266 : Ribosomal_S19e", "IPR002222 : Ribosomal_S19", 
                      "IPR001210 : Ribosomal_S17e", "IPR000266 : Ribosomal_S17", "IPR005713 : Ribosomal_S15_euk/arc", 
                      "IPR000589 : Ribosomal_S15", "IPR001209 : Ribosomal_S14", "IPR012606 : Ribosomal_S13/S15_N", 
                      "IPR010979 : Ribosomal_S13-like_H2TH", "IPR001892 : Ribosomal_S13", 
                      "IPR000530 : Ribosomal_S12e", "IPR006032 : Ribosomal_S12/S23", 
                      "IPR001971 : Ribosomal_S11", "IPR005729 : Ribosomal_S10_euk/arc", 
                      "IPR001848 : Ribosomal_S10", "IPR020069 : Ribosomal_L9_C", "IPR009027 : Ribosomal_L9/RNase_H1_N", 
                      "IPR004038 : Ribosomal_L7Ae/L30e/S12e/Gad45", "IPR018492 : Ribosomal_L7A/RS6_fam", 
                      "IPR001921 : Ribosomal_L7A", "IPR008932 : Ribosomal_L7/L12_oligo", 
                      "IPR014719 : Ribosomal_L7/12_C/ClpS-like", "IPR000915 : Ribosomal_L6E", 
                      "IPR020040 : Ribosomal_L6_a/b-dom", "IPR000702 : Ribosomal_L6", 
                      "IPR005485 : Ribosomal_L5_euk", "IPR002132 : Ribosomal_L5", "IPR000552 : Ribosomal_L44e", 
                      "IPR001975 : Ribosomal_L40e", "IPR002136 : Ribosomal_L4/L1e", 
                      "IPR000077 : Ribosomal_L39", "IPR002675 : Ribosomal_L38e", "IPR001569 : Ribosomal_L37e", 
                      "IPR002674 : Ribosomal_L37ae", "IPR000509 : Ribosomal_L36e", 
                      "IPR001780 : Ribosomal_L35Ae", "IPR008195 : Ribosomal_L34e", 
                      "IPR001515 : Ribosomal_L32e", "IPR000054 : Ribosomal_L31e", "IPR000517 : Ribosomal_L30p/L7e_cons-reg", 
                      "IPR016082 : Ribosomal_L30_ferredoxin-like", "IPR000597 : Ribosomal_L3", 
                      "IPR002673 : Ribosomal_L29e", "IPR001854 : Ribosomal_L29", "IPR001141 : Ribosomal_L27e", 
                      "IPR005756 : Ribosomal_L26_euk/arc", "IPR011035 : Ribosomal_L25/Gln-tRNA_synth", 
                      "IPR013025 : Ribosomal_L25/23", "IPR000988 : Ribosomal_L24e", 
                      "IPR012678 : Ribosomal_L23/L15e_core", "IPR002671 : Ribosomal_L22e", 
                      "IPR005721 : Ribosomal_L22/L17_euk/arc", "IPR001063 : Ribosomal_L22", 
                      "IPR001147 : Ribosomal_L21e", "IPR002171 : Ribosomal_L2", "IPR000196 : Ribosomal_L19/L19e", 
                      "IPR000039 : Ribosomal_L18e", "IPR002670 : Ribosomal_L18ae", 
                      "IPR005484 : Ribosomal_L18/L5", "IPR000439 : Ribosomal_L15e", 
                      "IPR001196 : Ribosomal_L15", "IPR002784 : Ribosomal_L14e", "IPR000218 : Ribosomal_L14b/L23e", 
                      "IPR001380 : Ribosomal_L13e", "IPR005755 : Ribosomal_L13_euk/arc", 
                      "IPR005822 : Ribosomal_L13", "IPR000911 : Ribosomal_L11", "IPR016180 : Ribosomal_L10e/L16", 
                      "IPR001197 : Ribosomal_L10e", "IPR001790 : Ribosomal_L10", "IPR002143 : Ribosomal_L1", 
                      "IPR001813 : Ribosomal_60S", "IPR007023 : Ribosom_reg", "IPR007676 : Ribophorin_I", 
                      "IPR002139 : Ribokinase", "IPR015865 : Riboflavin_kinase", "IPR010985 : Ribbon_hlx_hlx", 
                      "IPR003500 : Rib/Gal_isomrase", "IPR000198 : RhoGAP", "IPR001763 : Rhodanese-like", 
                      "IPR008936 : Rho_GTPase_activation_prot", "IPR000406 : Rho_GDI", 
                      "IPR008803 : RHD3_GTP_bd", "IPR007594 : RFT1", "IPR011335 : Restrict_endonuc_II-like_core", 
                      "IPR002853 : TFIIE_asu", "IPR003228 : TFIID_sub", "IPR019473 : TFIID_su8_C", 
                      "IPR012294 : TFIID_C/glycos_N", "IPR003923 : TFIID_30kDa", "IPR003195 : TFIID-18", 
                      "IPR013150 : TFIIB_cyclin", "IPR000812 : TFIIB-related", "IPR009088 : TFIIA_b-brl", 
                      "IPR009083 : TFIIA_a-hlx", "IPR002836 : TFAR19_DNA_bd", "IPR004600 : TF_Tfb4", 
                      "IPR002100 : TF_MADSbox", "IPR004330 : TF_FAR1-related", "IPR001289 : TF_CBFB", 
                      "IPR004827 : TF_bZIP", "IPR008952 : Tetraspanin_EC2", "IPR018499 : Tetraspanin", 
                      "IPR001958 : Tet-R_TetA", "IPR008949 : Terpenoid_synth", "IPR008930 : Terpenoid_cyclase/PrenylTrfase", 
                      "IPR014020 : Tensin_phosphatase_C2-dom", "IPR010776 : TBPIP", 
                      "IPR000814 : TBP", "IPR013932 : TATA_bd_TIP120", "IPR007304 : TAP42-like", 
                      "IPR006751 : TAFII55_N", "IPR004823 : TAF_TATA_bd", "IPR000727 : T_SNARE", 
                      "IPR010989 : t-SNARE", "IPR006011 : Syntaxin_N", "IPR016444 : Synaptobrevin_met/fun", 
                      "IPR001388 : Synaptobrevin", "IPR001359 : Synapsin", "IPR002013 : Syja_N", 
                      "IPR007233 : Sybindin", "IPR007526 : SWIRM", "IPR003121 : SWIB_MDM2_domain", 
                      "IPR012923 : Swi3", "IPR000061 : Surp", "IPR016091 : SuperAg_toxin_C_Staph/Strep", 
                      "IPR002650 : Sulphate_adenylyltransferase", "IPR005874 : SUI1_euk", 
                      "IPR016102 : Succinyl-CoA_synth-like", "IPR005828 : Sub_transporter", 
                      "IPR006070 : Sua5/yciO/yrdC_N", "IPR004388 : Sua5/YciO/YrdC/YwlC", 
                      "IPR005145 : SUA5", "IPR019393 : Strumpellin", "IPR006636 : STI1_HS_bd", 
                      "IPR016083 : Sterol-binding-like", "IPR015988 : STAT_TF_coiled-coil", 
                      "IPR002913 : START_lipid_bd", "IPR004093 : Staphylokinase", "IPR006021 : Staphylococcal_nuclease", 
                      "IPR016071 : Staphylococal_nuclease_OB-fold", "IPR006709 : SSU_processome_Utp14", 
                      "IPR013934 : SSU_processome_Utp13", "IPR007148 : SSU_processome_Utp12", 
                      "IPR007144 : SSU_processome_Utp11", "IPR000969 : SSrcognition", 
                      "IPR007198 : Ssl1-like", "IPR009044 : ssDNA-bd_transcriptional_reg", 
                      "IPR000731 : SSD_5TM", "IPR019009 : SRP_receptor_beta_su", "IPR004331 : SPX_N", 
                      "IPR009287 : Spt4", "IPR003877 : SPRY_rcpt", "IPR006640 : SprT", 
                      "IPR001537 : SpoU_MeTrfase", "IPR010822 : Spore_II_E_C", "IPR016194 : SPOC-like", 
                      "IPR013049 : Spo11/TopoVI_A_N", "IPR002815 : Spo11/TopoVI_A", 
                      "IPR009002 : Split_barrel_FMN-bd_related", "IPR018355 : SPla/RYanodine_receptor_sg", 
                      "IPR013315 : Spectrin_alpha_SH3", "IPR007259 : Spc97_Spc98", 
                      "IPR009582 : SPC25", "IPR007653 : SPC22", "IPR009542 : SPC12", 
                      "IPR013925 : SPB_interacting", "IPR012920 : Spb1_C", "IPR007287 : Sof1", 
                      "IPR016487 : snRNP_SmF", "IPR005024 : Snf7", "IPR000330 : SNF2_N", 
                      "IPR015414 : SNARE_assoc", "IPR002625 : Smr/MutS2_C", "IPR010935 : SMC_hinge", 
                      "IPR007848 : Small_mtfrase", "IPR017231 : Small_GTPase_Tem1", 
                      "IPR005225 : Small_GTP_bd", "IPR008984 : SMAD_FHA_domain", "IPR016073 : Skp1_comp_POZ", 
                      "IPR016072 : Skp1_comp_dimer", "IPR001232 : Skp1_comp", "IPR004015 : SKI-int_prot_SKIP_SNW-dom", 
                      "IPR007857 : Skb1_MeTrfase", "IPR001347 : SIS", "IPR011053 : Single_hybrid_motif", 
                      "IPR006886 : Sin-like_cons-reg", "IPR009018 : Signal_recog_particle_SRP9/14", 
                      "IPR004125 : Signal_recog_particle_SRP54_M", "IPR006325 : Signal_recog_particle_SRP54", 
                      "IPR002778 : Signal_recog_particle_SRP19", "IPR003210 : Signal_recog_particle_SRP14", 
                      "IPR013822 : Signal_recog_particl_SRP54_hlx", "IPR000897 : Signal_recog_part_SRP54_GTPase", 
                      "IPR016032 : Sig_transdc_resp-reg_C-effctor", "IPR007009 : SHQ1", 
                      "IPR006447 : SHAQKYF_myb_bd", "IPR020473 : SH3_region", "IPR001452 : SH3_domain", 
                      "IPR013247 : SH3_3", "IPR011511 : SH3_2", "IPR000980 : SH2", 
                      "IPR010770 : SGT1", "IPR007699 : SGS", "IPR011691 : SFT2", "IPR003648 : SFM", 
                      "IPR009846 : SF3b5/RDS3-10", "IPR001214 : SET", "IPR011049 : Serralysin-like_metalloprot_C", 
                      "IPR004469 : SerB", "IPR002290 : Ser/Thr_prot_kinase_dom", "IPR006186 : Ser/Thr-sp_prot-phosphatase", 
                      "IPR009003 : Ser/Cys_Pept_Trypsin-like", "IPR015866 : Ser-tRNA-synth_IIa_N", 
                      "IPR018156 : Ser-tRNA-synth_IIa_C", "IPR002317 : Ser-tRNA-synth_IIa", 
                      "IPR012989 : SEP_domain", "IPR006597 : Sel1-like", "IPR006722 : Sedlin", 
                      "IPR002208 : SecY", "IPR008158 : SecE_euk_arc", "IPR001901 : SecE", 
                      "IPR011130 : SecA_PP_bd", "IPR014018 : SecA_motor_DEAD", "IPR011115 : SecA_DEAD", 
                      "IPR000185 : SecA", "IPR000904 : Sec7", "IPR018127 : Sec63-dom_subgr", 
                      "IPR004179 : Sec63-dom", "IPR010326 : Sec6", "IPR006896 : Sec23_trunk", 
                      "IPR006900 : Sec23_helical", "IPR012990 : Sec23_24_beta_S", "IPR009976 : Sec10", 
                      "IPR001619 : Sec1-like", "IPR017442 : Se/Thr_prot_kinase-like_dom", 
                      "IPR007949 : SDA1", "IPR011145 : Scavenger_mRNA_decap_enz_N", 
                      "IPR008594 : Scavenger_mRNA_decap_enz", "IPR018972 : Sas10_C", 
                      "IPR007146 : Sas10/Utp3/C1D", "IPR005011 : SART_1", "IPR006687 : SAR1_GTP_bd", 
                      "IPR008139 : SaposinB", "IPR011001 : Saposin-like", "IPR008138 : SapB_2", 
                      "IPR007856 : SapB_1", "IPR003034 : SAP_DNA_bd", "IPR017884 : SANT_eukarya", 
                      "IPR001005 : SANT_DNA-bd", "IPR010919 : SAND-like", "IPR010993 : SAM_homology", 
                      "IPR001660 : SAM", "IPR007226 : SAG", "IPR012919 : Sad1_UNC_C", 
                      "IPR005062 : SAC3/GANP/Nin1/mts3/eIF-3-p25", "IPR002942 : S4_RNA_bd", 
                      "IPR006196 : S1_IF1", "IPR009068 : S15_NS1_RNA_bd", "IPR005326 : S10_plectin_N", 
                      "IPR002133 : S-AdoMet_synthetase", "IPR000043 : S-Ado-L-homoCys_hydrolase", 
                      "IPR003035 : RWP-RK", "IPR006575 : RWD", "IPR010994 : RuvA_2-like", 
                      "IPR001566 : RumA_MeTrfase", "IPR003251 : Rubrerythrin", "IPR016440 : Rubredoxin-O_OxRdtase", 
                      "IPR004039 : Rubredox", "IPR002877 : rRNA_MeTrfase_RrmJ/FtsJ", 
                      "IPR011530 : rRNA_adenine_dimethylase", "IPR020598 : rRNA_Ade_methylase_Trfase_N", 
                      "IPR001737 : rRNA_Ade_methylase_transferase", "IPR019582 : RRM_spliceosomal_PrP8", 
                      "IPR000504 : RRM_RNP1", "IPR003954 : RRM_1", "IPR018982 : RQC_domain", 
                      "IPR015048 : DUF1899", "IPR015068 : DUF1877", "IPR014937 : DUF1810", 
                      "IPR014795 : DUF1778", "IPR013894 : DUF1767", "IPR013885 : DUF1764_euk", 
                      "IPR013744 : DUF1749", "IPR013719 : DUF1747_euk", "IPR013562 : DUF1726", 
                      "IPR012936 : DUF1692", "IPR012879 : DUF1682", "IPR003746 : DUF167", 
                      "IPR012460 : DUF1667", "IPR012459 : DUF1665", "IPR012435 : DUF1632", 
                      "IPR012860 : DUF1630", "IPR011678 : DUF1620", "IPR011709 : DUF1605", 
                      "IPR011666 : DUF1604", "IPR011442 : DUF1546", "IPR009828 : DUF1394", 
                      "IPR002855 : DUF137", "IPR010760 : DUF1337", "IPR010678 : DUF1253", 
                      "IPR009653 : DUF1242", "IPR010643 : DUF1227", "IPR001434 : DUF11", 
                      "IPR009445 : DUF1077", "IPR010422 : DUF1014", "IPR010400 : DUF1000", 
                      "IPR020422 : Dual-sp_phosphatase_subgr_cat", "IPR000340 : Dual-sp_phosphatase_cat-dom", 
                      "IPR000387 : Dual-sp/Tyr_phosphatase", "IPR003732 : DTyrtRNA_deacyls", 
                      "IPR005636 : DTW", "IPR012961 : DSH_C", "IPR011084 : DRMBL", 
                      "IPR010472 : Drf_FH3", "IPR004551 : Dphthn_synthase", "IPR007249 : Dopey_N", 
                      "IPR010703 : DOCK", "IPR012278 : DNase_TatD_Mg", "IPR001130 : DNase_TatD-rel", 
                      "IPR001623 : DnaJ_N", "IPR002939 : DnaJ_C", "IPR013725 : DNA_replication_fac_RFC1_C", 
                      "IPR014808 : DNA_replication_fac_Dna2", "IPR004504 : DNA_repair_RadA", 
                      "IPR010995 : DNA_repair_Rad51/TF_NusA_a-hlx", "IPR004579 : DNA_repair_Rad10", 
                      "IPR017963 : DNA_repair_prot_UmuC-like_N", "IPR001126 : DNA_repair_prot_UmuC-like", 
                      "IPR003701 : DNA_repair", "IPR020588 : DNA_recomb_RecA/RadB_ATP-bd", 
                      "IPR016467 : DNA_recomb/repair_RecA-like", "IPR013632 : DNA_recomb/repair_Rad51_C", 
                      "IPR011941 : DNA_recomb/repair_Rad51", "IPR014052 : DNA_primase_ssu_euk/arc", 
                      "IPR002755 : DNA_primase_S", "IPR007238 : DNA_primase_lsu_euk/arc", 
                      "IPR002298 : DNA_polymerase_A_dom", "IPR017961 : DNA_pol_Y-fam_little_finger", 
                      "IPR014381 : DNA_pol_RPB5_su", "IPR009052 : DNA_pol_III_theta_bac", 
                      "IPR007185 : DNA_pol_alpha/epsilon_bsu", "IPR019483 : DNA_pol3_clamp-load_cplx_suE_C", 
                      "IPR008921 : DNA_pol3_clamp-load_cplx_C", "IPR016151 : DNA_mismatch_repair_MutS_N", 
                      "IPR007696 : DNA_mismatch_repair_MutS_core", "IPR007860 : DNA_mismatch_repair_MutS_connt", 
                      "IPR007861 : DNA_mismatch_repair_MutS_clamp", "IPR000432 : DNA_mismatch_repair_MutS_C", 
                      "IPR007695 : DNA_mismatch_repair_MutS-lik_N", "IPR013507 : DNA_mismatch_repair_C", 
                      "IPR012308 : DNA_ligase_A_N", "IPR012310 : DNA_ligase_A_M", "IPR012309 : DNA_ligase_A_C", 
                      "IPR000977 : DNA_ligase", "IPR013020 : DNA_helicase_DNA-repair_Rad3", 
                      "IPR018329 : DNA_helicase_ATP-dep_RecQ_N", "IPR011257 : DNA_glycosylase", 
                      "IPR015121 : DNA_fragmentation_C", "IPR011010 : DNA_brk_join_enz", 
                      "IPR009061 : DNA_bd_put", "IPR014825 : DNA_alkylation", "IPR011545 : DNA/RNA_helicase_DEAD/DEAH_N", 
                      "IPR001650 : DNA/RNA_helicase_C", "IPR019447 : DNA/RNA-bd_Kin17_cons_reg", 
                      "IPR007085 : DNA/pantothenate-metab_flavo_C", "IPR007120 : DNA-dir_RNA_pol_su2_6", 
                      "IPR011263 : DNA-dir_RNA_pol_RpoA/D/Rpb3", "IPR009025 : DNA-dir_RNA_pol_RBP11-like", 
                      "IPR001529 : DNA-dir_RNA_pol_M/15kDasu", "IPR011262 : DNA-dir_RNA_pol_insert", 
                      "IPR011261 : DNA-dir_RNA_pol_dimersation", "IPR004578 : DNA-dir_DNA_pol_B_pol2", 
                      "IPR004868 : DNA-dir_DNA_pol_B_mt/vir", "IPR006133 : DNA-dir_DNA_pol_B_exonuc", 
                      "IPR017966 : DNA-dir_DNA_pol_B_cons_reg2", "IPR006134 : DNA-dir_DNA_pol_B_cons-reg", 
                      "IPR006172 : DNA-dir_DNA_pol_B", "IPR001098 : DNA-dir_DNA_pol_A_palm_dom", 
                      "IPR001208 : DNA-dep_ATPase_MCM", "IPR006551 : DNA-3-Pase", "IPR011940 : DMC1_rcmbase", 
                      "IPR001275 : DM_DNA_bd", "IPR012960 : DKCLD", "IPR002058 : PAP_assoc", 
                      "IPR013143 : PAM", "IPR000095 : PAK_box_Rho_bd", "IPR003822 : PAH", 
                      "IPR012982 : PADR1", "IPR002004 : PABP_HYD", "IPR000326 : P_Acid_Pase_2/haloperoxidase", 
                      "IPR000304 : P5CR", "IPR008967 : p53-like_TF_DNA-bd", "IPR007188 : P34-arc", 
                      "IPR000648 : Oxysterol_bd", "IPR001853 : OxRdtase_DSBA", "IPR000683 : Oxidoreductase_N", 
                      "IPR003323 : OTU", "IPR005055 : OS_D_PhBP", "IPR002433 : Orn_de-COase", 
                      "IPR000270 : OPR_PB1", "IPR001809 : OM_lipoprot_Borrelia", "IPR019353 : Oligosaccharyltransferase_DC2", 
                      "IPR013969 : Oligosacch_biosynth_Alg14", "IPR003674 : Oligo_trans_STT3", 
                      "IPR006757 : OGF_rcpt", "IPR003462 : ODC_Mu_crystall", "IPR019496 : NUFIP1_cons_reg", 
                      "IPR015797 : NUDIX_hydrolase_dom-like", "IPR000086 : NUDIX_hydrolase_dom", 
                      "IPR020476 : Nudix_hydrolase", "IPR011068 : NuclTrfase_I_C", 
                      "IPR002934 : Nucleotidyltransferase", "IPR000845 : Nucleoside_phosphorylase", 
                      "IPR018222 : Nuclear_transport_factor_2_euk", "IPR008946 : Nucl_hormone_rcpt_ligand-bd", 
                      "IPR008089 : Nuc_sugar_epim", "IPR007271 : Nuc_sug_transpt", 
                      "IPR001564 : Nuc_diP_kinase_core", "IPR012580 : NUC153", "IPR005835 : NTP_transferase", 
                      "IPR003010 : Ntlse/CNhydtse", "IPR002075 : NTF2", "IPR000744 : NSF_attach", 
                      "IPR014854 : Nse4", "IPR012837 : NrdG", "IPR012833 : NrdD", "IPR005554 : Nrap", 
                      "IPR009348 : NPR2", "IPR007717 : NPL4", "IPR007207 : Not_N", 
                      "IPR007196 : Not1", "IPR007282 : NOT", "IPR012976 : NOSIC", "IPR012974 : NOP5_N", 
                      "IPR010301 : Nop52", "IPR011023 : Nop2p", "IPR007264 : Nop10p_RNA_bd", 
                      "IPR002687 : Nop", "IPR012973 : NOG_C", "IPR010674 : NOG1_GTP_bd", 
                      "IPR011501 : NOC3p", "IPR014881 : NOB1_Zn_bd", "IPR007064 : NMD3", 
                      "IPR012972 : NLE", "IPR000415 : Nitroreductase-like", "IPR015087 : NIP_1", 
                      "IPR002871 : NIF_FeS_clus_asmbl_NifU_N", "IPR001075 : NIF_FeS_clus_asmbl_NifU_C", 
                      "IPR004274 : NIF", "IPR007229 : Nic_PRibTrfase-rel", "IPR015977 : Nic_PRibTrfase-like", 
                      "IPR006406 : Nic_PRibTrfase", "IPR013017 : NHL_repeat_subgr", 
                      "IPR001258 : NHL_repeat", "IPR012971 : NGP1_N", "IPR000108 : Neu_cyt_fact_2", 
                      "IPR012466 : NECAP-1", "IPR002715 : Nas_poly-pep-assoc_cplx", 
                      "IPR002164 : NAP_family", "IPR005248 : NAMN_adtrnsfrase", "IPR004709 : NaH_exchanger_subfam", 
                      "IPR018406 : NaH_exchanger_cons-reg", "IPR008696 : NAF1", "IPR004003 : NADP_transhyd_b", 
                      "IPR004571 : NADP_transhyd_a", "IPR004455 : NADP_OxRdtase_F420", 
                      "IPR003694 : NAD_synthase", "IPR003000 : NAD-dep_histone_deAcase_SIR2", 
                      "IPR016040 : NAD(P)-bd_dom", "IPR004837 : NaCa_Exmemb", "IPR004365 : NA_bd_OB_tRNA-helicase", 
                      "IPR019900 : Na/solute_symporter_subgr", "IPR001734 : Na/solute_symporter", 
                      "IPR016027 : NA-bd_OB-fold-like", "IPR016217 : N_fixation_NifU", 
                      "IPR019369 : N6_adenine_Mtase-rel_euk", "IPR011045 : N2O_reductase_N", 
                      "IPR012901 : N2227", "IPR019183 : N-acetylTrfase_B_cplx_non-cat", 
                      "IPR011936 : Myxo_disulph_rpt", "IPR000903 : Myristoyl_trans", 
                      "IPR017906 : Myotubularin_phosphatase", "IPR010569 : Myotub-related", 
                      "IPR010926 : Myosin_tail_2", "IPR008989 : Myosin_S1_N", "IPR004009 : Myosin_N", 
                      "IPR001609 : Myosin_head", "IPR013021 : Myo-inos-1-P_Synthase_GAPDH", 
                      "IPR002587 : Myo-inos-1-P_Synthase", "IPR014778 : Myb_DNA-bd", 
                      "IPR017930 : Myb-type_HTH", "IPR017877 : MYB-like", "IPR014790 : MutL_C", 
                      "IPR011031 : Multihaem_cyt", "IPR018289 : MULE_transposase_cons-dom", 
                      "IPR010049 : MTA_SAH_Nsdase", "IPR011057 : Mss4-like", "IPR006685 : MscS_channel", 
                      "IPR004123 : mRNA_splic_U5", "IPR013260 : mRNA_splic_SYF2", "IPR004206 : mRNA_capping_enz_bsu", 
                      "IPR013846 : mRNA_cap_enzyme_C", "IPR001339 : mRNA_cap_enzyme", 
                      "IPR007151 : Mpp10", "IPR000751 : MPI_Phosphatase", "IPR002717 : MOZ_SAS", 
                      "IPR000555 : Mov34_MPN_PAD1", "IPR016155 : Mopterin_synth/thiamin_S_b", 
                      "IPR003448 : Mopterin_biosynth_MoaE", "IPR001453 : Mopterin_bd", 
                      "IPR009036 : Molybdenum_cofac_synth_MoeB", "IPR006030 : Mollsc_rhodpsn_C", 
                      "IPR007901 : MoeZ_MoeB", "IPR005301 : Mob1_phocein", "IPR005647 : Mnd1", 
                      "IPR019831 : Mn/Fe_SOD_N", "IPR019832 : Mn/Fe_SOD_C", "IPR001189 : Mn/Fe_SOD", 
                      "IPR002917 : MMR_HSR1_GTP_bd", "IPR018108 : Mitochondrial_sb/sol_carrier", 
                      "IPR001993 : Mitochondria_substrate_carrier", "IPR002067 : Mit_carrier", 
                      "IPR007330 : MIT", "IPR013684 : MIRO-like", "IPR016093 : MIR_motif", 
                      "IPR003608 : MIR", "IPR000425 : MIP", "IPR003890 : MIF4G-like_typ-3", 
                      "IPR020091 : Midkine_heparin-bd_GF_diS", "IPR009755 : Mic1", 
                      "IPR010606 : Mib_Herc2", "IPR006466 : MiaB-like_B", "IPR004166 : MHCK_EF2_kinase", 
                      "IPR011162 : MHC_I/II-like_Ag-recog", "IPR002523 : Mg2+_transptCorA", 
                      "IPR016196 : MFS_general_subst_transpt", "IPR011701 : MFS_1", 
                      "IPR009730 : MFAP1_C", "IPR006206 : Mevalonate/galactokinase", 
                      "IPR017280 : MeTrfase_METTL2_prd", "IPR007871 : Methyltransferase_TRM13", 
                      "IPR007823 : Methyltransferase-rel", "IPR019410 : Methyltransferase-16_put", 
                      "IPR013217 : Methyltransf_12", "IPR013216 : Methyltransf_11", 
                      "IPR013848 : Methylthiotransferase_N", "IPR005839 : Methylthiotransferase", 
                      "IPR002579 : Methionine_sulphoxide_MsrB", "IPR017854 : Metallothionein_sfam", 
                      "IPR006124 : Metalloenzyme", "IPR011249 : Metalloenz_metal-bd", 
                      "IPR011059 : Metal-dep_hydrolase_composite", "IPR002304 : Met-tRNA-synth_Ia", 
                      "IPR003226 : Met-dep_prot_hydro", "IPR006674 : Met-dep_phosphohydro_HD_sub", 
                      "IPR003607 : Met-dep_phosphohydro_HD", "IPR008010 : Membrane_Tatp1/CMV_rcpt", 
                      "IPR008831 : Mediator_Med31", "IPR019145 : Mediator_Med10", "IPR009244 : Mediatior_Med7", 
                      "IPR003172 : MD-2_lipid-recog", "IPR008050 : MCM_7", "IPR008049 : MCM_6", 
                      "IPR008048 : MCM_5", "IPR008047 : MCM_4", "IPR008046 : MCM_3", 
                      "IPR008045 : MCM_2", "IPR004299 : MBOAT_fam", "IPR008191 : Maternal_tudor", 
                      "IPR004241 : MAP1_LC3", "IPR016817 : MannP-dilichol_defect-1", 
                      "IPR007315 : Mannosyltransferase_PIG-V", "IPR007704 : Mannosyltransferase_DXD", 
                      "IPR016305 : Mannose-6-P_Isomerase", "IPR009011 : Man6P_isomerase_rcpt_bd", 
                      "IPR001250 : Man6P_Isoase-1", "IPR003428 : MAM33", "IPR001891 : Malic_OxRdtase", 
                      "IPR002318 : Ala-tRNA-synth_IIc", "IPR006703 : AIG1", "IPR015310 : AHSA1_N", 
                      "IPR008395 : Agenet", "IPR000961 : AGC-kinase_C", "IPR006190 : AFP_Neu5c_C", 
                      "IPR000759 : Adrndx_reductase", "IPR015878 : Ado_hCys_hydrolase_NAD-bd", 
                      "IPR008966 : Adhesion_bac", "IPR013149 : ADH_Zn-bd", "IPR013154 : ADH_GroES-like", 
                      "IPR001670 : ADH_Fe", "IPR017904 : ADF/Cofilin/Destrin", "IPR000850 : Adenylate_kin", 
                      "IPR013992 : Adenylate_cyclase-assoc_CAP_N", "IPR013912 : Adenylate_cyclase-assoc_CAP_C", 
                      "IPR008172 : Adenylate_cyclase", "IPR002123 : Acyltransferase", 
                      "IPR016035 : Acyl_Trfase/lysoPlipase", "IPR002656 : Acyl_transf_3", 
                      "IPR016181 : Acyl_CoA_acyltransferase", "IPR009081 : Acyl_carrier_prot-like", 
                      "IPR016365 : Actobindin", "IPR013538 : Activator_of_Hsp90_ATPase", 
                      "IPR008999 : Actin_cross-linking", "IPR004000 : Actin-like", 
                      "IPR003104 : Actin-bd_FH2/DRF_autoreg", "IPR002108 : Actin-bd_cofilin/tropomyosin", 
                      "IPR002912 : ACT_bd", "IPR004372 : AckA", "IPR000438 : Acetyl_CoA_COase_Trfase_b_su", 
                      "IPR020582 : Acetyl_CoA_COase_a_su_cons-reg", "IPR001095 : Acetyl_CoA_COase_a_su", 
                      "IPR000890 : Acetate/butyrate_kinase", "IPR014089 : AcCoA-synth-alpha", 
                      "IPR001176 : ACC_synthase", "IPR003675 : Abi", "IPR017940 : ABC_transporter_type1", 
                      "IPR003439 : ABC_transporter-like", "IPR001140 : ABC_TM_transpt", 
                      "IPR011527 : ABC_TM_1", "IPR013283 : ABC_E", "IPR013525 : ABC_2_trans", 
                      "IPR000073 : AB_hydrolase_1", "IPR012020 : AB-Hydro_YheT", "IPR012948 : AARP2CN", 
                      "IPR013057 : AA_transpt_TM", "IPR002293 : AA/rel_permease1", 
                      "IPR006195 : aa-tRNA-synth_II_cons-reg", "IPR002305 : aa-tRNA-synth_Ib", 
                      "IPR002300 : aa-tRNA-synth_Ia", "IPR002314 : aa-tRNA-synt_IIb_cons-reg", 
                      "IPR004364 : aa-tRNA-synt_II", "IPR015413 : aa-tRNA-synt_I", 
                      "IPR006330 : A_deaminase", "IPR002466 : A_deamin", "IPR002589 : A1pp", 
                      "IPR001365 : A/AMP_deaminase", "IPR005841 : A-D-PHexomutase_N", 
                      "IPR005843 : A-D-PHexomutase_C", "IPR005846 : A-D-PHexomutase_a/b/a-III", 
                      "IPR005845 : A-D-PHexomutase_a/b/a-II", "IPR016055 : A-D-PHexomutase_a/b/a-I/II/III", 
                      "IPR005844 : A-D-PHexomutase_a/b/a-I", "IPR006048 : A-amylase_b_C", 
                      "IPR008927 : 6-PGluconate_DH_C-like", "IPR008928 : 6-hairpin_glycosidase-like", 
                      "IPR017151 : 5_3_exoribonuclease_2", "IPR020047 : 5-3_exonuclease_SAM-fold_dom", 
                      "IPR002421 : 5-3_exonuclease_N", "IPR020045 : 5-3_exonuclease_C", 
                      "IPR000878 : 4pyrrol_Mease", "IPR001450 : 4Fe4S_Fe_S_bd_subgr", 
                      "IPR017896 : 4Fe4S_Fe-S-bd", "IPR009079 : 4_helix_cytokine-like_core", 
                      "IPR008278 : 4-PPantetheinyl_Trfase", "IPR015874 : 4-disulphide_core", 
                      "IPR004173 : 3H_domain", "IPR001080 : 3Fe4S_ferredoxin", "IPR002562 : 3_5_exonuclease", 
                      "IPR001104 : 3-oxo-5_a-steroid_4-DH_C", "IPR016636 : 3-oxo-5-alpha-steroid_4-DH", 
                      "IPR010734 : Copine", "IPR008985 : ConA-like_lec_gl", "IPR016060 : Complement_control_module", 
                      "IPR017920 : COMM", "IPR003830 : ComA_synth", "IPR008160 : Collagen", 
                      "IPR009169 : Calreticulin", "IPR001580 : Calret/calnex", "IPR001715 : Calponin_act_bd", 
                      "IPR016146 : Calponin-homology", "IPR003299 : Calflagin_bd", 
                      "IPR019134 : Cactin_cactus-bd_C", "IPR001525 : C5_DNA_meth", 
                      "IPR020477 : C2_region", "IPR018029 : C2_membr_targeting", "IPR008973 : C2_Ca/lipid-bd_reg_CaLB", 
                      "IPR000008 : C2_Ca-dep", "IPR011424 : C1_3", "IPR016187 : C-type_lectin_fold", 
                      "IPR017901 : C-CAP_CF_C-like", "IPR011700 : bZIP_2", "IPR011616 : bZIP_1", 
                      "IPR007955 : Bystin", "IPR006565 : BTP", "IPR013069 : BTB_POZ", 
                      "IPR011333 : BTB/POZ_fold", "IPR000210 : BTB/POZ-like", "IPR005607 : BSD", 
                      "IPR001487 : Bromodomain", "IPR004328 : BRO1", "IPR007109 : Brix", 
                      "IPR011665 : BRF1_TBP_bd", "IPR001357 : BRCT", "IPR015187 : BRCA-2_OB_1", 
                      "IPR004143 : BPL_LipA_LipB", "IPR011258 : BPG-indep_PGM_N", "IPR012954 : BP28_C", 
                      "IPR012953 : BOP1_N", "IPR001279 : Blactmase-like", "IPR006239 : Bisphos_HAL2", 
                      "IPR000089 : Biotin_lipoyl", "IPR004408 : Biotin_CoA_COase_ligase", 
                      "IPR019197 : Biotin-prot_ligase_N", "IPR012952 : BING4_C", "IPR003343 : Big_2", 
                      "IPR005252 : Bifunc_COABC", "IPR012079 : Bifunc_Ald/AlcDH", "IPR007419 : BFD_Fer2_bd", 
                      "IPR002453 : Beta_tubulin", "IPR001466 : Beta_lactamase-related", 
                      "IPR000409 : Beige_BEACH", "IPR003492 : Battenin_disease_Cln3", 
                      "IPR009009 : Barwin-related_endoglucanase", "IPR004148 : BAR", 
                      "IPR008417 : Bap31", "IPR019749 : Band_41_domain", "IPR001480 : B_lectin_man_bd", 
                      "IPR005786 : B_amino_transII", "IPR005147 : B5", "IPR001870 : B302", 
                      "IPR005146 : B3/B4_tRNA-bd", "IPR012338 : B-lactamase-typ_transpept_fold", 
                      "IPR004776 : Auxin_eff", "IPR007239 : Autophagy-rel_prot_5", 
                      "IPR007134 : Autophagy-rel_prot_3_N", "IPR019461 : Autophagy-rel_prot_3_C", 
                      "IPR007135 : Autophagy-rel_prot_3", "IPR018939 : Autophagy-rel_prot_27", 
                      "IPR009563 : Auto_anti-p27", "IPR012529 : Attractin", "IPR008218 : ATPase_V1/A1-cplx_fsu", 
                      "IPR002842 : ATPase_V1/A1-cplx_esu", "IPR002699 : ATPase_V1/A1-cplx_dsu", 
                      "IPR004908 : ATPase_V1-cplx_hsu", "IPR005772 : ATPase_V1-cplx_fsu_euk", 
                      "IPR004907 : ATPase_V1-cplx_csu", "IPR005723 : ATPase_V1-cplx_bsu", 
                      "IPR005725 : ATPase_V1-cplx_asu", "IPR002843 : ATPase_V0/A0-cplx_csu/dsu", 
                      "IPR002490 : ATPase_V0/A0-cplx_116kDa_su", "IPR016727 : ATPase_V0-cplx_dsu", 
                      "IPR011555 : ATPase_V0-cplx_csu_euk", "IPR000245 : ATPase_V0-cplx_csu", 
                      "IPR006544 : ATPase_P-typ_unknown-pump-sp", "IPR006539 : ATPase_P-typ_Plipid-transl", 
                      "IPR001757 : ATPase_P-typ_ion-transptr", "IPR000695 : ATPase_P-typ_H-transp", 
                      "IPR004014 : ATPase_P-typ_cation-transptr_N", "IPR006068 : ATPase_P-typ_cation-transptr_C", 
                      "IPR006408 : ATPase_P-typ_Ca-transp_PMCA", "IPR008250 : ATPase_P-typ_ATPase-assoc-reg", 
                      "IPR015194 : ATPase_nucl-remodel_HAND-dom", "IPR000194 : ATPase_F1/V1/A1_a/bsu_nucl-bd", 
                      "IPR004100 : ATPase_F1/V1/A1-cplx_a/bsu_N", "IPR000793 : ATPase_F1/V1/A1-cplx_a/bsu_C", 
                      "IPR018118 : ATPase_F1/A1-cplx_a/bsu_N", "IPR002091 : ArAA_permease", 
                      "IPR001597 : ArAA_b-elim_lyase/Thr_aldolase", "IPR009283 : Apyrase", 
                      "IPR002891 : APS_kinase_C", "IPR003103 : Apoptosis_reg_Bcl-2_prot_BAG", 
                      "IPR002575 : APH_trans", "IPR002015 : APC_proteasome", "IPR004939 : APC10", 
                      "IPR013332 : ApbA_N", "IPR013752 : ApbA_C", "IPR000097 : AP_endonuclease_F1", 
                      "IPR016635 : AP_complex_ssu", "IPR016342 : AP_complex_bsu", "IPR017105 : AP3_complex_dsu", 
                      "IPR017108 : AP3_complex_bsu", "IPR017104 : AP2_complex_asu", 
                      "IPR017107 : AP1_complex_gsu", "IPR004154 : Anticodon_bd", "IPR007138 : Antibiotic_mOase", 
                      "IPR011417 : ANTH", "IPR002110 : Ankyrin_rpt", "IPR001828 : ANF_lig_bd_rcpt", 
                      "IPR000873 : AMP-dep_Synth/Lig", "IPR020459 : AMP-binding", "IPR020471 : Aldo/keto_reductase_sg", 
                      "IPR001395 : Aldo/ket_red", "IPR012394 : Aldehyde_DH_NAD(P)", 
                      "IPR015590 : Aldehyde_DH", "IPR016161 : Ald_DH/histidinol_DH", 
                      "IPR008183 : Ald1_epimerase", "IPR001608 : Ala_racemase_N", "IPR009006 : Ala_racemase/Decarboxylase_C", 
                      "IPR007886 : Ala_DH/PNT_N", "IPR007698 : Ala_DH/PNT_C", "IPR018164 : Ala-tRNA-synth_IIc_N", 
                      "IPR018165 : Ala-tRNA-synth_IIc_cons-reg", "IPR018162 : Ala-tRNA-synth_IIc_anticod-bd", 
                      "IPR017850 : Alkaline_phosphatase_core", "IPR000866 : Alkyl_hydroperoxide_Rdtase", 
                      "IPR019341 : Alpha/Gamma-adaptin-bd_p34", "IPR005887 : Alpha_mannosidase", 
                      "IPR002452 : Alpha_tubulin", "IPR002502 : Amidase_2", "IPR010158 : Amidase_hdtase/Cbmase", 
                      "IPR006680 : Amidohydro_1", "IPR001544 : Aminotrans_IV", "IPR000192 : Aminotrans_V/Cys_dSase", 
                      "IPR004839 : Aminotransferase_I/II", "IPR002733 : AMMECR1", "IPR002804 : Archease_tRNA_MeTfrase_chp", 
                      "IPR006688 : ARF", "IPR006689 : ARF/SAR", "IPR001164 : ArfGAP", 
                      "IPR001278 : Arg-tRNA-synth_Ic", "IPR015945 : Arg-tRNA-synth_Ic_core", 
                      "IPR005148 : Arg-tRNA-synth_Ic_N", "IPR005924 : Arginase", "IPR016024 : ARM-type_fold", 
                      "IPR000225 : Armadillo", "IPR006789 : ARP2/3_p16_Arc", "IPR007204 : ARP2/3_p21-Arc", 
                      "IPR017383 : ARPC2/3_su1", "IPR008384 : ARPC4", "IPR011022 : Arrestin-like_C", 
                      "IPR011021 : Arrestin-like_N", "IPR007290 : Arv1", "IPR004522 : Asn-tRNA-synth_IIb", 
                      "IPR003789 : Asn/Gln_tRNA_amidoTrfrase-rel", "IPR001962 : Asn_synthase", 
                      "IPR004618 : AsnA", "IPR006033 : AsnASEI", "IPR002312 : Asp-tRNA-synth_IIb", 
                      "IPR004523 : Asp-tRNA-synth_IIb_arc/euk", "IPR001048 : Asp/Glu/Uridylate_kinase", 
                      "IPR006130 : Asp/Orn_carbamoylTrfase", "IPR020542 : Asp_carbamoyltrfase_reg_C", 
                      "IPR009010 : Asp_de-COase-like_fold", "IPR006034 : Asparaginase/glutaminase", 
                      "IPR017956 : AT_hook_DNA-bd_motif", "IPR005144 : ATP-cone", "IPR011761 : ATP-grasp", 
                      "IPR013650 : ATP-grasp_succ-CoA_synth-type", "IPR016064 : ATP-NAD_kinase_PpnK-typ", 
                      "IPR003594 : ATP_bd_ATPase", "IPR002504 : ATP_NADK", "IPR019591 : ATPase-like_ParA/MinD", 
                      "IPR003593 : ATPase_AAA+_core", "IPR013093 : ATPase_AAA-2", "IPR011703 : ATPase_AAA-3", 
                      "IPR011704 : ATPase_AAA-5", "IPR005938 : ATPase_AAA_CDC48", "IPR003959 : ATPase_AAA_core", 
                      "IPR003338 : ATPase_AAA_VAT_N", "IPR003348 : ATPase_anion-transp", 
                      "IPR002731 : ATPase_BadF", "IPR008387 : ATPase_F0-cplx_f6su_mt", 
                      "IPR002379 : ATPase_F0/V0-cplx_csu", "IPR003377 : Cornichon", 
                      "IPR002423 : Cpn60/TCP-1", "IPR001251 : CRAL_bd_TRIO_C", "IPR000587 : Creatinase", 
                      "IPR017447 : CS", "IPR007052 : CS_domain", "IPR006603 : CTNS", 
                      "IPR016182 : Cu_amine_oxidase_N-reg", "IPR003892 : CUE", "IPR016158 : Cullin_homology", 
                      "IPR001373 : Cullin_N", "IPR019559 : Cullin_neddylation_domain", 
                      "IPR016159 : Cullin_repeat-like_dom", "IPR013096 : Cupin_2", 
                      "IPR011051 : Cupin_RmlC_type", "IPR008972 : Cupredoxin", "IPR006768 : Cwf19-like_C_dom-1", 
                      "IPR006973 : Cwf_Cwc_15", "IPR006670 : Cyclin", "IPR000789 : Cyclin-dep_kinase_reg-sub", 
                      "IPR011028 : Cyclin-like", "IPR014400 : Cyclin_A_B_D_E", "IPR004367 : Cyclin_C", 
                      "IPR006671 : Cyclin_N", "IPR015891 : Cyclophilin-like", "IPR013171 : Cyd/dCyd_deaminase_Zn_bd", 
                      "IPR015803 : Cys-tRNA-synt_Ia_N", "IPR002308 : Cys-tRNA-synth_1a", 
                      "IPR000277 : Cys/Met-Metab_PyrdxlP-dep_enz", "IPR003341 : Cys_rich_tripleX", 
                      "IPR005856 : Cys_synthKM", "IPR005859 : CysK", "IPR000644 : Cysta_beta_synth_core", 
                      "IPR016454 : Cysteine_dSase_NifS", "IPR013871 : Cysteine_rich_secretory", 
                      "IPR005798 : Cyt_b/b6_C", "IPR001199 : Cyt_B5", "IPR010980 : Cyt_c/b562", 
                      "IPR009056 : Cyt_c_monohaem", "IPR000883 : Cyt_c_oxidase_su1", 
                      "IPR015964 : Cyt_c_oxidase_su2-like_TM", "IPR011048 : Cyt_cd1_nitrite_Rdtase_haem_C", 
                      "IPR004821 : Cyt_trans_rel", "IPR016193 : Cytidine_deaminase-like", 
                      "IPR004820 : Cytidylyltransf", "IPR008996 : Cytokine_IL1-like", 
                      "IPR011778 : D-hydantoinase", "IPR006139 : D-isomer_2_OHA_DH", 
                      "IPR006140 : D-isomer_2_OHA_DH_NAD-bd", "IPR009772 : D123", "IPR003038 : DAD", 
                      "IPR020454 : DAG/PE_bd", "IPR008909 : DALR_anticod_bd", "IPR012541 : DBP10CT", 
                      "IPR010334 : DCP1", "IPR007722 : DCP2", "IPR011962 : dCTP_deam", 
                      "IPR003533 : DCX", "IPR004875 : DDE_SF_endonuclease_CENPB-like", 
                      "IPR005112 : dDENN", "IPR005013 : DDOST_48kDa", "IPR000183 : De-COase2", 
                      "IPR014001 : DEAD-like_N", "IPR010614 : DEAD_2", "IPR011029 : DEATH-like", 
                      "IPR000310 : Decarbxylse1", "IPR005834 : Dehalogen-like_hydro", 
                      "IPR001194 : DENN", "IPR011343 : DeoC", "IPR002915 : DeoC/AroFGH_arch", 
                      "IPR004402 : DeoD", "IPR002773 : Deoxyhypus_synth", "IPR002624 : Deoxynucleoside_kinase", 
                      "IPR008180 : DeoxyUTP_pyroPase_dom", "IPR001977 : Depp_CoAkinase", 
                      "IPR002259 : DER/eqnu_transpt", "IPR007599 : DER1", "IPR000219 : DH-domain", 
                      "IPR002198 : DH_sc/Rdtase_SDR", "IPR003560 : DHB_DH", "IPR017945 : DHBP_synth_RibB-like_a/b_dom", 
                      "IPR000756 : Diacylglycerol_kinase_access", "IPR001206 : Diacylglycerol_kinase_cat", 
                      "IPR012135 : Dihydroorotate_DH_1_2", "IPR002710 : Dilute", "IPR011008 : Dimeric_a/b-barrel", 
                      "IPR000581 : DiOHA_6PGluconate_deHydtase", "IPR016435 : Diphthamide_synth_DHP1", 
                      "IPR002728 : Diphthamide_synth_DHP1/DHP2", "IPR005788 : Disulphide_isomerase", 
                      "IPR004680 : Divalent_ion_symporter", "IPR006287 : DJ1", "IPR009033 : Calreticulin/calnexin_P", 
                      "IPR009028 : Calthrin/coatomer_app_sub_C", "IPR011038 : Calycin-like", 
                      "IPR016184 : Capsid/spike_ssDNA_virus", "IPR001742 : Capsid_VP2_Orbivir", 
                      "IPR013784 : Carb-bd-like_fold", "IPR011611 : Carb/pur_kinase", 
                      "IPR008965 : Carb_bd", "IPR018485 : Carb_kinase_FGGY_C", "IPR018484 : Carb_kinase_FGGY_N", 
                      "IPR001765 : Carbonic_anhydrase", "IPR001315 : CARD", "IPR006599 : CARP_motif", 
                      "IPR000704 : Casein_kinase_II_reg-sub", "IPR003445 : Cat_transpt", 
                      "IPR011614 : Catalase_N", "IPR006153 : Cation/H_exchanger", "IPR002524 : Cation_efflux", 
                      "IPR019339 : CBF1-interact_co-repress_CIR_N", "IPR003958 : CBFA_NFYB_domain", 
                      "IPR020343 : CC-type_chemokine_FPV060_put", "IPR005612 : CCAAT-binding_factor", 
                      "IPR003874 : CDC45-like", "IPR000462 : CDP-OH_P_trans", "IPR014387 : CDP_diag_ino_3_P_euk", 
                      "IPR007216 : Cell_differentiation_Rcd1", "IPR004201 : Cell_division_protein_CDC48_2", 
                      "IPR003305 : CenC_carb_bd", "IPR012328 : Chalcone/stilbene_synth_C", 
                      "IPR012716 : Chap_CCT_beta", "IPR012717 : Chap_CCT_delta", "IPR012718 : Chap_CCT_epsi", 
                      "IPR012720 : Chap_CCT_eta", "IPR012719 : Chap_CCT_gamma", "IPR012721 : Chap_CCT_theta", 
                      "IPR012722 : Chap_CCT_zeta", "IPR001404 : Chaperone_htpG", "IPR017998 : Chaperone_TCP-1", 
                      "IPR001270 : Chaprnin_clpA/B", "IPR001844 : Chaprnin_Cpn60", 
                      "IPR001476 : Chaprnonin_Cpn10_subgroup", "IPR004089 : Chemotax_Me-accpt_rcpt_sig", 
                      "IPR002557 : Chitin-bd_peritrophin-A", "IPR001002 : Chitin_bd_1", 
                      "IPR004835 : Chitin_synth_fng", "IPR011583 : Chitinase_II", "IPR002573 : Choline/ethanolamine_kinase", 
                      "IPR014472 : CHOPT", "IPR002701 : Chorismate_mutase", "IPR004396 : CHP00092", 
                      "IPR005228 : CHP00251", "IPR006476 : CHP01589_pln", "IPR012816 : CHP02464_YbiA", 
                      "IPR014127 : CHP02757", "IPR013641 : Chromatin_KTI12", "IPR000953 : Chromodomain", 
                      "IPR016197 : Chromodomain-like", "IPR008136 : CinA_C", "IPR014743 : Cl-channel_core", 
                      "IPR001807 : Cl-channel_volt", "IPR002553 : Clathrin/coatomer_adapt-like_N", 
                      "IPR013041 : Clathrin/coatomer_app_Ig-like", "IPR003164 : Clathrin_a-adaptin_app_sub_C", 
                      "IPR008152 : Clathrin_a/b/g-adaptin_app_Ig", "IPR008153 : Clathrin_g-adaptin_app", 
                      "IPR000547 : Clathrin_H-chain/VPS_repeat", "IPR001473 : Clathrin_H-chain_propeller_N", 
                      "IPR016341 : Clathrin_heavy_chain", "IPR001392 : Clathrin_mu", 
                      "IPR008968 : Clathrin_mu_C", "IPR000804 : Clathrin_sigma/coatomer_zeta", 
                      "IPR016706 : Cleav_polyA_spec_factor_25kDa", "IPR004871 : Cleavage/polyA-sp_fac_asu_C", 
                      "IPR019489 : Clp_ATPase_C", "IPR004176 : Clp_N", "IPR008429 : CLPTM1", 
                      "IPR001707 : Cmp_AcTrfase", "IPR002125 : CMP_dCMP_Zn_bd", "IPR004232 : CN_Hdrtase_asu/SCN_Hdrlase_gsu", 
                      "IPR003673 : CoA-Trfase_fam_III", "IPR003781 : CoA_bd", "IPR011763 : COA_CT_C", 
                      "IPR011762 : COA_CT_N", "IPR016453 : Coatomer_beta'_subunit", 
                      "IPR016460 : Coatomer_beta_subunit", "IPR011710 : Coatomer_bsu_C", 
                      "IPR017106 : Coatomer_gamma_subunit", "IPR014863 : Coatomer_gsu_app", 
                      "IPR006692 : Coatomer_WD-assoc_reg", "IPR009316 : COG2", "IPR013167 : COG4", 
                      "IPR000308 : 14-3-3", "IPR005238 : 2-PSlactate_phosphatase", 
                      "IPR012089 : 2-thiocytidine_tRNA_synth_TtcA", "IPR019151 : 20S_Psome_assmbly_chp2", 
                      "IPR016448 : 23S_rRNA_mtfrase", "IPR019585 : 26S_proteasome_reg_su-Rpn7", 
                      "IPR005937 : 26S_Psome_P45", "IPR002888 : 2Fe-2S_bd", "IPR012392 : 3-ktacl-CoA_syn", 
                      "IPR015049 : DUF1900", "IPR015315 : DUF1963", "IPR015403 : DUF1981_SEC7_assoc", 
                      "IPR018553 : DUF2009", "IPR019008 : DUF2012", "IPR019159 : DUF2037", 
                      "IPR019351 : DUF2039", "IPR019140 : DUF2044_membrane", "IPR019158 : DUF2049", 
                      "IPR018609 : DUF2050_pre-mRNA-splic_fac", "IPR003838 : DUF214_permase", 
                      "IPR019363 : DUF2305", "IPR019312 : DUF2363", "IPR019411 : DUF2404_transmembrane", 
                      "IPR019438 : DUF2419", "IPR018838 : DUF2439", "IPR002876 : DUF28", 
                      "IPR005045 : DUF284_TM_euk", "IPR005061 : DUF292_euk", "IPR005176 : DUF298", 
                      "IPR005178 : DUF300", "IPR005514 : DUF316", "IPR005560 : DUF326", 
                      "IPR005651 : DUF343", "IPR007177 : DUF367", "IPR007180 : DUF382", 
                      "IPR006869 : DUF547", "IPR007590 : DUF572", "IPR007603 : DUF580", 
                      "IPR002744 : DUF59", "IPR006735 : DUF602", "IPR002747 : DUF62", 
                      "IPR006984 : DUF652", "IPR007034 : DUF663", "IPR007751 : DUF676_hydro-like", 
                      "IPR007807 : DUF699_ATPase", "IPR000620 : DUF6_TM", "IPR002761 : DUF71_ATP_bd", 
                      "IPR008496 : DUF778", "IPR008504 : DUF786", "IPR008506 : DUF788", 
                      "IPR002781 : DUF81", "IPR008530 : DUF812", "IPR008532 : DUF814", 
                      "IPR002782 : DUF82", "IPR008559 : DUF841_euk", "IPR008564 : DUF846_euk", 
                      "IPR008568 : DUF850_TM_euk", "IPR008576 : DUF858_MeTrfase_lik", 
                      "IPR008580 : DUF862_euk", "IPR010285 : DUF889_euk", "IPR010291 : DUF895_euk", 
                      "IPR010297 : DUF900_hydrolase", "IPR010310 : DUF909_bac", "IPR009262 : DUF914_euk", 
                      "IPR002794 : DUF92_TM", "IPR013029 : DUF933", "IPR009292 : DUF947", 
                      "IPR004130 : DUF_ATP_bd", "IPR019155 : DUF_FPL", "IPR015313 : DUF_Her-1", 
                      "IPR012979 : DUF_NUC189_C", "IPR019390 : DUF_SprT-like", "IPR008181 : dUTP_pyrophosphatase_subfam_1", 
                      "IPR014891 : DWNN_domain", "IPR000375 : Dynamin_central", "IPR001401 : Dynamin_GTPase", 
                      "IPR001372 : Dynein_light_chain_typ-1/2", "IPR014929 : E2_binding", 
                      "IPR016897 : E3_ubiquit_lig_SCF_Skp", "IPR007286 : EAP30", "IPR008610 : Ebp2", 
                      "IPR018249 : EF_HAND_2", "IPR002048 : EF_hand_Ca_bd", "IPR018248 : EF_Hand_dom", 
                      "IPR006210 : EGF-like", "IPR000742 : EGF_3", "IPR013111 : EGF_extracell", 
                      "IPR002049 : EGF_laminin", "IPR009890 : EI24", "IPR015256 : eIF2_C", 
                      "IPR013979 : eIF2A_central-region", "IPR007316 : EIF3_gamma", 
                      "IPR013906 : eIF3_subunit", "IPR008905 : eIF3c_N", "IPR003307 : eIF5C", 
                      "IPR002769 : eIF6", "IPR011488 : EIF_2_alpha", "IPR000949 : ELM2", 
                      "IPR009022 : Elongation_fac_G/III/V", "IPR006638 : Elp3/MiaB/NifB", 
                      "IPR000348 : Emp24_gp25L_p24", "IPR005135 : Endo/exonuclease/phosphatase", 
                      "IPR007581 : Endonuclease-V", "IPR013813 : Endoribo_LPSP/chorism_mut-like", 
                      "IPR006175 : EndoRNase_L-PSP", "IPR005639 : Endotoxin_N", "IPR003651 : Endouclease3_FeS-loop_motif", 
                      "IPR000941 : Enolase", "IPR008992 : Enterotoxin_bac", "IPR008942 : ENTH_VHS", 
                      "IPR001509 : Epimerase_deHydtase", "IPR000261 : EPS15_homology", 
                      "IPR013809 : Epsin-like_N", "IPR001026 : Epsin_N", "IPR011679 : ER_p29_C", 
                      "IPR000133 : ER_ret_rcpt", "IPR006166 : ERCC4_domain", "IPR004403 : eRF1", 
                      "IPR005140 : eRF1_1", "IPR005141 : eRF1_2", "IPR005142 : eRF1_3", 
                      "IPR008570 : ESCRT-II_cplx_vps25-sub", "IPR000801 : Esterase_put", 
                      "IPR013830 : Esterase_SGNH_hydro-type", "IPR009210 : Euk_LigT", 
                      "IPR008917 : Euk_TF_DNA_bd", "IPR004140 : Exo70", "IPR019160 : Exocyst_Exoc1", 
                      "IPR004808 : exoDNase_III", "IPR001247 : ExoRNase_PH_dom1", "IPR015847 : ExoRNase_PH_dom2", 
                      "IPR007112 : Expan_endogl", "IPR007117 : Expan_Lol_pI_C", "IPR013598 : Exportin-1/Importin-b-like", 
                      "IPR014877 : Exportin-1_C", "IPR004342 : EXS_C", "IPR002189 : F-actin_cap_asu", 
                      "IPR018315 : F-actin_cap_asu_actin_bd", "IPR001810 : F-box", 
                      "IPR013953 : FACT_Spt16p", "IPR001698 : Factin_cap_beta", "IPR006076 : FAD-dep_OxRdtase", 
                      "IPR003953 : FAD_bind2_N", "IPR013027 : FAD_pyr_nucl-diS_OxRdtase", 
                      "IPR013601 : FAE1_typ3_polyketide_synth", "IPR006838 : Far-17a_AIG1", 
                      "IPR010431 : Fascin", "IPR003152 : FATC", "IPR001060 : FCH", 
                      "IPR013130 : Fe3_reduct_TM_N", "IPR011167 : Fe_dep_fumarate_hydratase", 
                      "IPR009016 : Fe_hydrogenase", "IPR004108 : Fe_hydrogenase_lsu_C", 
                      "IPR003149 : Fe_hydrogenase_ssu-like", "IPR013352 : Fe_hydrogenase_subset", 
                      "IPR019748 : FERM_central", "IPR000299 : FERM_domain", "IPR018979 : FERM_N", 
                      "IPR001041 : Ferredoxin", "IPR009040 : Ferritin-like", "IPR009078 : Ferritin/RR-like", 
                      "IPR002713 : FF_domain", "IPR013517 : FG-GAP", "IPR015425 : FH2_actin_bd", 
                      "IPR000253 : FHA", "IPR000692 : Fibrillarin", "IPR008616 : Fibro_bd_N", 
                      "IPR008957 : Fibronectin_typ-III-like_fold", "IPR001298 : Filamin", 
                      "IPR017868 : Filamin/ABP280_repeat-like", "IPR007854 : Fip1", 
                      "IPR009076 : FKBP_rapamycin-assoc_FKBP12-bd", "IPR002563 : Flavin_Rdtase_FMN_bd", 
                      "IPR008254 : Flavodoxin/NO_synth", "IPR003680 : Flavodoxin_fold", 
                      "IPR003382 : Flavoprotein", "IPR000262 : FMN-dep_DH", "IPR005025 : FMN_red", 
                      "IPR001678 : Fmu/NOL1/Nop2p", "IPR008981 : FMuLV_rcpt_bd", "IPR000292 : For/Nit_transpt", 
                      "IPR007513 : Four_F5", "IPR019402 : Frag1/DRAM/Sfk1", "IPR011289 : Fruc_bis_ald_", 
                      "IPR018951 : Fumarase_C_C", "IPR000362 : Fumarate_lyase", "IPR011602 : Fumble", 
                      "IPR001138 : Fungi_Trscrp_N", "IPR006212 : Furin_repeat", "IPR020472 : G-protein_beta_WD-40_rep_reg", 
                      "IPR001748 : G10", "IPR001672 : G6P_Isomerase", "IPR000467 : G_patch", 
                      "IPR011043 : Gal_Oxase/kelch_b-propeller", "IPR000705 : Galactokinase", 
                      "IPR008979 : Galactose-bd-like", "IPR005886 : GalE", "IPR019539 : GalKase_gal_bd", 
                      "IPR002454 : Gamma_tubulin", "IPR007504 : Gar1_RNA-bd_reg", "IPR000583 : GATase_2", 
                      "IPR017932 : GATase_II", "IPR011641 : GCC2_GCC3", "IPR000182 : GCN5-rel_AcTrfase", 
                      "IPR010401 : GDE_C", "IPR018203 : GDP_dissociation_inhibitor", 
                      "IPR003130 : GED", "IPR007122 : Gelsolin", "IPR007123 : Gelsoln", 
                      "IPR001191 : Gemini_AL1", "IPR001301 : Gemini_AL1_CLV", "IPR006204 : GHMP_kinase", 
                      "IPR013750 : GHMP_kinase_C", "IPR005127 : Giardia_VSP", "IPR005339 : GINS_Psf1", 
                      "IPR007257 : GINS_Psf2", "IPR008591 : GINS_Sld5", "IPR006148 : Glc/Gal-6P_isomerase", 
                      "IPR002347 : Glc/ribitol_DH", "IPR007720 : GlcNAc_Gpi1", "IPR003737 : GlcNAc_PIno_de-acetylase", 
                      "IPR004514 : Gln-tRNA-synth_Ic", "IPR007639 : Gln-tRNA-synth_Ic_RNA-bd_1", 
                      "IPR008146 : Gln_synth_cat", "IPR009050 : Globin-like", "IPR000971 : Globin_subset", 
                      "IPR004526 : Glu-tRNA-synth_Ic_arc/euk", "IPR020058 : Glu/Gln-tRNA-synth_Ic_cat-dom", 
                      "IPR020059 : Glu/Gln-tRNA-synth_Ic_codon-bd", "IPR020060 : Glu/Gln-tRNA-synth_Ic_N", 
                      "IPR006096 : Glu/Leu/Phe/Val_DH_C", "IPR007788 : Glu_cyclase_2", 
                      "IPR018322 : Glucosamine6P_isomerase_subgr", "IPR002109 : Glutaredoxin", 
                      "IPR010987 : Glutathione-S-Trfase_C-like", "IPR001419 : Glutenin", 
                      "IPR004360 : Glyas_bleo-R_dOase", "IPR000173 : GlycerAld_3-P_DH_subfam", 
                      "IPR006424 : Glyceraldehyde-3-P_DH_1", "IPR004381 : Glycerate_kinase", 
                      "IPR004129 : GlyceroP-diester-Pdiesterase", "IPR011833 : Glycg_phsphrylas", 
                      "IPR011013 : Glyco_hydro-type_carb-bd", "IPR011330 : Glyco_hydro/deAcase_b/a-brl", 
                      "IPR001223 : Glyco_hydro18cat", "IPR006046 : Glyco_hydro_13", 
                      "IPR006047 : Glyco_hydro_13_cat", "IPR004193 : Glyco_hydro_13_N", 
                      "IPR006589 : Glyco_hydro_13_sub_cat", "IPR001554 : Glyco_hydro_14", 
                      "IPR001540 : Glyco_hydro_20", "IPR015883 : Glyco_hydro_20_cat-core", 
                      "IPR001916 : Glyco_hydro_22", "IPR002053 : Glyco_hydro_25", "IPR006104 : Glyco_hydro_2_carb-bd", 
                      "IPR006102 : Glyco_hydro_2_Ig-like", "IPR000322 : Glyco_hydro_31", 
                      "IPR002772 : Glyco_hydro_3_C", "IPR001764 : Glyco_hydro_3_N", 
                      "IPR001547 : Glyco_hydro_5", "IPR003385 : Glyco_hydro_77", "IPR012939 : Glyco_hydro_92", 
                      "IPR002044 : Glyco_hydro_carb-bd", "IPR017853 : Glyco_hydro_catalytic_core", 
                      "IPR001296 : Glyco_trans_1", "IPR001173 : Glyco_trans_2", "IPR007235 : Glyco_trans_28_C", 
                      "IPR002659 : Glyco_trans_31", "IPR000811 : Glyco_trans_35", "IPR002495 : Glyco_trans_8", 
                      "IPR013534 : Glyco_transf_5", "IPR018481 : Glycosyl_Trfase_4_cons-reg", 
                      "IPR011171 : GMF-beta", "IPR014813 : GN3L_Grn1", "IPR009038 : GOLD", 
                      "IPR019383 : Golgin_A_7/ERF4", "IPR007305 : Got1", "IPR017981 : GPCR_2-like", 
                      "IPR011500 : GPCR_3_NCR", "IPR017452 : GPCR_Rhodpsn_supfam", 
                      "IPR007245 : Gpi16", "IPR001770 : Gprotein-gamma", "IPR001019 : Gprotein_alpha_su", 
                      "IPR001632 : Gprotein_B", "IPR011025 : GproteinA_insert", "IPR004182 : GRAM", 
                      "IPR000237 : GRIP", "IPR011032 : GroES-like", "IPR009030 : Growth_fac_rcpt", 
                      "IPR006073 : GTP1_OBG", "IPR014768 : GTPase_bd/formin_homology_3", 
                      "IPR003579 : GTPase_Rab", "IPR003577 : GTPase_Ras", "IPR003578 : GTPase_Rho", 
                      "IPR006762 : Gtr1_RagA", "IPR007267 : GtrA", "IPR014311 : Guanine_deaminase", 
                      "IPR016346 : Guanine_nucleotide-bd_bsu", "IPR015900 : Guanylate-bd-like_C", 
                      "IPR015894 : Guanylate-bd_N", "IPR008144 : Guanylate_kin", "IPR017665 : Guanylate_kinase_sub", 
                      "IPR000879 : Guanylin", "IPR008145 : Guanylt/Ca", "IPR009447 : GWT1", 
                      "IPR003169 : GYF", "IPR011557 : GyrB", "IPR019019 : H-type_lectin_domain", 
                      "IPR013200 : HAD-SF_hydro-like_3", "IPR006402 : HAD-SF_hydro_IA_v3", 
                      "IPR006383 : HAD-SF_hydro_IB_PSP-like", "IPR006357 : HAD-SF_hydro_IIA", 
                      "IPR006353 : HAD-SF_hydro_IIA_CECR5", "IPR006379 : HAD-SF_hydro_IIB", 
                      "IPR006549 : HAD-SF_hydro_IIIA", "IPR005833 : Haloacid_DH/epoxide_hydro", 
                      "IPR002637 : Ham1p-like", "IPR003107 : HAT", "IPR019467 : Hat1_N", 
                      "IPR008906 : HATC", "IPR009886 : HCaRG", "IPR000357 : HEAT", 
                      "IPR006121 : HeavyMe_transpt", "IPR000569 : HECT", "IPR014013 : Helic_SF1/SF2_ATP-bd_DinG/Rad3", 
                      "IPR009051 : Helical_ferredxn", "IPR007502 : Helicase-assoc_reg", 
                      "IPR006554 : Helicase-like_DEXD_c2", "IPR002121 : Helicase/RNaseD_C", 
                      "IPR006555 : Helicase_ATP-dep_c2", "IPR014021 : Helicase_SF1/SF2_ATP-bd", 
                      "IPR000605 : Helicase_SF3_ssDNA/RNA_vir", "IPR020441 : Helix-turn-helix_Fis", 
                      "IPR004557 : HemK_rel_arch", "IPR000585 : Hemopexin/matrixin", 
                      "IPR001451 : Hexapep_transf", "IPR015882 : HexNAc-like_b", "IPR001312 : Hexokinase", 
                      "IPR003265 : HhH-GPD_domain", "IPR008918 : HhH2", "IPR000445 : HhH_motif", 
                      "IPR000170 : High_potential_FeS_prot", "IPR015807 : His-tRNA-synth_IIa_sub", 
                      "IPR004516 : His-tRNA_synth_IIA", "IPR000286 : His_deacetylse", 
                      "IPR003084 : His_deacetylse_1", "IPR011146 : His_triad-like_motif", 
                      "IPR017380 : Hist_AcTrfase_B-typ_cat-su", "IPR005910 : Hist_AcTrfase_ELP3", 
                      "IPR000560 : Histidine_acid_Pase", "IPR001310 : Histidine_triad_HIT", 
                      "IPR009072 : Histone-fold", "IPR006818 : Histone_chaperone_ASF1-like", 
                      "IPR007125 : Histone_core_D", "IPR002119 : Histone_H2A", "IPR000558 : Histone_H2B", 
                      "IPR000164 : Histone_H3", "IPR001951 : Histone_H4", "IPR011598 : HLH_DNA_bd", 
                      "IPR004254 : HlyIII_related", "IPR009023 : HMG_CoA_Rdtase_NAD(P)-bd", 
                      "IPR000910 : HMG_HMG1/HMG2", "IPR000135 : HMG_HMG1/HMG2_subgr", 
                      "IPR002415 : HMG_nuclear", "IPR009071 : HMG_superfamily", "IPR013749 : HMP-P_kinase-1", 
                      "IPR001356 : Homeobox", "IPR009057 : Homeodomain-like", "IPR003511 : HORMA_DNA_bd", 
                      "IPR011072 : HR1_rho-bd", "IPR010997 : HRDC-like", "IPR005578 : Hrf1", 
                      "IPR000232 : HSF_DNA_bd", "IPR002068 : Hsp20", "IPR008978 : HSP20-like_chaperone", 
                      "IPR008971 : HSP40/DnaJ_pept-bd", "IPR001023 : Hsp70", "IPR020576 : Hsp90_C", 
                      "IPR020575 : Hsp90_N", "IPR013126 : Hsp_70", "IPR003095 : Hsp_DnaJ", 
                      "IPR001305 : HSP_DnaJ_cys-rich", "IPR001387 : HTH_3", "IPR012318 : HTH_CRP_2", 
                      "IPR000835 : HTH_MarR", "IPR007150 : Hus1", "IPR010048 : Hybrid_clust", 
                      "IPR000150 : Hypothet_cof", "IPR009428 : ICAT", "IPR007269 : ICMT_MeTrfase", 
                      "IPR000649 : IF-2B_related", "IPR007110 : Ig-like", "IPR009063 : Ig/albumin-bd", 
                      "IPR014756 : Ig_E-set", "IPR010992 : IHF-like_DNA_bd", "IPR006849 : IKI3", 
                      "IPR002301 : Ile-tRNA-synt_Ia", "IPR015905 : Ile-tRNA-synt_Ia_N", 
                      "IPR002558 : ILWEQ", "IPR001494 : Importin-b_N", "IPR007342 : Indigdn_synthA", 
                      "IPR003891 : Initiation_fac_eIF4g_MI", "IPR000525 : Initiator_Rep_prot", 
                      "IPR001910 : Inosine/uridine_Nucl_hydrolase", "IPR000760 : Inositol_monophosphatase", 
                      "IPR017427 : Inositol_tetrakis-P_1-kinase", "IPR008656 : Ins134_P3_kin", 
                      "IPR003460 : Insect_antifreeze_prot_motif", "IPR016179 : Insulin-like", 
                      "IPR019185 : Integral_memb_SYS1-rel", "IPR001584 : Integrase_cat-core", 
                      "IPR002104 : Integrase_cat-core_phage", "IPR002678 : Interacting_NIF3", 
                      "IPR000779 : Interleukin-2", "IPR008964 : Invasin/intimin_cell_adhesion", 
                      "IPR013099 : Ion_trans_2", "IPR011179 : IPdP_isomerase", "IPR005522 : IPK", 
                      "IPR000300 : IPPc", "IPR002627 : IPPT", "IPR002909 : IPT_TIG_rcpt", 
                      "IPR000048 : IQ_CaM_bd_region", "IPR000868 : Isochorismatase-like", 
                      "IPR001804 : Isocitrate/isopropylmalate_DH", "IPR009360 : Isy1", 
                      "IPR003131 : K_chnl_volt-dep_Kv_tetra", "IPR006652 : Kelch_1", 
                      "IPR011498 : Kelch_2", "IPR010513 : KEN_RNase_activator", "IPR000771 : Ketose_bisP_aldolase_II", 
                      "IPR004087 : KH", "IPR009019 : KH_prok-type", "IPR004088 : KH_type_1", 
                      "IPR018111 : KH_type_1_subgr", "IPR004044 : KH_type_2", "IPR003900 : KID_repeat", 
                      "IPR011009 : Kinase-like_dom", "IPR001752 : Kinesin_motor", "IPR005824 : KOW", 
                      "IPR007851 : Kri1_subgr", "IPR001909 : Krueppel-associated_box", 
                      "IPR014893 : Ku_PK_bind", "IPR008948 : L-Aspartase-like", "IPR001557 : L-lactate/malate_DH", 
                      "IPR003386 : LACT", "IPR001236 : Lactate/malate_DH", "IPR015955 : Lactate_DH/Glyco_Ohase_4_C", 
                      "IPR010982 : Lambda_DNA-bd", "IPR012680 : Laminin_G_2", "IPR007174 : Las1", 
                      "IPR002172 : LDL_rcpt_classA_cys-rich", "IPR005052 : Lectin_leg", 
                      "IPR001611 : Leu-rich_rpt", "IPR013101 : Leu-rich_rpt_2", "IPR006553 : Leu-rich_rpt_Cys-con_subtyp", 
                      "IPR013210 : Leu-rich_rpt_N", "IPR003590 : Leu-rich_rpt_RNase_inh_sub-typ", 
                      "IPR003591 : Leu-rich_rpt_typical-subtyp", "IPR004493 : Leu-tRNA-synth_Ia_arc/euk", 
                      "IPR017305 : Leupaxin", "IPR006649 : Like-Sm_rNuclprot_core_euk/arc", 
                      "IPR002921 : Lipase_3", "IPR001087 : Lipase_GDSL", "IPR008976 : Lipase_LipOase", 
                      "IPR013819 : LipOase_C", "IPR006594 : LisH_dimerisation", "IPR013720 : LisH_dimerisation_sub", 
                      "IPR006629 : LITAF", "IPR006876 : LMBR1", "IPR010908 : Longin", 
                      "IPR011012 : Longin-like", "IPR010920 : LSM_related_core", "IPR001163 : LSM_snRNP_core", 
                      "IPR002344 : Lupus_La", "IPR006630 : Lupus_La_RNA_bd", "IPR002313 : Lys-tRNA-synth_II", 
                      "IPR018149 : Lys-tRNA-synth_II_C", "IPR004843 : M-pesterase", 
                      "IPR001398 : Macrophage_inhib_fac", "IPR003619 : MAD_homology1_Dwarfin-type", 
                      "IPR003697 : Maf", "IPR002190 : MAGE", "IPR004023 : Mago_nashi", 
                      "IPR006958 : Mak16", "IPR003767 : Malate/L-lactate_DH", "IPR010945 : Malate_DH_SF1", 
                      "IPR004315 : Male_ac_gland_sc", "IPR013120 : Male_sterile_NAD-bd", 
                      "IPR012301 : Malic_N", "IPR012302 : Malic_NAD_bd", "IPR016132 : Phyto_chromo_attachment", 
                      "IPR000403 : PI3/4_kinase_cat", "IPR002420 : PI3K_C2", "IPR000341 : PI3K_ras_bd", 
                      "IPR008290 : PI3K_Vps34", "IPR001263 : PI3Ka", "IPR013717 : PIG-P", 
                      "IPR009600 : PIG-U", "IPR013233 : PIG_X_PBN1", "IPR013234 : PIGA_GPI_anchor_biosynthesis", 
                      "IPR003151 : PIK-rel_kinase_FAT", "IPR014009 : PIK_FAT", "IPR006596 : PINc_nuc_bd", 
                      "IPR002498 : PInositol-4-P-5-kinase_core", "IPR016034 : PInositol-4P-5-kinase_core_sub", 
                      "IPR003165 : Piwi", "IPR017892 : Pkinase_C", "IPR015155 : PLAA_fam_Ub_bd_PFU", 
                      "IPR017946 : PLC-like_Pdiesterase_TIM-brl", "IPR001849 : Pleckstrin_homology", 
                      "IPR003659 : Plexin-like", "IPR016201 : Plexin-like_fold", "IPR002165 : Plexin_repeat", 
                      "IPR001736 : PLipase_D/transphosphatidylase", "IPR009450 : Plno_GlcNAc_GPI2", 
                      "IPR004343 : Plus-3", "IPR005002 : PMM", "IPR013954 : PNK3P_central-region", 
                      "IPR016195 : Pol/histidinol_Pase-like", "IPR007012 : PolA_pol_centr", 
                      "IPR000959 : POLO_box_duplicated", "IPR007724 : Poly_GlycHdrlase", 
                      "IPR002646 : PolyA_pol_reg", "IPR012337 : PolynucTfrase_RNaseH_fold", 
                      "IPR000092 : Polyprenyl_synt", "IPR002509 : Polysac_deacetylase", 
                      "IPR012590 : POPLD", "IPR004969 : Pox_I1", "IPR004971 : Pox_MCEL", 
                      "IPR019578 : PP2A_Bsu_A/B_central-region", "IPR000009 : PP2A_PR55", 
                      "IPR019573 : PP2A_suB_N", "IPR001932 : PP2C-related", "IPR014045 : PP2C_N", 
                      "IPR011063 : PP_loop", "IPR002192 : PPDK_PEP_bd", "IPR002130 : PPIase_cyclophilin", 
                      "IPR001179 : PPIase_FKBP", "IPR000297 : PPIase_PpiC", "IPR013235 : PPP5", 
                      "IPR011236 : PPPtase_5", "IPR018391 : PQQ_beta_propeller_repeat", 
                      "IPR000730 : Pr_cel_nuc_antig", "IPR018800 : PRCC_C", "IPR011078 : Prd-pyrdxlP-dep_enz_YBL036C", 
                      "IPR012591 : Pre-mRNA-splicing_factor-8", "IPR013881 : Pre-mRNA_splic_Prp3", 
                      "IPR019398 : Pre-rRNA_process_TSR2_cons_reg", "IPR016185 : PreATP-grasp-like", 
                      "IPR009053 : Prefoldin", "IPR016655 : Prefoldin_su-3", "IPR006797 : PRELI/MSF1", 
                      "IPR002088 : Prenyl_trans_a", "IPR001330 : Prenyltrans", "IPR000836 : PRibTrfase", 
                      "IPR004137 : Prismane", "IPR011254 : Prismane-like", "IPR006083 : PRK_URK", 
                      "IPR008286 : Prn/Lys/Arg_de-COase_C", "IPR002316 : Pro-tRNA-synth_IIa_cons-reg", 
                      "IPR004499 : Pro-tRNA-synth_IIa_pro-type", "IPR017449 : Pro-tRNA_synth_II", 
                      "IPR016061 : Pro-tRNA_synth_II_C", "IPR012984 : PRO_C", "IPR012592 : PROCN", 
                      "IPR002097 : Profilin", "IPR005455 : Profilin_plant", "IPR009966 : Prosystemin", 
                      "IPR002919 : Prot_Inh_CR_TIL", "IPR018990 : Prot_inh_I42_chagasin", 
                      "IPR002223 : Prot_inh_Kunz-m", "IPR013201 : Prot_inhib_I29", 
                      "IPR002219 : Prot_Kinase_C-like_PE/DAG_bd", "IPR000719 : Prot_kinase_cat_dom", 
                      "IPR016085 : Protease_inh_b-brl", "IPR000215 : Protease_inhib_I4_serpin", 
                      "IPR000426 : Proteasome_asu_CS", "IPR001353 : Proteasome_sua/b", 
                      "IPR011052 : Proteinase_amylase_inhib", "IPR000795 : ProtSyn_GTP_bd", 
                      "IPR010491 : PRP1_N", "IPR019175 : Prp31_C", "IPR005037 : PRP38", 
                      "IPR014906 : PRP4", "IPR019581 : Prp8_U5-snRNA-bd", "IPR019580 : Prp8_U6-snRNA-bd", 
                      "IPR005946 : PRPP_kinase", "IPR020103 : PsdUridine_synth_cat_dom", 
                      "IPR004802 : PsdUridine_synth_put", "IPR006225 : PsdUridine_synth_RluC/D", 
                      "IPR006145 : PsdUridine_synth_RsuA/RluD", "IPR001406 : PsdUridine_synth_TruA", 
                      "IPR020097 : PsdUridine_synth_TruA_a/b_dom", "IPR002501 : PsdUridine_synth_TruB_N", 
                      "IPR001656 : PsdUridine_synth_TruD", "IPR017091 : PsdUridine_synth_TruD_euk", 
                      "IPR011760 : PsdUridine_synth_TruD_insert", "IPR003248 : Pser_amintransf", 
                      "IPR005137 : PSI_BtpA", "IPR006568 : PSP", "IPR004277 : PSS", 
                      "IPR006970 : PT", "IPR019540 : PtdIno-glycan_biosynth_class_S", 
                      "IPR002745 : Ptrans_KptA/Tpt1", "IPR004701 : PTS_EIIA_fruc", 
                      "IPR008731 : PTS_PEP_utilis_N", "IPR002478 : PUA", "IPR015947 : PUA-like", 
                      "IPR006567 : PUG-dom", "IPR001313 : Pumilio_RNA_bd", "IPR004859 : Put_53exo", 
                      "IPR002483 : PWI", "IPR000313 : PWWP", "IPR001683 : PX", "IPR003379 : PYC_OADA", 
                      "IPR000891 : PYR_CT", "IPR001327 : Pyr_OxRdtase_NAD_bd", "IPR002129 : PyrdxlP-dep_de-COase", 
                      "IPR001926 : PyrdxlP-dep_enz_bsu", "IPR015424 : PyrdxlP-dep_Trfase_major", 
                      "IPR004625 : PyrdxlP_synth_PyrdxlKinase", "IPR000103 : Pyridine_nuc-diS_OxRdtase_2", 
                      "IPR011576 : PyridoxamineP_oxidase_FMN-bd", "IPR012004 : PyroP-dep_PFruKinase_TP0108", 
                      "IPR008162 : Pyrophosphatase", "IPR010121 : Pyruvate_phosphate_dikinase", 
                      "IPR019456 : Pyrv-flavodox_OxRtase_EKR", "IPR016431 : Pyrv-formate_lyase-activ_prd", 
                      "IPR019752 : Pyrv/ketoisovalerate_OxRed", "IPR015813 : Pyrv/PenolPyrv_Kinase_cat", 
                      "IPR002880 : Pyrv_Fd/Flavodoxin_OxRdtase_N", "IPR011895 : Pyrv_flavodox_OxRed", 
                      "IPR002869 : Pyrv_flavodox_OxRed_cen", "IPR011037 : Pyrv_Knase_b-brl-like", 
                      "IPR015793 : Pyrv_Knase_brl", "IPR004803 : Queuine_tRNA-ribosylTrfase", 
                      "IPR011047 : Quino_AlcDH-like", "IPR011044 : Quino_amine_DH_bsu", 
                      "IPR001374 : R3H_ss_bd", "IPR002005 : Rab_GDI_REP", "IPR000195 : RabGAP_TBC", 
                      "IPR000806 : RabGDI", "IPR006909 : Rad21/Rec8_C", "IPR006910 : Rad21_Rec8_N", 
                      "IPR014761 : Rad23_C", "IPR007232 : Rad52_Rad22", "IPR007197 : Radical_SAM", 
                      "IPR002041 : Ran_GTPase", "IPR000156 : RanBP", "IPR000331 : Rap_GAP", 
                      "IPR004083 : Raptor", "IPR013753 : Ras", "IPR000651 : Ras-like_Gua-exchang_fac_N", 
                      "IPR008937 : Ras_GEF", "IPR001806 : Ras_GTPase", "IPR001936 : RasGAP", 
                      "IPR000593 : RasGAP_C", "IPR001895 : RasGRF_CDC25", "IPR005304 : Rbsml_bgen_MeTrfase_EMG1/NEP1", 
                      "IPR003029 : Rbsml_prot_S1_RNA-bd_dom", "IPR005155 : Rbsml_synth_fac_NIP7-like", 
                      "IPR006037 : RCK_C", "IPR003148 : RCK_N", "IPR020587 : RecA_monomer-monomer_interface", 
                      "IPR003395 : RecF/RecN/SMC_N", "IPR001125 : Recoverin", "IPR000408 : Reg_chr_condens", 
                      "IPR009091 : Reg_csome_cond/b-lactamase_inh", "IPR011256 : Reg_factor_effector_bac", 
                      "IPR000342 : Regulat_G_prot_signal", "IPR016137 : Regulat_G_prot_signal_superfam", 
                      "IPR013955 : Rep_factor-A_C", "IPR013748 : Replication_factor_C", 
                      "IPR018777 : Replication_initiator_prot_A", "IPR004932 : Rer1", 
                      "IPR014914 : RES", "IPR006120 : Resolv_hlx-trn-hlx", "IPR006935 : Restrct_endonuc_I_R/III_Res", 
                      "IPR000289 : Ribosomal_S28e", "IPR005707 : Ribosomal_S2_euk/arc", 
                      "IPR006846 : Ribosomal_S30", "IPR003489 : Ribosomal_S30Ae/sigma54_mod", 
                      "IPR001351 : Ribosomal_S3_C", "IPR005703 : Ribosomal_S3_euk/arc", 
                      "IPR001593 : Ribosomal_S3Ae", "IPR001912 : Ribosomal_S4", "IPR005710 : Ribosomal_S4/S9_euk/arc", 
                      "IPR013845 : Ribosomal_S4e_central", "IPR013843 : Ribosomal_S4e_N", 
                      "IPR005324 : Ribosomal_S5_C", "IPR020568 : Ribosomal_S5_D2-typ_fold", 
                      "IPR005711 : Ribosomal_S5_euk/arc", "IPR013810 : Ribosomal_S5_N", 
                      "IPR014401 : Ribosomal_S6_euk", "IPR001377 : Ribosomal_S6e", 
                      "IPR000235 : Ribosomal_S7", "IPR005716 : Ribosomal_S7_euk/arc", 
                      "IPR000554 : Ribosomal_S7e", "IPR000630 : Ribosomal_S8", "IPR001047 : Ribosomal_S8e", 
                      "IPR000754 : Ribosomal_S9", "IPR016686 : Ribosomal_synth_fac_NIP7", 
                      "IPR011332 : Ribosomal_zn-bd", "IPR019002 : Ribosome_biogenesis_Nop16", 
                      "IPR018978 : Ribosome_mat_SBDS_C", "IPR019783 : Ribosome_mat_SBDS_N", 
                      "IPR002140 : Ribosome_maturation_pr_SBDS", "IPR005502 : Ribosyl_crysJ1", 
                      "IPR000056 : Ribul_P_3_epim", "IPR011060 : RibuloseP-bd_barrel", 
                      "IPR008997 : Ricin_B-rel_lectin", "IPR000772 : Ricin_B_lectin", 
                      "IPR018934 : RIO-like_kinase", "IPR015285 : RIO2_kinase_winged_hlx_N", 
                      "IPR000687 : RIO_kinase", "IPR005132 : RlpA", "IPR011108 : RMMBL", 
                      "IPR007855 : RNA-dep_RNA_pol_euk-typ", "IPR018999 : RNA-helicase_UPF1_UPF2-interct", 
                      "IPR000228 : RNA3'_term_phos_cycl-like", "IPR016443 : RNA3'_term_phos_cycl-like_euk", 
                      "IPR013796 : RNA3'_term_phos_cycl_insert", "IPR013792 : RNA3'P_cycl/enolpyr_Trfase_a/b", 
                      "IPR019012 : RNA_cap_Gua-N2-MeTrfase", "IPR016438 : RNA_helicase_ATP-dep_SK12/DOB1", 
                      "IPR014014 : RNA_helicase_DEAD_Q_motif", "IPR012647 : RNA_lig_RNL2", 
                      "IPR009097 : RNA_ligase/cNuc_Pdiesterase", "IPR000241 : RNA_methylase", 
                      "IPR007852 : RNA_pol_access_fac_Cdc73", "IPR000722 : RNA_pol_asu", 
                      "IPR007644 : RNA_pol_bsu_protrusion", "IPR013929 : RNA_pol_II_AP1_C", 
                      "IPR006811 : RNA_pol_II_suA", "IPR017415 : RNA_pol_II_tscrpt_coact_KELP", 
                      "IPR019000 : RNA_Pol_III_su-C17", "IPR006592 : RNA_pol_N", "IPR000268 : RNA_pol_N/8_sub", 
                      "IPR013238 : RNA_pol_Rbc25", "IPR007080 : RNA_pol_Rpb1_1", "IPR007066 : RNA_pol_Rpb1_3", 
                      "IPR007083 : RNA_pol_Rpb1_4", "IPR007081 : RNA_pol_Rpb1_5", "IPR007075 : RNA_pol_Rpb1_6", 
                      "IPR007073 : RNA_pol_Rpb1_7", "IPR007642 : RNA_pol_Rpb2_2", "IPR007645 : RNA_pol_Rpb2_3", 
                      "IPR007646 : RNA_pol_Rpb2_4", "IPR007647 : RNA_pol_Rpb2_5", "IPR007641 : RNA_pol_Rpb2_7", 
                      "IPR005571 : RNA_pol_Rpb5_N", "IPR005576 : RNA_pol_Rpb7_N", "IPR005570 : RNA_pol_Rpb8", 
                      "IPR007832 : RNA_pol_Rpc34", "IPR007811 : RNA_pol_Rpc4", "IPR013324 : RNA_pol_sigma_r3_r4", 
                      "IPR000783 : RNA_pol_subH/Rpb5_C", "IPR006110 : RNA_poly_Rpb6", 
                      "IPR006569 : RNA_polymerase_II_lsu_CTD", "IPR006941 : RNase_CAF1", 
                      "IPR004649 : RNase_H2_suA", "IPR001352 : RNase_HII/HIII", "IPR001900 : RNase_II/R", 
                      "IPR000999 : RNase_III", "IPR002730 : RNase_P/MRP_p29_euk/arc", 
                      "IPR009723 : RNase_P/MRP_POP1", "IPR002738 : RNase_P_p30", "IPR002759 : RNase_P_related", 
                      "IPR001568 : RNase_T2", "IPR001427 : RNaseA", "IPR007209 : RNaseL-inhib_metal-bd", 
                      "IPR003042 : Rng_hydrolase-like", "IPR000769 : Rop_reg", "IPR002107 : Rotavirus_NSP4", 
                      "IPR007779 : Rotavirus_VP2", "IPR004785 : RpiB", "IPR007175 : Rpr2", 
                      "IPR003703 : Acyl_CoA_thio", "IPR015100 : Anti-sigma_A", "IPR007241 : Autophagy-rel_prot_9", 
                      "IPR005499 : BioW", "IPR001762 : Blood-coag_inhib_Disintegrin", 
                      "IPR018231 : BRCA2_repeat_subgroup", "IPR015877 : Cdk-activating_kinase_MAT1", 
                      "IPR000038 : Cell_Div_GTP_bd", "IPR000158 : Cell_division_FtsZ_N", 
                      "IPR011006 : CheY-like", "IPR017984 : Chromo_dom_subgr", "IPR018125 : Chromo_shadow_sbgrp", 
                      "IPR001180 : Citron", "IPR010655 : Clp1", "IPR007673 : Condensin_D2_su", 
                      "IPR003136 : Cytidylate_kin", "IPR011994 : Cytidylate_kin_d", 
                      "IPR001017 : DH_E1", "IPR012259 : DHFR", "IPR018444 : Dil_domain", 
                      "IPR011114 : DNA_helicas_Holl-junc_RuvA_C", "IPR016722 : DNA_pol_alpha_bsu", 
                      "IPR004585 : DNA_recomb/repair_Rad52", "IPR018326 : DNA_repair_Rad4_DNA-bd_1", 
                      "IPR018327 : DNA_repair_Rad4_DNA-bd_2", "IPR012178 : DNA_replication_fac_C_lsu", 
                      "IPR012468 : DUF1686", "IPR003807 : DUF202", "IPR019273 : DUF2296", 
                      "IPR019081 : DUF2463", "IPR001719 : Endodeoxyribonuclease_IV", 
                      "IPR015152 : EpoR_lig-bind", "IPR017905 : ERV/ALR_sulphydryl_oxidase", 
                      "IPR000447 : FAD-dep_Gly3P_DH", "IPR011947 : FCP1_euk", "IPR008331 : Ferritin_Dps", 
                      "IPR011034 : Formyl_transferase_C-like", "IPR002908 : Frataxin-like", 
                      "IPR003888 : FYrich_N", "IPR000407 : GDA1_CD39_NTPase", "IPR000101 : GGT_peptidase", 
                      "IPR016906 : GINS_Psf2_subgr", "IPR000294 : GLA_domain", "IPR018608 : Gluconate_transp_1/Pac2", 
                      "IPR000889 : Glutathione_peroxidase", "IPR000726 : Glyco_hydro_19_cat", 
                      "IPR001661 : Glyco_hydro_37", "IPR002685 : Glyco_trans_15", "IPR003342 : Glyco_trans_39", 
                      "IPR009101 : Gurmarin-lik_inhib/Antifun_tox", "IPR017282 : Hist_deposition_Asf1", 
                      "IPR020479 : Homeobox_region", "IPR014840 : HPC2", "IPR018996 : Inner-Nucl-membr_MAN1_C", 
                      "IPR004042 : Intein_endonuc", "IPR001228 : ISPD_synthase", "IPR017944 : KaiA/RbsU_helical_domain", 
                      "IPR005550 : Kinetochore_Ndc80", "IPR005549 : Kinetochore_Nuf2", 
                      "IPR004238 : LEA", "IPR009604 : LsmAD_domain", "IPR008672 : MAD", 
                      "IPR007018 : Mediator_Med6", "IPR010565 : Muskelin_N", "IPR006168 : NAD-dep_Gly3P_DH", 
                      "IPR011128 : NAD-dep_Gly3P_DH_N", "IPR006109 : NAD_Gly3P_DH_C", 
                      "IPR007716 : NPL4_Zn_bd_put", "IPR018767 : Nucleus_export_prot_Brr6", 
                      "IPR000109 : Oligopeptide_transporter", "IPR007203 : ORMDL", 
                      "IPR019400 : Peptidase_C65_otubain", "IPR001590 : Peptidase_M12B", 
                      "IPR008283 : Peptidase_M17_N", "IPR007217 : Per1", "IPR019263 : Phosphate_transporter_Pho88", 
                      "IPR012098 : Phosphate_transptr_Pho88_fun", "IPR016270 : PLipase-D_PtdSer-synthase-type", 
                      "IPR016555 : PLipase_D_euk", "IPR018144 : Plus3-dom_subgr", "IPR001370 : Prot_inh_I32_IAP", 
                      "IPR010259 : Prot_inh_S8A", "IPR007557 : PSP1_C", "IPR003180 : PurDNA_glycsylse", 
                      "IPR013144 : Ran-bd_prot-like_CRA_domain", "IPR007199 : Rep-A_N", 
                      "IPR013509 : Ribncl_Rdtase_lsu_N", "IPR004788 : Ribose-5-phosphate_isomerase", 
                      "IPR007528 : RINT1_TIP1", "IPR001890 : RNA-binding_CRM", "IPR000606 : RNA_helicase1_vir", 
                      "IPR014646 : RPA32", "IPR005097 : Saccharopine_DH", "IPR016491 : Septin", 
                      "IPR001085 : Ser_HO-MeTrfase", "IPR003096 : SM22_calponin", "IPR004761 : Spore_GerAB", 
                      "IPR019835 : SWIB_domain", "IPR007900 : TAF4", "IPR006809 : TAFII28", 
                      "IPR001766 : TF_fork_head", "IPR003120 : TF_STE", "IPR004855 : TFIIA_asu/bsu", 
                      "IPR015872 : TFIIA_gsu_N", "IPR007582 : TFIID-su_WD40-assoc_reg", 
                      "IPR017919 : TFIIE/TFIIEa_HTH", "IPR003196 : TFIIF_beta", "IPR011039 : TFIIF_interaction", 
                      "IPR017923 : TFIIS_N", "IPR017890 : TFS2M", "IPR003397 : Tim17/Tim22", 
                      "IPR006645 : Transcrpt_antiterm_NusG_N", "IPR014039 : Transl_elong_EFTs/EF1B_dimer", 
                      "IPR019815 : Translation_initiation_fac_3_C", "IPR011667 : UPF0329", 
                      "IPR018618 : Vacuolar_import/degrad_Vid24", "IPR018966 : VTC_domain", 
                      "IPR000465 : XPA", "IPR012307 : Xyl_isomerase_TIM-brl", "IPR006572 : Znf_DBF", 
                      "IPR011961 : 16S_RimM", "IPR011278 : 2-MeCitrate/Citrate_synth_I", 
                      "IPR001078 : 2-oxoacid_DH_actylTfrase", "IPR019538 : 26S_Psome_nonATP_su5", 
                      "IPR013586 : 26S_Psome_reg_C", "IPR011603 : 2oxoglutarate_DH_E1", 
                      "IPR016652 : Ubiquitinyl_hydrolase", "IPR003613 : Ubox", "IPR000011 : UBQ-activ_enz_E1", 
                      "IPR014027 : UDP-Glc/GDP-Man_DHase_C", "IPR014026 : UDP-Glc/GDP-Man_DHase_dimer", 
                      "IPR001732 : UDP-Glc/GDP-Man_DHase_N", "IPR003903 : UIM", "IPR008012 : UMP1", 
                      "IPR001126 : UMUC_like", "IPR005839 : UPF0004", "IPR013848 : UPF0004_N", 
                      "IPR006214 : UPF0005", "IPR001727 : UPF0016", "IPR001498 : UPF0029_N", 
                      "IPR005366 : UPF0172", "IPR001441 : UPP_synth", "IPR000764 : Uridine_kin", 
                      "IPR002413 : V5_allergen", "IPR016763 : Vesicle-associated_membrane", 
                      "IPR013863 : VID27", "IPR006581 : VPS10", "IPR006925 : Vps16_C", 
                      "IPR006926 : Vps16_N", "IPR012501 : Vps54", "IPR011046 : WD40_repeat-like", 
                      "IPR004170 : WWE", "IPR007005 : XAP5", "IPR008165 : XGLTT_domain", 
                      "IPR001044 : XPGC_DNA_repair", "IPR013022 : Xyl_isomerase-like_TIM-brl", 
                      "IPR012307 : Xyl_isomerase-typ_TIM-brl", "IPR004910 : Yippee", 
                      "IPR013272 : YL1_C", "IPR002653 : Znf_A20", "IPR008913 : Znf_CHY", 
                      "IPR002926 : Znf_CONSTANS", "IPR011124 : Znf_CW", "IPR007872 : Znf_DHP", 
                      "IPR015408 : Znf_Mcm10/DnaG", "IPR004217 : Znf_Tim10_DDP", "IPR011016 : ZnF_var-RING", 
                      "IPR007853 : Znf_Zim17", "IPR009361 : Zw10", "IPR010708 : 5'(3')-deoxyribonucleotidase", 
                      "IPR006183 : 6-phosphogluconate_DH", "IPR006114 : 6PGDH_C", "IPR006115 : 6PGDH_NAD-bd", 
                      "IPR020456 : Acylphosphatase", "IPR001792 : Acylphosphatase-like", 
                      "IPR008088 : Alpha_giardin", "IPR003198 : Amidino_trans", "IPR006828 : AMPKBI", 
                      "IPR001464 : Annexin", "IPR018502 : Annexin_repeat", "IPR006034 : Asp/Glutamnse", 
                      "IPR006132 : Asp/Orn_carbamoyltranf_P_bd", "IPR006131 : Asp_carbamoyltransf_Asp/Orn_bd", 
                      "IPR000796 : Asp_trans", "IPR019156 : Ataxin-10_domain", "IPR000749 : ATP-guanido_PTrfase", 
                      "IPR009163 : ATP_adenylyltransferase", "IPR019200 : ATP_adenylyltransferase_C", 
                      "IPR007421 : ATPase_AAA-4", "IPR006069 : ATPase_P-typ_cation-exchng_asu", 
                      "IPR008389 : ATPase_V0-cplx_esu", "IPR019347 : Axonemal_dynein_light_chain", 
                      "IPR009099 : B_lactamas_inhib", "IPR003964 : Bac_carb_kinase", 
                      "IPR017943 : Bactericidal_perm-incr_a/b_dom", "IPR003649 : Bbox_C", 
                      "IPR016140 : Bifunc_inhib/LTP/seed_store", "IPR015215 : BmKX", 
                      "IPR007520 : Bul1_C", "IPR015919 : Cadherin-like", "IPR003117 : cAMP-dep_prot_kin_reg_I/II_a/b", 
                      "IPR001894 : Cathelicidin", "IPR010402 : CCT_domain", "IPR012715 : Chap_CCT_alpha", 
                      "IPR008929 : Chondroitin_lyas", "IPR013045 : CHP01563", "IPR010106 : CHP01784", 
                      "IPR019366 : Clusterin-associated_protein-1", "IPR003779 : CMD", 
                      "IPR018490 : cNMP_bd-like", "IPR018607 : Ctf8", "IPR017456 : CTP_synthase_N", 
                      "IPR001083 : Cu_fist_DNA_bd", "IPR011893 : CXXU_selWTH", "IPR006262 : Cyt_deam_tetra", 
                      "IPR001128 : Cyt_P450", "IPR000938 : Cytoskel-assoc-prot_CAP-Gly", 
                      "IPR002742 : Desulfoferrodoxin_Fe-bd", "IPR016174 : Di-haem_cyt_TM", 
                      "IPR012319 : DNA_glycosylase/AP_lyase_cat", "IPR015252 : DNA_recomb/repair_BRCA2_hlx", 
                      "IPR001553 : DNA_recomb/repair_RecA/RadB", "IPR007858 : Dpy-30_motif", 
                      "IPR010441 : DUF1042", "IPR011546 : Pept_M41_FtsH_ex", "IPR012962 : Pept_M54_archaemetzncn", 
                      "IPR013736 : Pept_S15/CocE/NonD_C", "IPR008269 : Pept_S16_C", 
                      "IPR004815 : Pept_S16_lon", "IPR003111 : Pept_S16_N", "IPR000223 : Pept_S26A_signal_pept_1", 
                      "IPR017092 : Pept_S54_Rhomboid-like_Rom4/5", "IPR000209 : Pept_S8_S53", 
                      "IPR001461 : Peptidase_A1", "IPR005077 : Peptidase_C11", "IPR012462 : Peptidase_C78_UfSP1/2", 
                      "IPR000834 : Peptidase_M14", "IPR000819 : Peptidase_M17_C", "IPR012779 : Peptidase_M1_pepN", 
                      "IPR000994 : Peptidase_M24_cat_core", "IPR000642 : Peptidase_M41", 
                      "IPR000383 : Peptidase_S15", "IPR001984 : Peptidase_S16", "IPR011056 : Peptidase_S24_S26_C", 
                      "IPR004127 : PFD_alpha_like", "IPR002777 : PFD_beta_like", "IPR003994 : PFD_UXT", 
                      "IPR015155 : PFU", "IPR001849 : PH", "IPR002319 : Phe-tRNA-synth_IIc", 
                      "IPR014019 : Phosphatase_tensin", "IPR015913 : Phosphofructokinase_core", 
                      "IPR005952 : Phosphogly_mut1", "IPR003140 : Phospholipase/Carboxylesterase", 
                      "IPR008947 : Phospholipase_C/P1_nuclease", "IPR015359 : Phospholipase_C_EF-hand-like", 
                      "IPR013841 : Phospholipase_C_PI-sp_X/Y", "IPR001192 : Phospholipase_C_Pinositol-sp_C", 
                      "IPR001711 : Phospholipase_C_Pinositol-sp_Y", "IPR016195 : PHP-like", 
                      "IPR013234 : PIGA_GPI_anchor", "IPR002498 : PIP5K_core", "IPR016034 : PIP5K_core_sub", 
                      "IPR003882 : Pistil_extensin", "IPR012198 : PK_regulatory", "IPR000961 : Pkinase_C", 
                      "IPR001736 : PLD", "IPR013637 : PLU-1", "IPR015848 : PNPase_PH_RNA-bd_bac/org-type", 
                      "IPR007010 : PolA_pol_RNA-bd", "IPR007724 : Poly_GlycOHase", 
                      "IPR014492 : PolyA_polymerase", "IPR005031 : Polyket_cyc", "IPR013968 : Polyketide_synth_KR", 
                      "IPR016563 : PolyUb_recognition_cplx_Npl4", "IPR001925 : Porin_Euk", 
                      "IPR003616 : Post-SET_Zn_bd", "IPR011561 : Pox_I1_rel", "IPR002554 : PP2A_B56", 
                      "IPR000023 : Ppfruckinase", "IPR007062 : PPI-2", "IPR011107 : PPI_Ypi1", 
                      "IPR000774 : PPIase_FKBP_N", "IPR011033 : PRC_barrell-like", 
                      "IPR011608 : PRD", "IPR013915 : Pre-mRNA_splic_Prp19", "IPR004895 : Prenylated_rab_accept_PRA1", 
                      "IPR011254 : Prismane_like", "IPR010456 : PrmA_MeTrfase", "IPR002316 : Pro-tRNA-synth_IIa", 
                      "IPR012591 : PRO8NT", "IPR006620 : Pro_4_hyd_alph", "IPR005715 : ProB", 
                      "IPR016814 : Profilin_apicomplexa", "IPR000163 : Prohibitin", 
                      "IPR002350 : Prot_inh_Kazal", "IPR011497 : Prot_Inh_Kazal_2", 
                      "IPR009020 : Prot_inh_propept", "IPR000719 : Prot_kinase_core", 
                      "IPR001353 : Proteasome_A_B_su", "IPR009077 : Proteasome_activ_REG_asu/bsu", 
                      "IPR003186 : Proteasome_activ_REG_bsu", "IPR015909 : Protein_transpt_Pam16/TIM14", 
                      "IPR004098 : Prp18", "IPR003817 : PS_Dcarbxylase", "IPR005221 : PS_decarb", 
                      "IPR007345 : PS_pyruv_trans", "IPR006145 : Pseudouridine_synth", 
                      "IPR006567 : PUG", "IPR013535 : PUL", "IPR001697 : Pyr_Knase", 
                      "IPR001100 : Pyr_nuc-diS_OxRdtase", "IPR004099 : Pyr_nucl-diS_OxRdtase_dimer", 
                      "IPR011895 : Pyruv_OxRdtase_PFOR", "IPR012110 : Pyruvt_ip_decrb", 
                      "IPR002869 : Pyrv_Fd/Flavodoxin_OxRdtase", "IPR015794 : Pyrv_Knase_a/b", 
                      "IPR015795 : Pyrv_Knase_C-like", "IPR011281 : Succ_DH_flav_su_fwd", 
                      "IPR000825 : SUF_FeS_clus_asmbl_SufBD", "IPR003808 : SufE", "IPR016816 : Surface_antigen_2", 
                      "IPR006311 : TAT_signal", "IPR017859 : TCS_treacle-like", "IPR010874 : TEBP_beta", 
                      "IPR019157 : Temp-induced_dauer_prot-like", "IPR019544 : Tetratricopeptide_SHNi-TPR_dom", 
                      "IPR001471 : TF_ERF_DNA-bd", "IPR013129 : TF_JmjC", "IPR003347 : TF_JmjC_AAH", 
                      "IPR003349 : TF_JmjN", "IPR003617 : TFIIS/CRSP70_N_sub", "IPR014809 : TFP11", 
                      "IPR000672 : THF_DH/CycHdrlase", "IPR010080 : Thioester_reductase", 
                      "IPR001031 : Thioesterase", "IPR006338 : Thioredoxin/glutathione_Rdtase", 
                      "IPR019407 : Thiouridylase_cyt_su2", "IPR000884 : Thrombospondin_1_rpt", 
                      "IPR007379 : Tim44_related", "IPR004217 : Tim8/9/10/13_Znf-like", 
                      "IPR013498 : Topo_IA_Znf", "IPR004085 : TopoVI_A", "IPR011717 : TPR-4", 
                      "IPR001533 : Trans/pterin_deHydtase", "IPR001585 : Transaldolase", 
                      "IPR004730 : Transaldolase_AB", "IPR018772 : Transcription_activator_HlyU", 
                      "IPR008988 : Transcriptional_repressor_C", "IPR004540 : Transl_elong_EFG/EF2", 
                      "IPR004541 : Transl_elong_EFTu/EF1A_bac/org", "IPR013185 : Transl_elong_KOW-like", 
                      "IPR001059 : Transl_elong_P/YeiP_cen", "IPR019537 : Transmembrane_protein_65", 
                      "IPR008881 : Trigger_fac_ribosome-bd_bac", "IPR018318 : tRNA_MeTrfase-like", 
                      "IPR003827 : tRNA_yW-synthesising", "IPR006221 : TrpG_papA", 
                      "IPR000792 : Tscrpt_reg_LuxR_C", "IPR018351 : Tudor_subgroup", 
                      "IPR006529 : U2AF_lg", "IPR017132 : U6_snRNA_Lsm7", "IPR000537 : UbiA_prenyltransferase", 
                      "IPR006317 : Ubiquinol_cyt_c_Rdtase_Fe-S-su", "IPR008027 : Ubiquinol_cyt_c_Rdtase_QCR9", 
                      "IPR004192 : Ubiquinol_cyt_Rdtase_TM", "IPR003422 : Ubol_cytC_Rdtase_hinge", 
                      "IPR014806 : Ufc1", "IPR007881 : UNC-50", "IPR020231 : Uncharacterised_YfgI", 
                      "IPR006015 : Universal_stress_UspA", "IPR003425 : Unk_YGGT", 
                      "IPR005336 : UPF0041", "IPR002036 : UPF0054", "IPR005349 : UPF0136_TM", 
                      "IPR002765 : UPF0145", "IPR007915 : UPF0197", "IPR007317 : UPF0363", 
                      "IPR007206 : UPF0507_C", "IPR006361 : Uroporphyrinogen_deCO2ase_HemE", 
                      "IPR000257 : Uroporphyrinogen_deCOase", "IPR006016 : UspA", "IPR019499 : Val-tRNA_synth_Ia_tRNA-bd", 
                      "IPR012932 : VKOR", "IPR019453 : Vps39/TGF_beta_rcpt-assoc_2", 
                      "IPR007258 : Vps52", "IPR009032 : Vpu_cyt", "IPR014883 : VRR_NUC", 
                      "IPR000738 : WHEP-TRS", "IPR019007 : WW_dom-bd_prot_11", "IPR013917 : Wyosine_form", 
                      "IPR008164 : XGLTT_repeat", "IPR008895 : YL1", "IPR007275 : YTH_domain", 
                      "IPR003656 : Znf_BED_prd", "IPR001562 : Znf_Btk_motif", "IPR005735 : Znf_LSD1", 
                      "IPR006580 : Znf_TTF", "IPR013782 : 1-4-alpha-glucan_branch_enz", 
                      "IPR014474 : 26S_protsm_RPN10", "IPR004175 : 2_5_ligase", "IPR006139 : 2_Hacid_DH", 
                      "IPR006140 : 2hydac_DH_NAD_bd", "IPR004136 : 2Npropane_dOase", 
                      "IPR010611 : 3D", "IPR006176 : 3HCDH_NAD_bd", "IPR008928 : 6hp_glycosidase-like", 
                      "IPR006183 : 6PGD", "IPR006115 : 6PGDH_NAD_bd", "IPR013772 : A-amylase", 
                      "IPR008152 : A/G_adapt_C", "IPR001048 : Aa_kinase", "IPR011703 : AAA_3", 
                      "IPR003439 : ABC_transp_like", "IPR005128 : Acetolac_decarb", 
                      "IPR008934 : AcPase_VanPerase", "IPR003702 : ActCoA_hydro", "IPR002553 : Adaptin_N", 
                      "IPR005019 : Adenine_glyco", "IPR000736 : Adeno_hexon", "IPR008172 : Adenylate_cyc", 
                      "IPR013912 : Adenylate_cyc_assoc_C", "IPR006599 : Adenylate_cyc_CARP", 
                      "IPR013154 : ADH_N", "IPR002347 : ADH_short_C2", "IPR013149 : ADH_Zn_bd", 
                      "IPR007862 : ADK_lid", "IPR012377 : AdoCbl_GlcG", "IPR006763 : Ag332", 
                      "IPR010819 : AGE/RnBP", "IPR008141 : Ala_DH_PNT", "IPR007698 : Ala_DH_PNT_C", 
                      "IPR007886 : Ala_DH_PNT_N", "IPR002086 : Ald_DH", "IPR008274 : Ald_xan_DH_mo_bd", 
                      "IPR012394 : ALDH", "IPR000674 : Aldxan_DH_hamm", "IPR013108 : Amidohydro_3", 
                      "IPR011550 : Amidohydro_like", "IPR000192 : Aminotrans_V", "IPR000873 : AMP-bind", 
                      "IPR013286 : AnnexinVII", "IPR013155 : Anticodon_V_L_bd", "IPR012520 : Antimicrobial_1", 
                      "IPR009028 : AP2_adap_app", "IPR008968 : AP50", "IPR000097 : APendonclse1", 
                      "IPR007242 : APG12", "IPR013923 : APG16", "IPR007241 : APG9", 
                      "IPR004456 : APGAM_arc", "IPR008383 : API5", "IPR003313 : AraC_bd", 
                      "IPR010499 : AraC_E_bd", "IPR003876 : Arg_deiminase", "IPR001278 : Arg_tRNA-synt_1c", 
                      "IPR007204 : ARP2/3_P21-Arc", "IPR011021 : Arrestin_N", "IPR000802 : Ars_pump", 
                      "IPR002595 : ASFV_360", "IPR004522 : AsnS", "IPR006130 : Asp/Orn_carbamoyltranf", 
                      "IPR009010 : Asp_decarb_fold", "IPR002082 : Aspartate_carbamoyltransf_euk", 
                      "IPR004523 : AspS_arch", "IPR009163 : ATP_A_trans", "IPR012003 : ATP_PFK_prok", 
                      "IPR006408 : ATPase-IIB_Ca", "IPR006069 : ATPase_cat_a", "IPR012094 : ATPase_MesJ_YaeO", 
                      "IPR005042 : Avirulence", "IPR005146 : B3_4", "IPR002554 : B56", 
                      "IPR001926 : B6_enzyme_beta", "IPR009063 : Bac_Ig_alb_bd", "IPR011256 : Bac_reg_effector", 
                      "IPR005478 : BacTransketolase", "IPR004619 : Baf", "IPR001025 : BAH", 
                      "IPR000299 : Band_4.1", "IPR010722 : BATS", "IPR003492 : Battenin", 
                      "IPR001597 : Beta_elim_lyase", "IPR003784 : BioY", "IPR000515 : BPD_transp", 
                      "IPR000210 : BTB", "IPR008973 : C2_CaLB", "IPR002126 : Cadherin", 
                      "IPR001997 : Calponin", "IPR009033 : Calret_calnex_P", "IPR003644 : Calx_beta", 
                      "IPR003691 : Camphor_CrcB", "IPR000938 : CAP-Gly", "IPR013992 : CAP_N", 
                      "IPR000631 : carb_kinase", "IPR008969 : CarboxypepD_reg", "IPR000704 : CAS_kinase_II", 
                      "IPR004341 : CAT_RNA_bd", "IPR004917 : Caulimo_AT", "IPR003610 : CBM_5_12", 
                      "IPR005084 : CBM_6", "IPR004875 : CENP-B", "IPR010446 : CgtA", 
                      "IPR001476 : Chaprnin_Cpn10", "IPR011006 : CheY_like", "IPR003368 : Chlamydia_PMP", 
                      "IPR002573 : Choline_kinase", "IPR012664 : CHP02452", "IPR005218 : CHP147", 
                      "IPR013045 : CHP1563", "IPR004630 : CHP698", "IPR004395 : CHP91", 
                      "IPR004396 : CHP92", "IPR000953 : Chromo", "IPR008251 : Chromo_shadow", 
                      "IPR011206 : Cit_lyase_B", "IPR000804 : Clat_adaptor_s", "IPR000996 : Clathrin_lg_ch", 
                      "IPR000547 : Clathrin_repeat", "IPR001392 : Clathrn_med", "IPR008161 : Clg_helix", 
                      "IPR001765 : CO_anhd_prok_pln", "IPR006176 : 3-OHacyl-CoA_DH_NAD-bd", 
                      "IPR017568 : 3-oxoacyl-ACP_synth-2", "IPR006108 : 3HC_DH_C", 
                      "IPR011284 : 3oxo_ACP_reduc", "IPR010961 : 4pyrrol_synth_NH2levulA_synth", 
                      "IPR000860 : 4pyrrol_synth_OHMeBilane_synth", "IPR001731 : 4pyrrol_synth_porphobiln_synth", 
                      "IPR003754 : 4pyrrol_synth_uPrphyn_synth", "IPR020046 : 5-3_exonucl_resolvase-like_N", 
                      "IPR006179 : 5_nucleotidase/apyrase", "IPR007115 : 6-PTP_synth-rel", 
                      "IPR012850 : A-amylase_bs_C", "IPR020478 : A.T_hook_like", "IPR008925 : aa-tRNA-synth_I_codon-bd", 
                      "IPR006693 : AB_hydro_lipase", "IPR019195 : ABC_ATPase", "IPR019196 : ABC_transp_unknown", 
                      "IPR013537 : AcCoA_COase_cen", "IPR013751 : ACP_syn_III", "IPR013747 : ACP_syn_III_C", 
                      "IPR006092 : Acyl-CoA_DH_N", "IPR006090 : Acyl-CoA_Oxase/DH_1", 
                      "IPR006091 : Acyl-CoA_Oxase/DH_M", "IPR012258 : Acyl-CoA_oxidase", 
                      "IPR002655 : Acyl-CoA_oxidase_C", "IPR009075 : AcylCo_DH/oxidase_C", 
                      "IPR009100 : AcylCoA_DH/oxidase", "IPR003153 : Adaptor_Cbl_N", 
                      "IPR005801 : ADC_synthase", "IPR001805 : Adenokinase", "IPR001114 : Adenylosuccinate_synthetase", 
                      "IPR009288 : AIG2-like", "IPR000728 : AIR_synth", "IPR010918 : AIR_synth_C", 
                      "IPR008141 : Ala_DH/Pyr_transHydgase", "IPR008274 : AldOxase/xan_DH_Mopterin-bd", 
                      "IPR000120 : Amidase", "IPR006992 : Amidohydro_2", "IPR018081 : Anaphylatoxin_", 
                      "IPR000066 : Antenna_a/b", "IPR006805 : Anth_synth_I_N", "IPR006220 : Anth_synthII", 
                      "IPR019999 : Anthranilate_synth_I_C", "IPR003710 : ApbA", "IPR003298 : Apmem_Ag1", 
                      "IPR006773 : ARM_1", "IPR019774 : Aromatic-AA_hydroxylase_C", 
                      "IPR013539 : ASL_C", "IPR018027 : Asn/Gln_amidotransferase", 
                      "IPR006426 : Asn_synth_AEB", "IPR001920 : Asp/Glu_race", "IPR002082 : Asp_carbamoyltransf_euk", 
                      "IPR001341 : Asp_kin_reg", "IPR005676 : Asp_semi-ald_DH_pep-lack", 
                      "IPR015412 : ATG2_C", "IPR013651 : ATP-grasp_RimK-type", "IPR010591 : ATP11", 
                      "IPR001877 : ATPase1_Cu-transp", "IPR005654 : ATPase_AFG1-like", 
                      "IPR000454 : ATPase_F0-cplx_csu", "IPR005294 : ATPase_F1-cplx_asu", 
                      "IPR005722 : ATPase_F1-cplx_bsu", "IPR020546 : ATPase_F1-cplx_dsu/esu_N", 
                      "IPR006721 : ATPase_F1-cplx_esu_mt", "IPR000131 : ATPase_F1-cplx_gsu", 
                      "IPR000711 : ATPase_F1-cplx_OSCP/dsu", "IPR005782 : ATPase_P-typ_Ca-transp", 
                      "IPR006416 : ATPase_P-typ_heavy-metal", "IPR006534 : ATPase_P-typ_PM_proton-efflux", 
                      "IPR010230 : ATPase_SufC_FeS-cluster_assmbl", "IPR017993 : Atrophin-1", 
                      "IPR007242 : Autophagy-rel_prot_12", "IPR013923 : Autophagy-rel_prot_16", 
                      "IPR007243 : Autophagy-rel_prot_6", "IPR010525 : Auxin_resp", 
                      "IPR010796 : B9", "IPR000184 : Bac_surfAg_D15", "IPR008409 : BCAS2", 
                      "IPR018955 : BCDHK/PDK_mit", "IPR014851 : BCS1_N", "IPR000615 : Bestrophin", 
                      "IPR010675 : Bin3", "IPR003142 : BPL_C", "IPR001304 : C-type_lectin", 
                      "IPR018816 : Cactin_central", "IPR004713 : CaH_exchang", "IPR003691 : Camphor-R_CrcB", 
                      "IPR006598 : CAP10", "IPR008960 : Carb-bd_dom_fam9-like", "IPR001317 : CarbamoylP_synth_GATase", 
                      "IPR005483 : CarbamoylP_synth_lsu", "IPR006275 : CarbamoylP_synth_lsu_Gln-dep", 
                      "IPR005480 : CarbamoylP_synth_lsu_oligo", "IPR006274 : CarbamoylP_synth_ssu", 
                      "IPR002474 : CarbamoylP_synth_ssu_N", "IPR001148 : Carbonic_anhydrase_a-class_cat", 
                      "IPR019380 : Casein_kinase_sb_PP28", "IPR012955 : CASP_C", "IPR002226 : Catalase", 
                      "IPR010582 : Catalase-rel_immune_responsive", "IPR018028 : Catalase_rel_subgroup", 
                      "IPR003722 : Cbl_synth_CobH/CbiC_core", "IPR012270 : CCR4-NOT_su3/5", 
                      "IPR006600 : Centromere_CenpB_HTH", "IPR012725 : Chaperone_DnaK", 
                      "IPR017730 : Chaperonin_ClpB", "IPR015374 : ChAPs", "IPR010625 : CHCH", 
                      "IPR007051 : CHORD", "IPR015890 : Chorismate-bd_C", "IPR000453 : Chorismate_synth", 
                      "IPR005269 : CHP00730", "IPR013256 : Chromatin_SPT2", "IPR015151 : Clathrin_b-adaptin_app_sub_C", 
                      "IPR003769 : ClpS_core", "IPR016391 : Coatomer_alpha_subunit", 
                      "IPR007715 : CoenzQ_biosynthesis_Coq4", "IPR011129 : Cold_shock_prot", 
                      "IPR001260 : Coprogen_oxidas", "IPR003302 : Cornifin", "IPR006387 : CPW_WPC", 
                      "IPR001071 : CRAL_bd_toc_tran", "IPR001753 : Crotonase_core", 
                      "IPR003782 : Cu-chaperone_SCO1/SenC", "IPR013109 : Cupin_4", 
                      "IPR006767 : Cwf19-like_C_dom-2", "IPR017060 : Cyclin_L", "IPR005857 : Cysta_beta_synth", 
                      "IPR005797 : Cyt_b/b6_N", "IPR003197 : Cyt_bd_ubiquinol_oxidase_14kDa", 
                      "IPR000511 : Cyt_C/C1_haem_lyase", "IPR002326 : Cyt_C1", "IPR002327 : Cyt_c_1A/1B", 
                      "IPR013892 : Cyt_c_biogenesis_Cmc1-like", "IPR003088 : Cyt_c_I", 
                      "IPR007533 : Cyt_c_oxidase_assmbl_CtaG", "IPR018793 : Cyt_c_oxidase_assmbl_Pet191_N", 
                      "IPR007745 : Cyt_c_oxidase_Cu-chaperone", "IPR002429 : Cyt_c_oxidase_su2_C", 
                      "IPR000298 : Cyt_c_oxidase_su3", "IPR004203 : Cyt_c_oxidase_su4", 
                      "IPR002124 : Cyt_c_oxidase_su5b", "IPR003213 : Cyt_c_oxidase_su6B", 
                      "IPR002325 : Cyt_f", "IPR003780 : Cyt_oxidase_assembly", "IPR017973 : Cyt_P450_C", 
                      "IPR002401 : Cyt_P450_E_grp-I", "IPR006236 : D-3-Phosphoglycerate_DH", 
                      "IPR013097 : Dabb", "IPR002480 : DAHP_synth_2", "IPR002986 : DAP_decrbxlase", 
                      "IPR005263 : DapA_synth", "IPR000846 : DapB", "IPR007708 : DBR1_C", 
                      "IPR016473 : dCMP_deaminase", "IPR019153 : DDRGK_domain", "IPR019190 : Defects_morphology_1-like", 
                      "IPR003207 : DeHydtase_su", "IPR002967 : Delta_tubulin", "IPR008120 : Dense_granule_Gra7_protein", 
                      "IPR000489 : Dhdropt_synth", "IPR004721 : DHOdimr", "IPR006390 : DHP_synth", 
                      "IPR002658 : DHQ_synth_AroB", "IPR011770 : Dihydrodipicolinate_Rdtase", 
                      "IPR002220 : Dihydrodipicolinate_synth", "IPR005719 : Dihydroorotate_DH_2", 
                      "IPR011005 : Dihydropteroate_synth-like", "IPR001158 : DIX", 
                      "IPR016177 : DNA-bd_integrase-typ", "IPR002054 : DNA-dir_DNA_pol_X", 
                      "IPR002092 : DNA-dir_RNA_pol_phage", "IPR001604 : DNA/RNA_non-sp_Endonuclease", 
                      "IPR006164 : DNA_helicase_ATP-dep_Ku", "IPR007694 : DNA_helicase_DnaB-like_C", 
                      "IPR004150 : DNA_ligase_OB", "IPR006050 : DNA_photolyase_N", 
                      "IPR007218 : DNA_pol_delta_4", "IPR018944 : DNA_pol_lambd_fingers_domain", 
                      "IPR019038 : DNA_polymerase_subunit_Cdc27", "IPR018328 : DNA_repair_Rad4_DNA-bd_3", 
                      "IPR013839 : DNAligase_adenylation", "IPR013840 : DNAligase_N", 
                      "IPR007255 : Dor1", "IPR013110 : DOT1", "IPR011637 : DoxX", "IPR013174 : DPM3", 
                      "IPR018732 : Dpy-19", "IPR001159 : Ds-RNA_bd", "IPR009548 : DUF1168", 
                      "IPR009613 : DUF1222", "IPR009771 : DUF1339", "IPR003738 : DUF159", 
                      "IPR012430 : DUF1625", "IPR013180 : DUF1716_euk", "IPR013549 : DUF1731_C", 
                      "IPR008737 : DUF1758", "IPR005312 : DUF1759", "IPR003774 : DUF179", 
                      "IPR014931 : DUF1805", "IPR015070 : DUF1880", "IPR018612 : DUF2040_coiled-coil", 
                      "IPR018611 : DUF2042", "IPR018613 : DUF2052_coiled-coil", "IPR019164 : DUF2053_membrane", 
                      "IPR018651 : DUF2081", "IPR019361 : DUF2228", "IPR019310 : DUF2361", 
                      "IPR019434 : DUF2423", "IPR019442 : DUF2428_death-receptor-like", 
                      "IPR007308 : DUF408", "IPR002725 : DUF45", "IPR007621 : DUF477", 
                      "IPR007511 : DUF501", "IPR007518 : DUF544", "IPR007650 : DUF581", 
                      "IPR008537 : DUF819", "IPR008539 : DUF821_CAP10-like", "IPR008560 : DUF842_euk", 
                      "IPR002791 : DUF89", "IPR010378 : DUF974", "IPR016065 : DUF_methylase", 
                      "IPR019387 : DUF_SAYSvFN", "IPR003821 : DXP_reductoisomerase", 
                      "IPR013644 : DXP_reductoisomerase_C", "IPR013512 : DXP_reductoisomerase_N", 
                      "IPR019142 : Dymeclin", "IPR019370 : E2F-assoc_phosphoprotein_C", 
                      "IPR004167 : E3_bd", "IPR010314 : E3_ubiquit_lig_DUF913", "IPR006947 : EGF_alliinase", 
                      "IPR015362 : EJC_Pym", "IPR015365 : Elong-fact-P_C", "IPR019542 : Enhancer_of_polycomb-like", 
                      "IPR001986 : EPSP_synthase_core", "IPR001308 : ETF_a", "IPR014730 : ETF_a/b_N", 
                      "IPR014731 : ETF_asu_C", "IPR012255 : ETF_b", "IPR007859 : ETFD_OxRdtase", 
                      "IPR019495 : Exosome_cplx_CSL4", "IPR013114 : FabA_FabZ", "IPR004655 : FabH_synth", 
                      "IPR010084 : FabZ", "IPR018797 : FAM98", "IPR000782 : FAS1_domain", 
                      "IPR005804 : Fatty_acid_desaturase-1", "IPR015876 : Fatty_acid_desaturase-1_core", 
                      "IPR006694 : Fatty_acid_hydroxylase", "IPR010241 : Fdx_pln", 
                      "IPR001015 : Ferrochelatase", "IPR018967 : FeS-contain_CDGSH-typ", 
                      "IPR006622 : FeS-contain_CDGSH-typ_subfam", "IPR019053 : FFD/TFG_box_motif", 
                      "IPR011398 : Fibrillin", "IPR000181 : Fmet_deformylase", "IPR017703 : Folate-bd_YgfZ", 
                      "IPR018143 : Folate_rcpt_cons-reg", "IPR005793 : Formyl_trans_C", 
                      "IPR002376 : Formyl_transf_N", "IPR001645 : Fpolygl_synthtse", 
                      "IPR020067 : Frizzled-like_dom", "IPR000024 : Frizzled_Cys-rich", 
                      "IPR020068 : Frizzled_dom_subgr", "IPR000146 : Fructose_bisphosphatase", 
                      "IPR002698 : FTHF_cligase", "IPR004112 : Fum_Rdtase/Succ_DH_flav_C", 
                      "IPR015377 : Fumarylacetoacetase_N", "IPR007014 : FUN14", "IPR000965 : G-glutamylP_reductase", 
                      "IPR003018 : GAF", "IPR019379 : Gamma_Secretase_Asp_P_PEN2", 
                      "IPR002930 : GCV_H", "IPR013977 : GCV_T_C", "IPR006222 : GCV_T_N", 
                      "IPR019378 : GDP-Fuc_prot_O-FucTrfase", "IPR006368 : GDP_Man_deHydtase", 
                      "IPR018928 : Generative_cell_HAP2/GCS1", "IPR002218 : GIDA-rel", 
                      "IPR004911 : GILT", "IPR012476 : GLE1", "IPR006107 : Gln-tRNA_amidoTrfase_suB/E_cen", 
                      "IPR006075 : Gln-tRNA_amidoTrfase_suB/E_N", "IPR011899 : Glutaredoxin_euk/vir", 
                      "IPR004887 : Glutathione_synth_subst-bd_euk", "IPR000490 : Glyco_hydro_17", 
                      "IPR002241 : Glyco_hydro_27", "IPR004888 : Glyco_hydro_63", "IPR000111 : Glyco_hydro_GHD", 
                      "IPR006813 : Glyco_trans_17", "IPR003440 : Glyco_trans_48", "IPR007577 : Glyco_trans_s_bd", 
                      "IPR001944 : Glycoside_Hdrlase_35", "IPR007006 : Glycosyltransferase_ALG10", 
                      "IPR004856 : Glycosyltransferase_ALG6/ALG8", "IPR004361 : Glyoxalase_1", 
                      "IPR019328 : GPI-GlcNAc_cplx_Trfase_PIG-H", "IPR008118 : Gra2_protein", 
                      "IPR008119 : Gra6_protein", "IPR015349 : GTP-bd_prot_GTP1/OBG_C", 
                      "IPR019987 : GTP-bd_ribosome_bio_YsxC", "IPR016484 : GTP-binding_EngA", 
                      "IPR006169 : GTP1_OBG_sub", "IPR018948 : GTP_bd_TrmE_N", "IPR001474 : GTP_CycHdrlase_I", 
                      "IPR020602 : GTP_CycHdrlase_I/CN_OxRdtase", "IPR006691 : GyrA/parC_pinwhl", 
                      "IPR004131 : H_PPase", "IPR011943 : HAD-SF_hydro_IIID", "IPR016084 : Haem_Oase-like_multi-hlx", 
                      "IPR010255 : Haem_peroxidase", "IPR002016 : Haem_peroxidase_pln/fun/bac", 
                      "IPR012479 : HCNGP", "IPR010756 : Hep_59", "IPR000119 : Hist_DNA_bd_bac", 
                      "IPR005819 : Histone_H5", "IPR002711 : HNH", "IPR003615 : HNH_nuc", 
                      "IPR008220 : Homoserine_AcTrfase", "IPR000870 : Homoserine_kin", 
                      "IPR006296 : Homoserine_O-AcTrfase", "IPR000550 : Hppk", "IPR002343 : Hud_Sxl_RNA", 
                      "IPR005904 : Hxn_phspho_trans", "IPR017782 : Hydroxyacylglutathione_Hdrlase", 
                      "IPR003521 : ICln_channel", "IPR005990 : IMP_DH", "IPR001093 : IMP_DH_GMPRt", 
                      "IPR018529 : IMP_DH_rel", "IPR013798 : Indole-3-glycerol_P_synth", 
                      "IPR000354 : Involucrin_rpt", "IPR004394 : Iojap", "IPR005821 : Ion_trans", 
                      "IPR009453 : ISN1", "IPR004790 : Isocitrate_DH_NADP-dep_euk", 
                      "IPR000918 : Isocitrate_lyase/Pmutase", "IPR004588 : IspG_bac-type", 
                      "IPR011329 : Killer_tox_Kp4/SMK-like_core", "IPR019315 : Kinase_phosphorylation_domain", 
                      "IPR005161 : Ku_N", "IPR007822 : LANC-like", "IPR006297 : LepA_GTP_bd", 
                      "IPR013842 : LepA_GTP_bd_C", "IPR002302 : Leu-tRNA-synth_Ia_bac/mito", 
                      "IPR004616 : Leu/Phe-tRNA_Trfase", "IPR006258 : Lipoamide_DH", 
                      "IPR019491 : Lipoate_protein_ligase_C", "IPR003698 : Lipoate_synth", 
                      "IPR013208 : Lipocalin_2", "IPR004562 : LipoylTrfase_LipoateP_Ligase", 
                      "IPR008671 : Lycopene_b/e_cyclase", "IPR003451 : LytB", "IPR001862 : MAC_perforin", 
                      "IPR011275 : Malate_DH_NAD-dep_bac", "IPR002539 : MaoC_deHydtase", 
                      "IPR007918 : MDM35_apoptosis", "IPR003526 : MECDP_synthase_core", 
                      "IPR010061 : MeMal-semiAld_DH", "IPR001129 : Membr-assoc_MAPEG", 
                      "IPR011607 : MGS", "IPR019562 : Micronemal-adhesive-rpt_sia-bd", 
                      "IPR008117 : Microneme_MIC1", "IPR019367 : Microtubule-assoc_pr_Cript", 
                      "IPR003690 : Mit_transcrip_term-rel", "IPR005656 : MmgE_PrpD", 
                      "IPR010505 : Mob_synth_C", "IPR005066 : MoCF_OxRdtse_dimer", 
                      "IPR005111 : MoeA_C_domain_IV", "IPR005110 : MoeA_N-dom-I/II", 
                      "IPR014434 : Monothiol_GRX", "IPR002820 : Mopterin_CF_MoaC_reg", 
                      "IPR008335 : Mopterin_OxRdtase_euk", "IPR013169 : mRNA_splic_Cwf18", 
                      "IPR007757 : MT-A70", "IPR004686 : Mtc", "IPR018169 : MtN3_saliva_TM_cons-reg", 
                      "IPR009113 : Mu1_membr_pen", "IPR004101 : Mur_ligase_C", "IPR013221 : Mur_ligase_cen", 
                      "IPR001991 : Na-dicarboxylate_symporter", "IPR000175 : Na/ntran_symport", 
                      "IPR001898 : Na/sul_symport", "IPR017751 : NAD-dep_Gly3P_DH_euk", 
                      "IPR001834 : NADH-Cyt_B5_reductase", "IPR001046 : Nat-R-assoc-macro_Nramp", 
                      "IPR002186 : NCS-type_chromop", "IPR005120 : Nonsense_mediated_decay_UPF3", 
                      "IPR009400 : Nuc_excision_repair_TFIIH_TTDA", "IPR019148 : Nuclear_protein_DGCR14", 
                      "IPR017227 : Nucleoside-triphosphatase", "IPR003455 : O_MeTrfase_N", 
                      "IPR007702 : Ocnus", "IPR000544 : Octanoyltransferase", "IPR005038 : Octapeptide", 
                      "IPR005632 : OM_chaperone_Skp/OmpH", "IPR011995 : OMPdecase_2_core", 
                      "IPR001754 : OMPdecase_core", "IPR010754 : OPA3-like", "IPR003421 : Opine_DH", 
                      "IPR004467 : Or_phspho_trans", "IPR010164 : Orn_aminotrans", 
                      "IPR005123 : Oxoglutarate/Fe-dep_oxygenase", "IPR000572 : OxRdtase_Mopterin-bd", 
                      "IPR003137 : PA", "IPR013733 : PAD_central", "IPR003014 : PAN-1_domain", 
                      "IPR003700 : Pantoate_hydroxy_MeTrfase", "IPR003721 : Pantoate_ligase", 
                      "IPR010882 : PCEMA1", "IPR005139 : PCRF", "IPR007810 : Pep3_Vps18", 
                      "IPR001272 : PEP_carboxykinase_ATP", "IPR000352 : Pep_rel_factor_I", 
                      "IPR015527 : Pept_C26_g-glut_hydrolase", "IPR011546 : Pept_M41_FtsH_extracell", 
                      "IPR001907 : Pept_S14_ClpP", "IPR016117 : Pept_S58_DmpA/Arg_biosyn_ArgJ", 
                      "IPR000816 : Peptidase_C15", "IPR016125 : Peptidase_C15-like", 
                      "IPR011697 : Peptidase_C26", "IPR005074 : Peptidase_C39", "IPR018497 : Peptidase_M13_C", 
                      "IPR008753 : Peptidase_M13_N", "IPR007484 : Peptidase_M28", "IPR008915 : Peptidase_M50", 
                      "IPR007963 : Peptidase_M61", "IPR019165 : Peptidase_M76_ATP23", 
                      "IPR001254 : Peptidase_S1_S6", "IPR001940 : Peptidase_S1C", "IPR002692 : Peptidase_S45", 
                      "IPR002470 : Peptidase_S9A", "IPR002469 : Peptidase_S9B", "IPR018392 : Peptidoglycan-bd_lysin", 
                      "IPR002482 : Peptidoglycan-bd_Lysin_sg", "IPR008733 : PEX11", 
                      "IPR006845 : Pex_N", "IPR012908 : PGAP1", "IPR006349 : PGP_euk", 
                      "IPR007686 : PgpA", "IPR019385 : PHAX_RNA-binding_domain", "IPR005121 : PheS_beta_Fdx_antiC_bd", 
                      "IPR001204 : Phos_transporter", "IPR005101 : Photolyase_FAD-bd/Cryptochr_C", 
                      "IPR008775 : Phytyl_CoA_dOase", "IPR013886 : PI31_Prot_Reg", 
                      "IPR006786 : Pinin_SDK_memA", "IPR013968 : PKS_KR", "IPR000591 : Pleckstrin/G-protein_interact", 
                      "IPR004259 : PP_M1", "IPR004568 : PPantethiene-prot_Trfase", 
                      "IPR007728 : Pre-SET_Zn_bd", "IPR000424 : Primosome_PriB/ssb", 
                      "IPR012913 : PRKCSH", "IPR004931 : Pro/parathymosin", "IPR002872 : Proline_DH", 
                      "IPR005792 : Prot_disulphide_isomerase", "IPR005341 : Protein_transpt", 
                      "IPR007157 : PspA_IM30", "IPR008914 : PtdEtn-bd_prot_PEBP", "IPR018997 : PUB_domain", 
                      "IPR004769 : Pur_lyase", "IPR016188 : PurM_N-like", "IPR019265 : Putative_carnitine_def-assoc", 
                      "IPR005930 : Pyruv_COase", "IPR017597 : Pyrv_DH_E1_asu_subgrp-y", 
                      "IPR014189 : Quinone_OxRdtase_PIG3", "IPR011041 : Quinoprot_gluc/sorb_DH", 
                      "IPR010742 : Rab5ip", "IPR007268 : Rad9", "IPR006802 : Radial_spoke", 
                      "IPR008811 : Raffinose_synthase", "IPR019589 : Ran-bd_prot_CRA_domain", 
                      "IPR013584 : RAP", "IPR012916 : RED_N", "IPR013740 : Redoxin", 
                      "IPR014010 : REJ-like", "IPR003388 : Reticulon", "IPR008042 : Retrotrans_Pao", 
                      "IPR008919 : Retrov_capsid_N", "IPR014848 : Rgp1", "IPR016815 : Rhoptry_Rop2-like", 
                      "IPR005823 : Ribosomal_L13_bac-type", "IPR005749 : Ribosomal_L15_bac-type", 
                      "IPR000114 : Ribosomal_L16", "IPR000456 : Ribosomal_L17", "IPR001857 : Ribosomal_L19", 
                      "IPR005813 : Ribosomal_L20", "IPR001787 : Ribosomal_L21", "IPR005727 : Ribosomal_L22_bac-type", 
                      "IPR019985 : Ribosomal_L23", "IPR003256 : Ribosomal_L24", "IPR001684 : Ribosomal_L27", 
                      "IPR019189 : Ribosomal_L27/L41_mit", "IPR001383 : Ribosomal_L28", 
                      "IPR005880 : Ribosomal_L2_bac-type", "IPR001705 : Ribosomal_L33", 
                      "IPR001706 : Ribosomal_L35", "IPR000473 : Ribosomal_L36", "IPR013870 : Ribosomal_L37_mit", 
                      "IPR019927 : Ribosomal_L3_bac/org-type", "IPR007836 : Ribosomal_L41", 
                      "IPR010729 : Ribosomal_L47_mit", "IPR007740 : Ribosomal_L49/IMG2", 
                      "IPR019906 : Ribosomal_L6_bac-type", "IPR000206 : Ribosomal_L7/12", 
                      "IPR013823 : Ribosomal_L7/L12_C", "IPR020070 : Ribosomal_L9_N", 
                      "IPR015324 : Ribosomal_Rsm22_bac-type", "IPR005679 : Ribosomal_S12_bac-type", 
                      "IPR005290 : Ribosomal_S15_bac-type", "IPR000307 : Ribosomal_S16", 
                      "IPR001648 : Ribosomal_S18", "IPR019368 : Ribosomal_S23/S29_mit", 
                      "IPR000529 : Ribosomal_S6", "IPR000238 : Ribosome-bd_factorA", 
                      "IPR017941 : Rieske_2Fe-2S", "IPR005805 : Rieske_Fe-S_prot_C", 
                      "IPR002676 : RimM", "IPR019181 : RNA-processing_Lsm_domain", 
                      "IPR008111 : RNA_bd_8", "IPR019382 : RNA_pol1-assoc_factor_Paf67", 
                      "IPR007624 : RNA_pol_sigma70_r3", "IPR002078 : RNA_pol_sigma_54_int", 
                      "IPR013325 : RNA_pol_sigma_r2", "IPR019024 : RNase_H2_suB", "IPR013924 : RNase_H2_suC", 
                      "IPR018450 : Romo1", "IPR007201 : Rrm_2", "IPR006700 : rRNA_ssu_MeTrfase-E", 
                      "IPR003154 : S1/P1nuclease", "IPR003726 : S_MeTrfase", "IPR002903 : SAM-dep_MeTrfase_MraW", 
                      "IPR007364 : SAM-dep_RNA_MeTrfase_prd", "IPR012614 : SASP_SspP", 
                      "IPR003033 : SCP2_sterol_bd", "IPR019872 : Sec-tRNA_Se_transferase", 
                      "IPR007265 : Sec34", "IPR016482 : Sec61_beta_euk", "IPR004027 : SEC_C_motif", 
                      "IPR018307 : Secretory_pathway_prot_Avl9", "IPR004536 : SelD", 
                      "IPR000534 : Semialdehyde_DH_NAD-bd", "IPR012280 : Semialdhyde_DH_C", 
                      "IPR018865 : Ser/Thr_prot_kinase_19", "IPR000623 : Shik_kinase", 
                      "IPR013708 : Shikimate_DH-bd_N", "IPR009148 : SibA", "IPR007222 : Sig_recog_particle_rcpt_asu_N", 
                      "IPR008832 : Signal_recog_particle_SRP9", "IPR016685 : Silence_cplx_Nase-comp_TudorSN", 
                      "IPR008829 : SLA/LP_auto_ag", "IPR002161 : SNO", "IPR001852 : Snz1p/Sor1", 
                      "IPR002645 : SO4_transptr/STAS", "IPR013866 : Sphingolipid_d4-desaturase_N", 
                      "IPR019147 : Splice_fac_sup-white-apricot", "IPR016967 : Splicing_factor_SPF45", 
                      "IPR012921 : SPOC_C", "IPR007730 : Spore_cell-division_bac", 
                      "IPR003105 : SRA_YDG", "IPR017448 : Srcr_rcpt-rel", "IPR012942 : SRR1", 
                      "IPR011344 : ssDNA_bd", "IPR018119 : Strictosidine_synth_cons-reg", 
                      "IPR005809 : Succ_CoA_synthase_bsu", "IPR004489 : Succ_DH/fum_Rdtase_Fe-S", 
                      "IPR001799 : Ephrin", "IPR001509 : Epimerase_Dh", "IPR013945 : ER_Pkr1", 
                      "IPR006166 : ERCC4", "IPR011679 : ERp29_C", "IPR000697 : EVH1", 
                      "IPR005135 : Exo_endo_phos", "IPR004808 : ExoIII_xth", "IPR001247 : ExoRNase", 
                      "IPR006706 : Extensin_2", "IPR003097 : FAD_bd", "IPR006076 : Fad_oxred", 
                      "IPR013027 : FAD_pyr_redox", "IPR002606 : FAD_Synth", "IPR005121 : Fdx_AntiC_bd", 
                      "IPR001670 : Fe_ADH", "IPR009016 : Fe_hyd", "IPR004108 : Fe_hyd_lg_C", 
                      "IPR003149 : Fe_hyd_ssu-like", "IPR013352 : Fe_hyd_subset", "IPR009040 : Ferritin_like", 
                      "IPR001519 : Ferritin_N", "IPR003651 : FeS_bind", "IPR000577 : FGGY_kin", 
                      "IPR003104 : FH2_actin_bd", "IPR010069 : Fil_hemag_20aa", "IPR006342 : FkbM_mtfrase", 
                      "IPR011002 : FliG_like", "IPR005503 : FliL", "IPR011034 : FMT_C_like", 
                      "IPR008957 : FN_III-like", "IPR013653 : FR47", "IPR008081 : FragX_IP", 
                      "IPR009076 : FRAP_FKBP12_bd", "IPR009015 : Fuc_isomerase_N", 
                      "IPR003889 : FYrich_C", "IPR001282 : G6PDH", "IPR011024 : G_crystallin_SF", 
                      "IPR008979 : Gal_bd", "IPR011043 : Gal_oxid_central", "IPR008153 : Gamma_adaptin_C", 
                      "IPR000173 : GAP_DH", "IPR006424 : GAPDH_I", "IPR004152 : GAT", 
                      "IPR000991 : GATase_1", "IPR000182 : GCN5acetyl_trans", "IPR000683 : GFO/IDH/MocA_N", 
                      "IPR006095 : GLFV_DH", "IPR006096 : GLFV_DH_C", "IPR006097 : GLFV_DH_N", 
                      "IPR001376 : Gliadin", "IPR007639 : GlnRS_RNA_R1_bd", "IPR004514 : GlnS", 
                      "IPR000971 : Globin", "IPR008554 : GLRX2", "IPR004527 : GltX_bac", 
                      "IPR010107 : Glu_decarb_GAD", "IPR000924 : Glu_tRNA-synt_1c", 
                      "IPR006148 : Gluc_gal_isom", "IPR006002 : Gluconate_kinase", 
                      "IPR007043 : Glutaminase", "IPR001085 : Gly_HO-Metrfase", "IPR011588 : Gly_Xdiol_dOase", 
                      "IPR004360 : Glyas_bleo_dOase", "IPR004381 : Glyc_kinase", "IPR005999 : Glycerol_kin", 
                      "IPR001360 : Glyco_hydro_1", "IPR000757 : Glyco_hydro_16", "IPR006101 : Glyco_hydro_2", 
                      "IPR006103 : Glyco_hydro_2_TIM", "IPR001139 : Glyco_hydro_30", 
                      "IPR001362 : Glyco_hydro_32", "IPR013148 : Glyco_hydro_32_N", 
                      "IPR000602 : Glyco_hydro_38", "IPR011682 : Glyco_hydro_38_C", 
                      "IPR001382 : Glyco_hydro_47", "IPR001722 : Glyco_hydro_7", "IPR002860 : Glyco_hydro_BNR", 
                      "IPR007235 : Glyco_tran_28_C", "IPR001264 : Glyco_trans_51", 
                      "IPR008015 : GMP_PDE_delta", "IPR001019 : Gprotein_alph_bd", 
                      "IPR006359 : GreA", "IPR012243 : GreA_GreB", "IPR001482 : GSPII_E", 
                      "IPR010987 : GST_C_like", "IPR000695 : H_ATPase", "IPR005833 : HAD/epoxide_hydro", 
                      "IPR009970 : HC2", "IPR011531 : HCO3_transpt_C", "IPR006555 : Helic_c2", 
                      "IPR014021 : Helic_SF1/SF2_ATP_bd", "IPR014013 : Helic_SF1/SF2_ATP_bd_DinG/Rad3", 
                      "IPR014016 : Helic_SF1_UvrD_Rel", "IPR001650 : Helicase_C", "IPR007502 : Helicase_dom", 
                      "IPR012312 : Hemeryt_HHE_bd", "IPR012480 : Hepar_II_III", "IPR008642 : Herpes_BLRF2", 
                      "IPR002896 : Herpes_glycop_D", "IPR003404 : Herpes_glycopE", 
                      "IPR003840 : Herpes_helicase", "IPR000361 : HesB_yadR_yfhF", 
                      "IPR000116 : Highmoblty_IY", "IPR009082 : His_kin_homodim", "IPR004358 : His_kin_like_C", 
                      "IPR003661 : His_kinA_N", "IPR005467 : His_kinase", "IPR000560 : HisAc_phsphtse", 
                      "IPR004516 : HisS", "IPR001092 : HLH_basic", "IPR002202 : HMG-CoA_red", 
                      "IPR000135 : HMG_1/2", "IPR009023 : HMG_CoA_NAD_bd", "IPR004553 : HMG_CoA_R_NAD", 
                      "IPR010122 : HMG_CoA_S_euk", "IPR009029 : HMG_CoA_sub_bd", "IPR008260 : HMG_CoA_synth", 
                      "IPR005000 : HpcH_HpaI", "IPR008207 : Hpt", "IPR009073 : HSC20_C", 
                      "IPR012895 : HSCB_C", "IPR008978 : HSP20_chap", "IPR008971 : HSP_Dna_pep_bd", 
                      "IPR002197 : HTH_Fis", "IPR000524 : HTH_GntR", "IPR011053 : Hybrid_motif", 
                      "IPR005744 : HylIII", "IPR001910 : I/U_nuclsd_hydro", "IPR007269 : ICMT_mtfrase", 
                      "IPR001804 : IDH_IMDH", "IPR000178 : IF2", "IPR003890 : IF_eIF4G", 
                      "IPR010992 : IHF_like_DNA_bd", "IPR000146 : In_FB_phphtase", 
                      "IPR005635 : INCENP_ARK_bd", "IPR002587 : Inos-1-P_synth", "IPR004191 : Integrase_Tn916-type_DNA-bd_N", 
                      "IPR006141 : Intein_S", "IPR011258 : iPGM_N", "IPR011876 : IPP_isom_1", 
                      "IPR002667 : IPP_isomerase", "IPR011339 : IscU", "IPR000868 : Isochorismatase_hydro", 
                      "IPR014493 : Isopntndiph_ism", "IPR000771 : K_bP_aldolase", "IPR006652 : Kelch_rep", 
                      "IPR009019 : KH_prok", "IPR007478 : KilA_N", "IPR001752 : kinesin_motor", 
                      "IPR006646 : KOW_sub", "IPR001909 : KRAB", "IPR011530 : ksgA", 
                      "IPR011065 : Kunitz_like", "IPR012678 : L23_L15e_core", "IPR001557 : L_LDH_MDH", 
                      "IPR001236 : lact_mal_DH", "IPR010982 : Lambda_DNA_bd", "IPR007000 : Laminin_A", 
                      "IPR001791 : Laminin_G", "IPR007213 : LCM_mtfrase", "IPR011272 : LDH_protist", 
                      "IPR002172 : LDL_rcpt_A", "IPR003887 : LEM", "IPR011015 : LEM_like_fold", 
                      "IPR004493 : Leu-tRNA-synt1a", "IPR001781 : LIM_Zn_bd", "IPR006594 : LisH", 
                      "IPR013720 : LisH-PF08513", "IPR013101 : LLR_2", "IPR000106 : Low_mwt_PTPase", 
                      "IPR006553 : LRR_cys_sub", "IPR003590 : LRR_RNinh_sub", "IPR003591 : LRR_typ", 
                      "IPR011030 : LV_superhelical", "IPR012796 : Lysidine_TilS_C", 
                      "IPR012795 : Lysidine_TilS_N", "IPR002482 : LysM_PGBD", "IPR011076 : Malat_synth_like", 
                      "IPR008267 : Malate_DH", "IPR001891 : Malic_oxred", "IPR001250 : Man6P_isomerase-1", 
                      "IPR007145 : MAP65_ASE1", "IPR010945 : MDH_SF1", "IPR007018 : MED6", 
                      "IPR012573 : Meleagrin", "IPR006237 : Met_gamma_lys", "IPR011059 : Metal-dep_hydro_comp", 
                      "IPR001008 : Metallthion_2", "IPR014048 : MethylDNA_cys_mtrans_DNA_bd", 
                      "IPR003358 : Methyltransf_4", "IPR012327 : MethyltransfD12", 
                      "IPR006205 : Mev_gal_kin", "IPR006206 : Mev_galkinase", "IPR012278 : Mg_TatD", 
                      "IPR013021 : MIPS_GAPDH_like", "IPR011186 : MLH1", "IPR008954 : Moesin", 
                      "IPR005303 : MOSC_N", "IPR001453 : MPT_bd", "IPR002346 : MPT_DH_FAD_bd", 
                      "IPR000535 : MSP", "IPR002569 : MsrA", "IPR002579 : MsrB", "IPR001369 : Mtap_PNP", 
                      "IPR007823 : mtransfer", "IPR011610 : Mtu_fam_121", "IPR013221 : Mur_ligase_M", 
                      "IPR000432 : MutS_C", "IPR007860 : MutS_II", "IPR007696 : MutS_III", 
                      "IPR007861 : MutS_IV", "IPR007695 : MutS_N", "IPR011403 : PPi_PFK_TM0289", 
                      "IPR002885 : PPR", "IPR002372 : PQQ_repeat", "IPR011033 : PRCH_cytoplasmic", 
                      "IPR010456 : PrmA_mtfrase", "IPR010759 : ProFAR-like", "IPR000010 : Prot_inh_cystat", 
                      "IPR003243 : Prot_inh_I25A_B", "IPR000719 : Prot_kinase", "IPR001353 : Proteasome_A_B", 
                      "IPR000836 : PRtransferase", "IPR006225 : Pseud_synth_RluD", 
                      "IPR006145 : PseudoU_synth", "IPR001406 : PseudoU_synth_1", "IPR001656 : PsU_synth_TruD", 
                      "IPR003595 : PTPc_motif", "IPR003188 : PTS_IIA_lac", "IPR004720 : PTS_IIB_sorb", 
                      "IPR001313 : Pum_puf_RNA_bd", "IPR008963 : Purple_Pase_N", "IPR004861 : Put_tyr_phos", 
                      "IPR007190 : PWP2", "IPR013934 : PWP2_Utp13", "IPR001100 : Pyr_redox", 
                      "IPR004099 : Pyr_redox_dim", "IPR001327 : Pyr_redox_NAD_bd", 
                      "IPR000103 : Pyridine_redox_2", "IPR004625 : Pyridox_kin", "IPR002129 : Pyridoxal_deC", 
                      "IPR010121 : Pyru_phos_dikin", "IPR011895 : Pyruv_ox_red", "IPR001697 : Pyruvate_kinase", 
                      "IPR011047 : Quino_alc_DH", "IPR011044 : Quino_amine_DH_b", "IPR011041 : Quino_gluc_DH", 
                      "IPR009006 : Racem_decarbox_C", "IPR003021 : Rad1_Rec1", "IPR003011 : Rad1_repair", 
                      "IPR013020 : Rad3", "IPR010995 : Rad51_N", "IPR011575 : RasGAP_prot", 
                      "IPR000651 : RasGef_N", "IPR009091 : RCC1/BLIP-II", "IPR004589 : RecQ", 
                      "IPR013748 : Rep_fac_C", "IPR006935 : ResIII", "IPR011538 : Resp_NADH_DH_51K_dom", 
                      "IPR001789 : Response_reg", "IPR009400 : REX1", "IPR013725 : RFC1_C", 
                      "IPR000342 : RGS", "IPR010256 : RH_like_transpt", "IPR002229 : RhesusRHD", 
                      "IPR008936 : Rho_GAP", "IPR000219 : RhoGEF", "IPR002734 : RibDG_C", 
                      "IPR005680 : Ribosom_S23_arc", "IPR014401 : Ribosom_S6_euk", 
                      "IPR001921 : Ribosomal_7A", "IPR010979 : Ribosomal_H2TH", "IPR001197 : Ribosomal_L10E", 
                      "IPR001380 : Ribosomal_L13E", "IPR005755 : Ribosomal_L13e/a", 
                      "IPR000218 : Ribosomal_L14", "IPR005484 : Ribosomal_L18p", "IPR000196 : Ribosomal_L19e", 
                      "IPR005721 : Ribosomal_L22/17", "IPR000988 : Ribosomal_L24E", 
                      "IPR011035 : Ribosomal_L25rel", "IPR005756 : Ribosomal_L26e/a", 
                      "IPR000517 : Ribosomal_L30", "IPR001515 : Ribosomal_L32E", "IPR008195 : Ribosomal_L34E", 
                      "IPR001780 : Ribosomal_L35AE", "IPR001569 : Ribosomal_L37E", 
                      "IPR002136 : Ribosomal_L4/L1E", "IPR001975 : Ribosomal_L40E", 
                      "IPR000552 : Ribosomal_L44E", "IPR003236 : Ribosomal_L5_mit", 
                      "IPR005485 : Ribosomal_L5euk", "IPR004038 : Ribosomal_L7A", "IPR013810 : Ribosomal_protein_S5_N", 
                      "IPR006032 : Ribosomal_S12_23", "IPR012606 : Ribosomal_S13_N", 
                      "IPR005713 : Ribosomal_S15e/a", "IPR001210 : Ribosomal_S17E", 
                      "IPR001266 : Ribosomal_S19E", "IPR001931 : Ribosomal_S21E", "IPR001976 : Ribosomal_S24E", 
                      "IPR000892 : Ribosomal_S26E", "IPR000592 : Ribosomal_S27E", "IPR005707 : Ribosomal_S2_e/a", 
                      "IPR001593 : Ribosomal_S3AE", "IPR005710 : Ribosomal_S4/9", "IPR000876 : Ribosomal_S4E", 
                      "IPR013845 : Ribosomal_S4E_central", "IPR013843 : Ribosomal_S4E_N", 
                      "IPR013844 : Ribosomal_S4E_N_RNA_bd", "IPR001377 : Ribosomal_S6E", 
                      "IPR000554 : Ribosomal_S7E", "IPR005716 : Ribosomal_S7e/a", "IPR001047 : Ribosomal_S8E", 
                      "IPR013025 : Ribosome_L25_23", "IPR011060 : RibP_bd_barrel", 
                      "IPR005946 : RibP_Ppkin", "IPR008997 : RicinB_like", "IPR003117 : RIIa", 
                      "IPR011016 : RINGv", "IPR006590 : RNA_pol_II_Rpb4", "IPR003716 : RNA_pol_omega", 
                      "IPR009025 : RNA_pol_RBP11-like", "IPR007644 : RNA_pol_Rpb2_1", 
                      "IPR007120 : RNA_pol_Rpb2_6", "IPR000783 : RNA_pol_Rpb5", "IPR009026 : RNA_pol_Rpb5/Rpb6-like", 
                      "IPR006592 : RNA_polA_N", "IPR011261 : RNAP_dimersation", "IPR011262 : RNAP_insert", 
                      "IPR011263 : RNAP_RpoA_D_Rpb3", "IPR012164 : RNApol_C11", "IPR010513 : RNase_L", 
                      "IPR002730 : RNase_P_Rpp29", "IPR000504 : RNP1_RNA_bd", "IPR004942 : Robl_LC7", 
                      "IPR002661 : RRF", "IPR002877 : RrmJFtsJ_mtfrase", "IPR006174 : rRNAsub_mtfrase", 
                      "IPR013550 : RTX_C", "IPR004012 : Run", "IPR011132 : RuvA_like_C", 
                      "IPR002133 : S-AdoMet_synt", "IPR003029 : S1_RNA_bd", "IPR010884 : S48_45", 
                      "IPR001985 : SAM_decarbox", "IPR008373 : Saposin", "IPR011001 : Saposin_like", 
                      "IPR007273 : SCAMP", "IPR002198 : SDR", "IPR013907 : Sds3", "IPR006722 : Sedlin_N", 
                      "IPR000264 : Serum_albumin", "IPR009846 : SF3b10", "IPR001452 : SH3", 
                      "IPR003646 : SH3_bac", "IPR003000 : SIR2", "IPR007857 : Skb1_mtfrase", 
                      "IPR001232 : Skp1", "IPR001119 : SLH", "IPR008984 : SMAD_FHA", 
                      "IPR003395 : SMC_N", "IPR006021 : SNase", "IPR006939 : SNF5", 
                      "IPR009002 : Split_barrel_FMN_bd_related", "IPR012609 : Spore_V_M", 
                      "IPR003210 : SRP14", "IPR002778 : SRP19", "IPR000897 : SRP54_GTPase", 
                      "IPR013822 : SRP54_helical", "IPR004125 : SRP54_M", "IPR013699 : SRP72_RNA_bd", 
                      "IPR009018 : SRP9/14", "IPR009044 : ssDNA_bd_regul", "IPR006811 : Ssu72", 
                      "IPR014479 : SSUE", "IPR007726 : SSXT", "IPR013721 : STAG", "IPR000956 : Stathmin", 
                      "IPR001104 : Strd5A_DH_C", "IPR010354 : Strep_67kDa_ant", "IPR008847 : Suf", 
                      "IPR002828 : SurE", "IPR010989 : t-snare", "IPR001130 : TatD_DNase", 
                      "IPR004370 : Taut", "IPR012945 : TBCC", "IPR001983 : TCTP", "IPR014020 : Tensin_C2", 
                      "IPR008930 : Terp_cyc_toroid", "IPR008952 : Tetraspanin", "IPR002487 : TF_Kbox", 
                      "IPR009083 : TFIIA_helical", "IPR003923 : TFIID_30kD", "IPR011039 : TFIIF_interactn", 
                      "IPR001222 : TFIIS", "IPR007537 : Thg1", "IPR003720 : ThiI", 
                      "IPR005982 : Thioredox_reduct", "IPR005789 : Thr_dehydrateII", 
                      "IPR004450 : Thr_synthase", "IPR000157 : TIR", "IPR007713 : TMP", 
                      "IPR011166 : TNase", "IPR001368 : TNFR_c6", "IPR010528 : TolA", 
                      "IPR011042 : TolB_C", "IPR000380 : Topo_IA", "IPR001440 : TPR_1", 
                      "IPR011716 : TPR_3", "IPR008974 : Traf_like", "IPR005476 : Transketo_C", 
                      "IPR009014 : Transketo_C_like", "IPR005474 : Transketo_N", "IPR008991 : Transl_SH3_like", 
                      "IPR000301 : Transmem_4", "IPR001888 : Transposase_1", "IPR002560 : Transposase_12", 
                      "IPR003346 : Transposase_20", "IPR002492 : Transposase_5", "IPR008856 : TRAP_beta", 
                      "IPR003993 : treacle", "IPR006037 : TrkAC", "IPR002905 : TRM_mtfrase", 
                      "IPR002300 : tRNA-synt_1a", "IPR002305 : tRNA-synt_1b", "IPR004364 : tRNA-synt_2", 
                      "IPR002314 : tRNA-synt_2b", "IPR002318 : tRNA-synt_2c", "IPR002319 : tRNA-synt_2d", 
                      "IPR002312 : tRNA-synt_asp", "IPR002301 : tRNA-synt_ile", "IPR002313 : tRNA-synt_lys_2", 
                      "IPR002304 : tRNA-synt_met", "IPR002316 : tRNA-synt_pro", "IPR002317 : tRNA-synt_ser", 
                      "IPR002320 : tRNA-synt_thr", "IPR002303 : tRNA-synt_val", "IPR006677 : tRNA_int_endo_C", 
                      "IPR006195 : tRNA_ligase_II", "IPR002649 : tRNA_m1G_mtfrase", 
                      "IPR008925 : tRNA_synt_bd", "IPR009080 : tRNAsyn_1a_bd", "IPR002931 : Trnsglumase_like", 
                      "IPR002306 : Trp_tRNA-synt_1b", "IPR005801 : TRPE_1_chor_bd", 
                      "IPR002501 : Tru_synth_B_N", "IPR011760 : TRUD", "IPR008882 : Trypano_PARP", 
                      "IPR004307 : TspO_MBR", "IPR000387 : TYR_phosphatase", "IPR000449 : UBA/Transl_elong_EF1B_N", 
                      "IPR005122 : UDNA_glycsylseSF", "IPR009448 : UDP-g_GGtrans", 
                      "IPR014687 : UDP_ManNAc_DH", "IPR014027 : UDPG_MGDP_DH_C", "IPR014026 : UDPG_MGDP_DH_dimer", 
                      "IPR001732 : UDPG_MGDP_DH_N", "IPR014684 : UDPglc_DH_euk", "IPR014360 : UDPglc_GDPman_dh", 
                      "IPR000541 : UPF0021", "IPR001498 : UPF0029", "IPR005155 : UPF0113", 
                      "IPR007144 : Utp11", "IPR007148 : Utp12", "IPR006709 : Utp14", 
                      "IPR009055 : UvrB_UvrC_bd_C", "IPR000212 : UvrD_helicase", "IPR009008 : ValRS_IleRS_edit", 
                      "IPR003128 : VHP", "IPR007261 : Vps36", "IPR007262 : Vps55", 
                      "IPR009543 : VPSAP", "IPR008197 : WAP", "IPR001680 : WD40", "IPR011046 : WD40_like", 
                      "IPR006043 : Xant/urac/vitC", "IPR004183 : Xdiol_dOase_3B", "IPR001161 : XPB_DNA_repair", 
                      "IPR001945 : XPD_DNA_repair", "IPR006085 : XPG_N", "IPR006084 : XPGC_Rad", 
                      "IPR006000 : Xylulokinase", "IPR007214 : YbaK", "IPR010488 : Zeta_toxin", 
                      "IPR013134 : Zn_hook_Rad50", "IPR000315 : Znf_Bbox", "IPR013138 : Znf_TFIIS_2", 
                      "IPR006773 : 26S_Psome_Ubiquitin-recp_Rpn13", "IPR011282 : 2am3keto_CoA_ligase", 
                      "IPR002888 : 2Fe-2S-bd", "IPR011294 : 3-OHbutyrate_DH", "IPR012792 : 3-oxoacid_CoA-transf_A", 
                      "IPR012791 : 3-oxoacid_CoA-transf_B", "IPR014388 : 3-oxoacid_CoA-transferase", 
                      "IPR002225 : 3Beta_OHSteriod_DH/Estase", "IPR001450 : 4Fe4S-bd_domain", 
                      "IPR015896 : 4pyrrol_synth_GluRdtase_dimer", "IPR001646 : 5peptide_repeat", 
                      "IPR005900 : 6-phosphogluconolactonase_DevB", "IPR003094 : 6Pfruct_kin", 
                      "IPR013079 : 6Phosfructo_kin", "IPR004841 : AA-permease_dom", 
                      "IPR002314 : aa-tRNA-synt_IIb_cons-dom", "IPR010065 : AA_ABC_transptr_permease_3TM", 
                      "IPR001140 : ABC_transptr_TM_dom", "IPR011527 : ABC_transptrTM_dom_typ1", 
                      "IPR011904 : Ac_CoA_lig", "IPR016715 : Ac_Ohase_PAF", "IPR006159 : Acid_CoA_mut_C", 
                      "IPR004313 : Acireductn_dOase", "IPR008381 : ACN9", "IPR010169 : AcOrn-deacetyl", 
                      "IPR001036 : Acrflvin-R", "IPR002912 : ACT-bd", "IPR000182 : AcTrfase_GCN5-related_dom", 
                      "IPR009160 : Acyl-CoA_deSatase_haem/ster-bd", "IPR006091 : Acyl-CoA_Oxase/DH_cen-dom", 
                      "IPR000043 : Adenosylhomocysteinase", "IPR007862 : Adenylate_kinase_lid-dom", 
                      "IPR013539 : AdenyloSucc_lyase_C_pln", "IPR000274 : Adenylt_cyclse_1", 
                      "IPR013149 : ADH_C", "IPR012197 : MVK_PMK", "IPR001005 : Myb_DNA_bd", 
                      "IPR001734 : Na/solut_symport", "IPR002715 : NAC", "IPR006168 : NAD_Gly3P_DH", 
                      "IPR011128 : NAD_Gly3P_DH_N", "IPR002023 : NADH_DH_24kDa", "IPR004439 : NADP_IDH_prok", 
                      "IPR004455 : NADPoxred_F420", "IPR004547 : NagB", "IPR005264 : NanA", 
                      "IPR007229 : NAPRTase", "IPR001564 : NDK", "IPR012005 : NDK-2", 
                      "IPR011040 : Neuramndase", "IPR006405 : Nic_PRtrans_like", "IPR008710 : Nicastrin", 
                      "IPR001075 : NifU_C", "IPR002871 : NifU_N", "IPR000415 : Nitroreductase", 
                      "IPR000064 : NLP_P60", "IPR008030 : NmrA", "IPR013344 : NrdJ_Z", 
                      "IPR010708 : NT5C", "IPR012581 : NUC156", "IPR009110 : Nuc_rcpt_coact", 
                      "IPR008946 : Nucl_hrmn_rcpt_lig_bd", "IPR007231 : Nucleoporin_intact_comp", 
                      "IPR004870 : Nucleoporin_WGA-neg", "IPR000086 : NUDIX_hydrolase", 
                      "IPR010902 : NUMOD4", "IPR003455 : Omt_N", "IPR001742 : Orbi_VP2", 
                      "IPR001399 : Orbi_VP6", "IPR002433 : Orn_decarbxylse", "IPR003718 : OsmC", 
                      "IPR001809 : Outrsurface", "IPR001155 : Oxidored_FMN_N", "IPR001433 : Oxred_FAD_NAD_bd", 
                      "IPR006544 : P-ATPase-V", "IPR006789 : p16_Arc", "IPR008729 : PA_decarbox", 
                      "IPR011068 : PAP_C", "IPR012222 : PAP_CCA", "IPR001290 : PARP", 
                      "IPR000014 : PAS", "IPR000700 : PAS-assoc_C", "IPR013655 : PAS_3", 
                      "IPR013656 : PAS_4", "IPR013767 : PAS_fold", "IPR001460 : PBP_tpept", 
                      "IPR012338 : PBP_tpept_fold", "IPR007735 : Pecanex_C", "IPR011050 : Pectin_lyas_fold/virulence", 
                      "IPR008209 : PEP_carboxykin", "IPR008210 : PEPCK_N", "IPR001042 : Pept_A11B_Ty1", 
                      "IPR006615 : Pept_C19_N_1", "IPR009180 : Pept_M22_Osialgl", "IPR007865 : Pept_M24B_N", 
                      "IPR011056 : Pept_S24_S26_C", "IPR007369 : Peptidase_A22B", "IPR000317 : Peptidase_C24", 
                      "IPR005322 : Peptidase_C69", "IPR001930 : Peptidase_M1", "IPR005317 : Peptidase_M49", 
                      "IPR005320 : Peptidase_S51", "IPR000246 : Peptidase_T2", "IPR000326 : Pesterase_PA_PTP", 
                      "IPR014389 : Pesterase_YkuE", "IPR011611 : PfkB_region", "IPR005841 : PG/PMM_mutase", 
                      "IPR005844 : PG_PMM_ABAI", "IPR005845 : PG_PMM_ABAII", "IPR005846 : PG_PMM_ABAIII", 
                      "IPR005843 : PG_PMM_C", "IPR002477 : PGBD_1", "IPR009070 : PGBD_like", 
                      "IPR001576 : PGK", "IPR005003 : Phage_fiber", "IPR004529 : PheS", 
                      "IPR004531 : PheT_arch", "IPR014051 : Phosphoesterase_HXTX", 
                      "IPR005900 : Phosphogluconlac", "IPR013516 : Phyto_chromo_BS", 
                      "IPR003719 : PhzC_PhzF", "IPR000909 : PI_PLC_X", "IPR001711 : PI_PLC_Y", 
                      "IPR003737 : PIGL/MshB", "IPR002498 : PIP5K", "IPR012093 : Pirin", 
                      "IPR008778 : Pirin_C", "IPR003829 : Pirin_N", "IPR011037 : PK_B_barrel_like", 
                      "IPR000601 : PKD", "IPR011072 : PKN_effector", "IPR008947 : PLC_Nuclease", 
                      "IPR001531 : PLC_Zn_bd", "IPR000845 : PNP_UDP", "IPR011268 : PNPHPUNA_XAPA", 
                      "IPR008921 : Pol_clamp_load_C", "IPR000959 : POLO_box", "IPR002509 : Polysac_deacet", 
                      "IPR002869 : POR", "IPR002880 : POR_N", "IPR004968 : Pox_D5", 
                      "IPR000009 : Pp2A_PR55", "IPR014045 : PP2C-like", "IPR011078 : PP_YBL036C", 
                      "IPR005107 : CO_DH_flav_C", "IPR005252 : COABC", "IPR006822 : Coatomer_E", 
                      "IPR006692 : Coatomer_WDAD", "IPR002779 : Cob_adeno_trans", "IPR002108 : cofln_actin_bd", 
                      "IPR010490 : COG6", "IPR010714 : COPI_alpha_C", "IPR011710 : COPI_beta_C", 
                      "IPR000883 : COX1", "IPR004871 : CPSF_A_C", "IPR007052 : CS", 
                      "IPR001373 : Cullin", "IPR005627 : CutC", "IPR008173 : CyaB", 
                      "IPR000789 : Cyc_dep_kin_rsub", "IPR009097 : Cyc_nuc_Pdiester", 
                      "IPR007325 : Cyclase", "IPR000277 : Cys_Met_Meta_PP", "IPR002308 : Cys_tRNA-synt_1a", 
                      "IPR011048 : Cyt_cd1_haem_C", "IPR000298 : CytC_oxdse_III", "IPR008996 : Cytok_IL1_like", 
                      "IPR002294 : D12N6_mtfrase", "IPR013251 : DASH_Spc19", "IPR011545 : DEAD/DEAH_N", 
                      "IPR014014 : DEAD_Q_motif", "IPR011029 : DEATH_like", "IPR000183 : Decarbxylse2", 
                      "IPR001875 : DED", "IPR000653 : DegT_DnrJ_EryC1", "IPR006554 : DEXDc2", 
                      "IPR007085 : Dfp_C", "IPR013594 : DHC_N1", "IPR013602 : DHC_N2", 
                      "IPR002220 : DHDPS", "IPR012135 : DHO_DH_1_2", "IPR005720 : DHO_DH_1_core", 
                      "IPR001295 : DHO_DH_core", "IPR005847 : DHOase", "IPR011005 : DHP_synth_like", 
                      "IPR008922 : Di-copper_centre", "IPR011008 : Dimer_A_B_barrel", 
                      "IPR006602 : DM10", "IPR006607 : DM15", "IPR005173 : DMA", "IPR011257 : DNA_glycsylse", 
                      "IPR014017 : DNA_hel_UvrD_C", "IPR002099 : DNA_mis_repair", "IPR013507 : DNA_mis_repair_C", 
                      "IPR001098 : DNA_pol", "IPR004578 : DNA_pol2", "IPR006172 : DNA_pol_B", 
                      "IPR004868 : DNA_pol_B_2", "IPR006133 : DNA_pol_B_exo", "IPR006134 : DNA_pol_B_region", 
                      "IPR002934 : DNA_pol_beta", "IPR007185 : DNA_pol_E_B", "IPR002298 : DNA_polI", 
                      "IPR007238 : DNA_primase_lrg_euk", "IPR001305 : DnaJ_CXXCXGXG", 
                      "IPR010996 : DNApol_B_N_like", "IPR004947 : DNase_II", "IPR002624 : dNK", 
                      "IPR002105 : Dockerin_1", "IPR007858 : Dpy-30", "IPR010473 : Drf_GTPase_bd", 
                      "IPR000340 : DS_phosphatase", "IPR001774 : DSL", "IPR000888 : dTDP_sugar_isom", 
                      "IPR004652 : Du_synth_NifR3", "IPR002804 : DUF101", "IPR010939 : DUF1136", 
                      "IPR010721 : DUF1295", "IPR010750 : DUF1325", "IPR009784 : DUF1349", 
                      "IPR010011 : DUF1518", "IPR013861 : DUF1751_Mem_euk", "IPR004920 : DUF263", 
                      "IPR005175 : DUF296", "IPR005185 : DUF307", "IPR005532 : DUF323", 
                      "IPR005602 : DUF334", "IPR005624 : DUF336", "IPR007153 : DUF355", 
                      "IPR007272 : DUF395_YeeE_YedE", "IPR007420 : DUF465", "IPR007438 : DUF488", 
                      "IPR002737 : DUF52", "IPR008547 : DUF829_euk", "IPR002786 : DUF84", 
                      "IPR008570 : DUF852_euk", "IPR008576 : DUF858_Mtase_lik", "IPR009286 : DUF941", 
                      "IPR009305 : DUF962", "IPR009327 : DUF985", "IPR006461 : DUF_Cys-rich", 
                      "IPR006556 : DUF_FAF1", "IPR001401 : Dynamin", "IPR001372 : Dynein_light1", 
                      "IPR003172 : E1_DerP2_DerF2", "IPR001334 : E6", "IPR003938 : EAG_ELK_ERG", 
                      "IPR004953 : EB1", "IPR002952 : Eggshell", "IPR002735 : eIF5_eIF2B", 
                      "IPR005910 : ELP3_Ac_trans", "IPR008232 : EMAPII", "IPR007581 : Endonuc_V", 
                      "IPR007346 : Endonuclease_I", "IPR006175 : Endoribon_LPSP", "IPR000352 : Pep_chain_release_fac_I_II", 
                      "IPR018061 : Pept_A2A_retrovirus_sg", "IPR017294 : Pept_S8A_site-1-pep", 
                      "IPR001300 : Peptidase_C2_calpain_cat", "IPR008751 : Peptidase_C53", 
                      "IPR006286 : Peptidase_C56", "IPR001333 : Peptidase_M32", "IPR008007 : Peptidase_M42", 
                      "IPR017537 : Peptidase_M42_hydrolase", "IPR001563 : Peptidase_S10", 
                      "IPR001847 : Peptidase_S21", "IPR000280 : Peptidase_S31", "IPR001850 : Peptidase_S7", 
                      "IPR000383 : Peptidase_S9/S15", "IPR004403 : Peptide_chain-rel_eRF1/aRF1", 
                      "IPR003718 : Peroxiredoxin_OsmC-like", "IPR015342 : PEX-1N", 
                      "IPR013919 : Pex16", "IPR006183 : Pgluconate_DH/OHisobutyrate_DH", 
                      "IPR005068 : Phage_fibre_2", "IPR004195 : Phage_lambda_HDPD", 
                      "IPR018306 : Phage_T5_ORF172_DNA-bd", "IPR001106 : Phe/His_NH3-lyase", 
                      "IPR015012 : Phe_ZIP", "IPR002319 : Phenylalanyl-tRNA_Synthase", 
                      "IPR012597 : Pheromone", "IPR009064 : Pheromone_protoz", "IPR005121 : PheS_beta_Fdx_antiC-bd", 
                      "IPR008977 : PHM_PNGase_F-fold_dom", "IPR017684 : Phophono-pyrv_decarboxylase", 
                      "IPR000979 : Phosphodiesterase_MJ0936", "IPR000023 : Phosphofructokinase_dom", 
                      "IPR003633 : Phospholipase_C_var-glycoprot", "IPR000484 : Photo_RC_L/M", 
                      "IPR001683 : Phox", "IPR006163 : Phsphopanteth-bd", "IPR000341 : PI3K_ras-bd", 
                      "IPR016542 : PIG-P_GPI19", "IPR006596 : PINc_nuc-bd", "IPR001263 : PInositide-3_kin_accessory_dom", 
                      "IPR001192 : Pinositol_Phospholipase-C", "IPR015155 : PLAA_fam_Ub-bd_PFU", 
                      "IPR011067 : Plasmid_toxin/cell-grow_inhib", "IPR000909 : PLipase_C_PInositol-sp_X_dom", 
                      "IPR005916 : Pmev_kin_euk", "IPR019531 : Pmp4", "IPR001778 : POA_allergen", 
                      "IPR007012 : PolA_pol_cen_dom", "IPR002646 : PolA_pol_head_dom", 
                      "IPR007010 : PolA_pol_RNA-bd_dom", "IPR000176 : PolA_polymerase_reg", 
                      "IPR000959 : POLO_box_duplicated_dom", "IPR012317 : Poly(ADP-ribose)pol_cat_dom", 
                      "IPR004102 : Poly(ADP-ribose)pol_reg_dom", "IPR006551 : Polynucleotide_phosphatase", 
                      "IPR002504 : polyP/ATP_NADK_prd", "IPR003616 : Post-SET_dom", 
                      "IPR001932 : PP2C-like", "IPR012911 : PP2C_C", "IPR004131 : PPase-energised_H-pump", 
                      "IPR002192 : PPDK_PEP-bd", "IPR007498 : PqiA", "IPR010655 : Pre-mRNA_cleavage_cplxII_Clp1", 
                      "IPR004127 : Prefoldin_subunit", "IPR012389 : PREG", "IPR005946 : PRib_PPkinase", 
                      "IPR014819 : PriCT_2", "IPR000817 : Prion", "IPR006083 : PRK/URK", 
                      "IPR004499 : Pro-tRNA-synth_IIa_euk-type", "IPR008794 : Pro_racemase", 
                      "IPR003883 : Pro_rich_cell_wall_rpt", "IPR012599 : Propeptide_C1A", 
                      "IPR000877 : Prot_inh_BBI", "IPR005658 : Prot_inh_ecotin", "IPR011061 : Prot_inh_I14/15_hirudin/antisn", 
                      "IPR002219 : Prot_Kinase_C-like_PE/DAG-bd", "IPR019161 : Prot_N_Gln_amidohydro", 
                      "IPR003137 : Protease-assoc_domain", "IPR010400 : Proteasome-int_thioredoxin_C", 
                      "IPR011052 : Proteinase_amylase_inhib_dom", "IPR006369 : Protohaem_IX_farnesylTrfase", 
                      "IPR016315 : Protohaem_IX_farnesylTrfase_mt", "IPR000795 : ProtSyn_GTP-bd", 
                      "IPR002501 : PsdUridine_synth", "IPR004802 : Pseudouridine_synthase-related", 
                      "IPR009900 : PSGP", "IPR014058 : Pteridine_reductase", "IPR000489 : Pterin-binding", 
                      "IPR016152 : PTrfase/Anion_transptr", "IPR001313 : Pumilio_RNA-bd_rpt", 
                      "IPR013102 : PYNP_C", "IPR016128 : Pyoson/cloacin_translocation", 
                      "IPR001327 : Pyr_OxRdtase_NAD-bd", "IPR015424 : PyrdxlP-dep_Trfase_major_dom", 
                      "IPR006384 : PyrdxlP_Pase-rel", "IPR015813 : Pyrv/PenolPyrv_Kinase", 
                      "IPR011037 : Pyrv_Knase-like_insert_dom", "IPR018317 : Queuosine_synthesis", 
                      "IPR001374 : R3H_ss-bd", "IPR000195 : RabGAP/TBC_dom", "IPR006909 : Rad21/Rec8_C_eu", 
                      "IPR004584 : Rad50", "IPR009109 : Ran_GTPase_activating_1_C", 
                      "IPR003395 : RecF/RecN/SMC", "IPR005621 : Regulation_modulator_SeqA", 
                      "IPR000769 : Regulatory_Rop", "IPR009714 : Resistin", "IPR006641 : Resolv_RNaseH-like", 
                      "IPR011335 : Restrct_endonuc_II-like", "IPR018892 : Retro-transposon_transp_CS", 
                      "IPR008803 : RHD3_GTP-bd", "IPR000198 : RhoGAP_dom", "IPR005878 : Ribosom_L1_bac-type", 
                      "IPR001790 : Ribosomal_L10/acidic_P0", "IPR001196 : Ribosomal_L15_CS", 
                      "IPR012678 : Ribosomal_L23/L15e", "IPR005756 : Ribosomal_L26/L24P_euk/arc", 
                      "IPR001921 : Ribosomal_L7A/L8", "IPR018492 : Ribosomal_L7Ae/L8/Nhp2", 
                      "IPR001859 : Ribosomal_P2", "IPR002583 : Ribosomal_S20", "IPR001912 : Ribosomal_S4/S9_N", 
                      "IPR011332 : Ribosomal_zn-bd_dom", "IPR004394 : Ribosome-assoc_Iojap-like", 
                      "IPR007741 : Ribosome/NADH_DH", "IPR009771 : Ribosome_control_1", 
                      "IPR013662 : RIH_assoc-dom", "IPR018539 : RNA-bd_mt", "IPR006196 : RNA-binding_domain_S1_IF1", 
                      "IPR000228 : RNA3'_term_phos_cycl-like", "IPR016443 : RNA3'_term_phos_cycl-like_euk", 
                      "IPR013796 : RNA3'_term_phos_cycl_insert", "IPR013792 : RNA3'P_cycl/enolpyr_Trfase_a/b", 
                      "IPR017083 : RNA_edit_cplx_Nase-su_MP42", "IPR017086 : RNA_edit_cplx_Nase-su_MP63", 
                      "IPR017085 : RNA_edit_cplx_Nase-su_MP81", "IPR017084 : RNA_edit_cplx_su_MP18", 
                      "IPR000394 : RNA_pol_sigma_54", "IPR006110 : RNA_poly_omega/K/RPABC2", 
                      "IPR011260 : RNAP_asu_C", "IPR005093 : RNArep_beta", "IPR013223 : RNase_B_OB_dom", 
                      "IPR017067 : RNase_H1_euk", "IPR012337 : RNaseH-like", "IPR002156 : RNaseH_domain", 
                      "IPR007209 : RNaseL-inhib_metal-bd_dom", "IPR015146 : RNR_stirrup", 
                      "IPR014892 : RPA_C", "IPR000504 : RRM_dom", "IPR003954 : RRM_dom_euk", 
                      "IPR013730 : rRNA_processing", "IPR000685 : RuBisCO_lsu_C", "IPR017443 : RuBisCO_lsu_fd_N", 
                      "IPR000894 : RuBisCO_sc", "IPR000477 : RVT", "IPR010661 : RVT_thumb", 
                      "IPR001985 : S-AdoMet_decarboxylase", "IPR018167 : S-AdoMet_decarboxylase_sg", 
                      "IPR016067 : S-AdoMet_deCO2ase_core", "IPR009068 : S15_NS1_RNA-bd", 
                      "IPR002942 : S4_RNA-bd", "IPR005097 : Saccharopine_DH/HSpermid_syn", 
                      "IPR003034 : SAP_DNA-bd", "IPR006900 : Sec23/24_helical_dom", 
                      "IPR006896 : Sec23/24_trunk_dom", "IPR011130 : SecA_preprotein_X-link_dom", 
                      "IPR011893 : Selenoprotein_Rdx-typ", "IPR001627 : Semaphorin/CD100_Ag", 
                      "IPR001245 : Ser-Thr/Tyr-Pkinase", "IPR005645 : Serine_hydrolase", 
                      "IPR001214 : SET_dom", "IPR011714 : Seve_residue_repeat", "IPR013658 : SGL", 
                      "IPR000623 : Shikimate_kinase", "IPR008377 : Sialidase_trypan", 
                      "IPR008207 : Sig_transdc_His_kin_Hpt_dom", "IPR001867 : Sig_transdc_resp-reg_C", 
                      "IPR017858 : AdoCbl_syn_CblAdoTrfase_PduO_N", "IPR002779 : AdoCbl_synth_CblAdoTrfase", 
                      "IPR016030 : AdoCbl_synth_CblAdoTrfase-like", "IPR007733 : Agouti", 
                      "IPR000866 : AhpC/TSA", "IPR000031 : AIR_COase_core", "IPR018165 : Ala-tRNA-synth_IIc_core", 
                      "IPR000821 : Ala_racemase", "IPR011079 : Ala_racemase_C", "IPR005000 : Aldehyde-lyase_domain", 
                      "IPR015590 : Aldehyde_DH_dom", "IPR001303 : Aldolase_II/adducin_N", 
                      "IPR008183 : Aldose_1-epimerase", "IPR009410 : Allene_ox_cyc", 
                      "IPR007173 : ALO", "IPR005841 : Alpha-D-phosphohexomutase", "IPR009944 : Amastin", 
                      "IPR015413 : Aminoacyl-tRNA-synt_I", "IPR004364 : Aminoacyl-tRNA-synt_II", 
                      "IPR002300 : Aminoacyl-tRNA-synth_Ia", "IPR002305 : Aminoacyl-tRNA-synth_Ib", 
                      "IPR006195 : Aminoacyl-tRNA-synth_II", "IPR002575 : Aminoglycoside_PTrfase", 
                      "IPR001905 : Ammonium_transpt", "IPR006828 : AMP_prot_kin_bsu_interact-dom", 
                      "IPR007785 : Anamorsin", "IPR004939 : Ananphase-promot_cplx_su10_DOC", 
                      "IPR000020 : Anaphylatoxin/fibulin", "IPR001828 : ANF_lig-bd_rcpt", 
                      "IPR005338 : Anhydro_N_Ac-Mur_kinase", "IPR007632 : Anoctamin", 
                      "IPR005572 : Anti-sigma_E_RseA_N", "IPR004154 : Anticodon-bd", 
                      "IPR017109 : AP4_complex_esu", "IPR007474 : ApaG_domain", "IPR000074 : ApoA1_A4_E", 
                      "IPR012269 : Aquaporin", "IPR014033 : Arginase_sub", "IPR001518 : Arginosuc_synth", 
                      "IPR005129 : ArgK", "IPR019345 : Armet_prot", "IPR010977 : Aromatic_deC", 
                      "IPR002207 : Asc_peroxidase", "IPR007374 : ASCH_domain", "IPR002312 : Asp/Asn-tRNA-synth_IIb", 
                      "IPR005106 : Asp/hSer_DH_NAD-bd", "IPR006132 : Asp/Orn_carbamoyltranf_P-bd", 
                      "IPR006131 : Asp_carbamoyltransf_Asp/Orn-bd", "IPR020478 : AT_hook-like", 
                      "IPR003135 : ATP-grasp_carboxylate-amine", "IPR003806 : ATP-grasp_DUF201-type", 
                      "IPR011419 : ATP12_ATPase-F1F0-assembly", "IPR003594 : ATPase-like_ATP-bd", 
                      "IPR000194 : ATPase_a/bsu_nucl-bd", "IPR002146 : ATPase_F0-cplx_b/b'su_bac", 
                      "IPR001469 : ATPase_F1-cplx_dsu/esu", "IPR020547 : ATPase_F1-cplx_dsu/esu_C", 
                      "IPR008250 : ATPase_P-typ_ATPase-assoc-dom", "IPR006403 : ATPase_P-typ_cat/Cu-transptr", 
                      "IPR001870 : B302/SPRY", "IPR009084 : B_transpositn_C", "IPR001025 : BAH_dom", 
                      "IPR016616 : Bardet-Biedl_syndrome_2_prot", "IPR006949 : Baseplate_assembly_J-like_pred", 
                      "IPR006606 : BBL5", "IPR018955 : BCDHK/PDK_N", "IPR015123 : Bcr-Abl_oncoprot_oligo", 
                      "IPR016288 : Beta_cellobiohydrolase", "IPR016260 : Bifunct_6PFK/fruc_bisP_Ptase", 
                      "IPR002657 : BilAc/Na_symport", "IPR011764 : Biotin_carboxylation_dom", 
                      "IPR019304 : BisP-indep_Pglycerate_Mutase", "IPR007034 : BMS1_TSR1_C", 
                      "IPR002860 : BNR_rpt", "IPR009149 : BR22", "IPR015187 : BRCA2_OB_1", 
                      "IPR008973 : C2_Ca/lipid-bd_dom_CaLB", "IPR001525 : C5_MeTfrase", 
                      "IPR010907 : Ca-mediated_lectin", "IPR000699 : Ca-rel_channel", 
                      "IPR003299 : Calflagin-bd", "IPR001393 : Calsequestrin", "IPR004178 : CaM-bd_dom", 
                      "IPR003117 : cAMP_dep_PK_reg_su_I/II_a/b", "IPR000938 : CAP-Gly_domain", 
                      "IPR006633 : Carb-bd_sugar_hydrolysis-dom", "IPR001317 : CarbamoylP_synth_GATase_dom", 
                      "IPR006275 : CarbamoylP_synth_lsu", "IPR005483 : CarbamoylP_synth_lsu_CPS-dom", 
                      "IPR000542 : Carn_acyl_trans", "IPR019323 : CAZ_cplx_RIM-bd_prot", 
                      "IPR002586 : CbiA_P_synth", "IPR016176 : Cbl-dep_enz_cat", "IPR013215 : Cbl-indep_Met_Synth_N", 
                      "IPR003874 : CDC45", "IPR003333 : CFA/mycolic_acid_synthase", 
                      "IPR001715 : CH-domain", "IPR006840 : ChaC", "IPR007921 : CHAP", 
                      "IPR001404 : Chaperone_HtpG", "IPR001270 : Chaprnin_ClpA/B", 
                      "IPR006189 : CHASE", "IPR003122 : Chemotax_Me-accpt_rcpt_lig-bd", 
                      "IPR011006 : CheY-like_superfamily", "IPR007603 : Choline_transptr-like", 
                      "IPR011935 : CHP02231", "IPR011749 : CHP02243", "IPR010109 : Citrate_synthase_euk", 
                      "IPR001807 : Cl-channel_volt-gated", "IPR015348 : Clathrin_H-chain_linker_core", 
                      "IPR000804 : Clathrin_sm-chain_CS", "IPR012537 : Cmp-R_leader", 
                      "IPR002125 : CMP_dCMP_Zn-bd", "IPR018490 : cNMP-bd-like", "IPR000595 : cNMP-bd_dom", 
                      "IPR003781 : CoA-bd", "IPR004165 : CoA_trans", "IPR016453 : Coatomer_beta'_subunit", 
                      "IPR006158 : Cobalamin-bd", "IPR006276 : Cobalamin-indep_Met_synthase", 
                      "IPR004226 : CofA_tubulin-bd", "IPR019465 : COG_cplx_su5", "IPR019335 : COG_su7", 
                      "IPR016632 : COG_su8", "IPR006769 : Coiled-coil-dom_prot_109_C", 
                      "IPR008011 : Complex1_LYR", "IPR012629 : Conotoxin_TVIIAGS", 
                      "IPR009761 : CRA_rpt", "IPR001071 : CRAL-bd_toc_tran", "IPR001251 : CRAL-bd_TRIO_C", 
                      "IPR008273 : CRAL-bd_TRIO_N", "IPR009745 : CRAM_rpt", "IPR001166 : Crust_neurhormone", 
                      "IPR002081 : Cryptochrome/DNA_photolyase_1", "IPR007052 : CS-like_domain", 
                      "IPR017447 : CS_domain", "IPR008462 : CsbD", "IPR002059 : CSP_DNA-bd", 
                      "IPR011706 : Cu-oxidase_2", "IPR011707 : Cu-oxidase_3", "IPR008457 : Cu-R_CopD", 
                      "IPR004946 : Cucumo_2B", "IPR013922 : Cyclin-related_2", "IPR005535 : Cyclotide", 
                      "IPR015803 : Cys-tRNA-synt_Ia", "IPR006233 : Cys_b_lyase_bac", 
                      "IPR006238 : Cys_b_lyase_euk", "IPR003197 : Cyt-d_ubiquinol_oxidase_14kDa", 
                      "IPR006593 : Cyt_b561/ferric_Rdtase_TM", "IPR002326 : Cyt_c1", 
                      "IPR003834 : Cyt_c_assmbl_TM_dom", "IPR009056 : Cyt_c_dom", "IPR015964 : Cyt_c_oxidase_su2-like_TM_dom", 
                      "IPR003205 : Cyt_c_oxidase_su8", "IPR002403 : Cyt_P450_E_grp-IV", 
                      "IPR004821 : Cyt_trans-rel", "IPR006139 : D-isomer_2_OHA_DH_cat_dom", 
                      "IPR009090 : D_amino_pept_C", "IPR011877 : D_ribokin_bac", "IPR004006 : Dak1", 
                      "IPR004007 : Dak2", "IPR008909 : DALR_anticod-bd", "IPR018501 : DDT_dom_superfamily", 
                      "IPR000488 : Death", "IPR001855 : Defensin_beta-typ", "IPR005931 : Delta1-pyrroline-5-COlate_DH-1", 
                      "IPR002773 : Deoxyhypus_synthase", "IPR004097 : DHHA2", "IPR000756 : Diacylglycerol_kin_accessory", 
                      "IPR001206 : Diacylglycerol_kinase_cat_dom", "IPR002925 : Dienelactn_hydro", 
                      "IPR010678 : Digest_organ_expansion_fac-prd", "IPR000160 : Diguanylate_cyclase-pred", 
                      "IPR001633 : Diguanylate_PEstase_EAL_dom", "IPR001796 : Dihydrofolate_reductase_dom", 
                      "IPR005720 : Dihydroorotate_DH_1", "IPR014003 : DM16_repeat", 
                      "IPR001275 : DM_DNA-bd", "IPR002180 : DMRL_synthase", "IPR000620 : DMT", 
                      "IPR009061 : DNA-bd_dom_put", "IPR006886 : DNA-dir_RNA_pol_III_Rpc5", 
                      "IPR002775 : DNA/RNA-bd_Alba-like", "IPR015886 : DNA_glyclase/AP_lyase_DNA-bd", 
                      "IPR006165 : DNA_helicase_ATP-dep_Ku70", "IPR003840 : DNA_helicase_Herpesvir", 
                      "IPR000977 : DNA_ligase_ATP-dep", "IPR012309 : DNA_ligase_ATP-dep_C", 
                      "IPR012310 : DNA_ligase_ATP-dep_cent", "IPR012308 : DNA_ligase_ATP-dep_N", 
                      "IPR011184 : DNA_mismatch_repair_MSH2", "IPR007459 : DNA_pol3_chi", 
                      "IPR013697 : DNA_pol_e_suA_C", "IPR016266 : DNA_pol_epsilon_bsu", 
                      "IPR002008 : DNA_pol_X_beta-like", "IPR002298 : DNA_polymerase_A", 
                      "IPR016558 : DNA_primase_lsu_euk", "IPR013765 : DNA_recomb/repair_RecA", 
                      "IPR018325 : DNA_repair_Rad4_transGln-dom", "IPR008865 : DNA_replication_term_site-bd", 
                      "IPR003533 : Doublecortin_dom", "IPR009914 : DPM2", "IPR007884 : DREV_MeTrfase", 
                      "IPR001159 : Ds-RNA-bd", "IPR009445 : DUF1077_TMEM85", "IPR009566 : DUF1181", 
                      "IPR009671 : DUF1260", "IPR010733 : DUF1308", "IPR010856 : DUF1479", 
                      "IPR009959 : DUF1486", "IPR003729 : DUF151", "IPR011677 : DUF1619", 
                      "IPR012864 : DUF1637", "IPR012457 : DUF1663", "IPR012880 : DUF1683_C", 
                      "IPR013544 : DUF1725", "IPR013618 : DUF1736", "IPR013899 : DUF1771", 
                      "IPR014903 : DUF1796_papain-like", "IPR003788 : DUF185", "IPR015045 : DUF1861", 
                      "IPR015206 : DUF1930", "IPR015232 : DUF1935", "IPR015308 : DUF1962", 
                      "IPR019352 : DUF2054", "IPR004245 : DUF229", "IPR019309 : DUF2360_coiled-coil", 
                      "IPR019446 : DUF2431", "IPR005184 : DUF306_Meta_HslJ", "IPR006696 : DUF423", 
                      "IPR007546 : DUF503", "IPR007553 : DUF523", "IPR007512 : DUF543", 
                      "IPR002740 : DUF55", "IPR006745 : DUF605", "IPR006968 : DUF647", 
                      "IPR007807 : DUF699_exoDNase-V_alpha", "IPR007808 : DUF701_Zn-bd", 
                      "IPR002761 : DUF71_ATP-bd_dom", "IPR002763 : DUF72", "IPR008032 : DUF749", 
                      "IPR008504 : DUF786_TMEM93", "IPR008506 : DUF788_TMEM208", "IPR008509 : DUF791", 
                      "IPR008551 : DUF833", "IPR008590 : DUF872_TM", "IPR010357 : DUF953_thioredox", 
                      "IPR011948 : Dullard_phosphatase", "IPR014871 : dUTPase_2", "IPR012960 : Dyskerin-like", 
                      "IPR004167 : E3-bd", "IPR013956 : E3_ubiquit_lig_BRE1", "IPR007905 : EBP", 
                      "IPR018248 : EF-hand", "IPR002048 : EF_hand_Ca-bd", "IPR019010 : eIF3_su6_N", 
                      "IPR015419 : EKC/KEOPS_Pcc1", "IPR000348 : Emp24/Gp25L/p24", 
                      "IPR003542 : Enbac_synth_compD-like", "IPR001178 : Endotoxin_cen_dom", 
                      "IPR010041 : Enolase_ppase", "IPR000639 : Epox_hydrolase-like", 
                      "IPR001026 : Epsin_dom_N", "IPR007266 : ER_oxidoreductin-1", 
                      "IPR006716 : ERG2_sigma1_rcpt-like", "IPR001171 : Ergosterol_biosynth_ERG4_ERG24", 
                      "IPR004922 : ESAG", "IPR006806 : ETC_CI_29_9", "IPR008917 : Euk_TF_DNA-bd", 
                      "IPR004808 : ExoDNase_III", "IPR012588 : Exosome-assoc_fac_Rrp6_N", 
                      "IPR013713 : Exportin/Importin_Cse1-like", "IPR006706 : Extensin_rpt", 
                      "IPR014436 : Extradiol_dOase_DODA", "IPR016044 : F", "IPR001810 : F-box_dom_cyclin-like", 
                      "IPR008920 : FA-response_TF_FadR_C", "IPR013112 : FAD-bd_8", 
                      "IPR016164 : FAD-linked_Oxase-like_C", "IPR004113 : FAD-linked_oxidase_C", 
                      "IPR004621 : Fadh2_euk", "IPR012171 : Fatty_acid/sphinglp_desaturase", 
                      "IPR003965 : Fatty_acid_synthase", "IPR000146 : FBPase_class-1/SBPase", 
                      "IPR004646 : Fe-S_hydro-lyase_TtdA-typ_cat", "IPR004647 : Fe-S_hydro-lyase_TtdB-typ_cat", 
                      "IPR013121 : Fe_red_NAD-bd_6", "IPR006614 : Ferlin/Peroxisome_membrane", 
                      "IPR015425 : FH2_actin-bd", "IPR000253 : FHA_dom", "IPR012969 : Fibrinogen_BP", 
                      "IPR008616 : Fibro-bd_N", "IPR008957 : Fibronectin_III_dom", 
                      "IPR007824 : Flagellar_rod", "IPR001094 : Flavdoxin", "IPR000960 : Flavin_mOase", 
                      "IPR010960 : Flavocytochrome_c", "IPR013130 : Flavoprotein_TM", 
                      "IPR008981 : FMuLV_rcpt-bd", "IPR018993 : FOP_dimerisation-dom_N", 
                      "IPR000559 : Formate_THF_ligase", "IPR017789 : Frataxin", "IPR012887 : Fucokinase", 
                      "IPR002529 : Fumarylacetoacetase_C-like", "IPR011234 : Fumarylacetoacetase_C-rel", 
                      "IPR015898 : G-protein_gamma_dom", "IPR000447 : G3P_DH_FAD-dep", 
                      "IPR006168 : G3P_DH_NAD-dep", "IPR006109 : G3P_DH_NAD-dep_C", 
                      "IPR017751 : G3P_DH_NAD-dep_euk", "IPR011128 : G3P_DH_NAD-dep_N", 
                      "IPR001282 : G6P_DH", "IPR011024 : G_crystallin-rel", "IPR000840 : G_retro_matrix_N", 
                      "IPR003036 : Gag_p30", "IPR019539 : GalKase_gal-bd", "IPR001174 : Galkinase", 
                      "IPR010376 : Gamma-BBH/TMLD_N", "IPR002003 : Gas-vesicle_GvpC", 
                      "IPR009395 : GCN5L1", "IPR017453 : GCV_H_sub", "IPR006223 : GcvT", 
                      "IPR020580 : GDC-P_N", "IPR003437 : GDC_P_homo", "IPR007123 : Gelsolin_dom", 
                      "IPR008627 : GETHR", "IPR008146 : Gln_synth_cat_dom", "IPR011070 : Globular_prot_asu/bsu", 
                      "IPR001057 : Glu/AcGlu_kinase", "IPR006097 : Glu/Leu/Phe/Val_DH_dimer_dom", 
                      "IPR011529 : Glu_5kinase", "IPR005715 : Glu_5kinase/COase_Synthase", 
                      "IPR016210 : Glu_DH_NAD-dep", "IPR002932 : Glu_synth_centr_C", 
                      "IPR006993 : Glut_rich_SH3-bd", "IPR013189 : Glyco_hydro_32_C", 
                      "IPR015341 : Glyco_hydro_38_cen_dom", "IPR000602 : Glyco_hydro_38_core", 
                      "IPR005194 : Glyco_hydro_65_C", "IPR005195 : Glyco_hydro_65_M", 
                      "IPR005196 : Glyco_hydro_65_N", "IPR003469 : Glyco_hydro_68", 
                      "IPR005201 : Glyco_hydro_85", "IPR001503 : Glyco_trans_10", "IPR002516 : Glyco_trans_11", 
                      "IPR002654 : Glyco_trans_25", "IPR014830 : Glycolipid_transfer_prot_dom", 
                      "IPR004888 : Glycoside_hydrolase_63", "IPR000312 : Glycosyl_Trfase_fam3", 
                      "IPR007873 : Glycosyltransferase_ALG3", "IPR013714 : Golgi_TVP15", 
                      "IPR000777 : GP120", "IPR005599 : GPI_mannosylTrfase", "IPR004174 : gpW", 
                      "IPR019459 : GRAB", "IPR002167 : Graves_DC", "IPR009017 : Green_fluorescent_prot-like", 
                      "IPR000791 : Grp1_Fun34_YaaH", "IPR005494 : GSP_synth", "IPR014100 : GTP-bd_Obg/CgtA", 
                      "IPR014768 : GTPase-bd/formin_homology_3", "IPR006687 : GTPase_SAR1", 
                      "IPR008145 : Guanylate_kin/L-typ_Ca_channel", "IPR009101 : Gurmarin/antifun_pep", 
                      "IPR007504 : H/ACA_rnp_Gar1/Naf1", "IPR002415 : H/ACA_rnp_Nhp2_euk", 
                      "IPR007264 : H/ACA_rnp_Nop10", "IPR010033 : HAD_SF_ppase_IIIC", 
                      "IPR012312 : Haemerythrin/HHE_cat-bd_motif", "IPR003660 : HAMP_linker_domain", 
                      "IPR009218 : HD_phosphohydro", "IPR001342 : HDH_cat", "IPR007502 : Helicase-assoc_dom", 
                      "IPR003780 : HemeA_syn/farnesylTrfrase", "IPR015338 : HexNAc_Trfase_a", 
                      "IPR017065 : HIRA-interacting_protein_5", "IPR013078 : His_Pase_superF_clade-1", 
                      "IPR000560 : His_Pase_superF_clade-2", "IPR011598 : HLH_DNA-bd", 
                      "IPR001092 : HLH_DNA-bd_dom", "IPR004254 : HlyIII-related", "IPR002202 : HMG_CoA_Rdtase", 
                      "IPR004554 : HMG_CoA_Rdtase_eu_arc", "IPR003511 : HORMA_DNA-bd", 
                      "IPR007065 : HPP", "IPR009643 : HS1-bd", "IPR003134 : Hs1_Cortactin", 
                      "IPR001305 : HSP_DnaJ_Cys-rich_dom", "IPR000551 : HTH_MerR", 
                      "IPR017930 : HTH_Myb-type_DNA-bd", "IPR010252 : HutF", "IPR005921 : HutH", 
                      "IPR005920 : HutI", "IPR008040 : Hydant_A_N", "IPR002821 : Hydantoinase_A", 
                      "IPR003692 : Hydantoinase_B", "IPR000649 : IF-2B-related", "IPR005251 : IF-2BI_MTNA", 
                      "IPR018529 : IMP_DH-rel", "IPR001494 : Importin-beta_N", "IPR006214 : Inhibitor_apoptosis_Bax1", 
                      "IPR011559 : Initiation_fac_2B_a/b/d", "IPR016029 : Inner_layer_core_VP3_Reovir", 
                      "IPR001910 : Inosine/uridine_hydrolase_dom", "IPR014821 : Ins145_P3_rcpt", 
                      "IPR014996 : Integr_conj_element_PFL4669", "IPR019185 : Integral_membrane_SYS1-rel", 
                      "IPR001037 : Integrase_C_retrovir", "IPR003308 : Integrase_Zn-bd_dom_N", 
                      "IPR012896 : Integrin_bsu_tail", "IPR000048 : IQ_motif_EF-hand-BS", 
                      "IPR004439 : Isocitrate_DH_NADP_prok", "IPR002283 : Isopenicillin-N_synthase", 
                      "IPR003280 : K_chnl_2pore", "IPR002957 : Keratin_I", "IPR007659 : Keratin_matx", 
                      "IPR019510 : Kinase-A_anchor_nucl_local_sig", "IPR001752 : Kinesin_motor_dom", 
                      "IPR002395 : Kininogen", "IPR004132 : KMP11", "IPR019547 : KuaUb-conj-enz_UEV1", 
                      "IPR011065 : Kunitz_inhibitor_ST1-like", "IPR010111 : Kynureninase", 
                      "IPR005929 : L_ribulokin", "IPR001236 : Lactate/malate_DH_N", 
                      "IPR009254 : Laminin_I", "IPR002172 : LDLR_classA_rpt", "IPR011015 : LEM-like_dom", 
                      "IPR007149 : Leo1", "IPR013842 : LepA_GTP-bd_C", "IPR003106 : Leu_zip_homeo", 
                      "IPR007074 : LicD-like", "IPR000538 : Link", "IPR001124 : Lipid-bd_serum_glycop_C", 
                      "IPR007372 : Lipid/polyisoprenoid-bd_YceI", "IPR006876 : LMBR1-like_membr_prot", 
                      "IPR005269 : LOG", "IPR005413 : LowCa_resp_V_Ag", "IPR013210 : LRR-contain_N2", 
                      "IPR010920 : LSM-related_domain", "IPR001163 : LSM_domain", "IPR006649 : LSM_domain_euk/arc", 
                      "IPR003612 : LTP/seed_store/tryp_amyl_inhib", "IPR006630 : Lupus_La_RNA-bd", 
                      "IPR008671 : Lycopene_cyclase_FAD-bd", "IPR005119 : LysR_subst-bd", 
                      "IPR011274 : Malate_DH_NAD-dep_euk", "IPR010097 : Malate_DH_NAD-dep_euk/g-bac", 
                      "IPR011076 : Malate_synth-like", "IPR004262 : Malesterile", "IPR012302 : Malic_NAD-bd", 
                      "IPR007956 : Malonyl_CoA_deC", "IPR009011 : Man6P_isomerase_rcpt-bd", 
                      "IPR002528 : MATE", "IPR010036 : MDP_1", "IPR008924 : Me_CoM_Rdtase_asu/bsu_C", 
                      "IPR019170 : Meckelin_TM", "IPR003171 : Mehydrof_redctse", "IPR017515 : MeMalonyl-CoA_epimerase", 
                      "IPR006099 : MeMalonylCoA_mutase_a/b_cat", "IPR001708 : Membrane_insertion_OxaA/YidC", 
                      "IPR014758 : Met-tRNA_synth", "IPR003759 : Met_synth_Cbl-bd", 
                      "IPR003607 : Metal-dep_PHydrolase_HD_dom", "IPR006674 : Metal-dep_PHydrolase_HD_sub", 
                      "IPR004843 : Metallo-dependent_phosphatase", "IPR001396 : Metallthion_4_echinoidea", 
                      "IPR011822 : MetH", "IPR010044 : MeThioAdo_phosphorylase", "IPR002629 : Methionine_synth", 
                      "IPR010743 : Methionine_synth_MetW", "IPR014048 : MethylDNA_cys_MeTrfase_DNA-bd", 
                      "IPR017714 : MethylthioRu-1-P_deHdtase_MtnB", "IPR005779 : MeTrfase_D", 
                      "IPR011607 : MGS-like_dom", "IPR006667 : MgtE_Mg_transptr_membr", 
                      "IPR007145 : Microtubule-assoc_MAP65_ASE1", "IPR006098 : MMCoA_mutase_a_cat", 
                      "IPR002917 : MMR_HSR1_GTP-bd", "IPR002938 : mOase_FAD-bd", "IPR003454 : mOase_MmoB_DmpM", 
                      "IPR004556 : Modification_methylase_HemK", "IPR004480 : Monothiol_GRX-rel", 
                      "IPR001453 : Mopterin-bd", "IPR002820 : Mopterin_CF_biosynth-C_dom", 
                      "IPR007281 : Mre11_DNA-bd", "IPR019564 : Mt-OM_transp_Tom37/Metaxin", 
                      "IPR009069 : MTCP1", "IPR011601 : MurB_C", "IPR001609 : Myosin_head_motor_dom", 
                      "IPR017906 : Myotubularin_phosphatase_dom", "IPR000903 : MyristoylCoA_TrFase", 
                      "IPR004365 : NA-bd_OB_tRNA-helicase", "IPR010526 : Na_trans_assoc", 
                      "IPR017328 : NAD-dep_deAcase_SIR2_euk", "IPR019575 : NADH-UbQ_OxRdtase_Fsu_4Fe4S-bd", 
                      "IPR011537 : NADH-UbQ_OxRdtase_suF", "IPR007523 : NADH_Ub_cplx-1_asu_assmbl-fac3", 
                      "IPR006137 : NADH_UbQ_OxRdtase-like_20kDa", "IPR002023 : NADH_UbQ_OxRdtase_24kDa_su", 
                      "IPR011538 : NADH_UbQ_OxRdtase_51kDa_su", "IPR019574 : NADH_UbQ_OxRdtase_Gsu_4Fe4S-bd", 
                      "IPR006138 : NADH_UQ_OxRdtase_20Kd_su", "IPR013946 : NCA2", "IPR011528 : NERD", 
                      "IPR011040 : Neuraminidase", "IPR006029 : Neurotrans-gated_channel_TM", 
                      "IPR012577 : NIPSNAP", "IPR005117 : NiRdtase/SiRdtase_haem-b_fer", 
                      "IPR006067 : NO2/SO3_Rdtase_4Fe4S_dom", "IPR014881 : NOB1_Zn-bd", 
                      "IPR010658 : Nodulin-like", "IPR010674 : NOG1_GTP-bd", "IPR012981 : Nop17p", 
                      "IPR000800 : Notch_dom", "IPR014822 : Nsp9", "IPR004740 : Nuc_H_symport", 
                      "IPR007231 : Nucleoporin_int_Nup93/Nic96", "IPR004870 : Nucleoporin_Nup155", 
                      "IPR007710 : Nucleoside_deoxyribTrfase", "IPR001564 : Nucleoside_diP_kinase", 
                      "IPR000845 : Nucleoside_phosphorylase_d", "IPR017476 : Nucleotide_sugar_DH", 
                      "IPR014798 : Ocr", "IPR006770 : OGF_rcpt_rpt", "IPR016474 : OM_assmbl_YaeT", 
                      "IPR017690 : OM_insertion_C_omp85_target", "IPR005318 : OM_porin_bac", 
                      "IPR009415 : Omega-atracotox", "IPR019412 : OMP_IML2_mit/TPR_39", 
                      "IPR006665 : OmpA/MotB_C", "IPR011995 : OMPdecase_type-2", "IPR001754 : OMPdeCOase_dom", 
                      "IPR004467 : Or_phspho_trans_clade-1", "IPR000183 : Orn/DAP/Arg_de-COase", 
                      "IPR019332 : OSCP1", "IPR006094 : Oxid_FAD_bind_N", "IPR019180 : Oxidoreductase-like_N", 
                      "IPR008333 : OxRdtase_FAD-bd_dom", "IPR001433 : OxRdtase_FAD/NAD-bd", 
                      "IPR000648 : Oxysterol-bd", "IPR014838 : P3A", "IPR000108 : p67phox", 
                      "IPR000519 : P_trefoil", "IPR006730 : PA26", "IPR005065 : PAF_acetylhydro_II", 
                      "IPR000095 : PAK_box_Rho-bd", "IPR002895 : Paramecium_SA", "IPR004437 : ParB_part", 
                      "IPR003115 : ParBc", "IPR002641 : Patatin/PhospholipaseA2-rel", 
                      "IPR005311 : PBP_dimer", "IPR000717 : PCI_dom", "IPR002073 : PDEase_catalytic_dom", 
                      "IPR012698 : PEnolPyrv_PMutase_core", "IPR008279 : PEP-utiliz_enz_mobile_dom", 
                      "IPR019773 : Tyrosine_3-monooxygenase-like", "IPR005957 : Tyrosine_aminoTrfase", 
                      "IPR003603 : U2A'_phosphoprotein32A_C", "IPR016615 : Ubiquitin_thioesterase_Otubain", 
                      "IPR000011 : UBQ/SUMO-activ_enz_E1-like", "IPR008568 : UCP010045_TM_euk", 
                      "IPR014500 : UCP019307_cupin-contain", "IPR014560 : UCP030333_Alba", 
                      "IPR004205 : UcrQ", "IPR014027 : UDP-Glc/GDP-Man_DH_C", "IPR014026 : UDP-Glc/GDP-Man_DH_dimer", 
                      "IPR001732 : UDP-Glc/GDP-Man_DH_N", "IPR002213 : UDP_glucos_trans", 
                      "IPR014505 : UMP-CMP_kinase_mit", "IPR004130 : Uncharacterised_ATP-bd", 
                      "IPR006461 : Uncharacterised_Cys-rich", "IPR006602 : Uncharacterised_DM10", 
                      "IPR004521 : Uncharacterised_dom_2", "IPR019155 : Uncharacterised_FPL", 
                      "IPR012977 : Uncharacterised_NUC130/133_N", "IPR007513 : Uncharacterised_SERF", 
                      "IPR019184 : Uncharacterised_TM-17", "IPR011637 : Uncharacterised_YphA", 
                      "IPR008189 : UPF0011", "IPR002036 : UPF0054_metalloprotease_prd", 
                      "IPR007451 : UPF0274", "IPR005651 : UPF0434/Trm112", "IPR019579 : UPF0564", 
                      "IPR018902 : UPF0573/UPF0605", "IPR002026 : Urease_alpha/gamma", 
                      "IPR019515 : Vacuolar_sorting-assoc_54", "IPR009008 : Val/Leu/Ile-tRNA-synth_edit", 
                      "IPR002303 : Valyl-tRNA_synthetase", "IPR019609 : Variant_surf_glycoprt_trypan_C", 
                      "IPR002499 : Vault_N", "IPR010221 : VCBS_rpt", "IPR007305 : Vesicle_transpt_Got1/SFT2", 
                      "IPR011691 : Vesicle_transpt_SFT2", "IPR007705 : Vesicle_trsprt_v-SNARE_N", 
                      "IPR018205 : VHS_subgroup", "IPR008982 : Viral_att", "IPR004223 : VitB12-dep_Met_synth_activ_dom", 
                      "IPR005377 : VPS26", "IPR007143 : VPS28", "IPR017899 : VPS28_C", 
                      "IPR017898 : VPS28_N", "IPR005378 : VPS35", "IPR019452 : VPS39/TGF_beta_rcpt-assoc_1", 
                      "IPR019453 : VPS39/TGF_beta_rcpt-assoc_2", "IPR007262 : VPS55", 
                      "IPR015404 : Vps5_C", "IPR017233 : WD_repeat_p35", "IPR008893 : WGR_dom", 
                      "IPR017987 : Wilms_tumour", "IPR013536 : WLM", "IPR003657 : WRKY_DNA-bd", 
                      "IPR006086 : XPG/RAD2_endonuclease", "IPR007214 : YbaK/aa-tRNA-synth-assoc-dom", 
                      "IPR007029 : YHS", "IPR019080 : YqaJ_viral_recombinase_family", 
                      "IPR004058 : Zeta_tubulin", "IPR007449 : ZipA_FtsZ-bd_C", "IPR001138 : Zn2-C6_fun-type_DNA-bd", 
                      "IPR001594 : Znf_DHHC_palmitoyltrfase", "IPR000962 : Znf_DskA_TraR", 
                      "IPR015416 : Znf_H2C2_histone_UAS-bd", "IPR015376 : Znr_NADH_PPase", 
                      "IPR006291 : Sig_transdc_resp-reg_metal", "IPR001789 : Sig_transdc_resp-reg_receiver", 
                      "IPR019128 : Sister_chromatid_cohesion_DCC1", "IPR014805 : SKG6/AXL2_alpha-helix_TM", 
                      "IPR005225 : Small_GTP-bd", "IPR002687 : SnoRNA-bd_dom", "IPR001424 : SOD_Cu_Zn", 
                      "IPR019554 : Soluble_ligand-bd", "IPR013254 : Sperm_act_pept", 
                      "IPR011388 : Sphingolipid_d4-desaturase", "IPR009002 : Split_barrel_FMN-bd-related", 
                      "IPR013123 : SpoU_subst-bd", "IPR001045 : Sprmine_synthase", 
                      "IPR002060 : Squ/phyt_synthse", "IPR006449 : Squal_synth", "IPR018333 : Squalene_cyclase", 
                      "IPR013698 : Squalene_epoxidase", "IPR000731 : SSD", "IPR002913 : START_lipid-bd", 
                      "IPR017916 : Steadiness_box", "IPR010993 : Sterile_alpha_motif_homology", 
                      "IPR013705 : Sterol_MeTrfase_C", "IPR006636 : STI1_HS-bd", "IPR006232 : Suc6P_hydrolase", 
                      "IPR009737 : Suc_Fer-like", "IPR005532 : Sulphatase-mod_factor", 
                      "IPR002994 : Surf1", "IPR007019 : Surf6", "IPR010827 : Surface_Ag_variable_number", 
                      "IPR017276 : Synth_of_cyt-c-oxidase_Sco1/2", "IPR018076 : T2SS_F", 
                      "IPR009929 : T3SS_YscO", "IPR000727 : T_SNARE_dom", "IPR015224 : Talin_cent", 
                      "IPR010090 : Tape_meas_TP901", "IPR019546 : TAT_signal_bac_arc", 
                      "IPR013867 : Telomere_rpt-bd_fac_dimer_dom", "IPR012992 : Tet-R_leader_TetM", 
                      "IPR018974 : Tex-like_N", "IPR013735 : TF_NusA_N", "IPR001699 : TF_T-box", 
                      "IPR002836 : TFAR19_DNA-bd", "IPR003618 : TFIIS_cen_dom", "IPR006001 : Therm_gnt_kin", 
                      "IPR016198 : Thiamin/HMP-bd-like_put", "IPR012000 : Thiamin_PyroP_enz_cen_dom", 
                      "IPR012001 : Thiamin_PyroP_enz_TPP-bd_dom", "IPR007373 : Thiamin_PyroPKinase_vitB1-bd", 
                      "IPR003374 : Thiamine_synth_ApbE/UPF0280", "IPR000594 : ThiF_NAD_FAD-bd", 
                      "IPR008867 : ThiG", "IPR020536 : ThiI_C", "IPR001010 : Thionin", 
                      "IPR008854 : Thiopurine_S-MeTrfase", "IPR000398 : Thymidylate_synthase", 
                      "IPR015256 : TIF2_gsu_C", "IPR013979 : TIF2A_central-region", 
                      "IPR007303 : TIP41-like", "IPR010261 : Tir_chaperone", "IPR018154 : TLV/ENV_coat_polyprotein", 
                      "IPR019396 : TM_Fragile-X-F-assoc", "IPR003733 : TMP_synthase", 
                      "IPR003602 : Topo_IA_DNA-bd", "IPR013506 : Topo_IIA_bsu_dom2", 
                      "IPR008336 : TopoI_DNA-bd_euk", "IPR007965 : Touch_recpt_neuron_Mec-17", 
                      "IPR012625 : Toxin_20", "IPR011766 : TPP_enzyme-bd_C", "IPR013026 : TPR-contain", 
                      "IPR004730 : Transaldolase_1", "IPR016650 : Transl_init_fac_3_su6_euk", 
                      "IPR016437 : Transl_RNA-bd_prd", "IPR004244 : Transposase_22", 
                      "IPR002525 : Transposase_N", "IPR010978 : tRNA-bd_arm", "IPR002547 : tRNA-bd_dom", 
                      "IPR011063 : tRNA-lysidine/thiocyt_synth", "IPR000541 : tRNA_2-thiolation_protein", 
                      "IPR017423 : tRNA_m1A_mtfrase", "IPR016653 : tRNA_m1G_mtfrase_met", 
                      "IPR008858 : TROVE", "IPR016031 : Trp_RNA-bd_attenuator-like", 
                      "IPR006518 : Trypano_RHS", "IPR001812 : Trypano_variant_glycop", 
                      "IPR001864 : Trypnth_redctse", "IPR001437 : Tscrpt_elong_fac_GreA/B_C", 
                      "IPR003902 : Tscrpt_reg_GCM_motif", "IPR015358 : Tscrpt_reg_MerR_DNA-bd", 
                      "IPR005398 : Tubby_N", "IPR008884 : TylF_MeTrfase", "IPR004861 : Tyr_Pase_SIW14-like", 
                      "IPR005958 : TyrNic_aminoTrfase", "SSF55486 : 0041314", "SSF51182 : 0045406", 
                      "SSF57581 : 0035156", "SSF52540 : 0049343", "PS51205 : VPS9", 
                      "PF01090 : Ribosomal_S19e", "SSF51556 : 0036862", "SSF53223 : 0035317", 
                      "PR00173 : EDTRNSPORT", "SSF55347 : 0046978", "SSF51283 : 0036608", 
                      "SSF53474 : 0044007", "SSF55221 : 0040202", "PR00621 : HISTONEH2B", 
                      "PF01196 : Ribosomal_L17", "SSF50494 : 0038059", "SSF46548 : 0042841", 
                      "PF09278 : MerR-DNA-bind", "PF01031 : Dynamin_M", "SSF53383 : 0044944", 
                      "SSF53474 : 0039579", "SSF48403 : 0050455", "SSF48726 : 0039923", 
                      "SSF53474 : 0035712", "SSF53850 : 0052996", "PR00945 : HGRDTASE", 
                      "PR01871 : ANNEXINVII", "PR01657 : MCMFAMILY", "SSF48264 : 0044304", 
                      "SSF49899 : 0047109", "SSF81524 : 0037295", "SSF55550 : 0035602", 
                      "PF05711 : TylF", "SSF82199 : 0040998", "SSF52821 : 0049169", 
                      "SSF88633 : 0049656", "SSF50044 : 0038033", "PR00355 : ADRENODOXIN", 
                      "PF08606 : Prp19", "SSF47699 : 0038793", "SSF56529 : 0038911", 
                      "SSF50405 : 0046324", "SSF48163 : 0038153", "SSF89069 : 0041989", 
                      "SSF55961 : 0052007", "SSF49785 : 0041041", "SSF46785 : 0053153", 
                      "SSF46785 : 0035582", "SSF68906 : 0039508", "SSF47616 : 0038244", 
                      "PF06415 : iPGM_N", "SSF54001 : 0052887", "SSF47454 : 0039848", 
                      "SSF50249 : 0049071", "SSF69340 : 0040206", "SSF48013 : 0037270", 
                      "SSF54292 : 0052035", "SSF53671 : 0042299", "SSF57535 : 0042991", 
                      "PS50041 : C_TYPE_LECTIN_2", "SSF51735 : 0040449", "PIRSF003575 :", 
                      "SSF46785 : 0045043", "PF07016 : CRAM_rpt", "PF08127 : Propeptide_C1", 
                      "PF00328 : Acid_phosphat_A", "SSF46785 : 0041150", "SSF53383 : 0044083", 
                      "SSF56553 : 0038896", "SSF46785 : 0040891", "SSF46689 : 0037098", 
                      "SSF46458 : 0035292", "SSF52518 : 0042761", "PD011473 :", "SSF88633 : 0035267", 
                      "SSF48726 : 0046048", "PF01661 : Macro", "SSF55405 : 0044460", 
                      "SSF56574 : 0039986", "SSF48464 : 0039767", "SSF56436 : 0037303", 
                      "SSF51366 : 0052356", "SSF54373 : 0037711", "PD000739 :", "PF02353 : CMAS", 
                      "SSF53187 : 0044744", "PD010355 :", "SSF51445 : 0047099", "PF04051 : TRAPP", 
                      "SSF52255 : 0042713", "SSF53850 : 0035088", "SSF52799 : 0043336", 
                      "TIGR01460 : HAD-SF-IIA", "SSF48576 : 0037280", "SSF64167 : 0039433", 
                      "SSF63451 : 0047150", "PF05046 : Img2", "SSF57440 : 0042264", 
                      "SSF56112 : 0040727", "SSF88633 : 0034902", "SSF51735 : 0043276", 
                      "SSF63562 : 0038899", "PF05890 : Ebp2", "SSF47050 : 0042949", 
                      "SSF53474 : 0035948", "SSF88633 : 0041956", "SSF55550 : 0035613", 
                      "SSF49785 : 0038309", "SSF50044 : 0041334", "SSF55961 : 0047345", 
                      "SSF50729 : 0047292", "SSF53474 : 0050206", "SSF52833 : 0045476", 
                      "SSF51445 : 0047542", "PR00097 : ANTSNTHASEII", "SSF56059 : 0034971", 
                      "PIRSF028739 :", "SSF57701 : 0045125", "PF06463 : Mob_synth_C", 
                      "TIGR00045 : TIGR00045", "SSF51366 : 0038374", "PF02879 : PGM_PMM_II", 
                      "PF04326 : AAA_4", "SSF55945 : 0035063", "SSF48726 : 0036146", 
                      "SSF48726 : 0046950", "SSF52113 : 0040339", "SSF52507 : 0042145", 
                      "SSF48403 : 0035240", "PF02181 : FH2", "PF04840 : Vps16_C", "SSF56796 : 0041672", 
                      "SSF54111 : 0037041", "PD018182 :", "SSF54747 : 0041008", "SSF50729 : 0052196", 
                      "SSF52540 : 0052680", "SSF51430 : 0050262", "PF01758 : SBF", 
                      "SSF49503 : 0045236", "SSF51230 : 0047763", "SSF52743 : 0040900", 
                      "SSF56719 : 0034983", "SSF51011 : 0038622", "SSF53067 : 0039964", 
                      "SSF57027 : 0046175", "PD000158 :", "PD316494 :", "SSF52440 : 0038250", 
                      "SSF53613 : 0040323", "SSF55347 : 0036439", "PR00031 : HTHREPRESSR", 
                      "PR00886 : HIGHMOBLTY12", "SSF50621 : 0040167", "SSF52972 : 0049765", 
                      "PF02259 : FAT", "SSF57667 : 0040545", "SSF51735 : 0035316", 
                      "SSF55811 : 0051875", "SSF47616 : 0041395", "SSF51735 : 0050955", 
                      "SSF56281 : 0039825", "SSF51430 : 0042624", "SSF51984 : 0042135", 
                      "SSF49562 : 0036565", "SSF48726 : 0035668", "SSF56436 : 0035777", 
                      "SSF47938 : 0036629", "SSF54862 : 0052779", "SSF55729 : 0053292", 
                      "SSF52540 : 0051025", "SSF47769 : 0052400", "SSF57196 : 0044080", 
                      "PR01397 : DHBDHDRGNASE", "SSF48317 : 0044476", "SSF51735 : 0050938", 
                      "PF05216 : UNC-50", "SSF109885 : 0049819", "SSF102645 : 0042209", 
                      "SSF47113 : 0037139", "SSF57903 : 0041002", "SSF51735 : 0040235", 
                      "SSF63411 : 0045927", "SSF48179 : 0041099", "PF01198 : Ribosomal_L31e", 
                      "SSF46984 : 0037516", "SSF49344 : 0046277", "SSF54373 : 0049991", 
                      "PF05698 : Trigger_C", "SSF57095 : 0045871", "PF05179 : CDC73", 
                      "SSF53448 : 0044779", "SSF49899 : 0049971", "SSF51351 : 0044079", 
                      "PF04031 : Las1", "PF09717 : CPW_WPC", "SSF53383 : 0035739", 
                      "SSF55676 : 0042412", "SSF82708 : 0048219", "SSF81296 : 0036868", 
                      "SSF51735 : 0045404", "SSF74924 : 0050557", "SSF57302 : 0046116", 
                      "SSF54060 : 0037998", "PF03164 : DUF254", "PF02789 : Peptidase_M17_N", 
                      "SSF53850 : 0035309", "SSF47699 : 0044059", "SSF52518 : 0052104", 
                      "SSF55729 : 0035394", "SSF50249 : 0045777", "SSF54495 : 0051297", 
                      "SSF53927 : 0044829", "SSF47473 : 0036149", "SSF56235 : 0039166", 
                      "PR00385 : P450", "SSF50923 : 0048745", "PF02375 : JmjN", "SSF52080 : 0037540", 
                      "SSF54452 : 0043534", "SSF101288 : 0044731", "PF00651 : BTB", 
                      "SSF82282 : 0044453", "SSF51905 : 0037712", "SSF55021 : 0042630", 
                      "SSF52540 : 0045788", "SSF46934 : 0050158", "SSF49503 : 0042257", 
                      "PF02330 : MAM33", "SSF57501 : 0035633", "PF02566 : OsmC", "SSF48726 : 0043443", 
                      "SSF47175 : 0047546", "SSF48445 : 0048967", "SSF52283 : 0041130", 
                      "SSF49503 : 0047082", "SSF51735 : 0038057", "SSF54211 : 0051752", 
                      "SSF50494 : 0037077", "SSF50494 : 0041537", "SSF48168 : 0049204", 
                      "PF01990 : ATP-synt_F", "SSF54593 : 0037460", "TIGR02340 : chap_CCT_alpha", 
                      "SSF50447 : 0049110", "SSF54292 : 0038906", "TIGR01892 : AcOrn-deacetyl", 
                      "PF02373 : JmjC", "SSF47769 : 0049156", "SSF53383 : 0036132", 
                      "SSF88633 : 0049167", "SSF53335 : 0040196", "SSF46689 : 0046702", 
                      "PF00482 : GSPII_F", "SSF88688 : 0044322", "SSF46458 : 0046853", 
                      "SSF53098 : 0046055", "SSF47576 : 0048700", "SSF57774 : 0051783", 
                      "SSF55307 : 0048559", "SSF75217 : 0044758", "SSF49313 : 0040377", 
                      "SSF50729 : 0048704", "SSF51445 : 0049908", "SSF56784 : 0050723", 
                      "PF01813 : ATP-synt_D", "SSF53850 : 0040298", "PF03656 : Pam16", 
                      "SSF54277 : 0052303", "SSF53955 : 0046990", "PS51269 : COMM", 
                      "PF03151 : TPT", "TIGR01264 : tyr_amTase_E", "PS50126 : S1", 
                      "SSF53927 : 0042364", "SSF52743 : 0053283", "SSF50692 : 0035236", 
                      "SSF55550 : 0043268", "SSF47616 : 0043129", "SSF51366 : 0051442", 
                      "PR00625 : DNAJPROTEIN", "SSF54197 : 0051072", "SSF52141 : 0049909", 
                      "SSF56601 : 0036668", "SSF90112 : 0041812", "SSF53335 : 0046838", 
                      "SSF51045 : 0038884", "SSF48264 : 0036859", "SSF51735 : 0041504", 
                      "SSF56399 : 0045059", "SSF54001 : 0036137", "SSF53474 : 0046639", 
                      "PF04463 : DUF523", "SSF50156 : 0050553", "PF08328 : ASL_C", 
                      "PF01592 : NifU_N", "SSF52833 : 0053106", "SSF50203 : 0042436", 
                      "SSF53901 : 0041154", "SSF101288 : 0051219", "PD042290 :", "PF01084 : Ribosomal_S18", 
                      "SSF50985 : 0034818", "SSF50475 : 0053098", "SSF55486 : 0049785", 
                      "SSF52402 : 0039538", "SSF55347 : 0039896", "PD001610 :", "PF05746 : tRNA-synt_1d_C", 
                      "SSF48034 : 0045228", "PF07743 : HSCB_C", "SSF53335 : 0047862", 
                      "PD133308 :", "PF06807 : Clp1", "SSF81296 : 0044111", "TIGR03346 : chaperone_ClpB", 
                      "SSF54001 : 0050793", "PF04136 : Sec34", "SSF53633 : 0035386", 
                      "SSF47240 : 0040908", "SSF54980 : 0048719", "SSF55234 : 0036636", 
                      "SSF51011 : 0040295", "PF08326 : ACC_central", "SSF54686 : 0047597", 
                      "SSF46934 : 0050599", "PR00685 : TIFACTORIIB", "PF08206 : OB_RNB", 
                      "SSF81296 : 0040539", "SSF54593 : 0049800", "SSF52540 : 0049933", 
                      "SSF53850 : 0050299", "SSF89837 : 0048171", "SSF57059 : 0045774", 
                      "SSF51366 : 0040280", "SSF49348 : 0042533", "SSF57868 : 0036407", 
                      "SSF53300 : 0042702", "SSF55666 : 0044292", "SSF48081 : 0036809", 
                      "SSF49870 : 0042258", "SSF47576 : 0038432", "SSF49785 : 0046425", 
                      "TIGR00071 : hisT_truA", "SSF46785 : 0040681", "PD184728 :", 
                      "PR01839 : RAD23PROTEIN", "SSF54427 : 0042609", "SSF55718 : 0042531", 
                      "SSF51445 : 0037108", "SSF57667 : 0050631", "SSF46785 : 0043214", 
                      "SSF53901 : 0049676", "SSF54975 : 0047079", "SSF51445 : 0046186", 
                      "PF03801 : Ndc80_HEC", "SSF47364 : 0041903", "SSF50494 : 0038512", 
                      "SSF47986 : 0045580", "SSF63825 : 0041506", "SSF54791 : 0050814", 
                      "PF02581 : TMP-TENI", "SSF54862 : 0047149", "SSF50249 : 0042018", 
                      "PF09532 : DFDF", "SSF48726 : 0037655", "PD001961 :", "SSF53613 : 0046030", 
                      "SSF56601 : 0050287", "PIRSF001365 :", "SSF69500 : 0039597", 
                      "PR00063 : RIBOSOMALL27", "SSF81301 : 0039654", "SSF55008 : 0048906", 
                      "SSF52402 : 0052363", "SSF57716 : 0050810", "SSF81301 : 0039639", 
                      "SSF52949 : 0038610", "SSF52540 : 0037688", "PF02536 : mTERF", 
                      "SSF50814 : 0051412", "SSF57903 : 0048189", "SSF55418 : 0051640", 
                      "PF06487 : SAP18", "SSF51045 : 0052454", "PF01266 : DAO", "PS50089 : ZF_RING_2", 
                      "PR00740 : GLHYDRLASE27", "SSF51338 : 0053352", "SSF56672 : 0042798", 
                      "SSF64484 : 0039235", "SSF53681 : 0039522", "PF08438 : MMR_HSR1_C", 
                      "PS50820 : LCCL", "SSF56601 : 0035789", "SSF47473 : 0044062", 
                      "SSF50104 : 0046768", "SSF52309 : 0049517", "SSF48452 : 0042246", 
                      "SSF56371 : 0036290", "PF01967 : MoaC", "SSF88723 : 0035546", 
                      "SSF51445 : 0050071", "SSF49265 : 0050785", "PS51125 : NHL", 
                      "SSF53474 : 0040583", "SSF50729 : 0051547", "PIRSF006540 :", 
                      "SSF56281 : 0045733", "SSF56436 : 0035828", "SSF48726 : 0051168", 
                      "SSF57059 : 0038843", "SSF56235 : 0045038", "SSF51395 : 0050201", 
                      "TIGR01756 : LDH_protist", "SSF49503 : 0046622", "SSF55753 : 0039398", 
                      "SSF56601 : 0035830", "SSF56821 : 0039702", "PF01555 : N6_N4_Mtase", 
                      "SSF50692 : 0044985", "SSF49503 : 0040322", "SSF52425 : 0039139", 
                      "PF00814 : Peptidase_M22", "SSF56568 : 0042776", "SSF52309 : 0037445", 
                      "PF05721 : PhyH", "TIGR02245 : HAD_IIID1", "SSF50729 : 0036373", 
                      "PR01868 : ABCEFAMILY", "SSF55035 : 0046381", "SSF52777 : 0041458", 
                      "TIGR00041 : DTMP_kinase", "SSF48726 : 0052642", "PF03009 : GDPD", 
                      "SSF46689 : 0046399", "SSF53671 : 0048834", "SSF54791 : 0044118", 
                      "SSF46785 : 0035347", "SSF53271 : 0037758", "SSF57716 : 0043073", 
                      "SSF57783 : 0036225", "PF06172 : Cupin_5", "SSF51735 : 0043507", 
                      "SSF53335 : 0050154", "PF04252 : RNA_Me_trans", "SSF47473 : 0039467", 
                      "SSF50044 : 0052588", "SSF54913 : 0048313", "SSF46565 : 0039212", 
                      "PF02359 : CDC48_N", "SSF53067 : 0048238", "PF00150 : Cellulase", 
                      "SSF48726 : 0041436", "SSF49899 : 0045223", "SSF57095 : 0047293", 
                      "SSF52954 : 0037214", "SSF53067 : 0039479", "SSF52540 : 0036985", 
                      "SSF64076 : 0052353", "SSF49562 : 0036281", "SSF48350 : 0044971", 
                      "SSF57095 : 0043552", "SSF81296 : 0049996", "SSF46689 : 0049336", 
                      "SSF102712 : 0041863", "SSF90229 : 0043225", "SSF54358 : 0048754", 
                      "PF00035 : dsrm", "SSF57667 : 0052293", "SSF49503 : 0047074", 
                      "SSF89124 : 0041552", "PF08700 : Vps51", "PF09070 : PFU", "SSF47616 : 0047221", 
                      "SSF54826 : 0051293", "PF06565 : DUF1126", "SSF46785 : 0040682", 
                      "SSF53474 : 0034990", "SSF54631 : 0035336", "SSF52972 : 0044186", 
                      "SSF48726 : 0036135", "PF04900 : DUF652", "SSF49562 : 0048916", 
                      "SSF46785 : 0049335", "PF02797 : Chal_sti_synt_C", "SSF52540 : 0046860", 
                      "SSF55486 : 0036188", "SSF52540 : 0048111", "SSF55846 : 0052586", 
                      "SSF57829 : 0049062", "SSF50978 : 0041353", "SSF51735 : 0050914", 
                      "SSF52540 : 0046258", "SSF49899 : 0053316", "PD000817 :", "SSF46626 : 0035856", 
                      "SSF75304 : 0041075", "PF00319 : SRF-TF", "SSF47954 : 0038414", 
                      "PF00338 : Ribosomal_S10", "SSF55486 : 0048333", "SSF54236 : 0050757", 
                      "SSF52172 : 0051860", "PF00561 : Abhydrolase_1", "SSF51998 : 0047139", 
                      "PF04908 : SH3BGR", "PF07817 : GLE1", "SSF51998 : 0038460", "PF00056 : Ldh_1_N", 
                      "PF05148 : Methyltransf_8", "SSF46565 : 0045028", "SSF56235 : 0036734", 
                      "SSF49348 : 0038335", "SSF52218 : 0044895", "PS50846 : HMA_2", 
                      "SSF57059 : 0036478", "SSF57262 : 0046570", "SSF110857 : 0050035", 
                      "SSF46785 : 0049944", "PF08636 : Pkr1", "PD686197 :", "PF00334 : NDK", 
                      "PS50180 : GAE", "SSF56519 : 0039858", "SSF46977 : 0035988", 
                      "PS50914 : BON", "SSF56436 : 0040070", "TIGR00636 : PduO_Nterm", 
                      "TIGR00871 : zwf", "TIGR00873 : gnd", "SSF53901 : 0044095", "SSF53271 : 0038588", 
                      "PF08325 : WLM", "PF02598 : DUF171", "SSF54358 : 0040931", "PF03194 : LUC7", 
                      "SSF47807 : 0048139", "SSF57667 : 0052292", "SSF55073 : 0037822", 
                      "SSF50129 : 0049685", "PR00153 : CSAPPISMRASE", "SSF51905 : 0047271", 
                      "PF07787 : DUF1625", "SSF47413 : 0052277", "SSF101353 : 0049182", 
                      "SSF55347 : 0038088", "SSF48726 : 0040926", "TIGR00861 : MIP", 
                      "SSF81483 : 0037268", "PF00155 : Aminotran_1_2", "SSF47459 : 0044409", 
                      "PF02811 : PHP", "SSF51735 : 0038022", "SSF55347 : 0041771", 
                      "PIRSF005902 :", "SSF47323 : 0039069", "SSF56645 : 0049932", 
                      "PR00210 : GLUTENIN", "SSF53271 : 0048678", "PF01192 : RNA_pol_Rpb6", 
                      "PF01920 : Prefoldin_2", "PF09754 : HCCA3", "PF07690 : MFS_1", 
                      "PF02517 : Abi", "SSF57535 : 0053251", "SSF54999 : 0037620", 
                      "SSF54966 : 0051334", "SSF57196 : 0038803", "SSF49265 : 0050843", 
                      "SSF100950 : 0043544", "SSF55326 : 0044820", "SSF51658 : 0046032", 
                      "SSF49899 : 0052538", "SSF56176 : 0049208", "SSF54826 : 0039689", 
                      "SSF47741 : 0037698", "SSF47266 : 0040780", "PF09410 : DUF2006", 
                      "PF04037 : DUF382", "SSF57756 : 0036042", "SSF47807 : 0049264", 
                      "SSF52540 : 0036813", "PIRSF016089 :", "SSF47781 : 0052273", 
                      "SSF55008 : 0047700", "SSF63501 : 0039057", "SSF57667 : 0043689", 
                      "PF09725 : Fra10Ac1", "SSF52425 : 0048654", "SSF51735 : 0039271", 
                      "SSF55681 : 0050375", "SSF51735 : 0035945", "SSF54373 : 0035331", 
                      "SSF51621 : 0041703", "PF04176 : TIP41", "PF08713 : DNA_alkylation", 
                      "SSF49723 : 0041262", "SSF88798 : 0052108", "PF03248 : Rer1", 
                      "PF01466 : Skp1", "SSF51735 : 0046291", "PF03484 : B5", "SSF53474 : 0040405", 
                      "SSF57095 : 0039621", "SSF49899 : 0051315", "PD141665 :", "SSF46689 : 0039940", 
                      "SSF53335 : 0049442", "SSF49899 : 0048891", "TIGR00057 : TIGR00057", 
                      "SSF54928 : 0052082", "SSF57903 : 0050472", "PD000945 :", "SSF53067 : 0035528", 
                      "SSF49764 : 0050494", "SSF54826 : 0041818", "SSF48726 : 0051411", 
                      "SSF53901 : 0036930", "PIRSF000382 :", "SSF53067 : 0050049", 
                      "SSF88633 : 0035268", "PD003041 :", "PF06294 : DUF1042", "SSF88633 : 0038483", 
                      "SSF52540 : 0050792", "PF00355 : Rieske", "PR00742 : GLHYDRLASE35", 
                      "SSF46966 : 0038528", "SSF51182 : 0051311", "SSF48726 : 0041299", 
                      "SSF53067 : 0035800", "SSF56219 : 0044912", "SSF57716 : 0040361", 
                      "PD032764 :", "TIGR03506 : FlgEFG_subfam", "SSF49842 : 0042352", 
                      "SSF57059 : 0046885", "SSF51316 : 0038443", "SSF47807 : 0043406", 
                      "SSF51366 : 0038072", "PD022798 :", "SSF56507 : 0041070", "PD032367 :", 
                      "SSF46689 : 0037517", "SSF49452 : 0036196", "SSF46938 : 0041712", 
                      "SSF55347 : 0051148", "SSF51011 : 0036197", "SSF81296 : 0036167", 
                      "SSF54913 : 0052354", "SSF51905 : 0048356", "SSF48726 : 0052409", 
                      "SSF69572 : 0039789", "SSF51569 : 0044886", "SSF57667 : 0045127", 
                      "PF07133 : Merozoite_SPAM", "SSF53098 : 0053015", "SSF54695 : 0041467", 
                      "TIGR00457 : asnS", "PF04059 : RRM_2", "PIRSF006468 :", "SSF50370 : 0041977", 
                      "SSF56770 : 0038382", "SSF51569 : 0038289", "PF07539 : DRIM", 
                      "SSF57262 : 0035754", "SSF57196 : 0037756", "SSF53474 : 0035373", 
                      "SSF51366 : 0052714", "SSF52833 : 0045690", "SSF53659 : 0045683", 
                      "TIGR01959 : nuoF_fam", "SSF103378 : 0043815", "SSF54928 : 0047197", 
                      "SSF56235 : 0039162", "SSF47473 : 0039987", "SSF54495 : 0045144", 
                      "SSF57603 : 0042760", "SSF53187 : 0046134", "SSF51604 : 0047786", 
                      "SSF50044 : 0042039", "PF08506 : Cse1", "PS50222 : EF_HAND_2", 
                      "SSF53795 : 0039463", "SSF56601 : 0047733", "SSF49899 : 0035245", 
                      "SSF81296 : 0038935", "PR00098 : CPSASE", "SSF54975 : 0050347", 
                      "PF04109 : APG9", "SSF48726 : 0048384", "SSF51126 : 0043397", 
                      "SSF54171 : 0038039", "SSF50249 : 0043008", "SSF50475 : 0049155", 
                      "SSF46626 : 0041461", "SSF52540 : 0041830", "SSF56112 : 0051877", 
                      "SSF47473 : 0053255", "SSF47986 : 0045502", "PS50404 : GST_NTER", 
                      "TIGR00978 : asd_EA", "SSF54452 : 0040930", "PF01344 : Kelch_1", 
                      "SSF52490 : 0041832", "SSF81296 : 0048052", "SSF46785 : 0048703", 
                      "SSF50891 : 0050106", "SSF51445 : 0035310", "SSF69786 : 0039723", 
                      "SSF53098 : 0046649", "SSF51351 : 0047237", "PF02296 : Alpha_adaptin_C", 
                      "SSF48445 : 0042811", "TIGR01416 : Rieske_proteo", "SSF48150 : 0040572", 
                      "SSF54919 : 0049319", "SSF57190 : 0047391", "SSF81631 : 0037393", 
                      "SSF46575 : 0036602", "SSF55331 : 0046964", "SSF50022 : 0043257", 
                      "SSF55846 : 0051259", "SSF52467 : 0036754", "PF05492 : NAF1", 
                      "SSF50891 : 0039184", "SSF53448 : 0039044", "SSF46689 : 0047970", 
                      "SSF51735 : 0042914", "SSF53137 : 0046769", "SSF50911 : 0042582", 
                      "PF00262 : Calreticulin", "PF09340 : NuA4", "SSF54292 : 0039204", 
                      "PF03171 : 2OG-FeII_Oxy", "SSF52540 : 0048957", "SSF50156 : 0049878", 
                      "SSF101744 : 0042245", "SSF55008 : 0048239", "SSF51011 : 0036005", 
                      "SSF100966 : 0039954", "PF04438 : zf-HIT", "PR00049 : WILMSTUMOUR", 
                      "SSF53098 : 0043260", "PS51084 : HIT_2", "PIRSF037188 :", "PF01896 : DNA_primase_S", 
                      "SSF53474 : 0043940", "PS50075 : ACP_DOMAIN", "PF01106 : NifU", 
                      "PF01255 : Prenyltransf", "PF00476 : DNA_pol_A", "SSF53613 : 0044661", 
                      "PF09066 : B2-adapt-app_C", "SSF54768 : 0042985", "SSF54236 : 0050579", 
                      "PF05970 : DUF889", "PF02271 : UCR_14kD", "SSF53383 : 0047956", 
                      "SSF51126 : 0035630", "SSF51735 : 0053356", "SSF48726 : 0052869", 
                      "SSF52317 : 0039782", "SSF48097 : 0036467", "SSF52833 : 0048388", 
                      "SSF50891 : 0039026", "SSF81321 : 0038433", "SSF81891 : 0042030", 
                      "PD001462 :", "SSF47699 : 0041156", "SSF51556 : 0040032", "PF06513 : DUF1103", 
                      "PF00887 : ACBP", "SSF49503 : 0048089", "SSF55811 : 0052710", 
                      "SSF52518 : 0045857", "SSF57667 : 0044541", "SSF49785 : 0035554", 
                      "PF00374 : NiFeSe_Hases", "PF01680 : SOR_SNZ", "SSF52540 : 0046441", 
                      "SSF55424 : 0041941", "SSF53955 : 0040641", "SSF50447 : 0050420", 
                      "PF04133 : Vps55", "SSF46626 : 0047110", "SSF52833 : 0043097", 
                      "PR00370 : FMOXYGENASE", "SSF53335 : 0043270", "SSF50203 : 0044588", 
                      "PF01202 : SKI", "SSF50203 : 0040783", "TIGR01091 : upp", "SSF51011 : 0049621", 
                      "SSF103409 : 0042652", "SSF47857 : 0037127", "PIRSF000392 :", 
                      "SSF51658 : 0047312", "SSF47781 : 0039263", "SSF90112 : 0041810", 
                      "SSF53927 : 0052747", "SSF47616 : 0042394", "SSF57256 : 0045438", 
                      "SSF56655 : 0037748", "SSF56821 : 0040965", "SSF51445 : 0035738", 
                      "SSF47082 : 0045536", "SSF51604 : 0039690", "SSF53187 : 0039797", 
                      "SSF52540 : 0036386", "SSF55681 : 0041469", "SSF57716 : 0045290", 
                      "SSF52540 : 0051332", "SSF55729 : 0050223", "SSF81406 : 0041782", 
                      "SSF81624 : 0041472", "SSF54928 : 0050514", "SSF52540 : 0051472", 
                      "SSF81301 : 0037463", "PS51387 : FAD_PCMH", "SSF110942 : 0043579", 
                      "PR00853 : XPGRADSUPER", "SSF50203 : 0042438", "SSF54928 : 0050834", 
                      "SSF46689 : 0045264", "PF03815 : LCCL", "SSF57283 : 0040110", 
                      "SSF52833 : 0039431", "TIGR01032 : rplT_bact", "SSF49599 : 0052253", 
                      "SSF54292 : 0035421", "SSF48695 : 0044945", "SSF54197 : 0037089", 
                      "SSF81296 : 0041280", "SSF49899 : 0048870", "SSF101967 : 0042205", 
                      "PD001263 :", "SSF54495 : 0045252", "SSF48403 : 0047720", "SSF51621 : 0048843", 
                      "PF08755 : YccV-like", "SSF47923 : 0037637", "SSF50978 : 0047077", 
                      "SSF52540 : 0036719", "SSF49354 : 0048065", "SSF48403 : 0035616", 
                      "SSF53383 : 0050768", "SSF48613 : 0044286", "SSF50022 : 0036982", 
                      "SSF53067 : 0049808", "SSF53659 : 0048724", "SSF54814 : 0047188", 
                      "SSF55347 : 0052327", "PIRSF001335 :", "SSF88633 : 0045604", 
                      "PF01585 : G-patch", "SSF51905 : 0046128", "SSF53659 : 0043135", 
                      "SSF52821 : 0049841", "SSF52440 : 0050232", "SSF81296 : 0048116", 
                      "PD007327 :", "PF00108 : Thiolase_N", "SSF53850 : 0039658", "SSF55174 : 0035794", 
                      "SSF51445 : 0050774", "SSF46689 : 0051514", "SSF51735 : 0039780", 
                      "SSF57184 : 0041269", "SSF56024 : 0050933", "PF10338 : DUF2423", 
                      "SSF51905 : 0044705", "SSF81631 : 0043167", "SSF48150 : 0050956", 
                      "SSF52467 : 0042100", "SSF47240 : 0048264", "SSF54076 : 0040290", 
                      "SSF54427 : 0036984", "SSF49503 : 0041162", "SSF52540 : 0051553", 
                      "SSF55804 : 0038790", "SSF51735 : 0052368", "SSF54534 : 0040252", 
                      "SSF47413 : 0042440", "SSF56436 : 0047544", "SSF51735 : 0044794", 
                      "SSF48726 : 0046148", "SSF55469 : 0037401", "SSF46966 : 0043478", 
                      "SSF81923 : 0047755", "SSF46785 : 0047353", "SSF53474 : 0042896", 
                      "SSF48726 : 0052689", "SSF56091 : 0036035", "SSF54966 : 0053362", 
                      "SSF54585 : 0044985", "SSF82282 : 0040652", "SSF51735 : 0045239", 
                      "SSF52440 : 0034970", "SSF51294 : 0038214", "SSF53681 : 0035380", 
                      "SSF52833 : 0040722", "SSF69349 : 0038452", "SSF48726 : 0046047", 
                      "SSF54334 : 0037159", "SSF54593 : 0049036", "SSF53383 : 0040759", 
                      "SSF101546 : 0049220", "PF06202 : GDE_C", "SSF51430 : 0037240", 
                      "SSF54076 : 0035307", "PD009131 :", "SSF69103 : 0039970", "SSF53098 : 0041495", 
                      "SSF81343 : 0052036", "SSF103575 : 0049460", "PIRSF037671 :", 
                      "SSF51735 : 0050383", "PF02771 : Acyl-CoA_dh_N", "PF05182 : Fip1", 
                      "PF08498 : Sterol_MT_C", "SSF101288 : 0051220", "SSF51011 : 0044243", 
                      "SSF52821 : 0046064", "SSF55144 : 0041220", "SSF64484 : 0038898", 
                      "SSF53927 : 0041046", "SSF46689 : 0044342", "PF08211 : dCMP_cyt_deam_2", 
                      "PF07699 : GCC2_GCC3", "PF01928 : CYTH", "PR00008 : DAGPEDOMAIN", 
                      "SSF55608 : 0042195", "SSF48695 : 0046850", "SSF47413 : 0036635", 
                      "SSF49319 : 0048401", "SSF101307 : 0043223", "SSF48208 : 0047967", 
                      "SSF63748 : 0040933", "SSF48464 : 0043806", "SSF55008 : 0035910", 
                      "SSF53800 : 0047952", "SSF88645 : 0048230", "SSF51735 : 0050721", 
                      "SSF57095 : 0036069", "SSF50814 : 0035749", "SSF101498 : 0043330", 
                      "SSF101215 : 0044943", "SSF50156 : 0050486", "SSF52540 : 0052795", 
                      "SSF48726 : 0035169", "SSF46785 : 0046825", "SSF54334 : 0037172", 
                      "SSF53706 : 0045382", "SSF46626 : 0036199", "PD000742 :", "SSF51011 : 0035979", 
                      "SSF48726 : 0050900", "SSF56601 : 0053342", "SSF46997 : 0035472", 
                      "TIGR02307 : RNA_lig_RNL2", "SSF54593 : 0039475", "PF04403 : PqiA", 
                      "SSF55486 : 0038837", "PS50022 : FA58C_3", "PF00907 : T-box", 
                      "SSF55144 : 0052753", "SSF49503 : 0040026", "SSF54695 : 0043098", 
                      "SSF54719 : 0039719", "PF02464 : CinA", "SSF55347 : 0036580", 
                      "TIGR03636 : L23_arch", "SSF50729 : 0050535", "SSF82109 : 0049575", 
                      "SSF51445 : 0037582", "SSF88633 : 0041618", "SSF50692 : 0049634", 
                      "SSF54593 : 0049133", "SSF81296 : 0048504", "PF01544 : CorA", 
                      "SSF52540 : 0049506", "SSF51905 : 0038075", "SSF53901 : 0042745", 
                      "SSF55681 : 0035444", "SSF55637 : 0042693", "SSF49785 : 0044991", 
                      "SSF50331 : 0037900", "SSF50104 : 0039292", "SSF55681 : 0037947", 
                      "SSF57302 : 0044150", "SSF52972 : 0049799", "SSF55961 : 0050953", 
                      "PR00782 : LSHMANOLYSIN", "SSF52402 : 0049476", "SSF57302 : 0041635", 
                      "SSF47781 : 0040063", "SSF55550 : 0043340", "SSF50022 : 0049176", 
                      "SSF54980 : 0049572", "SSF54001 : 0043989", "SSF53613 : 0036419", 
                      "PF00882 : Zn_dep_PLPC", "SSF55021 : 0051653", "SSF56645 : 0036988", 
                      "SSF53807 : 0048954", "SSF48726 : 0039147", "SSF53807 : 0048163", 
                      "SSF56235 : 0042399", "SSF55729 : 0043128", "SSF51717 : 0046719", 
                      "SSF53182 : 0035204", "PF09333 : ATG_C", "SSF46626 : 0038390", 
                      "SSF53067 : 0036765", "PS50015 : SAP_B", "PF04758 : Ribosomal_S30", 
                      "PF07649 : C1_3", "PF00032 : Cytochrom_B_C", "PF03467 : Smg4_UPF3", 
                      "PF00211 : Guanylate_cyc", "SSF48695 : 0039660", "SSF53474 : 0048460", 
                      "PF00854 : PTR2", "SSF53223 : 0037204", "SSF47095 : 0039363", 
                      "SSF46785 : 0047445", "SSF51735 : 0047443", "SSF47616 : 0035250", 
                      "SSF50814 : 0051673", "SSF50998 : 0040632", "SSF56784 : 0052884", 
                      "PIRSF001359 :", "TIGR00501 : met_pdase_II", "SSF51011 : 0048723", 
                      "SSF48264 : 0036682", "PF01951 : DUF101", "PIRSF005225 :", "SSF53474 : 0047600", 
                      "SSF51161 : 0053094", "PF04922 : DIE2_ALG10", "TIGR02464 : ribofla_fusion", 
                      "SSF57059 : 0040569", "SSF54826 : 0049602", "SSF49265 : 0046131", 
                      "SSF49265 : 0050484", "PIRSF000114 :", "SSF47473 : 0038096", 
                      "PF00250 : Fork_head", "SSF57059 : 0049215", "SSF56542 : 0038756", 
                      "TIGR00500 : met_pdase_I", "SSF53335 : 0037982", "PS51037 : YEATS", 
                      "SSF52317 : 0047286", "SSF48726 : 0039133", "SSF54236 : 0052254", 
                      "SSF49899 : 0052728", "SSF50156 : 0049521", "TIGR03026 : NDP-sugDHase", 
                      "SSF88697 : 0043893", "PF02363 : C_tripleX", "SSF54928 : 0040182", 
                      "SSF57095 : 0041000", "SSF55811 : 0044789", "SSF57716 : 0039332", 
                      "SSF47661 : 0037604", "SSF103025 : 0044877", "SSF49899 : 0036975", 
                      "SSF52402 : 0047848", "PF05282 : AAR2", "SSF75217 : 0042210", 
                      "SSF52374 : 0050866", "SSF51649 : 0049482", "PF00408 : PGM_PMM_IV", 
                      "SSF53383 : 0049486", "SSF55785 : 0042199", "SSF53182 : 0034844", 
                      "SSF53271 : 0048919", "SSF53271 : 0052114", "SSF81296 : 0052458", 
                      "SSF47655 : 0044532", "SSF54826 : 0045368", "SSF47781 : 0052274", 
                      "PF06701 : MIB_HERC2", "PIRSF037956 :", "SSF54373 : 0035355", 
                      "SSF57095 : 0046183", "SSF57825 : 0036216", "PR01072 : PRESENILIN", 
                      "PF00719 : Pyrophosphatase", "SSF50814 : 0037502", "SSF51556 : 0041368", 
                      "SSF52540 : 0049611", "SSF51011 : 0046235", "SSF54913 : 0041643", 
                      "SSF54373 : 0037442", "SSF68923 : 0053254", "SSF75620 : 0038227", 
                      "PF03860 : DUF326", "SSF50494 : 0043039", "PR00053 : FORKHEAD", 
                      "SSF47220 : 0048976", "SSF57716 : 0035410", "SSF51735 : 0051147", 
                      "SSF47413 : 0035294", "SSF51011 : 0040699", "PF07986 : TBCC", 
                      "SSF51905 : 0039758", "SSF48113 : 0035393", "SSF52402 : 0041405", 
                      "SSF54495 : 0035271", "SSF54236 : 0039275", "SSF57027 : 0052110", 
                      "PF05544 : Pro_racemase", "SSF47807 : 0040884", "SSF56112 : 0048206", 
                      "SSF51445 : 0040700", "SSF53686 : 0042165", "SSF48726 : 0046061", 
                      "SSF47220 : 0038435", "SSF50494 : 0034935", "TIGR00414 : serS", 
                      "TIGR00390 : hslU", "SSF50104 : 0040086", "SSF52540 : 0050351", 
                      "SSF53850 : 0045864", "PIRSF000714 :", "SSF52172 : 0048975", 
                      "PF10251 : PEN-2", "SSF54980 : 0037686", "SSF53098 : 0050411", 
                      "SSF53597 : 0043185", "SSF49503 : 0038326", "SSF56784 : 0051387", 
                      "SSF51726 : 0039427", "SSF46626 : 0036886", "PF03641 : Lysine_decarbox", 
                      "SSF81296 : 0051134", "SSF47819 : 0038183", "SSF81273 : 0040625", 
                      "PR00069 : ALDKETRDTASE", "SSF51569 : 0041582", "SSF57095 : 0044106", 
                      "SSF56601 : 0035997", "SSF49265 : 0051918", "SSF50044 : 0045920", 
                      "PF09202 : Rio2_N", "SSF52507 : 0037949", "SSF48403 : 0036354", 
                      "SSF53383 : 0052302", "SSF48695 : 0038903", "SSF52540 : 0044055", 
                      "SSF51206 : 0050263", "PF05024 : Gpi1", "SSF56436 : 0042096", 
                      "SSF46626 : 0035262", "SSF57048 : 0042599", "SSF56784 : 0041535", 
                      "PF03630 : Fumble", "SSF50129 : 0047235", "SSF56176 : 0043862", 
                      "SSF53850 : 0046117", "PF00711 : Defensin_beta", "SSF53597 : 0047688", 
                      "SSF55729 : 0048674", "SSF81296 : 0047834", "PIRSF000159 :", 
                      "SSF88659 : 0040345", "SSF56300 : 0044503", "PF00904 : Involucrin", 
                      "PF06762 : DUF1222", "SSF51430 : 0045160", "SSF48726 : 0051848", 
                      "SSF55021 : 0052554", "SSF53098 : 0049323", "PR00071 : HMGCOARDTASE", 
                      "PS51381 : B9", "SSF69349 : 0052558", "PF08373 : RAP", "SSF54236 : 0047488", 
                      "SSF54452 : 0036913", "SSF53383 : 0036040", "PIRSF038093 :", 
                      "SSF56601 : 0038744", "SSF57802 : 0046413", "SSF101283 : 0044483", 
                      "SSF101801 : 0041705", "SSF53167 : 0048860", "SSF56047 : 0043454", 
                      "SSF52540 : 0039672", "SSF53187 : 0037690", "SSF55486 : 0039592", 
                      "SSF46934 : 0051335", "SSF51735 : 0035290", "SSF54334 : 0040784", 
                      "SSF54791 : 0047806", "PF01557 : FAA_hydrolase", "SSF50249 : 0035443", 
                      "SSF46929 : 0039265", "SSF53335 : 0050519", "SSF55315 : 0046480", 
                      "PF01226 : Form_Nir_trans", "SSF53850 : 0036319", "SSF57048 : 0036468", 
                      "SSF51735 : 0051955", "SSF50249 : 0049181", "SSF48726 : 0048451", 
                      "SSF88713 : 0052426", "PD000657 :", "SSF48726 : 0035057", "SSF48726 : 0038991", 
                      "TIGR00936 : ahcY", "SSF54980 : 0041172", "SSF49354 : 0047045", 
                      "SSF52172 : 0047799", "SSF54862 : 0038491", "PF08697 : TFP11", 
                      "SSF48113 : 0043417", "SSF53697 : 0050875", "PS50195 : PX", "SSF48150 : 0041380", 
                      "SSF54791 : 0036896", "PS50007 : PIPLC_X_DOMAIN", "SSF48371 : 0038438", 
                      "SSF81296 : 0040426", "SSF52833 : 0048363", "SSF48208 : 0036044", 
                      "SSF52425 : 0047421", "SSF51126 : 0049214", "SSF48600 : 0036905", 
                      "SSF50475 : 0035992", "SSF49899 : 0049553", "SSF81296 : 0047130", 
                      "SSF49503 : 0048336", "SSF51246 : 0036616", "SSF47240 : 0049951", 
                      "SSF53738 : 0045551", "SSF49695 : 0045177", "SSF48264 : 0037346", 
                      "SSF54427 : 0051880", "SSF51735 : 0051440", "SSF46785 : 0048041", 
                      "PF01920 : KE2", "SSF51246 : 0036724", "PF06110 : DUF953", "PF00252 : Ribosomal_L16", 
                      "SSF63380 : 0038921", "SSF74924 : 0052208", "SSF51161 : 0040705", 
                      "SSF52317 : 0048285", "SSF57783 : 0036482", "PF07060 : DUF1530", 
                      "SSF48726 : 0037793", "SSF49842 : 0045469", "PF05051 : COX17", 
                      "TIGR01079 : rplX_bact", "SSF57933 : 0040367", "TIGR02033 : D-hydantoinase", 
                      "SSF51735 : 0047040", "SSF51621 : 0037608", "PR00604 : CYTCHRMECIAB", 
                      "PF02544 : Steroid_dh", "SSF51182 : 0051410", "SSF51246 : 0050406", 
                      "SSF48726 : 0045321", "SSF50729 : 0039917", "PF00226 : DnaJ", 
                      "SSF51735 : 0053172", "SSF54631 : 0048350", "SSF53850 : 0045745", 
                      "SSF53790 : 0050755", "SSF51011 : 0040788", "PF02140 : Gal_Lectin", 
                      "PF00617 : RasGEF", "SSF55347 : 0050939", "SSF56436 : 0044410", 
                      "SSF54495 : 0037866", "SSF81296 : 0042221", "SSF47240 : 0039557", 
                      "SSF57667 : 0045966", "SSF54556 : 0036242", "SSF52540 : 0036325", 
                      "SSF46785 : 0049555", "PS50244 : S5A_REDUCTASE", "SSF55729 : 0044764", 
                      "SSF102405 : 0050465", "SSF47175 : 0045136", "SSF52374 : 0036247", 
                      "SSF50129 : 0045092", "SSF57716 : 0050786", "SSF52096 : 0046300", 
                      "SSF75500 : 0039385", "SSF88633 : 0038484", "SSF48179 : 0049729", 
                      "SSF54814 : 0036740", "SSF50044 : 0049905", "SSF52777 : 0041459", 
                      "SSF52440 : 0049858", "SSF49863 : 0043393", "PS50832 : S1_IF1_TYPE", 
                      "SSF81452 : 0037559", "PF00578 : AhpC-TSA", "PD003210 :", "SSF48726 : 0045335", 
                      "PF01138 : RNase_PH", "SSF47473 : 0039413", "SSF51182 : 0052017", 
                      "SSF46966 : 0043004", "SSF55945 : 0036895", "SSF50692 : 0044362", 
                      "SSF54452 : 0043533", "SSF89837 : 0040962", "SSF50249 : 0036299", 
                      "SSF53335 : 0049915", "SSF51735 : 0039210", "SSF51395 : 0046501", 
                      "SSF56104 : 0040269", "SSF52540 : 0047772", "PF01115 : F_actin_cap_B", 
                      "SSF46785 : 0044207", "SSF81330 : 0041071", "SSF55083 : 0037459", 
                      "SSF55753 : 0044836", "PD000252 :", "PR01183 : RIBORDTASEM1", 
                      "SSF47769 : 0043597", "SSF56672 : 0044001", "SSF56327 : 0045903", 
                      "SSF52047 : 0034878", "SSF57184 : 0039224", "PF04437 : RINT1_TIP1", 
                      "SSF51351 : 0051284", "SSF55331 : 0046380", "PD001149 :", "PF01902 : ATP_bind_4", 
                      "SSF81296 : 0046264", "SSF55729 : 0046177", "SSF52317 : 0047324", 
                      "SSF48726 : 0040903", "SSF55287 : 0038639", "SSF55129 : 0037548", 
                      "SSF50044 : 0047146", "SSF57095 : 0038218", "SSF51971 : 0045795", 
                      "SSF111418 : 0044198", "SSF50494 : 0042134", "SSF51556 : 0051379", 
                      "SSF52096 : 0052629", "SSF48168 : 0042276", "SSF69593 : 0039877", 
                      "PIRSF000185 :", "SSF54358 : 0037495", "SSF52540 : 0036155", 
                      "SSF49265 : 0044397", "SSF54334 : 0045569", "SSF50465 : 0049291", 
                      "SSF52540 : 0040684", "SSF56436 : 0035288", "PIRSF001253 :", 
                      "SSF50156 : 0044638", "SSF53474 : 0049637", "SSF48726 : 0038833", 
                      "SSF48508 : 0040676", "PF01250 : Ribosomal_S6", "SSF81333 : 0035882", 
                      "PR01228 : EGGSHELL", "SSF55298 : 0047528", "SSF53067 : 0046238", 
                      "SSF46458 : 0043695", "SSF51177 : 0040845", "SSF51556 : 0048480", 
                      "SSF57889 : 0043932", "SSF50044 : 0039674", "SSF57716 : 0043072", 
                      "SSF46458 : 0050882", "PD041625 :", "SSF81296 : 0040841", "SSF55961 : 0046549", 
                      "PF00733 : Asn_synthase", "SSF53178 : 0043416", "SSF56300 : 0042801", 
                      "PF00962 : A_deaminase", "SSF53098 : 0049752", "PR00884 : RIBOSOMALHS6", 
                      "SSF56553 : 0035474", "PIRSF013022 :", "SSF48726 : 0035918", 
                      "SSF54160 : 0035277", "SSF54416 : 0041278", "SSF51206 : 0048492", 
                      "SSF49899 : 0037999", "SSF48150 : 0042464", "SSF57667 : 0042220", 
                      "SSF52540 : 0041499", "SSF53067 : 0052626", "SSF52540 : 0052796", 
                      "TIGR00512 : salvage_mtnA", "PF01875 : UPF0103", "TIGR03421 : FeS_CyaY", 
                      "TIGR00329 : gcp", "TIGR00008 : infA", "SSF81296 : 0052396", 
                      "PF10585 : UBA_e1_thiolCys", "SSF88633 : 0037665", "SSF52540 : 0052615", 
                      "SSF47874 : 0036466", "SSF52540 : 0041904", "PF03477 : ATP-cone", 
                      "SSF53335 : 0040085", "PF00501 : AMP-binding", "SSF48317 : 0036249", 
                      "SSF55347 : 0042208", "SSF53681 : 0035381", "SSF46785 : 0042570", 
                      "PF09416 : UPF1_Zn_bind", "SSF48726 : 0035923", "SSF56436 : 0044992", 
                      "SSF50985 : 0039753", "SSF49329 : 0046610", "SSF100950 : 0050636", 
                      "SSF51658 : 0045684", "SSF54593 : 0046159", "PF03208 : PRA1", 
                      "SSF81296 : 0037931", "SSF47473 : 0035893", "SSF52467 : 0039737", 
                      "SSF55048 : 0041455", "SSF48452 : 0040251", "PR00109 : TYRKINASE", 
                      "SSF52402 : 0050128", "TIGR00962 : atpA", "SSF54975 : 0051747", 
                      "SSF56327 : 0053357", "SSF47148 : 0039254", "SSF53927 : 0050283", 
                      "TIGR01515 : branching_enzym", "SSF50129 : 0038378", "SSF47769 : 0050037", 
                      "SSF100920 : 0035654", "SSF47050 : 0044396", "PS51166 : CBM20", 
                      "SSF54897 : 0049360", "SSF52833 : 0050590", "SSF48498 : 0052656", 
                      "SSF51182 : 0047411", "PR01217 : PRICHEXTENSN", "SSF55424 : 0040604", 
                      "SSF51206 : 0041733", "SSF54236 : 0048122", "SSF53850 : 0049318", 
                      "SSF56235 : 0035162", "SSF47240 : 0044868", "SSF51621 : 0040513", 
                      "SSF51971 : 0035117", "SSF69055 : 0043067", "PF01233 : NMT", 
                      "PS50177 : NTF2_DOMAIN", "SSF50129 : 0047104", "SSF56281 : 0051102", 
                      "PS51293 : SANT", "PF02896 : PEP-utilizers_C", "SSF54919 : 0041546", 
                      "SSF81296 : 0044234", "SSF102816 : 0041477", "SSF48726 : 0038796", 
                      "SSF57016 : 0041004", "SSF56327 : 0035478", "SSF50203 : 0045498", 
                      "PR00927 : ADPTRNSLCASE", "SSF57716 : 0038687", "PD000139 :", 
                      "SSF53383 : 0046089", "SSF56436 : 0044447", "PS51348 : LACTALBUMIN_LYSOZYME_2", 
                      "SSF55331 : 0047185", "SSF56235 : 0036865", "SSF50156 : 0040042", 
                      "PF00703 : Glyco_hydro_2", "PF05918 : API5", "SSF53955 : 0034784", 
                      "SSF47769 : 0040293", "SSF46689 : 0048379", "SSF54001 : 0046209", 
                      "PD037296 :", "SSF49758 : 0043036", "TIGR02243 : TIGR02243", 
                      "SSF55785 : 0048579", "SSF53383 : 0050261", "SSF88633 : 0041491", 
                      "TIGR01265 : tyr_nico_aTase", "PF02735 : Ku", "SSF56371 : 0035154", 
                      "PF02826 : 2-Hacid_dh_C", "SSF57783 : 0048749", "SSF51445 : 0044343", 
                      "SSF50193 : 0037536", "SSF54427 : 0049417", "PF00083 : Sugar_tr", 
                      "SSF46785 : 0035620", "SSF46689 : 0046802", "SSF50814 : 0052611", 
                      "SSF52540 : 0037921", "SSF56322 : 0042721", "PF02450 : LACT", 
                      "SSF56601 : 0035716", "SSF52518 : 0044478", "SSF53850 : 0046857", 
                      "SSF49870 : 0044010", "SSF57059 : 0049689", "SSF50729 : 0038081", 
                      "SSF55846 : 0039348", "SSF49863 : 0037335", "TIGR00183 : prok_nadp_idh", 
                      "SSF56235 : 0043423", "SSF54427 : 0041600", "SSF51182 : 0051599", 
                      "SSF51735 : 0049864", "SSF51366 : 0050916", "SSF57903 : 0050468", 
                      "SSF54292 : 0036522", "SSF46689 : 0038254", "TIGR00263 : trpB", 
                      "SSF46609 : 0039718", "SSF52833 : 0050108", "SSF46988 : 0038461", 
                      "SSF55550 : 0048099", "PF00384 : Molybdopterin", "PD001819 :", 
                      "SSF54695 : 0043834", "SSF51126 : 0043380", "SSF52042 : 0037550", 
                      "TIGR01934 : MenG_MenH_UbiE", "SSF52467 : 0048895", "SSF54957 : 0035341", 
                      "SSF48726 : 0041312", "PF03222 : Trp_Tyr_perm", "SSF51735 : 0048361", 
                      "PF10300 : Deme6", "SSF51649 : 0046969", "SSF54928 : 0052234", 
                      "PF03928 : DUF336", "SSF48726 : 0035008", "SSF54637 : 0044191", 
                      "SSF52540 : 0037818", "SSF51283 : 0051089", "PS50903 : RUBREDOXIN_LIKE", 
                      "SSF81452 : 0041781", "SSF56091 : 0035285", "SSF46548 : 0052034", 
                      "SSF57059 : 0046695", "PD042831 :", "PF00368 : HMG-CoA_red", 
                      "SSF50249 : 0037529", "SSF54001 : 0040815", "SSF53167 : 0046908", 
                      "SSF52218 : 0036261", "SSF48726 : 0045212", "SSF103196 : 0044719", 
                      "SSF54160 : 0040160", "SSF53098 : 0049562", "SSF54001 : 0038155", 
                      "SSF57667 : 0044262", "SSF51735 : 0045619", "SSF52518 : 0044439", 
                      "PF01799 : Fer2_2", "PS50866 : GOLD", "SSF52317 : 0041668", "SSF51905 : 0042898", 
                      "SSF54909 : 0045015", "SSF55681 : 0043576", "SSF110395 : 0044143", 
                      "SSF51556 : 0045950", "SSF52743 : 0036139", "SSF48726 : 0043047", 
                      "SSF56059 : 0047135", "PF06445 : AraC_E_bind", "SSF54292 : 0037699", 
                      "SSF51679 : 0046866", "SSF49313 : 0041961", "SSF55961 : 0047675", 
                      "SSF55781 : 0043944", "SSF74650 : 0048040", "SSF47836 : 0036911", 
                      "SSF54160 : 0051886", "SSF53098 : 0043904", "SSF88633 : 0034903", 
                      "SSF51556 : 0053093", "PIRSF001250 :", "SSF51445 : 0045330", 
                      "SSF57414 : 0035558", "SSF46785 : 0049992", "SSF54814 : 0036986", 
                      "SSF52833 : 0049089", "SSF51735 : 0043042", "SSF54826 : 0047479", 
                      "SSF53850 : 0038459", "SSF53383 : 0053335", "SSF90209 : 0048257", 
                      "PF07665 : MpPF2", "SSF54117 : 0038002", "PF01245 : Ribosomal_L19", 
                      "SSF89028 : 0043378", "PF03133 : TTL", "SSF47072 : 0049827", 
                      "SSF56770 : 0045287", "SSF57802 : 0046329", "SSF54358 : 0048155", 
                      "SSF53659 : 0050920", "SSF53187 : 0048899", "SSF52540 : 0046539", 
                      "SSF88645 : 0047743", "SSF54768 : 0037618", "SSF53448 : 0050266", 
                      "TIGR00392 : ileS", "SSF51905 : 0053322", "SSF56436 : 0037892", 
                      "SSF49329 : 0046103", "PIRSF018300 :", "SSF51445 : 0052585", 
                      "SSF54452 : 0040256", "SSF56420 : 0050041", "PR00469 : PNDRDTASEII", 
                      "SSF55387 : 0052857", "SSF56436 : 0039103", "SSF51445 : 0041516", 
                      "SSF50249 : 0042514", "SSF49695 : 0037072", "SSF52540 : 0050317", 
                      "PIRSF005677 :", "PF00193 : Xlink", "SSF109905 : 0044340", "SSF48726 : 0045268", 
                      "SSF81324 : 0037417", "SSF88723 : 0049265", "SSF53659 : 0051856", 
                      "TIGR00260 : thrC", "PF08620 : RPAP1_C", "SSF57016 : 0044430", 
                      "SSF49401 : 0041179", "SSF53167 : 0041801", "SSF55469 : 0035601", 
                      "SSF54160 : 0050782", "PF06703 : SPC25", "SSF47661 : 0036510", 
                      "SSF48726 : 0046952", "SSF48557 : 0038780", "SSF55239 : 0035748", 
                      "SSF54001 : 0053371", "PIRSF037938 :", "SSF47175 : 0036826", 
                      "SSF53933 : 0043204", "SSF54913 : 0044330", "SSF48498 : 0049546", 
                      "SSF51658 : 0044164", "SSF51366 : 0052661", "SSF50891 : 0052158", 
                      "SSF52540 : 0038295", "SSF53474 : 0036107", "SSF55681 : 0041422", 
                      "SSF49265 : 0050115", "SSF49417 : 0034855", "SSF56327 : 0038280", 
                      "SSF54523 : 0045412", "SSF51735 : 0041498", "SSF51905 : 0048045", 
                      "SSF49695 : 0045707", "TIGR00494 : crcB", "SSF57302 : 0052990", 
                      "SSF48613 : 0044069", "SSF46609 : 0035151", "PD002395 :", "SSF50475 : 0037036", 
                      "SSF46689 : 0037631", "SSF48726 : 0035467", "SSF53067 : 0049108", 
                      "SSF51246 : 0037274", "SSF51735 : 0044285", "SSF51182 : 0049672", 
                      "SSF69786 : 0041271", "PIRSF015578 :", "PF08707 : PriCT_2", "SSF52540 : 0047073", 
                      "SSF56029 : 0037881", "SSF53067 : 0044614", "SSF50814 : 0052867", 
                      "SSF52283 : 0034926", "SSF50800 : 0042355", "SSF56596 : 0036908", 
                      "SSF52540 : 0046895", "PS50304 : TUDOR", "SSF46934 : 0042141", 
                      "SSF56235 : 0048627", "SSF51735 : 0045076", "SSF49785 : 0051052", 
                      "PF01493 : GXGXG", "SSF55711 : 0036758", "SSF50630 : 0049593", 
                      "SSF54506 : 0044177", "SSF54447 : 0042252", "SSF56327 : 0053364", 
                      "SSF55785 : 0050109", "SSF48403 : 0042015", "SSF57095 : 0046804", 
                      "PIRSF038186 :", "SSF47781 : 0035731", "SSF57095 : 0049513", 
                      "SSF56322 : 0039827", "SSF51126 : 0049244", "SSF51735 : 0050241", 
                      "SSF54919 : 0041292", "TIGR01330 : bisphos_HAL2", "PF02770 : Acyl-CoA_dh_M", 
                      "SSF88697 : 0050865", "SSF50249 : 0050575", "SSF53067 : 0039006", 
                      "SSF50156 : 0049948", "SSF52540 : 0051851", "SSF52540 : 0039713", 
                      "SSF74650 : 0037336", "SSF53706 : 0034976", "SSF53254 : 0041553", 
                      "PF04997 : RNA_pol_Rpb1_1", "TIGR00519 : asnASE_I", "SSF81296 : 0048773", 
                      "SSF51445 : 0036926", "SSF89733 : 0043219", "SSF46626 : 0041460", 
                      "SSF48726 : 0047360", "PF00376 : MerR", "SSF48726 : 0052149", 
                      "PF01467 : CTP_transf_2", "SSF51395 : 0044803", "SSF46689 : 0045265", 
                      "TIGR00657 : asp_kinases", "SSF47413 : 0036955", "SSF51004 : 0041417", 
                      "SSF50249 : 0047013", "SSF52833 : 0041908", "SSF52047 : 0037738", 
                      "SSF53756 : 0042857", "PF00782 : DSPc", "SSF57247 : 0051950", 
                      "SSF53955 : 0034790", "SSF55424 : 0050928", "SSF46626 : 0046405", 
                      "SSF47954 : 0035705", "SSF53686 : 0051972", "SSF51445 : 0049744", 
                      "PR00193 : MYOSINHEAVY", "SSF50447 : 0040119", "PIRSF000336 :", 
                      "PF01812 : 5-FTHF_cyc-lig", "SSF46785 : 0051371", "SSF52218 : 0048535", 
                      "PS51184 : JMJC", "SSF51197 : 0038380", "PS51379 : 4FE4S_FER_2", 
                      "SSF50814 : 0045830", "SSF49899 : 0036669", "PF03601 : Cons_hypoth698", 
                      "SSF48537 : 0035890", "PF04080 : Per1", "SSF100895 : 0043933", 
                      "SSF54236 : 0034888", "PF05887 : Trypan_PARP", "SSF50494 : 0036322", 
                      "PD000902 :", "SSF50044 : 0035132", "PF08544 : GHMP_kinases_C", 
                      "SSF49373 : 0046228", "SSF53756 : 0046669", "PF05011 : DBR1", 
                      "SSF50447 : 0036231", "PIRSF028763 :", "SSF50814 : 0040216", 
                      "PF00687 : Ribosomal_L1", "SSF54849 : 0034908", "SSF54556 : 0038609", 
                      "SSF48256 : 0034881", "SSF50156 : 0044398", "SSF49417 : 0045705", 
                      "SSF69635 : 0051005", "SSF55073 : 0045850", "SSF54791 : 0040088", 
                      "SSF53850 : 0049916", "SSF51197 : 0053127", "TIGR01147 : V_ATP_synt_G", 
                      "SSF57038 : 0048815", "SSF52540 : 0051784", "SSF46785 : 0051024", 
                      "SSF52833 : 0045879", "SSF51905 : 0041939", "SSF48452 : 0038802", 
                      "PIRSF015582 :", "SSF50156 : 0035407", "PF02219 : MTHFR", "PS50879 : RNASE_H", 
                      "SSF52943 : 0037751", "SSF51998 : 0036059", "SSF46626 : 0045615", 
                      "SSF50370 : 0038758", "SSF57016 : 0045672", "SSF48613 : 0042615", 
                      "SSF54637 : 0051977", "SSF88723 : 0052662", "SSF53032 : 0045728", 
                      "PS51195 : Q_MOTIF", "SSF51230 : 0037846", "SSF51717 : 0044147", 
                      "SSF54909 : 0044707", "SSF52283 : 0045380", "SSF57603 : 0049793", 
                      "SSF55781 : 0046710", "SSF81573 : 0040364", "SSF48726 : 0036377", 
                      "SSF74650 : 0049429", "SSF74653 : 0044075", "SSF81296 : 0046675", 
                      "SSF57059 : 0047351", "SSF52833 : 0048057", "SSF55729 : 0052704", 
                      "SSF52821 : 0043248", "SSF57429 : 0039634", "SSF56784 : 0043043", 
                      "PD001229 :", "PF02569 : Pantoate_ligase", "SSF55945 : 0042876", 
                      "SSF52540 : 0047589", "SSF54160 : 0036680", "PF00707 : IF3_C", 
                      "PIRSF000533 :", "SSF49899 : 0046872", "SSF57501 : 0037865", 
                      "SSF47370 : 0046609", "SSF53300 : 0048922", "SSF51445 : 0046505", 
                      "TIGR00043 : TIGR00043", "SSF50494 : 0053300", "PF02550 : AcetylCoA_hydro", 
                      "PF01213 : CAP_N", "SSF55770 : 0037950", "PF10253 : PRCC_Cterm", 
                      "SSF47323 : 0049755", "PD009192 :", "SSF46934 : 0044670", "SSF50494 : 0048030", 
                      "SSF64005 : 0039684", "SSF51445 : 0038602", "PF04427 : Brix", 
                      "SSF53335 : 0047465", "SSF56935 : 0048764", "SSF46785 : 0044275", 
                      "TIGR01180 : aman2_put", "SSF101288 : 0051218", "SSF52402 : 0048521", 
                      "SSF52833 : 0045523", "SSF88723 : 0050096", "SSF55331 : 0049917", 
                      "SSF54285 : 0037656", "SSF51230 : 0041944", "SSF48726 : 0050084", 
                      "PF02424 : ApbE", "PR00792 : PEPSIN", "SSF56281 : 0036779", "SSF52922 : 0041404", 
                      "SSF46911 : 0038930", "SSF53697 : 0046385", "SSF53067 : 0047192", 
                      "PF03952 : Enolase_N", "SSF50156 : 0044391", "SSF46785 : 0043062", 
                      "SSF53223 : 0041513", "SSF57716 : 0050855", "SSF55486 : 0036710", 
                      "SSF82784 : 0040990", "SSF57095 : 0047205", "PF00755 : Carn_acyltransf", 
                      "PS51069 : GBP", "SSF55418 : 0039118", "SSF57535 : 0038112", 
                      "PF03092 : BT1", "SSF55405 : 0036799", "SSF52833 : 0037799", 
                      "SSF48695 : 0037345", "PF09668 : Asp_protease", "SSF46458 : 0037272", 
                      "SSF101790 : 0045001", "SSF51445 : 0052913", "SSF88802 : 0042645", 
                      "SSF51445 : 0047637", "TIGR00499 : lysS_bact", "PR00448 : NSFATTACHMNT", 
                      "SSF63882 : 0043850", "SSF51998 : 0043179", "SSF63887 : 0038596", 
                      "SSF100879 : 0039846", "SSF46785 : 0047283", "SSF53649 : 0038549", 
                      "SSF81271 : 0042736", "SSF81301 : 0042031", "SSF46934 : 0048763", 
                      "SSF57302 : 0050313", "SSF51569 : 0045877", "SSF49785 : 0046230", 
                      "PF03352 : Adenine_glyco", "SSF50249 : 0045686", "SSF56436 : 0040505", 
                      "PF00164 : Ribosomal_S12", "SSF57535 : 0051922", "SSF49899 : 0052500", 
                      "SSF57716 : 0037624", "SSF52374 : 0040214", "TIGR00435 : cysS", 
                      "SSF56219 : 0052568", "SSF54506 : 0043561", "SSF55920 : 0035274", 
                      "SSF49265 : 0053090", "SSF47954 : 0052145", "SSF54928 : 0049801", 
                      "SSF47576 : 0035124", "SSF51679 : 0048036", "PF02020 : W2", "SSF53474 : 0046169", 
                      "SSF52833 : 0040163", "SSF48619 : 0039565", "SSF50249 : 0048167", 
                      "PF06813 : Nodulin-like", "SSF51735 : 0048186", "PF00860 : Xan_ur_permease", 
                      "SSF51430 : 0042515", "SSF49265 : 0042595", "PF00271 : Helicase_C", 
                      "PF04565 : RNA_pol_Rpb2_3", "SSF48726 : 0042901", "SSF53223 : 0040474", 
                      "SSF53335 : 0052749", "SSF47413 : 0036752", "SSF51735 : 0051991", 
                      "PF00724 : Oxidored_FMN", "SSF57424 : 0041242", "SSF54211 : 0041648", 
                      "SSF49899 : 0044950", "SSF56219 : 0048441", "SSF57501 : 0043999", 
                      "TIGR00199 : cinA_cterm", "SSF52317 : 0042722", "SSF57362 : 0034981", 
                      "SSF55961 : 0038973", "SSF49899 : 0046195", "SSF51604 : 0041566", 
                      "SSF54076 : 0035445", "SSF50814 : 0046604", "SSF51366 : 0049675", 
                      "SSF49777 : 0037790", "SSF51430 : 0048014", "SSF51445 : 0043007", 
                      "PR00405 : REVINTRACTNG", "SSF50370 : 0036558", "SSF52972 : 0051656", 
                      "SSF53790 : 0051949", "PF00034 : Cytochrom_C", "SSF53901 : 0035564", 
                      "SSF49309 : 0037322", "PF02502 : LacAB_rpiB", "PS50823 : KH_TYPE_2", 
                      "SSF54171 : 0042826", "PS50263 : CN_HYDROLASE", "PF01855 : POR_N", 
                      "SSF49899 : 0052639", "SSF56235 : 0043424", "SSF46689 : 0052493", 
                      "SSF52540 : 0044482", "SSF52467 : 0045128", "SSF48726 : 0053222", 
                      "SSF88633 : 0042942", "SSF53335 : 0046744", "PS50810 : FRATAXIN_2", 
                      "PF01733 : Nucleoside_tran", "SSF52540 : 0048113", "SSF50104 : 0052975", 
                      "SSF48726 : 0048256", "SSF46626 : 0046233", "SSF54928 : 0034964", 
                      "SSF56112 : 0035778", "SSF56209 : 0039150", "SSF81296 : 0036045", 
                      "PF00520 : Ion_trans", "SSF52058 : 0041264", "SSF53955 : 0042950", 
                      "SSF56300 : 0037632", "SSF57429 : 0041297", "SSF46458 : 0034912", 
                      "SSF57667 : 0037782", "SSF56655 : 0037769", "SSF46458 : 0041115", 
                      "SSF50630 : 0045262", "SSF47188 : 0038688", "SSF47473 : 0034797", 
                      "SSF56176 : 0047231", "SSF48726 : 0038612", "SSF53955 : 0037640", 
                      "SSF88633 : 0037728", "SSF47240 : 0047097", "SSF47616 : 0047061", 
                      "PF02366 : PMT", "SSF54928 : 0050802", "SSF51735 : 0051183", 
                      "SSF53167 : 0048936", "SSF48726 : 0043803", "SSF52821 : 0051400", 
                      "SSF56784 : 0053041", "SSF56854 : 0035760", "PD010667 :", "SSF49785 : 0048711", 
                      "SSF56112 : 0048011", "SSF47874 : 0040853", "PIRSF036999 :", 
                      "SSF51569 : 0051345", "SSF52540 : 0044918", "PF07542 : ATP12", 
                      "SSF88697 : 0039543", "PF04683 : ARM_1", "PF04003 : Utp12", "SSF57424 : 0037404", 
                      "PS51192 : HELICASE_ATP_BIND_1", "SSF50814 : 0047275", "SSF49503 : 0045393", 
                      "SSF57667 : 0045296", "PF03950 : tRNA-synt_1c_C", "SSF56399 : 0049927", 
                      "SSF51998 : 0043302", "SSF88713 : 0053151", "SSF52738 : 0035983", 
                      "SSF68906 : 0050065", "SSF82910 : 0038645", "SSF88697 : 0051822", 
                      "PF02401 : LYTB", "SSF50203 : 0046626", "SSF53098 : 0039100", 
                      "PR00094 : ADENYLTKNASE", "SSF55424 : 0041887", "SSF47807 : 0051042", 
                      "PIRSF006294 :", "PF04671 : Ag332", "PF06920 : Ded_cyto", "PF02129 : Peptidase_S15", 
                      "SSF52374 : 0043153", "SSF52540 : 0051138", "SSF54991 : 0042524", 
                      "SSF53300 : 0040744", "SSF48452 : 0051240", "SSF51556 : 0052789", 
                      "SSF53659 : 0050238", "SSF49503 : 0046621", "SSF46997 : 0046313", 
                      "SSF54637 : 0051590", "SSF50621 : 0050170", "SSF47644 : 0035624", 
                      "SSF47616 : 0049696", "SSF55979 : 0035384", "PD002334 :", "SSF54373 : 0036284", 
                      "SSF48726 : 0047783", "SSF54416 : 0050377", "PS51160 : ACYLPHOSPHATASE_3", 
                      "SSF55846 : 0048569", "SSF49503 : 0053156", "SSF53800 : 0042769", 
                      "PF04139 : Rad9", "PF02991 : MAP1_LC3", "SSF48113 : 0049776", 
                      "SSF50353 : 0048867", "PF09394 : Chagasin_I42", "SSF51445 : 0049894", 
                      "PF08927 : DUF1909", "SSF57184 : 0041265", "SSF47729 : 0039023", 
                      "SSF55008 : 0036108", "SSF82199 : 0041233", "SSF52113 : 0035932", 
                      "SSF50249 : 0039751", "SSF53067 : 0036205", "SSF50249 : 0043001", 
                      "SSF54523 : 0049569", "SSF49265 : 0051920", "SSF56059 : 0044434", 
                      "PF04627 : ATP-synt_Eps", "SSF63829 : 0050023", "SSF50353 : 0049016", 
                      "SSF51445 : 0046139", "SSF53474 : 0043587", "PF04468 : PSP1", 
                      "SSF48619 : 0044788", "SSF57302 : 0052301", "SSF46458 : 0048236", 
                      "PF02984 : Cyclin_C", "PF06047 : DUF926", "SSF56801 : 0043409", 
                      "SSF109728 : 0049571", "SSF47616 : 0038264", "SSF52210 : 0045446", 
                      "PS51228 : ACB_2", "SSF52317 : 0038915", "SSF49879 : 0037914", 
                      "SSF53738 : 0045549", "PF04389 : Peptidase_M28", "PF00027 : cNMP_binding", 
                      "SSF57262 : 0049419", "SSF52141 : 0035086", "PR01159 : DNAGYRASEB", 
                      "PF09794 : Avl9", "SSF53659 : 0049112", "SSF46785 : 0038516", 
                      "SSF81563 : 0039459", "SSF47240 : 0045057", "PS51165 : THUMP", 
                      "SSF48726 : 0041839", "SSF54919 : 0052491", "SSF46966 : 0046218", 
                      "PF10115 : HlyU", "PF03373 : Octapeptide", "PF02887 : PK_C", 
                      "SSF52402 : 0048520", "PF07647 : SAM_2", "SSF49899 : 0039013", 
                      "SSF81631 : 0042506", "SSF47616 : 0039829", "SSF110296 : 0043716", 
                      "SSF88697 : 0051929", "SSF50249 : 0053338", "SSF88633 : 0044054", 
                      "SSF48239 : 0050379", "SSF46689 : 0049195", "SSF46458 : 0046961", 
                      "SSF50965 : 0038187", "SSF49695 : 0034930", "SSF55729 : 0051493", 
                      "SSF53474 : 0049630", "SSF48726 : 0046082", "PF04316 : FlgM", 
                      "SSF54593 : 0041043", "SSF89009 : 0039330", "SSF50630 : 0041065", 
                      "SSF81469 : 0048090", "SSF50891 : 0051523", "SSF54452 : 0040827", 
                      "PIRSF004967 :", "SSF52540 : 0049919", "PF08060 : NOSIC", "SSF54001 : 0042510", 
                      "SSF56042 : 0050292", "SSF53067 : 0051710", "TIGR00291 : TIGR00291", 
                      "SSF51182 : 0040629", "SSF54534 : 0042239", "SSF49899 : 0046938", 
                      "TIGR01369 : CPSaseII_lrg", "PF00076 : RRM_1", "PS51344 : HTH_TFE_IIE", 
                      "SSF57716 : 0050751", "SSF47095 : 0040422", "SSF55315 : 0043511", 
                      "SSF54117 : 0037908", "SSF55486 : 0038581", "SSF51556 : 0040224", 
                      "SSF51445 : 0050028", "PF00497 : SBP_bac_3", "PF09440 : eIF3_N", 
                      "SSF49503 : 0038964", "SSF52540 : 0045809", "SSF48498 : 0043883", 
                      "SSF49348 : 0036757", "TIGR00468 : pheS", "SSF53335 : 0052084", 
                      "SSF57667 : 0052206", "SSF50129 : 0041738", "SSF50789 : 0035190", 
                      "SSF51556 : 0052605", "SSF50494 : 0045448", "SSF46626 : 0045496", 
                      "SSF47917 : 0043649", "PF00096 : zf-C2H2", "SSF51569 : 0046741", 
                      "PF08017 : Fibrinogen_BP", "SSF53474 : 0050112", "SSF48726 : 0042304", 
                      "SSF57059 : 0037367", "SSF54001 : 0048830", "SSF47220 : 0049464", 
                      "SSF48208 : 0046953", "SSF48726 : 0035520", "SSF75005 : 0051222", 
                      "SSF52540 : 0037776", "SSF56112 : 0042354", "TIGR01882 : peptidase-T", 
                      "SSF53474 : 0039602", "SSF88713 : 0053130", "SSF54786 : 0050569", 
                      "SSF49695 : 0034864", "SSF51735 : 0049824", "SSF46689 : 0039196", 
                      "SSF48452 : 0050358", "SSF63829 : 0046436", "PF07946 : DUF1682", 
                      "PF02911 : Formyl_trans_C", "SSF54001 : 0045204", "TIGR01634 : tail_P2_I", 
                      "SSF51445 : 0045067", "PF02782 : FGGY_C", "SSF46934 : 0052215", 
                      "SSF89957 : 0051374", "PD019198 :", "SSF101494 : 0043535", "SSF47240 : 0050162", 
                      "SSF50156 : 0044310", "PF00373 : FERM_M", "PF09734 : Tau95", 
                      "PD000018 :", "SSF48334 : 0037229", "SSF49503 : 0043618", "PF07145 : PAM2", 
                      "SSF51430 : 0048846", "SSF52343 : 0036119", "PS50086 : TBC_RABGAP", 
                      "SSF55060 : 0037811", "SSF50814 : 0035581", "PR00929 : ATHOOK", 
                      "PF00487 : FA_desaturase", "PS50194 : FILAMIN_REPEAT", "SSF52540 : 0042557", 
                      "SSF51197 : 0036356", "SSF53474 : 0044333", "SSF100895 : 0045542", 
                      "PF00403 : HMA", "SSF52080 : 0052972", "SSF55973 : 0041132", 
                      "SSF103107 : 0043602", "SSF56436 : 0049355", "SSF48726 : 0051841", 
                      "SSF109993 : 0044157", "SSF46561 : 0043156", "SSF52172 : 0047753", 
                      "SSF54427 : 0053334", "SSF51101 : 0039368", "SSF50249 : 0046777", 
                      "PF03164 : Mon1", "TIGR01534 : GAPDH-I", "SSF50249 : 0047328", 
                      "PD026943 :", "SSF56655 : 0042779", "SSF46689 : 0046966", "SSF52540 : 0036293", 
                      "SSF48726 : 0041910", "SSF55486 : 0046088", "SSF52283 : 0042341", 
                      "SSF53474 : 0039631", "SSF50156 : 0043410", "SSF46785 : 0052633", 
                      "SSF51905 : 0038284", "SSF57095 : 0040494", "SSF56281 : 0042783", 
                      "PF09588 : YqaJ", "SSF57302 : 0039535", "SSF46785 : 0049993", 
                      "PF00582 : Usp", "PD000566 :", "SSF47095 : 0050522", "SSF51905 : 0048865", 
                      "SSF53335 : 0047471", "SSF49441 : 0044722", "SSF52540 : 0045340", 
                      "SSF48726 : 0047941", "SSF55637 : 0042465", "PF00596 : Aldolase_II", 
                      "SSF63817 : 0039050", "SSF54292 : 0039693", "PD004466 :", "SSF50729 : 0040975", 
                      "SSF82649 : 0041407", "PF02466 : Tim17", "SSF49344 : 0044348", 
                      "SSF54637 : 0052965", "PF05116 : S6PP", "SSF49503 : 0045174", 
                      "SSF54862 : 0052658", "SSF48230 : 0035895", "SSF46785 : 0044211", 
                      "SSF51101 : 0042038", "SSF51735 : 0048293", "TIGR00687 : pyridox_kin", 
                      "PF06888 : Put_Phosphatase", "SSF54897 : 0048845", "SSF54928 : 0043799", 
                      "SSF50203 : 0048087", "SSF52833 : 0038271", "SSF46955 : 0044064", 
                      "SSF55174 : 0038395", "SSF51735 : 0039650", "SSF54984 : 0037408", 
                      "PF09132 : BmKX", "SSF50494 : 0042528", "SSF51604 : 0047651", 
                      "SSF51905 : 0048494", "SSF54328 : 0043742", "SSF63380 : 0039465", 
                      "PF08077 : Cm_res_leader", "SSF50916 : 0037375", "SSF46589 : 0043575", 
                      "SSF48726 : 0045271", "PS50090 : MYB_3", "PF01420 : Methylase_S", 
                      "PF05378 : Hydant_A_N", "SSF88713 : 0039851", "SSF48695 : 0046418", 
                      "SSF56784 : 0043763", "PF00550 : PP-binding", "SSF52833 : 0042395", 
                      "SSF50494 : 0035210", "SSF48081 : 0036803", "SSF81296 : 0040248", 
                      "SSF55315 : 0038339", "SSF88688 : 0051909", "SSF53822 : 0037227", 
                      "SSF64268 : 0040149", "SSF55856 : 0043820", "PF03919 : mRNA_cap_C", 
                      "SSF46785 : 0045981", "SSF48464 : 0038572", "SSF48371 : 0051023", 
                      "PF07047 : OPA3", "SSF48508 : 0048850", "SSF69645 : 0039969", 
                      "PF03748 : FliL", "PS51087 : APAG", "PR00148 : ENOLASE", "SSF88645 : 0039897", 
                      "PF00975 : Thioesterase", "PF10510 : PIG-S", "SSF47473 : 0037732", 
                      "PF07985 : SRR1", "SSF53335 : 0051617", "SSF57774 : 0045114", 
                      "SSF46458 : 0035971", "SSF54197 : 0045601", "SSF46785 : 0045030", 
                      "SSF56235 : 0047001", "SSF49265 : 0044621", "SSF48508 : 0038502", 
                      "SSF55040 : 0046578", "PF02374 : ArsA_ATPase", "SSF46604 : 0036817", 
                      "SSF53474 : 0047592", "PF03328 : HpcH_HpaI", "SSF53300 : 0040904", 
                      "PF00174 : Oxidored_molyb", "SSF109604 : 0049588", "PF01946 : Thi4", 
                      "SSF56059 : 0050127", "SSF57440 : 0047144", "SSF54334 : 0045577", 
                      "PF00059 : Lectin_C", "SSF53335 : 0045109", "PF04719 : TAFII28", 
                      "PF10058 : DUF2296", "PS50995 : HTH_MARR_2", "SSF48201 : 0048822", 
                      "SSF51998 : 0049134", "SSF56436 : 0039437", "SSF55811 : 0052719", 
                      "SSF48371 : 0045874", "SSF47616 : 0052944", "SSF48726 : 0035998", 
                      "SSF49464 : 0042871", "SSF81327 : 0037935", "SSF56425 : 0036733", 
                      "SSF46785 : 0047461", "SSF47616 : 0038252", "SSF90112 : 0041813", 
                      "SSF53383 : 0050340", "SSF55753 : 0045072", "SSF81296 : 0035521", 
                      "SSF56281 : 0042203", "SSF56973 : 0044565", "PD004738 :", "SSF46689 : 0047051", 
                      "SSF51735 : 0036785", "SSF47323 : 0035690", "PR00620 : HISTONEH2A", 
                      "SSF53850 : 0051197", "SSF48726 : 0035518", "SSF50939 : 0050402", 
                      "SSF47240 : 0050978", "SSF56399 : 0038322", "SSF46626 : 0044444", 
                      "SSF57095 : 0045915", "PD017661 :", "SSF47473 : 0037987", "PIRSF001368 :", 
                      "PF00638 : Ran_BP1", "PS51282 : DWNN", "PF01323 : DSBA", "SSF51445 : 0043162", 
                      "SSF48179 : 0052328", "SSF47353 : 0045255", "SSF48208 : 0044653", 
                      "TIGR00836 : amt", "PF03947 : Ribosomal_L2_C", "SSF51735 : 0043289", 
                      "SSF52833 : 0051497", "SSF54358 : 0048156", "SSF56784 : 0051120", 
                      "PD001057 :", "SSF88633 : 0046844", "SSF52266 : 0037157", "SSF52540 : 0037884", 
                      "PF04658 : TAFII55_N", "PF10408 : Ufd2P_core", "PIRSF010072 :", 
                      "SSF55904 : 0035847", "SSF89447 : 0049850", "SSF49265 : 0052410", 
                      "SSF47895 : 0051550", "SSF49503 : 0049194", "SSF55469 : 0041494", 
                      "SSF48256 : 0036140", "PF03600 : CitMHS", "SSF47370 : 0048291", 
                      "SSF46906 : 0048192", "SSF100966 : 0041336", "SSF47226 : 0049447", 
                      "SSF53933 : 0040915", "SSF56214 : 0042952", "SSF48726 : 0046776", 
                      "PF03455 : dDENN", "SSF57424 : 0036243", "SSF50182 : 0047193", 
                      "SSF51445 : 0049424", "SSF54495 : 0051309", "SSF57190 : 0042256", 
                      "SSF63515 : 0038093", "SSF57716 : 0036273", "PS50174 : G_PATCH", 
                      "PF08767 : CRM1_C", "SSF55200 : 0053103", "SSF51735 : 0041610", 
                      "SSF68918 : 0036821", "SSF57196 : 0042294", "SSF57501 : 0037654", 
                      "PD002389 :", "PS50945 : I_LWEQ", "SSF50203 : 0053317", "SSF46997 : 0040595", 
                      "SSF48726 : 0045331", "SSF51569 : 0043346", "PF10424 : RFC-E_C", 
                      "SSF48726 : 0040314", "SSF51735 : 0041757", "PF01775 : Ribosomal_L18ae", 
                      "SSF53335 : 0044857", "SSF48726 : 0043444", "PIRSF000151 :", 
                      "SSF52833 : 0052112", "SSF81872 : 0040951", "SSF88946 : 0041988", 
                      "PF00224 : PK", "SSF57667 : 0045656", "PS51048 : SGS", "SSF48498 : 0045466", 
                      "SSF48179 : 0045524", "SSF46458 : 0036309", "SSF46785 : 0050732", 
                      "SSF49879 : 0038313", "SSF82026 : 0044487", "PR00067 : CATALASE", 
                      "SSF46934 : 0044709", "SSF56601 : 0046452", "SSF64484 : 0038871", 
                      "SSF56672 : 0043905", "SSF55753 : 0053314", "SSF52833 : 0045744", 
                      "SSF57535 : 0038135", "SSF109805 : 0042586", "SSF46785 : 0052860", 
                      "PF01145 : Band_7", "SSF56281 : 0034936", "PD214932 :", "SSF55136 : 0039814", 
                      "SSF55159 : 0036233", "SSF51735 : 0043144", "SSF88713 : 0048464", 
                      "SSF54966 : 0035747", "SSF56849 : 0036012", "SSF47203 : 0043101", 
                      "SSF46966 : 0042055", "SSF55811 : 0049771", "SSF54495 : 0039405", 
                      "SSF51604 : 0039688", "SSF49879 : 0044369", "SSF55753 : 0038681", 
                      "SSF52788 : 0047618", "SSF55068 : 0041594", "SSF54236 : 0046009", 
                      "SSF56436 : 0039104", "SSF54160 : 0052049", "PF04066 : MrpF_PhaF", 
                      "SSF53335 : 0053077", "SSF57802 : 0036623", "SSF81296 : 0034854", 
                      "SSF50630 : 0040949", "SSF54211 : 0041085", "SSF52540 : 0038151", 
                      "SSF81296 : 0047604", "SSF56436 : 0039794", "SSF52317 : 0042074", 
                      "SSF57868 : 0042814", "PF07859 : Abhydrolase_3", "SSF49503 : 0039509", 
                      "SSF101960 : 0044748", "SSF54427 : 0050687", "SSF49785 : 0041795", 
                      "SSF51096 : 0036011", "PF05222 : AlaDh_PNT_N", "SSF51110 : 0036491", 
                      "SSF49785 : 0040582", "SSF51306 : 0037364", "SSF54117 : 0046734", 
                      "SSF53244 : 0041698", "SSF53056 : 0037055", "TIGR03625 : L3_bact", 
                      "SSF63491 : 0047318", "SSF50129 : 0047654", "SSF63418 : 0038084", 
                      "SSF49584 : 0040381", "SSF52402 : 0049673", "SSF57535 : 0038134", 
                      "PR00011 : EGFLAMININ", "SSF52833 : 0050680", "PF00432 : Prenyltrans", 
                      "SSF52833 : 0036606", "SSF51011 : 0040842", "PF01257 : Complex1_24kDa", 
                      "SSF50353 : 0053114", "PF00370 : FGGY_N", "SSF88633 : 0037664", 
                      "SSF49695 : 0048591", "SSF53474 : 0045736", "SSF47794 : 0042537", 
                      "SSF54534 : 0040355", "SSF51735 : 0047992", "SSF53254 : 0051064", 
                      "SSF53955 : 0040610", "SSF57302 : 0040309", "SSF53098 : 0046881", 
                      "SSF51905 : 0046344", "SSF56436 : 0045372", "SSF47895 : 0036001", 
                      "SSF50353 : 0039707", "SSF63380 : 0049422", "SSF50249 : 0043292", 
                      "SSF56281 : 0048716", "SSF50494 : 0042606", "SSF51735 : 0040043", 
                      "SSF54236 : 0050539", "SSF53850 : 0050446", "PF00268 : Ribonuc_red_sm", 
                      "PIRSF000090 :", "SSF52518 : 0049135", "SSF50353 : 0042939", 
                      "PIRSF015596 :", "PF01814 : Hemerythrin", "SSF63380 : 0038027", 
                      "SSF56655 : 0049438", "SSF55811 : 0050097", "PF09297 : zf-NADH-PPase", 
                      "SSF55961 : 0047781", "PF09111 : SLIDE", "PD205440 :", "SSF50814 : 0046633", 
                      "SSF54452 : 0034827", "SSF52467 : 0046339", "SSF56672 : 0043962", 
                      "SSF54928 : 0050478", "TIGR03413 : GSH_gloB", "SSF52540 : 0037248", 
                      "SSF52518 : 0036597", "SSF57392 : 0049707", "PF01591 : 6PF2K", 
                      "PF10684 : BDM", "SSF48666 : 0038412", "TIGR01197 : nramp", "SSF101912 : 0042613", 
                      "SSF50998 : 0047775", "SSF54928 : 0050809", "SSF46609 : 0040859", 
                      "SSF57095 : 0036460", "SSF54631 : 0050301", "SSF53659 : 0034800", 
                      "PS51351 : TFIIE_BETA_C", "SSF52821 : 0036692", "SSF54897 : 0047658", 
                      "PIRSF500133 :", "SSF51735 : 0034872", "SSF49785 : 0036673", 
                      "SSF57027 : 0038497", "SSF46785 : 0049886", "SSF48019 : 0034889", 
                      "SSF54814 : 0046552", "SSF54236 : 0051476", "PS51006 : SPERMIDINE_SYNTHASE_2", 
                      "SSF56112 : 0038477", "SSF48726 : 0039148", "SSF81296 : 0039076", 
                      "SSF56601 : 0037018", "SSF52821 : 0046432", "SSF47113 : 0038977", 
                      "PF02391 : MoaE", "SSF53335 : 0036610", "SSF57302 : 0040013", 
                      "SSF46934 : 0047021", "SSF51206 : 0052199", "SSF51556 : 0039379", 
                      "PF00037 : Fer4", "SSF54768 : 0043878", "SSF49842 : 0044063", 
                      "PF08698 : Fcf2", "SSF49899 : 0045387", "SSF51735 : 0038206", 
                      "PF05362 : Lon_C", "PF03637 : Mob1_phocein", "SSF53474 : 0039972", 
                      "SSF51735 : 0042207", "SSF49899 : 0052129", "SSF55811 : 0052634", 
                      "PF01991 : vATP-synt_E", "SSF54427 : 0045571", "SSF53271 : 0038882", 
                      "SSF52335 : 0044894", "SSF51445 : 0051312", "SSF46689 : 0035079", 
                      "SSF50203 : 0050029", "SSF48403 : 0047382", "PF00347 : Ribosomal_L6", 
                      "SSF53271 : 0046852", "SSF53383 : 0052731", "PF10354 : DUF2431", 
                      "SSF50486 : 0037228", "SSF47113 : 0040304", "SSF52096 : 0050758", 
                      "SSF48508 : 0039913", "SSF54236 : 0047942", "SSF50249 : 0038590", 
                      "SSF69635 : 0043472", "PF07276 : PSGP", "SSF56235 : 0040786", 
                      "SSF50386 : 0044018", "SSF52518 : 0049136", "SSF50156 : 0051643", 
                      "SSF48726 : 0040599", "SSF47781 : 0052272", "SSF53335 : 0045988", 
                      "SSF55781 : 0040980", "SSF48179 : 0040234", "PF00431 : CUB", 
                      "SSF54285 : 0044804", "TIGR01525 : ATPase-IB_hvy", "SSF81853 : 0038318", 
                      "SSF81273 : 0038653", "PR00622 : HISTONEH3", "SSF48557 : 0037788", 
                      "SSF50182 : 0036252", "SSF50129 : 0042106", "PS51380 : EXS", 
                      "SSF51182 : 0050297", "SSF101215 : 0043138", "SSF63748 : 0048574", 
                      "SSF49899 : 0053302", "PF09379 : FERM_N", "SSF56327 : 0045222", 
                      "PF01603 : B56", "SSF57774 : 0035076", "PR00099 : CPSGATASE", 
                      "SSF46934 : 0041983", "SSF50969 : 0047917", "SSF56831 : 0045200", 
                      "SSF48508 : 0037497", "PF07541 : EIF_2_alpha", "SSF47587 : 0038239", 
                      "SSF90229 : 0052242", "SSF74650 : 0044155", "PF03256 : APC10", 
                      "SSF56112 : 0041710", "SSF52935 : 0036702", "SSF50630 : 0038719", 
                      "SSF51569 : 0046878", "SSF57196 : 0048437", "PF05645 : RNA_pol_Rpc82", 
                      "SSF81464 : 0053245", "SSF51055 : 0036915", "SSF56854 : 0037326", 
                      "SSF57850 : 0047962", "SSF52540 : 0034833", "SSF50129 : 0047480", 
                      "SSF49785 : 0049619", "SSF54919 : 0050638", "SSF53850 : 0047567", 
                      "PS51152 : NFYA_HAP2_2", "SSF49785 : 0037199", "SSF56436 : 0053191", 
                      "PF08069 : Ribosomal_S13_N", "SSF57440 : 0039409", "SSF56059 : 0038455", 
                      "SSF54826 : 0047652", "PD011023 :", "SSF57196 : 0045033", "PF09384 : U3_snoRNA_C", 
                      "PF00466 : Ribosomal_L10", "SSF46458 : 0050304", "SSF48662 : 0037553", 
                      "PF07534 : TLD", "SSF51569 : 0047939", "PF03747 : ADP_ribosyl_GH", 
                      "SSF46785 : 0045310", "SSF51556 : 0052488", "SSF54975 : 0052052", 
                      "SSF48695 : 0037755", "SSF57429 : 0045416", "SSF57247 : 0048233", 
                      "SSF100920 : 0046351", "SSF49265 : 0048948", "SSF55347 : 0035390", 
                      "SSF63748 : 0048668", "PIRSF036492 :", "PF06551 : DUF1120", "SSF49503 : 0035783", 
                      "SSF53448 : 0036781", "PIRSF000778 :", "SSF100895 : 0040148", 
                      "SSF47113 : 0050728", "SSF48726 : 0036315", "PR00756 : ALADIPTASE", 
                      "SSF49562 : 0049239", "SSF49503 : 0042367", "SSF48726 : 0035573", 
                      "PF04098 : Rad52_Rad22", "SSF50729 : 0052197", "SSF52540 : 0034890", 
                      "SSF51101 : 0035836", "SSF52788 : 0042322", "SSF53850 : 0051539", 
                      "SSF46565 : 0041640", "SSF50156 : 0038015", "SSF53686 : 0050152", 
                      "SSF51230 : 0039971", "SSF55653 : 0036447", "SSF50447 : 0037974", 
                      "PF01883 : DUF59", "SSF46689 : 0050545", "SSF55174 : 0039540", 
                      "SSF55945 : 0035064", "SSF53187 : 0036591", "SSF51206 : 0036184", 
                      "SSF46997 : 0036384", "PD802108 :", "SSF63825 : 0039054", "PIRSF036407 :", 
                      "SSF48179 : 0042306", "SSF53098 : 0051397", "SSF52833 : 0043137", 
                      "SSF46785 : 0045910", "SSF81593 : 0040171", "SSF50494 : 0036486", 
                      "SSF52309 : 0040444", "SSF64356 : 0038994", "SSF57756 : 0048327", 
                      "SSF47616 : 0045593", "SSF52833 : 0042873", "PF05585 : DUF1758", 
                      "SSF54791 : 0039370", "PF01183 : Glyco_hydro_25", "SSF50969 : 0048144", 
                      "SSF49870 : 0049235", "PF04148 : Erv26", "PF03129 : HGTP_anticodon", 
                      "SSF47616 : 0037211", "PF00128 : Alpha-amylase", "SSF46785 : 0036308", 
                      "SSF47973 : 0043368", "SSF57701 : 0045307", "PS50057 : FERM_3", 
                      "SSF52743 : 0035548", "SSF51556 : 0037271", "SSF51230 : 0051241", 
                      "SSF52266 : 0046616", "SSF54928 : 0049769", "SSF50494 : 0040353", 
                      "SSF57716 : 0038173", "SSF50494 : 0047191", "PD014007 :", "PF01965 : DJ-1_PfpI", 
                      "SSF49777 : 0035501", "SSF53137 : 0036588", "SSF57196 : 0037162", 
                      "SSF49265 : 0050606", "PF00483 : NTP_transferase", "SSF50182 : 0041281", 
                      "SSF51735 : 0045035", "SSF53706 : 0041852", "PR00883 : NUCLEARHMG", 
                      "TIGR01642 : U2AF_lg", "PS51217 : UVRD_HELICASE_CTER", "SSF55486 : 0042988", 
                      "SSF52768 : 0036259", "SSF56112 : 0038413", "PF01749 : IBB", 
                      "SSF52833 : 0049048", "SSF49764 : 0038165", "SSF68906 : 0052478", 
                      "PIRSF000709 :", "SSF88633 : 0041955", "SSF52833 : 0037366", 
                      "SSF52833 : 0035590", "SSF55326 : 0044821", "TIGR00567 : 3mg", 
                      "SSF52540 : 0043562", "SSF52540 : 0040091", "SSF52540 : 0043459", 
                      "SSF57850 : 0052291", "SSF49899 : 0042532", "PF00398 : RrnaAD", 
                      "SSF48726 : 0048800", "PR00975 : RIBOSOMALS19", "SSF81296 : 0047884", 
                      "SSF51055 : 0036705", "PD001180 :", "PF00462 : Glutaredoxin", 
                      "PD009560 :", "PF07366 : SnoaL", "SSF53850 : 0036600", "SSF53850 : 0049487", 
                      "SSF55729 : 0045090", "SSF56176 : 0044931", "SSF81301 : 0041481", 
                      "SSF64210 : 0038801", "SSF56349 : 0034845", "SSF51395 : 0040653", 
                      "SSF48726 : 0046823", "SSF88723 : 0045876", "SSF53098 : 0046173", 
                      "SSF48208 : 0038024", "SSF52218 : 0048395", "SSF54292 : 0037749", 
                      "SSF57630 : 0040622", "PR00616 : CCAATSUBUNTB", "SSF47576 : 0040871", 
                      "SSF51069 : 0043265", "SSF53187 : 0046194", "PF03941 : INCENP_ARK-bind", 
                      "SSF51430 : 0045771", "PF00900 : Ribosomal_S4e", "PF01221 : Dynein_light", 
                      "SSF55347 : 0052819", "SSF47598 : 0035481", "SSF50249 : 0050995", 
                      "SSF55144 : 0053115", "SSF48695 : 0045497", "SSF55781 : 0043759", 
                      "SSF52980 : 0047187", "SSF101386 : 0051426", "PF02214 : K_tetra", 
                      "PF03881 : Fructosamin_kin", "PF03054 : tRNA_Me_trans", "PF07780 : Spb1_C", 
                      "SSF52540 : 0048956", "SSF57701 : 0046168", "PF00134 : Cyclin_N", 
                      "SSF52440 : 0045749", "SSF54373 : 0041697", "SSF48726 : 0050984", 
                      "SSF57535 : 0035816", "SSF57262 : 0037033", "TIGR02238 : recomb_DMC1", 
                      "PR00660 : ERLUMENR", "SSF52540 : 0051562", "SSF55658 : 0042790", 
                      "SSF101152 : 0042326", "SSF53474 : 0041603", "SSF50249 : 0039578", 
                      "SSF54211 : 0041876", "SSF53187 : 0048735", "SSF55931 : 0046708", 
                      "SSF88645 : 0038078", "SSF50814 : 0038868", "SSF51126 : 0042255", 
                      "SSF52540 : 0048255", "SSF51182 : 0041796", "SSF52540 : 0037821", 
                      "SSF55347 : 0053020", "SSF48726 : 0041364", "SSF52540 : 0051104", 
                      "SSF56327 : 0041889", "SSF53383 : 0046747", "SSF46894 : 0042125", 
                      "SSF54843 : 0035758", "PR01438 : UNVRSLSTRESS", "SSF49899 : 0051717", 
                      "PF02212 : GED", "PF00342 : PGI", "PF03720 : UDPG_MGDP_dh_C", 
                      "SSF54909 : 0043272", "SSF48239 : 0045459", "SSF57059 : 0046086", 
                      "SSF53671 : 0048833", "PF00416 : Ribosomal_S13", "SSF57850 : 0039626", 
                      "SSF52058 : 0041848", "SSF56037 : 0042526", "SSF56568 : 0040341", 
                      "PF04181 : RPAP2_Rtr1", "SSF57277 : 0037812", "SSF56399 : 0047531", 
                      "PF06588 : Muskelin_N", "SSF48445 : 0048523", "SSF54277 : 0047341", 
                      "SSF88633 : 0046812", "PF00227 : Proteasome", "PF00249 : Myb_DNA-binding", 
                      "SSF48464 : 0046580", "SSF47794 : 0049831", "SSF53807 : 0053186", 
                      "SSF49899 : 0045737", "SSF53633 : 0036708", "SSF46955 : 0042546", 
                      "SSF52402 : 0045391", "SSF56815 : 0041050", "SSF54160 : 0045948", 
                      "SSF46689 : 0050573", "SSF48726 : 0047816", "SSF55550 : 0036271", 
                      "SSF56235 : 0053199", "SSF49373 : 0036179", "SSF52540 : 0052724", 
                      "SSF52518 : 0042101", "SSF57567 : 0038764", "SSF88713 : 0041730", 
                      "PF04983 : RNA_pol_Rpb1_3", "TIGR01160 : SUI1_MOF2", "PF09337 : zf-H2C2", 
                      "PF00883 : Peptidase_M17", "SSF56112 : 0040180", "SSF56672 : 0046068", 
                      "PF01139 : UPF0027", "SSF69008 : 0038160", "PS51337 : B12_BINDING_NTER", 
                      "SSF52374 : 0048216", "SSF51735 : 0035405", "SSF54373 : 0038927", 
                      "PF05162 : Ribosomal_L41", "SSF50104 : 0037542", "SSF49785 : 0039760", 
                      "SSF52402 : 0050233", "SSF55021 : 0051578", "SSF50090 : 0039455", 
                      "SSF53335 : 0039093", "SSF53597 : 0036228", "SSF48726 : 0050952", 
                      "PF00036 : efhand", "PIRSF005229 :", "SSF51126 : 0048970", "SSF53850 : 0045793", 
                      "SSF57095 : 0051824", "SSF55856 : 0038614", "PS50157 : ZINC_FINGER_C2H2_2", 
                      "SSF50249 : 0047805", "SSF55785 : 0041279", "SSF53807 : 0040947", 
                      "SSF53335 : 0036976", "SSF82109 : 0048281", "SSF49899 : 0052187", 
                      "PF06068 : TIP49", "PIRSF018427 :", "SSF51445 : 0045956", "PF00189 : Ribosomal_S3_C", 
                      "SSF51011 : 0036869", "SSF48452 : 0047366", "SSF57716 : 0039083", 
                      "TIGR00087 : surE", "SSF56784 : 0051956", "SSF51905 : 0038074", 
                      "SSF50729 : 0052193", "PD354900 :", "TIGR02606 : antidote_CC2985", 
                      "SSF49503 : 0034979", "SSF56784 : 0041474", "SSF57889 : 0037470", 
                      "SSF53790 : 0044765", "SSF101288 : 0051594", "SSF51569 : 0043447", 
                      "SSF51419 : 0044737", "SSF54719 : 0039180", "SSF56436 : 0051196", 
                      "PF06248 : Zw10", "SSF53155 : 0049381", "SSF53300 : 0046828", 
                      "SSF52467 : 0052448", "SSF48508 : 0042006", "SSF54236 : 0044307", 
                      "SSF52309 : 0052602", "SSF50249 : 0039282", "SSF51569 : 0049000", 
                      "SSF52540 : 0039366", "SSF100895 : 0045201", "SSF47807 : 0045875", 
                      "SSF50465 : 0036238", "SSF52440 : 0049945", "SSF47954 : 0037918", 
                      "PF08066 : PMC2NT", "PF01778 : Ribosomal_L28e", "PF10381 : Autophagy_Cterm", 
                      "SSF48726 : 0047352", "SSF63411 : 0046661", "PIRSF016394 :", 
                      "SSF69103 : 0047762", "PF05181 : XPA_C", "SSF51604 : 0050709", 
                      "SSF82057 : 0040855", "SSF52374 : 0041706", "SSF52540 : 0051927", 
                      "TIGR00009 : L28", "SSF56235 : 0053074", "SSF89919 : 0040128", 
                      "TIGR00417 : speE", "SSF52833 : 0052012", "SSF54849 : 0044966", 
                      "SSF55770 : 0048791", "SSF53901 : 0047209", "SSF57424 : 0052954", 
                      "SSF53474 : 0046004", "PF08773 : CathepsinC_exc", "SSF48726 : 0038918", 
                      "SSF57095 : 0052259", "PR01640 : PROFILINPLNT", "SSF56994 : 0045636", 
                      "SSF51735 : 0037436", "SSF89009 : 0048660", "PD238184 :", "SSF88633 : 0045944", 
                      "PF04157 : EAP30", "PF07722 : Peptidase_C26", "SSF52317 : 0043181", 
                      "SSF54236 : 0048367", "PF00391 : PEP-utilizers", "SSF51735 : 0051873", 
                      "PF00491 : Arginase", "SSF57016 : 0037004", "SSF53448 : 0040693", 
                      "SSF57667 : 0052470", "SSF55550 : 0045451", "SSF50249 : 0049372", 
                      "SSF55331 : 0038049", "SSF49344 : 0047326", "PIRSF000110 :", 
                      "SSF46785 : 0044331", "SSF48613 : 0039231", "SSF50891 : 0051660", 
                      "PF06357 : Omega-toxin", "SSF57059 : 0040571", "SSF53697 : 0050600", 
                      "SSF51621 : 0034859", "SSF51556 : 0053002", "SSF55405 : 0042699", 
                      "SSF103196 : 0039361", "SSF50405 : 0047167", "SSF55331 : 0049829", 
                      "SSF51445 : 0046102", "SSF53254 : 0039033", "PF02525 : Flavodoxin_2", 
                      "SSF51905 : 0036653", "SSF54631 : 0042238", "SSF88633 : 0036269", 
                      "SSF51735 : 0044858", "PF00091 : Tubulin", "SSF51419 : 0046278", 
                      "PR00679 : PROHIBITIN", "SSF56112 : 0042315", "PS50940 : CHIT_BIND_II", 
                      "SSF54637 : 0051839", "SSF48726 : 0046740", "SSF51569 : 0037304", 
                      "PF08569 : Mo25", "SSF54534 : 0052573", "SSF48592 : 0042602", 
                      "SSF50156 : 0050487", "SSF55729 : 0045986", "SSF52317 : 0051742", 
                      "SSF50729 : 0042143", "SSF46966 : 0043477", "SSF50249 : 0043671", 
                      "SSF54506 : 0043560", "SSF51182 : 0039355", "PF10434 : MAM1", 
                      "SSF52172 : 0048705", "SSF55120 : 0052542", "SSF50129 : 0038566", 
                      "SSF47473 : 0037066", "SSF51735 : 0049007", "SSF51445 : 0044581", 
                      "SSF47943 : 0037867", "PF01162 : GatB", "PF04325 : DUF465", "SSF48726 : 0045972", 
                      "SSF49785 : 0039889", "SSF48726 : 0040072", "PS50929 : ABC_TM1F", 
                      "PF00170 : bZIP_1", "SSF102405 : 0043198", "SSF88645 : 0038077", 
                      "SSF52540 : 0037787", "SSF53474 : 0040046", "SSF47781 : 0036157", 
                      "PR01161 : TUBULIN", "SSF53706 : 0044058", "SSF50182 : 0052637", 
                      "SSF57774 : 0045158", "SSF57302 : 0040261", "SSF46785 : 0052579", 
                      "SSF49863 : 0046101", "PR01301 : RGSPROTEIN", "SSF48613 : 0052925", 
                      "PF02551 : Acyl_CoA_thio", "SSF53822 : 0042275", "TIGR00280 : L37a", 
                      "SSF55315 : 0037533", "SSF82895 : 0040648", "SSF101278 : 0043456", 
                      "SSF57392 : 0036767", "SSF57501 : 0045943", "SSF52402 : 0052923", 
                      "SSF57095 : 0035688", "SSF57667 : 0043981", "SSF52540 : 0044295", 
                      "SSF52096 : 0052793", "SSF81342 : 0044720", "SSF75217 : 0044596", 
                      "PD120108 :", "SSF49265 : 0047532", "SSF46950 : 0052265", "PF03234 : CDC37_N", 
                      "SSF53383 : 0035700", "PF08007 : Cupin_4", "PR00985 : TRNASYNTHLEU", 
                      "SSF51735 : 0035733", "SSF48371 : 0050410", "SSF48726 : 0035859", 
                      "PIRSF008835 :", "SSF53448 : 0043019", "SSF51604 : 0046516", 
                      "SSF50814 : 0037119", "SSF82679 : 0041641", "PIRSF015919 :", 
                      "TIGR01145 : ATP_synt_delta", "SSF50182 : 0038611", "SSF52728 : 0041536", 
                      "SSF57038 : 0035547", "SSF47473 : 0035795", "PF02847 : MA3", 
                      "SSF50203 : 0053332", "SSF75217 : 0041137", "SSF49879 : 0041155", 
                      "SSF53092 : 0052071", "SSF49899 : 0044236", "PF01373 : Glyco_hydro_14", 
                      "SSF88645 : 0049320", "PF05001 : RNA_pol_Rpb1_R", "SSF53671 : 0042024", 
                      "SSF51096 : 0039560", "SSF64383 : 0037383", "SSF49899 : 0047089", 
                      "PF00005 : ABC_tran", "SSF47862 : 0041824", "SSF50729 : 0049788", 
                      "SSF90183 : 0043881", "SSF52540 : 0041074", "SSF54534 : 0038237", 
                      "SSF56214 : 0042951", "PF02595 : Gly_kinase", "SSF54686 : 0043512", 
                      "SSF46689 : 0035608", "SSF48208 : 0041306", "PF10277 : Frag1", 
                      "PF03949 : Malic_M", "SSF57095 : 0037633", "SSF46458 : 0049399", 
                      "SSF54631 : 0048351", "SSF54593 : 0037339", "SSF50952 : 0046203", 
                      "SSF51905 : 0044099", "PF00293 : NUDIX", "SSF50692 : 0053128", 
                      "SSF47699 : 0040393", "SSF54523 : 0041981", "SSF75005 : 0042078", 
                      "PF00903 : Glyoxalase", "SSF53056 : 0036375", "SSF52833 : 0049009", 
                      "PD184633 :", "SSF50729 : 0049787", "SSF54211 : 0041639", "SSF69848 : 0039469", 
                      "SSF81296 : 0046393", "PF05724 : TPMT", "PF00717 : Peptidase_S24", 
                      "SSF48508 : 0051122", "SSF56954 : 0037050", "SSF81327 : 0040125", 
                      "SSF56235 : 0043422", "PIRSF000546 :", "SSF47473 : 0038125", 
                      "SSF53706 : 0038360", "SSF48208 : 0049609", "SSF50353 : 0048450", 
                      "SSF48726 : 0037879", "PD207074 :", "SSF53850 : 0042048", "SSF55060 : 0047892", 
                      "SSF56176 : 0046490", "PF00351 : Biopterin_H", "SSF54452 : 0039955", 
                      "SSF46934 : 0044110", "SSF64397 : 0050323", "SSF82114 : 0041066", 
                      "SSF51735 : 0048227", "SSF54928 : 0050479", "SSF55205 : 0042868", 
                      "PR00082 : GLFDHDRGNASE", "SSF64397 : 0050281", "PF01040 : UbiA", 
                      "SSF53474 : 0047034", "SSF53738 : 0040057", "PF05811 : DUF842", 
                      "SSF51351 : 0035415", "SSF52490 : 0044122", "SSF56672 : 0049312", 
                      "SSF54277 : 0048553", "SSF52540 : 0052815", "PD002830 :", "SSF47396 : 0045103", 
                      "TIGR00049 : TIGR00049", "SSF55003 : 0037461", "SSF52172 : 0044060", 
                      "SSF52833 : 0035238", "SSF52374 : 0045477", "SSF52833 : 0034960", 
                      "SSF49384 : 0035121", "SSF56672 : 0049525", "SSF50475 : 0046934", 
                      "PS51193 : HELICASE_ATP_BIND_2", "SSF51366 : 0044091", "SSF49344 : 0049898", 
                      "SSF51445 : 0049842", "SSF49503 : 0038299", "SSF53383 : 0046584", 
                      "SSF48726 : 0044979", "SSF51351 : 0049668", "SSF56784 : 0043284", 
                      "PIRSF036773 :", "PF08740 : BCS1_N", "SSF48726 : 0037448", "SSF54416 : 0040242", 
                      "SSF55347 : 0038548", "SSF47933 : 0037969", "SSF54277 : 0046691", 
                      "SSF53098 : 0045815", "SSF52172 : 0045852", "PR00600 : PP2APR55", 
                      "SSF51713 : 0047415", "SSF57652 : 0039732", "SSF46689 : 0041825", 
                      "SSF57095 : 0047709", "TIGR01351 : adk", "SSF81324 : 0042184", 
                      "PR01546 : YEAST73DUF", "SSF50249 : 0039831", "SSF100950 : 0039928", 
                      "SSF56327 : 0047262", "PF08538 : DUF1749", "PF07555 : NAGidase", 
                      "SSF51219 : 0051361", "SSF48403 : 0045081", "SSF75217 : 0044237", 
                      "SSF51735 : 0053287", "SSF55729 : 0050733", "PF02800 : Gp_dh_C", 
                      "SSF51445 : 0037235", "SSF46609 : 0038984", "SSF55315 : 0038463", 
                      "SSF81585 : 0039638", "SSF51735 : 0053019", "SSF52833 : 0050957", 
                      "SSF55785 : 0044682", "SSF57095 : 0043800", "PF02881 : SRP54_N", 
                      "PF00221 : PAL", "SSF48726 : 0039721", "SSF56854 : 0042620", 
                      "SSF56235 : 0043434", "SSF100895 : 0045399", "SSF51126 : 0038938", 
                      "SSF64076 : 0051739", "SSF55008 : 0039798", "SSF51905 : 0045531", 
                      "PF00458 : WHEP-TRS", "SSF74650 : 0044349", "SSF46626 : 0037492", 
                      "SSF51735 : 0051109", "SSF53474 : 0049383", "SSF57424 : 0036124", 
                      "SSF46929 : 0036156", "SSF53850 : 0049726", "PF00647 : EF1G", 
                      "SSF110324 : 0044669", "SSF57302 : 0050121", "SSF47090 : 0049469", 
                      "SSF54637 : 0051976", "PF04402 : DUF541", "SSF56436 : 0036181", 
                      "PD114929 :", "SSF47836 : 0047937", "SSF50886 : 0037016", "PS50197 : BEACH", 
                      "SSF48239 : 0053305", "SSF52540 : 0047547", "SSF53671 : 0039731", 
                      "SSF50353 : 0042579", "SSF82544 : 0051940", "SSF48097 : 0037735", 
                      "SSF53474 : 0044405", "SSF57501 : 0038532", "SSF54060 : 0044201", 
                      "SSF57667 : 0052290", "SSF49401 : 0039425", "SSF48439 : 0036345", 
                      "SSF54593 : 0047984", "SSF51621 : 0045706", "SSF54452 : 0039865", 
                      "SSF49417 : 0034796", "PF04008 : DUF355", "SSF100950 : 0052833", 
                      "PR00390 : PHPHLIPASEC", "SSF54821 : 0037615", "SSF49503 : 0045671", 
                      "PF06645 : SPC12", "SSF111283 : 0044856", "SSF53335 : 0037952", 
                      "SSF109910 : 0042477", "SSF55973 : 0042856", "SSF52540 : 0041834", 
                      "SSF54334 : 0043755", "PD006364 :", "PR01158 : TOPISMRASEII", 
                      "SSF50729 : 0042372", "SSF48613 : 0047453", "SSF53850 : 0048733", 
                      "SSF69189 : 0044133", "SSF57850 : 0046745", "PS50095 : PLAT", 
                      "SSF49384 : 0043980", "SSF50494 : 0043619", "SSF53474 : 0048008", 
                      "SSF54791 : 0049699", "SSF55753 : 0036223", "TIGR00079 : pept_deformyl", 
                      "PF08669 : GCV_T_C", "SSF46626 : 0040303", "PF03761 : DUF316", 
                      "SSF100950 : 0040764", "SSF50494 : 0046306", "PF02290 : SRP14", 
                      "SSF53671 : 0040987", "SSF56194 : 0044562", "PF03813 : Nrap", 
                      "SSF54495 : 0051215", "PD005103 :", "PF10343 : DUF2419", "SSF48726 : 0043241", 
                      "SSF57440 : 0040395", "SSF52777 : 0042677", "SSF46689 : 0042229", 
                      "SSF52402 : 0039642", "SSF52309 : 0046731", "SSF48065 : 0035771", 
                      "SSF54928 : 0050804", "SSF52540 : 0043798", "SSF51338 : 0048114", 
                      "SSF52540 : 0049491", "SSF75217 : 0048429", "SSF46689 : 0048742", 
                      "SSF54427 : 0041124", "PR00509 : PGMPMM", "PF02301 : HORMA", 
                      "SSF89919 : 0042218", "SSF55008 : 0046867", "SSF46785 : 0037479", 
                      "SSF50978 : 0049784", "SSF53671 : 0036612", "SSF69819 : 0039787", 
                      "PF05257 : CHAP", "PF06371 : Drf_GBD", "SSF81531 : 0040340", 
                      "SSF51569 : 0048312", "SSF53067 : 0041304", "PF03874 : RNA_pol_Rpb4", 
                      "PF08300 : HCV_NS5a_1a", "SSF49899 : 0048987", "SSF52540 : 0045436", 
                      "PD001243 :", "SSF51445 : 0036870", "PF03177 : Nucleoporin", 
                      "SSF88697 : 0050744", "SSF69618 : 0039709", "SSF53218 : 0040986", 
                      "SSF47323 : 0034948", "PF02892 : zf-BED", "SSF46934 : 0042314", 
                      "SSF52172 : 0051859", "SSF56436 : 0038672", "SSF53649 : 0047177", 
                      "PF00102 : Y_phosphatase", "SSF51351 : 0040821", "SSF101420 : 0049250", 
                      "PD002239 :", "PD000609 :", "PF08662 : eIF2A", "SSF56003 : 0037702", 
                      "PF01094 : ANF_receptor", "SSF54373 : 0039759", "SSF103491 : 0043235", 
                      "SSF46458 : 0034871", "SSF53822 : 0039493", "SSF54292 : 0041225", 
                      "PR00191 : FACTINCAPA", "PF01612 : 3_5_exonuc", "SSF54631 : 0053231", 
                      "PF04417 : DUF501", "SSF53067 : 0051544", "SSF52972 : 0050260", 
                      "PF01608 : I_LWEQ", "PIRSF001235 :", "SSF57059 : 0041106", "SSF52096 : 0042618", 
                      "SSF52540 : 0048819", "SSF50494 : 0043683", "PS50947 : DDENN", 
                      "SSF56784 : 0050761", "SSF47954 : 0044902", "SSF52777 : 0051016", 
                      "SSF54211 : 0043358", "SSF51905 : 0040660", "SSF57924 : 0037913", 
                      "SSF57903 : 0050496", "SSF46458 : 0036640", "SSF54984 : 0045883", 
                      "SSF54665 : 0044865", "PF01214 : CK_II_beta", "SSF51126 : 0047142", 
                      "SSF47060 : 0034846", "SSF54680 : 0035686", "PF01469 : Pentapeptide_2", 
                      "PF03030 : H_PPase", "SSF48726 : 0040023", "SSF51182 : 0046598", 
                      "SSF54001 : 0052043", "SSF110997 : 0044517", "SSF49503 : 0040320", 
                      "PF07716 : bZIP_2", "SSF53335 : 0044550", "SSF52540 : 0050337", 
                      "SSF49384 : 0037243", "SSF48065 : 0036335", "SSF54593 : 0037337", 
                      "SSF57027 : 0045460", "SSF50494 : 0035861", "SSF52540 : 0043651", 
                      "SSF51971 : 0040620", "PF01894 : UPF0047", "SSF47769 : 0035350", 
                      "SSF88697 : 0038846", "SSF46919 : 0050613", "SSF46785 : 0040207", 
                      "PS50179 : VHS", "SSF54928 : 0039140", "SSF53328 : 0045289", 
                      "SSF52540 : 0036770", "PF10152 : DUF2360", "PD011090 :", "SSF54427 : 0040851", 
                      "SSF47413 : 0051234", "SSF50494 : 0037599", "SSF51658 : 0046285", 
                      "PF09716 : ETRAMP", "SSF48508 : 0051039", "SSF88633 : 0041373", 
                      "SSF49503 : 0050694", "SSF50494 : 0046356", "SSF48726 : 0036569", 
                      "PF01264 : Chorismate_synt", "PF08145 : BOP1NT", "SSF53187 : 0049011", 
                      "SSF53474 : 0035209", "PF01432 : Peptidase_M3", "SSF48201 : 0048823", 
                      "PS50096 : IQ", "TIGR02258 : 2_5_ligase", "SSF53659 : 0038679", 
                      "PF03870 : RNA_pol_Rpb8", "SSF46626 : 0047418", "SSF81901 : 0040147", 
                      "PR00984 : TRNASYNTHILE", "SSF48726 : 0046208", "SSF55008 : 0046107", 
                      "SSF51905 : 0050363", "PF06220 : zf-U1", "SSF50630 : 0036266", 
                      "SSF57196 : 0035940", "SSF53850 : 0051520", "PF01111 : CKS", 
                      "SSF47473 : 0047768", "SSF57770 : 0049234", "SSF101386 : 0052946", 
                      "SSF47565 : 0041953", "PIRSF002158 :", "SSF54909 : 0044097", 
                      "PF03091 : CutA1", "SSF50729 : 0042935", "PF01663 : Phosphodiest", 
                      "SSF51182 : 0051300", "SSF74924 : 0040606", "SSF51412 : 0047664", 
                      "PIRSF017190 :", "PF00573 : Ribosomal_L4", "SSF50814 : 0045526", 
                      "SSF51182 : 0045016", "PF00616 : RasGAP", "SSF57868 : 0045363", 
                      "SSF55681 : 0039382", "SSF57783 : 0042292", "SSF50494 : 0045328", 
                      "SSF51556 : 0047434", "SSF57059 : 0041765", "SSF88633 : 0039736", 
                      "SSF55729 : 0048084", "PIRSF028998 :", "SSF54928 : 0047845", 
                      "SSF49899 : 0040785", "PIRSF018169 :", "SSF51011 : 0042223", 
                      "SSF53098 : 0035463", "SSF48508 : 0040276", "PIRSF037504 :", 
                      "SSF53335 : 0038869", "PR00986 : TRNASYNTHVAL", "SSF81296 : 0040240", 
                      "SSF51351 : 0053375", "SSF48726 : 0042427", "SSF51905 : 0044942", 
                      "SSF51604 : 0052917", "SSF53748 : 0037808", "TIGR01053 : LSD1", 
                      "SSF52540 : 0043133", "SSF54277 : 0050609", "SSF54117 : 0042369", 
                      "SSF52540 : 0052002", "SSF57667 : 0050623", "PF03463 : eRF1_1", 
                      "PS50006 : FHA_DOMAIN", "SSF54768 : 0042361", "SSF53335 : 0038652", 
                      "SSF49265 : 0043952", "SSF46934 : 0050902", "SSF52058 : 0041263", 
                      "SSF51430 : 0048562", "SSF56235 : 0042626", "SSF47802 : 0036464", 
                      "PF10312 : Cactin_mid", "PF00498 : FHA", "SSF47240 : 0039590", 
                      "SSF47954 : 0035706", "SSF46785 : 0036614", "SSF56935 : 0045768", 
                      "SSF64167 : 0040392", "SSF50494 : 0043779", "TIGR02717 : AcCoA-syn-alpha", 
                      "PF01765 : RRF", "SSF51445 : 0036198", "SSF55729 : 0049338", 
                      "PR00060 : RIBOSOMALL16", "SSF51735 : 0044559", "SSF56219 : 0050453", 
                      "PF03974 : Ecotin", "SSF53098 : 0039215", "PF04756 : OST3_OST6", 
                      "SSF48576 : 0047573", "PF03063 : Prismane", "SSF46934 : 0035061", 
                      "SSF57716 : 0052315", "PIRSF003113 :", "SSF52121 : 0037034", 
                      "PF08235 : LNS2", "SSF52283 : 0036665", "PR00463 : EP450I", "PF04567 : RNA_pol_Rpb2_5", 
                      "SSF54637 : 0049325", "SSF81783 : 0039286", "SSF56371 : 0040546", 
                      "SSF48179 : 0042865", "PIRSF036578 :", "SSF100950 : 0040719", 
                      "SSF55729 : 0052908", "SSF52009 : 0047778", "PF00742 : Homoserine_dh", 
                      "SSF55961 : 0049728", "SSF49265 : 0035921", "SSF51126 : 0039752", 
                      "SSF52922 : 0035298", "SSF48208 : 0049995", "PR00706 : PYROGLUPTASE", 
                      "SSF47413 : 0053325", "SSF47240 : 0046379", "SSF50156 : 0047731", 
                      "PS50309 : DC", "SSF53448 : 0046833", "SSF56053 : 0037526", "SSF50692 : 0042560", 
                      "SSF52540 : 0043796", "PF00465 : Fe-ADH", "SSF51604 : 0052871", 
                      "PF02810 : SEC-C", "SSF53187 : 0040486", "PF00849 : PseudoU_synth_2", 
                      "SSF49452 : 0035978", "SSF53448 : 0050366", "SSF53633 : 0052050", 
                      "SSF55190 : 0039123", "SSF51735 : 0043840", "SSF51735 : 0036746", 
                      "SSF55895 : 0035593", "SSF52096 : 0041794", "TIGR01816 : sdhA_forward", 
                      "SSF54637 : 0049589", "PF02919 : Topoisom_I_N", "PF10396 : TrmE_N", 
                      "SSF50129 : 0044525", "SSF50729 : 0052195", "SSF57829 : 0043029", 
                      "SSF52440 : 0035375", "PF08161 : NUC173", "PF00154 : RecA", "SSF50156 : 0050550", 
                      "SSF53697 : 0047338", "SSF47413 : 0043492", "SSF54189 : 0051035", 
                      "PF04832 : SOUL", "SSF53254 : 0035570", "PR00344 : BCTRLSENSOR", 
                      "PF09830 : ATP_transf", "SSF55920 : 0041657", "SSF48371 : 0042701", 
                      "PF01412 : ArfGap", "PD289296 :", "SSF51556 : 0034875", "SSF49785 : 0047057", 
                      "SSF48034 : 0041181", "SSF51735 : 0041389", "SSF57552 : 0041221", 
                      "SSF46689 : 0040923", "PF01448 : ELM2", "SSF50084 : 0041806", 
                      "SSF56496 : 0040735", "PF10561 : UPF0565", "SSF48619 : 0036549", 
                      "SSF56425 : 0041342", "SSF47113 : 0035550", "PIRSF023381 :", 
                      "SSF52540 : 0043418", "SSF46785 : 0047523", "SSF55729 : 0046883", 
                      "SSF52540 : 0050095", "SSF56047 : 0038894", "SSF47823 : 0037652", 
                      "SSF46458 : 0042318", "SSF49764 : 0047015", "SSF49265 : 0037679", 
                      "SSF89942 : 0048731", "SSF52833 : 0042927", "SSF52540 : 0051459", 
                      "SSF55060 : 0041877", "SSF51735 : 0047470", "SSF101288 : 0043366", 
                      "SSF52467 : 0041747", "PF00889 : EF_TS", "PF03348 : Serinc", 
                      "PF05525 : Branch_AA_trans", "SSF48726 : 0038213", "SSF54160 : 0042283", 
                      "SSF53474 : 0049037", "PR01415 : ANKYRIN", "SSF56112 : 0041095", 
                      "SSF51735 : 0053363", "PIRSF002131 :", "SSF48670 : 0041928", 
                      "SSF54211 : 0036295", "SSF48264 : 0035710", "SSF53955 : 0035100", 
                      "SSF46785 : 0050578", "SSF64268 : 0038052", "SSF55120 : 0043816", 
                      "SSF48256 : 0035069", "SSF63562 : 0039237", "PF04241 : DUF423", 
                      "SSF47473 : 0037597", "SSF55821 : 0039907", "SSF101386 : 0044938", 
                      "PF04670 : Gtr1_RagA", "SSF55447 : 0049207", "SSF54098 : 0035034", 
                      "SSF100879 : 0049570", "PF03399 : SAC3_GANP", "SSF53383 : 0046007", 
                      "SSF51604 : 0051292", "PD020942 :", "PF08557 : Lipid_DES", "SSF51735 : 0048270", 
                      "SSF46689 : 0038060", "SSF51011 : 0044468", "SSF53671 : 0045166", 
                      "SSF52096 : 0052628", "SSF55331 : 0049293", "SSF52922 : 0042966", 
                      "SSF47729 : 0039024", "SSF52490 : 0043342", "PD005155 :", "SSF53659 : 0042461", 
                      "SSF52540 : 0036239", "SSF52833 : 0052451", "SSF47769 : 0043772", 
                      "SSF63515 : 0037951", "SSF51730 : 0035362", "TIGR02174 : CXXU_selWTH", 
                      "SSF82615 : 0040878", "SSF51569 : 0035351", "SSF54373 : 0038190", 
                      "SSF52540 : 0038794", "SSF46548 : 0038466", "SSF47576 : 0035551", 
                      "SSF56496 : 0040703", "SSF50044 : 0049376", "SSF50978 : 0037143", 
                      "SSF82199 : 0040991", "SSF55961 : 0051990", "PIRSF036893 :", 
                      "SSF55979 : 0036501", "SSF52113 : 0047914", "SSF102522 : 0043352", 
                      "SSF57059 : 0040191", "SSF55347 : 0047176", "SSF46785 : 0041686", 
                      "TIGR00518 : alaDH", "PIRSF009376 :", "PF01131 : Topoisom_bac", 
                      "PF08367 : M16C_assoc", "SSF57625 : 0036556", "SSF49695 : 0040847", 
                      "SSF49265 : 0037380", "SSF51621 : 0048498", "SSF81606 : 0034914", 
                      "SSF52540 : 0053170", "SSF55729 : 0051326", "SSF51621 : 0036440", 
                      "SSF56300 : 0043485", "SSF54452 : 0035039", "SSF52833 : 0042260", 
                      "SSF56854 : 0039890", "SSF50182 : 0047299", "SSF47686 : 0035961", 
                      "SSF50249 : 0045976", "SSF47380 : 0037387", "SSF52743 : 0044989", 
                      "SSF49899 : 0036248", "PR00981 : TRNASYNTHSER", "SSF90148 : 0041870", 
                      "SSF100950 : 0043684", "SSF52833 : 0051911", "SSF57716 : 0052405", 
                      "SSF54534 : 0042634", "SSF51430 : 0049985", "SSF55681 : 0046597", 
                      "PF00636 : Ribonuclease_3", "SSF48613 : 0043377", "SSF53335 : 0037721", 
                      "PF03147 : FDX-ACB", "SSF54236 : 0050620", "SSF46919 : 0044980", 
                      "SSF51011 : 0035508", "SSF47266 : 0036313", "SSF55021 : 0053149", 
                      "PF00326 : Peptidase_S9", "SSF88659 : 0049224", "PF04258 : Peptidase_A22B", 
                      "PD000497 :", "SSF56327 : 0034892", "SSF53254 : 0048439", "PF08094 : Toxin_24", 
                      "SSF82171 : 0041192", "SSF46977 : 0041340", "PIRSF016468 :", 
                      "SSF51366 : 0053293", "SSF46767 : 0048152", "PF05932 : CesT", 
                      "SSF109843 : 0043391", "SSF51735 : 0037437", "SSF54117 : 0041737", 
                      "PR00477 : PHGLYCKINASE", "SSF46934 : 0050615", "SSF57716 : 0050752", 
                      "SSF51735 : 0050203", "SSF50729 : 0041926", "SSF57196 : 0037555", 
                      "SSF47769 : 0049479", "SSF88802 : 0039129", "SSF54452 : 0049096", 
                      "SSF57501 : 0035126", "SSF51569 : 0041658", "SSF51182 : 0050205", 
                      "SSF57059 : 0048376", "PF01199 : Ribosomal_L34e", "SSF48225 : 0047864", 
                      "SSF50044 : 0049867", "SSF49562 : 0044591", "SSF57716 : 0041630", 
                      "SSF54160 : 0052490", "TIGR00001 : rpmI_bact", "SSF46785 : 0042157", 
                      "SSF53795 : 0047503", "PF01398 : Mov34", "SSF46626 : 0036446", 
                      "SSF53474 : 0050010", "PF00256 : L15", "SSF50475 : 0051821", 
                      "SSF49503 : 0035665", "PF05173 : DapB_C", "SSF49562 : 0053329", 
                      "SSF49373 : 0046663", "PIRSF000853 :", "SSF55781 : 0044759", 
                      "SSF52788 : 0051181", "SSF51011 : 0039440", "SSF53850 : 0047899", 
                      "SSF47353 : 0051231", "PF10263 : SprT-like", "PD009961 :", "SSF46626 : 0045077", 
                      "PF00832 : Ribosomal_L39", "SSF55021 : 0051307", "SSF52540 : 0045123", 
                      "PS51312 : SB", "SSF52821 : 0051399", "PS50159 : RIBOSOMAL_S13_2", 
                      "SSF57535 : 0046992", "SSF49899 : 0043474", "SSF53633 : 0052046", 
                      "SSF63380 : 0047554", "PF00560 : LRR_1", "SSF81296 : 0043776", 
                      "SSF54593 : 0048855", "SSF50129 : 0035924", "PS50035 : PLD", 
                      "SSF57783 : 0045108", "SSF47454 : 0043644", "SSF54098 : 0037705", 
                      "SSF51445 : 0040522", "PF06027 : DUF914", "SSF52335 : 0037994", 
                      "PF03371 : PRP38", "PIRSF000460 :", "SSF48726 : 0037372", "SSF56994 : 0040531", 
                      "TIGR00535 : SAM_DCase", "SSF47380 : 0038261", "SSF53474 : 0046573", 
                      "SSF51445 : 0050431", "SSF63380 : 0043659", "SSF48173 : 0042877", 
                      "SSF56176 : 0036837", "SSF51283 : 0052042", "PR00406 : CYTB5RDTASE", 
                      "PR01040 : TRNASYNTHTYR", "SSF51735 : 0038222", "SSF46785 : 0039537", 
                      "TIGR02433 : lysidine_TilS_C", "SSF56918 : 0041445", "SSF64397 : 0038755", 
                      "SSF88633 : 0046193", "SSF50729 : 0035165", "SSF48225 : 0048461", 
                      "SSF53335 : 0051944", "SSF51905 : 0046446", "SSF50630 : 0038981", 
                      "SSF56176 : 0041229", "SSF57586 : 0039629", "SSF57716 : 0052445", 
                      "PF01346 : FKBP_N", "SSF50630 : 0042452", "SSF88697 : 0052338", 
                      "SSF57196 : 0040141", "SSF51395 : 0044529", "PF00957 : Synaptobrevin", 
                      "SSF51713 : 0049115", "SSF54236 : 0050740", "SSF63411 : 0037288", 
                      "SSF46458 : 0037587", "SSF51735 : 0048454", "SSF57667 : 0045694", 
                      "SSF53795 : 0047552", "SSF49503 : 0047887", "SSF50494 : 0046511", 
                      "SSF52540 : 0036748", "SSF53383 : 0035401", "SSF54556 : 0036925", 
                      "SSF53137 : 0046396", "SSF46689 : 0051615", "SSF53067 : 0052947", 
                      "SSF52540 : 0048026", "SSF55620 : 0052840", "PF02319 : E2F_TDP", 
                      "PF04802 : DUF625", "SSF88697 : 0044608", "SSF50156 : 0049946", 
                      "SSF51246 : 0035374", "TIGR02345 : chap_CCT_eta", "SSF53335 : 0040816", 
                      "SSF53187 : 0052020", "SSF55154 : 0052645", "PF10274 : ParcG", 
                      "PF03446 : NAD_binding_2", "SSF81296 : 0052028", "PS51273 : GATASE_TYPE_1", 
                      "PF01326 : PPDK_N", "SSF57535 : 0038352", "SSF52058 : 0036217", 
                      "SSF50729 : 0040959", "SSF54117 : 0040916", "SSF55979 : 0045418", 
                      "SSF49899 : 0046337", "SSF51395 : 0044791", "PF09760 : Hid1", 
                      "PF00589 : Phage_integrase", "PF10237 : DPPF", "PF09387 : MRP", 
                      "PD329443 :", "SSF53671 : 0048182", "SSF81296 : 0046919", "SSF53383 : 0035689", 
                      "SSF103025 : 0050060", "SSF47836 : 0041011", "SSF51445 : 0036057", 
                      "PF04199 : Cyclase", "SSF88633 : 0045868", "SSF52141 : 0041892", 
                      "PIRSF017205 :", "SSF50729 : 0041561", "SSF47473 : 0048241", 
                      "SSF55486 : 0040267", "SSF53850 : 0039257", "PD000819 :", "SSF88688 : 0039849", 
                      "SSF50692 : 0047857", "PS50883 : EAL", "SSF54117 : 0043321", 
                      "SSF57716 : 0044540", "PF05863 : DUF850", "SSF54593 : 0043873", 
                      "TIGR00508 : bioA", "TIGR03422 : mito_frataxin", "SSF57716 : 0034931", 
                      "SSF51120 : 0038009", "SSF52833 : 0038099", "PF04695 : Pex14_N", 
                      "PF08239 : SH3_3", "SSF48264 : 0036106", "SSF54975 : 0050769", 
                      "PF01583 : APS_kinase", "SSF54675 : 0051267", "SSF52058 : 0039610", 
                      "SSF47240 : 0049309", "SSF53613 : 0051780", "SSF54403 : 0036624", 
                      "TIGR02151 : IPP_isom_2", "SSF57667 : 0049956", "SSF50044 : 0049926", 
                      "PF02350 : Epimerase_2", "SSF52980 : 0046325", "SSF53671 : 0045168", 
                      "PF10602 : RPN7", "SSF50978 : 0042310", "SSF54637 : 0051338", 
                      "PF08183 : SpoV", "SSF49879 : 0050719", "SSF50630 : 0040710", 
                      "SSF51011 : 0043664", "PF06732 : Pescadillo_N", "PS50050 : TNFR_NGFR_2", 
                      "SSF51735 : 0042866", "PF08032 : SpoU_sub_bind", "SSF52402 : 0041745", 
                      "TIGR01329 : cysta_beta_ly_E", "PD211126 :", "SSF56645 : 0049822", 
                      "SSF47741 : 0043857", "SSF54913 : 0053273", "SSF56601 : 0037151", 
                      "PF06218 : NPR2", "SSF49417 : 0045029", "PS50904 : PRELI_MSF1", 
                      "PR01547 : YEAST176DUF", "SSF50249 : 0049722", "PF02176 : zf-TRAF", 
                      "PF06414 : Zeta_toxin", "SSF55826 : 0036342", "SSF56601 : 0044134", 
                      "SSF49785 : 0043558", "SSF81296 : 0045945", "SSF54631 : 0051257", 
                      "SSF48557 : 0035400", "SSF50882 : 0043667", "SSF81469 : 0048980", 
                      "SSF51182 : 0049374", "PIRSF000389 :", "SSF57586 : 0036276", 
                      "SSF48726 : 0034916", "SSF46785 : 0042087", "SSF54862 : 0043229", 
                      "SSF47473 : 0049906", "SSF48371 : 0035395", "SSF54826 : 0043637", 
                      "SSF55718 : 0035842", "SSF46934 : 0052474", "SSF56235 : 0039169", 
                      "SSF56235 : 0043425", "SSF49265 : 0050818", "PF02197 : RIIa", 
                      "SSF47473 : 0053282", "SSF50203 : 0035850", "SSF82784 : 0044862", 
                      "PIRSF035805 :", "PF06831 : H2TH", "SSF54171 : 0036316", "PS51133 : ZF_TFIIS_2", 
                      "SSF54523 : 0041982", "PS51157 : ZF_UBR", "SSF47729 : 0036536", 
                      "SSF46458 : 0044617", "SSF51445 : 0047117", "SSF53271 : 0037906", 
                      "SSF50475 : 0053062", "SSF52833 : 0040257", "SSF53697 : 0041028", 
                      "SSF48726 : 0050133", "SSF56601 : 0046422", "SSF54523 : 0052938", 
                      "SSF57501 : 0037644", "PF01655 : Ribosomal_L32e", "SSF57095 : 0045342", 
                      "PIRSF000416 :", "SSF46626 : 0046407", "SSF81338 : 0037828", 
                      "SSF57196 : 0048292", "PF05671 : GETHR", "SSF48256 : 0045234", 
                      "SSF48508 : 0035697", "SSF57716 : 0050813", "SSF50939 : 0050334", 
                      "PF00675 : Peptidase_M16", "SSF63380 : 0035106", "PF04992 : RNA_pol_Rpb1_6", 
                      "SSF56235 : 0039158", "SSF109732 : 0044339", "TIGR00737 : nifR3_yhdG", 
                      "SSF51905 : 0049222", "PF00010 : HLH", "PF02515 : CoA_transf_3", 
                      "SSF49503 : 0037814", "SSF54001 : 0048105", "SSF51735 : 0046367", 
                      "TIGR00418 : thrS", "PD011819 :", "SSF52833 : 0048033", "SSF47699 : 0048296", 
                      "SSF53756 : 0048983", "SSF51283 : 0037202", "SSF47413 : 0044906", 
                      "SSF109797 : 0051995", "SSF46609 : 0039179", "PIRSF006615 :", 
                      "SSF88633 : 0038778", "PF01602 : Adaptin_N", "SSF50814 : 0047874", 
                      "SSF52266 : 0044801", "SSF50729 : 0050772", "PF01019 : G_glu_transpept", 
                      "SSF51735 : 0052978", "SSF47598 : 0035318", "PS50258 : LNR", 
                      "SSF51735 : 0041868", "SSF53613 : 0051760", "PF10296 : DUF2404", 
                      "PF04124 : Dor1", "PF10431 : ClpB_D2-small", "SSF57774 : 0045789", 
                      "PF00089 : Trypsin", "SSF51569 : 0050143", "SSF46548 : 0048346", 
                      "TIGR01965 : VCBS_repeat", "SSF47661 : 0043526", "SSF50156 : 0050857", 
                      "SSF53649 : 0037019", "SSF52954 : 0040151", "SSF51735 : 0051006", 
                      "SSF46966 : 0049303", "SSF50249 : 0048844", "SSF50249 : 0049427", 
                      "SSF53067 : 0053028", "SSF56176 : 0037317", "TIGR00068 : glyox_I", 
                      "PS50865 : ZF_MYND_2", "PR00789 : OSIALOPTASE", "PF04508 : Pox_A_type_inc", 
                      "SSF52540 : 0045606", "PIRSF036565 :", "SSF52402 : 0047035", 
                      "PR00833 : POAALLERGEN", "SSF50370 : 0044697", "SSF48264 : 0041802", 
                      "SSF47266 : 0045338", "SSF100895 : 0039232", "SSF81901 : 0047832", 
                      "SSF46785 : 0048143", "SSF52058 : 0048505", "PF00612 : IQ", "SSF56529 : 0041525", 
                      "PS51294 : HTH_MYB", "SSF49319 : 0045761", "SSF52833 : 0042047", 
                      "SSF54928 : 0044194", "SSF54001 : 0048477", "PF02005 : TRM", 
                      "PF05756 : S-antigen", "SSF48113 : 0036112", "SSF53335 : 0051657", 
                      "SSF53850 : 0036541", "SSF50022 : 0052006", "SSF46689 : 0050780", 
                      "SSF51735 : 0046059", "SSF52833 : 0052617", "PD103294 :", "SSF48695 : 0047103", 
                      "TIGR01302 : IMP_dehydrog", "SSF48403 : 0045139", "SSF56672 : 0050972", 
                      "SSF57501 : 0045009", "SSF53335 : 0048490", "SSF55021 : 0051984", 
                      "PF10255 : Paf67", "PR00110 : ALPHAAMYLASE", "PF00324 : AA_permease", 
                      "SSF55895 : 0039111", "SSF51735 : 0042107", "PF02628 : COX15-CtaA", 
                      "PR01165 : CYCOXIDASEI", "SSF57903 : 0041001", "SSF51445 : 0038194", 
                      "PF03178 : CPSF_A", "SSF63600 : 0038441", "SSF57302 : 0034988", 
                      "SSF53335 : 0048805", "SSF81296 : 0049432", "SSF48179 : 0035534", 
                      "SSF52440 : 0038908", "SSF50729 : 0049561", "SSF52402 : 0044854", 
                      "SSF49265 : 0045282", "SSF48726 : 0037855", "SSF57662 : 0036453", 
                      "SSF49354 : 0040380", "SSF54001 : 0046780", "SSF51366 : 0038867", 
                      "SSF53335 : 0038933", "PF02786 : CPSase_L_D2", "PF00875 : DNA_photolyase", 
                      "SSF46785 : 0051354", "SSF51445 : 0036998", "SSF48334 : 0036747", 
                      "PF03101 : FAR1", "PF00098 : zf-CCHC", "SSF54001 : 0039885", 
                      "SSF56059 : 0038243", "SSF47616 : 0035412", "SSF47113 : 0038979", 
                      "SSF54637 : 0039324", "SSF57095 : 0048744", "SSF53067 : 0050788", 
                      "SSF81648 : 0044721", "SSF46589 : 0037028", "SSF49265 : 0050827", 
                      "PF00984 : UDPG_MGDP_dh", "PF02460 : Patched", "SSF49493 : 0041449", 
                      "SSF55874 : 0042491", "PIRSF008716 :", "SSF49695 : 0035560", 
                      "SSF51011 : 0046151", "SSF48726 : 0044741", "SSF53955 : 0045677", 
                      "SSF55681 : 0037938", "SSF55753 : 0040776", "PIRSF000484 :", 
                      "SSF51905 : 0037441", "PS50966 : ZF_SWIM", "PF00847 : AP2", "SSF50044 : 0045834", 
                      "PIRSF002394 :", "SSF52374 : 0041579", "SSF51366 : 0048768", 
                      "PF05041 : Pecanex_C", "SSF55347 : 0039601", "SSF46934 : 0042545", 
                      "SSF52096 : 0050305", "SSF46785 : 0039991", "SSF57095 : 0035045", 
                      "SSF101546 : 0043320", "PF05047 : L51_S25_CI-B8", "SSF51230 : 0038716", 
                      "SSF54913 : 0048471", "SSF46689 : 0052249", "SSF54719 : 0038283", 
                      "SSF57716 : 0050812", "PF06425 : Psf3", "SSF57667 : 0052919", 
                      "SSF53383 : 0035846", "PIRSF038027 :", "SSF50475 : 0051825", 
                      "SSF46626 : 0046488", "SSF54928 : 0046794", "SSF50729 : 0044624", 
                      "TIGR01647 : ATPase-IIIA_H", "PIRSF001771 :", "SSF55120 : 0042443", 
                      "SSF54403 : 0052022", "SSF50044 : 0047507", "SSF53335 : 0040197", 
                      "SSF56399 : 0051835", "SSF53474 : 0037013", "PS50217 : BZIP", 
                      "SSF53335 : 0049885", "TIGR03304 : OMP85_target", "SSF49899 : 0053179", 
                      "SSF57903 : 0038788", "SSF47175 : 0039442", "SSF47699 : 0046805", 
                      "SSF56219 : 0038542", "PR00980 : TRNASYNTHALA", "SSF51649 : 0045664", 
                      "SSF52540 : 0042735", "SSF49785 : 0050642", "SSF52096 : 0039881", 
                      "SSF46689 : 0047583", "PF00191 : Annexin", "SSF103165 : 0043297", 
                      "SSF56327 : 0045622", "SSF54593 : 0049535", "SSF109604 : 0043926", 
                      "SSF53383 : 0041260", "SSF50729 : 0048603", "PF10417 : 1-cysPrx_C", 
                      "SSF51445 : 0036797", "PF00022 : Actin", "SSF54427 : 0051680", 
                      "SSF48613 : 0051692", "SSF53383 : 0035246", "SSF47917 : 0037819", 
                      "SSF46458 : 0040508", "SSF46785 : 0045862", "SSF50891 : 0052507", 
                      "SSF47014 : 0037147", "SSF57247 : 0048766", "SSF55753 : 0043781", 
                      "SSF88633 : 0048972", "TIGR03297 : Ppyr-DeCO2ase", "PF02256 : Fe_hyd_SSU", 
                      "SSF50386 : 0045831", "SSF51971 : 0048016", "SSF51735 : 0049357", 
                      "SSF55271 : 0037232", "PF08295 : HDAC_interact", "SSF55729 : 0051377", 
                      "SSF49373 : 0036178", "SSF57302 : 0050068", "SSF47473 : 0041978", 
                      "SSF57196 : 0043808", "SSF47216 : 0035229", "SSF53474 : 0042339", 
                      "SSF48600 : 0052401", "SSF49562 : 0039924", "SSF57196 : 0040565", 
                      "SSF52113 : 0047091", "SSF49899 : 0037395", "SSF46600 : 0036773", 
                      "SSF54211 : 0034909", "SSF50249 : 0052237", "SSF56784 : 0051495", 
                      "SSF47203 : 0036987", "PF01055 : Glyco_hydro_31", "PD155499 :", 
                      "SSF51735 : 0043337", "SSF53850 : 0046371", "PF02368 : Big_2", 
                      "SSF56204 : 0041316", "SSF48498 : 0052878", "SSF109604 : 0044798", 
                      "SSF52768 : 0044998", "SSF55979 : 0035249", "SSF57262 : 0036695", 
                      "SSF54762 : 0036838", "SSF49785 : 0041602", "SSF46785 : 0044089", 
                      "SSF56574 : 0035196", "SSF57667 : 0035556", "SSF49695 : 0034863", 
                      "SSF49265 : 0038841", "SSF54236 : 0038417", "PF10270 : Tmemb_32", 
                      "SSF51604 : 0048445", "PR00298 : CHAPERONIN60", "PS50818 : INTEIN_C_TER", 
                      "SSF50203 : 0040146", "PD013253 :", "SSF55326 : 0043866", "SSF52540 : 0051551", 
                      "PD006931 :", "SSF53795 : 0035264", "PF00004 : AAA", "PR00615 : CCAATSUBUNTA", 
                      "PR00724 : CRBOXYPTASEC", "SSF56512 : 0040714", "SSF53271 : 0047309", 
                      "SSF52210 : 0052286", "PF07942 : N2227", "SSF55486 : 0036505", 
                      "SSF47592 : 0045079", "PF04622 : ERG2_Sigma1R", "PIRSF001386 :", 
                      "SSF49899 : 0041913", "PF04641 : DUF602", "SSF52218 : 0043299", 
                      "SSF51905 : 0048866", "SSF52799 : 0041855", "SSF57059 : 0042725", 
                      "PF07738 : Sad1_UNC", "SSF56752 : 0034852", "SSF48464 : 0037260", 
                      "SSF53383 : 0038056", "SSF57016 : 0038568", "SSF55931 : 0036128", 
                      "SSF49503 : 0048779", "SSF46785 : 0038616", "SSF46785 : 0049796", 
                      "SSF51412 : 0035077", "SSF56672 : 0046174", "SSF63748 : 0052416", 
                      "SSF103007 : 0047498", "TIGR01473 : cyoE_ctaB", "SSF52047 : 0045193", 
                      "SSF88802 : 0047416", "SSF55144 : 0037760", "PF00722 : Glyco_hydro_16", 
                      "SSF89009 : 0038768", "SSF56672 : 0041005", "SSF52402 : 0048369", 
                      "SSF63562 : 0038875", "PD096294 :", "SSF53098 : 0044818", "PD001278 :", 
                      "PF07967 : zf-C3HC", "PF07581 : Glug", "PF08839 : CDT1", "SSF54427 : 0052008", 
                      "SSF63411 : 0038683", "SSF53474 : 0036166", "SSF51556 : 0045709", 
                      "SSF52540 : 0051458", "SSF55315 : 0049200", "SSF54236 : 0040913", 
                      "PF01281 : Ribosomal_L9_N", "SSF88723 : 0044668", "SSF53383 : 0045973", 
                      "SSF52540 : 0036153", "SSF47413 : 0051388", "PF02222 : ATP-grasp", 
                      "SSF52743 : 0038019", "TIGR02729 : Obg_CgtA", "SSF53187 : 0038334", 
                      "SSF47807 : 0035545", "PF04114 : Gaa1", "SSF51569 : 0051933", 
                      "PF05493 : ATP_synt_H", "SSF52943 : 0040865", "SSF54211 : 0037014", 
                      "SSF54358 : 0042305", "PF06859 : Bin3", "SSF54814 : 0038592", 
                      "SSF54791 : 0047512", "PF05909 : IWS1_C", "SSF51905 : 0048583", 
                      "PF02178 : AT_hook", "PR00417 : PRTPISMRASEI", "SSF47917 : 0036812", 
                      "SSF48726 : 0041945", "SSF53098 : 0035416", "SSF74788 : 0047960", 
                      "SSF46689 : 0048818", "SSF55753 : 0038372", "SSF53067 : 0038603", 
                      "SSF51182 : 0053268", "SSF57850 : 0046140", "SSF53067 : 0049109", 
                      "PF10191 : COG7", "SSF51445 : 0052125", "SSF56784 : 0052740", 
                      "PIRSF027110 :", "SSF63380 : 0048947", "SSF55753 : 0040022", 
                      "PF00908 : dTDP_sugar_isom", "SSF56371 : 0034985", "SSF55811 : 0050821", 
                      "SSF51905 : 0038798", "SSF52540 : 0035814", "SSF49723 : 0045089", 
                      "PF06026 : Rib_5-P_isom_A", "SSF51735 : 0049942", "SSF57196 : 0036621", 
                      "SSF56281 : 0046465", "SSF47473 : 0049328", "SSF56059 : 0039113", 
                      "PF08743 : Nse4", "SSF56327 : 0041769", "SSF75689 : 0039947", 
                      "PF00298 : Ribosomal_L11", "SSF53335 : 0047329", "SSF51445 : 0046948", 
                      "SSF101690 : 0043841", "SSF57716 : 0043116", "SSF47384 : 0052096", 
                      "SSF51735 : 0035477", "SSF50249 : 0049790", "SSF46785 : 0037718", 
                      "PS51275 : PEPTIDASE_C26_GGH", "SSF51182 : 0042373", "SSF49899 : 0051707", 
                      "SSF48726 : 0037724", "SSF50729 : 0048782", "PF06100 : Strep_67kDa_ant", 
                      "SSF50129 : 0045640", "SSF53383 : 0048571", "SSF52980 : 0045917", 
                      "PF10404 : BHD_2", "SSF54452 : 0037792", "SSF89817 : 0042122", 
                      "SSF57048 : 0046074", "SSF55486 : 0035195", "TIGR01423 : trypano_reduc", 
                      "SSF55550 : 0037781", "SSF54637 : 0046093", "SSF75005 : 0052539", 
                      "SSF55658 : 0036448", "SSF47836 : 0034915", "SSF64043 : 0038570", 
                      "SSF57889 : 0042462", "SSF54236 : 0045716", "SSF51445 : 0052376", 
                      "PIRSF006060 :", "SSF52540 : 0045860", "SSF53850 : 0042201", 
                      "SSF50486 : 0043481", "SSF50044 : 0048550", "SSF54909 : 0047284", 
                      "SSF57184 : 0039016", "SSF51905 : 0041885", "SSF56300 : 0045823", 
                      "SSF52540 : 0044631", "TIGR00165 : S18", "SSF51351 : 0049680", 
                      "SSF56281 : 0044896", "PS51003 : CYTB_CTER", "PF06984 : MRP-L47", 
                      "SSF53822 : 0036537", "PF01261 : AP_endonuc_2", "SSF53613 : 0039806", 
                      "SSF57492 : 0036858", "SSF47203 : 0045539", "SSF48726 : 0047906", 
                      "PF09371 : Tex_N", "SSF81585 : 0045993", "PD009170 :", "SSF51905 : 0042233", 
                      "SSF56935 : 0034817", "SSF46966 : 0049794", "SSF53067 : 0046240", 
                      "SSF54452 : 0043108", "PR00348 : UBIQUITIN", "SSF56601 : 0048423", 
                      "SSF63411 : 0039094", "TIGR00323 : eIF-6", "PD009396 :", "SSF55931 : 0052576", 
                      "SSF52440 : 0048058", "SSF54334 : 0037097", "PF02148 : zf-UBP", 
                      "SSF57535 : 0051921", "SSF100950 : 0040763", "PD000355 :", "SSF56235 : 0039159", 
                      "SSF56327 : 0050213", "PIRSF018497 :", "SSF51338 : 0051352", 
                      "SSF46785 : 0052514", "PF00626 : Gelsolin", "SSF50494 : 0048133", 
                      "SSF57027 : 0037358", "SSF54060 : 0036822", "SSF49835 : 0040127", 
                      "SSF48726 : 0050941", "PF06087 : Tyr-DNA_phospho", "TIGR00384 : dhsB", 
                      "PF01498 : Transposase_5", "SSF102405 : 0043844", "TIGR02081 : metW", 
                      "SSF48208 : 0044515", "SSF52218 : 0046705", "SSF46458 : 0038917", 
                      "SSF53383 : 0035871", "SSF56176 : 0047282", "SSF50494 : 0040858", 
                      "SSF54292 : 0045218", "SSF54358 : 0048158", "SSF51011 : 0046504", 
                      "SSF63411 : 0039429", "SSF51445 : 0044817", "SSF55620 : 0047499", 
                      "SSF52172 : 0036341", "SSF46934 : 0050150", "PF01280 : Ribosomal_L19e", 
                      "SSF47741 : 0049209", "SSF55174 : 0040244", "PF10219 : DUF2055", 
                      "TIGR01382 : PfpI", "PF00118 : Cpn60_TCP1", "SSF88645 : 0048006", 
                      "SSF49503 : 0047780", "SSF46458 : 0046284", "SSF50494 : 0043595", 
                      "SSF53300 : 0042550", "SSF51735 : 0051327", "PR01551 : SPO11HOMOLOG", 
                      "PF00297 : Ribosomal_L3", "SSF49503 : 0051775", "PF00871 : Acetate_kinase", 
                      "SSF48726 : 0050598", "SSF49401 : 0048741", "SSF57095 : 0049361", 
                      "PS50968 : BIOTINYL_LIPOYL", "PF09750 : DRY_EERY", "PIRSF002144 :", 
                      "SSF111321 : 0045039", "SSF53850 : 0047313", "SSF50630 : 0045441", 
                      "SSF57095 : 0042587", "SSF47473 : 0044365", "SSF49562 : 0043369", 
                      "SSF75445 : 0040720", "PF09799 : Transmemb_17", "SSF47616 : 0038270", 
                      "SSF49265 : 0050830", "PS51285 : AGC_KINASE_CTER", "SSF56784 : 0049203", 
                      "SSF46626 : 0035824", "PF08583 : Cmc1", "SSF57716 : 0040768", 
                      "PD013434 :", "SSF100985 : 0042478", "SSF46458 : 0040219", "SSF51735 : 0047263", 
                      "SSF101744 : 0041974", "SSF74650 : 0038422", "SSF47240 : 0044816", 
                      "SSF51338 : 0038136", "SSF57501 : 0040137", "SSF55874 : 0035757", 
                      "SSF51445 : 0045947", "SSF55729 : 0053259", "PF05380 : Peptidase_A17", 
                      "PF00463 : ICL", "SSF50814 : 0051321", "SSF48726 : 0038555", 
                      "PIRSF005198 :", "SSF50729 : 0042703", "SSF52540 : 0047933", 
                      "SSF56601 : 0045586", "SSF56371 : 0043991", "SSF49785 : 0053078", 
                      "SSF74650 : 0052583", "SSF51182 : 0043706", "SSF63380 : 0046600", 
                      "SSF52540 : 0041617", "SSF48726 : 0040598", "PF02472 : ExbD", 
                      "SSF52540 : 0039039", "TIGR00484 : EF-G", "SSF57059 : 0048932", 
                      "SSF57756 : 0045753", "SSF50182 : 0046262", "SSF69917 : 0039855", 
                      "SSF88633 : 0045603", "SSF50203 : 0048031", "SSF49785 : 0038886", 
                      "SSF57716 : 0036936", "SSF54292 : 0046762", "SSF49354 : 0050581", 
                      "SSF47240 : 0052977", "SSF51338 : 0051378", "SSF52833 : 0050985", 
                      "SSF54495 : 0047549", "SSF56235 : 0052428", "PR01224 : DELTATUBULIN", 
                      "SSF57829 : 0037552", "SSF57850 : 0050433", "SSF49785 : 0038642", 
                      "SSF81296 : 0035507", "PF05184 : SapB_1", "SSF52540 : 0037958", 
                      "SSF100879 : 0047594", "SSF54358 : 0046757", "PF01937 : DUF89", 
                      "SSF47769 : 0044485", "PF04750 : Far-17a_AIG1", "SSF53300 : 0048147", 
                      "SSF88633 : 0041857", "PF00333 : Ribosomal_S5", "SSF48619 : 0037909", 
                      "SSF48179 : 0052836", "SSF54373 : 0052601", "SSF51735 : 0041596", 
                      "SSF47565 : 0036557", "SSF54236 : 0048335", "SSF52440 : 0047047", 
                      "SSF50182 : 0047980", "SSF52467 : 0047535", "SSF56601 : 0046438", 
                      "SSF52518 : 0035517", "SSF53098 : 0042797", "PF05577 : Peptidase_S28", 
                      "SSF53167 : 0051268", "SSF51182 : 0036421", "PS50860 : AA_TRNA_LIGASE_II_ALA", 
                      "SSF53474 : 0042747", "SSF52418 : 0047803", "SSF49503 : 0035908", 
                      "SSF55315 : 0049508", "SSF52121 : 0035826", "SSF52540 : 0045383", 
                      "SSF51735 : 0044044", "SSF52540 : 0052098", "SSF50044 : 0047748", 
                      "SSF56436 : 0040502", "SSF49764 : 0050540", "SSF49785 : 0048554", 
                      "PR00624 : HISTONEH5", "PIRSF001348 :", "SSF51206 : 0046232", 
                      "SSF49785 : 0044443", "SSF46565 : 0048279", "SSF51621 : 0036701", 
                      "SSF56349 : 0035020", "SSF82754 : 0040745", "SSF56024 : 0035785", 
                      "SSF49899 : 0038601", "SSF50118 : 0053339", "SSF50494 : 0038086", 
                      "SSF54189 : 0043514", "PR00146 : DHPICSNTHASE", "SSF48065 : 0050917", 
                      "SSF52467 : 0051273", "PR00180 : CRETINALDHBP", "SSF51717 : 0049727", 
                      "SSF53254 : 0047369", "SSF46934 : 0038998", "PR00987 : TRNASYNTHGLU", 
                      "SSF48726 : 0049830", "SSF47113 : 0041191", "SSF53335 : 0052894", 
                      "SSF54928 : 0050512", "SSF51556 : 0038137", "SSF51161 : 0049600", 
                      "SSF52821 : 0044242", "SSF48484 : 0041261", "SSF49265 : 0037683", 
                      "SSF64307 : 0039497", "TIGR00112 : proC", "PF02969 : TAF", "SSF54211 : 0042329", 
                      "SSF47616 : 0034807", "SSF51126 : 0035062", "SSF53383 : 0047670", 
                      "SSF51905 : 0035330", "SSF46458 : 0035981", "SSF57196 : 0039882", 
                      "SSF53474 : 0048003", "SSF52096 : 0039416", "SSF63491 : 0044404", 
                      "SSF53474 : 0044833", "SSF57667 : 0035441", "PF08477 : Miro", 
                      "SSF46689 : 0052250", "SSF88874 : 0038451", "SSF57059 : 0048710", 
                      "TIGR03182 : PDH_E1_alph_y", "SSF56436 : 0035579", "SSF50494 : 0049010", 
                      "SSF48726 : 0037355", "SSF63600 : 0038442", "PF08790 : zf-LYAR", 
                      "SSF82714 : 0039247", "SSF51735 : 0050247", "SSF54719 : 0040124", 
                      "SSF53743 : 0037785", "SSF51735 : 0047847", "SSF51445 : 0043920", 
                      "PF00810 : ER_lumen_recept", "SSF50465 : 0043132", "SSF53720 : 0050666", 
                      "SSF54452 : 0038943", "PF06203 : CCT", "SSF50814 : 0049055", 
                      "SSF55298 : 0039489", "SSF51735 : 0042180", "SSF50249 : 0036753", 
                      "TIGR00116 : tsf", "SSF53649 : 0036916", "SSF53067 : 0039963", 
                      "SSF48081 : 0036801", "PD004816 :", "SSF51717 : 0045781", "PF01269 : Fibrillarin", 
                      "TIGR02227 : sigpep_I_bact", "SSF48726 : 0049642", "PF01728 : FtsJ", 
                      "SSF46689 : 0047439", "SSF50044 : 0049890", "SSF55681 : 0052835", 
                      "SSF48613 : 0050729", "SSF52317 : 0041222", "SSF50939 : 0040109", 
                      "SSF51126 : 0036933", "SSF56300 : 0045596", "PR00160 : GLUTAREDOXIN", 
                      "SSF50370 : 0043723", "SSF49503 : 0045210", "SSF82649 : 0041151", 
                      "SSF53098 : 0046085", "SSF53474 : 0045756", "PIRSF017179 :", 
                      "SSF63748 : 0048669", "SSF51182 : 0039765", "SSF52540 : 0043876", 
                      "PF01243 : Pyridox_oxidase", "PF01105 : EMP24_GP25L", "SSF51735 : 0045031", 
                      "SSF57027 : 0047151", "SSF54236 : 0050629", "SSF49562 : 0044352", 
                      "SSF52833 : 0041722", "SSF54160 : 0050790", "SSF50044 : 0043613", 
                      "SSF55608 : 0036397", "PD106810 :", "SSF48652 : 0037997", "TIGR00389 : glyS_dimeric", 
                      "SSF57567 : 0035914", "SSF51905 : 0046416", "SSF52540 : 0052859", 
                      "SSF49503 : 0038298", "SSF52833 : 0051931", "PS51043 : DDHD", 
                      "SSF57302 : 0037520", "TIGR00032 : argG", "SSF53067 : 0051661", 
                      "SSF88688 : 0041728", "SSF57667 : 0041311", "SSF53901 : 0048944", 
                      "SSF54637 : 0052559", "SSF57095 : 0045842", "PF06367 : Drf_FH3", 
                      "SSF51556 : 0039934", "SSF53335 : 0049532", "SSF55550 : 0034940", 
                      "SSF54292 : 0049210", "SSF51735 : 0046635", "SSF51735 : 0049519", 
                      "SSF47370 : 0046469", "SSF63737 : 0038696", "SSF53901 : 0040003", 
                      "SSF55729 : 0038108", "PIRSF500153 :", "SSF47473 : 0041808", 
                      "SSF49503 : 0038247", "SSF53335 : 0044380", "PF00917 : MATH", 
                      "PF09793 : AD", "SSF52833 : 0048990", "SSF50993 : 0042746", "TIGR01958 : nuoE_fam", 
                      "SSF54001 : 0044406", "SSF109885 : 0049410", "SSF46785 : 0042079", 
                      "SSF52833 : 0052770", "SSF51989 : 0044056", "SSF49899 : 0042784", 
                      "SSF49785 : 0047719", "SSF46929 : 0047467", "SSF55550 : 0035513", 
                      "SSF49742 : 0051313", "SSF51735 : 0038824", "SSF50494 : 0044104", 
                      "SSF88633 : 0045869", "PIRSF009998 :", "SSF57059 : 0047849", 
                      "SSF103196 : 0047508", "SSF49265 : 0047337", "SSF49265 : 0050505", 
                      "PF02965 : Met_synt_B12", "PS50025 : LAM_G_DOMAIN", "SSF52058 : 0041267", 
                      "SSF53474 : 0042002", "SSF50156 : 0050507", "SSF51905 : 0048607", 
                      "PF05299 : Peptidase_M61", "SSF47014 : 0037141", "PS50255 : CYTOCHROME_B5_2", 
                      "SSF53067 : 0049498", "SSF53474 : 0040862", "SSF55347 : 0038332", 
                      "SSF52540 : 0048436", "SSF57667 : 0043978", "SSF52540 : 0041807", 
                      "SSF57924 : 0042700", "PF00789 : UBX", "SSF51905 : 0047682", 
                      "PR00032 : HTHARAC", "PD024629 :", "SSF52833 : 0043163", "SSF57362 : 0039476", 
                      "SSF46785 : 0042770", "TIGR03595 : Obg_CgtA_exten", "SSF52172 : 0045682", 
                      "SSF100950 : 0042240", "SSF52799 : 0041856", "SSF88633 : 0044050", 
                      "PR00103 : CAMPKINASE", "SSF56112 : 0039145", "SSF52518 : 0042965", 
                      "SSF57716 : 0048881", "SSF48439 : 0046281", "SSF51569 : 0051114", 
                      "SSF52343 : 0053272", "SSF81296 : 0042348", "SSF53474 : 0047940", 
                      "SSF54791 : 0052297", "SSF53850 : 0052589", "SSF50249 : 0048176", 
                      "SSF48371 : 0043817", "SSF52374 : 0039032", "SSF52518 : 0044101", 
                      "SSF89837 : 0049879", "SSF53067 : 0052751", "PF00135 : COesterase", 
                      "PIRSF000779 :", "SSF47699 : 0048161", "SSF54928 : 0050477", 
                      "SSF49417 : 0038119", "SSF46984 : 0046764", "SSF49265 : 0035255", 
                      "PD002841 :", "SSF81296 : 0039645", "SSF57924 : 0042068", "PF06246 : Isy1", 
                      "PF00429 : TLV_coat", "PF04678 : DUF607", "PD093343 :", "PF02151 : UVR", 
                      "SSF52833 : 0043130", "PF01422 : zf-NF-X1", "SSF51735 : 0040810", 
                      "SSF47113 : 0052078", "PR01245 : RAD1REC1", "PF09285 : Elong-fact-P_C", 
                      "SSF48208 : 0050704", "SSF56529 : 0043774", "SSF47819 : 0050708", 
                      "SSF50249 : 0037626", "SSF50729 : 0037213", "SSF82549 : 0042544", 
                      "SSF47188 : 0045324", "PF01512 : Complex1_51K", "SSF57868 : 0039376", 
                      "PF03945 : Endotoxin_N", "SSF56112 : 0046180", "SSF81508 : 0037296", 
                      "PIRSF002181 :", "SSF46689 : 0052496", "SSF48726 : 0045932", 
                      "SSF46609 : 0035695", "SSF48371 : 0047129", "SSF50044 : 0036795", 
                      "SSF81624 : 0036935", "PF00248 : Aldo_ket_red", "SSF53697 : 0049747", 
                      "SSF82057 : 0040857", "SSF56276 : 0040932", "SSF88633 : 0045464", 
                      "SSF102414 : 0043318", "PF08240 : ADH_N", "TIGR01639 : P_fal_TIGR01639", 
                      "SSF47694 : 0045397", "SSF56112 : 0042918", "SSF54001 : 0037324", 
                      "SSF46689 : 0036604", "SSF56235 : 0039160", "SSF53335 : 0050749", 
                      "SSF51045 : 0036697", "SSF53901 : 0049763", "PF08598 : Sds3", 
                      "SSF47240 : 0044715", "SSF52540 : 0051510", "SSF49417 : 0041370", 
                      "PF10294 : Methyltransf_16", "PF02545 : Maf", "PD000094 :", "SSF52540 : 0035301", 
                      "SSF47973 : 0039141", "SSF55550 : 0039796", "SSF49503 : 0044586", 
                      "SSF52833 : 0045521", "SSF50814 : 0036126", "SSF51645 : 0041255", 
                      "SSF53150 : 0036749", "PF00404 : Dockerin_1", "PF01532 : Glyco_hydro_47", 
                      "SSF53187 : 0050951", "PF03308 : ArgK", "SSF56399 : 0048582", 
                      "PF03671 : UPF0185", "PF01546 : Peptidase_M20", "PF01391 : Collagen", 
                      "SSF101690 : 0043154", "SSF49503 : 0044584", "SSF54593 : 0046683", 
                      "SSF81502 : 0042673", "PS50923 : SUSHI", "SSF49899 : 0040108", 
                      "SSF51011 : 0038047", "PF07940 : Hepar_II_III", "SSF54913 : 0048636", 
                      "SSF54928 : 0045479", "SSF57652 : 0045317", "SSF101307 : 0044043", 
                      "PF05285 : SDA1", "SSF55550 : 0042706", "SSF47616 : 0039277", 
                      "PF05700 : BCAS2", "SSF90188 : 0049461", "SSF54593 : 0043178", 
                      "PR01399 : ENTSNTHTASED", "SSF49777 : 0037630", "SSF49373 : 0046226", 
                      "SSF55257 : 0035473", "SSF53659 : 0044867", "SSF47473 : 0045726", 
                      "PF00766 : ETF_alpha", "PD031313 :", "SSF48726 : 0036563", "PR00453 : VWFADOMAIN", 
                      "SSF47090 : 0040394", "SSF50814 : 0043017", "SSF55447 : 0043861", 
                      "SSF54001 : 0040313", "PF07808 : RED_N", "SSF53927 : 0039755", 
                      "SSF51055 : 0035067", "SSF49503 : 0053158", "SSF49503 : 0040014", 
                      "SSF57552 : 0040378", "SSF82185 : 0038399", "SSF51984 : 0048687", 
                      "SSF51445 : 0040789", "SSF52540 : 0052879", "SSF51011 : 0052584", 
                      "SSF63411 : 0048873", "SSF49899 : 0041681", "SSF51905 : 0041022", 
                      "SSF54928 : 0041653", "SSF53850 : 0035308", "SSF57774 : 0035085", 
                      "PF01746 : tRNA_m1G_MT", "SSF51338 : 0040834", "SSF54511 : 0040194", 
                      "SSF53335 : 0041593", "SSF53649 : 0039941", "SSF47413 : 0051711", 
                      "SSF50182 : 0047853", "SSF53098 : 0044173", "PIRSF005963 :", 
                      "SSF63748 : 0047119", "TIGR00653 : GlnA", "SSF46458 : 0040157", 
                      "SSF54675 : 0053068", "SSF82708 : 0050562", "SSF54373 : 0047713", 
                      "SSF50249 : 0051418", "PF00281 : Ribosomal_L5", "TIGR00502 : nagB", 
                      "SSF49899 : 0045782", "SSF48239 : 0046282", "SSF46626 : 0035863", 
                      "SSF48350 : 0044148", "SSF48726 : 0042571", "TIGR00040 : yfcE", 
                      "SSF57362 : 0036599", "PF03987 : Autophagy_C", "SSF47240 : 0041079", 
                      "PF02872 : 5_nucleotid_C", "SSF52980 : 0040166", "SSF48695 : 0038266", 
                      "SSF48371 : 0049893", "SSF55008 : 0045769", "PR00006 : COFILIN", 
                      "PF04113 : Gpi16", "PS50979 : BC", "SSF46458 : 0046359", "SSF48726 : 0041959", 
                      "SSF47954 : 0035065", "SSF56281 : 0051980", "SSF55729 : 0049032", 
                      "SSF51126 : 0045985", "SSF52799 : 0046846", "SSF53335 : 0046923", 
                      "SSF56112 : 0038940", "SSF88659 : 0043328", "SSF48695 : 0048634", 
                      "SSF75011 : 0039675", "SSF47473 : 0047571", "SSF56634 : 0038517", 
                      "SSF49265 : 0043971", "SSF57059 : 0040433", "SSF54001 : 0051746", 
                      "SSF50151 : 0035213", "SSF47473 : 0046726", "SSF52096 : 0050306", 
                      "SSF52949 : 0048378", "SSF48726 : 0037979", "SSF55620 : 0049105", 
                      "SSF53155 : 0048994", "PD968187 :", "PS50991 : PYR_CT", "SSF48201 : 0042473", 
                      "PF03900 : Porphobil_deamC", "SSF52540 : 0043011", "PF09791 : Oxidored-like", 
                      "TIGR01008 : rpsC_E_A", "SSF54637 : 0042390", "PF04729 : ASF1_hist_chap", 
                      "SSF46626 : 0045678", "PF00580 : UvrD-helicase", "PF10559 : Plug_translocon", 
                      "SSF53850 : 0038458", "SSF51604 : 0040131", "PF00625 : Guanylate_kin", 
                      "PF01764 : Lipase_3", "SSF51395 : 0051489", "TIGR01694 : MTAP", 
                      "SSF49899 : 0038204", "PS50033 : UBX", "PD001086 :", "SSF57095 : 0035333", 
                      "SSF51905 : 0050961", "SSF49785 : 0041690", "SSF54211 : 0037595", 
                      "SSF48371 : 0037915", "SSF50104 : 0050864", "SSF52540 : 0038674", 
                      "PF10032 : Pho88", "SSF47587 : 0034839", "SSF52980 : 0051030", 
                      "SSF53383 : 0049754", "SSF52833 : 0051913", "SSF51419 : 0045930", 
                      "PD009163 :", "SSF56601 : 0046008", "SSF54909 : 0042653", "SSF48403 : 0039901", 
                      "SSF48726 : 0042160", "SSF56176 : 0037703", "PR00415 : ACONITASE", 
                      "SSF81431 : 0041788", "SSF48726 : 0037402", "SSF68906 : 0040017", 
                      "SSF52833 : 0039073", "SSF52218 : 0044023", "SSF52172 : 0042126", 
                      "SSF48230 : 0043392", "PD024971 :", "PIRSF005894 :", "PF02683 : DsbD", 
                      "SSF109885 : 0043635", "SSF50729 : 0051750", "SSF56059 : 0045447", 
                      "SSF52029 : 0039107", "SSF48726 : 0039132", "TIGR02432 : lysidine_TilS_N", 
                      "PF02689 : Herpes_Helicase", "SSF47565 : 0043139", "PF00084 : Sushi", 
                      "PF04212 : MIT", "PF03660 : PHF5", "SSF53383 : 0045392", "TIGR00461 : gcvP", 
                      "SSF46785 : 0038673", "SSF51658 : 0035755", "SSF51445 : 0048418", 
                      "SSF49265 : 0034837", "SSF57440 : 0042382", "SSF46689 : 0053132", 
                      "PF08445 : FR47", "SSF53706 : 0036504", "SSF57392 : 0035053", 
                      "SSF55486 : 0035660", "PF00530 : SRCR", "SSF56317 : 0037433", 
                      "SSF53686 : 0050081", "SSF51905 : 0038797", "SSF51735 : 0038711", 
                      "PF00317 : Ribonuc_red_lgN", "SSF101420 : 0043390", "PF05033 : Pre-SET", 
                      "SSF57059 : 0050082", "SSF54928 : 0052442", "PD003114 :", "PF00254 : FKBP_C", 
                      "SSF53623 : 0039393", "SSF51569 : 0052702", "PR00038 : HTHLUXR", 
                      "PF08597 : eIF3_subunit", "SSF56601 : 0043333", "SSF53335 : 0044197", 
                      "SSF56371 : 0042803", "SSF53300 : 0039774", "SSF46458 : 0043696", 
                      "SSF51110 : 0036490", "SSF48150 : 0045145", "SSF52151 : 0041454", 
                      "SSF54236 : 0040411", "PF03999 : MAP65_ASE1", "PR01452 : NOTCH", 
                      "SSF52833 : 0038306", "SSF50800 : 0034866", "SSF56371 : 0042475", 
                      "SSF50156 : 0040319", "PF09736 : DUF2050", "SSF63418 : 0036832", 
                      "SSF50104 : 0043291", "SSF51735 : 0036331", "SSF81698 : 0052247", 
                      "PS50934 : SWIRM", "SSF51351 : 0041019", "SSF51045 : 0048391", 
                      "SSF48726 : 0041090", "SSF47413 : 0044558", "SSF48452 : 0049644", 
                      "PF01873 : eIF-5_eIF-2B", "SSF57095 : 0043570", "TIGR01169 : rplA_bact", 
                      "SSF48726 : 0047982", "SSF53795 : 0040080", "SSF48208 : 0038366", 
                      "SSF56327 : 0047991", "SSF48726 : 0039061", "SSF48498 : 0052394", 
                      "PIRSF002401 :", "PF06427 : UDP-g_GGTase", "SSF75217 : 0048501", 
                      "SSF54001 : 0051855", "SSF88633 : 0037726", "SSF81886 : 0041441", 
                      "SSF54285 : 0049740", "SSF50729 : 0036672", "SSF53187 : 0051051", 
                      "SSF51445 : 0050643", "PF02966 : DIM1", "PF00428 : Ribosomal_60s", 
                      "SSF74650 : 0039850", "SSF46626 : 0042874", "SSF109604 : 0049430", 
                      "SSF52467 : 0039421", "SSF56281 : 0045185", "SSF53756 : 0042456", 
                      "PF01869 : BcrAD_BadFG", "SSF54980 : 0046824", "SSF55347 : 0047635", 
                      "SSF48619 : 0044904", "PF01047 : MarR", "SSF63829 : 0052901", 
                      "PIRSF022993 :", "SSF53671 : 0036611", "SSF47616 : 0040721", 
                      "SSF57770 : 0042948", "SSF55424 : 0037510", "SSF52047 : 0042312", 
                      "SSF63491 : 0048100", "PD068376 :", "PF03034 : PSS", "SSF53474 : 0035282", 
                      "PF00586 : AIRS", "SSF52540 : 0037359", "SSF48208 : 0040358", 
                      "PR01712 : ALPHAGIARDIN", "SSF54117 : 0045309", "SSF47954 : 0039605", 
                      "SSF53383 : 0045300", "SSF49367 : 0044922", "PIRSF028980 :", 
                      "PR01503 : TREACLE", "SSF63748 : 0051936", "SSF89975 : 0041238", 
                      "SSF48726 : 0044978", "SSF55811 : 0041034", "PF02162 : XYPPX", 
                      "SSF48173 : 0039138", "SSF46966 : 0036159", "SSF55486 : 0040001", 
                      "SSF52833 : 0036725", "SSF50044 : 0051651", "PF09732 : CactinC_cactus", 
                      "SSF51658 : 0050979", "SSF56059 : 0046656", "PF10601 : zf-LITAF-like", 
                      "PF08327 : AHSA1", "SSF51735 : 0036488", "SSF56112 : 0039792", 
                      "SSF51569 : 0050339", "SSF48726 : 0037299", "PR00081 : GDHRDH", 
                      "PF01124 : MAPEG", "PD007270 :", "PS50199 : ZF_RANBP2_2", "SSF52161 : 0039344", 
                      "SSF47473 : 0043372", "SSF56399 : 0039412", "PF00480 : ROK", 
                      "PF03800 : Nuf2", "PF05915 : DUF872", "SSF46579 : 0046875", "SSF51735 : 0047742", 
                      "SSF88697 : 0051817", "SSF54001 : 0052181", "SSF48552 : 0035618", 
                      "PF05783 : DLIC", "SSF53474 : 0040760", "SSF51338 : 0040031", 
                      "SSF54966 : 0052387", "SSF50156 : 0044399", "SSF53098 : 0044767", 
                      "SSF48371 : 0051211", "PF00630 : Filamin", "SSF53223 : 0036929", 
                      "SSF48726 : 0042751", "TIGR02429 : pcaI_scoA_fam", "PF00182 : Glyco_hydro_19", 
                      "SSF111331 : 0044184", "SSF53927 : 0051560", "SSF52096 : 0052608", 
                      "PF04930 : FUN14", "SSF51395 : 0047242", "SSF52540 : 0043985", 
                      "SSF54189 : 0037544", "SSF50249 : 0047019", "SSF63411 : 0047225", 
                      "TIGR01163 : rpe", "SSF51735 : 0050235", "SSF52518 : 0042964", 
                      "SSF55770 : 0045097", "SSF64076 : 0052790", "SSF54001 : 0046688", 
                      "SSF63411 : 0035449", "SSF49503 : 0053157", "PF01704 : UDPGP", 
                      "SSF48695 : 0038331", "SSF48557 : 0045086", "SSF53659 : 0044771", 
                      "SSF50249 : 0036423", "SSF52343 : 0035107", "PS50918 : WWE", 
                      "SSF47473 : 0048211", "SSF52833 : 0052945", "SSF55846 : 0049494", 
                      "PIRSF016323 :", "SSF55205 : 0043215", "SSF55486 : 0049043", 
                      "SSF57586 : 0049385", "SSF56796 : 0044872", "TIGR00675 : dcm", 
                      "SSF51735 : 0050228", "PF08263 : LRRNT_2", "SSF53383 : 0047581", 
                      "SSF57440 : 0035938", "PF01058 : Oxidored_q6", "SSF50090 : 0036454", 
                      "SSF56235 : 0048784", "SSF50891 : 0051043", "SSF48452 : 0045692", 
                      "SSF55486 : 0036884", "SSF57667 : 0034823", "SSF46689 : 0045635", 
                      "PD323026 :", "SSF57567 : 0035191", "PF05014 : Nuc_deoxyrib_tr", 
                      "PF01535 : PPR", "SSF47413 : 0045855", "PIRSF500170 :", "SSF52113 : 0038346", 
                      "SSF47266 : 0045527", "SSF53686 : 0050075", "PF01062 : Bestrophin", 
                      "SSF56568 : 0042777", "SSF51283 : 0042623", "SSF50129 : 0046724", 
                      "SSF55103 : 0038830", "SSF47240 : 0041078", "SSF46785 : 0044604", 
                      "SSF50151 : 0040348", "SSF55073 : 0035279", "SSF54862 : 0036609", 
                      "SSF54117 : 0038729", "PF02260 : FATC", "SSF47769 : 0052591", 
                      "SSF46689 : 0050913", "SSF53254 : 0043334", "SSF49373 : 0046664", 
                      "SSF50182 : 0040799", "SSF46626 : 0047100", "SSF51045 : 0049648", 
                      "SSF54106 : 0051227", "SSF52777 : 0036871", "SSF51351 : 0044082", 
                      "PF00217 : ATP-gua_Ptrans", "SSF81660 : 0044221", "SSF53671 : 0051827", 
                      "PF06093 : Spt4", "SSF55826 : 0044834", "SSF48726 : 0038775", 
                      "TIGR01798 : cit_synth_I", "PS50268 : CADHERIN_2", "SSF55729 : 0052040", 
                      "SSF48726 : 0037791", "PIRSF004749 :", "SSF51126 : 0047350", 
                      "SSF48619 : 0046918", "SSF50156 : 0035495", "SSF49384 : 0043055", 
                      "SSF54928 : 0037833", "SSF56534 : 0042325", "SSF52374 : 0050045", 
                      "PF00833 : Ribosomal_S17e", "SSF57095 : 0035985", "PF08746 : zf-RING-like", 
                      "SSF54117 : 0034819", "TIGR00147 : TIGR00147", "SSF51905 : 0053321", 
                      "SSF81342 : 0040212", "SSF52335 : 0034968", "SSF53732 : 0040390", 
                      "SSF50044 : 0042504", "PF03727 : Hexokinase_2", "PD025185 :", 
                      "SSF46458 : 0036100", "SSF50249 : 0037641", "SSF81296 : 0046892", 
                      "SSF49265 : 0046532", "SSF56994 : 0040150", "SSF74650 : 0046376", 
                      "SSF52518 : 0049968", "SSF48678 : 0036951", "SSF56327 : 0040466", 
                      "SSF54001 : 0052526", "SSF49503 : 0047347", "PF07391 : NPR", 
                      "PF01051 : Rep_3", "SSF52833 : 0039301", "PF07928 : Vps54", "PF08507 : COPI_assoc", 
                      "PF02065 : Melibiase", "PS51113 : ZF_BTK", "SSF51182 : 0041675", 
                      "PIRSF002162 :", "SSF49785 : 0040408", "SSF53383 : 0045639", 
                      "SSF55620 : 0050120", "SSF50037 : 0037827", "SSF48695 : 0037766", 
                      "SSF52833 : 0052893", "PD119426 :", "SSF52016 : 0040389", "SSF57783 : 0041574", 
                      "SSF48239 : 0045458", "SSF53697 : 0048203", "TIGR00310 : ZPR1_znf", 
                      "SSF88633 : 0046636", "SSF53067 : 0051549", "SSF52954 : 0050705", 
                      "SSF50692 : 0046362", "SSF52980 : 0038589", "SSF55811 : 0050219", 
                      "PF03357 : ESCRT-III", "SSF53659 : 0048816", "PD125763 :", "SSF57774 : 0045124", 
                      "SSF57059 : 0036070", "SSF52540 : 0043528", "PIRSF025024 :", 
                      "SSF51126 : 0036334", "SSF52833 : 0048740", "SSF48726 : 0042961", 
                      "SSF53474 : 0047627", "PIRSF006609 :", "PIRSF001594 :", "SSF52374 : 0036094", 
                      "SSF53383 : 0043852", "SSF81296 : 0052398", "SSF52029 : 0047016", 
                      "SSF57667 : 0034825", "SSF53155 : 0043582", "SSF81343 : 0041345", 
                      "SSF56436 : 0039984", "SSF56399 : 0037313", "SSF57903 : 0050591", 
                      "PF03962 : Mnd1", "PD216885 :", "SSF57196 : 0048204", "SSF53067 : 0045070", 
                      "SSF52087 : 0041714", "SSF69060 : 0039968", "PS50267 : NA_NEUROTRAN_SYMP_3", 
                      "SSF51658 : 0042974", "PF06079 : Apyrase", "PF05983 : MED7", 
                      "SSF50249 : 0035051", "SSF51735 : 0044247", "SSF56091 : 0049580", 
                      "PD170000 :", "SSF51011 : 0043161", "SSF55729 : 0051421", "SSF53720 : 0041670", 
                      "SSF54001 : 0047662", "SSF46609 : 0041142", "SSF47769 : 0043788", 
                      "SSF53927 : 0044981", "SSF55469 : 0041335", "SSF48726 : 0048325", 
                      "SSF54826 : 0048606", "PIRSF037759 :", "SSF53271 : 0041576", 
                      "TIGR02506 : NrdE_NrdA", "SSF81296 : 0038520", "SSF50405 : 0046323", 
                      "PF10508 : Proteasom_PSMB", "PF02115 : Rho_GDI", "SSF55469 : 0051432", 
                      "SSF69203 : 0041447", "SSF51366 : 0049922", "SSF55811 : 0051868", 
                      "SSF63748 : 0047802", "SSF53681 : 0039203", "PR00598 : HTHMARR", 
                      "SSF56731 : 0036366", "SSF53597 : 0035127", "SSF51120 : 0039942", 
                      "PS51063 : HTH_CRP_2", "SSF53850 : 0051127", "SSF51011 : 0052912", 
                      "SSF51246 : 0044850", "SSF56399 : 0053230", "PS50166 : IMPORTIN_B_NT", 
                      "SSF57802 : 0052486", "SSF47175 : 0036105", "SSF47954 : 0037917", 
                      "SSF54913 : 0044419", "PD021825 :", "SSF54211 : 0043250", "SSF51735 : 0051797", 
                      "SSF47353 : 0052699", "PD004122 :", "PF01613 : Flavin_Reduct", 
                      "SSF57716 : 0036002", "SSF52402 : 0036964", "SSF52425 : 0049782", 
                      "SSF55550 : 0053301", "SSF46458 : 0050016", "SSF52833 : 0034808", 
                      "SSF50090 : 0044781", "SSF50249 : 0048841", "PD009834 :", "PF05093 : DUF689", 
                      "PF00009 : GTP_EFTU", "SSF57863 : 0036355", "SSF55874 : 0051393", 
                      "SSF53448 : 0044747", "SSF52540 : 0039424", "SSF52540 : 0050361", 
                      "SSF49503 : 0040030", "SSF53850 : 0044486", "SSF54236 : 0050067", 
                      "SSF52374 : 0043997", "SSF51445 : 0038608", "SSF54452 : 0046112", 
                      "SSF53448 : 0043493", "PF05653 : DUF803", "SSF50353 : 0039074", 
                      "SSF52540 : 0043440", "SSF49899 : 0037101", "PF00077 : RVP", 
                      "SSF56059 : 0036618", "SSF47986 : 0037465", "TIGR03594 : GTPase_EngA", 
                      "SSF52949 : 0051619", "SSF51735 : 0036806", "SSF56276 : 0047616", 
                      "SSF52317 : 0043819", "SSF53067 : 0035529", "SSF50729 : 0036571", 
                      "PF07971 : Glyco_hydro_92", "SSF48431 : 0040642", "PF02195 : ParBc", 
                      "PF06733 : DEAD_2", "SSF56601 : 0035703", "SSF52402 : 0051645", 
                      "TIGR00152 : TIGR00152", "SSF57586 : 0043594", "SSF47370 : 0047674", 
                      "SSF50044 : 0047663", "SSF55811 : 0041520", "SSF55331 : 0038336", 
                      "SSF54211 : 0052561", "SSF103263 : 0043034", "SSF54285 : 0046674", 
                      "SSF48695 : 0045503", "SSF57262 : 0046434", "SSF56112 : 0041592", 
                      "SSF46626 : 0038389", "SSF56994 : 0045535", "PF04791 : LMBR1", 
                      "SSF47095 : 0047052", "SSF56112 : 0041048", "SSF57716 : 0052318", 
                      "TIGR00107 : deoD", "SSF74650 : 0048510", "SSF55729 : 0043487", 
                      "SSF52833 : 0051671", "SSF50494 : 0042928", "PF00258 : Flavodoxin_1", 
                      "SSF48726 : 0037854", "SSF52317 : 0040432", "SSF51905 : 0043577", 
                      "SSF47031 : 0048168", "SSF53098 : 0044000", "PD001589 :", "SSF51735 : 0036579", 
                      "SSF50974 : 0042881", "PD008866 :", "PF04561 : RNA_pol_Rpb2_2", 
                      "SSF50129 : 0046252", "PF00542 : Ribosomal_L12", "SSF51905 : 0041940", 
                      "SSF46997 : 0049607", "SSF46689 : 0046025", "SSF55620 : 0035367", 
                      "SSF51556 : 0035514", "SSF52540 : 0052502", "PF00939 : Na_sulph_symp", 
                      "SSF48726 : 0039659", "SSF48726 : 0048319", "PF00180 : Iso_dh", 
                      "SSF54862 : 0046874", "PF04127 : DFP", "SSF57095 : 0049375", 
                      "SSF57277 : 0037896", "PD140898 :", "SSF69635 : 0039894", "PF07321 : YscO", 
                      "SSF53720 : 0037193", "SSF56601 : 0052534", "SSF51604 : 0036897", 
                      "SSF51338 : 0041367", "SSF54292 : 0037561", "SSF50249 : 0049051", 
                      "PF01293 : PEPCK_ATP", "PF02269 : TFIID-18kDa", "SSF57362 : 0039152", 
                      "SSF56112 : 0041315", "PF02926 : THUMP", "SSF53335 : 0045537", 
                      "PF01805 : Surp", "PF01154 : HMG_CoA_synt_N", "SSF52413 : 0041101", 
                      "SSF50729 : 0048923", "SSF51703 : 0046111", "PF01653 : DNA_ligase_aden", 
                      "SSF46785 : 0053261", "SSF55486 : 0045583", "PIRSF000882 :", 
                      "SSF102405 : 0053289", "SSF48371 : 0042090", "SSF47598 : 0036063", 
                      "SSF50249 : 0047828", "PD126251 :", "SSF57535 : 0038525", "PF01358 : PARP_regulatory", 
                      "SSF100897 : 0042346", "SSF88723 : 0049616", "SSF57095 : 0046400", 
                      "SSF74924 : 0052210", "SSF55486 : 0042596", "SSF55620 : 0043717", 
                      "SSF53067 : 0052627", "SSF55874 : 0038465", "SSF53448 : 0041930", 
                      "SSF49354 : 0048218", "SSF57424 : 0044680", "PS51015 : YDG", 
                      "SSF57392 : 0036766", "SSF52540 : 0042581", "SSF51569 : 0041700", 
                      "SSF51569 : 0050239", "SSF53448 : 0037282", "SSF51735 : 0036194", 
                      "SSF53223 : 0040549", "SSF109775 : 0043810", "SSF51395 : 0052610", 
                      "SSF53098 : 0052515", "SSF57016 : 0037095", "SSF48034 : 0037876", 
                      "PF10406 : TAF8_C", "SSF57095 : 0034998", "SSF53335 : 0047923", 
                      "SSF52121 : 0040328", "SSF51735 : 0044357", "SSF54928 : 0042860", 
                      "SSF88723 : 0049935", "PIRSF036949 :", "SSF54236 : 0051792", 
                      "SSF52218 : 0045274", "PIRSF037506 :", "SSF57535 : 0036033", 
                      "SSF50998 : 0047121", "SSF46458 : 0035972", "SSF56574 : 0043572", 
                      "SSF56935 : 0046462", "SSF56784 : 0051888", "PF05608 : DUF778", 
                      "SSF49319 : 0045787", "PF00637 : Clathrin", "SSF55031 : 0046135", 
                      "PF08450 : SGL", "SSF52172 : 0048465", "SSF47113 : 0049584", 
                      "SSF48264 : 0042421", "SSF51182 : 0051250", "SSF82171 : 0048632", 
                      "PS50188 : B302_SPRY", "SSF57829 : 0039574", "SSF57535 : 0042990", 
                      "PF07264 : EI24", "PF03571 : Peptidase_M49", "SSF51905 : 0040035", 
                      "SSF54416 : 0037057", "SSF53254 : 0037864", "SSF52540 : 0040826", 
                      "SSF57829 : 0047598", "SSF53955 : 0039048", "SSF55315 : 0036589", 
                      "SSF48726 : 0049278", "SSF48034 : 0048060", "SSF54117 : 0040943", 
                      "SSF47986 : 0036193", "SSF88645 : 0040716", "SSF52935 : 0050265", 
                      "PF06624 : RAMP4", "SSF57095 : 0041144", "SSF48726 : 0047998", 
                      "SSF48726 : 0047419", "SSF54826 : 0040132", "SSF49417 : 0044533", 
                      "SSF54768 : 0052443", "SSF52540 : 0050061", "PF00567 : TUDOR", 
                      "SSF56796 : 0047854", "SSF52799 : 0049772", "SSF55874 : 0052097", 
                      "SSF48726 : 0048267", "SSF48592 : 0034906", "SSF48508 : 0043281", 
                      "SSF54928 : 0050567", "SSF57095 : 0047977", "PF07522 : DRMBL", 
                      "SSF50129 : 0040476", "SSF51430 : 0035889", "SSF52425 : 0048411", 
                      "TIGR03412 : iscX_yfhJ", "SSF47148 : 0036948", "SSF46785 : 0043553", 
                      "SSF50249 : 0042019", "SSF53850 : 0047371", "SSF51735 : 0036744", 
                      "PF00634 : BRCA2", "PS50114 : GATA_ZN_FINGER_2", "PF06644 : ATP11", 
                      "PD363422 :", "SSF56112 : 0036846", "SSF52540 : 0046442", "PF05186 : Dpy-30", 
                      "SSF48726 : 0037973", "SSF54358 : 0046754", "PF10283 : zf-CCHH", 
                      "SSF51649 : 0043188", "SSF48452 : 0037493", "SSF51569 : 0044932", 
                      "SSF52833 : 0036992", "SSF47598 : 0045226", "PR01038 : TRNASYNTHARG", 
                      "PS50158 : ZF_CCHC", "SSF50249 : 0050616", "PF06999 : Suc_Fer-like", 
                      "SSF51161 : 0040122", "PIRSF038170 :", "PF03462 : PCRF", "SSF88713 : 0053198", 
                      "SSF54897 : 0039699", "SSF46689 : 0043355", "SSF51569 : 0041890", 
                      "SSF57716 : 0052407", "PF02878 : PGM_PMM_I", "SSF55469 : 0052748", 
                      "SSF55464 : 0042148", "SSF47823 : 0053344", "SSF47819 : 0052226", 
                      "SSF46785 : 0037340", "SSF51679 : 0048037", "SSF52218 : 0043195", 
                      "SSF49695 : 0038408", "SSF49899 : 0040231", "SSF69635 : 0044114", 
                      "SSF52343 : 0045409", "SSF55486 : 0041503", "SSF46458 : 0047160", 
                      "SSF46689 : 0034886", "SSF63411 : 0045925", "SSF46785 : 0043758", 
                      "SSF53187 : 0044762", "PF01480 : PWI", "SSF46689 : 0045901", 
                      "SSF101152 : 0049093", "SSF51905 : 0042576", "SSF88697 : 0041612", 
                      "SSF52540 : 0049838", "SSF51735 : 0047979", "PD039427 :", "SSF53474 : 0049631", 
                      "PF01507 : PAPS_reduct", "SSF48726 : 0050595", "SSF51735 : 0051491", 
                      "SSF89957 : 0050222", "PF01208 : URO-D", "PD003489 :", "SSF56784 : 0048396", 
                      "SSF52016 : 0050083", "SSF54427 : 0044427", "PF02213 : GYF", 
                      "SSF69065 : 0039529", "PD322775 :", "PD353566 :", "SSF52440 : 0047049", 
                      "PF04893 : Yip1", "PF01369 : Sec7", "SSF102114 : 0041914", "SSF49749 : 0038767", 
                      "SSF55729 : 0045389", "SSF57829 : 0052971", "SSF101478 : 0043888", 
                      "SSF53927 : 0037995", "SSF56672 : 0044175", "SSF46785 : 0043213", 
                      "SSF56399 : 0038240", "PF00072 : Response_reg", "PF04679 : DNA_ligase_A_C", 
                      "SSF51735 : 0047955", "SSF53335 : 0046696", "SSF54427 : 0042608", 
                      "SSF54211 : 0050450", "SSF51230 : 0035479", "SSF57095 : 0043549", 
                      "SSF81660 : 0049472", "PR00932 : AMINO1PTASE", "SSF69304 : 0039879", 
                      "PF04064 : DUF384", "SSF56436 : 0044527", "SSF89000 : 0043725", 
                      "SSF54966 : 0046037", "SSF82199 : 0048183", "PF01113 : DapB_N", 
                      "SSF88633 : 0036873", "PIRSF028836 :", "SSF50891 : 0051149", 
                      "SSF48695 : 0046855", "PIRSF006704 :", "SSF51011 : 0046454", 
                      "SSF55257 : 0038895", "TIGR01392 : homoserO_Ac_trn", "PF01148 : CTP_transf_1", 
                      "SSF51011 : 0044371", "PF02750 : Synapsin_C", "SSF56436 : 0051409", 
                      "SSF53383 : 0036013", "SSF52833 : 0037455", "SSF51989 : 0052059", 
                      "SSF47095 : 0053174", "PS50168 : DED", "SSF53067 : 0046053", 
                      "SSF49265 : 0038949", "PF10288 : DUF2392", "SSF48179 : 0050268", 
                      "SSF48557 : 0049554", "SSF51011 : 0052124", "SSF51717 : 0037422", 
                      "PF08766 : DEK_C", "PF00471 : Ribosomal_L33", "SSF54719 : 0035152", 
                      "SSF49899 : 0045829", "SSF52283 : 0048240", "SSF48726 : 0036136", 
                      "PS50215 : ADAM_MEPRO", "SSF57414 : 0038925", "SSF63380 : 0040221", 
                      "SSF47954 : 0037400", "TIGR00685 : T6PP", "SSF53613 : 0044890", 
                      "SSF63748 : 0048667", "SSF50969 : 0039648", "SSF54495 : 0051310", 
                      "SSF49723 : 0038666", "PF03224 : V-ATPase_H", "SSF49452 : 0042793", 
                      "SSF54001 : 0052516", "SSF54814 : 0037614", "SSF49695 : 0041899", 
                      "SSF52821 : 0051401", "PF00186 : DHFR_1", "SSF57667 : 0043983", 
                      "SSF54980 : 0048253", "TIGR01243 : CDC48", "SSF56112 : 0050990", 
                      "SSF54928 : 0052218", "SSF88645 : 0043496", "SSF57392 : 0044513", 
                      "PF05978 : DUF895", "PF00644 : PARP", "SSF47729 : 0035413", "SSF56300 : 0049330", 
                      "SSF54791 : 0050725", "PF01679 : UPF0057", "PF04116 : FA_hydroxylase", 
                      "SSF46689 : 0047440", "SSF51445 : 0046523", "SSF46966 : 0036160", 
                      "SSF50405 : 0046321", "TIGR00722 : ttdA_fumA_fumB", "SSF100950 : 0052827", 
                      "SSF47370 : 0046715", "SSF48230 : 0037333", "SSF48726 : 0045764", 
                      "SSF46458 : 0038628", "PR00504 : CHROMODOMAIN", "PF01016 : Ribosomal_L27", 
                      "PF03144 : GTP_EFTU_D2", "SSF52374 : 0041210", "SSF51735 : 0047681", 
                      "SSF52009 : 0038454", "SSF46955 : 0041317", "PF00349 : Hexokinase_1", 
                      "SSF57716 : 0043947", "SSF56655 : 0044712", "SSF54909 : 0038836", 
                      "PR00190 : ACTIN", "SSF47459 : 0034803", "TIGR01322 : scrB_fam", 
                      "SSF47113 : 0040307", "SSF50923 : 0048961", "SSF48464 : 0046406", 
                      "SSF56645 : 0052370", "SSF52467 : 0038971", "SSF63882 : 0037992", 
                      "SSF55961 : 0040020", "PIRSF004681 :", "PF01661 : A1pp", "SSF49265 : 0050499", 
                      "PF01329 : Pterin_4a", "SSF52540 : 0041053", "SSF54277 : 0041819", 
                      "SSF57059 : 0047685", "SSF50324 : 0049865", "SSF54913 : 0048489", 
                      "PD002460 :", "PS50234 : VWFA", "PF09103 : BRCA-2_OB1", "SSF54001 : 0049065", 
                      "SSF49899 : 0048232", "PF03332 : PMM", "SSF100897 : 0037844", 
                      "SSF52743 : 0043453", "SSF48726 : 0042159", "SSF47802 : 0039637", 
                      "SSF52540 : 0049881", "SSF81593 : 0044610", "SSF56420 : 0040555", 
                      "PF03939 : Ribosomal_L23eN", "SSF53474 : 0042808", "SSF52540 : 0037163", 
                      "SSF52218 : 0046267", "SSF52980 : 0045557", "SSF54593 : 0047894", 
                      "PF04138 : GtrA", "SSF46458 : 0038561", "TIGR00574 : dnl1", "SSF57302 : 0041055", 
                      "SSF49899 : 0035851", "SSF49265 : 0045313", "SSF54791 : 0052295", 
                      "SSF55874 : 0037015", "SSF50814 : 0044914", "PF06658 : DUF1168", 
                      "PIRSF015921 :", "SSF69070 : 0039714", "SSF64356 : 0041530", 
                      "SSF48295 : 0039323", "SSF54001 : 0048736", "SSF50475 : 0053034", 
                      "SSF50346 : 0052566", "PF10217 : DUF2039", "PIRSF000848 :", "SSF56112 : 0049786", 
                      "SSF57038 : 0048265", "SSF50331 : 0037742", "SSF50104 : 0052974", 
                      "SSF54862 : 0049159", "SSF55550 : 0040807", "PF04910 : DUF654", 
                      "SSF53474 : 0050226", "SSF47266 : 0035199", "SSF54236 : 0051789", 
                      "SSF50621 : 0037373", "PF01168 : Ala_racemase_N", "PD000522 :", 
                      "SSF50465 : 0050422", "SSF51556 : 0051670", "SSF49562 : 0036566", 
                      "SSF48695 : 0047493", "SSF56300 : 0047216", "SSF50978 : 0042311", 
                      "PF06725 : 3D", "SSF47031 : 0036949", "SSF49503 : 0035148", "SSF55874 : 0043464", 
                      "PS50113 : PAC", "TIGR00482 : TIGR00482", "SSF56747 : 0044601", 
                      "SSF46785 : 0049384", "SSF54277 : 0050657", "SSF46626 : 0041148", 
                      "SSF52540 : 0037885", "SSF56235 : 0050948", "SSF56574 : 0038626", 
                      "SSF51905 : 0036092", "SSF53335 : 0052992", "SSF53167 : 0045902", 
                      "SSF46934 : 0038184", "SSF54637 : 0047414", "SSF57716 : 0042543", 
                      "SSF47031 : 0046976", "PF10639 : UPF0546", "SSF46689 : 0049545", 
                      "TIGR01787 : squalene_cyclas", "PS50070 : KRINGLE_2", "SSF57196 : 0036172", 
                      "SSF55331 : 0035587", "SSF52980 : 0036344", "SSF47266 : 0039612", 
                      "SSF55711 : 0049039", "SSF101116 : 0044750", "PF10072 : DUF2311", 
                      "SSF57501 : 0037154", "PS50807 : GCM", "PF00685 : Sulfotransfer_1", 
                      "SSF109709 : 0049120", "SSF50814 : 0048251", "PF02807 : ATP-gua_PtransN", 
                      "PD008617 :", "SSF54236 : 0050532", "SSF57095 : 0041054", "SSF48726 : 0052150", 
                      "SSF51998 : 0042277", "SSF51430 : 0034939", "SSF47986 : 0048274", 
                      "SSF55060 : 0043491", "SSF51366 : 0051164", "TIGR00254 : GGDEF", 
                      "SSF49265 : 0037680", "SSF54427 : 0042813", "SSF55486 : 0045818", 
                      "SSF50814 : 0052756", "SSF53850 : 0036601", "PR00176 : NANEUSMPORT", 
                      "SSF49503 : 0049365", "SSF50203 : 0042434", "SSF56420 : 0051210", 
                      "PS50231 : RICIN_B_LECTIN", "SSF54966 : 0053331", "PF01846 : FF", 
                      "PF00955 : HCO3_cotransp", "SSF56235 : 0039164", "SSF69754 : 0039086", 
                      "SSF57667 : 0043730", "PD002533 :", "PIRSF010340 :", "SSF52833 : 0040901", 
                      "SSF47862 : 0042723", "SSF50494 : 0036154", "SSF48056 : 0035699", 
                      "SSF49899 : 0046937", "SSF54719 : 0035287", "SSF50494 : 0043220", 
                      "SSF57535 : 0038132", "SSF57716 : 0045730", "SSF57059 : 0046591", 
                      "SSF81878 : 0040963", "SSF48726 : 0046790", "SSF53756 : 0046587", 
                      "PD117373 :", "PD001115 :", "SSF48726 : 0045277", "SSF53300 : 0040480", 
                      "TIGR02491 : NrdG", "SSF51717 : 0046651", "SSF101094 : 0041569", 
                      "SSF63748 : 0052440", "PF01588 : tRNA_bind", "SSF88713 : 0052123", 
                      "SSF53474 : 0048825", "SSF55298 : 0041514", "SSF53850 : 0046627", 
                      "SSF48508 : 0045306", "SSF51735 : 0050365", "SSF89942 : 0042241", 
                      "SSF50729 : 0044152", "SSF54211 : 0043249", "SSF53901 : 0052891", 
                      "SSF63763 : 0041052", "SSF53187 : 0050182", "SSF54452 : 0045332", 
                      "PS01033 : GLOBIN", "SSF81343 : 0040054", "SSF57701 : 0045159", 
                      "SSF54928 : 0052231", "SSF54593 : 0048964", "SSF57190 : 0048738", 
                      "SSF51445 : 0036899", "SSF54534 : 0052517", "PF00886 : Ribosomal_S16", 
                      "PF02825 : WWE", "SSF46785 : 0043441", "SSF57247 : 0048729", 
                      "SSF54197 : 0051525", "SSF54529 : 0051373", "SSF63380 : 0040333", 
                      "SSF81296 : 0048564", "SSF55144 : 0039208", "SSF52972 : 0044652", 
                      "SSF109797 : 0049598", "SSF55681 : 0037113", "SSF50090 : 0038316", 
                      "SSF102829 : 0043870", "SSF50249 : 0039283", "SSF52317 : 0049527", 
                      "PF01263 : Aldose_epim", "SSF53335 : 0045633", "SSF50610 : 0035462", 
                      "SSF54928 : 0050568", "PF05770 : Ins134_P3_kin", "PD014904 :", 
                      "SSF49899 : 0045454", "SSF48619 : 0042057", "SSF52980 : 0037341", 
                      "SSF89009 : 0038571", "SSF55620 : 0039329", "SSF53335 : 0040218", 
                      "SSF54593 : 0036021", "SSF52540 : 0050691", "PIRSF017535 :", 
                      "SSF52540 : 0040410", "SSF49785 : 0036183", "SSF51445 : 0038179", 
                      "SSF55711 : 0043123", "PIRSF031066 :", "SSF47565 : 0042124", 
                      "SSF51197 : 0039678", "SSF56935 : 0048638", "SSF56112 : 0039408", 
                      "SSF49785 : 0039417", "SSF81296 : 0043506", "SSF48726 : 0049851", 
                      "SSF52374 : 0040507", "SSF47473 : 0042852", "SSF52266 : 0036388", 
                      "SSF57302 : 0052991", "SSF53850 : 0038392", "PIRSF010045 :", 
                      "SSF46458 : 0047201", "TIGR00044 : TIGR00044", "SSF55979 : 0053277", 
                      "SSF56712 : 0036904", "SSF81296 : 0047131", "PF04916 : Phospholip_B", 
                      "SSF53597 : 0045659", "SSF47240 : 0052707", "SSF47240 : 0043824", 
                      "SSF51445 : 0050004", "SSF57716 : 0035408", "SSF53167 : 0042731", 
                      "SSF69695 : 0039566", "SSF53901 : 0040002", "SSF57196 : 0037086", 
                      "SSF82784 : 0041625", "PF08207 : EFP_N", "SSF63380 : 0040334", 
                      "SSF54160 : 0047837", "SSF51445 : 0043016", "PF02790 : COX2_TM", 
                      "SSF55920 : 0045044", "SSF47648 : 0044470", "SSF54452 : 0037256", 
                      "PF07218 : RAP1", "SSF50475 : 0052694", "SSF50911 : 0042583", 
                      "SSF56371 : 0038995", "SSF48695 : 0047319", "SSF53474 : 0041042", 
                      "SSF56994 : 0036101", "SSF54928 : 0050803", "SSF54814 : 0050483", 
                      "SSF54556 : 0040523", "SSF81624 : 0040360", "SSF53474 : 0042980", 
                      "SSF52038 : 0035259", "SSF49785 : 0043559", "SSF82171 : 0048263", 
                      "SSF69318 : 0049735", "PF01396 : zf-C4_Topoisom", "SSF81296 : 0035951", 
                      "PF04825 : Rad21_Rec8_N", "SSF47396 : 0045105", "SSF51445 : 0046528", 
                      "SSF53474 : 0047200", "SSF52467 : 0043498", "SSF51735 : 0052837", 
                      "SSF48150 : 0041038", "SSF50729 : 0042176", "SSF57667 : 0041429", 
                      "SSF47095 : 0038705", "SSF48403 : 0049331", "SSF90002 : 0041413", 
                      "SSF57262 : 0043652", "PR00868 : DNAPOLI", "SSF54631 : 0042493", 
                      "SSF53187 : 0053284", "SSF50129 : 0043275", "SSF47473 : 0043674", 
                      "SSF51735 : 0048416", "SSF52833 : 0038883", "SSF56024 : 0037308", 
                      "SSF52141 : 0048547", "SSF50630 : 0038690", "SSF57059 : 0037891", 
                      "SSF53850 : 0043183", "TIGR02428 : pcaJ_scoB_fam", "SSF53901 : 0049762", 
                      "PS51232 : GBD_FH3", "SSF88798 : 0051178", "PF10266 : Strumpellin", 
                      "SSF48726 : 0036133", "SSF54001 : 0042254", "SSF49503 : 0044585", 
                      "PF07885 : Ion_trans_2", "SSF52402 : 0036970", "SSF51161 : 0052621", 
                      "PF06472 : ABC_membrane_2", "SSF89028 : 0048403", "SSF55811 : 0047428", 
                      "SSF57196 : 0039776", "SSF49452 : 0035000", "SSF46626 : 0035913", 
                      "SSF52096 : 0052487", "SSF55753 : 0044639", "SSF54117 : 0043273", 
                      "SSF68923 : 0039037", "SSF55945 : 0045100", "SSF55186 : 0041633", 
                      "SSF52540 : 0052004", "SSF54452 : 0040019", "SSF50182 : 0051278", 
                      "SSF50044 : 0044361", "SSF55315 : 0043296", "SSF54236 : 0052069", 
                      "SSF55424 : 0036302", "TIGR00042 : TIGR00042", "PIRSF025798 :", 
                      "SSF75005 : 0051905", "SSF47928 : 0034989", "SSF50104 : 0049873", 
                      "PF01074 : Glyco_hydro_38", "SSF47862 : 0040425", "SSF53590 : 0045355", 
                      "SSF47031 : 0038036", "SSF49265 : 0038950", "SSF46955 : 0040704", 
                      "PD186071 :", "PD006539 :", "SSF55008 : 0048637", "SSF49503 : 0036726", 
                      "PF02453 : Reticulon", "SSF46585 : 0044490", "SSF53933 : 0036376", 
                      "SSF56436 : 0038795", "SSF54928 : 0052221", "PS51129 : PDXS_SNZ_2", 
                      "SSF57667 : 0052289", "SSF47473 : 0051413", "SSF56645 : 0046013", 
                      "SSF50494 : 0042529", "PF04106 : APG5", "SSF46626 : 0036633", 
                      "SSF48371 : 0053206", "SSF55315 : 0043564", "SSF54791 : 0050815", 
                      "PF00265 : TK", "SSF56672 : 0038597", "SSF56815 : 0036509", "SSF47473 : 0039516", 
                      "SSF57938 : 0041451", "SSF54928 : 0052239", "PS50110 : RESPONSE_REGULATORY", 
                      "SSF55008 : 0040284", "SSF54358 : 0048762", "SSF49348 : 0043122", 
                      "SSF53686 : 0039302", "SSF47240 : 0047502", "SSF49265 : 0047287", 
                      "PD014178 :", "SSF57440 : 0045327", "PF05699 : hATC", "PS51190 : FATC", 
                      "SSF57095 : 0049408", "SSF50494 : 0045461", "SSF57196 : 0036921", 
                      "SSF81296 : 0046996", "SSF88645 : 0040715", "SSF46458 : 0037450", 
                      "SSF53474 : 0034956", "SSF52467 : 0042409", "SSF53623 : 0047522", 
                      "SSF52922 : 0042763", "SSF50494 : 0045413", "SSF52922 : 0039199", 
                      "SSF46626 : 0036716", "PIRSF027081 :", "SSF50129 : 0042905", 
                      "PR00314 : CLATHRINADPT", "SSF55120 : 0047872", "SSF54637 : 0051494", 
                      "PF07974 : EGF_2", "PF02757 : YLP", "SSF53901 : 0044137", "PD150742 :", 
                      "PR00122 : VACATPASE", "PF01067 : Calpain_III", "PD003460 :", 
                      "PR00018 : KRINGLE", "SSF52980 : 0051238", "SSF52266 : 0037838", 
                      "SSF57184 : 0041266", "PF02670 : DXP_reductoisom", "SSF52374 : 0047586", 
                      "SSF55973 : 0041133", "SSF50814 : 0046640", "SSF102198 : 0043141", 
                      "PS50190 : SEC7", "SSF54975 : 0052074", "SSF52058 : 0040811", 
                      "SSF52374 : 0047487", "SSF50729 : 0044659", "PF01780 : Ribosomal_L37ae", 
                      "SSF50447 : 0049446", "SSF53686 : 0050641", "SSF57059 : 0046249", 
                      "PS50067 : KINESIN_MOTOR_DOMAIN2", "TIGR01978 : sufC", "PF01734 : Patatin", 
                      "SSF55031 : 0043110", "SSF50447 : 0037405", "SSF56770 : 0036735", 
                      "SSF50044 : 0038150", "SSF46785 : 0049556", "SSF53671 : 0047669", 
                      "SSF47027 : 0047159", "SSF53271 : 0050105", "SSF54117 : 0042732", 
                      "PF03474 : DMA", "PF00615 : RGS", "SSF81301 : 0051960", "PF02809 : UIM", 
                      "SSF54277 : 0038962", "PD000940 :", "PF02389 : Cornifin", "SSF54913 : 0047113", 
                      "SSF57095 : 0042836", "SSF51366 : 0048432", "SSF53850 : 0042407", 
                      "SSF56235 : 0039168", "SSF54495 : 0039449", "SSF48452 : 0047272", 
                      "SSF56935 : 0045553", "SSF46785 : 0038835", "SSF89000 : 0041581", 
                      "SSF49854 : 0043807", "PR00154 : AMPBINDING", "SSF56112 : 0043074", 
                      "SSF52540 : 0047665", "SSF52980 : 0036214", "PD157043 :", "SSF57667 : 0050111", 
                      "PF04343 : DUF488", "SSF50923 : 0042278", "SSF56322 : 0038839", 
                      "PF04194 : PDCD2_C", "SSF55486 : 0038130", "SSF46915 : 0046447", 
                      "TIGR00855 : L12", "PIRSF000806 :", "SSF51445 : 0036535", "SSF52980 : 0051182", 
                      "SSF53850 : 0049271", "SSF48371 : 0038695", "SSF51658 : 0045049", 
                      "SSF57059 : 0037848", "SSF47616 : 0038156", "SSF48498 : 0052844", 
                      "PF00033 : Cytochrom_B_N", "SSF48264 : 0038307", "PD002938 :", 
                      "SSF53067 : 0036203", "SSF50129 : 0050889", "TIGR01477 : RIFIN", 
                      "SSF54534 : 0041183", "SSF47986 : 0046261", "SSF52518 : 0048897", 
                      "SSF54236 : 0050756", "SSF49899 : 0045095", "SSF47729 : 0037242", 
                      "PD033721 :", "PR00450 : RECOVERIN", "SSF54826 : 0040034", "SSF51717 : 0042650", 
                      "SSF57667 : 0052288", "SSF47240 : 0039558", "SSF47240 : 0045957", 
                      "PIRSF000102 :", "SSF51569 : 0047070", "SSF55608 : 0035313", 
                      "SSF53098 : 0051425", "SSF46626 : 0046788", "SSF52821 : 0050551", 
                      "SSF46785 : 0041924", "SSF55031 : 0053285", "SSF53383 : 0049070", 
                      "SSF47473 : 0043505", "PF02787 : CPSase_L_D3", "SSF50249 : 0048166", 
                      "SSF52096 : 0048770", "SSF51569 : 0035349", "SSF57829 : 0043515", 
                      "SSF50729 : 0049970", "SSF53067 : 0049807", "TIGR01704 : MTA/SAH-Nsdase", 
                      "SSF53254 : 0036777", "PF00736 : EF1_GNE", "SSF47576 : 0046419", 
                      "SSF48295 : 0047944", "SSF46785 : 0048491", "SSF50044 : 0038487", 
                      "SSF50044 : 0050000", "SSF53067 : 0051971", "PF09759 : Atx10homo_assoc", 
                      "SSF47266 : 0043234", "SSF55447 : 0039726", "SSF48670 : 0043930", 
                      "SSF52317 : 0049298", "SSF56784 : 0049067", "SSF47113 : 0042675", 
                      "SSF53901 : 0053134", "SSF47413 : 0040544", "SSF57868 : 0040718", 
                      "SSF48726 : 0045273", "SSF52954 : 0037946", "SSF63446 : 0036328", 
                      "TIGR00617 : rpa1", "PF07934 : OGG_N", "PF01841 : Transglut_core", 
                      "SSF55608 : 0041030", "SSF57302 : 0036572", "SSF54495 : 0049978", 
                      "SSF49899 : 0039549", "SSF52540 : 0040678", "SSF82704 : 0038363", 
                      "SSF89028 : 0041411", "SSF54452 : 0045112", "SSF51161 : 0049025", 
                      "SSF48264 : 0039299", "SSF55003 : 0049129", "SSF55347 : 0041829", 
                      "SSF56741 : 0039911", "SSF56655 : 0045316", "SSF55394 : 0037225", 
                      "SSF52833 : 0043845", "SSF56300 : 0044319", "SSF53697 : 0049514", 
                      "TIGR01452 : PGP_euk", "SSF48557 : 0044708", "SSF49417 : 0038725", 
                      "SSF82171 : 0042001", "SSF53254 : 0045326", "SSF52833 : 0050770", 
                      "SSF57095 : 0046141", "PF00085 : Thioredoxin", "SSF63411 : 0037287", 
                      "SSF54334 : 0037693", "TIGR00521 : coaBC_dfp", "SSF81296 : 0047387", 
                      "SSF52540 : 0042738", "SSF57889 : 0047776", "SSF46950 : 0037023", 
                      "PD003035 :", "PF05327 : RRN3", "PS50984 : TRUD", "PD009460 :", 
                      "SSF57667 : 0037351", "SSF51344 : 0035173", "SSF50156 : 0044314", 
                      "SSF54452 : 0035166", "SSF53182 : 0039202", "SSF47240 : 0048950", 
                      "SSF49562 : 0050495", "SSF54913 : 0048360", "SSF53822 : 0045352", 
                      "SSF48557 : 0039747", "SSF48256 : 0039891", "SSF50182 : 0049628", 
                      "SSF47986 : 0044274", "SSF49777 : 0034862", "SSF54637 : 0052511", 
                      "SSF57667 : 0045297", "SSF51556 : 0039403", "SSF51905 : 0050960", 
                      "SSF54975 : 0044495", "SSF81585 : 0047636", "SSF50630 : 0045164", 
                      "SSF46689 : 0048162", "SSF51569 : 0050359", "SSF46977 : 0042838", 
                      "SSF81271 : 0048938", "SSF88723 : 0051236", "SSF48726 : 0043972", 
                      "SSF52540 : 0044263", "SSF47240 : 0052712", "SSF48726 : 0044388", 
                      "SSF53448 : 0051364", "SSF63411 : 0035486", "SSF49899 : 0035591", 
                      "SSF57625 : 0039274", "SSF47769 : 0044602", "SSF49265 : 0036945", 
                      "SSF69908 : 0039641", "SSF81736 : 0041453", "PS50002 : SH3", 
                      "SSF55347 : 0051902", "SSF54236 : 0038176", "PD007914 :", "SSF51905 : 0046973", 
                      "SSF51569 : 0046720", "SSF53448 : 0049057", "SSF54897 : 0040301", 
                      "SSF55347 : 0038051", "SSF55681 : 0035382", "SSF46458 : 0038098", 
                      "SSF57716 : 0036583", "SSF64383 : 0046703", "SSF53098 : 0048905", 
                      "SSF54928 : 0050515", "SSF48208 : 0050051", "SSF50475 : 0037651", 
                      "TIGR00745 : apbA_panE", "PS51310 : VPS28_C", "SSF47648 : 0035684", 
                      "SSF53383 : 0052157", "SSF54909 : 0049512", "SSF46458 : 0050880", 
                      "SSF56512 : 0045599", "SSF52980 : 0051967", "SSF50814 : 0037146", 
                      "SSF49265 : 0040701", "SSF48576 : 0043350", "TIGR01130 : ER_PDI_fam", 
                      "SSF55729 : 0048390", "SSF103025 : 0041533", "SSF55846 : 0041859", 
                      "SSF53383 : 0038034", "SSF88633 : 0045602", "SSF48464 : 0047697", 
                      "SSF53187 : 0047657", "SSF49503 : 0040015", "SSF57802 : 0039201", 
                      "PF04147 : Nop14", "SSF56784 : 0040657", "TIGR00486 : YbgI_SA1388", 
                      "SSF54368 : 0046707", "SSF63965 : 0042029", "PF05957 : DUF883", 
                      "SSF50353 : 0048836", "SSF46785 : 0050373", "PIRSF000157 :", 
                      "PF00175 : NAD_binding_1", "SSF48403 : 0044467", "SSF51717 : 0045762", 
                      "SSF56436 : 0039821", "SSF48695 : 0041835", "SSF53254 : 0049178", 
                      "SSF88633 : 0041620", "SSF51445 : 0044372", "SSF54637 : 0043610", 
                      "SSF57095 : 0045892", "SSF46458 : 0038290", "SSF52218 : 0046862", 
                      "SSF51395 : 0038972", "SSF52540 : 0042172", "SSF57825 : 0042302", 
                      "SSF54637 : 0043499", "SSF81901 : 0042037", "SSF54452 : 0038657", 
                      "SSF51735 : 0047032", "PF02183 : HALZ", "PF04939 : RRS1", "SSF46785 : 0038708", 
                      "SSF110849 : 0044819", "SSF54928 : 0048400", "PF00171 : Aldedh", 
                      "SSF52833 : 0037704", "SSF47473 : 0044955", "SSF50182 : 0039473", 
                      "SSF49503 : 0052066", "SSF48726 : 0044084", "PF07774 : DUF1620", 
                      "PF04909 : Amidohydro_2", "SSF53335 : 0047211", "PF07681 : DoxX", 
                      "SSF54334 : 0035116", "SSF54665 : 0036416", "SSF53335 : 0036357", 
                      "PIRSF000532 :", "SSF69754 : 0040382", "SSF52518 : 0035297", 
                      "SSF53697 : 0043829", "PS50878 : RT_POL", "PD021274 :", "SSF53850 : 0049998", 
                      "TIGR01060 : eno", "SSF56719 : 0035588", "SSF53659 : 0039193", 
                      "SSF54637 : 0043907", "SSF51569 : 0044066", "SSF51905 : 0046760", 
                      "SSF56053 : 0037527", "PF08159 : NUC153", "PF07002 : Copine", 
                      "SSF52540 : 0048426", "PF03073 : TspO_MBR", "SSF52540 : 0043814", 
                      "SSF46689 : 0048555", "SSF48208 : 0044703", "SSF100950 : 0051075", 
                      "SSF52507 : 0036713", "SSF52218 : 0043718", "SSF51445 : 0047897", 
                      "SSF57938 : 0037245", "PF05199 : GMC_oxred_C", "SSF52402 : 0046540", 
                      "SSF50494 : 0052619", "SSF55729 : 0045896", "SSF50494 : 0048392", 
                      "PD001005 :", "SSF48464 : 0036631", "SSF46626 : 0046236", "SSF52343 : 0047323", 
                      "SSF49742 : 0051314", "TIGR01137 : cysta_beta", "SSF53474 : 0045186", 
                      "SSF81730 : 0040729", "SSF57802 : 0045630", "SSF51445 : 0046463", 
                      "SSF48113 : 0051443", "PD001128 :", "SSF57903 : 0037409", "SSF54593 : 0049803", 
                      "SSF52540 : 0043080", "SSF52799 : 0046845", "SSF47113 : 0037328", 
                      "SSF47005 : 0035432", "SSF100895 : 0051518", "SSF52540 : 0038000", 
                      "SSF56327 : 0045719", "SSF54534 : 0038779", "PF06025 : DUF913", 
                      "PIRSF017316 :", "SSF49899 : 0035225", "SSF53032 : 0049078", 
                      "SSF53474 : 0045984", "PF00274 : Glycolytic", "SSF48726 : 0047325", 
                      "SSF54447 : 0040366", "SSF49503 : 0038246", "SSF48371 : 0036843", 
                      "SSF47336 : 0034997", "SSF53335 : 0047580", "SSF55545 : 0039983", 
                      "SSF57716 : 0050787", "SSF50249 : 0042523", "SSF50182 : 0035325", 
                      "SSF52172 : 0048129", "SSF49842 : 0038234", "PF04379 : DUF525", 
                      "SSF52833 : 0039527", "PR00599 : MAPEPTIDASE", "SSF56672 : 0039847", 
                      "PD001041 :", "SSF53335 : 0050745", "SSF81296 : 0038396", "SSF47473 : 0038410", 
                      "PF01424 : R3H", "PR01662 : MCMPROTEIN6", "PIRSF038156 :", "SSF57283 : 0044997", 
                      "TIGR00291 : RNA_SBDS", "PF00320 : GATA", "SSF56672 : 0043966", 
                      "SSF57196 : 0040138", "SSF55486 : 0045657", "SSF82927 : 0040609", 
                      "SSF52440 : 0037005", "SSF47113 : 0035368", "SSF54506 : 0051111", 
                      "SSF48726 : 0042158", "SSF49265 : 0039951", "TIGR00233 : trpS", 
                      "TIGR00537 : hemK_rel_arch", "SSF55979 : 0046967", "SSF52980 : 0036506", 
                      "SSF52096 : 0041742", "SSF57802 : 0036648", "SSF53067 : 0038737", 
                      "SSF52518 : 0035296", "PR00211 : GLUTELIN", "SSF53633 : 0038241", 
                      "SSF48726 : 0040403", "SSF55120 : 0036450", "SSF56420 : 0035693", 
                      "TIGR01750 : fabZ", "SSF53800 : 0036530", "SSF47459 : 0035101", 
                      "SSF46458 : 0042319", "PD210227 :", "SSF56496 : 0037600", "PF02839 : CBM_5_12", 
                      "SSF53218 : 0036437", "SSF57840 : 0036403", "SSF46785 : 0035145", 
                      "SSF57392 : 0035411", "SSF48726 : 0035919", "SSF53850 : 0051191", 
                      "PS50937 : HTH_MERR_2", "SSF50249 : 0049576", "SSF88633 : 0053183", 
                      "SSF57392 : 0045936", "PS50209 : CARD", "SSF53850 : 0047464", 
                      "SSF55550 : 0041534", "SSF46689 : 0043882", "SSF49265 : 0050826", 
                      "PF04511 : DER1", "PIRSF005409 :", "SSF57424 : 0052956", "SSF53383 : 0046965", 
                      "SSF48498 : 0042230", "SSF46955 : 0048783", "SSF51445 : 0041792", 
                      "PD002379 :", "SSF47616 : 0037365", "SSF51445 : 0045965", "SSF50729 : 0049773", 
                      "SSF50118 : 0045579", "SSF81624 : 0043946", "PD310412 :", "SSF52096 : 0048769", 
                      "SSF53955 : 0034786", "SSF56059 : 0045751", "SSF49265 : 0048655", 
                      "SSF100950 : 0048793", "SSF51735 : 0038426", "SSF48619 : 0043501", 
                      "SSF54736 : 0036361", "SSF53659 : 0046179", "SSF51905 : 0040619", 
                      "PF10104 : Brr6_like_C_C", "SSF53807 : 0045365", "PF08018 : Antimicrobial_1", 
                      "PF02799 : NMT_C", "SSF54928 : 0038385", "SSF53271 : 0035791", 
                      "SSF51905 : 0042839", "SSF53774 : 0052389", "PF02265 : S1-P1_nuclease", 
                      "PF00919 : UPF0004", "SSF52540 : 0042471", "SSF53254 : 0036474", 
                      "SSF57038 : 0048318", "SSF54184 : 0042862", "SSF47027 : 0034992", 
                      "PD016517 :", "SSF52540 : 0046815", "TIGR01297 : CDF", "SSF56371 : 0041057", 
                      "PD174574 :", "SSF103196 : 0044718", "PF10209 : DUF2340", "SSF52540 : 0052735", 
                      "SSF110857 : 0044830", "SSF55770 : 0046250", "PF00912 : Transgly", 
                      "SSF53335 : 0046931", "SSF54637 : 0044749", "TIGR01104 : V_PPase", 
                      "SSF50084 : 0045375", "SSF81296 : 0049731", "SSF49562 : 0044929", 
                      "SSF56487 : 0035772", "SSF57667 : 0052463", "SSF53822 : 0044032", 
                      "SSF53613 : 0038035", "SSF53850 : 0035894", "SSF49348 : 0049103", 
                      "TIGR01036 : pyrD_sub2", "SSF52283 : 0051306", "SSF51735 : 0041999", 
                      "SSF46689 : 0036286", "SSF51905 : 0049930", "SSF48726 : 0036912", 
                      "SSF54919 : 0035494", "SSF48726 : 0035966", "SSF53328 : 0047614", 
                      "SSF89447 : 0044254", "SSF53067 : 0050911", "PF01428 : zf-AN1", 
                      "SSF53067 : 0039962", "SSF47459 : 0035113", "SSF53335 : 0040424", 
                      "SSF51556 : 0047865", "SSF100895 : 0038552", "SSF46689 : 0048540", 
                      "SSF50729 : 0051047", "SSF52540 : 0037920", "SSF57716 : 0050847", 
                      "PF08448 : PAS_4", "SSF53271 : 0036475", "PR00972 : RIBSOMALS12E", 
                      "SSF49452 : 0047883", "SSF54791 : 0052299", "SSF49749 : 0038766", 
                      "PF00177 : Ribosomal_S7", "PF00821 : PEPCK", "SSF55961 : 0050686", 
                      "SSF52540 : 0045954", "SSF51735 : 0037099", "SSF57027 : 0045197", 
                      "SSF89796 : 0042164", "PF00348 : polyprenyl_synt", "SSF48726 : 0049188", 
                      "PR01848 : U2AUXFACTOR", "SSF49354 : 0038238", "SSF48163 : 0039170", 
                      "SSF54928 : 0052233", "SSF47762 : 0036847", "SSF46785 : 0042175", 
                      "SSF53098 : 0049624", "SSF54909 : 0039209", "SSF55486 : 0047769", 
                      "SSF51004 : 0048375", "PR00928 : GRAVESDC", "SSF53474 : 0034958", 
                      "SSF48726 : 0035669", "SSF52374 : 0052384", "PF07876 : Dabb", 
                      "PF00584 : SecE", "SSF52540 : 0037398", "PF00786 : PBD", "SSF54593 : 0042979", 
                      "SSF54452 : 0035752", "SSF57196 : 0037087", "SSF56574 : 0035184", 
                      "SSF52980 : 0043536", "SSF48726 : 0045931", "SSF48726 : 0046060", 
                      "SSF53271 : 0044334", "SSF54523 : 0038669", "SSF54791 : 0051994", 
                      "PS51126 : DILUTE", "SSF47095 : 0039347", "SSF53850 : 0043543", 
                      "SSF56371 : 0039320", "SSF51735 : 0051511", "SSF111379 : 0043655", 
                      "SSF52833 : 0041457", "SSF50044 : 0039912", "PR01744 : MIC1MICRNEME", 
                      "SSF49503 : 0035659", "SSF56645 : 0050327", "SSF52402 : 0048858", 
                      "SSF55257 : 0039233", "SSF46785 : 0049151", "SSF57440 : 0036025", 
                      "SSF50494 : 0037118", "SSF57059 : 0041419", "SSF81343 : 0040053", 
                      "SSF51735 : 0046034", "SSF54913 : 0038174", "SSF48508 : 0045026", 
                      "PIRSF017288 :", "SSF48508 : 0042042", "SSF50090 : 0042913", 
                      "SSF46689 : 0045778", "PF02922 : CBM_48", "SSF46938 : 0048578", 
                      "PF06862 : DUF1253", "SSF53067 : 0041902", "SSF100897 : 0045605", 
                      "SSF53659 : 0040698", "TIGR01430 : aden_deam", "SSF56854 : 0053168", 
                      "SSF69500 : 0039406", "SSF50182 : 0053242", "SSF52540 : 0041098", 
                      "SSF54585 : 0036123", "SSF56672 : 0043914", "SSF52743 : 0044008", 
                      "PF06432 : GPI2", "SSF50911 : 0035827", "SSF50324 : 0042734", 
                      "SSF54637 : 0052350", "SSF81624 : 0039899", "PF02836 : Glyco_hydro_2_C", 
                      "SSF56436 : 0039269", "PS51366 : MI", "SSF51735 : 0050910", "SSF54695 : 0037753", 
                      "SSF56994 : 0035644", "PR00124 : ATPASEC", "PIRSF018269 :", "SSF55961 : 0051529", 
                      "SSF46626 : 0038691", "SSF56601 : 0052144", "SSF56436 : 0039795", 
                      "SSF74653 : 0049753", "SSF51445 : 0038123", "SSF53955 : 0042970", 
                      "PR00297 : CHAPERONIN10", "SSF88633 : 0037663", "SSF47473 : 0043028", 
                      "SSF49417 : 0039062", "SSF54236 : 0048151", "SSF52540 : 0035084", 
                      "SSF52788 : 0053360", "SSF51649 : 0038127", "PF07969 : Amidohydro_3", 
                      "SSF47095 : 0049027", "PR00066 : XRODRMPGMNTG", "SSF53613 : 0044249", 
                      "SSF55347 : 0039651", "SSF53448 : 0048604", "SSF48576 : 0053355", 
                      "SSF46458 : 0037273", "SSF53383 : 0036980", "SSF48113 : 0041009", 
                      "SSF49265 : 0044309", "SSF51430 : 0046848", "PF04573 : SPC22", 
                      "PF00310 : GATase_2", "SSF56112 : 0046494", "PF10247 : Mit_gmP", 
                      "PIRSF017269 :", "SSF51905 : 0036732", "SSF53474 : 0048633", 
                      "SSF56104 : 0044167", "SSF89623 : 0041466", "SSF50916 : 0037374", 
                      "SSF46689 : 0039939", "SSF48726 : 0038773", "SSF74650 : 0038644", 
                      "SSF50203 : 0045568", "SSF53955 : 0050993", "SSF46565 : 0038551", 
                      "SSF63829 : 0052427", "PF01151 : ELO", "SSF52833 : 0040838", 
                      "SSF55785 : 0046903", "SSF53720 : 0035037", "PF01381 : HTH_3", 
                      "SSF50156 : 0041775", "SSF55729 : 0051819", "SSF51294 : 0039778", 
                      "SSF57850 : 0052101", "SSF51011 : 0035222", "SSF55326 : 0050216", 
                      "PF00828 : Ribosomal_L18e", "SSF55945 : 0035929", "SSF101904 : 0043770", 
                      "SSF64518 : 0049861", "SSF52540 : 0040639", "SSF57802 : 0035679", 
                      "SSF52540 : 0052785", "PR00423 : CELLDVISFTSZ", "SSF52833 : 0046982", 
                      "SSF51905 : 0048108", "SSF53383 : 0046165", "SSF50249 : 0046930", 
                      "PF04551 : GcpE", "SSF81296 : 0049480", "SSF54826 : 0048551", 
                      "SSF46458 : 0044511", "SSF48056 : 0038519", "SSF88633 : 0049655", 
                      "SSF81483 : 0042909", "PF05131 : Pep3_Vps18", "SSF53098 : 0039371", 
                      "SSF57716 : 0045386", "PF05301 : DUF738", "SSF52096 : 0049386", 
                      "SSF50405 : 0036400", "PF05206 : DUF715", "PS50064 : PARP_ZN_FINGER_2", 
                      "SSF48371 : 0038945", "SSF50729 : 0040694", "SSF48619 : 0035584", 
                      "SSF51658 : 0034806", "SSF82215 : 0040175", "SSF57392 : 0043609", 
                      "PF02910 : Succ_DH_flav_C", "PD009649 :", "SSF49452 : 0036120", 
                      "SSF101447 : 0044674", "SSF54211 : 0042083", "SSF47986 : 0050656", 
                      "PF00817 : IMS", "PS50191 : CRAL_TRIO", "SSF89963 : 0039089", 
                      "SSF52799 : 0044763", "PF08154 : NLE", "SSF48726 : 0049213", 
                      "SSF48619 : 0038185", "SSF48498 : 0053205", "PR01164 : GAMMATUBULIN", 
                      "SSF49503 : 0049379", "PF03938 : OmpH", "SSF50203 : 0037096", 
                      "SSF53850 : 0039259", "SSF55464 : 0043184", "SSF53335 : 0051449", 
                      "SSF49899 : 0043956", "SSF51182 : 0041608", "SSF54919 : 0048316", 
                      "SSF54358 : 0045429", "SSF50814 : 0040483", "SSF51569 : 0041693", 
                      "SSF52374 : 0053312", "SSF49313 : 0036919", "SSF48726 : 0038774", 
                      "SSF49417 : 0046018", "PF04752 : ChaC", "SSF50494 : 0053039", 
                      "SSF52833 : 0044073", "SSF53383 : 0050390", "PF01063 : Aminotran_4", 
                      "SSF51395 : 0044760", "PD024071 :", "SSF52317 : 0037847", "SSF57716 : 0052461", 
                      "SSF57440 : 0036828", "SSF56281 : 0051194", "PF03485 : Arg_tRNA_synt_N", 
                      "PF00493 : MCM", "PF00913 : Trypan_glycop", "SSF54909 : 0044163", 
                      "SSF63411 : 0035451", "PF00126 : HTH_1", "SSF52096 : 0041793", 
                      "SSF52343 : 0036370", "SSF48726 : 0048696", "SSF51621 : 0042518", 
                      "PF04811 : Sec23_trunk", "PF06058 : DCP1", "SSF54236 : 0049373", 
                      "SSF52029 : 0047814", "SSF56281 : 0051591", "SSF51445 : 0037496", 
                      "SSF52172 : 0039926", "PF10437 : Lip_prot_lig_C", "SSF100895 : 0043075", 
                      "SSF55174 : 0036496", "PS51229 : DCUN1", "PF02441 : Flavoprotein", 
                      "PF02535 : Zip", "PF03501 : S10_plectin", "SSF52096 : 0048890", 
                      "SSF50615 : 0048127", "SSF50022 : 0051453", "TIGR00224 : pckA", 
                      "PF08637 : NCA2", "SSF50630 : 0036544", "PF00238 : Ribosomal_L14", 
                      "SSF56112 : 0041035", "SSF54631 : 0045120", "SSF49695 : 0037390", 
                      "PF00209 : SNF", "SSF48695 : 0047084", "SSF53335 : 0043252", 
                      "SSF52833 : 0049496", "SSF51445 : 0038605", "PF06148 : COG2", 
                      "SSF56047 : 0035114", "SSF55021 : 0042450", "SSF56235 : 0039163", 
                      "SSF69336 : 0036863", "SSF52172 : 0048066", "SSF54680 : 0045474", 
                      "PF01451 : LMWPc", "SSF54427 : 0043497", "SSF81296 : 0052395", 
                      "SSF51430 : 0041158", "SSF47819 : 0051176", "SSF53244 : 0042136", 
                      "SSF52172 : 0043525", "SSF52096 : 0046748", "PF03839 : Sec62", 
                      "PF00133 : tRNA-synt_1", "SSF100895 : 0041571", "SSF52029 : 0038167", 
                      "SSF52540 : 0048180", "SSF52540 : 0043887", "PF08799 : PRP4", 
                      "SSF47874 : 0035119", "SSF54719 : 0038985", "SSF53098 : 0041082", 
                      "SSF51445 : 0052962", "SSF89162 : 0041249", "SSF46458 : 0038983", 
                      "SSF47473 : 0047873", "SSF54637 : 0035880", "SSF50156 : 0052077", 
                      "PF02224 : Cytidylate_kin", "PF03871 : RNA_pol_Rpb5_N", "SSF75217 : 0050073", 
                      "SSF53223 : 0035291", "SSF53901 : 0044256", "SSF52335 : 0050669", 
                      "SSF53223 : 0041505", "SSF81296 : 0048722", "SSF49373 : 0036180", 
                      "SSF55486 : 0035715", "SSF54975 : 0045805", "SSF57027 : 0047157", 
                      "PD016199 :", "SSF69012 : 0038145", "SSF52218 : 0043374", "SSF47060 : 0037893", 
                      "SSF54593 : 0046684", "SSF50494 : 0050139", "SSF46924 : 0038878", 
                      "SSF103054 : 0044537", "SSF52980 : 0037109", "PF02854 : MIF4G", 
                      "SSF56436 : 0046069", "SSF55326 : 0046171", "PF06677 : Auto_anti-p27", 
                      "SSF52821 : 0036693", "SSF55781 : 0040880", "PD005589 :", "SSF101447 : 0044554", 
                      "SSF63965 : 0037360", "SSF46946 : 0036934", "SSF52218 : 0041470", 
                      "TIGR01408 : Ube1", "PF07065 : D123", "TIGR00729 : TIGR00729", 
                      "SSF53167 : 0039496", "SSF49503 : 0047784", "PF07770 : SFT2", 
                      "SSF50923 : 0039192", "SSF54593 : 0051634", "SSF88645 : 0046974", 
                      "SSF52833 : 0038647", "SSF53448 : 0050249", "SSF48726 : 0038808", 
                      "SSF46906 : 0043513", "SSF46458 : 0037094", "PD099685 :", "SSF55298 : 0048417", 
                      "SSF53613 : 0046577", "PIRSF002356 :", "SSF57716 : 0050586", 
                      "SSF52833 : 0051694", "SSF69635 : 0047708", "SSF54928 : 0046876", 
                      "SSF56399 : 0044403", "SSF50129 : 0044792", "SSF53448 : 0052019", 
                      "TIGR00151 : ispF", "SSF51445 : 0041918", "PF01558 : POR", "SSF49329 : 0046679", 
                      "TIGR02273 : 16S_RimM", "SSF48498 : 0051467", "SSF49695 : 0038100", 
                      "SSF49835 : 0051626", "SSF48013 : 0042654", "SSF46785 : 0047958", 
                      "SSF52540 : 0042610", "SSF51351 : 0045908", "SSF57095 : 0049684", 
                      "SSF57095 : 0035055", "PD002376 :", "SSF48371 : 0051473", "SSF53639 : 0042497", 
                      "SSF56935 : 0053190", "SSF49265 : 0045361", "SSF52833 : 0049305", 
                      "SSF53098 : 0044466", "SSF57535 : 0053250", "SSF50129 : 0037435", 
                      "SSF50960 : 0046204", "SSF51445 : 0041289", "SSF100879 : 0049960", 
                      "SSF47095 : 0038638", "SSF51445 : 0038415", "SSF49503 : 0048337", 
                      "SSF48452 : 0052646", "PS50077 : HEAT_REPEAT", "SSF56784 : 0051632", 
                      "SSF50249 : 0038929", "SSF53686 : 0039474", "SSF48726 : 0037209", 
                      "PF01494 : FAD_binding_3", "SSF54814 : 0047716", "PF02882 : THF_DHG_CYH_C", 
                      "SSF54427 : 0043640", "TIGR01806 : CM_mono2", "SSF54826 : 0046517", 
                      "SSF51246 : 0046444", "SSF57027 : 0038507", "SSF81296 : 0052444", 
                      "PR00166 : AROAAPRMEASE", "SSF56849 : 0039561", "SSF53335 : 0051103", 
                      "SSF54919 : 0050392", "SSF55681 : 0048934", "PD001012 :", "SSF52540 : 0045731", 
                      "SSF52075 : 0036577", "PF09360 : zf-CDGSH", "SSF51735 : 0035925", 
                      "SSF53383 : 0043050", "SSF101238 : 0041984", "SSF57440 : 0040097", 
                      "PF00165 : HTH_AraC", "SSF53137 : 0037539", "SSF50331 : 0038274", 
                      "SSF53790 : 0052425", "SSF53955 : 0042085", "SSF49835 : 0039994", 
                      "PIRSF037379 :", "SSF46458 : 0037223", "SSF51735 : 0038975", 
                      "SSF50249 : 0044549", "SSF69864 : 0040190", "SSF51445 : 0047041", 
                      "SSF50156 : 0045940", "PF03644 : Glyco_hydro_85", "SSF51445 : 0045638", 
                      "PF09854 : DUF2081", "SSF57850 : 0049212", "SSF51726 : 0047539", 
                      "PD104036 :", "SSF47266 : 0037088", "PF01599 : Ribosomal_S27", 
                      "SSF49764 : 0050536", "PF04884 : DUF647", "SSF50193 : 0044974", 
                      "SSF50129 : 0042574", "PF05005 : Ocnus", "PF00044 : Gp_dh_N", 
                      "SSF51246 : 0046145", "SSF52374 : 0045888", "PF09764 : WDYHV", 
                      "SSF53067 : 0036206", "SSF49842 : 0041744", "SSF52540 : 0037385", 
                      "SSF53271 : 0047030", "SSF53686 : 0042503", "SSF53613 : 0039381", 
                      "SSF56762 : 0036736", "SSF46785 : 0040460", "SSF54593 : 0049436", 
                      "PIRSF017259 :", "SSF51569 : 0037187", "SSF47446 : 0045276", 
                      "SSF54236 : 0040849", "SSF50729 : 0039313", "PF05870 : PA_decarbox", 
                      "SSF55945 : 0041037", "SSF52343 : 0038292", "SSF46785 : 0052282", 
                      "PF08250 : Sperm_act_pep", "PF04677 : CwfJ_C_1", "SSF81653 : 0049471", 
                      "SSF47819 : 0051396", "PF02310 : B12-binding", "SSF46626 : 0035855", 
                      "PF04012 : PspA_IM30", "SSF52374 : 0048046", "PS50262 : G_PROTEIN_RECEP_F1_2", 
                      "PF10134 : RPA", "SSF52172 : 0051318", "PF07460 : NUMOD3", "SSF81593 : 0039676", 
                      "SSF47144 : 0037730", "SSF46689 : 0044769", "SSF57095 : 0042347", 
                      "PIRSF001019 :", "SSF49265 : 0046984", "SSF52540 : 0035904", 
                      "SSF54980 : 0043916", "TIGR02250 : FCP1_euk", "SSF52540 : 0050353", 
                      "SSF48403 : 0035470", "SSF49879 : 0047810", "SSF50814 : 0047014", 
                      "SSF47473 : 0045624", "SSF52540 : 0044438", "SSF52058 : 0046244", 
                      "SSF50494 : 0035042", "PF03108 : MuDR", "PF03942 : DTW", "SSF47729 : 0041092", 
                      "PF00450 : Peptidase_S10", "SSF54565 : 0037625", "SSF81853 : 0049123", 
                      "PF07039 : DUF1325", "SSF81296 : 0049691", "TIGR01484 : HAD-SF-IIB", 
                      "SSF57667 : 0050624", "SSF53218 : 0037993", "PR01747 : DENSEGRNULE7", 
                      "SSF49309 : 0046893", "SSF54292 : 0037744", "SSF54909 : 0052967", 
                      "PF08694 : UFC1", "SSF54768 : 0049541", "SSF81296 : 0043685", 
                      "SSF53300 : 0053249", "SSF47473 : 0043728", "PIRSF004499 :", 
                      "SSF57783 : 0043990", "SSF57392 : 0037233", "SSF54001 : 0040066", 
                      "SSF48726 : 0038314", "SSF100939 : 0039513", "SSF46689 : 0052551", 
                      "SSF50814 : 0038089", "PD034397 :", "SSF50729 : 0049397", "SSF50249 : 0052498", 
                      "SSF52540 : 0042089", "PD001866 :", "PR00112 : ACYLPHPHTASE", 
                      "PF03909 : BSD", "PF00635 : Motile_Sperm", "SSF55811 : 0048821", 
                      "SSF52540 : 0035849", "SSF54117 : 0042883", "PIRSF017888 :", 
                      "SSF54292 : 0036415", "SSF53187 : 0035969", "SSF54452 : 0040458", 
                      "SSF57924 : 0035887", "PF03288 : Pox_D5", "PF03781 : DUF323", 
                      "SSF56300 : 0051021", "SSF54637 : 0052881", "SSF50156 : 0044337", 
                      "SSF55486 : 0046509", "SSF55550 : 0049185", "PD010558 :", "SSF54236 : 0050923", 
                      "SSF47473 : 0034920", "SSF46785 : 0051302", "SSF51989 : 0049965", 
                      "SSF47741 : 0039724", "SSF46785 : 0043483", "SSF53067 : 0050670", 
                      "SSF47576 : 0048131", "SSF48695 : 0048560", "PD042406 :", "PIRSF015730 :", 
                      "PR00891 : RABGDIREP", "PF03803 : Scramblase", "SSF51366 : 0043339", 
                      "SSF57190 : 0039085", "SSF50331 : 0038500", "SSF57535 : 0042992", 
                      "SSF55124 : 0045801", "SSF81502 : 0035491", "PF07910 : DUF1671", 
                      "SSF49695 : 0034883", "SSF48113 : 0036171", "PS50939 : CYTOCHROME_B561", 
                      "SSF56436 : 0038730", "SSF56112 : 0038659", "PIRSF005813 :", 
                      "PF04818 : DUF618", "SSF55945 : 0041036", "SSF50729 : 0042287", 
                      "SSF57027 : 0038375", "SSF52540 : 0041799", "SSF50891 : 0051132", 
                      "SSF48695 : 0052296", "PF00829 : Ribosomal_L21p", "SSF48726 : 0038347", 
                      "PF04004 : Leo1", "SSF52540 : 0042553", "PF07535 : zf-DBF", "SSF53271 : 0036560", 
                      "SSF48726 : 0041363", "PF03109 : ABC1", "SSF53300 : 0041212", 
                      "SSF48726 : 0038480", "SSF55753 : 0045487", "PS51202 : RCK_C", 
                      "SSF50494 : 0040692", "SSF56399 : 0042968", "SSF47473 : 0035926", 
                      "SSF56219 : 0045245", "TIGR01726 : HEQRo_perm_3TM", "PF10010 : DUF2253", 
                      "SSF56235 : 0045668", "SSF47050 : 0043056", "SSF52009 : 0051669", 
                      "SSF55550 : 0042328", "SSF50814 : 0051695", "SSF49493 : 0041450", 
                      "SSF102712 : 0048572", "SSF81660 : 0051938", "SSF51182 : 0051957", 
                      "SSF109747 : 0043365", "SSF52172 : 0035845", "SSF53671 : 0034829", 
                      "SSF50729 : 0039182", "SSF50044 : 0044363", "SSF54826 : 0045217", 
                      "PF10589 : NADH_4Fe-4S", "PIRSF036436 :", "SSF56029 : 0036039", 
                      "SSF53335 : 0052693", "SSF51569 : 0044940", "SSF88633 : 0046506", 
                      "SSF49764 : 0051045", "SSF46689 : 0052742", "SSF54495 : 0040200", 
                      "SSF54999 : 0046798", "PR00416 : EUTPISMRASEI", "SSF50129 : 0044605", 
                      "SSF57392 : 0040113", "SSF81923 : 0043010", "SSF74784 : 0047790", 
                      "PD000012 :", "SSF64356 : 0052690", "SSF55895 : 0039137", "SSF55103 : 0047281", 
                      "SSF50203 : 0045576", "SSF54768 : 0050801", "SSF53335 : 0052510", 
                      "SSF47413 : 0041348", "PD120929 :", "PIRSF000136 :", "SSF54980 : 0044775", 
                      "SSF51274 : 0049594", "SSF52833 : 0052983", "PF08155 : NOGCT", 
                      "SSF50156 : 0042116", "SSF50249 : 0039892", "SSF52743 : 0042014", 
                      "SSF52540 : 0052346", "PF03297 : Ribosomal_S25", "PS50141 : A_DEAMIN_EDITASE", 
                      "SSF56112 : 0039870", "PF08245 : Mur_ligase_M", "SSF54928 : 0036165", 
                      "SSF50475 : 0053033", "SSF46689 : 0052856", "SSF51445 : 0035532", 
                      "SSF50156 : 0051603", "SSF52540 : 0046735", "SSF48619 : 0035718", 
                      "SSF50249 : 0046921", "SSF47954 : 0039746", "SSF53671 : 0037063", 
                      "TIGR00066 : g_glut_trans", "SSF57095 : 0039820", "SSF74924 : 0052209", 
                      "SSF53254 : 0049226", "SSF55979 : 0036502", "SSF47473 : 0043209", 
                      "PF00136 : DNA_pol_B", "SSF57196 : 0040379", "SSF52490 : 0050371", 
                      "SSF52058 : 0050397", "PF08530 : PepX_C", "SSF57924 : 0036727", 
                      "SSF54236 : 0046062", "SSF52788 : 0036232", "PF04078 : Rcd1", 
                      "SSF52218 : 0051281", "SSF50494 : 0037192", "SSF48695 : 0048527", 
                      "SSF55729 : 0035637", "SSF50974 : 0037815", "TIGR01027 : proB", 
                      "TIGR02452 : TIGR02452", "SSF52402 : 0050614", "SSF50447 : 0051646", 
                      "SSF50249 : 0035886", "SSF46689 : 0041826", "SSF55979 : 0050272", 
                      "PF07732 : Cu-oxidase_3", "SSF48726 : 0043445", "SSF57095 : 0040511", 
                      "SSF57716 : 0036190", "SSF50814 : 0046467", "SSF51246 : 0038249", 
                      "SSF55277 : 0050542", "SSF57716 : 0039950", "SSF49265 : 0046886", 
                      "SSF46997 : 0051119", "SSF50022 : 0050685", "SSF48576 : 0036435", 
                      "SSF109604 : 0049193", "SSF56112 : 0039884", "SSF55831 : 0044107", 
                      "PF01394 : Clathrin_propel", "PF05833 : FbpA", "PIRSF005588 :", 
                      "SSF55424 : 0038076", "SSF52540 : 0052054", "SSF49899 : 0037123", 
                      "SSF51366 : 0042892", "SSF47823 : 0045689", "SSF81296 : 0037321", 
                      "SSF55424 : 0035130", "SSF57095 : 0038967", "PF00453 : Ribosomal_L20", 
                      "SSF47473 : 0041623", "SSF100950 : 0048341", "SSF55681 : 0035397", 
                      "SSF54791 : 0050461", "SSF48726 : 0045322", "SSF52518 : 0042102", 
                      "SSF47095 : 0035973", "SSF50353 : 0037669", "SSF53271 : 0036015", 
                      "PS50055 : TYR_PHOSPHATASE_PTP", "SSF51703 : 0051083", "SSF52218 : 0035038", 
                      "SSF53187 : 0041539", "SSF53659 : 0049509", "PD002660 :", "PR00300 : CLPPROTEASEA", 
                      "SSF52540 : 0045385", "SSF54373 : 0038201", "TIGR01722 : MMSDH", 
                      "SSF48371 : 0047335", "SSF56235 : 0049272", "PF02833 : DHHA2", 
                      "PIRSF006092 :", "SSF55724 : 0037130", "PR00192 : FACTINCAPB", 
                      "PF01435 : Peptidase_M48", "SSF50203 : 0047301", "SSF53383 : 0041704", 
                      "SSF46785 : 0043254", "PF10159 : MMtag", "PD275159 :", "SSF53328 : 0051571", 
                      "PR00133 : GLHYDRLASE3", "SSF56854 : 0046925", "PD012670 :", 
                      "SSF47648 : 0044665", "SSF89890 : 0041741", "SSF101908 : 0043253", 
                      "PF01744 : GLTT", "SSF51735 : 0050022", "SSF50249 : 0034821", 
                      "PR00085 : THFDHDRGNASE", "SSF47473 : 0049237", "SSF56436 : 0037805", 
                      "SSF50044 : 0035242", "SSF53323 : 0035299", "SSF52540 : 0038892", 
                      "SSF50156 : 0038159", "PF04099 : Sybindin", "PF03028 : Dynein_heavy", 
                      "SSF54928 : 0036311", "SSF88697 : 0043891", "SSF53474 : 0051001", 
                      "SSF51182 : 0049912", "SSF56634 : 0036848", "SSF48371 : 0044543", 
                      "PF00063 : Myosin_head", "SSF56235 : 0037658", "SSF50475 : 0050236", 
                      "SSF48452 : 0046753", "PD358599 :", "PF05149 : Flagellar_rod", 
                      "PF09749 : HVSL", "PF00166 : Cpn10", "SSF51735 : 0043965", "PF00215 : OMPdecase", 
                      "SSF56281 : 0050873", "TIGR00874 : talAB", "PF00352 : TBP", "SSF54292 : 0037830", 
                      "TIGR00033 : aroC", "PD039565 :", "SSF52540 : 0041234", "SSF50090 : 0045156", 
                      "SSF81886 : 0040824", "SSF48726 : 0046781", "SSF81324 : 0040580", 
                      "SSF53098 : 0046687", "SSF54001 : 0050922", "SSF53383 : 0039532", 
                      "PF03510 : Peptidase_C24", "SSF46934 : 0050526", "SSF48726 : 0035168", 
                      "SSF48371 : 0038302", "PF02548 : Pantoate_transf", "SSF49503 : 0039677", 
                      "SSF48056 : 0039734", "SSF49503 : 0040279", "SSF48208 : 0037722", 
                      "SSF56037 : 0048370", "SSF56973 : 0042431", "SSF53271 : 0038017", 
                      "SSF47413 : 0045230", "SSF51338 : 0046499", "SSF56219 : 0052422", 
                      "PF02423 : OCD_Mu_crystall", "SSF55418 : 0035153", "SSF55681 : 0050295", 
                      "PF04960 : Glutaminase", "SSF56935 : 0047833", "SSF55729 : 0048343", 
                      "TIGR00756 : PPR", "PF10699 : HAP2-GCS1", "PF03364 : Polyketide_cyc", 
                      "SSF50939 : 0045455", "SSF82784 : 0041204", "PF05907 : DUF866", 
                      "PF05178 : Krr1", "SSF47240 : 0035030", "SSF46785 : 0048601", 
                      "SSF101344 : 0043134", "SSF51445 : 0035223", "SSF51182 : 0051916", 
                      "SSF50156 : 0050063", "PD010724 :", "PS51074 : ZF_DPH", "SSF53335 : 0042349", 
                      "TIGR00556 : pantethn_trn", "SSF53822 : 0038038", "PS50132 : RGS", 
                      "SSF52540 : 0036452", "SSF50447 : 0041169", "SSF50331 : 0038499", 
                      "SSF54160 : 0047065", "SSF54236 : 0050520", "SSF48619 : 0037880", 
                      "SSF53092 : 0046142", "PF04452 : Methyltrans_RNA", "PF08709 : Ins145_P3_rec", 
                      "SSF55486 : 0043111", "PF02200 : STE", "SSF52058 : 0041716", 
                      "SSF52833 : 0052730", "SSF49265 : 0036944", "SSF48179 : 0044957", 
                      "TIGR01549 : HAD-SF-IA-v1", "SSF57535 : 0042607", "PF06941 : NT5C", 
                      "SSF47769 : 0036082", "SSF51445 : 0052173", "SSF53254 : 0048946", 
                      "PF08079 : Ribosomal_L30_N", "SSF51905 : 0046761", "SSF63748 : 0052882", 
                      "SSF53901 : 0035033", "SSF52425 : 0041501", "SSF53623 : 0045483", 
                      "PF03951 : Gln-synt_N", "SSF49503 : 0040029", "SSF101690 : 0049405", 
                      "PD024236 :", "SSF50494 : 0037734", "PR00786 : NEPRILYSIN", "SSF47095 : 0045346", 
                      "PF00388 : PI-PLC-X", "SSF52540 : 0041170", "SSF51735 : 0048414", 
                      "SSF51351 : 0045199", "SSF52833 : 0051125", "PF08162 : NUC189", 
                      "SSF54534 : 0042567", "TIGR00456 : argS", "SSF51011 : 0046265", 
                      "SSF55729 : 0049641", "SSF48403 : 0045933", "PS50800 : SAP", 
                      "SSF47240 : 0051415", "PR00407 : EUMOPTERIN", "SSF51735 : 0035018", 
                      "SSF51735 : 0051279", "SSF52540 : 0050989", "SSF55298 : 0042681", 
                      "SSF56601 : 0046343", "SSF46689 : 0052830", "SSF48097 : 0038947", 
                      "SSF47473 : 0049189", "PIRSF000076 :", "SSF51197 : 0050415", 
                      "SSF53218 : 0050702", "SSF57190 : 0039084", "SSF48726 : 0047626", 
                      "PD009619 :", "SSF50939 : 0045570", "SSF57716 : 0040589", "SSF48695 : 0046401", 
                      "PF08615 : RNase_H1_sml", "TIGR00099 : Cof-subfamily", "SSF52058 : 0051010", 
                      "SSF50324 : 0045663", "SSF101386 : 0050348", "SSF53697 : 0044035", 
                      "SSF82771 : 0040970", "SSF51445 : 0046924", "SSF47240 : 0040076", 
                      "PF00710 : Asparaginase", "SSF56601 : 0049712", "SSF46689 : 0048195", 
                      "PF03153 : TFIIA", "PR01163 : BETATUBULIN", "SSF50494 : 0048635", 
                      "SSF56672 : 0041083", "SSF49503 : 0053372", "SSF56601 : 0045791", 
                      "SSF52540 : 0040709", "SSF50998 : 0040282", "SSF49835 : 0052557", 
                      "PF02922 : Isoamylase_N", "TIGR01478 : STEVOR", "SSF57652 : 0039185", 
                      "SSF53098 : 0039430", "PF01747 : ATP-sulfurylase", "SSF54862 : 0045037", 
                      "SSF49373 : 0037301", "SSF50324 : 0048937", "SSF55021 : 0053024", 
                      "SSF51445 : 0045994", "SSF57716 : 0038158", "SSF53850 : 0043987", 
                      "SSF56935 : 0053278", "SSF54919 : 0047204", "PIRSF015950 :", 
                      "SSF46689 : 0039173", "SSF52540 : 0044835", "SSF50129 : 0036234", 
                      "SSF55486 : 0050667", "SSF48726 : 0046212", "PS50142 : RNASE_3_2", 
                      "SSF54236 : 0050735", "SSF88713 : 0052143", "PD003697 :", "SSF52172 : 0051573", 
                      "PF00827 : Ribosomal_L15e", "SSF54427 : 0048458", "PF02676 : TYW3", 
                      "SSF54909 : 0052703", "SSF51366 : 0037027", "PF00389 : 2-Hacid_dh", 
                      "SSF81342 : 0035453", "PS50897 : CTLH", "SSF50156 : 0049876", 
                      "SSF52402 : 0036972", "TIGR01488 : HAD-SF-IB", "SSF74653 : 0039034", 
                      "SSF56327 : 0047067", "SSF46934 : 0050160", "SSF48029 : 0040533", 
                      "PF04707 : PRELI", "SSF47240 : 0038489", "SSF49785 : 0047740", 
                      "SSF49401 : 0048577", "SSF51294 : 0047695", "SSF50156 : 0040317", 
                      "SSF46946 : 0043945", "PF00188 : SCP", "SSF51735 : 0045344", 
                      "SSF54427 : 0047080", "SSF46689 : 0047677", "SSF49785 : 0042380", 
                      "TIGR00046 : TIGR00046", "SSF52540 : 0051793", "SSF55545 : 0047767", 
                      "SSF46785 : 0043669", "SSF55347 : 0036543", "SSF52540 : 0044740", 
                      "SSF49265 : 0048290", "SSF81631 : 0051903", "PIRSF018147 :", 
                      "PD007457 :", "SSF50044 : 0050583", "SSF53218 : 0039613", "SSF100879 : 0043855", 
                      "SSF53850 : 0039038", "PF06188 : HrpE", "PF00169 : PH", "SSF53590 : 0038660", 
                      "SSF51395 : 0042077", "SSF103637 : 0042508", "SSF57440 : 0038481", 
                      "SSF88659 : 0043523", "PF07052 : Hep_59", "SSF56235 : 0039335", 
                      "TIGR01242 : 26Sp45", "SSF55008 : 0048621", "PF08609 : Fes1", 
                      "SSF46689 : 0049523", "SSF55271 : 0036750", "SSF53092 : 0048827", 
                      "PIRSF032184 :", "SSF101898 : 0043395", "SSF48613 : 0039400", 
                      "SSF46689 : 0039534", "SSF50156 : 0040883", "SSF55008 : 0042999", 
                      "PR00404 : MADSDOMAIN", "PF08492 : SRP72", "SSF55008 : 0042662", 
                      "SSF88659 : 0039238", "SSF47874 : 0034944", "SSF51658 : 0053353", 
                      "SSF52467 : 0036270", "SSF54919 : 0051631", "SSF52954 : 0041631", 
                      "PF02880 : PGM_PMM_III", "PF01516 : Orbi_VP6", "SSF52218 : 0042953", 
                      "SSF52075 : 0046394", "SSF54637 : 0040973", "SSF111347 : 0043732", 
                      "SSF46689 : 0045889", "SSF52980 : 0051683", "SSF47473 : 0045207", 
                      "SSF46894 : 0041963", "SSF50104 : 0049199", "SSF56219 : 0047174", 
                      "SSF51905 : 0039664", "PR01852 : SIBAPROTEIN", "SSF52833 : 0038799", 
                      "PD216134 :", "SSF54637 : 0047466", "SSF109604 : 0043929", "SSF52540 : 0044777", 
                      "SSF52374 : 0046940", "SSF49265 : 0046822", "SSF50249 : 0040310", 
                      "SSF55811 : 0039867", "SSF51445 : 0043665", "PD005653 :", "SSF51905 : 0048365", 
                      "SSF46689 : 0035200", "PF09745 : DUF2040", "SSF51735 : 0051093", 
                      "TIGR01604 : PYST-C2", "SSF49503 : 0034897", "TIGR00576 : dut", 
                      "SSF48576 : 0048261", "SSF51445 : 0049622", "SSF49899 : 0046331", 
                      "SSF48726 : 0045133", "SSF49265 : 0052411", "SSF49417 : 0045949", 
                      "SSF52540 : 0047259", "SSF54427 : 0038323", "PF04857 : CAF1", 
                      "SSF50249 : 0051100", "SSF52402 : 0040967", "SSF55620 : 0050713", 
                      "PF00364 : Biotin_lipoyl", "SSF81593 : 0047644", "SSF54001 : 0051417", 
                      "SSF49417 : 0038434", "SSF46689 : 0052393", "PF02071 : NSF", 
                      "SSF81321 : 0047106", "TIGR00650 : MG442", "SSF56276 : 0039506", 
                      "PF08124 : Lyase_8_N", "SSF54782 : 0047053", "SSF53784 : 0045548", 
                      "SSF51735 : 0048614", "SSF50447 : 0037246", "SSF48726 : 0039008", 
                      "SSF57667 : 0043977", "SSF55785 : 0035787", "SSF47565 : 0043025", 
                      "SSF53187 : 0046397", "PR00843 : GLHYDRLASE30", "PF01757 : Acyl_transf_3", 
                      "SSF48726 : 0045111", "SSF47473 : 0035639", "PD007730 :", "SSF48019 : 0043793", 
                      "SSF54373 : 0036093", "TIGR01311 : glycerol_kin", "SSF46589 : 0040635", 
                      "SSF53901 : 0035563", "SSF51011 : 0039306", "PIRSF000106 :", 
                      "SSF103263 : 0042573", "SSF50891 : 0052109", "SSF54631 : 0041683", 
                      "PF00041 : fn3", "PF04851 : ResIII", "SSF51197 : 0050303", "SSF53474 : 0038667", 
                      "PR01270 : HDASUPER", "SSF52540 : 0037955", "SSF47598 : 0039155", 
                      "SSF50249 : 0051771", "SSF56281 : 0040174", "SSF68923 : 0039346", 
                      "SSF49899 : 0041195", "SSF50939 : 0045432", "PF00097 : zf-C3HC4", 
                      "PF08553 : VID27", "SSF53697 : 0038344", "SSF48557 : 0035831", 
                      "PD001010 :", "SSF88697 : 0044757", "SSF48371 : 0050416", "SSF52242 : 0046814", 
                      "SSF88659 : 0049223", "SSF88633 : 0043086", "PF01652 : IF4E", 
                      "SSF81296 : 0036254", "SSF51445 : 0045253", "SSF52467 : 0053226", 
                      "SSF52058 : 0039015", "SSF52821 : 0043033", "PF00618 : RasGEF_N", 
                      "TIGR00463 : gltX_arch", "SSF55874 : 0048223", "PF04072 : LCM", 
                      "SSF51905 : 0052600", "TIGR02348 : GroEL", "SSF46458 : 0038916", 
                      "SSF47072 : 0053030", "SSF50814 : 0052746", "PF07933 : DUF1681", 
                      "SSF52374 : 0047774", "SSF54637 : 0053001", "PF05557 : MAD", 
                      "PD104536 :", "SSF81296 : 0047590", "SSF48619 : 0044450", "SSF52540 : 0040074", 
                      "SSF51735 : 0053195", "TIGR03081 : metmalonyl_epim", "SSF100950 : 0051773", 
                      "SSF51445 : 0038398", "SSF52172 : 0040867", "SSF53335 : 0050919", 
                      "SSF51445 : 0046470", "PF02252 : PA28_beta", "PF01569 : PAP2", 
                      "SSF47266 : 0047986", "SSF81296 : 0052437", "SSF52833 : 0045004", 
                      "SSF54001 : 0051581", "SSF50156 : 0044312", "SSF55307 : 0050369", 
                      "SSF56327 : 0044475", "TIGR01456 : CECR5", "SSF47473 : 0048981", 
                      "SSF54060 : 0034919", "SSF56854 : 0046035", "SSF52029 : 0043735", 
                      "SSF51445 : 0046176", "SSF48726 : 0041365", "SSF52016 : 0051894", 
                      "SSF53187 : 0053258", "SSF46458 : 0041146", "SSF51322 : 0045510", 
                      "SSF57059 : 0037780", "SSF54452 : 0038700", "PR01574 : TUBBYPROTEIN", 
                      "PIRSF027019 :", "SSF88633 : 0035877", "PD095266 :", "SSF52833 : 0046836", 
                      "SSF51430 : 0049058", "SSF51569 : 0046288", "SSF56601 : 0046147", 
                      "SSF52242 : 0045651", "PF00590 : TP_methylase", "SSF56327 : 0051214", 
                      "SSF52980 : 0035276", "SSF46997 : 0036920", "SSF48371 : 0042225", 
                      "PF08430 : Fork_head_N", "PF10436 : BCDHK_Adom3", "SSF50044 : 0037667", 
                      "SSF51445 : 0045806", "SSF81382 : 0037739", "SSF54098 : 0035303", 
                      "SSF49503 : 0041161", "SSF52374 : 0041067", "SSF55331 : 0040905", 
                      "SSF51445 : 0035171", "PF01483 : P_proprotein", "SSF51905 : 0047068", 
                      "PF05686 : DUF821", "SSF57059 : 0050987", "SSF48371 : 0040631", 
                      "SSF47175 : 0045211", "SSF50353 : 0045978", "SSF53474 : 0044976", 
                      "TIGR00592 : pol2", "SSF102114 : 0044131", "SSF53187 : 0048085", 
                      "SSF49599 : 0039868", "SSF47188 : 0038870", "SSF55729 : 0043317", 
                      "SSF50182 : 0052794", "SSF81296 : 0035736", "PF06320 : GCN5L1", 
                      "SSF47789 : 0046369", "SSF49899 : 0039102", "SSF55753 : 0036074", 
                      "SSF54236 : 0044282", "PF04230 : PS_pyruv_trans", "SSF56112 : 0046998", 
                      "SSF52540 : 0042178", "SSF52540 : 0047372", "PF00205 : TPP_enzyme_M", 
                      "SSF54786 : 0036551", "PF04073 : YbaK", "SSF50156 : 0042687", 
                      "SSF53756 : 0052910", "SSF48726 : 0045270", "SSF54292 : 0034918", 
                      "SSF56784 : 0044810", "SSF53671 : 0036650", "PF07741 : BRF1", 
                      "SSF46689 : 0052261", "SSF53448 : 0046466", "SSF48726 : 0052635", 
                      "SSF55486 : 0049211", "PF01088 : Peptidase_C12", "SSF48425 : 0042242", 
                      "PR00304 : TCOMPLEXTCP1", "SSF54511 : 0051069", "SSF47769 : 0049478", 
                      "SSF81340 : 0040198", "SSF55464 : 0040363", "SSF56655 : 0047954", 
                      "SSF48726 : 0042051", "SSF52374 : 0040696", "SSF48600 : 0052994", 
                      "SSF48508 : 0036469", "PF05967 : DUF887", "SSF101912 : 0048597", 
                      "PD360721 :", "SSF54160 : 0048746", "SSF53300 : 0047569", "SSF53187 : 0048430", 
                      "PF00985 : MSA_2", "TIGR00336 : pyrE", "SSF53218 : 0036881", 
                      "PF08551 : DUF1751", "PF08512 : Rtt106", "SSF53850 : 0037771", 
                      "SSF50800 : 0036700", "SSF55298 : 0052325", "PR01519 : EPSLNTUBULIN", 
                      "SSF81296 : 0037198", "TIGR00746 : arcC", "SSF51556 : 0051322", 
                      "SSF56784 : 0049197", "SSF48508 : 0043092", "SSF56994 : 0049626", 
                      "PF03647 : Tmemb_14", "SSF51569 : 0044753", "SSF51419 : 0046211", 
                      "TIGR02477 : PFKA_PPi", "SSF55658 : 0052998", "PF09767 : DUF2053", 
                      "SSF88697 : 0051801", "SSF81878 : 0039280", "SSF47226 : 0051209", 
                      "SSF51161 : 0047822", "PD000010 :", "SSF46929 : 0035730", "SSF57868 : 0039576", 
                      "SSF47954 : 0037399", "PS50988 : TROVE", "SSF57535 : 0038220", 
                      "SSF55347 : 0040869", "SSF53955 : 0038582", "SSF55031 : 0047972", 
                      "PF01367 : 5_3_exonuc", "SSF53901 : 0047210", "SSF50118 : 0051725", 
                      "SSF49503 : 0045649", "SSF53032 : 0043077", "SSF53590 : 0042656", 
                      "SSF51445 : 0036182", "PF03431 : RNA_replicase_B", "SSF52540 : 0036030", 
                      "SSF52540 : 0044086", "SSF103612 : 0044421", "PF08033 : Sec23_BS", 
                      "SSF56629 : 0039181", "SSF50494 : 0034885", "SSF47831 : 0045134", 
                      "SSF51905 : 0035128", "SSF53927 : 0051482", "TIGR03328 : salvage_mtnB", 
                      "PF00941 : FAD_binding_5", "SSF63380 : 0046305", "SSF53686 : 0041688", 
                      "SSF56059 : 0040724", "SSF47413 : 0044521", "SSF47220 : 0038436", 
                      "SSF57095 : 0038891", "SSF57716 : 0052307", "SSF51735 : 0038279", 
                      "SSF54897 : 0045841", "SSF53613 : 0040362", "SSF55895 : 0035643", 
                      "SSF81296 : 0047633", "SSF47413 : 0053040", "SSF52540 : 0034933", 
                      "SSF47473 : 0047687", "SSF55681 : 0035798", "SSF50182 : 0035326", 
                      "SSF47459 : 0041437", "SSF88723 : 0035344", "SSF54897 : 0040159", 
                      "SSF101887 : 0043465", "SSF53748 : 0040654", "SSF48452 : 0038771", 
                      "SSF54452 : 0039961", "SSF50182 : 0041138", "SSF52833 : 0044270", 
                      "SSF111321 : 0052852", "PR00626 : CALRETICULIN", "PF02045 : CBFB_NFYA", 
                      "SSF47226 : 0051419", "PD000395 :", "SSF51197 : 0047105", "SSF54928 : 0047631", 
                      "SSF51206 : 0036185", "SSF57903 : 0050462", "PF04056 : Ssl1", 
                      "SSF54189 : 0041253", "SSF47345 : 0037091", "SSF56281 : 0036363", 
                      "SSF49503 : 0038327", "SSF51735 : 0035340", "PF05648 : PEX11", 
                      "SSF52833 : 0038457", "SSF50182 : 0038865", "SSF53271 : 0040356", 
                      "SSF47203 : 0035713", "SSF100950 : 0052828", "SSF54675 : 0042684", 
                      "PF00764 : Arginosuc_synth", "SSF46458 : 0041879", "SSF56204 : 0048334", 
                      "SSF49503 : 0041414", "SSF56281 : 0043666", "SSF57667 : 0050859", 
                      "SSF51110 : 0035744", "SSF50814 : 0035228", "PF04898 : Glu_syn_central", 
                      "SSF51445 : 0046595", "SSF55347 : 0044809", "SSF51735 : 0040994", 
                      "PS51017 : CCT", "SSF51604 : 0048224", "TIGR01784 : T_den_put_tspse", 
                      "SSF51695 : 0053280", "PIRSF028758 :", "PS51096 : PTS_EIIA_TYPE_4", 
                      "SSF55455 : 0041235", "SSF49899 : 0048386", "SSF56042 : 0044822", 
                      "SSF48726 : 0045491", "SSF55486 : 0039411", "SSF50494 : 0046602", 
                      "SSF47266 : 0048829", "SSF88633 : 0053349", "PS50134 : ZF_TAZ", 
                      "PD003662 :", "SSF51604 : 0036852", "SSF51395 : 0042611", "SSF48726 : 0036169", 
                      "SSF48726 : 0052909", "SSF52540 : 0049190", "SSF52218 : 0047543", 
                      "SSF57802 : 0044923", "SSF54495 : 0048879", "SSF46785 : 0045974", 
                      "SSF47266 : 0036943", "SSF53955 : 0038111", "SSF52335 : 0045748", 
                      "SSF51658 : 0045612", "PF09783 : Vac_ImportDeg", "PF05291 : Bystin", 
                      "PF00225 : Kinesin", "SSF51905 : 0052926", "SSF53807 : 0040948", 
                      "SSF46785 : 0049797", "SSF53850 : 0034962", "SSF47240 : 0043825", 
                      "PF04029 : 2-ph_phosp", "SSF54506 : 0035750", "PD001963 :", "SSF69318 : 0039773", 
                      "PR00239 : RHODOPSNTAIL", "SSF55931 : 0044108", "SSF55945 : 0042875", 
                      "SSF56436 : 0037601", "SSF53850 : 0049987", "SSF55676 : 0035905", 
                      "SSF48225 : 0046353", "SSF48726 : 0038013", "SSF48403 : 0043510", 
                      "SSF52540 : 0040747", "SSF88697 : 0051036", "SSF52980 : 0045286", 
                      "SSF48113 : 0041762", "PF00447 : HSF_DNA-bind", "SSF54427 : 0050285", 
                      "SSF82861 : 0053244", "SSF55120 : 0039976", "SSF49441 : 0038537", 
                      "SSF54752 : 0044264", "TIGR00017 : cmk", "SSF46458 : 0043838", 
                      "SSF56281 : 0048073", "PS50011 : PROTEIN_KINASE_DOM", "SSF54427 : 0044127", 
                      "SSF52949 : 0038333", "SSF51735 : 0038567", "SSF48239 : 0038806", 
                      "SSF49998 : 0037056", "PF02732 : ERCC4", "SSF46458 : 0039500", 
                      "SSF54236 : 0043186", "PR00372 : FYWHYDRXLASE", "SSF55550 : 0041112", 
                      "SSF53383 : 0037484", "SSF53474 : 0039081", "PD020623 :", "PD003854 :", 
                      "TIGR01139 : cysK", "SSF53187 : 0052787", "SSF56327 : 0044226", 
                      "SSF49503 : 0044953", "SSF55008 : 0037802", "SSF46458 : 0045308", 
                      "SSF53597 : 0053378", "PF01361 : Tautomerase", "PF00433 : Pkinase_C", 
                      "SSF57868 : 0040935", "SSF52402 : 0050746", "SSF49879 : 0036359", 
                      "SSF49503 : 0043556", "SSF53623 : 0042137", "SSF49348 : 0048311", 
                      "PR00716 : MPIPHPHTASE", "SSF55267 : 0043081", "SSF56629 : 0040444", 
                      "PIRSF009449 :", "SSF49863 : 0049252", "SSF56112 : 0050905", 
                      "SSF53633 : 0052013", "PF02866 : Ldh_1_C", "SSF49265 : 0052314", 
                      "SSF49354 : 0049045", "PF09729 : Gti1_Pac2", "SSF52799 : 0040765", 
                      "SSF53633 : 0051788", "PF06421 : LepA_C", "TIGR01324 : cysta_beta_ly_B", 
                      "SSF50156 : 0044437", "SSF52540 : 0048939", "SSF51182 : 0046333", 
                      "SSF54416 : 0041760", "SSF51735 : 0042340", "PF00709 : Adenylsucc_synt", 
                      "SSF51445 : 0038623", "PF01458 : UPF0051", "SSF54975 : 0035160", 
                      "SSF48264 : 0041273", "SSF52374 : 0041647", "SSF54358 : 0037082", 
                      "SSF52172 : 0045700", "SSF52833 : 0037972", "PF01210 : NAD_Gly3P_dh_N", 
                      "SSF51445 : 0050130", "SSF81296 : 0049153", "PF00311 : PEPcase", 
                      "SSF55315 : 0036820", "SSF49899 : 0037694", "TIGR00167 : cbbA", 
                      "SSF46458 : 0045725", "SSF53300 : 0043617", "SSF51230 : 0047951", 
                      "SSF46785 : 0050048", "SSF51182 : 0043376", "SSF51445 : 0036759", 
                      "SSF50784 : 0041588", "SSF81660 : 0043764", "SSF47807 : 0045054", 
                      "SSF52172 : 0034799", "PF01379 : Porphobil_deam", "SSF52799 : 0036282", 
                      "SSF46774 : 0040133", "PF00551 : Formyl_trans_N", "SSF47655 : 0045952", 
                      "PF00999 : Na_H_Exchanger", "SSF51735 : 0037188", "PF01180 : DHO_dh", 
                      "SSF56655 : 0036465", "PF08572 : PRP3", "PF03853 : YjeF_N", "SSF48726 : 0049164", 
                      "SSF103642 : 0049654", "PS51224 : MVP", "SSF51126 : 0042926", 
                      "SSF50494 : 0040691", "PF04446 : Thg1", "SSF52141 : 0053053", 
                      "SSF54791 : 0052294", "SSF56235 : 0043428", "SSF51735 : 0035471", 
                      "PIRSF018153 :", "SSF48537 : 0040089", "SSF46458 : 0038490", 
                      "SSF55331 : 0047087", "SSF52172 : 0051898", "SSF50630 : 0044982", 
                      "SSF53098 : 0051538", "SSF54001 : 0053121", "SSF52540 : 0035641", 
                      "SSF57802 : 0043187", "SSF53795 : 0047370", "PS50198 : PPIC_PPIASE_2", 
                      "SSF55874 : 0053133", "SSF51735 : 0051305", "PF06090 : DUF941", 
                      "SSF51445 : 0042235", "PF10153 : DUF2361", "SSF57095 : 0044898", 
                      "SSF50923 : 0049470", "SSF56796 : 0044392", "SSF69572 : 0051360", 
                      "SSF50370 : 0044696", "SSF53187 : 0046827", "SSF50677 : 0038029", 
                      "SSF52540 : 0037045", "SSF54585 : 0036730", "PF08737 : Rgp1", 
                      "SSF51445 : 0041250", "TIGR00527 : gcvH", "SSF49785 : 0052854", 
                      "PF01793 : Glyco_transf_15", "SSF47473 : 0043503", "SSF53681 : 0039523", 
                      "PR00127 : CLPPROTEASEP", "SSF51735 : 0052284", "SSF51445 : 0050870", 
                      "SSF57440 : 0040096", "SSF54534 : 0035600", "SSF53187 : 0041773", 
                      "SSF55729 : 0052858", "PF02036 : SCP2", "PIRSF016408 :", "SSF46458 : 0038624", 
                      "PF02110 : HK", "SSF81296 : 0048306", "PD004193 :", "SSF56024 : 0053239", 
                      "PR00352 : 3FE4SFRDOXIN", "SSF49313 : 0036918", "SSF51735 : 0041888", 
                      "SSF53383 : 0035580", "SSF46689 : 0048440", "SSF56042 : 0049529", 
                      "PS50010 : DH_2", "SSF47203 : 0049931", "SSF49265 : 0038102", 
                      "TIGR00172 : maf", "SSF48726 : 0038563", "SSF56436 : 0035634", 
                      "SSF56796 : 0036562", "SSF50814 : 0042945", "SSF55608 : 0036398", 
                      "PD117885 :", "SSF55811 : 0046700", "SSF90123 : 0042281", "SSF56399 : 0041884", 
                      "SSF52540 : 0045785", "PS50108 : CRIB", "SSF52255 : 0051027", 
                      "PF01238 : PMI_typeI", "PR00072 : MALOXRDTASE", "SSF53328 : 0037671", 
                      "SSF50203 : 0037184", "SSF51569 : 0049661", "SSF52922 : 0044103", 
                      "SSF53067 : 0051457", "SSF55073 : 0046870", "SSF51735 : 0051575", 
                      "PS50078 : POLO_BOX", "PF08608 : Wyosine_form", "SSF63491 : 0047251", 
                      "SSF54897 : 0047902", "SSF51338 : 0039933", "PF02824 : TGS", 
                      "PF07258 : HCaRG", "SSF50156 : 0037485", "SSF50891 : 0052763", 
                      "PF03415 : Peptidase_C11", "PF02987 : LEA_4", "PF01315 : Ald_Xan_dh_C", 
                      "SSF52540 : 0036279", "PD000003 :", "SSF48150 : 0036894", "SSF48726 : 0045007", 
                      "SSF49265 : 0037415", "SSF53335 : 0037478", "SSF50353 : 0045661", 
                      "SSF56519 : 0050286", "SSF46785 : 0047770", "SSF53649 : 0037763", 
                      "PF03357 : Snf7", "SSF54919 : 0045939", "SSF51045 : 0051430", 
                      "SSF49899 : 0046956", "SSF47473 : 0042847", "SSF48557 : 0043207", 
                      "SSF52141 : 0044375", "SSF57247 : 0046066", "SSF52540 : 0042280", 
                      "SSF81296 : 0040711", "SSF56784 : 0053006", "PF01295 : Adenylate_cycl", 
                      "SSF51351 : 0043941", "SSF50386 : 0045494", "SSF100950 : 0040229", 
                      "SSF49899 : 0041068", "SSF52172 : 0042065", "SSF55874 : 0043142", 
                      "SSF52374 : 0038394", "SSF57059 : 0040665", "SSF54001 : 0046968", 
                      "SSF46785 : 0047585", "SSF51445 : 0051664", "SSF53474 : 0048965", 
                      "SSF81811 : 0040752", "SSF48371 : 0043958", "SSF81296 : 0050400", 
                      "SSF75625 : 0040484", "PIRSF002148 :", "SSF51604 : 0043636", 
                      "SSF50814 : 0052750", "SSF54695 : 0037241", "SSF56235 : 0049273", 
                      "SSF50494 : 0048877", "SSF81660 : 0041020", "PR00458 : PEROXIDASE", 
                      "PF07081 : DUF1349", "SSF54791 : 0039369", "SSF51445 : 0046782", 
                      "SSF51338 : 0041659", "PF01471 : PG_binding_1", "TIGR00561 : pntA", 
                      "SSF57850 : 0047625", "SSF53187 : 0050200", "SSF81273 : 0047212", 
                      "SSF49299 : 0035353", "SSF56024 : 0042590", "PD006591 :", "SSF50615 : 0043650", 
                      "SSF54849 : 0034905", "SSF52499 : 0041359", "SSF56436 : 0046868", 
                      "SSF57783 : 0038876", "SSF56436 : 0042097", "PF01431 : Peptidase_M13", 
                      "SSF55008 : 0047718", "SSF54556 : 0051087", "SSF52317 : 0043013", 
                      "PR01713 : NUCEPIMERASE", "SSF49503 : 0041598", "PF00562 : RNA_pol_Rpb2_6", 
                      "SSF51366 : 0049228", "SSF51445 : 0046229", "SSF74924 : 0050559", 
                      "SSF69705 : 0038593", "PF03130 : HEAT_PBS", "SSF69635 : 0039936", 
                      "SSF56436 : 0044536", "SSF53098 : 0044995", "SSF50715 : 0036409", 
                      "SSF49265 : 0049605", "SSF56059 : 0036442", "SSF52499 : 0045069", 
                      "SSF57027 : 0053175", "SSF51110 : 0035745", "SSF47473 : 0039003", 
                      "SSF51730 : 0050099", "SSF52743 : 0043627", "SSF47090 : 0040446", 
                      "SSF51989 : 0052024", "PF00464 : SHMT", "SSF57196 : 0035212", 
                      "SSF48557 : 0049643", "SSF46626 : 0036885", "SSF56235 : 0039167", 
                      "SSF53271 : 0048493", "SSF48498 : 0050189", "SSF54593 : 0043737", 
                      "SSF53167 : 0050047", "PIRSF028043 :", "SSF52540 : 0046315", 
                      "PS50186 : DEP", "PIRSF003033 :", "SSF52255 : 0044185", "SSF50405 : 0036399", 
                      "SSF50156 : 0041357", "SSF52540 : 0046157", "PD001827 :", "SSF55724 : 0044116", 
                      "SSF51621 : 0044395", "SSF81296 : 0048941", "SSF57095 : 0047038", 
                      "PR00906 : SECA", "SSF52343 : 0042994", "SSF56796 : 0043359", 
                      "SSF54277 : 0048864", "SSF56672 : 0044996", "PR00862 : PROLIGOPTASE", 
                      "TIGR00612 : ispG_gcpE", "SSF46626 : 0036078", "SSF50370 : 0038091", 
                      "SSF53822 : 0052792", "SSF55469 : 0036576", "SSF51445 : 0051146", 
                      "PF05517 : p25-alpha", "SSF54495 : 0051478", "TIGR00522 : dph5", 
                      "SSF50203 : 0051814", "SSF51569 : 0041947", "TIGR02188 : Ac_CoA_lig_AcsA", 
                      "SSF90229 : 0040854", "SSF53850 : 0047639", "SSF46458 : 0039187", 
                      "SSF81296 : 0044516", "SSF48452 : 0046495", "SSF48726 : 0035807", 
                      "SSF50249 : 0038054", "SSF52833 : 0053013", "SSF55031 : 0035970", 
                      "SSF51011 : 0035611", "SSF51735 : 0039935", "SSF51569 : 0048245", 
                      "PF00234 : Tryp_alpha_amyl", "PR00315 : ELONGATNFCT", "SSF56645 : 0052090", 
                      "SSF53383 : 0046547", "SSF88633 : 0049017", "PF00132 : Hexapep", 
                      "SSF57756 : 0034900", "SSF54098 : 0051151", "SSF55347 : 0049076", 
                      "PF03097 : BRO1", "SSF52129 : 0039807", "SSF50814 : 0037195", 
                      "SSF46689 : 0046275", "SSF56425 : 0036265", "SSF50475 : 0037968", 
                      "SSF47240 : 0042764", "SSF53901 : 0049717", "SSF50729 : 0045916", 
                      "SSF49503 : 0052176", "SSF49503 : 0035035", "SSF101908 : 0049172", 
                      "SSF51569 : 0048940", "SSF69572 : 0051359", "SSF52949 : 0051745", 
                      "SSF51735 : 0035305", "SSF100879 : 0039568", "SSF57196 : 0045767", 
                      "SSF52374 : 0038403", "SSF50156 : 0052727", "PS50060 : MAM_2", 
                      "SSF48726 : 0037255", "SSF54719 : 0041143", "SSF49493 : 0035834", 
                      "PF06268 : Fascin", "SSF56327 : 0045345", "SSF49309 : 0040428", 
                      "PF09359 : VTC", "SSF88697 : 0051810", "SSF56091 : 0036424", 
                      "SSF57095 : 0038634", "SSF55550 : 0049229", "SSF49299 : 0040346", 
                      "PF01974 : tRNA_int_endo", "SSF54826 : 0043071", "PF00754 : F5_F8_type_C", 
                      "SSF55620 : 0051676", "SSF90096 : 0039298", "SSF54957 : 0037453", 
                      "SSF56327 : 0048849", "PS51011 : ARID", "SSF52833 : 0036343", 
                      "SSF56854 : 0037948", "SSF52540 : 0040984", "SSF47240 : 0051506", 
                      "SSF47220 : 0043750", "SSF88633 : 0053182", "SSF47240 : 0035023", 
                      "PF08324 : PUL", "SSF47598 : 0042628", "SSF56091 : 0045687", 
                      "SSF51445 : 0046336", "PF04095 : NAPRTase", "SSF57535 : 0042989", 
                      "PF03165 : MH1", "SSF54909 : 0053018", "PF00479 : G6PD_N", "PR01303 : CRCMSPRZOITE", 
                      "SSF52402 : 0043381", "TIGR01120 : rpiB", "TIGR01364 : serC_1", 
                      "TIGR00343 : TIGR00343", "SSF56601 : 0052119", "PF06127 : DUF962", 
                      "PF01966 : HD", "PF03568 : Peptidase_C50", "SSF56219 : 0038937", 
                      "PF04636 : PA26", "PF03876 : RNA_pol_Rpb7_N", "SSF51011 : 0046138", 
                      "SSF52172 : 0041609", "SSF47473 : 0048820", "PF04560 : RNA_pol_Rpb2_7", 
                      "SSF54862 : 0042562", "SSF53300 : 0051423", "PS50893 : ABC_TRANSPORTER_2", 
                      "PF00534 : Glycos_transf_1", "SSF51735 : 0047655", "SSF53254 : 0049059", 
                      "SSF51445 : 0048295", "SSF57059 : 0039266", "PF04982 : HPP", 
                      "SSF53474 : 0038209", "SSF47794 : 0048851", "PIRSF006232 :", 
                      "SSF54236 : 0044626", "SSF54675 : 0044878", "SSF52218 : 0046417", 
                      "SSF46626 : 0036087", "SSF57362 : 0044071", "SSF56112 : 0035615", 
                      "SSF55248 : 0049243", "SSF50022 : 0043222", "SSF53850 : 0046289", 
                      "SSF51735 : 0044838", "SSF48452 : 0052670", "SSF51905 : 0041375", 
                      "SSF52058 : 0036347", "SSF54909 : 0042616", "SSF48371 : 0042771", 
                      "SSF54427 : 0041823", "SSF52467 : 0048796", "SSF46785 : 0042414", 
                      "SSF46458 : 0051063", "SSF47592 : 0045078", "PF09341 : Pcc1", 
                      "SSF52096 : 0036350", "SSF54897 : 0048728", "SSF50044 : 0047043", 
                      "SSF50156 : 0039878", "SSF51735 : 0040548", "SSF53474 : 0047601", 
                      "SSF52980 : 0043563", "PF03836 : RasGAP_C", "PF10371 : EKR", 
                      "SSF54452 : 0040584", "PF03878 : Hrf1", "SSF57802 : 0045435", 
                      "SSF54631 : 0052381", "SSF56003 : 0044866", "SSF52540 : 0049868", 
                      "SSF54534 : 0037129", "PF05620 : DUF788", "PF01853 : MOZ_SAS", 
                      "SSF50978 : 0048420", "SSF46689 : 0035607", "SSF53098 : 0049035", 
                      "PS51313 : VPS28_N", "SSF47616 : 0037583", "SSF53613 : 0050193", 
                      "PIRSF016487 :", "SSF51735 : 0048974", "PR01738 : RNABINDINGM8", 
                      "PD013422 :", "SSF52540 : 0040238", "PD005132 :", "PD027623 :", 
                      "SSF50685 : 0041177", "SSF56784 : 0049579", "SSF52518 : 0051271", 
                      "SSF46689 : 0042468", "SSF56655 : 0043698", "SSF56601 : 0041274", 
                      "SSF55979 : 0045420", "SSF50784 : 0045104", "SSF46906 : 0037716", 
                      "TIGR01891 : amidohydrolases", "SSF82607 : 0039418", "SSF52172 : 0048656", 
                      "SSF50249 : 0034810", "SSF50729 : 0050998", "SSF50891 : 0051693", 
                      "SSF50249 : 0050030", "SSF47175 : 0046196", "SSF56601 : 0048985", 
                      "SSF56436 : 0042719", "SSF50203 : 0043754", "PIRSF004848 :", 
                      "SSF47095 : 0052980", "SSF56918 : 0036645", "SSF53383 : 0048747", 
                      "PIRSF000723 :", "SSF51161 : 0041790", "SSF53649 : 0037220", 
                      "SSF54928 : 0046220", "SSF47413 : 0050602", "SSF54928 : 0050481", 
                      "PIRSF016104 :", "SSF53448 : 0039769", "SSF55711 : 0042982", 
                      "PF01363 : FYVE", "SSF57196 : 0046553", "SSF48452 : 0052100", 
                      "PF07517 : SecA_DEAD", "SSF49384 : 0037981", "PF04942 : CC", 
                      "SSF57440 : 0040225", "SSF50249 : 0052107", "SSF52833 : 0053311", 
                      "PF02142 : MGS", "SSF55785 : 0048248", "PF03719 : Ribosomal_S5_C", 
                      "PIRSF000345 :", "PIRSF038084 :", "PD000461 :", "PF07847 : DUF1637", 
                      "PS50961 : HTH_LA", "SSF69099 : 0047852", "SSF49599 : 0036213", 
                      "SSF49493 : 0035833", "SSF47240 : 0048355", "PR00126 : ATPASEGAMMA", 
                      "PF04722 : Ssu72", "SSF51445 : 0046559", "SSF54593 : 0041044", 
                      "SSF53213 : 0045989", "SSF52972 : 0051798", "SSF53335 : 0043157", 
                      "SSF50494 : 0036882", "PF05406 : WGR", "SSF52833 : 0037145", 
                      "SSF53187 : 0040300", "SSF48726 : 0042284", "SSF50249 : 0044297", 
                      "PF08282 : Hydrolase_3", "SSF52540 : 0036095", "PF00571 : CBS", 
                      "SSF46689 : 0045724", "SSF56436 : 0042149", "SSF57630 : 0040919", 
                      "SSF81301 : 0040172", "SSF47336 : 0036619", "SSF101156 : 0042261", 
                      "SSF46934 : 0041010", "SSF50729 : 0050517", "PS50293 : TPR_REGION", 
                      "SSF51206 : 0048340", "SSF52949 : 0041430", "SSF54160 : 0052720", 
                      "SSF54695 : 0041351", "PF04801 : Sin_N", "PF01365 : RYDR_ITPR", 
                      "SSF54211 : 0052323", "SSF47240 : 0051533", "SSF88697 : 0052824", 
                      "SSF52029 : 0047405", "SSF47473 : 0038475", "SSF103388 : 0043146", 
                      "SSF64356 : 0038304", "SSF57756 : 0034980", "PF07061 : Swi5", 
                      "SSF54862 : 0046879", "PF03232 : COQ7", "PIRSF006076 :", "SSF52467 : 0042043", 
                      "SSF51730 : 0045882", "PR00353 : 4FE4SFRDOXIN", "PF02037 : SAP", 
                      "PF01842 : ACT", "PF01112 : Asparaginase_2", "SSF102114 : 0049709", 
                      "SSF53659 : 0044220", "SSF55724 : 0044594", "SSF51206 : 0038754", 
                      "SSF81648 : 0048907", "SSF57196 : 0041570", "SSF51069 : 0037649", 
                      "PF08660 : Alg14", "SSF47113 : 0047349", "SSF100950 : 0042404", 
                      "SSF49503 : 0034895", "PF03914 : CBF", "SSF53686 : 0051225", 
                      "SSF51338 : 0047004", "TIGR00714 : hscB", "SSF101386 : 0053260", 
                      "SSF51989 : 0046426", "SSF52016 : 0034995", "SSF55821 : 0039944", 
                      "PF01980 : UPF0066", "SSF53850 : 0046398", "SSF89000 : 0043345", 
                      "PF08148 : DSHCT", "SSF110849 : 0044920", "SSF50353 : 0039029", 
                      "SSF54768 : 0041656", "TIGR01116 : ATPase-IIA1_Ca", "SSF51101 : 0039681", 
                      "SSF51735 : 0050967", "SSF57095 : 0035263", "SSF46689 : 0048725", 
                      "SSF52151 : 0048184", "PF03412 : Peptidase_C39", "PIRSF036852 :", 
                      "SSF53474 : 0041128", "SSF49503 : 0047645", "SSF47240 : 0052156", 
                      "SSF50494 : 0040351", "SSF51649 : 0046026", "SSF51905 : 0045532", 
                      "SSF50969 : 0045181", "SSF52016 : 0052934", "SSF56436 : 0047400", 
                      "SSF46966 : 0047168", "SSF52096 : 0050444", "SSF56672 : 0051078", 
                      "SSF52266 : 0039722", "SSF54328 : 0035623", "SSF51679 : 0048081", 
                      "SSF51430 : 0048247", "SSF54637 : 0050180", "PIRSF001549 :", 
                      "SSF57196 : 0038804", "PF08429 : PLU-1", "SSF57095 : 0050654", 
                      "SSF52242 : 0046110", "PF03435 : Saccharop_dh", "PD000066 :", 
                      "SSF48695 : 0040737", "SSF48019 : 0039135", "SSF46626 : 0046109", 
                      "SSF48065 : 0041563", "SSF56399 : 0034840", "PD074940 :", "PF08275 : Toprim_N", 
                      "SSF49503 : 0048788", "TIGR01513 : NAPRTase_put", "SSF54975 : 0049941", 
                      "PF08696 : Dna2", "SSF56300 : 0041478", "SSF55103 : 0036836", 
                      "SSF53850 : 0044383", "PIRSF000361 :", "SSF57603 : 0046485", 
                      "SSF110395 : 0049721", "SSF53383 : 0045231", "SSF55347 : 0051576", 
                      "SSF52029 : 0045723", "TIGR01691 : enolase-ppase", "SSF52540 : 0046162", 
                      "SSF55666 : 0042084", "SSF54585 : 0036202", "SSF52467 : 0048650", 
                      "PF00454 : PI3_PI4_kinase", "PD001018 :", "SSF51182 : 0048484", 
                      "SSF54928 : 0045893", "SSF51730 : 0047760", "TIGR00798 : mtc", 
                      "SSF54285 : 0050092", "SSF50939 : 0045176", "SSF53474 : 0037956", 
                      "SSF52402 : 0041746", "SSF54211 : 0042360", "SSF57059 : 0038844", 
                      "SSF48726 : 0035321", "SSF54197 : 0049287", "PS50943 : HTH_CROC1", 
                      "SSF57802 : 0043471", "SSF51735 : 0045444", "SSF54695 : 0040560", 
                      "PF07046 : CRA_rpt", "SSF53795 : 0047841", "SSF51306 : 0044449", 
                      "TIGR01042 : V-ATPase_V1_A", "SSF50630 : 0037661", "SSF46785 : 0052364", 
                      "SSF57095 : 0037581", "PF02920 : Integrase_DNA", "PR00105 : C5METTRFRASE", 
                      "PF05879 : RHD3", "PF01849 : NAC", "SSF49899 : 0044568", "SSF51395 : 0038195", 
                      "PF06479 : Ribonuc_2-5A", "PF05891 : DUF858", "SSF54593 : 0043713", 
                      "PR00131 : GLHYDRLASE1", "SSF51338 : 0041948", "SSF54862 : 0045859", 
                      "TIGR02180 : GRX_euk", "SSF57535 : 0049458", "PR00989 : ADENOKINASE", 
                      "SSF52374 : 0035377", "SSF51735 : 0047346", "SSF54593 : 0040617", 
                      "PF00856 : SET", "SSF50685 : 0045260", "SSF50789 : 0037642", 
                      "SSF52096 : 0051228", "SSF50729 : 0050918", "PD910989 :", "SSF51445 : 0049836", 
                      "SSF51735 : 0051285", "SSF51395 : 0038429", "SSF47220 : 0049462", 
                      "PR00470 : TRYPANRDTASE", "SSF49354 : 0041072", "SSF56726 : 0036260", 
                      "SSF54791 : 0051852", "SSF47576 : 0042680", "PF00266 : Aminotran_5", 
                      "SSF53067 : 0053211", "SSF56784 : 0047721", "SSF46689 : 0051446", 
                      "SSF49464 : 0044552", "SSF48726 : 0043413", "SSF47113 : 0049583", 
                      "PR00603 : CYTOCHROMEC1", "SSF53756 : 0052533", "SSF57095 : 0048772", 
                      "SSF57667 : 0043305", "SSF52242 : 0051084", "SSF54928 : 0046785", 
                      "SSF51621 : 0046386", "SSF111321 : 0052676", "SSF46973 : 0036717", 
                      "PF02278 : Lyase_8", "SSF46458 : 0044117", "SSF46785 : 0038845", 
                      "SSF49265 : 0045838", "SSF101790 : 0044876", "TIGR01300 : CPA3_mnhG_phaG", 
                      "SSF53774 : 0045600", "SSF46785 : 0049152", "SSF57302 : 0035991", 
                      "SSF51649 : 0035762", "SSF50814 : 0049020", "SSF51905 : 0037067", 
                      "PD332643 :", "SSF51045 : 0041718", "PF10350 : DUF2428", "SSF47769 : 0039562", 
                      "SSF54452 : 0039593", "SSF55307 : 0044123", "SSF57535 : 0047039", 
                      "SSF52540 : 0047701", "SSF50249 : 0045922", "SSF54862 : 0036048", 
                      "SSF53335 : 0041749", "SSF50447 : 0037975", "SSF57362 : 0044524", 
                      "SSF48726 : 0053296", "SSF49309 : 0047886", "SSF51412 : 0048832", 
                      "SSF49899 : 0051853", "PF02040 : ArsB", "PD414759 :", "TIGR01368 : CPSaseIIsmall", 
                      "PR00744 : GLHYDRLASE37", "SSF52540 : 0040383", "PIRSF000729 :", 
                      "SSF49265 : 0050831", "SSF46626 : 0052127", "SSF55785 : 0048459", 
                      "SSF51366 : 0045712", "PD001568 :", "PF03540 : TFIID_30kDa", 
                      "SSF81296 : 0052436", "SSF57667 : 0050784", "PF06306 : CgtA", 
                      "SSF51905 : 0038073", "TIGR01628 : PABP-1234", "SSF55729 : 0049031", 
                      "SSF52374 : 0039322", "SSF52540 : 0041439", "PD936484 :", "SSF50494 : 0044701", 
                      "SSF53955 : 0045261", "SSF56024 : 0050932", "SSF46785 : 0046129", 
                      "SSF47819 : 0051395", "SSF52540 : 0044125", "SSF88697 : 0050660", 
                      "SSF54117 : 0040844", "SSF53223 : 0035544", "SSF63867 : 0043849", 
                      "SSF63411 : 0038684", "SSF50814 : 0036686", "SSF48726 : 0035123", 
                      "PF07093 : SGT1", "SSF50090 : 0039151", "PF00867 : XPG_I", "SSF52540 : 0049837", 
                      "SSF68906 : 0051622", "PS51360 : PLUS3", "SSF52540 : 0049369", 
                      "SSF55753 : 0039550", "PIRSF003352 :", "SSF55856 : 0040960", 
                      "SSF54928 : 0046795", "SSF57196 : 0045050", "SSF53335 : 0053229", 
                      "SSF50882 : 0041624", "PF02320 : UCR_hinge", "PR01520 : ZETATUBULIN", 
                      "SSF54427 : 0039599", "PD003649 :", "SSF101576 : 0041713", "SSF88633 : 0039922", 
                      "SSF52540 : 0043912", "SSF51905 : 0048009", "SSF54328 : 0040384", 
                      "SSF51395 : 0049587", "SSF63380 : 0037503", "SSF52467 : 0044477", 
                      "SSF50729 : 0036787", "SSF54427 : 0042033", "SSF53697 : 0048425", 
                      "PD008105 :", "PS51128 : ZF_DKSA_2", "SSF47027 : 0047158", "SSF56059 : 0037191", 
                      "SSF46785 : 0050651", "SSF48371 : 0049802", "PF06244 : DUF1014", 
                      "SSF49899 : 0036670", "SSF54928 : 0045373", "SSF54292 : 0042474", 
                      "SSF48619 : 0037472", "SSF53244 : 0036833", "PF02463 : SMC_N", 
                      "SSF88713 : 0051516", "SSF51735 : 0045153", "SSF53927 : 0044240", 
                      "SSF56918 : 0039051", "SSF54534 : 0039255", "SSF48371 : 0046492", 
                      "SSF81296 : 0050094", "SSF55961 : 0037080", "SSF54001 : 0037874", 
                      "SSF56053 : 0043293", "SSF48726 : 0046821", "PS50890 : PUA", 
                      "SSF51905 : 0037509", "SSF57535 : 0037922", "SSF52540 : 0036317", 
                      "SSF54334 : 0037185", "SSF57868 : 0045598", "SSF56762 : 0037746", 
                      "SSF88633 : 0035628", "SSF53800 : 0048953", "SSF52833 : 0051504", 
                      "SSF50249 : 0039281", "SSF52833 : 0042387", "SSF55729 : 0050185", 
                      "SSF49562 : 0042685", "SSF47364 : 0039423", "SSF54373 : 0044415", 
                      "SSF49742 : 0048758", "SSF49723 : 0035711", "PF03878 : YIF1", 
                      "SSF50044 : 0045835", "SSF47175 : 0046484", "SSF49785 : 0050013", 
                      "SSF47473 : 0042389", "SSF48576 : 0043373", "SSF57716 : 0040440", 
                      "SSF57362 : 0046316", "PF08648 : DUF1777", "PF01187 : MIF", "SSF51430 : 0035031", 
                      "SSF50969 : 0040347", "PIRSF016325 :", "PF07186 : TraB_2", "SSF51735 : 0041583", 
                      "SSF56436 : 0051179", "PR01271 : HISDACETLASE", "SSF57095 : 0045971", 
                      "SSF50353 : 0038832", "TIGR02504 : NrdJ_Z", "PF01992 : vATP-synt_AC39", 
                      "SSF47616 : 0037349", "SSF52172 : 0050341", "SSF53271 : 0042536", 
                      "PF08189 : Meleagrin", "SSF57850 : 0052268", "SSF57667 : 0052279", 
                      "SSF48576 : 0046340", "PF07890 : Rrp15p", "PD098974 :", "SSF57059 : 0035036", 
                      "SSF54211 : 0036739", "SSF53822 : 0053227", "PF02086 : MethyltransfD12", 
                      "SSF53901 : 0044962", "SSF48371 : 0052026", "SSF90229 : 0049158", 
                      "PF08681 : DUF1778", "TIGR02414 : pepN_proteo", "SSF52980 : 0035231", 
                      "SSF54452 : 0038944", "SSF53822 : 0046641", "SSF81301 : 0043168", 
                      "SSF51246 : 0044723", "SSF53927 : 0050664", "PF06245 : DUF1015", 
                      "SSF50978 : 0044204", "SSF50405 : 0046322", "SSF49503 : 0035275", 
                      "SSF88633 : 0043244", "SSF49695 : 0038546", "SSF51735 : 0050237", 
                      "SSF51197 : 0039716", "SSF46785 : 0045802", "SSF52540 : 0051942", 
                      "PS50112 : PAS", "SSF46626 : 0045581", "SSF52833 : 0049249", 
                      "SSF46934 : 0050173", "SSF63380 : 0042993", "SSF54495 : 0051962", 
                      "SSF53659 : 0036060", "SSF57903 : 0048190", "SSF51230 : 0038110", 
                      "PF00970 : FAD_binding_6", "SSF81502 : 0044726", "TIGR02082 : metH", 
                      "SSF54928 : 0042859", "PF09797 : NatB_MDM20", "SSF51126 : 0038225", 
                      "PF03671 : Ufm1", "SSF55550 : 0045452", "SSF53383 : 0037076", 
                      "SSF51445 : 0049099", "SSF55729 : 0043712", "PF02798 : GST_N", 
                      "PF01925 : DUF81", "SSF50891 : 0036678", "SSF46929 : 0046020", 
                      "SSF54637 : 0044751", "SSF51569 : 0036772", "SSF53659 : 0050896", 
                      "SSF48726 : 0044717", "SSF47266 : 0045959", "PF05764 : YL1", 
                      "SSF57440 : 0040039", "SSF55831 : 0038750", "SSF101874 : 0050707", 
                      "SSF57501 : 0050684", "PS51230 : EB1_C", "PS51319 : TFIIS_N", 
                      "SSF89447 : 0048250", "SSF50814 : 0046613", "PF01015 : Ribosomal_S3Ae", 
                      "SSF48726 : 0045220", "SSF57038 : 0047773", "PF03167 : UDG", 
                      "PF01798 : Nop", "SSF57716 : 0039900", "SSF102588 : 0042640", 
                      "SSF57027 : 0052044", "SSF50465 : 0046254", "SSF52518 : 0042044", 
                      "PF08571 : Yos1", "SSF51161 : 0043743", "SSF55486 : 0040568", 
                      "TIGR00976 : /NonD", "SSF55637 : 0035717", "PR00003 : 4DISULPHCORE", 
                      "SSF56747 : 0037965", "SSF48179 : 0045403", "SSF54919 : 0041572", 
                      "SSF56399 : 0047383", "SSF51395 : 0036457", "SSF54236 : 0036950", 
                      "SSF49899 : 0040475", "PS51051 : DSL", "SSF54980 : 0048254", 
                      "PF00383 : dCMP_cyt_deam_1", "SSF54211 : 0041171", "SSF49309 : 0047948", 
                      "PF02347 : GDC-P", "SSF52540 : 0038162", "SSF57027 : 0038496", 
                      "SSF46785 : 0037759", "SSF50978 : 0048421", "SSF51649 : 0050437", 
                      "SSF88633 : 0049084", "SSF52540 : 0051289", "SSF49265 : 0050500", 
                      "SSF51569 : 0049848", "SSF47095 : 0038826", "SSF63411 : 0037286", 
                      "SSF49329 : 0049662", "SSF57362 : 0042851", "SSF53790 : 0050440", 
                      "SSF53335 : 0047919", "PD001363 :", "SSF55931 : 0042782", "SSF50249 : 0045258", 
                      "SSF51658 : 0052921", "SSF55831 : 0042943", "PF07718 : Coatamer_beta_C", 
                      "SSF56024 : 0046667", "SSF81296 : 0039305", "SSF48726 : 0039021", 
                      "TIGR02757 : TIGR02757", "SSF49863 : 0036994", "PF07221 : GlcNAc_2-epim", 
                      "SSF55961 : 0051115", "PF07035 : Mic1", "SSF56436 : 0049550", 
                      "SSF48726 : 0047334", "SSF110083 : 0044952", "SSF48726 : 0050594", 
                      "SSF48726 : 0035440", "SSF46626 : 0038371", "SSF53901 : 0038813", 
                      "PD001627 :", "SSF54791 : 0047513", "SSF50978 : 0043708", "PF01276 : OKR_DC_1", 
                      "SSF51735 : 0040579", "SSF81524 : 0035492", "SSF57716 : 0037928", 
                      "SSF51735 : 0048027", "PF08436 : DXP_redisom_C", "SSF56784 : 0041356", 
                      "SSF54593 : 0048412", "SSF47576 : 0042219", "TIGR01612 : 235kDa-fam", 
                      "SSF46785 : 0048605", "SSF50814 : 0048407", "PF00291 : PALP", 
                      "SSF46689 : 0052194", "SSF63707 : 0037883", "SSF46785 : 0053005", 
                      "SSF53850 : 0051706", "PR01233 : JOSEPHIN", "PR00080 : SDRFAMILY", 
                      "SSF52540 : 0049300", "PF09418 : DUF2009", "PF02862 : DDHD", 
                      "SSF56047 : 0043571", "SSF51445 : 0046455", "SSF52343 : 0037343", 
                      "SSF49265 : 0035655", "SSF68912 : 0034893", "SSF47413 : 0051908", 
                      "SSF48019 : 0052930", "SSF81296 : 0037012", "SSF63748 : 0042093", 
                      "TIGR01793 : cit_synth_euk", "SSF50249 : 0046050", "SSF53807 : 0044070", 
                      "PF00949 : Peptidase_S7", "PF01510 : Amidase_2", "SSF53254 : 0042752", 
                      "SSF50044 : 0049918", "SSF55729 : 0048433", "PR01070 : ACCCTRFRASEB", 
                      "PIRSF022995 :", "SSF51735 : 0040868", "SSF53092 : 0042481", 
                      "SSF54236 : 0035815", "SSF81736 : 0040372", "SSF56831 : 0044316", 
                      "SSF51445 : 0046556", "SSF88633 : 0035217", "PF06817 : RVT_thumb", 
                      "SSF53474 : 0036047", "SSF53383 : 0045068", "SSF56276 : 0044046", 
                      "SSF55298 : 0039407", "SSF50621 : 0044144", "SSF52490 : 0044120", 
                      "SSF52518 : 0050394", "SSF55909 : 0051543", "SSF56655 : 0046304", 
                      "SSF47082 : 0045351", "SSF56752 : 0036320", "SSF50249 : 0041327", 
                      "SSF50685 : 0040416", "SSF50129 : 0047232", "SSF88697 : 0050072", 
                      "SSF50156 : 0038828", "SSF47240 : 0040937", "SSF49319 : 0035082", 
                      "SSF51338 : 0047005", "SSF88798 : 0038182", "SSF49329 : 0048149", 
                      "PD000288 :", "SSF55021 : 0051607", "PF08783 : DWNN", "SSF49348 : 0046453", 
                      "PIRSF000846 :", "PF05348 : UMP1", "SSF46609 : 0049958", "SSF46458 : 0047432", 
                      "SSF54637 : 0051502", "SSF81469 : 0042846", "PF07959 : Fucokinase", 
                      "SSF54236 : 0050523", "SSF48403 : 0045715", "PF01702 : TGT", 
                      "SSF56399 : 0042967", "PF03311 : Cornichon", "SSF50044 : 0038478", 
                      "SSF53335 : 0051239", "SSF51556 : 0047517", "SSF48264 : 0042400", 
                      "SSF55920 : 0035818", "SSF56112 : 0037572", "SSF53697 : 0046090", 
                      "SSF51713 : 0039127", "SSF49265 : 0042755", "SSF54768 : 0049542", 
                      "TIGR01578 : MiaB-like-B", "SSF50203 : 0040658", "PIRSF003354 :", 
                      "SSF52540 : 0052625", "SSF56327 : 0048534", "SSF75347 : 0040430", 
                      "SSF46785 : 0035561", "SSF53335 : 0044780", "SSF53383 : 0038357", 
                      "SSF53383 : 0046056", "SSF50203 : 0037171", "SSF52540 : 0036451", 
                      "SSF50630 : 0036329", "SSF53187 : 0046310", "SSF52540 : 0051376", 
                      "SSF55973 : 0041131", "SSF101215 : 0042633", "SSF56601 : 0040907", 
                      "SSF49265 : 0050842", "SSF48403 : 0041178", "SSF56112 : 0041767", 
                      "SSF47699 : 0035484", "SSF52467 : 0048522", "SSF46626 : 0034785", 
                      "SSF52540 : 0040588", "PIRSF019663 :", "PF04117 : Mpv17_PMP22", 
                      "PF02913 : FAD-oxidase_C", "SSF50814 : 0047376", "SSF57095 : 0036066", 
                      "SSF46997 : 0038021", "SSF50156 : 0050584", "SSF47240 : 0047582", 
                      "SSF88633 : 0044051", "SSF51445 : 0047198", "PF09234 : DUF1963", 
                      "SSF48403 : 0049488", "SSF53850 : 0048393", "SSF51604 : 0042271", 
                      "SSF52317 : 0040297", "SSF50044 : 0038838", "SSF53955 : 0037418", 
                      "SSF54913 : 0042004", "SSF49265 : 0041200", "SSF53649 : 0035207", 
                      "TIGR00476 : selD", "SSF54928 : 0052244", "PR00151 : PORPHBDMNASE", 
                      "SSF51445 : 0044244", "SSF57055 : 0047265", "SSF50156 : 0040399", 
                      "SSF53686 : 0037494", "SSF57059 : 0040870", "PF04916 : Laminin_A", 
                      "SSF54556 : 0042056", "SSF57429 : 0050716", "SSF52218 : 0051705", 
                      "SSF51366 : 0044006", "SSF53474 : 0046412", "SSF56327 : 0035406", 
                      "PF03029 : ATP_bind_1", "SSF54236 : 0039304", "SSF81514 : 0037298", 
                      "SSF52343 : 0038028", "PF01049 : Cadherin_C", "SSF46906 : 0041007", 
                      "SSF55811 : 0048878", "SSF75005 : 0051383", "SSF46689 : 0037777", 
                      "PF04990 : RNA_pol_Rpb1_7", "SSF48619 : 0042401", "SSF57196 : 0048531", 
                      "PF02970 : TBCA", "SSF46955 : 0043545", "PS50817 : INTEIN_N_TER", 
                      "PF02446 : Glyco_hydro_77", "PF01103 : Bac_surface_Ag", "SSF47986 : 0034834", 
                      "SSF51182 : 0037258", "SSF55753 : 0037429", "SSF46785 : 0051672", 
                      "PR01849 : UBIQUITINACT", "PF08123 : DOT1", "SSF53955 : 0047448", 
                      "PR01320 : KIRCHANNEL", "SSF50249 : 0043566", "PF04231 : Endonuclease_1", 
                      "SSF52540 : 0051769", "SSF55608 : 0036552", "SSF54236 : 0046482", 
                      "SSF54593 : 0049725", "SSF49384 : 0035131", "SSF88697 : 0051540", 
                      "SSF88633 : 0035503", "SSF49879 : 0044400", "SSF52540 : 0037725", 
                      "SSF48695 : 0036263", "SSF54358 : 0047749", "SSF50729 : 0044627", 
                      "SSF51569 : 0050181", "SSF69055 : 0039918", "SSF48726 : 0035642", 
                      "SSF52317 : 0051738", "SSF50249 : 0039264", "PF03088 : Str_synth", 
                      "SSF53474 : 0042551", "SSF54506 : 0044048", "SSF47266 : 0044650", 
                      "TIGR00127 : nadp_idh_euk", "SSF82754 : 0048067", "SSF55729 : 0049311", 
                      "SSF52096 : 0049617", "SSF46689 : 0043600", "SSF51735 : 0035680", 
                      "SSF49401 : 0041230", "PD005593 :", "TIGR02232 : myxo_disulf_rpt", 
                      "SSF52821 : 0041896", "SSF47802 : 0048475", "PS50163 : RECA_3", 
                      "PF10513 : EPL1", "SSF49863 : 0038643", "SSF55979 : 0044284", 
                      "SSF50630 : 0038745", "SSF50475 : 0050409", "PIRSF001355 :", 
                      "PIRSF037091 :", "SSF56553 : 0047315", "PF03946 : Ribosomal_L11_N", 
                      "SSF51445 : 0039435", "SSF55315 : 0039117", "SSF54001 : 0036473", 
                      "SSF55781 : 0048136", "SSF63393 : 0047308", "SSF56059 : 0034972", 
                      "SSF55874 : 0043939", "SSF46458 : 0042778", "PF09743 : DUF2042", 
                      "SSF50475 : 0048424", "PD017367 :", "SSF88633 : 0043246", "SSF54665 : 0043859", 
                      "SSF55021 : 0052555", "PF00478 : IMPDH", "SSF54427 : 0047196", 
                      "PR01181 : DAPDCRBXLASE", "SSF55424 : 0040820", "SSF74650 : 0041729", 
                      "SSF52833 : 0038265", "SSF57716 : 0036189", "SSF56784 : 0042929", 
                      "PF03711 : OKR_DC_1_C", "SSF52540 : 0051460", "SSF48208 : 0050765", 
                      "PS51309 : PABC", "PIRSF002179 :", "SSF54452 : 0039866", "SSF53223 : 0038762", 
                      "SSF50249 : 0048887", "SSF50249 : 0046596", "SSF56784 : 0052186", 
                      "PF01595 : DUF21", "SSF51445 : 0047875", "SSF47095 : 0047504", 
                      "SSF47741 : 0044863", "SSF52540 : 0044232", "SSF51735 : 0043041", 
                      "SSF89260 : 0041518", "SSF46565 : 0050633", "SSF56112 : 0044547", 
                      "SSF54211 : 0043148", "SSF63748 : 0050626", "SSF81296 : 0046137", 
                      "SSF54292 : 0042285", "SSF69917 : 0038904", "SSF48403 : 0046301", 
                      "SSF51556 : 0037044", "SSF46689 : 0045900", "SSF52172 : 0040741", 
                      "PR00870 : DNAPOLXBETA", "SSF49503 : 0035146", "SSF57535 : 0038577", 
                      "SSF52283 : 0046421", "SSF63829 : 0036709", "SSF48179 : 0044958", 
                      "SSF47113 : 0035549", "PF02928 : zf-C5HC2", "SSF54810 : 0047036", 
                      "PF09243 : Rsm22", "SSF53659 : 0039183", "PF09430 : DUF2012", 
                      "SSF89963 : 0039088", "SSF54928 : 0036164", "SSF52540 : 0042094", 
                      "SSF51726 : 0049982", "PF10199 : Adaptin_binding", "PF04387 : PTPLA", 
                      "SSF49265 : 0035671", "PF02055 : Glyco_hydro_30", "SSF53927 : 0051727", 
                      "PF04925 : SHQ1", "SSF51735 : 0036007", "SSF48726 : 0046389", 
                      "SSF52172 : 0048685", "SSF52317 : 0049505", "SSF51269 : 0044870", 
                      "SSF48726 : 0035930", "PF03587 : Nep1", "SSF81296 : 0047739", 
                      "SSF50156 : 0048138", "SSF74650 : 0039682", "SSF63380 : 0038912", 
                      "SSF47220 : 0049463", "SSF53223 : 0041590", "SSF64484 : 0038897", 
                      "SSF57850 : 0041252", "PF04408 : HA2", "SSF49899 : 0040591", 
                      "SSF54117 : 0041524", "SSF55347 : 0038233", "SSF74924 : 0052207", 
                      "SSF54862 : 0045275", "SSF52540 : 0050357", "SSF74788 : 0051932", 
                      "SSF51735 : 0039919", "PIRSF003314 :", "SSF46785 : 0037767", 
                      "SSF56176 : 0038831", "PS51134 : ZF_TFIIB", "TIGR00096 : TIGR00096", 
                      "SSF47370 : 0041239", "PF03531 : SSrecog", "PF00008 : EGF", "SSF48403 : 0051277", 
                      "SSF48173 : 0048653", "PIRSF029038 :", "SSF46626 : 0039356", 
                      "SSF52799 : 0050432", "SSF55753 : 0044290", "PD069349 :", "SSF51989 : 0045202", 
                      "SSF48371 : 0044481", "SSF56512 : 0040969", "SSF51011 : 0043113", 
                      "PF03997 : VPS28", "SSF46785 : 0052508", "SSF47661 : 0040683", 
                      "SSF52518 : 0045129", "SSF54452 : 0036615", "PF10509 : GalKase_gal_bdg", 
                      "SSF55068 : 0046766", "SSF51604 : 0041937", "SSF53807 : 0036959", 
                      "PD007736 :", "SSF54292 : 0036529", "PR00852 : XRODRMPGMNTD", 
                      "SSF51569 : 0041141", "PF03932 : CutC", "SSF46458 : 0041379", 
                      "PF04921 : XAP5", "SSF46934 : 0042142", "SSF56574 : 0037307", 
                      "PF05658 : Hep_Hag", "SSF51430 : 0047367", "SSF50156 : 0045904", 
                      "SSF56327 : 0047279", "SSF50494 : 0042215", "SSF56655 : 0041408", 
                      "SSF53335 : 0039272", "SSF57667 : 0040761", "PF08285 : DPM3", 
                      "SSF46609 : 0038282", "SSF52954 : 0035193", "TIGR00104 : TIGR00104", 
                      "SSF57095 : 0035461", "SSF53474 : 0049005", "SSF101790 : 0041532", 
                      "SSF57756 : 0049805", "SSF54534 : 0040253", "SSF55267 : 0034925", 
                      "SSF56436 : 0039268", "SSF50370 : 0045064", "SSF48576 : 0039518", 
                      "SSF46561 : 0049121", "PF01359 : Transposase_1", "SSF53383 : 0050696", 
                      "SSF53182 : 0047437", "SSF55620 : 0051175", "SSF53098 : 0050648", 
                      "SSF49452 : 0048380", "SSF50044 : 0049700", "PF08454 : RIH_assoc", 
                      "SSF54452 : 0040585", "SSF47233 : 0037933", "SSF57016 : 0044429", 
                      "SSF49562 : 0036844", "SSF111430 : 0043738", "SSF48726 : 0048320", 
                      "SSF47240 : 0051505", "SSF56849 : 0038888", "PF00787 : PX", "SSF53187 : 0051762", 
                      "TIGR00345 : arsA", "SSF54768 : 0040155", "PD337143 :", "SSF53155 : 0042888", 
                      "SSF54928 : 0042119", "SSF51658 : 0051438", "SSF51735 : 0037102", 
                      "PD015362 :", "SSF53098 : 0042659", "SSF56747 : 0051833", "SSF54675 : 0051320", 
                      "SSF56935 : 0035773", "PF01486 : K-box", "SSF49309 : 0037873", 
                      "SSF55347 : 0044889", "SSF63411 : 0047224", "SSF56645 : 0047447", 
                      "SSF50729 : 0050335", "SSF46785 : 0051874", "SSF50729 : 0035704", 
                      "SSF49899 : 0041754", "SSF51445 : 0049678", "PIRSF000463 :", 
                      "PF05486 : SRP9", "PF05241 : EBP", "SSF56553 : 0039234", "SSF51011 : 0044280", 
                      "SSF50249 : 0042291", "SSF52821 : 0042691", "SSF52540 : 0042202", 
                      "SSF49265 : 0046820", "SSF51735 : 0038545", "SSF47986 : 0036250", 
                      "PIRSF006019 :", "SSF51445 : 0046643", "PF08980 : DUF1883", "SSF50621 : 0047840", 
                      "SSF53067 : 0051709", "PF07993 : NAD_binding_4", "SSF47370 : 0036796", 
                      "SSF46609 : 0036584", "SSF64307 : 0036351", "SSF82051 : 0040587", 
                      "PIRSF000814 :", "SSF48726 : 0039470", "SSF55060 : 0040286", 
                      "PF01505 : Vault", "PIRSF028729 :", "SSF56568 : 0042417", "SSF47090 : 0036027", 
                      "SSF47188 : 0045362", "SSF49723 : 0037174", "SSF56529 : 0047268", 
                      "SSF56112 : 0042379", "SSF54862 : 0039142", "TIGR01763 : MalateDH_bact", 
                      "PF08661 : Rep_fac-A_3", "SSF50386 : 0035232", "TIGR01494 : ATPase_P-type", 
                      "SSF50729 : 0035702", "SSF52540 : 0043901", "SSF51569 : 0045094", 
                      "PF02724 : CDC45", "SSF57196 : 0040140", "SSF48726 : 0048631", 
                      "SSF46946 : 0040359", "SSF50494 : 0034828", "PD003823 :", "SSF50615 : 0040864", 
                      "SSF52833 : 0045739", "SSF54452 : 0046058", "PF02671 : PAH", 
                      "SSF55811 : 0043415", "SSF54060 : 0042034", "SSF53850 : 0039657", 
                      "SSF50156 : 0052281", "SSF53474 : 0042853", "SSF57552 : 0043312", 
                      "SSF57302 : 0036079", "SSF48013 : 0048904", "SSF74788 : 0052372", 
                      "SSF54358 : 0045336", "SSF51110 : 0040111", "SSF46785 : 0048177", 
                      "PF04104 : DNA_primase_lrg", "SSF47240 : 0041372", "PF00834 : Ribul_P_3_epim", 
                      "SSF54593 : 0048015", "SSF81338 : 0043681", "SSF53300 : 0036024", 
                      "SSF48498 : 0052831", "PF00855 : PWWP", "SSF56235 : 0039334", 
                      "SSF55856 : 0036519", "SSF57059 : 0046655", "SSF51412 : 0046530", 
                      "PF02190 : LON", "PF00327 : Ribosomal_L30", "SSF54106 : 0036696", 
                      "SSF64307 : 0042226", "SSF49899 : 0050332", "PIRSF006621 :", 
                      "SSF55040 : 0037060", "SSF51556 : 0048612", "PF01479 : S4", "PF05343 : Peptidase_M42", 
                      "SSF54285 : 0050209", "SSF48425 : 0043206", "SSF49899 : 0036430", 
                      "SSF54593 : 0049683", "PR01047 : TRNASYNTHTHR", "PF07720 : TPR_3", 
                      "SSF81273 : 0042040", "SSF55550 : 0045415", "SSF49441 : 0035993", 
                      "SSF48340 : 0037397", "SSF47676 : 0050628", "SSF55831 : 0035603", 
                      "PF02995 : DUF229", "SSF64586 : 0041421", "SSF49785 : 0039559", 
                      "SSF57586 : 0046650", "SSF50494 : 0037609", "SSF50104 : 0044301", 
                      "SSF51735 : 0051696", "SSF52833 : 0038540", "PS50031 : EH", "TIGR00981 : rpsL_bact", 
                      "SSF47986 : 0036368", "PS50178 : ZF_FYVE", "SSF51445 : 0040068", 
                      "SSF81296 : 0041347", "PF08241 : Methyltransf_11", "SSF110009 : 0044049", 
                      "PF02567 : PhzC-PhzF", "SSF56112 : 0044206", "TIGR00126 : deoC", 
                      "SSF57716 : 0052203", "SSF52058 : 0039223", "SSF57716 : 0052406", 
                      "SSF56784 : 0041259", "SSF46689 : 0042267", "PIRSF002724 :", 
                      "SSF53613 : 0050248", "SSF48613 : 0051513", "SSF52540 : 0052726", 
                      "SSF81296 : 0047381", "SSF48726 : 0041362", "SSF55347 : 0038044", 
                      "SSF46458 : 0038097", "PF10203 : Pet191_N", "PIRSF000418 :", 
                      "PR01368 : SYNAPSIN", "SSF55120 : 0043606", "PF05346 : DUF747", 
                      "SSF57535 : 0038353", "SSF49758 : 0040065", "SSF50800 : 0042000", 
                      "SSF49899 : 0045400", "SSF48726 : 0048434", "PF01201 : Ribosomal_S8e", 
                      "SSF49265 : 0035670", "PF05424 : Duffy_binding", "SSF51351 : 0052045", 
                      "SSF47794 : 0049536", "SSF55550 : 0034941", "SSF54403 : 0035947", 
                      "SSF53098 : 0038858", "SSF50249 : 0040354", "SSF52151 : 0036023", 
                      "SSF57868 : 0039375", "PF05172 : MPPN", "PD472677 :", "SSF52058 : 0048059", 
                      "SSF53328 : 0040902", "SSF51735 : 0051702", "SSF54236 : 0037105", 
                      "SSF51206 : 0041734", "SSF47240 : 0043100", "SSF56655 : 0040448", 
                      "PF09420 : Nop16", "SSF57716 : 0050811", "SSF46689 : 0037778", 
                      "SSF48619 : 0040575", "SSF100950 : 0050123", "SSF88633 : 0049166", 
                      "PF08423 : Rad51", "SSF57829 : 0046774", "SSF56047 : 0038928", 
                      "SSF48225 : 0036479", "SSF48726 : 0048004", "SSF82704 : 0041369", 
                      "SSF81464 : 0040793", "PF05368 : NmrA", "SSF53223 : 0038260", 
                      "SSF47446 : 0038671", "PF00163 : Ribosomal_S4", "SSF55347 : 0046003", 
                      "SSF52540 : 0053059", "SSF48239 : 0050380", "SSF52821 : 0046433", 
                      "SSF48113 : 0044250", "SSF52540 : 0040121", "SSF56784 : 0043957", 
                      "SSF48726 : 0035664", "SSF109801 : 0043645", "PIRSF013503 :", 
                      "PF03120 : DNA_ligase_OB", "SSF54768 : 0043193", "SSF46609 : 0043744", 
                      "SSF52540 : 0039930", "SSF53098 : 0047617", "SSF51366 : 0044394", 
                      "PD008800 :", "SSF52540 : 0044176", "SSF53633 : 0051682", "PF01565 : FAD_binding_4", 
                      "SSF47266 : 0035096", "SSF55681 : 0034783", "SSF53671 : 0042300", 
                      "PIRSF016315 :", "SSF57414 : 0038620", "SSF46785 : 0039808", 
                      "PD023420 :", "PF08784 : RPA_C", "TIGR00723 : ttdB_fumA_fumB", 
                      "SSF52047 : 0052014", "PS50173 : UMUC", "PS50811 : WRKY", "PF05603 : DUF775", 
                      "PF09299 : Mu-transpos_C", "SSF57770 : 0049021", "SSF52172 : 0046075", 
                      "SSF53098 : 0050971", "PF00666 : Cathelicidins", "SSF50939 : 0041196", 
                      "SSF49503 : 0047888", "SSF55874 : 0038974", "TIGR01025 : rpsS_arch", 
                      "SSF51445 : 0036257", "PF02897 : Peptidase_S9_N", "SSF52343 : 0037117", 
                      "SSF49785 : 0051368", "SSF51604 : 0050711", "SSF88633 : 0045183", 
                      "SSF57667 : 0052465", "PF10192 : GpcrRhopsn4", "SSF89028 : 0048373", 
                      "PF09173 : eIF2_C", "SSF53850 : 0047112", "SSF54452 : 0042893", 
                      "SSF51905 : 0045518", "SSF51649 : 0046036", "SSF54211 : 0042146", 
                      "PF10587 : EF-1_beta_acid", "SSF52058 : 0039222", "SSF52058 : 0034963", 
                      "SSF53448 : 0038743", "PF05856 : ARPC4", "SSF53335 : 0039748", 
                      "SSF50621 : 0043196", "SSF57716 : 0047389", "PF10659 : Trypan_glycop_C", 
                      "SSF54928 : 0052897", "SSF53748 : 0038550", "SSF55486 : 0041740", 
                      "SSF54236 : 0038476", "SSF47616 : 0038177", "SSF63451 : 0038494", 
                      "TIGR00790 : fnt", "SSF47095 : 0034978", "PD009224 :", "PR00345 : STATHMIN", 
                      "PF01157 : Ribosomal_L21e", "SSF54452 : 0046614", "SSF50630 : 0035868", 
                      "SSF50249 : 0042509", "SSF53901 : 0041153", "SSF51735 : 0044861", 
                      "SSF55550 : 0050893", "SSF48225 : 0047169", "SSF55979 : 0038064", 
                      "SSF53335 : 0050038", "SSF56672 : 0043608", "SSF88645 : 0045195", 
                      "PF04266 : ASCH", "PF06512 : Na_trans_assoc", "PF01940 : DUF92", 
                      "SSF52540 : 0049292", "SSF53067 : 0051732", "PF00412 : LIM", 
                      "PF08231 : SYF2", "SSF56645 : 0047431", "SSF46689 : 0036287", 
                      "SSF81296 : 0052433", "SSF56112 : 0040670", "SSF57535 : 0036032", 
                      "PF08271 : TFIIB_Zn_Ribbon", "TIGR01038 : L22_arch", "SSF52833 : 0038253", 
                      "PF01456 : Mucin", "SSF50249 : 0051177", "PF00012 : HSP70", "SSF111357 : 0044925", 
                      "SSF81502 : 0035456", "SSF54001 : 0042418", "SSF57196 : 0041646", 
                      "SSF50494 : 0042882", "PF08449 : UAA", "SSF51004 : 0042835", 
                      "SSF54897 : 0042232", "SSF49503 : 0041410", "SSF54534 : 0040249", 
                      "SSF57903 : 0050467", "SSF52317 : 0045752", "SSF47240 : 0049090", 
                      "PF03106 : WRKY", "PIRSF001492 :", "SSF53671 : 0044885", "SSF49899 : 0040452", 
                      "SSF55811 : 0052791", "PD149633 :", "PF08719 : DUF1768", "SSF57850 : 0050527", 
                      "SSF50475 : 0049578", "SSF48065 : 0037403", "SSF47473 : 0037250", 
                      "SSF50494 : 0036545", "SSF53213 : 0035648", "SSF50911 : 0042584", 
                      "SSF48726 : 0049860", "SSF56747 : 0051636", "PIRSF006221 :", 
                      "SSF50729 : 0048159", "SSF53613 : 0049846", "SSF51989 : 0036676", 
                      "PF00564 : PB1", "SSF49899 : 0042889", "SSF54292 : 0036211", 
                      "PD095324 :", "SSF48726 : 0044694", "SSF55008 : 0047891", "SSF52518 : 0042487", 
                      "PR00195 : DYNAMIN", "SSF53955 : 0034789", "SSF50353 : 0042502", 
                      "SSF56519 : 0042863", "PD003091 :", "SSF81296 : 0051961", "SSF48726 : 0042638", 
                      "SSF53474 : 0044683", "PD001516 :", "SSF51735 : 0049820", "SSF57095 : 0047704", 
                      "PR00412 : EPOXHYDRLASE", "SSF54690 : 0037657", "SSF52833 : 0044115", 
                      "PF01984 : dsDNA_bind", "PF09084 : NMT1", "SSF57586 : 0053012", 
                      "SSF53633 : 0051265", "SSF50324 : 0045422", "SSF51735 : 0048409", 
                      "SSF54928 : 0052622", "SSF75620 : 0043341", "SSF51717 : 0037259", 
                      "PD001093 :", "SSF54928 : 0046286", "SSF82829 : 0041406", "SSF55920 : 0052072", 
                      "SSF51604 : 0046496", "PS50044 : SIGMA54_3", "SSF52343 : 0042743", 
                      "SSF49503 : 0053155", "SSF51206 : 0042597", "SSF47266 : 0040527", 
                      "SSF46785 : 0037456", "SSF53474 : 0039761", "SSF52777 : 0051015", 
                      "PIRSF004930 :", "PF02906 : Fe_hyd_lg_C", "PIRSF015819 :", "SSF47874 : 0040852", 
                      "SSF82549 : 0041866", "PF03587 : EMG1", "SSF46458 : 0042923", 
                      "SSF51735 : 0038856", "SSF52540 : 0043648", "SSF50353 : 0047379", 
                      "SSF54593 : 0044219", "SSF53850 : 0049612", "PF04084 : ORC2", 
                      "SSF50122 : 0035866", "SSF57059 : 0048528", "TIGR01758 : MDH_euk_cyt", 
                      "TIGR01571 : A_thal_Cys_rich", "SSF56420 : 0040634", "SSF46689 : 0039011", 
                      "SSF54928 : 0052429", "SSF52172 : 0048463", "SSF109728 : 0043915", 
                      "SSF53720 : 0040316", "SSF46585 : 0036192", "SSF51735 : 0049966", 
                      "SSF56645 : 0049259", "SSF54534 : 0041898", "PF05185 : PRMT5", 
                      "SSF52518 : 0042045", "SSF46458 : 0034870", "SSF48613 : 0043643", 
                      "SSF51069 : 0044675", "SSF53474 : 0048207", "SSF51412 : 0047561", 
                      "SSF81271 : 0041632", "TIGR00111 : pelota", "SSF50447 : 0050421", 
                      "SSF54909 : 0050289", "SSF50353 : 0039056", "SSF53955 : 0039221", 
                      "PS50237 : HECT", "SSF100950 : 0043889", "SSF51905 : 0049150", 
                      "SSF55931 : 0050113", "SSF49854 : 0043700", "SSF57667 : 0049818", 
                      "SSF54862 : 0052774", "SSF57196 : 0044577", "TIGR00483 : EF-1_alpha", 
                      "SSF55945 : 0045101", "PD004429 :", "SSF52518 : 0039198", "TIGR00196 : yjeF_cterm", 
                      "SSF52029 : 0035186", "SSF81631 : 0046739", "SSF54001 : 0040429", 
                      "PF03666 : UPF0171", "SSF88697 : 0043605", "SSF50122 : 0046646", 
                      "SSF56327 : 0045620", "SSF55681 : 0035005", "SSF47203 : 0043402", 
                      "SSF53187 : 0052940", "PS50175 : ASP_PROT_RETROV", "PF03441 : FAD_binding_7", 
                      "SSF55979 : 0035248", "SSF56112 : 0048785", "PF04047 : PWP2", 
                      "SSF56925 : 0038001", "SSF101790 : 0042335", "SSF56821 : 0036722", 
                      "SSF63570 : 0038850", "SSF57196 : 0041189", "PS51085 : 2FE2S_FER_2", 
                      "PF06008 : Laminin_I", "SSF52540 : 0048549", "SSF110069 : 0049746", 
                      "SSF57196 : 0046121", "SSF53850 : 0041701", "SSF81296 : 0037932", 
                      "SSF47240 : 0039339", "SSF55874 : 0041086", "SSF54928 : 0037611", 
                      "SSF51735 : 0044187", "SSF53795 : 0040170", "PD016591 :", "PF00448 : SRP54", 
                      "SSF51735 : 0040540", "SSF53335 : 0037719", "SSF52266 : 0046880", 
                      "SSF57027 : 0048142", "TIGR00347 : bioD", "PD001394 :", "SSF52402 : 0036966", 
                      "PF08546 : ApbA_C", "PF03449 : GreA_GreB_N", "SSF51182 : 0045407", 
                      "SSF51695 : 0051554", "SSF54403 : 0041027", "SSF55550 : 0047684", 
                      "SSF54928 : 0052899", "SSF82153 : 0041628", "SSF56327 : 0042535", 
                      "SSF100934 : 0044279", "SSF57667 : 0045631", "SSF46955 : 0039432", 
                      "PF01230 : HIT", "PF09696 : Ctf8", "SSF51735 : 0042827", "SSF47113 : 0043925", 
                      "SSF52833 : 0034961", "SSF51905 : 0045870", "PF00702 : Hydrolase", 
                      "SSF103256 : 0044805", "SSF54452 : 0036378", "PD001326 :", "SSF55120 : 0044786", 
                      "SSF54713 : 0036969", "PS50105 : SAM_DOMAIN", "SSF46626 : 0041416", 
                      "PD004563 :", "SSF50677 : 0037567", "SSF50615 : 0037820", "SSF47240 : 0039533", 
                      "SSF52540 : 0045113", "SSF50129 : 0047994", "SSF52833 : 0052504", 
                      "SSF53218 : 0052616", "SSF52540 : 0052931", "SSF48452 : 0044939", 
                      "SSF57581 : 0044578", "SSF54001 : 0051162", "SSF51735 : 0050103", 
                      "SSF52172 : 0042829", "SSF50494 : 0042162", "PF00438 : S-AdoMet_synt_N", 
                      "SSF57059 : 0048973", "SSF51338 : 0045610", "SSF54928 : 0047108", 
                      "SSF57903 : 0051161", "SSF88633 : 0042940", "SSF50249 : 0048308", 
                      "SSF63491 : 0040836", "SSF53067 : 0045071", "SSF55856 : 0035258", 
                      "SSF48208 : 0038421", "SSF55753 : 0036222", "SSF51110 : 0040112", 
                      "SSF81383 : 0037737", "SSF57716 : 0045592", "SSF51269 : 0041966", 
                      "SSF55239 : 0049484", "SSF52540 : 0037524", "SSF63380 : 0049710", 
                      "SSF47917 : 0036814", "PF06705 : SF-assemblin", "PF03011 : PFEMP", 
                      "SSF54665 : 0041226", "PF05016 : Plasmid_stabil", "PD006587 :", 
                      "SSF46458 : 0042035", "SSF69765 : 0039813", "SSF54862 : 0035446", 
                      "SSF82109 : 0043917", "SSF88633 : 0043087", "SSF51735 : 0052529", 
                      "SSF53335 : 0051261", "TIGR01251 : ribP_PPkin", "PS50115 : ARFGAP", 
                      "SSF54980 : 0036327", "SSF53098 : 0047541", "SSF50353 : 0039311", 
                      "SSF49319 : 0045356", "SSF49348 : 0042981", "TIGR01341 : aconitase_1", 
                      "SSF50978 : 0042121", "SSF54452 : 0051953", "SSF53383 : 0051601", 
                      "PF02390 : Methyltransf_4", "SSF55681 : 0046638", "SSF54928 : 0043638", 
                      "PF02632 : BioY", "SSF56091 : 0044679", "SSF46785 : 0052161", 
                      "SSF52833 : 0049633", "SSF55347 : 0052355", "SSF53335 : 0051143", 
                      "SSF51045 : 0051620", "PD581812 :", "SSF54675 : 0050243", "SSF51182 : 0049242", 
                      "TIGR00398 : metG", "SSF54277 : 0050570", "SSF51735 : 0036438", 
                      "SSF53032 : 0049079", "SSF54001 : 0040950", "PF08082 : PRO8NT", 
                      "SSF46785 : 0051521", "SSF53474 : 0050245", "PS51136 : WAC", 
                      "PF09445 : Methyltransf_15", "SSF53067 : 0052961", "SSF57802 : 0043201", 
                      "SSF48726 : 0042663", "SSF57302 : 0041333", "SSF48726 : 0046709", 
                      "SSF53850 : 0051126", "SSF56837 : 0043233", "SSF46689 : 0049910", 
                      "SSF54160 : 0052489", "SSF57903 : 0050474", "SSF57184 : 0047362", 
                      "SSF54117 : 0035356", "SSF51445 : 0047578", "SSF57440 : 0040228", 
                      "SSF81301 : 0044735", "SSF51735 : 0048102", "SSF53335 : 0046568", 
                      "SSF49742 : 0042308", "SSF52374 : 0038263", "SSF48726 : 0041349", 
                      "PF02204 : VPS9", "SSF49899 : 0045783", "PS50902 : FLAVODOXIN_LIKE", 
                      "SSF57829 : 0037551", "PF03476 : MOSC_N", "SSF52540 : 0043614", 
                      "SSF52540 : 0038188", "PF00920 : ILVD_EDD", "SSF53756 : 0041707", 
                      "SSF49503 : 0043557", "SSF53756 : 0038341", "SSF63748 : 0052438", 
                      "SSF63965 : 0044673", "PF09713 : A_thal_3526", "SSF57667 : 0047831", 
                      "SSF47266 : 0043546", "PF08433 : KTI12", "PF01212 : Beta_elim_lyase", 
                      "SSF81698 : 0044575", "SSF47592 : 0044599", "PF00289 : CPSase_L_chain", 
                      "PF09324 : DUF1981", "SSF50494 : 0050034", "SSF56327 : 0045670", 
                      "SSF51126 : 0046293", "SSF49899 : 0044948", "PD031131 :", "SSF51430 : 0037743", 
                      "SSF54814 : 0046797", "PF08577 : PI31_Prot_Reg", "SSF52540 : 0046478", 
                      "SSF47616 : 0038678", "SSF57586 : 0036274", "PF00244 : 14-3-3", 
                      "SSF47473 : 0045377", "SSF48264 : 0044298", "SSF55174 : 0042206", 
                      "SSF55486 : 0047333", "SSF47769 : 0035302", "SSF48425 : 0047880", 
                      "SSF100950 : 0046311", "SSF57501 : 0048086", "PR01798 : SCOASYNTHASE", 
                      "SSF101816 : 0043049", "PF03162 : Y_phosphatase2", "PF02518 : HATPase_c", 
                      "SSF52540 : 0045559", "SSF53383 : 0043583", "SSF47203 : 0039175", 
                      "SSF57196 : 0041550", "SSF47113 : 0040305", "SSF51569 : 0037836", 
                      "SSF52821 : 0035819", "SSF57667 : 0051621", "SSF55874 : 0043462", 
                      "SSF46689 : 0045311", "SSF53448 : 0038005", "TIGR02347 : chap_CCT_zeta", 
                      "SSF53448 : 0037835", "PR01659 : MCMPROTEIN3", "PF00515 : TPR_1", 
                      "SSF51556 : 0051135", "SSF54236 : 0038037", "SSF47266 : 0038948", 
                      "SSF51011 : 0049423", "SSF46458 : 0038959", "PIRSF016281 :", 
                      "SSF57095 : 0043672", "SSF52518 : 0041167", "SSF51735 : 0045243", 
                      "PD153432 :", "SSF49401 : 0049082", "SSF51419 : 0040168", "TIGR01046 : S10_Arc_S20_Euk", 
                      "SSF54913 : 0041288", "SSF50621 : 0044738", "PD035675 :", "PF10036 : RLL", 
                      "SSF49764 : 0043616", "PF01169 : UPF0016", "SSF51735 : 0042131", 
                      "SSF56601 : 0046615", "PF00117 : GATase", "SSF50370 : 0041943", 
                      "SSF53474 : 0047003", "PR00302 : LUPUSLA", "SSF49265 : 0037851", 
                      "SSF56235 : 0036849", "SSF110304 : 0052876", "PIRSF037850 :", 
                      "SSF52540 : 0044180", "SSF50370 : 0040750", "SSF51735 : 0040649", 
                      "PS50287 : SRCR_2", "PS50065 : HMG_COA_REDUCTASE_4", "SSF54593 : 0052095", 
                      "SSF53850 : 0046118", "SSF54975 : 0051381", "PS51339 : PPASE_MYOTUBULARIN", 
                      "SSF51569 : 0038573", "SSF54909 : 0052757", "SSF50465 : 0051647", 
                      "PF01305 : Ribosomal_L15", "SSF57716 : 0039333", "PF05502 : Dynactin_p62", 
                      "SSF55424 : 0045533", "SSF47050 : 0044462", "SSF55729 : 0051232", 
                      "SSF52833 : 0043005", "PIRSF007764 :", "SSF48726 : 0050012", 
                      "SSF46785 : 0052198", "PF04280 : Tim44", "SSF51206 : 0042279", 
                      "SSF52317 : 0044699", "PIRSF036603 :", "PS51359 : COX5B_2", "SSF54416 : 0046576", 
                      "SSF47699 : 0042457", "SSF53335 : 0052982", "PIRSF036417 :", 
                      "SSF48208 : 0051759", "PIRSF002161 :", "SSF54427 : 0039598", 
                      "SSF54534 : 0040250", "PIRSF037336 :", "SSF49879 : 0040094", 
                      "SSF46785 : 0039384", "SSF57095 : 0048221", "SSF50104 : 0037528", 
                      "SSF52440 : 0046403", "SSF46589 : 0039226", "SSF55620 : 0036431", 
                      "SSF53335 : 0051823", "SSF51735 : 0050204", "SSF53474 : 0040601", 
                      "PF01633 : Choline_kinase", "SSF52440 : 0036762", "SSF51735 : 0039600", 
                      "PF08825 : E2_bind", "SSF48295 : 0044105", "SSF48726 : 0045951", 
                      "PIRSF000429 :", "PF06419 : COG6", "PF01204 : Trehalase", "SSF49998 : 0040241", 
                      "SSF54189 : 0037537", "SSF52833 : 0037474", "SSF47676 : 0037103", 
                      "SSF53474 : 0039211", "SSF57196 : 0045912", "SSF52540 : 0044893", 
                      "SSF57440 : 0035559", "SSF53167 : 0042569", "SSF51604 : 0043070", 
                      "PF05254 : UPF0203", "SSF51366 : 0050132", "PF03074 : GCS", "SSF88633 : 0046271", 
                      "SSF109604 : 0048665", "SSF52777 : 0035361", "SSF57059 : 0047950", 
                      "SSF55785 : 0045558", "PF10275 : Peptidase_C65", "SSF51445 : 0052061", 
                      "PF01121 : CoaE", "SSF50249 : 0048442", "SSF53474 : 0051009", 
                      "PF00684 : DnaJ_CXXCXGXG", "SSF56672 : 0051076", "PF01922 : SRP19", 
                      "PS51131 : ZN_HOOK", "SSF56925 : 0042153", "SSF52540 : 0042214", 
                      "SSF53335 : 0051816", "SSF53474 : 0040262", "SSF53300 : 0039514", 
                      "PF01477 : PLAT", "SSF57903 : 0050473", "SSF53223 : 0044859", 
                      "PF02540 : NAD_synthase", "SSF54495 : 0051720", "SSF49695 : 0035469", 
                      "SSF52833 : 0049857", "SSF81296 : 0044154", "SSF57095 : 0047623", 
                      "SSF54277 : 0046268", "PF05726 : Pirin_C", "SSF55729 : 0049263", 
                      "SSF48371 : 0043442", "SSF56420 : 0039816", "SSF51430 : 0043469", 
                      "SSF88946 : 0038400", "SSF55021 : 0043949", "TIGR01514 : NAPRTase", 
                      "SSF51735 : 0037203", "SSF48666 : 0045582", "SSF57716 : 0050849", 
                      "SSF54913 : 0042118", "PR00075 : FACDDSATRASE", "SSF57196 : 0045506", 
                      "SSF49695 : 0046582", "SSF50465 : 0037406", "SSF69645 : 0039966", 
                      "PR00392 : PROFILIN", "SSF55545 : 0038229", "SSF51445 : 0039927", 
                      "SSF51735 : 0046472", "SSF56266 : 0044921", "SSF48726 : 0038149", 
                      "PF10403 : BHD_1", "SSF82114 : 0041165", "SSF51126 : 0048925", 
                      "SSF56784 : 0052933", "SSF50630 : 0037639", "PF01411 : tRNA-synt_2c", 
                      "SSF50494 : 0037840", "SSF54862 : 0037513", "SSF48726 : 0036511", 
                      "PF01997 : Translin", "SSF51445 : 0039194", "SSF52540 : 0043821", 
                      "SSF55681 : 0046437", "SSF88633 : 0045812", "SSF47473 : 0048244", 
                      "SSF52540 : 0037384", "PF03690 : UPF0160", "PF02990 : EMP70", 
                      "SSF47986 : 0036420", "PS50023 : LIM_DOMAIN_2", "SSF56601 : 0046929", 
                      "SSF53067 : 0045955", "PF02109 : DAD", "SSF53067 : 0042565", 
                      "SSF88713 : 0041614", "SSF88713 : 0038723", "SSF56059 : 0037006", 
                      "PF01929 : Ribosomal_L14e", "SSF53067 : 0036472", "SSF90209 : 0041175", 
                      "SSF48619 : 0035019", "SSF55729 : 0052701", "SSF51735 : 0050776", 
                      "PF02729 : OTCace_N", "SSF53901 : 0036782", "SSF101288 : 0051593", 
                      "SSF53335 : 0043046", "SSF81338 : 0043191", "SSF48508 : 0042270", 
                      "SSF46689 : 0047202", "TIGR00451 : unchar_dom_2", "SSF57095 : 0041328", 
                      "SSF100895 : 0038668", "SSF48695 : 0043396", "PIRSF037309 :", 
                      "PD001295 :", "PF05971 : Methyltransf_10", "SSF50494 : 0037607", 
                      "SSF101386 : 0051698", "SSF51604 : 0043960", "SSF51182 : 0051625", 
                      "SSF57302 : 0047584", "PF10394 : Hat1_N", "PF02784 : Orn_Arg_deC_N", 
                      "SSF50978 : 0048760", "SSF50249 : 0037961", "SSF51905 : 0048199", 
                      "SSF51726 : 0049768", "SSF52833 : 0050456", "SSF51182 : 0039120", 
                      "SSF63882 : 0044571", "SSF48498 : 0053203", "SSF56524 : 0041847", 
                      "SSF57716 : 0038533", "SSF57802 : 0039154", "SSF51011 : 0035737", 
                      "SSF47576 : 0044393", "PR00024 : HOMEOBOX", "TIGR00337 : PyrG", 
                      "SSF51604 : 0039288", "SSF48695 : 0042897", "SSF51905 : 0044414", 
                      "SSF47473 : 0049061", "SSF54160 : 0051887", "PR00360 : C2DOMAIN", 
                      "SSF54665 : 0037700", "PF02146 : SIR2", "SSF56436 : 0048802", 
                      "SSF56436 : 0046554", "SSF52218 : 0052813", "PS50004 : C2", "PF08578 : DUF1765", 
                      "SSF48726 : 0037684", "SSF54593 : 0041502", "SSF69360 : 0038536", 
                      "SSF55811 : 0044827", "SSF49503 : 0045175", "PF01821 : ANATO", 
                      "SSF48726 : 0037856", "TIGR01019 : sucCoAalpha", "SSF46626 : 0048977", 
                      "SSF51445 : 0035899", "SSF46988 : 0042971", "SSF54593 : 0046682", 
                      "SSF52540 : 0050044", "SSF47095 : 0047509", "PF01417 : ENTH", 
                      "SSF47769 : 0045878", "SSF56672 : 0051077", "SSF51395 : 0038308", 
                      "PIRSF015901 :", "SSF57440 : 0053081", "SSF49899 : 0044686", 
                      "SSF48726 : 0038648", "SSF57630 : 0048383", "SSF50129 : 0048672", 
                      "SSF55681 : 0038522", "PF01975 : SurE", "SSF46785 : 0051337", 
                      "SSF54919 : 0039903", "SSF75632 : 0047961", "SSF52047 : 0045711", 
                      "PF00627 : UBA", "SSF54919 : 0050982", "PF03309 : Bvg_acc_factor", 
                      "SSF49401 : 0048289", "TIGR01101 : V_ATP_synt_F", "SSF50891 : 0040592", 
                      "PF04998 : RNA_pol_Rpb1_5", "SSF48726 : 0043259", "SSF51182 : 0051939", 
                      "SSF50729 : 0050531", "PF02978 : SRP_SPB", "SSF49785 : 0049620", 
                      "SSF57196 : 0046224", "SSF53901 : 0049604", "SSF47473 : 0046706", 
                      "SSF51430 : 0048892", "SSF47175 : 0034937", "SSF89550 : 0050078", 
                      "SSF47060 : 0050942", "SSF54928 : 0051748", "PF00400 : WD40", 
                      "SSF50494 : 0041992", "SSF50939 : 0046723", "PF00645 : zf-PARP", 
                      "SSF88633 : 0038482", "SSF55331 : 0043461", "SSF88697 : 0049603", 
                      "PF08950 : DUF1861", "PF05096 : Glu_cyclase_2", "SSF51182 : 0037114", 
                      "SSF47240 : 0039604", "SSF52540 : 0051535", "SSF51445 : 0042224", 
                      "PF00494 : SQS_PSY", "PD006584 :", "SSF50978 : 0038192", "PF05178 : Kri1", 
                      "SSF48264 : 0036587", "SSF52540 : 0046842", "SSF53901 : 0036364", 
                      "PS51181 : PPASE_TENSIN", "PF01697 : DUF23", "PD034736 :", "SSF47576 : 0042512", 
                      "SSF49785 : 0048542", "SSF57016 : 0045237", "PS51044 : ZF_SP_RING", 
                      "SSF51621 : 0039020", "SSF51225 : 0042807", "SSF49319 : 0034999", 
                      "SSF57059 : 0037093", "SSF88633 : 0036089", "SSF63380 : 0038920", 
                      "SSF52540 : 0048410", "SSF57667 : 0043984", "SSF55021 : 0052563", 
                      "SSF54236 : 0044657", "SSF50203 : 0037692", "SSF55239 : 0045565", 
                      "SSF56420 : 0040623", "PF02233 : PNTB", "SSF56003 : 0048288", 
                      "SSF51126 : 0039916", "SSF53187 : 0042930", "PF00173 : Cyt-b5", 
                      "SSF47240 : 0045047", "SSF51905 : 0050927", "SSF54862 : 0040210", 
                      "TIGR01071 : rplO_bact", "PF04749 : PLAC8", "SSF49899 : 0046076", 
                      "SSF52121 : 0038676", "SSF69000 : 0041970", "SSF48403 : 0039839", 
                      "SSF51445 : 0046755", "SSF52402 : 0036147", "SSF55331 : 0051736", 
                      "SSF48726 : 0040178", "SSF100950 : 0042405", "SSF52218 : 0035735", 
                      "SSF51735 : 0043068", "SSF46458 : 0042922", "SSF50249 : 0038161", 
                      "SSF103025 : 0042338", "SSF50494 : 0052737", "SSF50789 : 0045005", 
                      "TIGR00601 : rad23", "SSF47986 : 0041381", "SSF55550 : 0044534", 
                      "SSF54928 : 0053313", "SSF55979 : 0046361", "SSF54928 : 0045485", 
                      "SSF51445 : 0039441", "SSF55298 : 0036333", "SSF51445 : 0049716", 
                      "SSF56235 : 0042559", "SSF55931 : 0041182", "SSF53800 : 0040445", 
                      "SSF46894 : 0040611", "SSF51351 : 0038583", "PS51035 : BAG", 
                      "SSF56235 : 0045430", "SSF53756 : 0045091", "SSF55979 : 0045419", 
                      "PF08659 : KR", "SSF48726 : 0039906", "SSF47014 : 0038541", "PF00516 : GP120", 
                      "SSF57196 : 0048718", "SSF82282 : 0048028", "SSF47473 : 0045431", 
                      "PF00620 : RhoGAP", "TIGR02127 : pyrF_sub2", "SSF55856 : 0038968", 
                      "SSF53150 : 0037231", "SSF57667 : 0042182", "SSF88713 : 0050069", 
                      "SSF51126 : 0042818", "SSF50386 : 0050426", "SSF52540 : 0038720", 
                      "PF03489 : SapB_2", "SSF51011 : 0041486", "PF04945 : YHS", "SSF54680 : 0044472", 
                      "SSF50249 : 0047474", "SSF47802 : 0047629", "SSF53850 : 0051090", 
                      "SSF75445 : 0040230", "SSF46626 : 0046678", "SSF51445 : 0036798", 
                      "SSF57277 : 0042767", "SSF51905 : 0038189", "SSF47943 : 0042959", 
                      "SSF54001 : 0051992", "SSF75217 : 0044746", "SSF57667 : 0052896", 
                      "SSF52540 : 0052003", "PF01866 : Diphthamide_syn", "PF04179 : Init_tRNA_PT", 
                      "SSF51735 : 0046483", "SSF53474 : 0051883", "SSF46458 : 0036906", 
                      "SSF50998 : 0040005", "SSF55608 : 0036553", "SSF51621 : 0042356", 
                      "PF10181 : PIG-H", "PF04032 : Rpr2", "SSF53850 : 0042231", "SSF103456 : 0043251", 
                      "SSF54427 : 0044078", "SSF47336 : 0036515", "SSF52540 : 0037960", 
                      "SSF54909 : 0043709", "SSF47943 : 0040398", "SSF55909 : 0043530", 
                      "SSF69687 : 0039775", "SSF52467 : 0042566", "PF10586 : PP2A_B_N", 
                      "SSF54236 : 0043625", "SSF57667 : 0053340", "SSF88633 : 0042485", 
                      "PF04991 : LicD", "SSF48225 : 0038535", "SSF51735 : 0048035", 
                      "SSF53795 : 0047844", "PF08311 : Mad3_BUB1_I", "SSF47162 : 0035788", 
                      "SSF56112 : 0042707", "SSF57302 : 0045505", "SSF52833 : 0039542", 
                      "SSF46689 : 0044216", "TIGR01020 : rpsE_arch", "SSF53067 : 0053029", 
                      "SSF51604 : 0041817", "SSF47413 : 0051985", "SSF47473 : 0049706", 
                      "PF02096 : 60KD_IMP", "SSF52091 : 0044005", "SSF52540 : 0037986", 
                      "SSF81995 : 0040743", "SSF90209 : 0048377", "SSF54236 : 0037201", 
                      "SSF51621 : 0043598", "SSF48056 : 0040538", "SSF52540 : 0049825", 
                      "PD062785 :", "SSF81296 : 0045704", "SSF81301 : 0051904", "SSF56112 : 0037731", 
                      "SSF46689 : 0050796", "SSF51971 : 0046156", "SSF53474 : 0038133", 
                      "SSF56837 : 0034942", "PF05180 : zf-DNL", "PF07978 : NIPSNAP", 
                      "SSF54928 : 0052217", "PR00750 : BETAAMYLASE", "SSF48179 : 0041497", 
                      "TIGR01833 : HMG-CoA-S_euk", "SSF51197 : 0048968", "SSF48726 : 0048332", 
                      "SSF48726 : 0038553", "SSF50814 : 0041962", "SSF49899 : 0046423", 
                      "PR00505 : D12N6MTFRASE", "SSF49842 : 0043266", "SSF46626 : 0039581", 
                      "PF07759 : DUF1615", "SSF52029 : 0034907", "SSF54593 : 0049443", 
                      "PS51168 : CHORISMATE_MUT_2", "PD001895 :", "PIRSF002769 :", 
                      "SSF51735 : 0038547", "PF03330 : DPBB_1", "SSF50353 : 0047494", 
                      "SSF48726 : 0038989", "SSF48726 : 0048331", "SSF55073 : 0035278", 
                      "SSF50129 : 0038710", "SSF49313 : 0041309", "SSF51445 : 0045654", 
                      "SSF53187 : 0049240", "SSF46785 : 0052246", "SSF48208 : 0047896", 
                      "SSF52218 : 0045623", "SSF64484 : 0039236", "SSF52833 : 0049632", 
                      "SSF54285 : 0049256", "SSF48726 : 0051029", "SSF56436 : 0037804", 
                      "TIGR00212 : hemC", "SSF47769 : 0045861", "SSF52402 : 0039977", 
                      "PS50405 : GST_CTER", "PD136566 :", "SSF54277 : 0052120", "TIGR03106 : trio_M42_hydro", 
                      "SSF46997 : 0038121", "SSF53271 : 0034851", "PF03765 : CRAL_TRIO_N", 
                      "SSF52096 : 0051041", "SSF49899 : 0037454", "PF08142 : AARP2CN", 
                      "SSF52374 : 0039998", "SSF56601 : 0035095", "SSF52540 : 0046479", 
                      "SSF53659 : 0050681", "PF03024 : Folate_rec", "SSF49384 : 0041294", 
                      "SSF82282 : 0049954", "SSF50249 : 0038682", "PS50812 : PWWP", 
                      "SSF47459 : 0040898", "SSF57716 : 0052319", "SSF56796 : 0041880", 
                      "SSF53067 : 0035709", "SSF48726 : 0044027", "SSF47741 : 0036414", 
                      "SSF48726 : 0042009", "SSF54897 : 0043835", "SSF63562 : 0047454", 
                      "SSF47769 : 0047895", "SSF53474 : 0037610", "SSF51905 : 0040049", 
                      "SSF48208 : 0037466", "SSF55804 : 0034850", "SSF53790 : 0035898", 
                      "SSF48150 : 0048358", "SSF55729 : 0036020", "SSF48371 : 0047230", 
                      "SSF52833 : 0046445", "SSF48179 : 0039359", "PF00935 : Ribosomal_L44", 
                      "SSF63515 : 0046981", "SSF56601 : 0038040", "SSF47668 : 0045208", 
                      "PF01000 : RNA_pol_A_bac", "SSF52096 : 0038654", "PD002572 :", 
                      "SSF88633 : 0045359", "PF01687 : Flavokinase", "SSF109709 : 0050319", 
                      "SSF48208 : 0037980", "PF02915 : Rubrerythrin", "SSF51735 : 0050040", 
                      "SSF51366 : 0042331", "PF01590 : GAF", "SSF57850 : 0044658", 
                      "SSF48726 : 0047878", "SSF51445 : 0052495", "PF03575 : Peptidase_S51", 
                      "SSF55550 : 0035143", "SSF51206 : 0041694", "PF01041 : DegT_DnrJ_EryC1", 
                      "SSF56029 : 0038675", "SSF53901 : 0042063", "PS50030 : UBA", 
                      "SSF52833 : 0043121", "PF06680 : DUF1181", "SSF56003 : 0043860", 
                      "PF01125 : G10", "SSF53335 : 0052001", "SSF54001 : 0043495", 
                      "SSF81301 : 0037394", "PS51185 : WHEP_TRS_2", "SSF100950 : 0044389", 
                      "SSF57868 : 0037672", "PF02239 : Cytochrom_D1", "SSF53067 : 0050912", 
                      "SSF52799 : 0040417", "SSF51735 : 0040551", "SSF51971 : 0036459", 
                      "SSF51735 : 0038324", "SSF52540 : 0047023", "SSF46458 : 0053188", 
                      "SSF49503 : 0041325", "SSF49842 : 0039757", "SSF55753 : 0042657", 
                      "SSF49503 : 0038328", "PF01434 : Peptidase_M41", "SSF51621 : 0040767", 
                      "SSF51445 : 0046497", "PF00704 : Glyco_hydro_18", "TIGR00307 : S8e", 
                      "PF01423 : LSM", "SSF48034 : 0042781", "SSF110304 : 0043741", 
                      "PR00939 : C2HCZNFINGER", "SSF54495 : 0038907", "SSF48019 : 0039712", 
                      "SSF53335 : 0044689", "SSF52266 : 0051596", "SSF56327 : 0053173", 
                      "TIGR00093 : TIGR00093", "SSF54211 : 0044291", "PIRSF037023 :", 
                      "SSF57196 : 0049664", "SSF69635 : 0039817", "SSF46458 : 0042244", 
                      "SSF101386 : 0051724", "SSF52402 : 0050739", "SSF52949 : 0043702", 
                      "PF02223 : Thymidylate_kin", "SSF51306 : 0035304", "SSF48179 : 0051796", 
                      "SSF51445 : 0045065", "SSF47203 : 0043628", "PD009934 :", "SSF54675 : 0051404", 
                      "PD147181 :", "SSF54637 : 0052966", "SSF75689 : 0041337", "SSF52777 : 0040385", 
                      "PF03255 : ACCA", "SSF47576 : 0036662", "PF01770 : Folate_carrier", 
                      "SSF47240 : 0049497", "SSF53474 : 0049638", "SSF51569 : 0049279", 
                      "SSF57302 : 0037155", "SSF56425 : 0040050", "SSF56425 : 0042840", 
                      "SSF47699 : 0043446", "SSF81301 : 0035658", "TIGR03284 : thym_sym", 
                      "PF07064 : RIC1", "SSF53933 : 0035177", "SSF54665 : 0037562", 
                      "SSF53623 : 0037575", "SSF51735 : 0048243", "SSF52096 : 0048476", 
                      "SSF75399 : 0040558", "SSF53300 : 0047568", "SSF47113 : 0047903", 
                      "PF04153 : NOT2_3_5", "SSF51905 : 0047022", "SSF49265 : 0050820", 
                      "SSF51351 : 0035234", "PF03099 : BPL_LipA_LipB", "PF03770 : IPK", 
                      "SSF50494 : 0040590", "SSF88633 : 0046730", "SSF55347 : 0048557", 
                      "SSF88645 : 0041108", "SSF48371 : 0053212", "SSF53067 : 0046239", 
                      "SSF51338 : 0039387", "TIGR00231 : small_GTP", "PF02095 : Extensin_1", 
                      "SSF50044 : 0044289", "SSF54328 : 0035622", "TIGR01126 : pdi_dom", 
                      "SSF49785 : 0041689", "SSF55418 : 0049154", "SSF52833 : 0047173", 
                      "SSF52540 : 0043973", "SSF55979 : 0043899", "PR00707 : UBCTHYDRLASE", 
                      "PF09674 : DUF2400", "SSF50494 : 0045688", "SSF52833 : 0048908", 
                      "SSF56436 : 0040503", "PS50974 : ADOMET_ACTIVATION", "SSF88697 : 0037984", 
                      "SSF57716 : 0045906", "SSF46689 : 0052848", "SSF46785 : 0052734", 
                      "SSF109604 : 0050288", "SSF48371 : 0048021", "PF02781 : G6PD_C", 
                      "SSF51735 : 0046897", "SSF51430 : 0048842", "SSF51182 : 0041831", 
                      "SSF54957 : 0035775", "SSF53720 : 0035003", "SSF55331 : 0041123", 
                      "PS50970 : HCY", "TIGR00669 : asnA", "SSF55347 : 0035681", "SSF53067 : 0043897", 
                      "SSF51395 : 0036258", "SSF53613 : 0049742", "SSF53955 : 0040570", 
                      "SSF81296 : 0047877", "SSF55282 : 0040968", "SSF48726 : 0041840", 
                      "SSF52335 : 0051559", "SSF51621 : 0034867", "SSF47060 : 0036463", 
                      "SSF53383 : 0051195", "SSF47266 : 0037850", "PF00411 : Ribosomal_S11", 
                      "SSF47240 : 0048625", "PF04969 : CS", "SSF53254 : 0043909", "SSF53671 : 0044884", 
                      "SSF52518 : 0039197", "SSF100895 : 0040627", "PF03825 : Nuc_H_symport", 
                      "SSF46689 : 0045348", "SSF46458 : 0035185", "SSF54913 : 0041684", 
                      "SSF51717 : 0035068", "SSF54747 : 0050580", "SSF48726 : 0042052", 
                      "PF00198 : 2-oxoacid_dh", "PD395423 :", "SSF52972 : 0035385", 
                      "SSF52440 : 0045750", "SSF88633 : 0037444", "PIRSF015952 :", 
                      "SSF54160 : 0052476", "PIRSF037097 :", "PIRSF022536 :", "SSF46767 : 0040917", 
                      "SSF51351 : 0038714", "SSF56672 : 0035823", "PIRSF001434 :", 
                      "SSF81923 : 0049052", "SSF53092 : 0040192", "SSF51445 : 0045024", 
                      "SSF54495 : 0042542", "SSF52402 : 0042641", "PIRSF006398 :", 
                      "SSF55031 : 0037689", "SSF57850 : 0037895", "SSF52440 : 0044851", 
                      "SSF53098 : 0051245", "SSF51658 : 0049745", "SSF53633 : 0053112", 
                      "SSF51445 : 0041492", "PIRSF000747 :", "SSF46689 : 0052877", 
                      "PF07977 : FabA", "PF01683 : EB", "SSF89946 : 0048462", "PR00499 : P67PHOX", 
                      "SSF51735 : 0038087", "SSF51621 : 0036647", "SSF51735 : 0041828", 
                      "SSF50249 : 0041735", "SSF46458 : 0046962", "SSF49503 : 0049366", 
                      "SSF57716 : 0050907", "SSF50891 : 0036200", "PF05189 : RTC_insert", 
                      "SSF109604 : 0051349", "SSF52821 : 0049979", "PF08084 : PROCT", 
                      "SSF57059 : 0045772", "SSF46609 : 0042884", "SSF50814 : 0042174", 
                      "SSF48081 : 0036807", "SSF52777 : 0042676", "SSF46992 : 0037628", 
                      "SSF48726 : 0044969", "SSF47220 : 0042833", "PF04493 : Endonuclease_5", 
                      "SSF55729 : 0051248", "SSF53335 : 0039697", "SSF57716 : 0050851", 
                      "SSF52833 : 0042825", "SSF55205 : 0037035", "PF01851 : PC_rep", 
                      "TIGR01359 : UMP_CMP_kin_fam", "SSF51283 : 0049218", "SSF53474 : 0046077", 
                      "PF02617 : ClpS", "SSF51011 : 0049501", "SSF53756 : 0037081", 
                      "SSF49562 : 0046395", "SSF56399 : 0043470", "SSF57016 : 0044428", 
                      "SSF55347 : 0044841", "PF10551 : MULE", "PIRSF037527 :", "SSF55637 : 0036038", 
                      "SSF55920 : 0043037", "SSF48726 : 0045840", "SSF63515 : 0046927", 
                      "SSF54117 : 0035635", "PF02210 : Laminin_G_2", "SSF51735 : 0042366", 
                      "PF09377 : SBDS_C", "SSF54001 : 0045148", "SSF55021 : 0048810", 
                      "SSF53822 : 0035780", "SSF55257 : 0051060", "SSF46934 : 0050528", 
                      "SSF48498 : 0039750", "SSF47240 : 0040938", "SSF49265 : 0049599", 
                      "SSF54637 : 0052592", "SSF55550 : 0035526", "SSF51569 : 0051144", 
                      "PS50989 : COA_CT_CTER", "SSF54631 : 0045121", "PD000600 :", 
                      "PR00507 : N12N6MTFRASE", "PS50144 : MATH", "SSF54637 : 0051892", 
                      "SSF57184 : 0047449", "TIGR00523 : eIF-1A", "SSF49785 : 0050662", 
                      "SSF54416 : 0041277", "SSF51604 : 0046786", "PF05916 : Sld5", 
                      "PF00910 : RNA_helicase", "SSF49401 : 0042998", "SSF50044 : 0044356", 
                      "SSF56371 : 0038090", "SSF47266 : 0038018", "SSF51905 : 0042446", 
                      "SSF46689 : 0038632", "PF00705 : PCNA_N", "SSF55856 : 0035243", 
                      "PR00062 : RIBOSOMALL20", "PS50206 : RHODANESE_3", "SSF51445 : 0035942", 
                      "SSF51366 : 0050062", "PR00700 : PRTYPHPHTASE", "PF04564 : U-box", 
                      "SSF53098 : 0050330", "SSF57903 : 0050475", "SSF48576 : 0049855", 
                      "SSF52833 : 0051123", "SSF55486 : 0035598", "SSF46626 : 0039582", 
                      "SSF57552 : 0043969", "SSF57501 : 0038527", "SSF51445 : 0045014", 
                      "SSF51735 : 0038770", "SSF51445 : 0051733", "PR00473 : GALCTOKINASE", 
                      "SSF46942 : 0037100", "SSF54928 : 0038539", "PS50156 : SSD", 
                      "PF02994 : Transposase_22", "PF05832 : DUF846", "SSF57701 : 0035235", 
                      "SSF47473 : 0045680", "PF03991 : Prion_octapep", "SSF51735 : 0051542", 
                      "SSF55729 : 0052522", "SSF52096 : 0037486", "SSF52980 : 0036404", 
                      "SSF46689 : 0050954", "SSF82861 : 0041140", "SSF51695 : 0048917", 
                      "PD005658 :", "SSF53738 : 0039875", "SSF49265 : 0036990", "SSF54076 : 0038286", 
                      "SSF50405 : 0036401", "SSF51735 : 0040542", "SSF51621 : 0039294", 
                      "SSF54897 : 0039190", "SSF52980 : 0050698", "SSF56235 : 0047031", 
                      "PF03807 : F420_oxidored", "SSF56854 : 0040707", "SSF46458 : 0037869", 
                      "SSF53335 : 0044140", "SSF47769 : 0050795", "SSF52833 : 0048804", 
                      "SSF50156 : 0050833", "SSF50494 : 0047957", "SSF55785 : 0037897", 
                      "SSF49899 : 0040215", "PF01239 : PPTA", "SSF53067 : 0046348", 
                      "SSF50692 : 0040208", "SSF50814 : 0036784", "SSF52343 : 0039466", 
                      "SSF57630 : 0042658", "SSF88659 : 0051096", "SSF52540 : 0048050", 
                      "PS50275 : SAC", "SSF46561 : 0037547", "SSF75217 : 0041708", 
                      "PF01823 : MACPF", "PF05236 : TAF4", "SSF53850 : 0045817", "SSF51735 : 0049845", 
                      "SSF49265 : 0035651", "SSF52540 : 0042538", "PIRSF005567 :", 
                      "SSF55298 : 0051889", "PR00881 : L7ARS6FAMILY", "SSF52540 : 0051486", 
                      "PIRSF000164 :", "SSF53335 : 0052618", "SSF57756 : 0046619", 
                      "SSF54909 : 0043520", "SSF111384 : 0044195", "TIGR00191 : thrB", 
                      "SSF52096 : 0044384", "SSF110857 : 0050970", "TIGR00121 : birA_ligase", 
                      "SSF56003 : 0037563", "SSF51197 : 0047646", "PF01549 : ShK", 
                      "SSF52499 : 0041293", "TIGR00879 : SP", "SSF47473 : 0036978", 
                      "SSF50044 : 0044341", "SSF48366 : 0041591", "PF08378 : NERD", 
                      "SSF56059 : 0036763", "PF10584 : Proteasome_A_N", "TIGR00308 : TRM1", 
                      "SSF54686 : 0050637", "PF06071 : YchF-GTPase_C", "SSF56496 : 0037860", 
                      "SSF88633 : 0042486", "SSF51430 : 0047249", "PD125245 :", "SSF57440 : 0034809", 
                      "SSF51905 : 0037489", "PF08234 : Spindle_Spc25", "PIRSF004537 :", 
                      "PS50296 : SUI1", "SSF51971 : 0047327", "PF06827 : zf-FPG_IleRS", 
                      "PF02080 : TrkA_C", "SSF55021 : 0044223", "SSF54495 : 0039448", 
                      "PIRSF037239 :", "SSF81811 : 0048071", "PF01321 : Creatinase_N", 
                      "SSF53474 : 0047879", "PR00775 : HEATSHOCK90", "SSF52172 : 0051574", 
                      "SSF52343 : 0046686", "SSF55729 : 0040775", "SSF52540 : 0049053", 
                      "PF01776 : Ribosomal_L22e", "SSF57783 : 0046246", "SSF102848 : 0044687", 
                      "PF10260 : SAYSvFN", "SSF47240 : 0041751", "SSF53067 : 0051662", 
                      "SSF51735 : 0045221", "SSF52540 : 0044916", "SSF57302 : 0044003", 
                      "PS50208 : CASPASE_P20", "SSF47473 : 0037388", "SSF47175 : 0043455", 
                      "SSF57586 : 0041972", "SSF52540 : 0049759", "SSF69695 : 0040576", 
                      "PF02568 : ThiI", "PD001109 :", "SSF53756 : 0051981", "SSF47473 : 0046115", 
                      "SSF52799 : 0051429", "SSF56762 : 0035906", "SSF53901 : 0036783", 
                      "PIRSF002166 :", "PF05221 : AdoHcyase", "SSF53098 : 0048960", 
                      "SSF54862 : 0047184", "SSF51197 : 0051687", "SSF50969 : 0039586", 
                      "SSF88633 : 0041965", "SSF53474 : 0044009", "SSF53474 : 0049094", 
                      "SSF55874 : 0040344", "SSF52172 : 0043733", "SSF51735 : 0053216", 
                      "SSF54919 : 0048448", "PR00888 : SM22CALPONIN", "SSF54695 : 0045530", 
                      "PIRSF015892 :", "PF06221 : zf-C2HC5", "SSF55811 : 0043641", 
                      "SSF52309 : 0039181", "SSF51905 : 0041393", "PD013942 :", "PF01436 : NHL", 
                      "SSF55909 : 0037953", "PF02823 : ATP-synt_DE_N", "SSF51197 : 0038197", 
                      "SSF52021 : 0034973", "PF07713 : DUF1604", "SSF53067 : 0036471", 
                      "SSF88633 : 0036268", "SSF51161 : 0043848", "SSF52540 : 0051499", 
                      "SSF57716 : 0052316", "SSF47917 : 0037816", "SSF53474 : 0041081", 
                      "SSF53748 : 0034787", "SSF55003 : 0043169", "SSF48498 : 0044770", 
                      "SSF54957 : 0036332", "PS50032 : KA1", "SSF51182 : 0036427", 
                      "PF00725 : 3HCDH", "SSF55895 : 0039273", "PIRSF017199 :", "SSF48726 : 0039149", 
                      "SSF81301 : 0051344", "TIGR00063 : folE", "SSF56784 : 0053003", 
                      "SSF57302 : 0047417", "PIRSF000303 :", "SSF54695 : 0043466", 
                      "SSF51366 : 0048998", "SSF52317 : 0043467", "SSF54403 : 0047900", 
                      "SSF53671 : 0036649", "SSF53067 : 0052948", "SSF54928 : 0050566", 
                      "SSF50939 : 0041069", "PF08443 : RimK", "SSF50156 : 0044623", 
                      "SSF50615 : 0043647", "SSF51621 : 0038453", "SSF57850 : 0036769", 
                      "SSF57586 : 0043592", "SSF53671 : 0049701", "SSF51735 : 0041952", 
                      "PF01421 : Reprolysin", "SSF51658 : 0045048", "SSF49785 : 0040044", 
                      "SSF51283 : 0037428", "SSF47413 : 0036085", "TIGR00549 : mevalon_kin", 
                      "SSF56104 : 0052189", "SSF56112 : 0043269", "SSF51905 : 0052963", 
                      "SSF51395 : 0052481", "SSF52413 : 0036489", "SSF51064 : 0036470", 
                      "TIGR02512 : Fe_only_hydrog", "TIGR00603 : rad25", "SSF47836 : 0052612", 
                      "SSF53383 : 0035589", "SSF53659 : 0043057", "SSF49899 : 0041448", 
                      "SSF46966 : 0049304", "SSF52833 : 0042453", "SSF46626 : 0045713", 
                      "PF08016 : PKD_channel", "SSF52777 : 0041318", "PD000006 :", 
                      "SSF52540 : 0046001", "PF00302 : CAT", "SSF53067 : 0035708", 
                      "SSF56399 : 0040659", "SSF54211 : 0044305", "SSF81296 : 0051013", 
                      "SSF50923 : 0038071", "SSF48726 : 0042362", "SSF57586 : 0037253", 
                      "SSF102462 : 0042649", "SSF52833 : 0046603", "SSF49899 : 0041110", 
                      "SSF101238 : 0050794", "PF01904 : DUF72", "SSF54506 : 0051110", 
                      "SSF54236 : 0050607", "SSF46785 : 0047290", "SSF54292 : 0046241", 
                      "SSF51445 : 0049124", "SSF51011 : 0037001", "SSF49562 : 0036823", 
                      "PF08152 : GUCT", "SSF53784 : 0040332", "SSF48179 : 0048756", 
                      "SSF48726 : 0046172", "SSF50978 : 0048681", "SSF52218 : 0043822", 
                      "SSF49384 : 0038564", "SSF57501 : 0040782", "SSF56371 : 0035687", 
                      "SSF47681 : 0037420", "SSF54637 : 0041651", "SSF51294 : 0036550", 
                      "SSF52833 : 0035176", "PF09139 : Mmp37", "SSF54373 : 0042337", 
                      "SSF52540 : 0040165", "PF03037 : KMP11", "SSF49785 : 0041821", 
                      "PS50957 : JOSEPHIN", "SSF103263 : 0044435", "SSF51679 : 0043239", 
                      "SSF54593 : 0043714", "SSF48498 : 0049196", "SSF49899 : 0046944", 
                      "SSF57535 : 0053252", "PD331788 :", "SSF54810 : 0038212", "SSF51445 : 0037132", 
                      "PS50815 : HORMA", "SSF46785 : 0036548", "SSF48557 : 0039358", 
                      "PF05391 : Lsm_interact", "SSF49785 : 0038269", "SSF51412 : 0045119", 
                      "SSF54909 : 0050293", "PD135085 :", "SSF49749 : 0040770", "SSF46924 : 0036952", 
                      "SSF53167 : 0044423", "SSF69369 : 0039480", "PF01638 : DUF24", 
                      "SSF54506 : 0049758", "SSF63817 : 0043439", "SSF48239 : 0036306", 
                      "SSF50494 : 0035182", "PF02834 : 2_5_RNA_ligase", "PF08323 : Glyco_transf_5", 
                      "PR00143 : CITRTSNTHASE", "SSF50891 : 0045013", "PF03372 : Exo_endo_phos", 
                      "SSF54495 : 0051563", "PF04410 : Gar1", "SSF48619 : 0042095", 
                      "SSF55486 : 0047529", "SSF46785 : 0046914", "SSF57535 : 0038113", 
                      "SSF57095 : 0052009", "SSF88633 : 0048329", "PF02407 : Viral_Rep", 
                      "PF00145 : DNA_methylase", "TIGR01127 : ilvA_1Cterm", "PR01887 : SPECTRNALPHA", 
                      "SSF57586 : 0039628", "SSF53383 : 0051723", "PF03313 : SDH_alpha", 
                      "PF07000 : DUF1308", "TIGR00425 : CBF5", "TIGR03676 : aRF1/eRF1", 
                      "SSF55298 : 0051080", "SSF51905 : 0045881", "SSF54928 : 0052230", 
                      "SSF57059 : 0046861", "SSF49503 : 0035435", "SSF47266 : 0043242", 
                      "SSF51735 : 0044526", "TIGR00449 : tgt_general", "TIGR00455 : apsK", 
                      "SSF49309 : 0040427", "SSF57095 : 0042274", "SSF46785 : 0040266", 
                      "PF06777 : DUF1227", "SSF47616 : 0045522", "SSF51126 : 0048840", 
                      "SSF54768 : 0052472", "SSF48179 : 0048408", "SSF51351 : 0048284", 
                      "PS51111 : REJ", "PF09190 : DALR_2", "SSF57756 : 0037419", "PR00142 : RECA", 
                      "SSF53098 : 0045929", "SSF56300 : 0053347", "SSF51735 : 0049902", 
                      "SSF55620 : 0045884", "PD238818 :", "PF02209 : VHP", "TIGR01354 : cyt_deam_tetra", 
                      "SSF50814 : 0038816", "SSF53756 : 0048814", "SSF51395 : 0040553", 
                      "SSF48726 : 0044977", "SSF88697 : 0052524", "SSF54001 : 0045074", 
                      "SSF53448 : 0053095", "PF03007 : UPF0089", "TIGR02344 : chap_CCT_gamma", 
                      "SSF54909 : 0043255", "SSF47616 : 0037971", "SSF54637 : 0041468", 
                      "PR01797 : SAPOSIN", "SSF54637 : 0039126", "SSF51658 : 0039938", 
                      "SSF101059 : 0043524", "PIRSF005384 :", "SSF48484 : 0045088", 
                      "SSF47473 : 0035674", "PD000475 :", "SSF48508 : 0050898", "SSF101215 : 0043173", 
                      "SSF52440 : 0039112", "SSF54913 : 0049066", "SSF51445 : 0049162", 
                      "SSF57716 : 0044641", "PF02434 : Fringe", "SSF54001 : 0045662", 
                      "SSF52121 : 0035841", "SSF81296 : 0046150", "SSF46785 : 0052641", 
                      "SSF51306 : 0039545", "SSF63411 : 0047226", "SSF53335 : 0051840", 
                      "SSF53098 : 0041666", "SSF52540 : 0040118", "SSF102705 : 0041462", 
                      "SSF47240 : 0052811", "PR00721 : STOMATIN", "SSF51445 : 0036429", 
                      "PD005388 :", "TIGR01376 : POMP_repeat", "PS51321 : TFIIS_CENTRAL", 
                      "SSF50494 : 0036116", "PF01223 : Endonuclease_NS", "SSF55060 : 0049315", 
                      "SSF63570 : 0038011", "SSF52418 : 0050093", "PF08774 : VRR_NUC", 
                      "SSF50494 : 0042416", "SSF54285 : 0043419", "PIRSF015894 :", 
                      "PS50216 : ZF_DHHC", "SSF53597 : 0045504", "SSF52113 : 0039668", 
                      "SSF53167 : 0037905", "PF01008 : IF-2B", "PS51384 : FAD_FR", 
                      "SSF54909 : 0052160", "SSF81296 : 0046563", "PD001859 :", "SSF52172 : 0038859", 
                      "SSF81296 : 0047116", "SSF57362 : 0040457", "SSF53901 : 0049764", 
                      "SSF48726 : 0040056", "SSF54117 : 0035332", "SSF56935 : 0046039", 
                      "SSF48508 : 0044364", "SSF52374 : 0039071", "PD003829 :", "SSF48403 : 0039063", 
                      "SSF46689 : 0050781", "PF06247 : Plasmod_Pvs28", "SSF49899 : 0048910", 
                      "SSF51182 : 0047686", "PF02558 : ApbA", "SSF49899 : 0048847", 
                      "SSF48619 : 0035133", "PF01472 : PUA", "SSF52374 : 0047114", 
                      "SSF54593 : 0048208", "SSF49785 : 0050401", "PF10172 : DDA1", 
                      "PD034433 :", "SSF51735 : 0040651", "PF04724 : Glyco_transf_17", 
                      "SSF48179 : 0052564", "SSF47954 : 0044785", "PF03061 : 4HBT", 
                      "SSF54686 : 0037534", "PF05007 : Mannosyl_trans", "SSF81383 : 0042120", 
                      "SSF47862 : 0041232", "PD007306 :", "SSF48619 : 0040921", "SSF57667 : 0034826", 
                      "SSF57825 : 0045170", "SSF54849 : 0039108", "SSF52799 : 0040695", 
                      "TIGR03303 : OM_YaeT", "SSF51126 : 0042712", "SSF53784 : 0047912", 
                      "TIGR00471 : pheT_arch", "SSF54358 : 0046588", "SSF57667 : 0045295", 
                      "SSF54358 : 0039632", "SSF52540 : 0051325", "SSF47699 : 0041254", 
                      "SSF57903 : 0050463", "SSF51735 : 0036235", "SSF48179 : 0050909", 
                      "SSF50891 : 0051587", "SSF51395 : 0038467", "TIGR02341 : chap_CCT_beta", 
                      "SSF46458 : 0041116", "PD630236 :", "SSF52317 : 0050645", "SSF49265 : 0035963", 
                      "SSF57667 : 0045151", "SSF48150 : 0043362", "SSF53639 : 0039491", 
                      "SSF52540 : 0044321", "SSF54928 : 0049334", "SSF50370 : 0040751", 
                      "SSF53822 : 0045658", "SSF49695 : 0035104", "SSF81837 : 0040941", 
                      "SSF103612 : 0044420", "SSF52980 : 0037212", "SSF56747 : 0043316", 
                      "SSF50729 : 0040942", "SSF53067 : 0052359", "SSF53383 : 0042144", 
                      "PF07749 : ERp29", "SSF56645 : 0043629", "SSF56327 : 0045646", 
                      "SSF48726 : 0045779", "PR00147 : DNAPHOTLYASE", "PD002014 :", 
                      "SSF48726 : 0036053", "PIRSF036432 :", "PF03556 : DUF298", "PIRSF000149 :", 
                      "SSF50814 : 0035497", "SSF53271 : 0042694", "SSF52777 : 0047935", 
                      "PF09180 : ProRS-C_1", "SSF49863 : 0035896", "TIGR00585 : mutl", 
                      "SSF102645 : 0049815", "SSF55961 : 0051032", "SSF54427 : 0046550", 
                      "SSF54098 : 0038829", "SSF51905 : 0037508", "SSF56935 : 0046763", 
                      "PF07496 : zf-CW", "SSF47819 : 0052999", "SSF51735 : 0042307", 
                      "SSF57095 : 0050679", "PF07645 : EGF_CA", "SSF53590 : 0037284", 
                      "PD000535 :", "SSF47473 : 0036390", "PF00071 : Ras", "SSF63748 : 0048573", 
                      "PD454109 :", "PF09773 : Meckelin", "SSF55048 : 0040993", "SSF52743 : 0045424", 
                      "SSF53167 : 0036907", "SSF51735 : 0039378", "SSF51658 : 0038889", 
                      "SSF51604 : 0037592", "SSF51316 : 0038777", "PS50845 : RETICULON", 
                      "SSF88659 : 0039239", "SSF55060 : 0039905", "SSF50249 : 0048748", 
                      "PR01069 : ACCCTRFRASEA", "PF01496 : V_ATPase_I", "SSF53098 : 0052620", 
                      "PF05127 : DUF699", "SSF55200 : 0038931", "PF02538 : Hydantoinase_B", 
                      "SSF47473 : 0035583", "SSF52058 : 0037696", "SSF53067 : 0035799", 
                      "SSF55729 : 0046158", "SSF51621 : 0047364", "PF05351 : GMP_PDE_delta", 
                      "SSF55909 : 0035742", "SSF48726 : 0037878", "SSF56059 : 0044272", 
                      "SSF52317 : 0042273", "SSF51556 : 0051353", "SSF56436 : 0049420", 
                      "SSF51735 : 0047510", "SSF63433 : 0038791", "SSF56091 : 0048677", 
                      "SSF57586 : 0037252", "TIGR01022 : rpmJ_bact", "PF07469 : DUF1518", 
                      "SSF57196 : 0035423", "PF03972 : MmgE_PrpD", "PF05958 : tRNA_U5-meth_tr", 
                      "SSF53795 : 0039345", "SSF53474 : 0040713", "SSF102114 : 0048596", 
                      "SSF47473 : 0038680", "PF08523 : MBF1", "SSF49584 : 0042925", 
                      "SSF53613 : 0044196", "PS51295 : CRM", "SSF49785 : 0050414", 
                      "PIRSF035170 :", "SSF52218 : 0049202", "SSF51905 : 0052964", 
                      "TIGR01327 : PGDH", "SSF49899 : 0051718", "PF03721 : UDPG_MGDP_dh_N", 
                      "SSF55194 : 0036362", "SSF51735 : 0053383", "SSF48613 : 0046404", 
                      "PF08156 : NOP5NT", "PS50948 : PAN", "PR01222 : ATROPHIN", "PF04863 : EGF_alliinase", 
                      "SSF46626 : 0037327", "SSF57535 : 0041599", "PF09279 : efhand_like", 
                      "SSF75471 : 0043344", "SSF56281 : 0051638", "SSF54292 : 0046849", 
                      "SSF53756 : 0046716", "SSF52743 : 0042193", "SSF100897 : 0042086", 
                      "SSF46689 : 0052843", "SSF54593 : 0038510", "SSF47240 : 0049511", 
                      "SSF82615 : 0044451", "SSF51679 : 0049715", "SSF47862 : 0041435", 
                      "SSF57095 : 0042500", "PF09454 : Vps23_core", "SSF54001 : 0035230", 
                      "SSF48726 : 0040567", "SSF57716 : 0052446", "SSF63748 : 0040082", 
                      "SSF88659 : 0043327", "PS51324 : ERV_ALR", "SSF57095 : 0041077", 
                      "SSF64263 : 0038055", "PR00727 : LEADERPTASE", "PIRSF036482 :", 
                      "SSF55931 : 0042822", "PIRSF004976 :", "SSF55979 : 0043400", 
                      "SSF109604 : 0051140", "SSF48113 : 0035542", "SSF46689 : 0038474", 
                      "SSF54495 : 0042708", "TIGR01378 : thi_PPkinase", "PIRSF017479 :", 
                      "SSF56436 : 0043202", "SSF48239 : 0053306", "SSF50494 : 0035974", 
                      "SSF47794 : 0051237", "SSF54495 : 0035854", "PF02430 : AMA-1", 
                      "SSF47113 : 0047904", "SSF56176 : 0050017", "SSF50630 : 0043898", 
                      "SSF47616 : 0042259", "SSF52518 : 0051270", "PF02594 : DUF167", 
                      "PF07910 : Peptidase_C78", "SSF48403 : 0048640", "SSF57552 : 0045254", 
                      "SSF57059 : 0047999", "SSF55221 : 0040283", "SSF51735 : 0047550", 
                      "PR00116 : ARGINASE", "PD005043 :", "PF04699 : P16-Arc", "PF00773 : RNB", 
                      "SSF63848 : 0038569", "SSF52317 : 0039988", "SSF55831 : 0045478", 
                      "SSF47874 : 0035227", "PF08409 : DUF1736", "SSF53474 : 0046718", 
                      "SSF53850 : 0045863", "SSF50104 : 0045975", "SSF56994 : 0034928", 
                      "SSF54928 : 0050838", "SSF54919 : 0038633", "PF02263 : GBP", 
                      "SSF48371 : 0046912", "PD000518 :", "PF08375 : Rpn3_C", "SSF54117 : 0036523", 
                      "SSF53901 : 0035032", "SSF50993 : 0053044", "PD016638 :", "PS51278 : GATASE_TYPE_2", 
                      "PIRSF017209 :", "SSF81464 : 0037558", "SSF51430 : 0039515", 
                      "SSF52096 : 0051137", "SSF47699 : 0043504", "SSF54452 : 0036973", 
                      "PF02145 : Rap_GAP", "SSF53686 : 0050098", "SSF53474 : 0048053", 
                      "PD397608 :", "SSF51556 : 0040835", "SSF55550 : 0048234", "SSF56059 : 0038909", 
                      "SSF52540 : 0046936", "SSF53474 : 0047764", "SSF52540 : 0038781", 
                      "SSF51984 : 0039391", "PS51385 : YJEF_N", "PF03702 : UPF0075", 
                      "SSF51726 : 0044494", "TIGR00590 : pcna", "SSF51430 : 0041838", 
                      "SSF50044 : 0045329", "SSF50044 : 0039357", "SSF52317 : 0038211", 
                      "SSF56601 : 0045020", "PF01249 : Ribosomal_S21e", "SSF50156 : 0043230", 
                      "SSF100934 : 0049750", "SSF50486 : 0037670", "SSF100895 : 0042251", 
                      "SSF54495 : 0052733", "SSF53901 : 0042744", "SSF46626 : 0034880", 
                      "SSF55811 : 0044826", "SSF51445 : 0044469", "SSF55681 : 0051519", 
                      "PD038129 :", "SSF110836 : 0042426", "PF05192 : MutS_III", "TIGR00431 : TruB", 
                      "SSF52518 : 0040412", "PF01988 : DUF125", "SSF52374 : 0044335", 
                      "SSF52440 : 0034969", "PF00805 : Pentapeptide", "SSF51905 : 0046274", 
                      "PIRSF005639 :", "SSF49265 : 0037675", "SSF81271 : 0041401", 
                      "SSF48695 : 0041763", "PF08542 : Rep_fac_C", "SSF57802 : 0046415", 
                      "PD311402 :", "SSF81878 : 0040952", "SSF56219 : 0052475", "PIRSF006485 :", 
                      "SSF55387 : 0037054", "SSF54452 : 0042428", "SSF52540 : 0050741", 
                      "PS51198 : UVRD_HELICASE_ATP_BIND", "SSF56349 : 0043356", "SSF50814 : 0037221", 
                      "SSF50249 : 0037112", "PF04132 : Vps36", "SSF56784 : 0037046", 
                      "SSF53850 : 0043782", "PF08338 : DUF1731", "SSF52540 : 0051580", 
                      "SSF53474 : 0037216", "SSF52540 : 0038141", "SSF54928 : 0047172", 
                      "SSF51730 : 0039953", "SSF55909 : 0044954", "PD009796 :", "SSF101912 : 0041916", 
                      "SSF50249 : 0045898", "SSF46894 : 0042155", "SSF47090 : 0043654", 
                      "SSF51735 : 0043675", "SSF48619 : 0042848", "SSF57716 : 0044030", 
                      "SSF75005 : 0050644", "SSF56399 : 0049098", "PR00228 : GEMCOATCLVL1", 
                      "SSF54928 : 0046287", "SSF47175 : 0038226", "SSF51395 : 0042445", 
                      "SSF47781 : 0050778", "PF05084 : GRA6", "PF05021 : NPL4", "SSF51215 : 0045163", 
                      "PD138041 :", "SSF52440 : 0044433", "PS50913 : GRIP", "SSF57716 : 0049092", 
                      "SSF56300 : 0053225", "SSF49401 : 0042997", "SSF52029 : 0049414", 
                      "SSF56574 : 0034927", "SSF52317 : 0042648", "SSF55486 : 0035790", 
                      "SSF48726 : 0045914", "SSF50494 : 0037635", "SSF50447 : 0036237", 
                      "SSF49401 : 0035111", "SSF55103 : 0044930", "SSF52954 : 0052834", 
                      "PR00411 : PNDRDTASEI", "SSF47616 : 0041907", "SSF46626 : 0042837", 
                      "SSF103243 : 0044628", "SSF57196 : 0046901", "PIRSF002290 :", 
                      "SSF54984 : 0038105", "SSF55729 : 0045388", "SSF56826 : 0037715", 
                      "SSF51649 : 0038069", "SSF63451 : 0039505", "PF03966 : Trm112p", 
                      "PF04128 : Psf2", "PF06842 : DUF1242", "SSF52833 : 0049544", 
                      "SSF57603 : 0037480", "SSF54919 : 0037011", "SSF53300 : 0048276", 
                      "SSF54495 : 0052596", "SSF54452 : 0039524", "SSF54495 : 0045484", 
                      "SSF54495 : 0045844", "SSF51316 : 0040349", "TIGR01462 : greA", 
                      "SSF54909 : 0049187", "SSF47266 : 0040618", "SSF48726 : 0048595", 
                      "SSF49785 : 0039546", "PD036412 :", "SSF89095 : 0041377", "SSF54975 : 0038321", 
                      "SSF48403 : 0041145", "SSF47648 : 0041663", "SSF50494 : 0040145", 
                      "SSF53187 : 0044755", "SSF50249 : 0048839", "SSF52210 : 0046630", 
                      "SSF46458 : 0037501", "SSF50104 : 0037545", "SSF51604 : 0043385", 
                      "SSF53597 : 0047835", "PF08640 : U3_assoc_6", "PR01046 : TRNASYNTHPRO", 
                      "SSF51182 : 0037594", "SSF47895 : 0035280", "PD312896 :", "PS50151 : UVR", 
                      "PR00363 : CYTOCHROMEB5", "SSF46458 : 0043550", "SSF111423 : 0043231", 
                      "PF00804 : Syntaxin", "SSF51011 : 0043811", "SSF63380 : 0053271", 
                      "SSF81296 : 0039079", "SSF53254 : 0039931", "SSF54593 : 0049434", 
                      "PF02137 : A_deamin", "SSF69635 : 0049694", "SSF57095 : 0050259", 
                      "PF03083 : MtN3_slv", "TIGR00061 : L21", "PF03367 : zf-ZPR1", 
                      "SSF55347 : 0035946", "SSF51011 : 0052375", "SSF50475 : 0044860", 
                      "SSF49899 : 0042870", "PF02685 : Glucokinase", "SSF52540 : 0046869", 
                      "PF09335 : SNARE_assoc", "SSF56091 : 0042115", "PF02737 : 3HCDH_N", 
                      "SSF56349 : 0045588", "PF05731 : TROVE", "PIRSF005413 :", "PF02953 : zf-Tim10_DDP", 
                      "PF01899 : MNHE", "SSF53067 : 0035530", "SSF57196 : 0043221", 
                      "SSF57095 : 0038217", "SSF51905 : 0036016", "SSF47336 : 0040143", 
                      "SSF57667 : 0045118", "SSF54292 : 0048556", "PF01725 : Ham1p_like", 
                      "SSF89447 : 0041166", "TIGR00232 : tktlase_bact", "SSF51206 : 0043227", 
                      "PR00942 : CUATPASEI", "SSF51351 : 0044100", "SSF46785 : 0047247", 
                      "PS50261 : G_PROTEIN_RECEP_F2_4", "PF04886 : PT", "SSF49373 : 0037302", 
                      "SSF50998 : 0037647", "SSF54236 : 0043486", "SSF55154 : 0051744", 
                      "SSF51905 : 0052911", "PF00735 : Septin", "SSF46915 : 0036737", 
                      "SSF49503 : 0037170", "SSF50814 : 0038514", "PF04452 : DUF558", 
                      "SSF52540 : 0036244", "SSF63748 : 0048268", "SSF50044 : 0044124", 
                      "SSF88946 : 0039240", "PF08059 : SEP", "SSF49265 : 0034836", 
                      "SSF47699 : 0047269", "SSF51126 : 0036209", "PF01465 : GRIP", 
                      "SSF53901 : 0044182", "PF01566 : Nramp", "SSF51395 : 0047996", 
                      "SSF57362 : 0037468", "SSF100879 : 0039801", "SSF51735 : 0046725", 
                      "PF04130 : Spc97_Spc98", "PF03693 : RHH_2", "SSF48726 : 0049177", 
                      "SSF51197 : 0036573", "SSF54826 : 0050712", "PF09822 : ABC_transp_aux", 
                      "SSF52980 : 0048532", "PF10507 : DUF2453", "SSF50249 : 0042114", 
                      "SSF56112 : 0044407", "SSF50978 : 0049440", "PS51318 : TAT", 
                      "SSF103575 : 0043621", "TIGR03376 : glycerol3P_DH", "PS50021 : CH", 
                      "SSF50630 : 0048051", "SSF55469 : 0044848", "SSF53098 : 0050668", 
                      "PR01658 : MCMPROTEIN2", "SSF55781 : 0037396", "SSF55620 : 0043125", 
                      "PS50052 : GUANYLATE_KINASE_2", "SSF51419 : 0050171", "SSF48239 : 0046298", 
                      "SSF48726 : 0038807", "SSF81296 : 0038186", "PS50975 : ATP_GRASP", 
                      "SSF51621 : 0048777", "PF05667 : DUF812", "SSF47446 : 0036607", 
                      "SSF52540 : 0047291", "SSF102735 : 0042216", "PS51375 : PPR", 
                      "PF01875 : Memo", "PR00882 : RIBOSOMALL7A", "SSF50044 : 0036029", 
                      "SSF49899 : 0040663", "SSF54001 : 0036111", "SSF50129 : 0044967", 
                      "SSF47769 : 0049490", "SSF54452 : 0047577", "PIRSF500136 :", 
                      "SSF55831 : 0035996", "SSF47473 : 0043360", "SSF56821 : 0043379", 
                      "SSF52317 : 0050138", "SSF88633 : 0037354", "TIGR00163 : PS_decarb", 
                      "PF08613 : Cyclin", "SSF47789 : 0036524", "TIGR00243 : Dxr", 
                      "SSF56837 : 0036000", "SSF102848 : 0049459", "SSF53067 : 0051805", 
                      "SSF82679 : 0040733", "SSF56601 : 0046014", "SSF50203 : 0043119", 
                      "SSF54452 : 0036715", "SSF109770 : 0042548", "SSF68906 : 0051160", 
                      "SSF57095 : 0048871", "SSF49401 : 0048526", "SSF55021 : 0048893", 
                      "SSF56235 : 0047426", "SSF54277 : 0036262", "SSF54919 : 0046562", 
                      "SSF56854 : 0051740", "SSF102735 : 0043831", "SSF57603 : 0037481", 
                      "PF02254 : TrkA_N", "PF02777 : Sod_Fe_C", "SSF53335 : 0045060", 
                      "SSF55729 : 0041331", "SSF47473 : 0036425", "PD006217 :", "SSF52799 : 0051299", 
                      "PIRSF000722 :", "SSF48300 : 0036360", "SSF53448 : 0038003", 
                      "SSF52833 : 0050033", "SSF50494 : 0043596", "SSF56327 : 0047964", 
                      "SSF53474 : 0036643", "SSF46785 : 0046837", "SSF55424 : 0040690", 
                      "PS51158 : ALPHA_KINASE", "SSF49503 : 0040028", "SSF64288 : 0037809", 
                      "SSF55455 : 0041015", "SSF46977 : 0039663", "SSF53933 : 0043224", 
                      "SSF47807 : 0049934", "SSF53335 : 0051588", "PF02230 : Abhydrolase_2", 
                      "SSF54768 : 0036436", "SSF54909 : 0049703", "PR01050 : PYRUVTKNASE", 
                      "SSF55846 : 0051276", "SSF57667 : 0052466", "SSF57850 : 0035982", 
                      "PS50942 : ENTH", "SSF54292 : 0035261", "SSF55486 : 0046234", 
                      "TIGR00952 : S15_bact", "PS51163 : YRDC", "SSF51197 : 0041871", 
                      "SSF47240 : 0052941", "SSF64182 : 0038902", "SSF51011 : 0043015", 
                      "SSF52799 : 0045450", "SSF50249 : 0039293", "TIGR00002 : S16", 
                      "SSF56784 : 0043288", "PD028462 :", "SSF50447 : 0043131", "SSF54197 : 0051185", 
                      "SSF47616 : 0036791", "SSF48498 : 0044377", "SSF52980 : 0039325", 
                      "TIGR00036 : dapB", "SSF53383 : 0037569", "SSF52540 : 0047538", 
                      "SSF53067 : 0052752", "PF00316 : FBPase", "SSF75399 : 0040556", 
                      "TIGR00614 : recQ_fam", "PF09261 : Alpha-mann_mid", "SSF53633 : 0045891", 
                      "SSF53933 : 0038822", "SSF53383 : 0048074", "SSF48113 : 0042217", 
                      "SSF46689 : 0034910", "SSF64268 : 0051101", "SSF49265 : 0044269", 
                      "SSF57850 : 0050087", "SSF53335 : 0042197", "PD002667 :", "SSF49899 : 0045493", 
                      "SSF55909 : 0051350", "SSF48726 : 0046784", "PS50842 : EXPANSIN_EG45", 
                      "SSF52210 : 0053298", "PF01144 : CoA_trans", "SSF47240 : 0045278", 
                      "SSF109998 : 0043830", "SSF52113 : 0039090", "SSF90193 : 0042228", 
                      "SSF50118 : 0040730", "SSF103263 : 0043127", "SSF52016 : 0053017", 
                      "PR00077 : GPDHDRGNASE", "SSF88633 : 0041954", "SSF74924 : 0050555", 
                      "SSF49863 : 0039309", "SSF49503 : 0045766", "SSF50729 : 0037709", 
                      "SSF48619 : 0048119", "SSF52540 : 0049073", "PF00382 : TFIIB", 
                      "PF05683 : Fumerase_C", "SSF47923 : 0046806", "SSF56436 : 0047401", 
                      "SSF55021 : 0051654", "SSF48726 : 0047818", "SSF55681 : 0036712", 
                      "TIGR01828 : pyru_phos_dikin", "SSF50044 : 0035244", "PF00066 : Notch", 
                      "SSF48350 : 0042243", "SSF52540 : 0047406", "SSF51905 : 0040689", 
                      "SSF69500 : 0043938", "SSF57667 : 0050630", "SSF52540 : 0046826", 
                      "SSF52518 : 0042762", "SSF56672 : 0049138", "SSF49503 : 0042227", 
                      "TIGR01044 : rplV_bact", "SSF50129 : 0043968", "SSF54373 : 0048495", 
                      "PF00552 : Integrase", "SSF69721 : 0039563", "SSF52218 : 0045773", 
                      "PF00485 : PRK", "SSF55979 : 0044283", "SSF52091 : 0038420", 
                      "SSF56399 : 0044021", "SSF47823 : 0034814", "PF05064 : Nsp1_C", 
                      "SSF55729 : 0051252", "SSF53383 : 0042806", "SSF57302 : 0052986", 
                      "SSF54862 : 0037829", "SSF57667 : 0052460", "SSF55753 : 0036224", 
                      "PD004918 :", "SSF56436 : 0044411", "SSF52218 : 0051820", "SSF54637 : 0047497", 
                      "SSF54001 : 0038066", "SSF51011 : 0036428", "SSF56194 : 0038703", 
                      "SSF52833 : 0047714", "SSF57429 : 0035557", "PF00641 : zf-RanBP", 
                      "PF01227 : GTP_cyclohydroI", "PF01694 : Rhomboid", "SSF50249 : 0044179", 
                      "SSF111331 : 0043771", "PF00196 : GerE", "PF03121 : Herpes_UL52", 
                      "SSF49503 : 0040037", "SSF47473 : 0046215", "SSF53167 : 0039888", 
                      "SSF53822 : 0043335", "SSF63411 : 0045926", "SSF53800 : 0046373", 
                      "SSF51569 : 0046628", "SSF56801 : 0040451", "SSF54593 : 0038509", 
                      "PF08246 : Inhibitor_I29", "SSF46977 : 0040048", "PIRSF037536 :", 
                      "SSF47266 : 0044873", "PIRSF037096 :", "PIRSF005572 :", "PF00410 : Ribosomal_S8", 
                      "SSF55831 : 0043052", "SSF53597 : 0046319", "SSF54791 : 0052298", 
                      "SSF63862 : 0039001", "SSF52540 : 0036699", "SSF53790 : 0049314", 
                      "SSF81296 : 0049329", "PF10607 : RanBPM_CRA", "SSF52467 : 0052102", 
                      "SSF46689 : 0035379", "SSF54928 : 0045747", "SSF50182 : 0046263", 
                      "PF01437 : PSI", "SSF52540 : 0037977", "PIRSF017228 :", "SSF49503 : 0046038", 
                      "SSF81778 : 0039312", "SSF49785 : 0047789", "SSF55550 : 0045209", 
                      "PIRSF000375 :", "SSF48613 : 0043199", "PF02270 : TFIIF_beta", 
                      "SSF52210 : 0041869", "SSF56219 : 0050312", "PS50056 : TYR_PHOSPHATASE_2", 
                      "SSF53335 : 0052807", "PD001248 :", "SSF52799 : 0049260", "PD143259 :", 
                      "PD338624 :", "TIGR00641 : acid_CoA_mut_N", "SSF53927 : 0051897", 
                      "SSF53098 : 0047446", "SSF52540 : 0052528", "SSF50044 : 0041338", 
                      "SSF51735 : 0045516", "PF01294 : Ribosomal_L13e", "SSF50129 : 0046449", 
                      "SSF49354 : 0043323", "SSF49452 : 0036004", "SSF50129 : 0050202", 
                      "SSF51645 : 0046280", "SSF46934 : 0052204", "SSF47240 : 0041194", 
                      "SSF47266 : 0038637", "SSF52540 : 0047813", "TIGR00109 : hemH", 
                      "SSF57016 : 0037003", "PF08777 : RRM_3", "SSF55979 : 0036207", 
                      "SSF56770 : 0037747", "SSF52317 : 0051730", "SSF88633 : 0044053", 
                      "PF04841 : Vps16_N", "SSF48208 : 0040477", "SSF47240 : 0041475", 
                      "SSF51294 : 0035098", "SSF50044 : 0049900", "PF01536 : SAM_decarbox", 
                      "SSF47616 : 0039615", "SSF46626 : 0045102", "SSF47473 : 0035206", 
                      "SSF49417 : 0046997", "SSF53098 : 0037052", "PF09810 : Morph_protein1", 
                      "SSF46785 : 0048861", "PF07540 : NOC3p", "SSF74650 : 0051490", 
                      "SSF102110 : 0043018", "SSF48113 : 0037585", "SSF50630 : 0035099", 
                      "SSF53244 : 0038083", "SSF57027 : 0046692", "SSF50249 : 0038296", 
                      "SSF50044 : 0047642", "SSF46785 : 0050608", "SSF48600 : 0052958", 
                      "SSF48452 : 0046583", "SSF88946 : 0043626", "SSF46785 : 0047587", 
                      "PF01474 : DAHP_synth_2", "SSF56349 : 0034815", "SSF54862 : 0038470", 
                      "SSF81296 : 0038445", "PR01246 : RAD1REPAIR", "SSF53335 : 0039078", 
                      "SSF56420 : 0040557", "PD005145 :", "SSF46609 : 0042185", "SSF57440 : 0039525", 
                      "TIGR01495 : ETRAMP", "SSF50814 : 0039047", "PD015767 :", "SSF54791 : 0046515", 
                      "SSF57716 : 0035409", "SSF54111 : 0045608", "SSF56784 : 0043919", 
                      "PF00994 : MoCF_biosynth", "SSF52166 : 0037531", "PF01167 : Tub", 
                      "SSF55811 : 0051867", "PF01537 : Herpes_glycop_D", "SSF53790 : 0042343", 
                      "SSF48726 : 0053223", "SSF49503 : 0035015", "SSF57095 : 0035605", 
                      "SSF47113 : 0037140", "SSF55681 : 0046922", "SSF52242 : 0035625", 
                      "SSF54452 : 0045486", "SSF52440 : 0046456", "TIGR01065 : hlyIII", 
                      "SSF54928 : 0049843", "TIGR01313 : therm_gnt_kin", "SSF56436 : 0040181", 
                      "SSF81296 : 0036923", "SSF89623 : 0041667", "SSF49265 : 0045360", 
                      "SSF51621 : 0047777", "PF09591 : DUF2463", "SSF54928 : 0050805", 
                      "SSF51735 : 0036825", "SSF53383 : 0046255", "SSF51011 : 0051480", 
                      "PR01218 : PSTLEXTENSIN", "PF04062 : P21-Arc", "SSF51998 : 0040352", 
                      "SSF50353 : 0046816", "SSF47266 : 0035247", "SSF51905 : 0041021", 
                      "PF08312 : cwf21", "PR01039 : TRNASYNTHTRP", "SSF52833 : 0047062", 
                      "SSF52172 : 0046428", "SSF46966 : 0045457", "SSF52218 : 0037783", 
                      "SSF55979 : 0050271", "SSF55545 : 0048405", "PF09280 : XPC-binding", 
                      "SSF50729 : 0050571", "SSF57716 : 0037929", "SSF46906 : 0049332", 
                      "SSF57716 : 0052403", "PD040985 :", "SSF55405 : 0037750", "SSF54593 : 0042805", 
                      "SSF48695 : 0034794", "TIGR01241 : FtsH_fam", "PS51016 : MYTH4", 
                      "PR00334 : KININOGEN", "SSF51905 : 0040603", "PS51050 : ZF_CW", 
                      "SSF48726 : 0053038", "SSF52540 : 0036857", "SSF51445 : 0035555", 
                      "PF02780 : Transketolase_C", "SSF53474 : 0046410", "SSF46997 : 0051118", 
                      "SSF51735 : 0041136", "PIRSF018425 :", "SSF53697 : 0038951", 
                      "SSF47769 : 0035672", "SSF52540 : 0041400", "SSF54211 : 0037619", 
                      "PF00235 : Profilin", "SSF103486 : 0044678", "SSF54791 : 0036586", 
                      "SSF47113 : 0043924", "SSF48403 : 0043783", "PF05992 : SbmA_BacA", 
                      "SSF52058 : 0046830", "SSF50475 : 0041528", "SSF49384 : 0037927", 
                      "SSF48464 : 0040934", "SSF47943 : 0037085", "SSF57095 : 0047973", 
                      "SSF55979 : 0050273", "SSF52129 : 0042978", "SSF56327 : 0038785", 
                      "SSF57247 : 0047111", "SSF48726 : 0038834", "PR01463 : EAGCHANLFMLY", 
                      "PF04053 : Coatomer_WDAD", "SSF48508 : 0036330", "SSF47473 : 0039974", 
                      "SSF47220 : 0043749", "SSF52440 : 0038242", "SSF57095 : 0043091", 
                      "SSF50249 : 0041615", "TIGR02176 : pyruv_ox_red", "SSF49401 : 0041752", 
                      "SSF48498 : 0043843", "SSF50044 : 0043699", "TIGR01409 : TAT_signal_seq", 
                      "SSF48403 : 0048259", "SSF52777 : 0047936", "SSF54098 : 0051150", 
                      "SSF52540 : 0047607", "SSF55666 : 0036742", "PF00730 : HhH-GPD", 
                      "SSF54160 : 0052599", "SSF50998 : 0037966", "SSF50998 : 0046933", 
                      "SSF52218 : 0043885", "SSF55979 : 0042371", "SSF50956 : 0048794", 
                      "SSF51419 : 0036297", "SSF53686 : 0040135", "SSF56601 : 0042864", 
                      "TIGR01016 : sucCoAbeta", "PR00328 : SAR1GTPBP", "SSF88633 : 0049018", 
                      "SSF53335 : 0052949", "SSF53223 : 0035734", "SSF55729 : 0044327", 
                      "SSF51338 : 0040833", "SSF53098 : 0035802", "SSF51161 : 0047206", 
                      "PF03378 : CAS_CSE1", "SSF55347 : 0044188", "PF00278 : Orn_DAP_Arg_deC", 
                      "SSF56327 : 0047277", "SSF52540 : 0048047", "SSF51569 : 0043726", 
                      "SSF56300 : 0043527", "SSF69336 : 0040552", "PR00973 : RIBOSOMALS17", 
                      "PIRSF001773 :", "SSF49503 : 0048457", "SSF51569 : 0049382", 
                      "SSF52922 : 0039060", "SSF47986 : 0050544", "SSF54076 : 0034782", 
                      "SSF50692 : 0044012", "PR00447 : NATRESASSCMP", "PF04874 : Mak16", 
                      "SSF48056 : 0040577", "PF05187 : ETF_QO", "SSF51445 : 0042911", 
                      "SSF54236 : 0046537", "PF05175 : MTS", "SSF51126 : 0045962", 
                      "SSF52980 : 0038067", "SSF100897 : 0035935", "SSF51391 : 0045471", 
                      "SSF52518 : 0042411", "SSF57774 : 0048690", "SSF109604 : 0053263", 
                      "SSF50156 : 0049780", "SSF50939 : 0048217", "SSF54495 : 0039447", 
                      "SSF53671 : 0045167", "SSF52833 : 0047472", "PR00079 : G6PDHDRGNASE", 
                      "SSF49899 : 0039065", "SSF52821 : 0038810", "SSF54211 : 0040104", 
                      "SSF46557 : 0047044", "PF01331 : mRNA_cap_enzyme", "SSF52402 : 0046546", 
                      "PS50290 : PI3_4_KINASE_3", "SSF52374 : 0046569", "SSF50182 : 0047557", 
                      "SSF47592 : 0044600", "SSF51621 : 0036564", "PD010562 :", "SSF57552 : 0042646", 
                      "SSF46458 : 0044268", "SSF51445 : 0039528", "PF01625 : PMSR", 
                      "SSF57667 : 0044259", "PF03602 : Cons_hypoth95", "PIRSF000530 :", 
                      "SSF53822 : 0044040", "SSF51445 : 0035980", "SSF54768 : 0051935", 
                      "SSF55681 : 0049183", "SSF54189 : 0051435", "PF05063 : MT-A70", 
                      "SSF54001 : 0039241", "SSF49879 : 0043024", "PF10595 : UPF0564", 
                      "SSF49303 : 0036532", "SSF50346 : 0036658", "SSF64586 : 0041425", 
                      "SSF56655 : 0035592", "SSF53850 : 0044496", "SSF53187 : 0036381", 
                      "SSF52833 : 0048529", "TIGR02350 : prok_dnaK", "PF00042 : Globin", 
                      "SSF50891 : 0042900", "PF05965 : FYRC", "SSF47240 : 0039567", 
                      "SSF53335 : 0049474", "PS50066 : MADS_BOX_2", "SSF52402 : 0047632", 
                      "SSF53383 : 0050977", "SSF57667 : 0051749", "SSF56371 : 0035936", 
                      "SSF54292 : 0043858", "SSF81296 : 0042792", "SSF53955 : 0042765", 
                      "SSF57095 : 0048069", "SSF56645 : 0035714", "SSF64005 : 0037424", 
                      "SSF49785 : 0050018", "SSF51445 : 0053049", "SSF50249 : 0044302", 
                      "PF01388 : ARID", "SSF55785 : 0040536", "SSF56235 : 0037916", 
                      "SSF49417 : 0044112", "TIGR01893 : aa-his-dipept", "SSF53098 : 0038606", 
                      "SSF50729 : 0051073", "SSF51445 : 0037464", "SSF52540 : 0046697", 
                      "SSF57850 : 0050318", "PR00342 : RHESUSRHD", "PIRSF000868 :", 
                      "SSF52009 : 0050126", "SSF57288 : 0040981", "SSF63763 : 0044332", 
                      "SSF54826 : 0037593", "PF02284 : COX5A", "SSF53686 : 0048837", 
                      "PF02933 : CDC48_2", "SSF51621 : 0047484", "SSF47370 : 0037134", 
                      "SSF57535 : 0041891", "SSF51735 : 0041768", "SSF88633 : 0048795", 
                      "TIGR00533 : HMG_CoA_R_NADP", "PF10598 : RRM_4", "SSF63491 : 0049563", 
                      "SSF50249 : 0040136", "TIGR01472 : gmd", "SSF54928 : 0052232", 
                      "SSF53328 : 0052063", "SSF55550 : 0034802", "SSF47473 : 0050649", 
                      "SSF51735 : 0052116", "PF01900 : RNase_P_Rpp14", "TIGR01383 : not_thiJ", 
                      "PS51060 : PARP_ALPHA_HD", "PF08063 : PADR1", "SSF55239 : 0039143", 
                      "SSF57362 : 0035678", "PF03377 : Avirulence", "SSF54495 : 0044489", 
                      "SSF50022 : 0037293", "TIGR00293 : TIGR00293", "SSF50882 : 0041854", 
                      "SSF55267 : 0043079", "SSF55073 : 0045849", "SSF51246 : 0047171", 
                      "SSF50331 : 0037899", "PR01801 : SURFCEANTIGN", "PF03155 : Alg6_Alg8", 
                      "PF03733 : DUF307", "SSF56091 : 0046164", "PS51161 : ATP_CONE", 
                      "SSF55550 : 0052267", "SSF51419 : 0045647", "SSF46785 : 0035419", 
                      "SSF101386 : 0051216", "SSF63380 : 0038291", "SSF53271 : 0041687", 
                      "SSF57095 : 0035594", "PF07994 : NAD_binding_5", "TIGR00027 : mthyl_TIGR00027", 
                      "PF10576 : EndIII_4Fe-2S", "SSF53187 : 0050176", "PR00472 : CASNKINASEII", 
                      "TIGR00195 : exoDNase_III", "PR00747 : GLYHDRLASE47", "SSF81296 : 0052434", 
                      "SSF46785 : 0051507", "PIRSF036363 :", "SSF53474 : 0044016", 
                      "SSF51269 : 0038585", "SSF55331 : 0044228", "SSF54358 : 0040079", 
                      "PR00474 : GLU5KINASE", "SSF54236 : 0043295", "SSF57774 : 0049307", 
                      "SSF55620 : 0049106", "SSF51126 : 0036321", "SSF48081 : 0041061", 
                      "SSF46609 : 0041013", "SSF53474 : 0044560", "SSF50998 : 0046808", 
                      "SSF53223 : 0035811", "SSF82649 : 0042614", "SSF46458 : 0045566", 
                      "PF01509 : TruB_N", "SSF55753 : 0044994", "PS50892 : V_SNARE", 
                      "PF00986 : DNA_gyraseB_C", "PF10367 : Vps39_2", "SSF53756 : 0037311", 
                      "SSF51735 : 0035759", "PS50994 : INTEGRASE", "SSF64518 : 0039099", 
                      "SSF47459 : 0041452", "SSF57783 : 0046355", "SSF51569 : 0049247", 
                      "SSF100934 : 0036477", "SSF54648 : 0036064", "SSF63411 : 0035448", 
                      "SSF57440 : 0036829", "SSF53187 : 0051343", "PS50020 : WW_DOMAIN_2", 
                      "SSF50203 : 0044022", "SSF50475 : 0049738", "PF03302 : VSP", 
                      "SSF55846 : 0051969", "SSF52374 : 0046259", "SSF51087 : 0042151", 
                      "SSF49899 : 0049350", "PD020235 :", "SSF53067 : 0045000", "PF00569 : ZZ", 
                      "SSF54631 : 0039484", "SSF88697 : 0051555", "SSF53067 : 0035722", 
                      "SSF46458 : 0036493", "SSF100950 : 0040524", "SSF50965 : 0047741", 
                      "SSF48619 : 0042413", "SSF52540 : 0037180", "SSF55347 : 0044839", 
                      "SSF48726 : 0041298", "PF02891 : zf-MIZ", "TIGR00683 : nanA", 
                      "SSF47220 : 0051871", "SSF49899 : 0046605", "SSF57095 : 0046080", 
                      "SSF48726 : 0046531", "SSF55486 : 0049107", "SSF53335 : 0051930", 
                      "SSF50923 : 0047257", "SSF54984 : 0046985", "SSF48201 : 0044519", 
                      "SSF47616 : 0035345", "SSF52374 : 0042947", "PS51279 : BCNT_C", 
                      "SSF51905 : 0039503", "SSF54236 : 0050524", "TIGR01203 : HGPRTase", 
                      "SSF109709 : 0044919", "SSF53300 : 0039512", "SSF53474 : 0038343", 
                      "SSF52954 : 0038521", "SSF51645 : 0036304", "SSF47226 : 0051674", 
                      "SSF54098 : 0051106", "SSF54403 : 0048202", "SSF55550 : 0039762", 
                      "SSF51395 : 0051899", "PIRSF000889 :", "SSF53474 : 0039229", 
                      "SSF49870 : 0035208", "PF01454 : MAGE", "SSF50129 : 0047846", 
                      "SSF53383 : 0050157", "SSF53955 : 0038595", "PF02163 : Peptidase_M50", 
                      "SSF63411 : 0048874", "SSF54980 : 0052324", "SSF53271 : 0036476", 
                      "SSF51445 : 0051153", "PS51266 : ZF_CHY", "SSF63748 : 0041865", 
                      "SSF48508 : 0039946", "SSF46689 : 0051803", "SSF53448 : 0050387", 
                      "SSF46548 : 0041343", "PF10258 : RNA_GG_bind", "SSF53067 : 0052360", 
                      "SSF47986 : 0042393", "SSF56784 : 0049814", "SSF46785 : 0049520", 
                      "PIRSF025023 :", "SSF52402 : 0048172", "SSF52833 : 0052322", 
                      "SSF50729 : 0038905", "SSF81593 : 0050699", "SSF54862 : 0039666", 
                      "SSF55961 : 0036983", "SSF46579 : 0037832", "SSF54713 : 0036967", 
                      "SSF57038 : 0049088", "SSF55770 : 0053324", "SSF56436 : 0049354", 
                      "SSF55469 : 0051924", "SSF56988 : 0034993", "SSF53223 : 0041638", 
                      "SSF54001 : 0048933", "SSF53850 : 0036527", "SSF55846 : 0052137", 
                      "PF05022 : SRP40_C", "SSF56059 : 0044852", "TIGR00214 : lipB", 
                      "SSF57196 : 0035159", "PR00100 : AOTCASE", "PF01833 : TIG", "SSF51445 : 0044497", 
                      "SSF46785 : 0039091", "SSF81296 : 0034795", "PD002183 :", "PF05889 : SLA_LP_auto_ag", 
                      "SSF51735 : 0051925", "SSF47616 : 0040989", "SSF50044 : 0036794", 
                      "PF00246 : Peptidase_M14", "SSF51269 : 0045560", "SSF47266 : 0041187", 
                      "SSF47370 : 0037133", "PF01251 : Ribosomal_S7e", "PF00642 : zf-CCCH", 
                      "PD036218 :", "SSF52833 : 0048812", "SSF47175 : 0045734", "SSF51735 : 0047909", 
                      "SSF81296 : 0048589", "PF07159 : DUF1394", "SSF56731 : 0041573", 
                      "SSF49758 : 0036391", "SSF53800 : 0038689", "SSF47789 : 0051484", 
                      "PF03247 : Prothymosin", "SSF52743 : 0049659", "SSF50249 : 0047483", 
                      "SSF51556 : 0052371", "SSF46785 : 0045283", "PS51180 : BRO1", 
                      "SSF57059 : 0038747", "SSF50044 : 0047819", "SSF52540 : 0052546", 
                      "SSF52833 : 0044619", "SSF46785 : 0044208", "PF05743 : UEV", 
                      "PF07883 : Cupin_2", "SSF53300 : 0035144", "SSF52540 : 0040237", 
                      "SSF81296 : 0049897", "PF02585 : PIG-L", "PD012969 :", "SSF53335 : 0049719", 
                      "SSF47473 : 0047425", "SSF56634 : 0036413", "SSF88723 : 0045055", 
                      "SSF48239 : 0042933", "SSF49313 : 0041711", "SSF52540 : 0040687", 
                      "SSF51905 : 0047712", "PF05008 : V-SNARE", "SSF55961 : 0036690", 
                      "TIGR00837 : araaP", "SSF88713 : 0047723", "SSF52540 : 0051116", 
                      "SSF56219 : 0047330", "SSF49265 : 0052262", "SSF56235 : 0039165", 
                      "SSF56112 : 0041927", "SSF53474 : 0036639", "SSF47473 : 0053193", 
                      "SSF53335 : 0036480", "SSF64356 : 0038479", "SSF53335 : 0043711", 
                      "PF05914 : RIB43A", "SSF47473 : 0036627", "SSF49265 : 0035962", 
                      "PR00387 : PDIESTERASE1", "SSF54285 : 0044662", "SSF47336 : 0037430", 
                      "SSF54111 : 0036861", "SSF51905 : 0047270", "SSF49265 : 0052311", 
                      "PF01556 : DnaJ_C", "PF01743 : PolyA_pol", "SSF57424 : 0041241", 
                      "PD001202 :", "SSF52833 : 0044142", "PF10236 : DAP3", "SSF49695 : 0041900", 
                      "SSF52317 : 0046884", "SSF56003 : 0041227", "SSF53328 : 0043482", 
                      "SSF55347 : 0039920", "SSF53067 : 0047559", "SSF64076 : 0052700", 
                      "SSF53474 : 0043166", "SSF51649 : 0053361", "SSF51569 : 0036432", 
                      "SSF49899 : 0046424", "SSF81296 : 0036003", "SSF51735 : 0053266", 
                      "SSF49777 : 0040158", "SSF46785 : 0037648", "SSF54236 : 0041320", 
                      "SSF52540 : 0050867", "SSF53067 : 0048323", "SSF47473 : 0049489", 
                      "SSF57567 : 0045816", "PS50920 : SOLCAR", "PF00260 : Protamine_P1", 
                      "PD000971 :", "SSF48452 : 0039025", "SSF53383 : 0035073", "SSF74924 : 0050556", 
                      "SSF51735 : 0037505", "SSF57196 : 0039055", "PF03982 : DAGAT", 
                      "PF04707 : MSF1", "SSF48726 : 0041199", "SSF50692 : 0041851", 
                      "SSF46689 : 0050079", "PIRSF005444 :", "PF04097 : Nic96", "SSF63570 : 0038997", 
                      "SSF52172 : 0047555", "SSF69765 : 0039652", "SSF50969 : 0047606", 
                      "SSF48726 : 0035572", "SSF88946 : 0040264", "PF01607 : CBM_14", 
                      "SSF51658 : 0035756", "SSF49879 : 0052671", "SSF52540 : 0053196", 
                      "PIRSF023322 :", "SSF52058 : 0041268", "SSF55821 : 0038693", 
                      "SSF54076 : 0038598", "PIRSF001554 :", "SSF50923 : 0047435", 
                      "SSF48726 : 0035575", "SSF89009 : 0047255", "SSF46785 : 0040679", 
                      "SSF48726 : 0039547", "PS50212 : RASGEF_NTER", "SSF46458 : 0040876", 
                      "SSF48264 : 0044092", "SSF53271 : 0041997", "SSF54913 : 0044412", 
                      "SSF54637 : 0052512", "SSF50729 : 0050604", "SSF49348 : 0042154", 
                      "SSF46689 : 0051466", "SSF55816 : 0044502", "SSF48295 : 0049681", 
                      "SSF50203 : 0042439", "PIRSF036312 :", "SSF55681 : 0046052", 
                      "SSF49830 : 0035134", "PF04615 : Utp14", "SSF52313 : 0050191", 
                      "PD002096 :", "SSF53335 : 0047676", "SSF53328 : 0051998", "SSF52833 : 0051667", 
                      "SSF51735 : 0042757", "SSF49842 : 0042351", "SSF101874 : 0051165", 
                      "SSF47473 : 0040067", "SSF48695 : 0037264", "TIGR01292 : TRX_reduct", 
                      "PS50081 : ZF_DAG_PE_2", "SSF47095 : 0044635", "SSF51735 : 0049198", 
                      "SSF55770 : 0046198", "SSF52777 : 0048911", "PD035122 :", "SSF52141 : 0040441", 
                      "SSF55068 : 0048456", "SSF89550 : 0048101", "PIRSF000517 :", 
                      "PF03131 : bZIP_Maf", "SSF52540 : 0048220", "SSF51735 : 0040910", 
                      "PR01552 : TPISMRASE6A", "SSF51735 : 0052818", "SSF46966 : 0038529", 
                      "PF09756 : DDRGK", "SSF51069 : 0038524", "PD339107 :", "SSF53756 : 0048500", 
                      "SSF110738 : 0044068", "SSF55347 : 0052979", "SSF52833 : 0041396", 
                      "SSF52540 : 0041443", "SSF52540 : 0036790", "PF08321 : PPP5", 
                      "SSF54826 : 0045995", "SSF54117 : 0038505", "SSF100950 : 0048730", 
                      "SSF54184 : 0039856", "SSF50353 : 0045918", "SSF46785 : 0050338", 
                      "SSF54826 : 0050710", "SSF49899 : 0045066", "SSF50346 : 0044351", 
                      "SSF47781 : 0051966", "SSF57095 : 0035387", "SSF50939 : 0053333", 
                      "PF09825 : BPL_N", "SSF51604 : 0047478", "SSF53795 : 0039036", 
                      "SSF51621 : 0041093", "SSF52113 : 0038345", "SSF57362 : 0045341", 
                      "SSF48726 : 0041446", "SSF55961 : 0051454", "SSF52972 : 0039945", 
                      "TIGR00510 : lipA", "PF00696 : AA_kinase", "SSF54534 : 0040804", 
                      "SSF50156 : 0052650", "SSF47113 : 0047348", "SSF49854 : 0041549", 
                      "SSF48726 : 0041511", "SSF48498 : 0051586", "SSF54060 : 0037092", 
                      "SSF57016 : 0044360", "SSF54928 : 0037612", "SSF63999 : 0039000", 
                      "SSF51126 : 0035552", "PS50911 : CHAP", "SSF46626 : 0038140", 
                      "SSF52058 : 0038447", "SSF53850 : 0041385", "PF03388 : Lectin_leg-like", 
                      "SSF52540 : 0042720", "SSF54928 : 0052441", "SSF57829 : 0049333", 
                      "SSF49723 : 0043325", "SSF46955 : 0040420", "SSF50494 : 0040102", 
                      "SSF54631 : 0042237", "SSF56436 : 0042437", "SSF52540 : 0049404", 
                      "SSF50692 : 0036728", "TIGR00589 : ogt", "SSF88633 : 0050430", 
                      "SSF47266 : 0034934", "PR01727 : DNABINDINGHU", "PF04384 : DUF528", 
                      "PF04045 : P34-Arc", "SSF53720 : 0044883", "SSF54913 : 0041386", 
                      "PF01979 : Amidohydro_1", "SSF81296 : 0052025", "SSF49503 : 0046427", 
                      "SSF55481 : 0036590", "PF05742 : DUF833", "PIRSF000431 :", "SSF57630 : 0042600", 
                      "PR00171 : SUGRTRNSPORT", "PF03917 : GSH_synth_ATP", "SSF51366 : 0039992", 
                      "SSF50814 : 0038993", "SSF54511 : 0038095", "SSF52949 : 0052679", 
                      "SSF52266 : 0037646", "SSF52540 : 0042070", "SSF50729 : 0050053", 
                      "SSF50475 : 0050968", "SSF52540 : 0041032", "PF01762 : Galactosyl_T", 
                      "SSF88633 : 0041619", "SSF48726 : 0049839", "SSF51161 : 0053166", 
                      "SSF57424 : 0052952", "SSF55174 : 0047871", "PF00213 : OSCP", 
                      "SSF50044 : 0049439", "SSF51905 : 0046750", "PF09458 : H_lectin", 
                      "PF03006 : HlyIII", "SSF49265 : 0042954", "SSF48498 : 0052886", 
                      "SSF54909 : 0052136", "SSF50182 : 0038922", "SSF47473 : 0043104", 
                      "SSF47616 : 0039617", "SSF56436 : 0047699", "SSF54695 : 0042727", 
                      "SSF81301 : 0039444", "SSF56436 : 0038485", "SSF46934 : 0052068", 
                      "PD005927 :", "SSF49265 : 0037678", "SSF54236 : 0050743", "SSF52540 : 0052691", 
                      "SSF57535 : 0037923", "PF01400 : Astacin", "SSF54928 : 0050808", 
                      "PR01001 : FADG3PDH", "SSF53597 : 0053343", "SSF50118 : 0049849", 
                      "SSF56281 : 0050252", "SSF55550 : 0040946", "PF06916 : DUF1279", 
                      "SSF53686 : 0043948", "PR00753 : ACCSYNTHASE", "SSF53613 : 0047908", 
                      "SSF47266 : 0037414", "SSF56994 : 0044844", "SSF49265 : 0045312", 
                      "SSF57302 : 0038815", "SSF55347 : 0039377", "SSF51621 : 0047659", 
                      "SSF101116 : 0041994", "PF01068 : DNA_ligase_A_M", "SSF50630 : 0035480", 
                      "SSF51569 : 0040402", "PR00119 : CATATPASE", "SSF53167 : 0046520", 
                      "SSF54373 : 0040036", "PD002202 :", "SSF46548 : 0040051", "TIGR01347 : sucB", 
                      "SSF69322 : 0039880", "SSF46557 : 0038236", "SSF55331 : 0048148", 
                      "TIGR00269 : TIGR00269", "SSF51735 : 0049730", "SSF52540 : 0042802", 
                      "SSF48498 : 0051515", "PR00061 : RIBOSOMALL19", "SSF47576 : 0044622", 
                      "PS50888 : HLH", "SSF51445 : 0038114", "SSF88723 : 0043407", 
                      "SSF49899 : 0044454", "SSF54791 : 0052721", "SSF51604 : 0047825", 
                      "PS50001 : SH2", "SSF57716 : 0052404", "SSF53807 : 0042773", 
                      "PF01020 : Ribosomal_L40e", "SSF47616 : 0045301", "SSF50998 : 0048022", 
                      "PF00916 : Sulfate_transp", "SSF51206 : 0043228", "SSF52540 : 0046913", 
                      "PF01300 : Sua5_yciO_yrdC", "PF04733 : Coatomer_E", "SSF109604 : 0037310", 
                      "SSF49303 : 0036531", "SSF52788 : 0048765", "SSF51905 : 0035954", 
                      "SSF51735 : 0036542", "PF05028 : PARG_cat", "SSF56425 : 0052033", 
                      "SSF53335 : 0047945", "SSF56204 : 0046078", "PR01361 : MEROZOITESA", 
                      "PF02487 : CLN3", "SSF54695 : 0035720", "SSF46458 : 0044647", 
                      "SSF54909 : 0043827", "SSF52255 : 0048487", "PF08711 : TFIIS", 
                      "SSF53383 : 0051757", "SSF53448 : 0038020", "SSF88874 : 0041791", 
                      "SSF46689 : 0041016", "SSF53056 : 0038893", "SSF48726 : 0035047", 
                      "SSF56327 : 0036008", "SSF100920 : 0036037", "TIGR02228 : sigpep_I_arch", 
                      "SSF46934 : 0052455", "SSF88633 : 0046192", "SSF51569 : 0050945", 
                      "SSF52833 : 0050672", "SSF56935 : 0041517", "SSF57059 : 0048039", 
                      "SSF69012 : 0039623", "SSF46626 : 0046079", "PD000001 :", "SSF51011 : 0049835", 
                      "SSF52091 : 0044690", "SSF52091 : 0035218", "SSF51905 : 0050364", 
                      "SSF55961 : 0050926", "PR01333 : 2POREKCHANEL", "PIRSF008756 :", 
                      "SSF55648 : 0039754", "SSF53335 : 0035026", "SSF55174 : 0047115", 
                      "PD008153 :", "SSF57667 : 0050862", "PS50118 : HMG_BOX_2", "SSF46785 : 0037720", 
                      "PF02586 : DUF159", "SSF52540 : 0049657", "PF07909 : DUF1663", 
                      "SSF46458 : 0050881", "SSF51735 : 0043678", "SSF49265 : 0052997", 
                      "SSF63491 : 0038901", "SSF48452 : 0048732", "PF00831 : Ribosomal_L29", 
                      "PF02940 : mRNA_triPase", "SSF82199 : 0048273", "SSF55961 : 0037659", 
                      "PD003992 :", "SSF48239 : 0049012", "SSF51445 : 0042795", "SSF55486 : 0048413", 
                      "SSF56371 : 0036494", "PF02410 : DUF143", "SSF47769 : 0050731", 
                      "SSF53448 : 0046659", "SSF48619 : 0047620", "SSF74924 : 0039258", 
                      "SSF88802 : 0052339", "PF00806 : PUF", "SSF57756 : 0046717", 
                      "SSF55729 : 0040636", "SSF53335 : 0052536", "SSF52047 : 0039098", 
                      "SSF54236 : 0049310", "SSF52540 : 0045376", "SSF53822 : 0045343", 
                      "PF06159 : DUF974", "SSF54416 : 0037058", "SSF49309 : 0046677", 
                      "PIRSF000232 :", "PF01193 : RNA_pol_L", "SSF46955 : 0039468", 
                      "SSF56014 : 0035138", "SSF56821 : 0040966", "SSF53748 : 0042321", 
                      "SSF53738 : 0045550", "SSF52402 : 0052117", "SSF55486 : 0053376", 
                      "SSF50044 : 0042705", "SSF55811 : 0047729", "TIGR00532 : HMG_CoA_R_NAD", 
                      "SSF54768 : 0050560", "SSF47473 : 0034876", "SSF51246 : 0035994", 
                      "PF02136 : NTF2", "TIGR01536 : asn_synth_AEB", "SSF53649 : 0053063", 
                      "SSF46689 : 0038631", "SSF50129 : 0036743", "SSF50203 : 0035115", 
                      "PF01712 : dNK", "SSF46785 : 0037687", "SSF46689 : 0052257", 
                      "SSF53067 : 0053210", "SSF50044 : 0043854", "SSF48695 : 0048064", 
                      "TIGR00797 : matE", "SSF53383 : 0052070", "SSF53474 : 0045597", 
                      "SSF48726 : 0053104", "SSF46785 : 0044210", "SSF55961 : 0048001", 
                      "SSF52141 : 0041803", "SSF51011 : 0037941", "SSF109998 : 0044933", 
                      "SSF50789 : 0041709", "SSF53067 : 0035476", "SSF57059 : 0048599", 
                      "SSF54358 : 0047628", "SSF50978 : 0038319", "SSF51735 : 0043542", 
                      "PD729633 :", "SSF51412 : 0039483", "PF07884 : VKOR", "SSF50156 : 0044688", 
                      "SSF56235 : 0043431", "SSF46689 : 0036751", "PF01086 : Clathrin_lg_ch", 
                      "SSF54506 : 0046028", "SSF48452 : 0051253", "PF00728 : Glyco_hydro_20", 
                      "SSF52833 : 0051483", "SSF56300 : 0035205", "PF00689 : Cation_ATPase_C", 
                      "SSF48452 : 0042932", "SSF47323 : 0039121", "SSF52141 : 0040423", 
                      "PF07019 : Rab5ip", "SSF46689 : 0052308", "PF02840 : Prp18", 
                      "SSF55347 : 0035953", "SSF56935 : 0042007", "SSF51197 : 0046302", 
                      "PF01575 : MaoC_dehydratas", "SSF81301 : 0052653", "PF03645 : Tctex-1", 
                      "SSF50129 : 0037912", "PF09269 : DUF1967", "SSF49417 : 0039080", 
                      "PS51215 : AWS", "SSF51338 : 0039841", "TIGR01371 : met_syn_B12ind", 
                      "SSF49870 : 0036603", "PD015172 :", "PD112098 :", "SSF50729 : 0046512", 
                      "SSF74653 : 0040624", "SSF54211 : 0036738", "SSF57716 : 0045056", 
                      "SSF49562 : 0034838", "PD001231 :", "SSF57850 : 0047475", "TIGR00283 : TIGR00283", 
                      "SSF53056 : 0036374", "PF02734 : Dak2", "SSF48150 : 0041094", 
                      "SSF57716 : 0041473", "SSF51069 : 0045490", "SSF52283 : 0045244", 
                      "PF04192 : Utp21", "PF08288 : PIGA", "PF03607 : DCX", "SSF51569 : 0048586", 
                      "SSF55239 : 0045666", "SSF50044 : 0048617", "PF00490 : ALAD", 
                      "PD004399 :", "SSF56770 : 0052777", "SSF56059 : 0037276", "SSF51161 : 0050899", 
                      "SSF54211 : 0049170", "SSF50370 : 0035937", "SSF50022 : 0037990", 
                      "SSF54292 : 0040391", "SSF55729 : 0035638", "SSF47336 : 0041515", 
                      "SSF54427 : 0048566", "SSF51735 : 0041223", "PF02009 : Rifin_STEVOR", 
                      "SSF52833 : 0044681", "SSF54534 : 0035884", "SSF89796 : 0042642", 
                      "PF00385 : Chromo", "SSF47954 : 0046712", "SSF51695 : 0049567", 
                      "SSF50044 : 0045813", "SSF57302 : 0045147", "SSF50494 : 0046575", 
                      "SSF48726 : 0040886", "TIGR00005 : rluA_subfam", "PS50271 : ZF_UBP", 
                      "SSF53474 : 0046012", "SSF49313 : 0044192", "PR00783 : MINTRINSICP", 
                      "SSF55931 : 0045229", "SSF102198 : 0051869", "PS50830 : TNASE_3", 
                      "PF05383 : La", "SSF46689 : 0053204", "SSF54909 : 0049704", "SSF50353 : 0035609", 
                      "SSF57095 : 0043271", "PF00439 : Bromodomain", "SSF54928 : 0050476", 
                      "PF03016 : Exostosin", "SSF50923 : 0042799", "SSF54211 : 0040911", 
                      "SSF48726 : 0042572", "SSF88633 : 0049085", "SSF53271 : 0035468", 
                      "SSF50494 : 0038219", "SSF51182 : 0051095", "SSF53850 : 0051251", 
                      "SSF47473 : 0047413", "SSF56327 : 0052184", "PD004620 :", "SSF109604 : 0053004", 
                      "SSF52540 : 0043778", "SSF56112 : 0038373", "SSF52540 : 0044387", 
                      "SSF55008 : 0041969", "SSF54098 : 0040490", "SSF49313 : 0040373", 
                      "SSF52777 : 0041485", "PR00503 : BROMODOMAIN", "PR00320 : GPROTEINBRPT", 
                      "SSF88633 : 0042408", "PR00111 : ABHYDROLASE", "PF01609 : Transposase_11", 
                      "SSF52096 : 0044160", "SSF63570 : 0041463", "SSF51679 : 0048354", 
                      "SSF53732 : 0051895", "SSF57095 : 0045191", "SSF75005 : 0044831", 
                      "SSF57038 : 0046318", "SSF46689 : 0052252", "SSF56436 : 0045154", 
                      "TIGR00259 : TIGR00259", "SSF53098 : 0036054", "SSF47323 : 0042946", 
                      "SSF49899 : 0043656", "SSF57059 : 0037262", "SSF54928 : 0052243", 
                      "SSF52728 : 0035610", "SSF50249 : 0040955", "SSF46955 : 0037244", 
                      "SSF49723 : 0040090", "SSF46785 : 0051444", "SSF56112 : 0049348", 
                      "SSF51735 : 0046253", "SSF82653 : 0048181", "SSF48726 : 0052643", 
                      "SSF56935 : 0053328", "PIRSF000113 :", "SSF56059 : 0046457", 
                      "SSF52151 : 0040992", "SSF88633 : 0046307", "TIGR00012 : L29", 
                      "SSF49503 : 0052067", "SSF88697 : 0043106", "SSF81442 : 0037007", 
                      "SSF109604 : 0053007", "SSF48484 : 0040593", "PS50138 : BRCA2_REPEAT", 
                      "SSF101094 : 0041568", "PF01931 : DUF84", "PF00672 : HAMP", "SSF63380 : 0052010", 
                      "PIRSF006779 :", "PS50283 : NA_SOLUT_SYMP_3", "SSF52540 : 0036850", 
                      "SSF52518 : 0049028", "PD603779 :", "SSF54416 : 0040243", "PF01304 : Gas_vesicle_C", 
                      "SSF57059 : 0040673", "PF04193 : PQ-loop", "SSF53474 : 0043326", 
                      "SSF55464 : 0041922", "SSF46689 : 0045465", "SSF55620 : 0037473", 
                      "SSF50630 : 0036872", "SSF46458 : 0048134", "SSF47413 : 0049999", 
                      "PR01573 : SUPERTUBBY", "SSF57059 : 0035867", "PF08524 : rRNA_processing", 
                      "SSF48726 : 0034857", "SSF54452 : 0041946", "SSF52087 : 0043136", 
                      "SSF54277 : 0042424", "SSF51069 : 0040188", "SSF50891 : 0051982", 
                      "SSF52129 : 0037330", "PF03650 : UPF0041", "SSF46458 : 0035425", 
                      "SSF57879 : 0036077", "SSF54403 : 0046125", "TIGR01605 : PYST-D", 
                      "SSF51905 : 0046270", "SSF53850 : 0051046", "SSF49899 : 0038008", 
                      "TIGR00840 : b_cpa1", "PF00574 : CLP_protease", "SSF55315 : 0042511", 
                      "SSF52279 : 0037236", "SSF56601 : 0050388", "SSF57283 : 0042378", 
                      "SSF46626 : 0045084", "SSF53955 : 0036072", "SSF51905 : 0050148", 
                      "SSF53067 : 0050671", "SSF52935 : 0034868", "SSF57667 : 0052471", 
                      "SSF53383 : 0046154", "SSF49417 : 0034898", "SSF52317 : 0041867", 
                      "SSF53474 : 0046388", "SSF47113 : 0040265", "SSF52540 : 0039575", 
                      "SSF53822 : 0039803", "SSF48726 : 0035519", "SSF50249 : 0037576", 
                      "SSF48508 : 0038857", "SSF81296 : 0039584", "SSF51735 : 0051355", 
                      "SSF110069 : 0051061", "SSF47413 : 0043707", "PD004329 :", "SSF52518 : 0039059", 
                      "SSF53167 : 0043911", "SSF88633 : 0045358", "SSF51735 : 0047054", 
                      "SSF57903 : 0050172", "SSF88633 : 0046272", "SSF49265 : 0046701", 
                      "SSF75005 : 0050020", "SSF52540 : 0042008", "SSF81342 : 0035490", 
                      "SSF50405 : 0038526", "SSF47473 : 0039766", "SSF52922 : 0044441", 
                      "SSF51649 : 0035746", "SSF54184 : 0039857", "SSF49899 : 0034945", 
                      "SSF81531 : 0037297", "SSF64153 : 0051847", "TIGR00479 : rumA", 
                      "SSF57196 : 0044493", "SSF52540 : 0043494", "PF00130 : C1_1", 
                      "SSF56059 : 0047322", "SSF50249 : 0047223", "PF03635 : Vps35", 
                      "SSF53613 : 0044824", "SSF50494 : 0051243", "SSF53474 : 0049887", 
                      "SSF51735 : 0041770", "SSF56601 : 0038811", "SSF56235 : 0039157", 
                      "PD005152 :", "PF03152 : UFD1", "SSF49785 : 0036483", "TIGR03598 : GTPase_YsxC", 
                      "SSF51445 : 0049976", "SSF50886 : 0046564", "SSF55545 : 0052169", 
                      "PS50125 : GUANYLATE_CYCLASE_2", "SSF54416 : 0041759", "SSF101601 : 0043158", 
                      "SSF46785 : 0049173", "SSF51735 : 0040818", "SSF48557 : 0035142", 
                      "SSF51658 : 0049040", "SSF49899 : 0044555", "SSF63380 : 0042753", 
                      "SSF54511 : 0038418", "SSF51126 : 0041845", "SSF55424 : 0036655", 
                      "SSF46609 : 0035286", "PF00203 : Ribosomal_S19", "SSF48508 : 0041397", 
                      "PF04161 : Arv1", "SSF52540 : 0049485", "SSF51366 : 0050322", 
                      "SSF52440 : 0044271", "SSF54506 : 0043521", "SSF53474 : 0037175", 
                      "PF08068 : DKCLD", "PF03577 : Peptidase_C69", "PF00673 : Ribosomal_L5_C", 
                      "SSF47576 : 0048132", "SSF54452 : 0048801", "SSF51069 : 0040187", 
                      "SSF55770 : 0036230", "SSF100879 : 0043913", "SSF57501 : 0049623", 
                      "TIGR01697 : PNPH-PUNA-XAPA", "SSF51445 : 0035540", "PS50082 : WD_REPEATS_2", 
                      "PS50200 : RA", "PF00026 : Asp", "SSF51391 : 0045046", "SSF55895 : 0036449", 
                      "SSF57552 : 0047500", "SSF52374 : 0037568", "PF06155 : DUF971", 
                      "SSF52374 : 0039544", "SSF81923 : 0047811", "PF01096 : TFIIS_C", 
                      "SSF51445 : 0037942", "SSF46626 : 0040281", "SSF69765 : 0039216", 
                      "SSF56281 : 0047843", "PD012268 :", "PF06424 : PRP1_N", "SSF57716 : 0037546", 
                      "PS51123 : OMPA_2", "PF03358 : FMN_red", "SSF48113 : 0035161", 
                      "SSF52540 : 0044149", "SSF50044 : 0049871", "SSF49265 : 0049925", 
                      "SSF50203 : 0044158", "SSF52935 : 0049547", "SSF53901 : 0036365", 
                      "PF00038 : Filament", "SSF52788 : 0045625", "SSF50630 : 0040638", 
                      "SSF53335 : 0050693", "SSF52540 : 0039092", "PD001580 :", "PF04696 : Pinin_SDK_memA", 
                      "PF04324 : Fer2_BFD", "SSF46626 : 0036151", "PS50835 : IG_LIKE", 
                      "SSF48113 : 0044251", "SSF55124 : 0045800", "SSF48726 : 0052180", 
                      "SSF57196 : 0053152", "SSF46689 : 0052885", "PF02867 : Ribonuc_red_lgC", 
                      "SSF69000 : 0039717", "SSF52518 : 0041402", "PS51270 : ZF_CTCHY", 
                      "SSF54292 : 0042842", "SSF49785 : 0039902", "PF01981 : PTH2", 
                      "SSF52518 : 0042488", "SSF46938 : 0048503", "SSF51366 : 0049004", 
                      "SSF52980 : 0050352", "SSF51569 : 0041287", "SSF52313 : 0037613", 
                      "PR00141 : PROTEASOME", "PF05193 : Peptidase_M16_C", "SSF55298 : 0052332", 
                      "PS51284 : DOC", "PF01632 : Ribosomal_L35p", "PD038149 :", "SSF57095 : 0048338", 
                      "PF00218 : IGPS", "SSF51735 : 0038281", "PF02371 : Transposase_20", 
                      "SSF57701 : 0036289", "SSF51011 : 0042794", "SSF51445 : 0053367", 
                      "PF00162 : PGK", "SSF56112 : 0052889", "SSF54236 : 0044629", 
                      "SSF81301 : 0047842", "PF01370 : Epimerase", "PF07718 : DUF1606", 
                      "PF07748 : Glyco_hydro_38C", "SSF47175 : 0045921", "SSF47769 : 0044278", 
                      "SSF51126 : 0038472", "SSF46458 : 0037868", "SSF57667 : 0050596", 
                      "SSF63748 : 0038407", "SSF55347 : 0050229", "SSF53383 : 0050753", 
                      "PF07818 : HCNGP", "SSF52540 : 0049853", "SSF53448 : 0050195", 
                      "SSF54631 : 0042494", "SSF51445 : 0046266", "SSF53067 : 0039007", 
                      "SSF54452 : 0044539", "SSF47912 : 0037032", "SSF53271 : 0043936", 
                      "SSF47769 : 0049975", "SSF57586 : 0053011", "PF08170 : POPLD", 
                      "SSF50370 : 0045142", "SSF49401 : 0042266", "SSF53098 : 0047398", 
                      "SSF69572 : 0041382", "SSF57196 : 0038508", "SSF55729 : 0051336", 
                      "TIGR01080 : rplX_A_E", "PF03265 : DNase_II", "PF00153 : Mito_carr", 
                      "SSF56266 : 0035366", "SSF53167 : 0039819", "PD142495 :", "PF03588 : Leu_Phe_trans", 
                      "SSF52113 : 0050485", "SSF55961 : 0038996", "SSF51366 : 0051598", 
                      "SSF54495 : 0039404", "PS51156 : ELM2", "SSF75217 : 0041613", 
                      "SSF50814 : 0042679", "SSF51735 : 0049686", "SSF50044 : 0047233", 
                      "SSF50692 : 0036503", "SSF53098 : 0047295", "SSF56655 : 0048372", 
                      "SSF88697 : 0042644", "SSF100950 : 0051774", "PF09758 : FPL", 
                      "SSF56112 : 0040608", "PF08718 : GLTP", "SSF57059 : 0045837", 
                      "SSF52029 : 0040101", "PF05681 : Fumerase", "SSF56219 : 0035081", 
                      "PF00436 : SSB", "SSF54719 : 0051208", "SSF69099 : 0040201", 
                      "SSF51445 : 0036075", "PF09417 : RNA_pol_III_C17", "PS50839 : CHASE", 
                      "SSF48726 : 0051572", "SSF52833 : 0049697", "PF00043 : GST_C", 
                      "SSF48264 : 0046634", "SSF48726 : 0050174", "PF01132 : EFP", 
                      "SSF81296 : 0046854", "SSF56235 : 0053208", "SSF57027 : 0036056", 
                      "SSF57774 : 0046460", "PF08076 : TetM_leader", "SSF54098 : 0051189", 
                      "TIGR00440 : glnS", "SSF50156 : 0052663", "SSF57667 : 0044260", 
                      "SSF54919 : 0041390", "SSF56399 : 0049029", "SSF57802 : 0042711", 
                      "SSF54403 : 0052021", "PF03366 : YEATS", "SSF51695 : 0050147", 
                      "SSF69645 : 0039967", "SSF57095 : 0048422", "SSF55961 : 0047354", 
                      "SSF46626 : 0040004", "SSF49590 : 0041176", "SSF46938 : 0035202", 
                      "SSF52777 : 0041319", "SSF47473 : 0050653", "SSF55550 : 0037590", 
                      "SSF74784 : 0040045", "SSF56601 : 0038544", "PF00650 : CRAL_TRIO", 
                      "SSF54211 : 0037810", "PR00682 : IPNSYNTHASE", "SSF54909 : 0050908", 
                      "PF05251 : UPF0197", "PIRSF006865 :", "SSF88697 : 0039975", "SSF57798 : 0047698", 
                      "SSF50386 : 0044947", "SSF49401 : 0048260", "SSF56672 : 0049324", 
                      "SSF52768 : 0045215", "PS51257 : PROKAR_LIPOPROTEIN", "SSF52833 : 0040521", 
                      "SSF46785 : 0040459", "SSF52172 : 0050342", "PF08071 : RS4NT", 
                      "SSF57667 : 0045249", "SSF51735 : 0048286", "PR00982 : TRNASYNTHLYS", 
                      "SSF57362 : 0044072", "SSF46458 : 0040873", "SSF48113 : 0045642", 
                      "SSF48371 : 0038384", "SSF56784 : 0044171", "SSF47240 : 0050214", 
                      "PR00934 : XHISDIPTASE", "SSF56300 : 0044518", "SSF56436 : 0035372", 
                      "SSF47413 : 0051837", "PF02733 : Dak1", "SSF88659 : 0041987", 
                      "PF00116 : COX2", "TIGR00485 : EF-Tu", "SSF49417 : 0035525", 
                      "SSF50249 : 0036034", "SSF55060 : 0048150", "PS50106 : PDZ", 
                      "PF00075 : RnaseH", "SSF53697 : 0035872", "SSF56601 : 0036714", 
                      "SSF51366 : 0047889", "SSF47741 : 0041224", "SSF101852 : 0043351", 
                      "PF00335 : Tetraspannin", "SSF46458 : 0045292", "PR01041 : TRNASYNTHMET", 
                      "PF00614 : PLDc", "SSF56672 : 0044909", "SSF46955 : 0042547", 
                      "PF06017 : Myosin_TH1", "SSF54001 : 0039200", "PR01166 : CYCOXIDASEII", 
                      "SSF54909 : 0050149", "SSF53167 : 0044766", "SSF56954 : 0050674", 
                      "SSF47874 : 0038635", "SSF69369 : 0043232", "SSF51161 : 0039338", 
                      "SSF47240 : 0048157", "SSF52540 : 0043607", "SSF46767 : 0049380", 
                      "SSF47616 : 0046637", "SSF46785 : 0044139", "PIRSF001553 :", 
                      "SSF55021 : 0049597", "SSF52540 : 0051448", "SSF50249 : 0040655", 
                      "SSF51011 : 0050759", "SSF53686 : 0051522", "SSF51735 : 0052415", 
                      "SSF47616 : 0036939", "PF07744 : SPOC", "PF04264 : YceI", "SSF52540 : 0047808", 
                      "SSF57535 : 0037924", "SSF50037 : 0039019", "SSF54909 : 0040996", 
                      "PD039347 :", "PF00510 : COX3", "SSF56994 : 0045117", "SSF57868 : 0036497", 
                      "PD004105 :", "SSF48239 : 0053354", "PF07687 : M20_dimer", "PF09751 : Es2", 
                      "SSF55753 : 0036221", "SSF109604 : 0042082", "SSF56104 : 0035636", 
                      "PF07981 : Plasmod_MYXSPDY", "SSF46955 : 0042521", "SSF51905 : 0049679", 
                      "SSF53795 : 0047801", "PF01222 : ERG4_ERG24", "SSF56327 : 0045320", 
                      "SSF54593 : 0047985", "PR00102 : OTCASE", "SSF50494 : 0044076", 
                      "PD001367 :", "SSF50729 : 0035431", "SSF48113 : 0036187", "SSF49503 : 0038976", 
                      "SSF53383 : 0046024", "PF04900 : Fcf1", "SSF48295 : 0040418", 
                      "PIRSF001357 :", "SSF54849 : 0042604", "SSF101473 : 0044458", 
                      "SSF52777 : 0045500", "SSF56204 : 0035853", "SSF55424 : 0045520", 
                      "SSF53613 : 0051846", "SSF54995 : 0036115", "SSF52058 : 0042103", 
                      "SSF49401 : 0044512", "SSF53774 : 0038578", "PF01839 : FG-GAP", 
                      "SSF50729 : 0040330", "SSF46689 : 0040945", "SSF53671 : 0039730", 
                      "PF00282 : Pyridoxal_deC", "SSF50249 : 0043000", "SSF52129 : 0036096", 
                      "SSF52172 : 0045499", "SSF52833 : 0051701", "SSF81593 : 0044324", 
                      "SSF53474 : 0044544", "PF03573 : OprD", "SSF55804 : 0050986", 
                      "SSF51735 : 0051203", "SSF54637 : 0046094", "PD005232 :", "SSF56645 : 0043102", 
                      "SSF50044 : 0040117", "SSF81296 : 0040773", "PF08315 : cwf18", 
                      "SSF51556 : 0045611", "SSF46785 : 0039399", "SSF53067 : 0051731", 
                      "SSF54518 : 0053290", "SSF48113 : 0041121", "SSF51182 : 0036426", 
                      "SSF55826 : 0050454", "PF09329 : zf-primase", "PR00296 : CYCLINKINASE", 
                      "PF08333 : DUF1725", "PF05029 : TIMELESS_C", "SSF50814 : 0038640", 
                      "SSF75217 : 0047409", "PF02719 : Polysacc_synt_2", "PIRSF000089 :", 
                      "PD030375 :", "SSF50814 : 0037251", "TIGR00689 : rpiB_lacA_lacB", 
                      "PR01406 : BBOXZNFINGER", "SSF48264 : 0041213", "SSF56645 : 0039220", 
                      "SSF47031 : 0040958", "SSF81321 : 0035878", "SSF56327 : 0046657", 
                      "SSF47576 : 0036663", "SSF56436 : 0036620", "SSF53474 : 0049087", 
                      "SSF47473 : 0039124", "SSF56601 : 0044213", "SSF51011 : 0046022", 
                      "SSF53137 : 0046799", "SSF52540 : 0043792", "SSF53474 : 0041193", 
                      "SSF81296 : 0047385", "SSF53474 : 0047683", "SSF51445 : 0049986", 
                      "PF08146 : BP28CT", "SSF53474 : 0047220", "SSF101288 : 0050166", 
                      "SSF53807 : 0053187", "SSF49503 : 0042388", "TIGR00446 : nop2p", 
                      "SSF81321 : 0037432", "SSF103575 : 0041917", "SSF53335 : 0041685", 
                      "PF02679 : ComA", "SSF51419 : 0049723", "SSF56112 : 0044203", 
                      "SSF55347 : 0036893", "PF04865 : Baseplate_J", "SSF51045 : 0052570", 
                      "SSF49401 : 0049046", "SSF56176 : 0039727", "PF00112 : Peptidase_C1", 
                      "SSF47565 : 0035840", "SSF48726 : 0036170", "SSF47113 : 0052079", 
                      "SSF56601 : 0040822", "SSF53067 : 0052165", "PF00013 : KH_1", 
                      "TIGR01983 : UbiG", "PF00549 : Ligase_CoA", "SSF55729 : 0051303", 
                      "PF04570 : DUF581", "SSF48726 : 0047208", "SSF56042 : 0044823", 
                      "SSF57821 : 0038106", "SSF47446 : 0043060", "SSF50447 : 0045034", 
                      "SSF54637 : 0049564", "SSF48726 : 0046752", "PS50084 : KH_TYPE_1", 
                      "SSF51445 : 0037707", "SSF63748 : 0050625", "SSF47391 : 0043099", 
                      "SSF54919 : 0051068", "PF01209 : Ubie_methyltran", "SSF54928 : 0035388", 
                      "PF00113 : Enolase_C", "SSF52374 : 0039908", "SSF55909 : 0052532", 
                      "PD021858 :", "SSF56645 : 0045540", "PF01618 : MotA_ExbB", "SSF48239 : 0041219", 
                      "PF03798 : LAG1", "SSF51735 : 0037278", "SSF49417 : 0048196", 
                      "SSF55486 : 0035975", "SSF81837 : 0049560", "SSF50475 : 0043438", 
                      "SSF51011 : 0036256", "SSF51351 : 0049592", "SSF50044 : 0043256", 
                      "PF02996 : Prefoldin", "SSF50891 : 0050386", "PF00953 : Glycos_transf_4", 
                      "SSF48552 : 0035617", "SSF56371 : 0041415", "PF06417 : DUF1077", 
                      "SSF49344 : 0038919", "SSF53218 : 0050976", "SSF49785 : 0038231", 
                      "SSF57868 : 0049522", "SSF55486 : 0047260", "PF01426 : BAH", 
                      "SSF51219 : 0048752", "SSF47473 : 0043274", "PF00929 : Exonuc_X-T", 
                      "PD006880 :", "SSF50447 : 0037530", "SSF49899 : 0038356", "PF04972 : BON", 
                      "SSF49313 : 0040376", "SSF51445 : 0040255", "PF01256 : Carb_kinase", 
                      "SSF56024 : 0053240", "SSF51604 : 0040033", "SSF50353 : 0035434", 
                      "SSF53187 : 0050015", "PF09216 : Pfg27", "SSF88697 : 0052864", 
                      "SSF55008 : 0046759", "SSF51395 : 0050135", "SSF55979 : 0038063", 
                      "SSF49265 : 0051917", "PF05739 : SNARE", "SSF49998 : 0041276", 
                      "SSF52540 : 0043258", "SSF50203 : 0047560", "SSF53474 : 0037239", 
                      "SSF48726 : 0050798", "SSF55931 : 0043170", "SSF54373 : 0043578", 
                      "SSF54768 : 0051934", "SSF82649 : 0050294", "PF01513 : NAD_kinase", 
                      "TIGR00180 : parB_part", "SSF54001 : 0045515", "PF08603 : CAP_C", 
                      "SSF63411 : 0035450", "SSF54171 : 0040114", "SSF52540 : 0038732", 
                      "SSF54913 : 0038760", "SSF53955 : 0039862", "SSF57296 : 0045179", 
                      "PIRSF000193 :", "SSF100939 : 0042053", "SSF109880 : 0043634", 
                      "SSF53335 : 0049122", "PIRSF000513 :", "SSF56235 : 0046519", 
                      "SSF51110 : 0039687", "SSF56059 : 0050408", "SSF50370 : 0034987", 
                      "SSF48179 : 0040515", "SSF46785 : 0041905", "SSF57829 : 0046773", 
                      "SSF55770 : 0034994", "SSF50494 : 0040875", "PF02237 : BPL_C", 
                      "PF00610 : DEP", "SSF57586 : 0048622", "PF03404 : Mo-co_dimer", 
                      "SSF52821 : 0049168", "SSF51445 : 0035509", "SSF49695 : 0035105", 
                      "SSF81296 : 0048708", "SSF75471 : 0040574", "PF01172 : SBDS", 
                      "PF02338 : OTU", "SSF46458 : 0042568", "SSF56112 : 0047734", 
                      "SSF82919 : 0040756", "SSF53335 : 0042682", "SSF50494 : 0034813", 
                      "SSF53795 : 0040177", "SSF48726 : 0038946", "PF03334 : PhaG_MnhG_YufB", 
                      "PF02403 : Seryl_tRNA_N", "SSF57924 : 0039490", "SSF51569 : 0046606", 
                      "SSF49785 : 0044988", "SSF47807 : 0045727", "SSF55729 : 0053076", 
                      "SSF55770 : 0037603", "SSF51445 : 0042697", "SSF57059 : 0046567", 
                      "SSF50118 : 0044253", "PF04931 : DNA_pol_phi", "PF00437 : GSPII_E", 
                      "SSF50814 : 0047968", "PF08808 : RES", "SSF54098 : 0051152", 
                      "SSF47396 : 0041587", "SSF54211 : 0036326", "SSF57392 : 0036405", 
                      "TIGR01631 : Trypano_RHS", "SSF51905 : 0048584", "PF04189 : Gcd10p", 
                      "PF01715 : IPPT", "SSF54197 : 0044847", "SSF56091 : 0034811", 
                      "SSF49417 : 0048353", "PF02629 : CoA_binding", "TIGR01179 : galE", 
                      "PD005579 :", "SSF53448 : 0040712", "SSF48726 : 0046713", "SSF49835 : 0038471", 
                      "SSF48726 : 0041361", "SSF53067 : 0049552", "PF06022 : Cir_Bir_Yir", 
                      "PD540348 :", "SSF56784 : 0051870", "PD002101 :", "SSF50129 : 0039779", 
                      "PF01176 : eIF-1a", "SSF55729 : 0040972", "SSF50104 : 0045257", 
                      "SSF54452 : 0040116", "SSF56529 : 0049351", "SSF63867 : 0037991", 
                      "SSF51735 : 0052565", "SSF50129 : 0036385", "PF07571 : DUF1546", 
                      "TIGR00408 : proS_fam_I", "PR01550 : TOP6AFAMILY", "SSF88633 : 0047145", 
                      "SSF52833 : 0039303", "PIRSF006413 :", "TIGR00166 : S6", "PF00330 : Aconitase", 
                      "SSF55129 : 0035770", "SSF49265 : 0050829", "SSF50386 : 0035224", 
                      "SSF88688 : 0048509", "SSF53706 : 0037989", "PD054980 :", "PR00101 : ATCASE", 
                      "PF05516 : DUF757", "SSF52540 : 0039996", "SSF46689 : 0049907", 
                      "PF08976 : DUF1880", "PS50886 : TRBD", "SSF46946 : 0041471", 
                      "SSF54076 : 0048054", "PF06507 : Auxin_resp", "SSF63515 : 0037331", 
                      "SSF69635 : 0043414", "SSF53927 : 0035094", "SSF51445 : 0040488", 
                      "PF04182 : B-block_TFIIIC", "SSF53067 : 0036204", "SSF51569 : 0044871", 
                      "SSF57924 : 0050901", "SSF57095 : 0047314", "PF01217 : Clat_adaptor_s", 
                      "SSF56317 : 0037090", "PF06741 : LsmAD", "SSF47240 : 0049426", 
                      "SSF55961 : 0046017", "PF04548 : AIG1", "SSF54358 : 0046955", 
                      "SSF51445 : 0043662", "SSF53955 : 0039764", "SSF57903 : 0044739", 
                      "PF01159 : Ribosomal_L6e", "SSF50630 : 0039932", "PIRSF000735 :", 
                      "SSF46626 : 0051351", "SSF51430 : 0046647", "SSF48726 : 0042359", 
                      "SSF51556 : 0041660", "SSF53927 : 0050730", "SSF51726 : 0044190", 
                      "PF09687 : P_fal_TIGR01639", "PIRSF002090 :", "SSF56784 : 0050690", 
                      "SSF47413 : 0035201", "SSF57535 : 0046917", "SSF47391 : 0052552", 
                      "PR00990 : RIBOKINASE", "PF08585 : DUF1767", "PD012510 :", "SSF53474 : 0049928", 
                      "SSF46579 : 0037831", "SSF47769 : 0045998", "PIRSF001558 :", 
                      "SSF52029 : 0050458", "PF10494 : Stk19", "SSF52172 : 0035284", 
                      "PF01265 : Cyto_heme_lyase", "SSF46458 : 0042036", "SSF53067 : 0047359", 
                      "SSF51069 : 0036507", "SSF56112 : 0042133", "SSF49842 : 0042353", 
                      "SSF54928 : 0050727", "SSF54236 : 0035838", "SSF46626 : 0045374", 
                      "TIGR01885 : Orn_aminotrans", "SSF46785 : 0038107", "SSF53613 : 0037059", 
                      "SSF57802 : 0041476", "SSF53850 : 0048727", "SSF57501 : 0045796", 
                      "SSF54928 : 0044245", "SSF52374 : 0048269", "SSF50494 : 0040656", 
                      "PR00501 : KELCHREPEAT", "PF02493 : MORN", "SSF53901 : 0036931", 
                      "SSF109709 : 0043155", "PF08351 : DUF1726", "PF00253 : Ribosomal_S14", 
                      "SSF52833 : 0038245", "PF00378 : ECH", "SSF63491 : 0038763", 
                      "SSF50814 : 0047710", "PF03416 : Peptidase_C54", "SSF55298 : 0050969", 
                      "SSF50370 : 0041976", "PF10518 : TAT_signal", "PF01433 : Peptidase_M1", 
                      "SSF81271 : 0039446", "SSF48726 : 0049670", "SSF51069 : 0045205", 
                      "SSF51351 : 0045655", "SSF49373 : 0046227", "SSF54236 : 0050737", 
                      "SSF51905 : 0052032", "SSF56112 : 0049834", "SSF50447 : 0036956", 
                      "PD012998 :", "SSF82649 : 0043760", "SSF56436 : 0050046", "SSF50353 : 0041577", 
                      "SSF48425 : 0045924", "SSF50447 : 0052053", "SSF51735 : 0035535", 
                      "SSF52047 : 0048761", "SSF52096 : 0042334", "SSF56634 : 0045585", 
                      "TIGR00277 : HDIG", "SSF51069 : 0045126", "SSF50494 : 0048697", 
                      "PF07975 : C1_4", "SSF53720 : 0044574", "PF03142 : Chitin_synth_2", 
                      "SSF51182 : 0051431", "SSF47226 : 0046049", "SSF50814 : 0045138", 
                      "SSF54452 : 0035920", "SSF82114 : 0042150", "SSF57196 : 0053080", 
                      "SSF46934 : 0042026", "SSF53383 : 0036240", "SSF47769 : 0043773", 
                      "SSF47473 : 0039521", "SSF53850 : 0048497", "SSF53187 : 0036098", 
                      "SSF50729 : 0050088", "SSF47986 : 0036756", "PF08501 : Shikimate_dh_N", 
                      "SSF50494 : 0045561", "SSF49998 : 0035219", "SSF53271 : 0050435", 
                      "SSF56300 : 0049557", "SSF46561 : 0053140", "SSF74924 : 0050558", 
                      "SSF54416 : 0035220", "PF00763 : THF_DHG_CYH", "SSF51045 : 0038923", 
                      "SSF81296 : 0051500", "SSF52540 : 0040239", "SSF53623 : 0046487", 
                      "SSF54001 : 0038312", "PF07915 : PRKCSH", "SSF53474 : 0046202", 
                      "SSF49695 : 0048590", "SSF50729 : 0040866", "PF00288 : GHMP_kinases_N", 
                      "SSF52833 : 0043804", "SSF57652 : 0038665", "SSF53474 : 0046126", 
                      "SSF51735 : 0041512", "SSF52540 : 0051704", "SSF48371 : 0051487", 
                      "SSF49319 : 0041484", "SSF51905 : 0041886", "PR00459 : ASPEROXIDASE", 
                      "SSF55008 : 0043541", "SSF54637 : 0049396", "SSF57059 : 0046951", 
                      "SSF74650 : 0040674", "SSF52374 : 0047860", "SSF54001 : 0037200", 
                      "SSF48726 : 0047792", "SSF53686 : 0043354", "SSF49785 : 0042013", 
                      "SSF50249 : 0047679", "PIRSF001394 :", "SSF54452 : 0044538", 
                      "SSF48726 : 0044277", "SSF55455 : 0043734", "SSF57492 : 0038599", 
                      "SSF51430 : 0042530", "SSF68906 : 0038368", "SSF54575 : 0037549", 
                      "SSF49749 : 0042127", "PF01597 : GCV_H", "PR00887 : SSRCOGNITION", 
                      "SSF81296 : 0046368", "PR00714 : MAN6PISMRASE", "SSF50022 : 0044725", 
                      "PIRSF003085 :", "SSF50494 : 0043371", "SSF54427 : 0047611", 
                      "SSF48726 : 0043243", "SSF48695 : 0036613", "SSF52540 : 0040697", 
                      "SSF53383 : 0042286", "SSF55620 : 0050119", "SSF46604 : 0045808", 
                      "SSF88633 : 0042941", "SSF46785 : 0046839", "PF04083 : Abhydro_lipase", 
                      "SSF48371 : 0047241", "SSF51905 : 0039502", "SSF53623 : 0038085", 
                      "SSF81301 : 0042507", "PS50073 : COPPER_FIST_2", "SSF47095 : 0042963", 
                      "PD001129 :", "SSF47113 : 0049779", "PF05669 : SOH1", "SSF50494 : 0043603", 
                      "SSF53901 : 0038650", "SSF63380 : 0046758", "SSF52540 : 0048885", 
                      "PF03453 : MoeA_N", "SSF63411 : 0035487", "PF05964 : FYRN", "PF08647 : BRE1", 
                      "SSF56024 : 0039811", "SSF51225 : 0040127", "TIGR01352 : tonB_Cterm", 
                      "PR00391 : PITRANSFER", "PF09742 : Dymeclin", "SSF48726 : 0047556", 
                      "SSF63411 : 0039394", "SSF53927 : 0052851", "SSF52540 : 0042470", 
                      "SSF51126 : 0049255", "PF08625 : Utp13", "SSF48452 : 0036851", 
                      "SSF88633 : 0035329", "PF08704 : GCD14", "PF01490 : Aa_trans", 
                      "SSF90229 : 0043226", "SSF56918 : 0040493", "PF01070 : FMN_dh", 
                      "PF01545 : Cation_efflux", "SSF54495 : 0051700", "SSF53474 : 0039577", 
                      "SSF82153 : 0041720", "SSF54452 : 0037150", "SSF51069 : 0048038", 
                      "SSF55298 : 0048608", "SSF53720 : 0036174", "SSF51011 : 0045463", 
                      "SSF56235 : 0043959", "SSF49417 : 0041017", "SSF51735 : 0050890", 
                      "SSF47473 : 0040758", "TIGR01879 : hydantase", "SSF57783 : 0050588", 
                      "SSF54826 : 0041567", "SSF52425 : 0042878", "SSF47769 : 0048775", 
                      "SSF49503 : 0041409", "SSF52402 : 0040189", "SSF49785 : 0047060", 
                      "SSF51011 : 0045946", "SSF57196 : 0035016", "PF07724 : AAA_2", 
                      "PF05812 : Herpes_BLRF2", "PF03490 : Varsurf_PPLC", "SSF53335 : 0041551", 
                      "SSF51445 : 0039655", "SSF54373 : 0035118", "TIGR00338 : serB", 
                      "SSF53218 : 0051200", "SSF53850 : 0035192", "TIGR00562 : proto_IX_ox", 
                      "SSF48726 : 0045266", "PD014111 :", "PF01521 : Fe-S_biosyn", 
                      "SSF82114 : 0048215", "SSF56655 : 0039685", "SSF51735 : 0053286", 
                      "SSF48498 : 0043287", "SSF103025 : 0045002", "SSF55920 : 0035370", 
                      "SSF81324 : 0051014", "SSF63393 : 0049274", "SSF75445 : 0040525", 
                      "TIGR00251 : TIGR00251", "PF02078 : Synapsin", "PD004057 :", 
                      "SSF54637 : 0035879", "SSF54277 : 0035883", "PR01315 : BATTENIN", 
                      "PF00444 : Ribosomal_L36", "SSF51395 : 0038735", "SSF53187 : 0040437", 
                      "PF05768 : DUF836", "SSF57302 : 0041490", "SSF51569 : 0042739", 
                      "SSF50692 : 0036122", "SSF56219 : 0041556", "SSF53901 : 0044181", 
                      "SSF54211 : 0040285", "SSF63411 : 0037285", "SSF56317 : 0046590", 
                      "SSF50044 : 0050508", "SSF51230 : 0039287", "SSF54211 : 0038464", 
                      "SSF51556 : 0039842", "PF05495 : zf-CHY", "SSF52540 : 0051831", 
                      "SSF110069 : 0051124", "SSF53137 : 0042050", "PF03636 : Glyco_hydro_65N", 
                      "PF01527 : Transposase_8", "SSF54637 : 0048889", "PF03114 : BAR", 
                      "PF04110 : APG12", "SSF54928 : 0052898", "PF04563 : RNA_pol_Rpb2_1", 
                      "SSF52343 : 0034955", "PS50928 : ABC_TM1", "SSF48208 : 0046166", 
                      "SSF51110 : 0041508", "SSF51735 : 0040465", "PF00989 : PAS", 
                      "SSF50891 : 0042879", "SSF47655 : 0035524", "SSF81296 : 0046920", 
                      "SSF53822 : 0053377", "SSF52129 : 0038957", "SSF48726 : 0045757", 
                      "SSF50447 : 0050448", "PF04774 : HABP4_PAI-RBP1", "SSF53448 : 0050959", 
                      "PF07753 : DUF1609", "SSF47220 : 0047128", "PF00070 : Pyr_redox", 
                      "SSF56425 : 0035990", "SSF48695 : 0045213", "SSF49785 : 0039837", 
                      "SSF46458 : 0044646", "PF01754 : zf-A20", "SSF57059 : 0041920", 
                      "PF02637 : GatB_Yqey", "SSF69340 : 0039956", "PS50013 : CHROMO_2", 
                      "SSF53901 : 0038651", "SSF56512 : 0036393", "SSF46689 : 0045820", 
                      "SSF51445 : 0044531", "SSF52058 : 0047619", "PS51253 : HTH_CENPB", 
                      "PF08190 : PIH1", "SSF51269 : 0035874", "SSF51445 : 0045828", 
                      "SSF57016 : 0045673", "SSF57501 : 0038531", "SSF51182 : 0046334", 
                      "PIRSF037949 :", "SSF52540 : 0050356", "SSF50249 : 0042016", 
                      "PF01189 : Nol1_Nop2_Fmu", "SSF63748 : 0043740", "SSF69864 : 0039978", 
                      "SSF53659 : 0046187", "PS50160 : DNA_LIGASE_A3", "SSF53955 : 0036652", 
                      "SSF54928 : 0042061", "SSF56112 : 0046042", "SSF47986 : 0036251", 
                      "SSF54768 : 0037064", "SSF81321 : 0044248", "SSF55681 : 0050689", 
                      "PF00899 : ThiF", "SSF51735 : 0047178", "SSF53633 : 0052030", 
                      "PF04652 : DUF605", "SSF53383 : 0045909", "SSF63411 : 0048875", 
                      "PD004104 :", "PF00417 : Ribosomal_S3_N", "PF02615 : Ldh_2", 
                      "SSF50814 : 0035357", "SSF50465 : 0039671", "SSF102705 : 0052969", 
                      "SSF56672 : 0036055", "SSF47266 : 0037382", "SSF52540 : 0050775", 
                      "SSF46458 : 0045366", "SSF55083 : 0035902", "SSF63748 : 0053036", 
                      "SSF47933 : 0042046", "SSF69635 : 0040365", "SSF69635 : 0039887", 
                      "SSF57716 : 0050853", "SSF48065 : 0044151", "SSF47413 : 0051630", 
                      "SSF50249 : 0047473", "SSF53474 : 0045824", "SSF54452 : 0038699", 
                      "SSF51206 : 0051666", "TIGR01225 : hutH", "PF05091 : eIF-3_zeta", 
                      "SSF56574 : 0041076", "SSF52317 : 0047771", "SSF48425 : 0051097", 
                      "SSF54928 : 0037591", "SSF52540 : 0048266", "SSF48613 : 0052581", 
                      "SSF56801 : 0044590", "SSF57095 : 0050697", "SSF53067 : 0036764", 
                      "SSF54928 : 0047422", "SSF50022 : 0044425", "SSF52317 : 0037903", 
                      "SSF46785 : 0046987", "PF10228 : DUF2228", "SSF55424 : 0041394", 
                      "SSF52540 : 0049537", "SSF52518 : 0048896", "SSF50729 : 0044633", 
                      "SSF52833 : 0039300", "SSF56655 : 0050973", "SSF75217 : 0039893", 
                      "SSF51569 : 0048611", "PF03483 : B3_4", "SSF55874 : 0044566", 
                      "SSF48726 : 0044546", "SSF51161 : 0042958", "SSF75005 : 0050007", 
                      "TIGR00091 : TIGR00091", "SSF53067 : 0051804", "SSF55008 : 0035028", 
                      "PD002673 :", "SSF54637 : 0042455", "SSF48726 : 0040259", "SSF56235 : 0043427", 
                      "SSF51735 : 0039291", "SSF46785 : 0037713", "PF00425 : Chorismate_bind", 
                      "TIGR01438 : TGR", "SSF57196 : 0040142", "SSF52317 : 0047898", 
                      "SSF81296 : 0052467", "SSF54452 : 0036280", "PF02776 : TPP_enzyme_N", 
                      "PF05018 : DUF667", "PF02074 : Peptidase_M32", "PF01163 : RIO1", 
                      "SSF56784 : 0046572", "SSF54631 : 0051258", "SSF48726 : 0052029", 
                      "SSF89392 : 0052080", "SSF53067 : 0046347", "PF04051 : TRAPP_Bet3", 
                      "TIGR01597 : PYST-B", "SSF52540 : 0035779", "SSF53706 : 0044013", 
                      "SSF54511 : 0041147", "SSF47336 : 0041986", "PS50054 : TYR_PHOSPHATASE_DUAL", 
                      "PD001032 :", "PF04101 : Glyco_tran_28_C", "PF00679 : EFG_C", 
                      "SSF57667 : 0045294", "SSF52768 : 0038224", "SSF52540 : 0035569", 
                      "PF02415 : Chlam_PMP", "PF07189 : SF3b10", "SSF50494 : 0035578", 
                      "SSF55729 : 0052347", "SSF51419 : 0043197", "PS50172 : BRCT", 
                      "PF03850 : Tfb4", "SSF51445 : 0049977", "SSF53067 : 0035721", 
                      "SSF51735 : 0038232", "SSF52768 : 0043894", "SSF50729 : 0048169", 
                      "SSF47895 : 0051951", "SSF47473 : 0044956", "SSF50729 : 0050056", 
                      "SSF49879 : 0040495", "SSF54928 : 0042123", "SSF50494 : 0042588", 
                      "SSF49830 : 0040453", "SSF49785 : 0038168", "SSF52172 : 0034842", 
                      "SSF52833 : 0046783", "PF02657 : SufE", "SSF47380 : 0047055", 
                      "SSF57059 : 0035252", "SSF55729 : 0048174", "SSF53187 : 0045232", 
                      "SSF88633 : 0045827", "PF01142 : TruD", "SSF56059 : 0047779", 
                      "SSF55307 : 0044121", "SSF52540 : 0045970", "SSF51182 : 0044480", 
                      "SSF82615 : 0049953", "SSF54211 : 0052055", "SSF49265 : 0046819", 
                      "SSF88633 : 0036176", "TIGR00552 : nadE", "SSF50044 : 0047765", 
                      "SSF52833 : 0039830", "TIGR01930 : AcCoA-C-Actrans", "SSF63763 : 0041973", 
                      "SSF74914 : 0039633", "SSF57277 : 0048951", "SSF57798 : 0039793", 
                      "SSF88633 : 0037727", "SSF49503 : 0038248", "SSF54076 : 0041936", 
                      "SSF57196 : 0035211", "SSF53187 : 0042647", "SSF57647 : 0044905", 
                      "SSF55331 : 0036547", "SSF57630 : 0047402", "SSF53822 : 0045248", 
                      "SSF52540 : 0050906", "SSF53335 : 0048524", "PF01699 : Na_Ca_ex", 
                      "SSF46689 : 0039012", "SSF48695 : 0042718", "SSF50494 : 0046290", 
                      "SSF47576 : 0040872", "SSF51998 : 0046178", "SSF49354 : 0042924", 
                      "PF01887 : DUF62", "SSF54814 : 0038591", "SSF51338 : 0044456", 
                      "SSF55486 : 0049714", "SSF55060 : 0047747", "SSF54403 : 0037137", 
                      "SSF54236 : 0046493", "PF01470 : Peptidase_C15", "SSF52283 : 0048809", 
                      "SSF51069 : 0039488", "PF00579 : tRNA-synt_1b", "SSF55620 : 0034957", 
                      "SSF47170 : 0053177", "SSF47699 : 0042396", "SSF51905 : 0038468", 
                      "SSF63411 : 0052685", "SSF46785 : 0053027", "SSF55909 : 0047563", 
                      "SSF51445 : 0039555", "PF00445 : Ribonuclease_T2", "PF09072 : TMA7", 
                      "PF07992 : Pyr_redox_2", "SSF57716 : 0036152", "SSF51735 : 0040184", 
                      "SSF50156 : 0050116", "SSF56327 : 0048187", "SSF54631 : 0052380", 
                      "SSF51735 : 0045045", "SSF56436 : 0038340", "PD010398 :", "PF01443 : Viral_helicase1", 
                      "PS50088 : ANK_REPEAT", "PD004155 :", "PF02225 : PA", "SSF57196 : 0041188", 
                      "SSF50447 : 0048252", "SSF50129 : 0036745", "SSF51658 : 0036651", 
                      "SSF46689 : 0049952", "SSF51621 : 0050125", "SSF46785 : 0036540", 
                      "SSF56601 : 0048511", "SSF51366 : 0049146", "SSF52540 : 0036318", 
                      "SSF48726 : 0042554", "SSF49899 : 0045353", "SSF109604 : 0053234", 
                      "SSF56091 : 0050929", "SSF50891 : 0051558", "SSF50044 : 0047724", 
                      "SSF52540 : 0047127", "PF08694 : DUF1782", "SSF56672 : 0043203", 
                      "SSF46689 : 0039005", "PF04086 : SRP-alpha_N", "PF04383 : KilA-N", 
                      "PF00924 : MS_channel", "SSF48371 : 0047075", "SSF53098 : 0037249", 
                      "SSF47661 : 0046792", "SSF52518 : 0052450", "PF02774 : Semialdhyde_dhC", 
                      "SSF100895 : 0044002", "SSF55729 : 0051751", "PIRSF001487 :", 
                      "SSF46894 : 0037757", "SSF53474 : 0046502", "SSF55031 : 0040487", 
                      "SSF54791 : 0050196", "SSF53748 : 0044903", "SSF50447 : 0052567", 
                      "SSF52518 : 0036596", "SSF51905 : 0046834", "SSF56300 : 0043509", 
                      "SSF55729 : 0046988", "SSF49863 : 0047492", "PIRSF037092 :", 
                      "SSF51366 : 0042903", "SSF54534 : 0043182", "SSF47220 : 0036528", 
                      "SSF57667 : 0050861", "SSF57095 : 0036554", "SSF50182 : 0047126", 
                      "SSF51735 : 0037662", "SSF50156 : 0040806", "SSF54966 : 0053381", 
                      "PF00621 : RhoGEF", "PF00167 : FGF", "SSF48726 : 0040929", "SSF46785 : 0044209", 
                      "SSF81383 : 0041352", "SSF52972 : 0046645", "PS50119 : ZF_BBOX", 
                      "SSF53933 : 0037789", "SSF54975 : 0049983", "SSF56512 : 0040839", 
                      "PF04265 : TPK_B1_binding", "PF00158 : Sigma54_activat", "SSF47699 : 0035743", 
                      "SSF57095 : 0035429", "SSF102114 : 0043105", "SSF50324 : 0048538", 
                      "SSF57302 : 0037471", "SSF88659 : 0049695", "SSF57716 : 0052418", 
                      "PS50005 : TPR", "SSF53223 : 0042181", "SSF47240 : 0048222", 
                      "SSF54506 : 0049368", "PF08339 : RTX_C", "SSF50494 : 0035683", 
                      "PF09282 : Mago-bind", "SSF50249 : 0042017", "SSF57302 : 0037959", 
                      "PF02775 : TPP_enzyme_C", "SSF54506 : 0035751", "SSF53067 : 0052166", 
                      "PIRSF005243 :", "SSF47592 : 0044367", "SSF56024 : 0037309", 
                      "SSF50729 : 0047098", "SSF63748 : 0043739", "SSF55486 : 0043540", 
                      "SSF53933 : 0043124", "SSF55021 : 0042324", "SSF52954 : 0042728", 
                      "SSF48173 : 0041500", "SSF52833 : 0050002", "SSF50814 : 0042749", 
                      "SSF49309 : 0046676", "SSF53474 : 0047078", "PIRSF000108 :", 
                      "SSF53927 : 0052373", "SSF89043 : 0041378", "SSF54452 : 0037794", 
                      "TIGR01198 : pgl", "SSF48300 : 0043353", "SSF57059 : 0040021", 
                      "SSF46785 : 0040471", "SSF54928 : 0050466", "SSF53474 : 0039526", 
                      "SSF54862 : 0044815", "PS51283 : DUSP", "PF07731 : Cu-oxidase_2", 
                      "SSF57038 : 0048315", "SSF54909 : 0048013", "SSF54913 : 0047018", 
                      "SSF52833 : 0051129", "PF01425 : Amidase", "SSF81296 : 0037334", 
                      "PF07491 : PPI_Ypi1", "PR00475 : HEXOKINASE", "SSF81648 : 0035452", 
                      "SSF52540 : 0036574", "SSF53659 : 0050895", "SSF50685 : 0035740", 
                      "PF01025 : GrpE", "PF00692 : dUTPase", "PF00521 : DNA_topoisoIV", 
                      "SSF53098 : 0049179", "SSF55909 : 0050230", "SSF51430 : 0035048", 
                      "SSF57095 : 0036605", "SSF49452 : 0036255", "SSF51445 : 0052168", 
                      "PF00276 : Ribosomal_L23", "PIRSF001123 :", "SSF53067 : 0046054", 
                      "SSF51366 : 0044632", "PIRSF004557 :", "SSF47473 : 0045378", 
                      "SSF50122 : 0035801", "SSF47473 : 0045443", "PF08513 : LisH", 
                      "SSF47240 : 0047593", "SSF55287 : 0037024", "PF08534 : Redoxin", 
                      "SSF51735 : 0050269", "SSF54556 : 0043998", "SSF54236 : 0035698", 
                      "SSF54160 : 0035510", "SSF48726 : 0046887", "SSF81767 : 0040823", 
                      "PD005378 :", "PF10447 : EXOSC1", "PS51199 : SF4_HELICASE", "SSF52777 : 0042637", 
                      "SSF52833 : 0052692", "SSF90229 : 0052241", "SSF52540 : 0050423", 
                      "SSF46626 : 0037177", "SSF51569 : 0046975", "SSF48464 : 0037071", 
                      "TIGR00495 : crvDNA_42K", "SSF47266 : 0040055", "SSF89447 : 0037061", 
                      "PF00909 : Ammonium_transp", "SSF56784 : 0051416", "SSF51658 : 0034804", 
                      "SSF53850 : 0045538", "SSF51905 : 0040819", "PF00486 : Trans_reg_C", 
                      "SSF49695 : 0045178", "SSF53383 : 0038952", "SSF47240 : 0044445", 
                      "PD038185 :", "SSF82754 : 0040755", "PR00471 : ACETATEKNASE", 
                      "SSF57095 : 0035843", "SSF55729 : 0052664", "TIGR01224 : hutI", 
                      "SSF53383 : 0048952", "SSF51735 : 0037048", "SSF81296 : 0046527", 
                      "SSF52467 : 0051405", "SSF47370 : 0037411", "SSF47823 : 0045587", 
                      "PIRSF037002 :", "SSF55486 : 0044993", "TIGR00309 : V_ATPase_subD", 
                      "SSF51905 : 0048771", "PF10599 : Nup_retrotrp_bd", "SSF52058 : 0040725", 
                      "SSF54211 : 0052560", "SSF47266 : 0035253", "SSF46785 : 0039256", 
                      "TIGR01812 : sdhA_frdA_Gneg", "SSF48464 : 0039791", "SSF48619 : 0040470", 
                      "PF01885 : PTS_2-RNA", "TIGR00149 : TIGR00149", "SSF52833 : 0049125", 
                      "SSF48208 : 0035941", "TIGR01498 : folK", "SSF46785 : 0051708", 
                      "SSF52954 : 0041424", "PR01250 : RIBOSOMALL34", "SSF52777 : 0036720", 
                      "SSF51246 : 0038538", "SSF52540 : 0045528", "TIGR00378 : cax", 
                      "SSF46689 : 0052200", "SSF55486 : 0038010", "SSF54236 : 0044358", 
                      "PIRSF016308 :", "SSF88633 : 0048616", "PF02985 : HEAT", "PF04034 : DUF367", 
                      "PF00780 : CNH", "SSF54593 : 0044215", "SSF47266 : 0045439", 
                      "SSF53067 : 0038006", "SSF63748 : 0042092", "PIRSF017233 :", 
                      "SSF50729 : 0050089", "SSF56655 : 0039095", "SSF53613 : 0044230", 
                      "PF00111 : Fer2", "SSF50022 : 0052423", "PS50143 : BIR_REPEAT_2", 
                      "SSF88633 : 0040435", "SSF47836 : 0044370", "SSF47353 : 0036227", 
                      "SSF50044 : 0047008", "SSF53067 : 0049551", "PF01253 : SUI1", 
                      "SSF52540 : 0051832", "PIRSF038120 :", "SSF56672 : 0043856", 
                      "SSF55831 : 0044026", "SSF101112 : 0041644", "PR00728 : SIGNALPTASE", 
                      "SSF49899 : 0038367", "SSF52540 : 0051331", "SSF53271 : 0050136", 
                      "SSF49899 : 0041968", "SSF53383 : 0052164", "SSF51445 : 0041135", 
                      "SSF52266 : 0046617", "SSF56235 : 0042377", "SSF49785 : 0047533", 
                      "SSF51316 : 0037813", "SSF51197 : 0046391", "SSF56815 : 0037122", 
                      "SSF54358 : 0040936", "SSF56784 : 0048428", "SSF56712 : 0038143", 
                      "SSF47576 : 0043370", "PF00852 : Glyco_transf_10", "SSF49503 : 0037391", 
                      "SSF49899 : 0038032", "SSF51735 : 0047278", "SSF53659 : 0036076", 
                      "SSF56935 : 0045398", "SSF55103 : 0036444", "SSF50044 : 0049882", 
                      "SSF109631 : 0044499", "SSF53335 : 0049671", "SSF52540 : 0040831", 
                      "SSF50249 : 0044303", "PF03015 : Sterile", "SSF53639 : 0038256", 
                      "SSF56112 : 0043658", "SSF52540 : 0046276", "PF03095 : PTPA", 
                      "SSF54928 : 0050839", "PF07651 : ANTH", "SSF47874 : 0035256", 
                      "SSF63411 : 0045938", "PIRSF037125 :", "SSF63380 : 0046685", 
                      "SSF54631 : 0051201", "SSF53474 : 0038900", "SSF52218 : 0052810", 
                      "TIGR01100 : V_ATP_synt_C", "SSF54762 : 0034792", "SSF48726 : 0040566", 
                      "SSF54285 : 0046810", "SSF54909 : 0052377", "SSF50729 : 0042632", 
                      "SSF53067 : 0049352", "SSF55874 : 0040105", "SSF47162 : 0046046", 
                      "PF09262 : PEX-1N", "PF06102 : DUF947", "SSF53383 : 0040134", 
                      "SSF49764 : 0043290", "SSF88645 : 0040289", "SSF46689 : 0052741", 
                      "SSF57038 : 0050124", "SSF51230 : 0048969", "PF08242 : Methyltransf_12", 
                      "SSF63748 : 0052413", "SSF47794 : 0035311", "SSF88633 : 0037207", 
                      "SSF53474 : 0047194", "SSF48108 : 0034967", "SSF57586 : 0043591", 
                      "SSF57048 : 0046346", "SSF102400 : 0037083", "SSF81301 : 0048838", 
                      "SSF51905 : 0036300", "SSF51905 : 0047133", "SSF54928 : 0043516", 
                      "SSF52540 : 0042605", "PF07896 : DUF1674", "SSF53098 : 0037344", 
                      "TIGR01023 : rpmG_bact", "SSF54593 : 0043693", "SSF64158 : 0037135", 
                      "SSF52343 : 0037504", "PR00120 : HATPASE", "PIRSF005590 :", "SSF47203 : 0039176", 
                      "SSF54928 : 0044542", "SSF55424 : 0036890", "SSF55194 : 0037049", 
                      "PF02779 : Transket_pyr", "SSF46934 : 0046704", "PD001884 :", 
                      "SSF55008 : 0037506", "SSF47240 : 0043064", "SSF55729 : 0049804", 
                      "SSF51206 : 0050530", "SSF57667 : 0034822", "SSF57716 : 0045905", 
                      "SSF47819 : 0036303", "SSF54184 : 0042861", "SSF54236 : 0051477", 
                      "PF00781 : DAGK_cat", "SSF53244 : 0052865", "SSF47473 : 0040064", 
                      "SSF51679 : 0040772", "PS50090 : MYB_LIKE", "SSF81343 : 0048347", 
                      "SSF51419 : 0035465", "SSF54197 : 0038272", "SSF57783 : 0050145", 
                      "SSF53335 : 0048774", "SSF50370 : 0045143", "SSF50923 : 0038776", 
                      "PF01777 : Ribosomal_L27e", "SSF51569 : 0050246", "SSF52540 : 0046941", 
                      "SSF53448 : 0037570", "SSF102110 : 0044222", "PF06278 : DUF1032", 
                      "PR01011 : GLUTPROXDASE", "SSF53697 : 0050197", "SSF49354 : 0047932", 
                      "SSF52172 : 0051229", "PR01042 : TRNASYNTHASP", "SSF50044 : 0039980", 
                      "SSF51556 : 0041949", "PIRSF001237 :", "SSF57868 : 0045371", 
                      "SSF47050 : 0044461", "SSF74650 : 0047240", "SSF82784 : 0044506", 
                      "SSF47473 : 0035873", "SSF49899 : 0038387", "PR01475 : PARKIN", 
                      "SSF48150 : 0051070", "SSF48619 : 0042415", "SSF51161 : 0044607", 
                      "SSF46689 : 0052845", "SSF51569 : 0050734", "SSF50249 : 0046800", 
                      "SSF48208 : 0043979", "SSF57095 : 0041929", "SSF51905 : 0047029", 
                      "SSF55326 : 0036050", "SSF47986 : 0045697", "SSF63491 : 0044355", 
                      "SSF47794 : 0044229", "PF00653 : BIR", "SSF52058 : 0045746", 
                      "PF08676 : MutL_C", "SSF50370 : 0043721", "PF03315 : SDH_beta", 
                      "PF00676 : E1_dh", "PS50926 : TRAM", "SSF51905 : 0035354", "SSF46626 : 0048374", 
                      "TIGR01563 : gp16_SPP1", "SSF50129 : 0046314", "SSF50037 : 0035567", 
                      "SSF51445 : 0047246", "SSF56112 : 0051133", "SSF52922 : 0036598", 
                      "SSF49562 : 0035482", "PF00639 : Rotamase", "SSF53335 : 0050242", 
                      "SSF46785 : 0035957", "SSF55068 : 0046864", "SSF47473 : 0046181", 
                      "SSF50729 : 0051791", "SSF46689 : 0038473", "PD209044 :", "PF05693 : Glycogen_syn", 
                      "SSF109604 : 0043931", "SSF51395 : 0037425", "SSF53067 : 0037167", 
                      "PF10230 : DUF2305", "SSF52096 : 0041933", "SSF63411 : 0038685", 
                      "SSF47874 : 0035226", "SSF53067 : 0045934", "SSF56672 : 0043963", 
                      "SSF74650 : 0044654", "SSF54495 : 0051244", "SSF52172 : 0047867", 
                      "PF09748 : Med10", "SSF74650 : 0039310", "PS50912 : EAR", "PF00208 : ELFV_dehydrog", 
                      "SSF47473 : 0051184", "TIGR00342 : TIGR00342", "SSF56784 : 0047540", 
                      "TIGR00640 : acid_CoA_mut_C", "PF03223 : V-ATPase_C", "SSF53955 : 0035420", 
                      "SSF64356 : 0038406", "SSF49723 : 0038208", "PF04762 : IKI3", 
                      "SSF54862 : 0039453", "SSF50494 : 0042975", "SSF51735 : 0048757", 
                      "SSF50156 : 0050057", "SSF49854 : 0043586", "SSF81901 : 0048648", 
                      "SSF64182 : 0039853", "SSF53067 : 0050789", "SSF55811 : 0050220", 
                      "PF01878 : DUF55", "PS51332 : B12_BINDING", "SSF54928 : 0045480", 
                      "SSF46785 : 0053037", "SSF57756 : 0036581", "SSF48726 : 0043802", 
                      "SSF56214 : 0037427", "SSF54403 : 0043756", "PR00998 : CRBOXYPTASET", 
                      "SSF88697 : 0049549", "SSF101166 : 0042539", "SSF55060 : 0047824", 
                      "PIRSF006205 :", "SSF101690 : 0044172", "SSF88645 : 0040596", 
                      "PF00365 : PFK", "PF03481 : SUA5", "PS50038 : FZ", "PF10262 : SelT", 
                      "SSF56854 : 0045190", "SSF48695 : 0049433", "SSF57038 : 0047608", 
                      "SSF51735 : 0041100", "SSF81296 : 0052060", "PF06978 : POP1", 
                      "PF07857 : DUF1632", "SSF53448 : 0047373", "SSF52980 : 0035433", 
                      "PF00657 : Lipase_GDSL", "SSF48726 : 0035498", "PF01722 : BolA", 
                      "SSF49348 : 0050393", "PF00794 : PI3K_rbd", "SSF52833 : 0051602", 
                      "SSF52540 : 0048868", "PF08761 : dUTPase_2", "SSF47413 : 0035010", 
                      "SSF81321 : 0038383", "SSF50494 : 0049389", "SSF55486 : 0039410", 
                      "SSF54292 : 0041344", "SSF47266 : 0046185", "PS50045 : SIGMA54_INTERACT_4", 
                      "SSF54909 : 0049174", "PF01302 : CAP_GLY", "SSF53335 : 0050234", 
                      "SSF54928 : 0050576", "TIGR00365 : TIGR00365", "SSF47336 : 0044845", 
                      "PS51030 : NUCLEAR_REC_DBD_2", "SSF54292 : 0051017", "SSF49503 : 0036679", 
                      "SSF52540 : 0043790", "SSF81442 : 0035178", "SSF49417 : 0035726", 
                      "SSF51735 : 0038068", "SSF69635 : 0052716", "PR00971 : RIBOSOMALS10", 
                      "SSF53807 : 0052519", "SSF51905 : 0044098", "PIRSF005856 :", 
                      "SSF53756 : 0037413", "TIGR00658 : orni_carb_tr", "SSF47113 : 0043120", 
                      "SSF48371 : 0038440", "SSF51351 : 0035103", "PF00232 : Glyco_hydro_1", 
                      "SSF57392 : 0035631", "SSF46774 : 0039004", "SSF51735 : 0042906", 
                      "SSF54984 : 0035365", "SSF52540 : 0051485", "PR00219 : SYNAPTOBREVN", 
                      "SSF51905 : 0045797", "SSF55785 : 0042020", "SSF51445 : 0036854", 
                      "SSF53706 : 0037183", "SSF51905 : 0036301", "SSF53335 : 0043063", 
                      "SSF57095 : 0046073", "SSF53955 : 0039741", "PF01531 : Glyco_transf_11", 
                      "SSF48371 : 0052018", "SSF53706 : 0040209", "SSF49309 : 0047885", 
                      "SSF46458 : 0039186", "PIRSF000124 :", "SSF75217 : 0044065", 
                      "SSF51905 : 0036458", "SSF50729 : 0037589", "SSF47240 : 0047609", 
                      "SSF52016 : 0045759", "PF02201 : SWIB", "SSF51316 : 0051445", 
                      "SSF49363 : 0045595", "SSF49265 : 0050634", "SSF63411 : 0052687", 
                      "SSF55205 : 0044235", "SSF46785 : 0044508", "PS50238 : RHOGAP", 
                      "SSF47954 : 0044784", "SSF51621 : 0049391", "SSF48295 : 0047496", 
                      "PF07691 : PA14", "SSF47266 : 0037849", "SSF69065 : 0044214", 
                      "PIRSF030333 :", "SSF54593 : 0047558", "PR00851 : XRODRMPGMNTB", 
                      "SSF51182 : 0037842", "PF03953 : Tubulin_C", "SSF54211 : 0035363", 
                      "SSF53335 : 0051842", "PF01501 : Glyco_transf_8", "SSF54197 : 0044881", 
                      "SSF55681 : 0041283", "PF05871 : ESCRT-II", "SSF48726 : 0052800", 
                      "SSF52210 : 0045445", "SSF55826 : 0044800", "SSF52833 : 0034984", 
                      "PD001272 :", "SSF54189 : 0039573", "SSF47364 : 0037523", "SSF51971 : 0035804", 
                      "SSF53098 : 0049961", "TIGR01229 : rocF_arginase", "SSF49723 : 0040594", 
                      "SSF51569 : 0036314", "SSF47473 : 0039049", "PF01553 : Acyltransferase", 
                      "SSF53633 : 0053023", "SSF57716 : 0052417", "PIRSF033096 :", 
                      "SSF57196 : 0039225", "SSF81799 : 0040828", "SSF52833 : 0044593", 
                      "PF04542 : Sigma70_r2", "SSF63380 : 0049949", "SSF52418 : 0046005", 
                      "SSF55979 : 0042370", "SSF54292 : 0052178", "SSF52440 : 0050407", 
                      "SSF50939 : 0036842", "SSF81296 : 0034965", "SSF52425 : 0046364", 
                      "SSF50814 : 0044077", "PF07479 : NAD_Gly3P_dh_C", "SSF56112 : 0047088", 
                      "TIGR00566 : trpG_papA", "SSF51569 : 0051011", "SSF54495 : 0050764", 
                      "PF00890 : FAD_binding_2", "SSF50022 : 0051878", "PS50822 : PIWI", 
                      "PF03911 : Sec61_beta", "SSF56112 : 0038530", "SSF56091 : 0050886", 
                      "SSF54966 : 0046970", "SSF52343 : 0042754", "SSF48264 : 0039101", 
                      "PF04935 : SURF6", "SSF90209 : 0052255", "PF01170 : UPF0020", 
                      "PF08164 : TRAUB", "SSF51735 : 0052326", "SSF47473 : 0037031", 
                      "SSF50249 : 0040087", "PF02114 : Phosducin", "SSF56712 : 0036294", 
                      "TIGR01847 : bacteriocin_sig", "SSF53474 : 0037443", "SSF46689 : 0035403", 
                      "PF08903 : DUF1846", "TIGR00967 : 3a0501s007", "SSF52980 : 0037863", 
                      "SSF46689 : 0038558", "SSF55770 : 0045541", "PF03335 : Phage_fiber", 
                      "SSF52499 : 0039077", "SSF53098 : 0049844", "PF01133 : ER", "SSF55874 : 0043038", 
                      "SSF54980 : 0052057", "SSF56796 : 0039694", "SSF54211 : 0039904", 
                      "SSF54211 : 0051753", "SSF51045 : 0044033", "SSF46626 : 0036626", 
                      "SSF57262 : 0038692", "SSF51445 : 0048992", "SSF51445 : 0050447", 
                      "PS50111 : CHEMOTAXIS_TRANSDUC_2", "SSF54897 : 0042527", "SSF51556 : 0047525", 
                      "PF03959 : FSH1", "PF00147 : Fibrinogen_C", "PF01184 : Grp1_Fun34_YaaH", 
                      "SSF52922 : 0040414", "SSF51735 : 0036664", "PF04054 : Not1", 
                      "SSF47807 : 0034921", "SSF54736 : 0036150", "SSF48019 : 0039710", 
                      "SSF81296 : 0048958", "SSF47781 : 0047794", "PS50196 : RANBD1", 
                      "SSF54637 : 0046019", "PF07792 : DUF1630", "SSF63748 : 0041202", 
                      "TIGR02499 : HrpE_YscL_not", "SSF74788 : 0040461", "SSF81585 : 0039653", 
                      "SSF52833 : 0045743", "TIGR00407 : proA", "SSF48225 : 0037697", 
                      "SSF57868 : 0040717", "SSF49503 : 0041324", "SSF54593 : 0048209", 
                      "SSF46785 : 0043517", "SSF55486 : 0048517", "SSF53167 : 0050257", 
                      "SSF52540 : 0039270", "SSF49562 : 0052179", "SSF51430 : 0039027", 
                      "PF04442 : CtaG_Cox11", "PIRSF036805 :", "PS50881 : S5_DSRBD", 
                      "SSF57802 : 0036411", "SSF47648 : 0045472", "SSF54928 : 0039640", 
                      "SSF52440 : 0037275", "SSF52009 : 0047134", "SSF57716 : 0050585", 
                      "SSF54236 : 0046958", "SSF48097 : 0038715", "PS51154 : MACRO", 
                      "PS50954 : LEM", "SSF55031 : 0051390", "SSF48726 : 0035257", 
                      "SSF53613 : 0052553", "SSF88633 : 0036090", "TIGR00197 : yjeF_nterm", 
                      "SSF48726 : 0035806", "PF01080 : Presenilin", "SSF48371 : 0040848", 
                      "PR00983 : TRNASYNTHCYS", "SSF46785 : 0038992", "SSF48371 : 0048921", 
                      "PF03835 : Rad4", "SSF50156 : 0045547", "SSF56784 : 0052765", 
                      "SSF49863 : 0047207", "SSF48403 : 0047744", "TIGR01822 : 2am3keto_CoA", 
                      "SSF47240 : 0049510", "PF00988 : CPSase_sm_chain", "SSF55424 : 0042578", 
                      "SSF50494 : 0047907", "SSF81296 : 0036575", "SSF51905 : 0038449", 
                      "SSF48508 : 0042350", "SSF54928 : 0050577", "SSF49384 : 0037890", 
                      "SSF52467 : 0046545", "PIRSF000497 :", "SSF53067 : 0037166", 
                      "SSF90234 : 0039838", "SSF48619 : 0044685", "PF02816 : Alpha_kinase", 
                      "SSF51366 : 0049629", "SSF49695 : 0041510", "SSF55060 : 0040130", 
                      "SSF54719 : 0042885", "SSF55961 : 0052677", "SSF53383 : 0050754", 
                      "SSF49899 : 0051761", "SSF49562 : 0046160", "SSF110014 : 0043809", 
                      "SSF49265 : 0050825", "SSF47040 : 0040040", "SSF47473 : 0048602", 
                      "PD133034 :", "PF03715 : Noc2", "SSF49348 : 0049038", "SSF51621 : 0037440", 
                      "SSF51445 : 0043588", "PIRSF036424 :", "SSF57196 : 0045467", 
                      "SSF51569 : 0046665", "PD350662 :", "PF00467 : KOW", "PIRSF017321 :", 
                      "SSF51219 : 0044946", "SSF53254 : 0043022", "SSF52096 : 0051719", 
                      "SSF46785 : 0047910", "PS50213 : FAS1", "PS50018 : RAS_GTPASE_ACTIV_2", 
                      "SSF55073 : 0046871", "SSF57196 : 0048447", "SSF55486 : 0039989", 
                      "SSF56534 : 0044074", "SSF57667 : 0050860", "SSF57716 : 0052306", 
                      "SSF57184 : 0048419", "SSF56024 : 0039810", "SSF56436 : 0036827", 
                      "SSF57095 : 0043630", "SSF50814 : 0041772", "PF05882 : ACN9", 
                      "PF02358 : Trehalose_PPase", "SSF51735 : 0052745", "SSF103642 : 0042099", 
                      "PS50895 : SURF1", "SSF52540 : 0048154", "PF10391 : DNA_pol_lambd_f", 
                      "SSF57196 : 0036644", "SSF57716 : 0049246", "PF07562 : NCD3G", 
                      "SSF53271 : 0046909", "PF04889 : Cwf_Cwc_15", "SSF54534 : 0044934", 
                      "SSF48726 : 0035009", "SSF52096 : 0041649", "SSF57630 : 0042296", 
                      "SSF50104 : 0052479", "SSF50370 : 0043992", "TIGR01517 : ATPase-IIB_Ca", 
                      "PF07202 : Tcp10_C", "SSF55003 : 0037392", "SSF48726 : 0037449", 
                      "SSF57850 : 0050469", "PS50053 : UBIQUITIN_2", "SSF54534 : 0039667", 
                      "SSF50156 : 0050836", "SSF51182 : 0050652", "PS50850 : MFS", 
                      "PF01738 : DLH", "SSF50156 : 0050516", "PR00420 : RNGMNOXGNASE", 
                      "PS51286 : RAP", "PF00109 : ketoacyl-synt", "SSF53800 : 0047228", 
                      "SSF49562 : 0045699", "SSF54236 : 0050773", "PF01782 : RimM", 
                      "SSF88633 : 0037325", "SSF53790 : 0050153", "SSF52518 : 0044479", 
                      "SSF57027 : 0045347", "SSF46934 : 0052263", "SSF46626 : 0042834", 
                      "PF04005 : Hus1", "TIGR00222 : panB", "SSF51735 : 0051996", "SSF51011 : 0047490", 
                      "SSF53067 : 0046011", "SSF52833 : 0045280", "PD353340 :", "PS51072 : MHD", 
                      "SSF81601 : 0034913", "PS50104 : TIR", "SSF48726 : 0040404", 
                      "PF01667 : Ribosomal_S27e", "SSF48726 : 0043943", "SSF56059 : 0035376", 
                      "SSF51206 : 0048882", "SSF81296 : 0052345", "PF09067 : EpoR_lig-bind", 
                      "TIGR00674 : dapA", "SSF51445 : 0044130", "PF05002 : SGS", "PR01653 : TCTPROTEIN", 
                      "PF01182 : Glucosamine_iso", "SSF50729 : 0046779", "SSF53920 : 0037511", 
                      "SSF75011 : 0047643", "SSF51445 : 0044643", "SSF49265 : 0053184", 
                      "SSF55447 : 0041228", "SSF51905 : 0040688", "SSF51735 : 0051901", 
                      "PS51008 : MULTIHEME_CYTC", "SSF55681 : 0035194", "PF09268 : Clathrin-link", 
                      "TIGR01211 : ELP3", "SSF46689 : 0035402", "PF05191 : ADK_lid", 
                      "PF04135 : Nop10p", "SSF50494 : 0036371", "SSF51445 : 0038713", 
                      "SSF55729 : 0052829", "SSF53686 : 0050122", "SSF49401 : 0041872", 
                      "PF03465 : eRF1_3", "SSF50692 : 0044984", "PR01162 : ALPHATUBULIN", 
                      "TIGR01602 : PY-rept-46", "SSF47203 : 0052369", "PD007062 :", 
                      "PF00185 : OTCace", "SSF52833 : 0043574", "PF00137 : ATP-synt_C", 
                      "PF00842 : Ala_racemase_C", "SSF69635 : 0047757", "SSF55961 : 0050822", 
                      "SSF46626 : 0039130", "SSF55239 : 0039144", "SSF54098 : 0036642", 
                      "SSF55895 : 0043599", "SSF47807 : 0045961", "SSF48150 : 0047788", 
                      "SSF49899 : 0050427", "SSF56327 : 0046124", "PF00518 : E6", "SSF51658 : 0047759", 
                      "PD025234 :", "PR01502 : UXTPROTEIN", "SSF57783 : 0049068", "PF04397 : LytTR", 
                      "SSF51905 : 0046514", "SSF50729 : 0037579", "SSF50939 : 0041541", 
                      "SSF69349 : 0050027", "SSF52283 : 0042449", "SSF57850 : 0043306", 
                      "SSF49265 : 0050506", "SSF54211 : 0044774", "SSF52374 : 0043348", 
                      "SSF48508 : 0038584", "SSF48726 : 0037378", "SSF101288 : 0044732", 
                      "SSF47095 : 0039979", "SSF57667 : 0045693", "SSF47364 : 0037775", 
                      "PF10252 : PP28", "SSF54292 : 0050692", "PS50867 : PRE_SET", 
                      "SSF50386 : 0045738", "PF05450 : Nicastrin", "TIGR01234 : L-ribulokinase", 
                      "SSF47769 : 0043787", "SSF50249 : 0047147", "SSF46785 : 0043095", 
                      "SSF53218 : 0044572", "PS51147 : PFTA", "SSF57501 : 0035043", 
                      "SSF48592 : 0041815", "PF04188 : Mannosyl_trans2", "SSF48726 : 0042750", 
                      "SSF53187 : 0052853", "PF03756 : AfsA", "PF01336 : tRNA_anti", 
                      "PF01194 : RNA_pol_N", "SSF46785 : 0045968", "SSF46626 : 0046083", 
                      "SSF75304 : 0052574", "PS01124 : HTH_ARAC_FAMILY_2", "PF01134 : GIDA", 
                      "SSF53067 : 0041303", "SSF50249 : 0050502", "SSF50182 : 0038430", 
                      "SSF55298 : 0042282", "SSF52507 : 0043058", "SSF49879 : 0052027", 
                      "SSF47113 : 0046611", "SSF51182 : 0051659", "SSF52540 : 0052823", 
                      "SSF50800 : 0034858", "SSF53098 : 0052065", "SSF57701 : 0036046", 
                      "SSF57392 : 0036291", "SSF69322 : 0047732", "SSF102588 : 0044238", 
                      "SSF49503 : 0040321", "SSF54236 : 0044265", "SSF53474 : 0047451", 
                      "SSF74924 : 0052214", "SSF47113 : 0034938", "SSF100895 : 0043934", 
                      "SSF52172 : 0046294", "SSF52218 : 0049507", "SSF57362 : 0035506", 
                      "PF01128 : IspD", "PF04628 : Sedlin_N", "SSF50729 : 0037469", 
                      "SSF55021 : 0052152", "SSF52218 : 0039436", "SSF52317 : 0052668", 
                      "PF05425 : CopD", "PF05057 : DUF676", "SSF46785 : 0035566", "SSF53738 : 0040058", 
                      "PF02636 : DUF185", "SSF47769 : 0049862", "PF08590 : DUF1771", 
                      "SSF46458 : 0046411", "PIRSF026991 :", "SSF81296 : 0052435", 
                      "PF01938 : TRAM", "PF00397 : WW", "SSF56300 : 0049468", "SSF50203 : 0037158", 
                      "SSF50044 : 0038043", "SSF50386 : 0049639", "SSF48695 : 0046269", 
                      "SSF50677 : 0049869", "SSF51905 : 0045519", "SSF48230 : 0042690", 
                      "SSF54160 : 0036691", "SSF51556 : 0048352", "SSF49265 : 0046555", 
                      "SSF56029 : 0045369", "SSF49319 : 0047274", "PF01140 : Gag_MA", 
                      "SSF48600 : 0045614", "SSF49562 : 0050498", "SSF57889 : 0044625", 
                      "PD127999 :", "PF01028 : Topoisom_I", "PF03725 : RNase_PH_C", 
                      "SSF57027 : 0040888", "PS50833 : BRIX", "SSF56235 : 0036148", 
                      "PF05646 : DUF786", "PIRSF001109 :", "SSF46565 : 0037729", "SSF57501 : 0041636", 
                      "SSF54236 : 0052075", "PF10597 : U5_2-snRNA_bdg", "SSF50249 : 0035732", 
                      "SSF48113 : 0035183", "SSF57059 : 0047859", "SSF53474 : 0047974", 
                      "SSF52540 : 0048226", "SSF50630 : 0035430", "SSF51430 : 0040614", 
                      "TIGR00730 : TIGR00730", "SSF81296 : 0046222", "PF10520 : Kua-UEV1_localn", 
                      "SSF57302 : 0040008", "SSF47060 : 0037853", "SSF51735 : 0035389", 
                      "SSF89392 : 0039251", "SSF56601 : 0035694", "SSF89392 : 0039250", 
                      "PF02542 : YgbB", "PF07937 : DUF1686", "SSF46785 : 0043590", 
                      "SSF56601 : 0052485", "SSF55729 : 0041465", "SSF55909 : 0039495", 
                      "SSF54495 : 0047526", "SSF54631 : 0050302", "SSF51989 : 0042819", 
                      "PF08617 : CGI-121", "SSF57440 : 0040396", "PF00940 : RNA_pol", 
                      "PF01351 : RNase_HII", "SSF51197 : 0052278", "SSF81514 : 0035459", 
                      "SSF51735 : 0039450", "SSF56327 : 0044812", "SSF47220 : 0043279", 
                      "SSF88723 : 0040885", "PF03969 : AFG1_ATPase", "SSF53933 : 0043375", 
                      "PF10629 : DUF2475", "TIGR00021 : rpiA", "SSF54826 : 0048446", 
                      "SSF52540 : 0038142", "SSF53271 : 0041489", "SSF55781 : 0048178", 
                      "SSF63380 : 0036369", "SSF49879 : 0052287", "SSF55729 : 0044025", 
                      "SSF51735 : 0039438", "SSF57196 : 0048473", "PF08216 : DUF1716", 
                      "SSF51621 : 0046414", "SSF50729 : 0049013", "SSF56524 : 0043687", 
                      "PS50302 : PUM", "SSF54919 : 0047706", "SSF69652 : 0039995", 
                      "PF06589 : CRA", "SSF53271 : 0049832", "SSF47203 : 0039219", 
                      "SSF55120 : 0043107", "SSF52540 : 0036815", "SSF49417 : 0049543", 
                      "SSF109604 : 0053047", "SSF51556 : 0052675", "SSF49401 : 0042171", 
                      "SSF52218 : 0049201", "SSF56327 : 0053384", "PF09801 : SYS1", 
                      "SSF53659 : 0050329", "SSF46785 : 0045285", "PS51090 : CORTACTIN", 
                      "SSF52025 : 0053257", "SSF47095 : 0039362", "SSF52402 : 0044087", 
                      "SSF49899 : 0048278", "TIGR01312 : XylB", "SSF52540 : 0049582", 
                      "PR00150 : PEPCARBXLASE", "SSF57095 : 0046184", "SSF52768 : 0050949", 
                      "PR00070 : DHFR", "SSF51011 : 0038748", "PF00694 : Aconitase_C", 
                      "PF02582 : DUF155", "SSF52540 : 0048963", "PF05903 : DUF862", 
                      "SSF47364 : 0050250", "TIGR00419 : tim", "SSF51445 : 0038749", 
                      "SSF55681 : 0035568", "SSF54534 : 0039396", "SSF52788 : 0039609", 
                      "SSF56808 : 0036641", "PD003946 :", "SSF50729 : 0046390", "SSF48726 : 0036508", 
                      "SSF54076 : 0036683", "SSF54236 : 0042200", "PF09258 : Glyco_transf_64", 
                      "PF03291 : Pox_MCEL", "PF07244 : Surf_Ag_VNR", "SSF53098 : 0037839", 
                      "SSF75005 : 0050224", "SSF50494 : 0045318", "SSF54928 : 0043639", 
                      "SSF50814 : 0035900", "PF10197 : Cir_N", "SSF54826 : 0042272", 
                      "SSF55856 : 0043686", "SSF52540 : 0050943", "SSF47954 : 0038276", 
                      "SSF50494 : 0047218", "SSF53774 : 0035046", "PD004495 :", "SSF110399 : 0050717", 
                      "SSF52540 : 0046711", "SSF49899 : 0036674", "PF03547 : Mem_trans", 
                      "SSF47616 : 0035175", "SSF48726 : 0046363", "PF00749 : tRNA-synt_1c", 
                      "SSF81822 : 0040997", "SSF53335 : 0048438", "SSF54452 : 0041354", 
                      "SSF56634 : 0043623", "TIGR00092 : TIGR00092", "SSF51604 : 0041087", 
                      "SSF51658 : 0045685", "SSF55681 : 0043263", "PF00332 : Glyco_hydro_17", 
                      "SSF53383 : 0052943", "SSF81496 : 0035455", "SSF46458 : 0035092", 
                      "SSF54236 : 0052076", "PR00056 : HSFDOMAIN", "SSF46785 : 0038753", 
                      "SSF50891 : 0036049", "SSF53720 : 0041750", "SSF56529 : 0041438", 
                      "SSF49562 : 0049647", "SSF53613 : 0046332", "SSF51905 : 0040602", 
                      "SSF56925 : 0042810", "SSF52768 : 0042422", "PF01624 : MutS_I", 
                      "SSF50447 : 0043457", "SSF54328 : 0042944", "SSF89817 : 0041950", 
                      "SSF52540 : 0053247", "SSF52833 : 0047046", "SSF74650 : 0040407", 
                      "SSF47203 : 0052089", "SSF51101 : 0039439", "SSF53955 : 0038053", 
                      "SSF51445 : 0037002", "SSF88697 : 0049288", "SSF48034 : 0035522", 
                      "SSF54826 : 0035663", "SSF46689 : 0034887", "SSF52799 : 0043147", 
                      "PF01656 : CbiA", "SSF48726 : 0050983", "TIGR00327 : secE_euk_arch", 
                      "SSF50037 : 0035782", "SSF52540 : 0040825", "SSF52833 : 0034816", 
                      "SSF52087 : 0035203", "SSF54076 : 0035041", "SSF52540 : 0051498", 
                      "PF10571 : UPF0547", "PF08179 : SspP", "SSF82199 : 0041208", 
                      "PF02796 : HTH_7", "SSF53474 : 0037421", "SSF51197 : 0046468", 
                      "SSF51445 : 0040843", "SSF54849 : 0049415", "PF01755 : Glyco_transf_25", 
                      "SSF51161 : 0045573", "PR00108 : THYMDSNTHASE", "SSF53955 : 0034793", 
                      "PIRSF003025 :", "SSF48726 : 0043705", "PF09768 : Peptidase_M76", 
                      "SSF54403 : 0050887", "SSF50199 : 0039679", "SSF47616 : 0037806", 
                      "PF04245 : NA37", "SSF51430 : 0035011", "SSF50129 : 0038267", 
                      "SSF88697 : 0039128", "SSF47226 : 0035793", "SSF56235 : 0046214", 
                      "SSF51735 : 0044225", "SSF56925 : 0041003", "SSF48726 : 0053026", 
                      "SSF49899 : 0041680", "SSF56935 : 0037514", "SSF49899 : 0042869", 
                      "SSF55008 : 0041127", "SSF109728 : 0042211", "SSF50156 : 0044311", 
                      "SSF50156 : 0040455", "SSF54897 : 0049516", "SSF53597 : 0043051", 
                      "PF04968 : CHORD", "SSF50044 : 0045082", "SSF56762 : 0045288", 
                      "SSF55239 : 0043190", "PF03124 : EXS", "SSF54637 : 0049345", 
                      "SSF51735 : 0041244", "PF00667 : FAD_binding_1", "PF10596 : U6-snRNA_bdg", 
                      "SSF51984 : 0045481", "PS50882 : YTH", "SSF57552 : 0043970", 
                      "PF00141 : peroxidase", "SSF54292 : 0044864", "SSF53597 : 0036395", 
                      "SSF81648 : 0035489", "SSF53756 : 0042392", "PF02002 : TFIIE_alpha", 
                      "SSF48592 : 0044965", "SSF57059 : 0036229", "PF08900 : DUF1845", 
                      "SSF48179 : 0038855", "PF01053 : Cys_Met_Meta_PP", "SSF47384 : 0039683", 
                      "PD003462 :", "SSF55424 : 0037490", "SSF46626 : 0037291", "SSF49562 : 0045562", 
                      "PD001103 :", "PF05746 : DALR_1", "SSF51658 : 0036310", "PF00460 : Flg_bb_rod", 
                      "SSF56235 : 0043429", "SSF50044 : 0038235", "SSF51735 : 0042575", 
                      "SSF69360 : 0038354", "SSF55804 : 0034911", "PF03343 : SART-1", 
                      "SSF49265 : 0050828", "SSF46785 : 0037861", "SSF50692 : 0038359", 
                      "SSF50044 : 0045799", "TIGR00329 : gcp_kae1", "SSF110111 : 0043679", 
                      "SSF52540 : 0045717", "SSF50129 : 0048862", "SSF52266 : 0051808", 
                      "SSF55347 : 0043069", "SSF57716 : 0040769", "SSF53933 : 0042517", 
                      "SSF103365 : 0044267", "PF09368 : Sas10_Utp3_C", "PF02812 : ELFV_dehydrog_N", 
                      "SSF48464 : 0049499", "SSF51126 : 0038982", "SSF49879 : 0050718", 
                      "SSF53254 : 0042788", "SSF54675 : 0041677", "SSF57667 : 0052464", 
                      "SSF51445 : 0047122", "SSF54637 : 0048789", "SSF47240 : 0035460", 
                      "SSF74650 : 0036534", "SSF55331 : 0042021", "SSF51735 : 0041129", 
                      "SSF51556 : 0047006", "SSF54416 : 0050378", "SSF64268 : 0041789", 
                      "SSF51735 : 0046629", "SSF50156 : 0051242", "SSF52540 : 0048272", 
                      "SSF48726 : 0047976", "SSF56784 : 0039843", "SSF51735 : 0048799", 
                      "SSF55298 : 0042717", "PIRSF002133 :", "SSF53098 : 0035188", 
                      "SSF55307 : 0049230", "SSF56752 : 0037053", "SSF52540 : 0038731", 
                      "TIGR00750 : lao", "PS50017 : DEATH_DOMAIN", "SSF57095 : 0040615", 
                      "SSF50104 : 0047804", "PF01522 : Polysacc_deac_1", "SSF47874 : 0038746", 
                      "SSF75005 : 0051199", "SSF54713 : 0050903", "SSF51197 : 0047666", 
                      "TIGR02251 : HIF-SF_euk", "SSF53474 : 0046670", "SSF50370 : 0038759", 
                      "SSF57774 : 0042140", "SSF53671 : 0034830", "SSF50989 : 0035885", 
                      "SSF82282 : 0048902", "SSF54534 : 0040805", "SSF57196 : 0045115", 
                      "SSF52833 : 0051532", "SSF53167 : 0048112", "SSF46785 : 0052801", 
                      "SSF49417 : 0045953", "SSF48726 : 0038649", "SSF54862 : 0037487", 
                      "SSF51230 : 0040434", "SSF53098 : 0050187", "SSF53850 : 0042594", 
                      "SSF51679 : 0040669", "SSF48726 : 0038862", "PF08771 : Rapamycin_bind", 
                      "SSF51569 : 0034882", "SSF50729 : 0052260", "SSF63380 : 0037116", 
                      "SSF52777 : 0049362", "SSF50969 : 0045354", "SSF51011 : 0050403", 
                      "SSF57362 : 0035719", "SSF53067 : 0049353", "SSF47060 : 0043152", 
                      "SSF81296 : 0044347", "PS50137 : DS_RBD", "PD304020 :", "SSF52833 : 0041256", 
                      "SSF54373 : 0041376", "PF00628 : PHD", "SSF53137 : 0047384", 
                      "SSF56436 : 0046041", "PF01641 : SelR", "PF00441 : Acyl-CoA_dh_1", 
                      "SSF48464 : 0046653", "SSF51604 : 0049077", "PF00826 : Ribosomal_L10e", 
                      "SSF75005 : 0051316", "SSF55550 : 0040808", "SSF48726 : 0036134", 
                      "SSF48239 : 0045616", "SSF49899 : 0045172", "PF02803 : Thiolase_C", 
                      "SSF57095 : 0050661", "SSF55608 : 0035312", "SSF57196 : 0036113", 
                      "SSF47240 : 0042025", "PF00006 : ATP-synt_ab", "SSF50814 : 0035442", 
                      "PF01872 : RibD_C", "SSF81665 : 0049473", "SSF52540 : 0037370", 
                      "PF05804 : KAP", "SSF49899 : 0039321", "SSF53697 : 0047090", 
                      "SSF50494 : 0048628", "SSF53335 : 0039530", "SSF52096 : 0041934", 
                      "SSF51445 : 0047094", "SSF51679 : 0049163", "SSF50494 : 0037051", 
                      "SSF53098 : 0040061", "PIRSF008765 :", "SSF52210 : 0037189", 
                      "SSF51569 : 0046689", "SSF49503 : 0042368", "SSF49265 : 0049874", 
                      "SSF53448 : 0046877", "SSF56436 : 0043082", "SSF52540 : 0052841", 
                      "SSF56317 : 0037148", "PF03676 : UPF0183", "SSF51569 : 0045763", 
                      "PD001009 :", "SSF48019 : 0043791", "SSF46774 : 0043437", "SSF54403 : 0040299", 
                      "SSF52833 : 0047011", "SSF52518 : 0050395", "SSF51366 : 0047300", 
                      "TIGR00125 : cyt_tran_rel", "SSF101238 : 0042489", "PR00064 : RIBOSOMALL35", 
                      "PD075190 :", "SSF52540 : 0037412", "PF02141 : DENN", "SSF54236 : 0052269", 
                      "PF02656 : DUF202", "SSF49265 : 0050597", "SSF50974 : 0048991", 
                      "SSF52335 : 0045907", "SSF48726 : 0035725", "SSF48498 : 0052743", 
                      "SSF51604 : 0047649", "SSF48726 : 0047395", "PF01048 : PNP_UDP_1", 
                      "SSF57716 : 0051139", "SSF75005 : 0044569", "SSF53383 : 0035803", 
                      "SSF56436 : 0050635", "SSF54556 : 0050413", "PR00040 : HTHMERR", 
                      "SSF54236 : 0039419", "SSF56003 : 0036417", "SSF103473 : 0042480", 
                      "SSF48557 : 0050346", "SSF88633 : 0042484", "SSF57059 : 0036009", 
                      "SSF53223 : 0050104", "SSF50960 : 0036130", "SSF57095 : 0045760", 
                      "SSF54719 : 0049959", "TIGR01664 : DNA-3'-Pase", "SSF57196 : 0048017", 
                      "SSF48452 : 0037079", "PF08954 : DUF1900", "SSF53067 : 0052960", 
                      "SSF53067 : 0041117", "SSF53474 : 0047388", "SSF53474 : 0050947", 
                      "SSF46689 : 0049809", "SSF54637 : 0051358", "SSF101999 : 0049339", 
                      "SSF56634 : 0040837", "SSF46785 : 0038701", "PF07892 : DUF1667", 
                      "TIGR00670 : asp_carb_tr", "SSF46458 : 0038046", "SSF57302 : 0040646", 
                      "PIRSF000130 :", "TIGR01788 : Glu-decarb-GAD", "PD037294 :", 
                      "SSF47220 : 0043280", "SSF53850 : 0038890", "SSF55120 : 0050199", 
                      "SSF100950 : 0041329", "SSF102705 : 0052808", "SSF50729 : 0052349", 
                      "SSF57586 : 0037254", "SSF53182 : 0039105", "PF06968 : BATS", 
                      "SSF54719 : 0035696", "SSF53633 : 0051530", "SSF56837 : 0036083", 
                      "SSF54292 : 0037512", "PF02012 : BNR", "SSF48619 : 0045390", 
                      "SSF57630 : 0044973", "PF04129 : Vps52", "SSF53474 : 0039914", 
                      "SSF56854 : 0048173", "SSF57196 : 0046108", "SSF48439 : 0036305", 
                      "SSF52210 : 0052285", "SSF55136 : 0035649", "SSF49265 : 0053185", 
                      "SSF52540 : 0050374", "SSF55486 : 0037477", "SSF53850 : 0036526", 
                      "PR00597 : GELSOLIN", "SSF51569 : 0036525", "SSF51366 : 0046387", 
                      "SSF55973 : 0042854", "SSF81296 : 0042183", "PD000621 :", "SSF56219 : 0049450", 
                      "PS51329 : C_CAP_COFACTOR_C", "PF08244 : Glyco_hydro_32C", "SSF81296 : 0046681", 
                      "SSF57652 : 0038630", "SSF51445 : 0048920", "SSF55753 : 0035967", 
                      "PD216863 :", "SSF74650 : 0051663", "SSF53697 : 0048077", "SSF103565 : 0049964", 
                      "SSF53448 : 0047707", "PF04434 : SWIM", "SSF52374 : 0037985", 
                      "SSF50249 : 0043261", "SSF55729 : 0051028", "SSF49695 : 0037073", 
                      "SSF46689 : 0040874", "SSF49309 : 0040273", "SSF51735 : 0041637", 
                      "SSF50814 : 0051000", "SSF51658 : 0049033", "SSF57184 : 0041519", 
                      "SSF53850 : 0042263", "SSF51161 : 0047866", "SSF56436 : 0044061", 
                      "SSF63380 : 0045408", "SSF48508 : 0045508", "PF01485 : IBR", 
                      "SSF57603 : 0042759", "PF04675 : DNA_ligase_A_N", "SSF47220 : 0046372", 
                      "SSF100910 : 0040308", "PS50862 : AA_TRNA_LIGASE_II", "SSF52029 : 0042603", 
                      "PF05292 : MCD", "SSF55298 : 0044338", "SSF52540 : 0049398", 
                      "SSF55961 : 0046811", "SSF48179 : 0043964", "SSF51735 : 0044888", 
                      "SSF53187 : 0050184", "SSF48371 : 0048121", "SSF48726 : 0039958", 
                      "SSF50630 : 0049227", "PD354634 :", "PR01043 : TRNASYNTHGLY", 
                      "SSF50814 : 0046935", "SSF47598 : 0042198", "SSF51182 : 0043192", 
                      "PF00750 : tRNA-synt_1d", "SSF53955 : 0046807", "SSF54843 : 0037543", 
                      "SSF48452 : 0051642", "SSF55785 : 0048715", "SSF48726 : 0048128", 
                      "TIGR00217 : malQ", "PF10525 : Engrail_1_C_sig", "PF00081 : Sod_Fe_N", 
                      "SSF46458 : 0050879", "PD011820 :", "PF06391 : MAT1", "PF01804 : Penicil_amidase", 
                      "SSF57196 : 0046899", "SSF48317 : 0044900", "SSF52096 : 0038805", 
                      "SSF51182 : 0039119", "SSF51366 : 0036340", "SSF48403 : 0039267", 
                      "SSF56672 : 0043488", "SSF50630 : 0049394", "PF05795 : Plasmodium_Vir", 
                      "SSF52210 : 0037190", "SSF54719 : 0041014", "PF06039 : Mqo", 
                      "SSF52540 : 0042088", "PF08393 : DHC_N2", "SSF90096 : 0047485", 
                      "SSF54211 : 0042490", "SSF53448 : 0047989", "SSF46458 : 0044752", 
                      "SSF69075 : 0038205", "SSF56327 : 0035944", "SSF54117 : 0035320", 
                      "SSF53335 : 0041326", "SSF48726 : 0038115", "SSF46458 : 0044618", 
                      "SSF55331 : 0042022", "PF04092 : SAG", "SSF53271 : 0051105", 
                      "SSF51366 : 0047125", "SSF49503 : 0048546", "PF00665 : rve", 
                      "SSF56601 : 0041731", "SSF55729 : 0051437", "SSF52743 : 0050066", 
                      "SSF56112 : 0047332", "SSF54826 : 0043961", "SSF52943 : 0036816", 
                      "SSF100879 : 0044465", "SSF55729 : 0048023", "SSF56784 : 0052665", 
                      "SSF53901 : 0039353", "SSF55785 : 0041159", "SSF47353 : 0034953", 
                      "PF05036 : SPOR", "SSF88633 : 0036874", "SSF57302 : 0045214", 
                      "SSF53671 : 0042023", "SSF53167 : 0047738", "SSF46689 : 0047064", 
                      "SSF54826 : 0050382", "PIRSF005727 :", "PF03450 : CO_deh_flav_C", 
                      "PF01287 : eIF-5a", "SSF47336 : 0049566", "SSF54637 : 0053021", 
                      "SSF49899 : 0035606", "SSF52518 : 0045130", "SSF52025 : 0046309", 
                      "SSF53187 : 0051427", "PS50838 : MAGE", "SSF51569 : 0046338", 
                      "SSF48695 : 0047058", "SSF53098 : 0036277", "SSF52833 : 0045475", 
                      "SSF52540 : 0039110", "PD005639 :", "SSF50156 : 0042269", "SSF53474 : 0047495", 
                      "SSF52540 : 0048025", "SSF53335 : 0050935", "SSF49417 : 0050006", 
                      "SSF50465 : 0036957", "PF03901 : Glyco_transf_22", "SSF49899 : 0047199", 
                      "SSF46626 : 0046408", "PF06480 : FtsH_ext", "SSF103473 : 0042501", 
                      "SSF55347 : 0045517", "SSF53474 : 0048075", "SSF53474 : 0042109", 
                      "SSF51735 : 0039314", "SSF56821 : 0043766", "SSF47220 : 0049466", 
                      "SSF51182 : 0047506", "SSF53933 : 0038193", "SSF89957 : 0040708", 
                      "SSF47802 : 0035656", "SSF82615 : 0044452", "TIGR02093 : P_ylase", 
                      "SSF54719 : 0036585", "SSF88633 : 0035327", "SSF50784 : 0041586", 
                      "PF00459 : Inositol_P", "SSF47576 : 0042167", "PF06470 : SMC_hinge", 
                      "SSF52833 : 0049102", "SSF51110 : 0035319", "PF09429 : Wbp11", 
                      "PF05208 : ALG3", "SSF54593 : 0039909", "PIRSF017246 :", "SSF57933 : 0037431", 
                      "SSF49842 : 0035097", "SSF52540 : 0048689", "SSF48726 : 0037602", 
                      "SSF57845 : 0037745", "SSF48113 : 0039189", "PF02182 : YDG_SRA", 
                      "SSF89433 : 0041248", "PF00294 : PfkB", "SSF55031 : 0051475", 
                      "SSF55821 : 0037940", "SSF57095 : 0045928", "SSF52540 : 0035075", 
                      "SSF55326 : 0050217", "SSF47661 : 0050140", "PF00181 : Ribosomal_L2", 
                      "SSF49503 : 0043555", "SSF52218 : 0049241", "SSF52374 : 0037030", 
                      "SSF51445 : 0051975", "SSF51419 : 0036144", "PIRSF002291 :", 
                      "SSF53795 : 0053253", "SSF63520 : 0038492", "PF08158 : NUC130_3NT", 
                      "SSF63393 : 0038880", "SSF51445 : 0038048", "SSF48201 : 0035911", 
                      "PS50072 : CSA_PPIASE_2", "SSF54403 : 0043319", "SSF46561 : 0046772", 
                      "SSF50494 : 0035122", "SSF51182 : 0040530", "SSF56327 : 0038787", 
                      "SSF57027 : 0053307", "SSF47648 : 0040083", "PF04566 : RNA_pol_Rpb2_4", 
                      "SSF57392 : 0036768", "SSF54452 : 0052058", "SSF52266 : 0047668", 
                      "SSF54928 : 0049888", "SSF52949 : 0051618", "SSF54495 : 0051649", 
                      "PS50122 : CHEB", "SSF55666 : 0036741", "SSF51726 : 0049767", 
                      "SSF55021 : 0052683", "SSF52343 : 0037677", "PF01906 : DUF74", 
                      "SSF49329 : 0051813", "SSF57850 : 0035646", "PF03104 : DNA_pol_B_exo", 
                      "SSF81324 : 0041998", "SSF55545 : 0038663", "SSF52540 : 0044714", 
                      "SSF46785 : 0043589", "PF02469 : Fasciclin", "SSF53756 : 0039046", 
                      "SSF56712 : 0048235", "SSF56436 : 0039985", "SSF48239 : 0041184", 
                      "SSF57095 : 0049493", "SSF54098 : 0049792", "SSF48726 : 0040777", 
                      "SSF54373 : 0035955", "SSF48150 : 0040041", "SSF48403 : 0045980", 
                      "SSF51604 : 0050381", "PF00583 : Acetyltransf_1", "PF01215 : COX5B", 
                      "PF03306 : AAL_decarboxy", "SSF82895 : 0040647", "SSF52540 : 0037926", 
                      "SSF51283 : 0041842", "SSF52218 : 0051274", "PD186135 :", "SSF55931 : 0048061", 
                      "SSF54368 : 0047238", "SSF51395 : 0036864", "PF09592 : DUF2031", 
                      "SSF56112 : 0041719", "PF07650 : KH_2", "SSF47240 : 0048525", 
                      "PF05578 : Peptidase_S31", "SSF57770 : 0048145", "TIGR01492 : CPW_WPC", 
                      "SSF101288 : 0043367", "SSF54001 : 0036392", "SSF49899 : 0053201", 
                      "PF01135 : PCMT", "SSF57716 : 0045122", "SSF53474 : 0040607", 
                      "SSF102886 : 0044037", "SSF57850 : 0037482", "SSF53098 : 0045061", 
                      "SSF50494 : 0037131", "SSF50494 : 0049034", "SSF48726 : 0040832", 
                      "SSF50249 : 0037936", "SSF51445 : 0049502", "SSF54452 : 0039595", 
                      "SSF57667 : 0052280", "SSF48695 : 0038377", "SSF50331 : 0038501", 
                      "PF04137 : ERO1", "SSF54358 : 0042313", "SSF57302 : 0044913", 
                      "SSF54862 : 0038575", "SSF52343 : 0052188", "SSF52418 : 0053310", 
                      "SSF57716 : 0052320", "SSF49590 : 0044975", "SSF52833 : 0048664", 
                      "SSF51445 : 0051737", "SSF51338 : 0037043", "SSF51419 : 0053370", 
                      "SSF46785 : 0040979", "SSF53474 : 0044797", "SSF51182 : 0044378", 
                      "SSF53335 : 0050762", "SSF53474 : 0039556", "SSF57362 : 0045626", 
                      "SSF53187 : 0042872", "SSF53383 : 0051517", "SSF48029 : 0042704", 
                      "SSF48264 : 0037196", "SSF51126 : 0048515", "TIGR01685 : MDP-1", 
                      "SSF50494 : 0053299", "PD006705 :", "SSF56784 : 0040685", "SSF55729 : 0037843", 
                      "SSF50044 : 0039706", "SSF48726 : 0035621", "SSF53474 : 0036866", 
                      "SSF54117 : 0037065", "SSF101690 : 0043622", "PIRSF500058 :", 
                      "SSF100950 : 0036382", "SSF48695 : 0035167", "SSF53067 : 0039478", 
                      "SSF57586 : 0043593", "SSF54980 : 0042213", "SSF55973 : 0042855", 
                      "PS50016 : ZF_PHD_2", "SSF51735 : 0047059", "SSF50814 : 0040479", 
                      "SSF52540 : 0043012", "SSF88633 : 0035328", "SSF56601 : 0040978", 
                      "SSF63380 : 0041321", "PF01137 : RTC", "SSF50677 : 0038402", 
                      "SSF51971 : 0038469", "SSF47060 : 0036236", "SSF57924 : 0043565", 
                      "SSF55729 : 0052713", "SSF56935 : 0047258", "PF00015 : MCPsignal", 
                      "SSF48113 : 0042916", "PF09451 : ATG27", "SSF49367 : 0036559", 
                      "PF09688 : Wx5_PLAF3D7", "SSF51905 : 0041392", "SSF46767 : 0043581", 
                      "SSF57059 : 0050311", "SSF52540 : 0040419", "SSF51419 : 0045470", 
                      "SSF48113 : 0040547", "SSF47323 : 0043347", "SSF54292 : 0040052", 
                      "PIRSF000184 :", "SSF56300 : 0048962", "SSF52833 : 0047056", 
                      "PD319679 :", "SSF52540 : 0050194", "SSF81585 : 0047630", "SSF74924 : 0050554", 
                      "SSF54523 : 0042622", "SSF63862 : 0038999", "SSF55486 : 0047882", 
                      "PF07999 : RHSP", "SSF53448 : 0037706", "SSF52540 : 0053147", 
                      "PS51188 : ZF_CR", "SSF82549 : 0040914", "PIRSF000587 :", "SSF51735 : 0044840", 
                      "SSF52540 : 0047820", "SSF57850 : 0044949", "SSF101898 : 0048898", 
                      "SSF54966 : 0050438", "SSF56507 : 0039390", "SSF54719 : 0040860", 
                      "SSF51283 : 0052041", "PF10415 : FumaraseC_C", "SSF101489 : 0043216", 
                      "SSF50249 : 0037226", "SSF51735 : 0037128", "SSF53383 : 0040450", 
                      "PF02739 : 5_3_exonuc_N", "SSF53955 : 0043002", "SSF57095 : 0042105", 
                      "PF02837 : Glyco_hydro_2_N", "SSF51735 : 0042962", "SSF51395 : 0047026", 
                      "SSF57868 : 0039564", "PF03105 : SPX", "SSF46458 : 0035398", 
                      "SSF47895 : 0043922", "PD141294 :", "SSF53686 : 0042904", "SSF63380 : 0045794", 
                      "SSF46934 : 0052431", "SSF52540 : 0038191", "TIGR00803 : nst", 
                      "SSF55781 : 0043975", "SSF49441 : 0036723", "PF01871 : AMMECR1", 
                      "SSF56994 : 0039009", "SSF47862 : 0040726", "SSF47576 : 0048913", 
                      "SSF47741 : 0037560", "SSF57850 : 0046458", "SSF55347 : 0038023", 
                      "PR01099 : HYETHTZKNASE", "SSF81653 : 0043762", "SSF46934 : 0049688", 
                      "SSF54373 : 0052927", "PF09405 : Btz", "SSF53335 : 0045150", 
                      "SSF50465 : 0047821", "SSF53774 : 0051611", "PF03226 : Yippee", 
                      "SSF49899 : 0036671", "PR00758 : ARSENICPUMP", "SSF57059 : 0042189", 
                      "SSF47203 : 0050325", "PF03619 : DUF300", "SSF53474 : 0047444", 
                      "SSF57016 : 0044972", "SSF56784 : 0045131", "SSF55060 : 0044306", 
                      "TIGR00235 : udk", "SSF49447 : 0038852", "SSF55550 : 0040671", 
                      "SSF54236 : 0036824", "PF07500 : TFIIS_M", "SSF51316 : 0051019", 
                      "SSF50104 : 0040731", "PF02627 : CMD", "SSF55846 : 0052587", 
                      "SSF75471 : 0039673", "SSF56487 : 0042161", "SSF49265 : 0051919", 
                      "SSF54919 : 0051941", "SSF53383 : 0038960", "SSF57630 : 0048382", 
                      "SSF46689 : 0052309", "SSF53187 : 0044790", "SSF48695 : 0045238", 
                      "SSF57863 : 0049791", "SSF52172 : 0041560", "SSF49309 : 0046894", 
                      "SSF57196 : 0039114", "PF00082 : Peptidase_S8", "SSF53098 : 0042976", 
                      "SSF56601 : 0051964", "SSF52833 : 0050915", "SSF52540 : 0037407", 
                      "TIGR00279 : L10e", "PF01852 : START", "SSF54814 : 0039832", 
                      "SSF47616 : 0052729", "SSF53335 : 0044875", "SSF56042 : 0036051", 
                      "SSF48552 : 0040312", "SSF53244 : 0046486", "SSF48726 : 0049268", 
                      "PF02900 : LigB", "SSF53335 : 0046354", "SSF51556 : 0051086", 
                      "SSF57903 : 0036632", "SSF54719 : 0038820", "SSF47473 : 0046010", 
                      "PR00326 : GTP1OBG", "SSF50156 : 0041555", "SSF52540 : 0049317", 
                      "SSF52113 : 0040406", "SSF48726 : 0037181", "SSF56235 : 0036097", 
                      "SSF50630 : 0043668", "PF02526 : GBP_repeat", "SSF52540 : 0051958", 
                      "SSF53597 : 0051866", "SSF57667 : 0045695", "PS51182 : C2_TENSIN", 
                      "SSF47266 : 0045732", "SSF48576 : 0044612", "SSF47576 : 0048721", 
                      "SSF57095 : 0048792", "SSF81296 : 0041846", "SSF52540 : 0043794", 
                      "SSF47986 : 0038970", "SSF52743 : 0043768", "SSF52141 : 0041089", 
                      "SSF52833 : 0049667", "PIRSF037000 :", "PIRSF005381 :", "PF01907 : Ribosomal_L37e", 
                      "SSF57362 : 0036387", "SSF50022 : 0042667", "PF08644 : SPT16", 
                      "SSF53150 : 0046642", "PD000007 :", "PF01174 : SNO", "SSF55785 : 0036539", 
                      "SSF54160 : 0035149", "SSF50346 : 0042374", "SSF51182 : 0051339", 
                      "SSF51445 : 0048598", "SSF50447 : 0051767", "SSF47473 : 0047730", 
                      "SSF50249 : 0036711", "SSF46977 : 0052031", "SSF50494 : 0045449", 
                      "SSF57716 : 0039082", "SSF48537 : 0035074", "SSF52799 : 0048179", 
                      "SSF53800 : 0049646", "SSF89028 : 0041488", "TIGR01307 : pgm_bpd_ind", 
                      "SSF54928 : 0050480", "SSF56371 : 0041058", "SSF55666 : 0043149", 
                      "SSF63825 : 0048415", "SSF57492 : 0045426", "SSF48619 : 0041979", 
                      "SSF51735 : 0038823", "PF04739 : AMPKBI", "SSF53474 : 0049128", 
                      "SSF54675 : 0048486", "SSF50156 : 0050492", "SSF51735 : 0044874", 
                      "SSF63501 : 0039058", "PR01661 : MCMPROTEIN5", "SSF48695 : 0045233", 
                      "SSF57535 : 0038221", "SSF50249 : 0038488", "PF00387 : PI-PLC-Y", 
                      "PF04979 : IPP-2", "SSF55821 : 0039486", "SSF56935 : 0042320", 
                      "PF03632 : Glyco_hydro_65m", "SSF54373 : 0047787", "SSF109925 : 0044528", 
                      "SSF55729 : 0041464", "SSF56784 : 0051280", "SSF56784 : 0051937", 
                      "SSF52540 : 0046693", "SSF46934 : 0048626", "SSF50044 : 0044917", 
                      "SSF56059 : 0038251", "PF01339 : CheB_methylest", "PF00187 : Chitin_bind_1", 
                      "PR00058 : RIBOSOMALL5", "SSF50249 : 0043053", "SSF47266 : 0041275", 
                      "PS51352 : THIOREDOXIN_2", "SSF53383 : 0047441", "PS50980 : COA_CT_NTER", 
                      "PF04144 : SCAMP", "SSF47789 : 0036084", "PF00514 : Arm", "SSF81271 : 0050742", 
                      "SSF48726 : 0048140", "SSF48726 : 0049540", "SSF48695 : 0036731", 
                      "SSF55608 : 0040802", "SSF56672 : 0038511", "SSF46458 : 0038958", 
                      "SSF101386 : 0051439", "PS50827 : DDT", "SSF51735 : 0045621", 
                      "SSF51445 : 0035163", "SSF57586 : 0036275", "SSF57889 : 0043160", 
                      "PD004501 :", "PF00092 : VWA", "SSF88633 : 0041051", "SSF50882 : 0039571", 
                      "SSF55021 : 0044224", "SSF51735 : 0036800", "TIGR02320 : PEP_mutase", 
                      "SSF57667 : 0052895", "SSF52283 : 0038058", "SSF88633 : 0042820", 
                      "SSF48097 : 0053167", "SSF49899 : 0038287", "SSF54373 : 0040661", 
                      "SSF53335 : 0040829", "PF00050 : Kazal_1", "PF00090 : TSP_1", 
                      "SSF50952 : 0036129", "SSF56003 : 0039729", "SSF50156 : 0041243", 
                      "PF05631 : DUF791", "SSF56672 : 0041091", "SSF52540 : 0043054", 
                      "PF08292 : RNA_pol_Rbc25", "PR01362 : CALFLAGIN", "SSF50891 : 0050399", 
                      "PD007878 :", "SSF57059 : 0037025", "PS51175 : CBM6", "SSF48537 : 0035050", 
                      "SSF57095 : 0047344", "SSF81296 : 0042741", "SSF48464 : 0047397", 
                      "SSF81296 : 0036195", "PF02738 : Ald_Xan_dh_C2", "SSF48371 : 0035653", 
                      "SSF46565 : 0038101", "SSF48013 : 0037257", "SSF53335 : 0048856", 
                      "SSF50129 : 0039695", "SSF47473 : 0043035", "SSF46785 : 0040680", 
                      "SSF51679 : 0046662", "PF02420 : AFP", "SSF81296 : 0050024", 
                      "TIGR02008 : fdx_plant", "SSF48508 : 0045423", "SSF55821 : 0042499", 
                      "TIGR00430 : Q_tRNA_tgt", "SSF52374 : 0034949", "SSF47095 : 0050064", 
                      "SSF49899 : 0039178", "PD006030 :", "TIGR00296 : TIGR00296", 
                      "SSF52540 : 0041547", "PF06098 : Radial_spoke_3", "PS51386 : RINT1_TIP20", 
                      "SSF57016 : 0045675", "SSF50630 : 0045556", "SSF48726 : 0049095", 
                      "SSF54909 : 0049441", "SSF56112 : 0040302", "SSF54695 : 0049297", 
                      "PS51002 : CYTB_NTER", "SSF52096 : 0051721", "SSF55021 : 0053265", 
                      "SSF51905 : 0036889", "SSF51230 : 0048610", "SSF51011 : 0039554", 
                      "SSF50814 : 0040311", "SSF88723 : 0050100", "SSF47473 : 0035150", 
                      "PR01182 : ORNDCRBXLASE", "PF05670 : DUF814", "SSF54452 : 0051534", 
                      "SSF54236 : 0046536", "SSF51419 : 0053309", "SSF48230 : 0036993", 
                      "PF04558 : tRNA_synt_1c_R1", "PF01794 : Ferric_reduct", "SSF55060 : 0050715", 
                      "SSF52540 : 0052914", "SSF46955 : 0037930", "PF02221 : E1_DerP2_DerF2", 
                      "SSF51735 : 0038786", "SSF51556 : 0039386", "SSF52540 : 0046392", 
                      "PF01018 : GTP1_OBG", "SSF103506 : 0041893", "SSF54534 : 0048097", 
                      "SSF56300 : 0052321", "SSF51621 : 0049789", "PF07970 : DUF1692", 
                      "PF05206 : TRM13", "SSF52467 : 0042917", "TIGR01474 : ubiA_proteo", 
                      "TIGR02727 : MTHFS_bact", "SSF53448 : 0038881", "SSF56327 : 0040541", 
                      "SSF47413 : 0046409", "PIRSF500072 :", "PF09689 : PY_rept_46", 
                      "SSF47113 : 0038980", "SSF53137 : 0039075", "PF02817 : E3_binding", 
                      "SSF50978 : 0048349", "SSF54358 : 0040940", "PR01803 : TCSIALIDASE", 
                      "SSF56176 : 0046672", "SSF57802 : 0051414", "SSF55486 : 0040268", 
                      "SSF110304 : 0052073", "SSF48726 : 0044573", "PF09763 : Sec3", 
                      "SSF81296 : 0051882", "SSF55298 : 0047562", "SSF49503 : 0037169", 
                      "SSF47203 : 0047430", "PIRSF037094 :", "SSF56300 : 0049342", 
                      "SSF47031 : 0038416", "SSF88633 : 0035627", "PIRSF017207 :", 
                      "SSF51182 : 0049969", "PF00629 : MAM", "SSF46458 : 0040501", 
                      "SSF52343 : 0040222", "SSF50104 : 0035596", "SSF69203 : 0039921", 
                      "SSF90096 : 0039297", "SSF57095 : 0038661", "SSF55811 : 0048869", 
                      "SSF50891 : 0034847", "SSF82657 : 0041621", "PF00809 : Pterin_bind", 
                      "PF05219 : DREV", "SSF52113 : 0040338", "PS51219 : DPCK", "SSF55811 : 0049418", 
                      "PF02630 : SCO1-SenC", "SSF46785 : 0035958", "PS50046 : PHYTOCHROME_2", 
                      "PF04263 : TPK_catalytic", "SSF51230 : 0047477", "SSF48557 : 0042625", 
                      "SSF53474 : 0046729", "SSF50475 : 0038821", "SSF49329 : 0049454", 
                      "SSF52980 : 0040016", "SSF46626 : 0039492", "SSF48726 : 0042027", 
                      "PS51027 : INTEGRASE_DBD", "SSF57095 : 0048835", "PD042469 :", 
                      "PR01365 : TELOMERASERT", "SSF55931 : 0037877", "SSF53271 : 0046350", 
                      "SSF48726 : 0041578", "TIGR01559 : squal_synth", "SSF55729 : 0051600", 
                      "SSF56672 : 0047809", "SSF51556 : 0052760", "SSF55486 : 0041006", 
                      "SSF56420 : 0040562", "SSF55729 : 0052874", "PF03834 : Rad10", 
                      "PS50841 : DIX", "PIRSF037881 :", "SSF50621 : 0038617", "SSF49265 : 0035650", 
                      "SSF50249 : 0035796", "SSF49265 : 0043953", "PR00960 : LMBPPROTEIN", 
                      "SSF54928 : 0038503", "SSF54292 : 0036856", "PF06094 : AIG2", 
                      "SSF48208 : 0049896", "SSF55194 : 0039174", "SSF46934 : 0037386", 
                      "SSF51735 : 0047993", "SSF53927 : 0043140", "SSF55486 : 0037882", 
                      "SSF53335 : 0045247", "SSF53850 : 0047137", "SSF53807 : 0042458", 
                      "SSF81442 : 0037556", "PD177368 :", "SSF55545 : 0052140", "SSF57716 : 0050845", 
                      "SSF55681 : 0045899", "SSF53474 : 0048126", "PS50176 : ARM_REPEAT", 
                      "SSF57716 : 0052202", "PF10568 : Tom37", "SSF48726 : 0043240", 
                      "PD140053 :", "PD006609 :", "PIRSF023577 :", "PIRSF004869 :", 
                      "PR00418 : TPI2FAMILY", "PF01648 : ACPS", "SSF46785 : 0052640", 
                      "SSF54001 : 0045648", "SSF54452 : 0053319", "SSF48726 : 0045269", 
                      "SSF48726 : 0051876", "SSF81382 : 0041350", "SSF52833 : 0045304", 
                      "SSF55729 : 0041544", "SSF57586 : 0051112", "SSF53720 : 0035565", 
                      "SSF50249 : 0045011", "PF01541 : GIY-YIG", "SSF53659 : 0045022", 
                      "SSF47345 : 0044464", "SSF55821 : 0044038", "PIRSF037215 :", 
                      "SSF46785 : 0045184", "SSF48498 : 0047678", "SSF48726 : 0042262", 
                      "SSF52540 : 0050316", "PR00481 : LAMNOPPTDASE", "PIRSF006305 :", 
                      "SSF55729 : 0049219", "SSF55729 : 0051375", "PR00258 : SPERACTRCPTR", 
                      "SSF51445 : 0035428", "SSF102198 : 0049116", "SSF88633 : 0034901", 
                      "SSF52374 : 0041203", "SSF56371 : 0035956", "SSF52440 : 0040723", 
                      "TIGR01039 : atpD", "SSF54762 : 0034791", "SSF111352 : 0044218", 
                      "SSF51735 : 0040516", "SSF48619 : 0038172", "TIGR00517 : acyl_carrier", 
                      "SSF53448 : 0047689", "SSF89442 : 0041427", "SSF53659 : 0043174", 
                      "PD097930 :", "SSF54001 : 0047010", "SSF57059 : 0035040", "SSF81301 : 0044611", 
                      "SSF48208 : 0044346", "SSF101931 : 0043277", "PIRSF038169 :", 
                      "SSF82708 : 0049895", "SSF55550 : 0040529", "SSF54189 : 0052820", 
                      "SSF50494 : 0041958", "SSF51735 : 0052988", "SSF52821 : 0043853", 
                      "SSF50494 : 0051141", "SSF55874 : 0035784", "SSF46458 : 0048357", 
                      "SSF51246 : 0046402", "PD001127 :", "PF01756 : ACOX", "SSF55797 : 0042890", 
                      "SSF109604 : 0049586", "PF01092 : Ribosomal_S6e", "SSF48113 : 0052494", 
                      "TIGR00218 : manA", "SSF51695 : 0053275", "SSF54826 : 0036898", 
                      "SSF53383 : 0045242", "SSF51735 : 0047963", "SSF54495 : 0044227", 
                      "TIGR03150 : fabF", "SSF57603 : 0044081", "SSF50475 : 0044501", 
                      "TIGR01601 : PYST-C1", "SSF54791 : 0052300", "PS50919 : MIR", 
                      "PF00122 : E1-E2_ATPase", "SSF54593 : 0036022", "SSF51735 : 0045093", 
                      "SSF69065 : 0047579", "SSF52540 : 0035676", "PF09402 : MAN1_C", 
                      "SSF88633 : 0049083", "PIRSF005799 :", "SSF48256 : 0036138", 
                      "SSF47353 : 0037110", "SSF53335 : 0041580", "SSF48726 : 0045997", 
                      "PIRSF500081 :", "PF00928 : Adap_comp_sub", "SSF53335 : 0042552", 
                      "SSF47031 : 0041398", "SSF50729 : 0041564", "SSF52283 : 0052457", 
                      "SSF47240 : 0047612", "PD004282 :", "SSF47954 : 0050198", "SSF49265 : 0052473", 
                      "SSF81730 : 0040672", "SSF55961 : 0052424", "SSF109604 : 0049806", 
                      "SSF46458 : 0038045", "PF08212 : Lipocalin_2", "SSF46785 : 0044258", 
                      "SSF54358 : 0053281", "SSF56496 : 0040734", "PF08030 : NAD_binding_6", 
                      "SSF49401 : 0049261", "SSF57429 : 0036910", "PD041151 :", "SSF53254 : 0053031", 
                      "SSF50814 : 0043076", "SSF53697 : 0039383", "SSF57667 : 0050840", 
                      "SSF48726 : 0037121", "SSF48726 : 0036145", "SSF52935 : 0043884", 
                      "SSF54160 : 0052477", "PF06943 : zf-LSD1", "PF00285 : Citrate_synt", 
                      "SSF53383 : 0036780", "SSF51569 : 0048294", "SSF54980 : 0052056", 
                      "SSF53244 : 0045482", "SSF49309 : 0047947", "SSF50044 : 0042323", 
                      "SSF53036 : 0036684", "SSF48726 : 0034856", "SSF49899 : 0051193", 
                      "PD001098 :", "SSF52743 : 0036867", "PF01844 : HNH", "SSF69065 : 0041655", 
                      "SSF52218 : 0049548", "SSF53474 : 0035682", "SSF53448 : 0038462", 
                      "SSF88633 : 0043088", "SSF56399 : 0038117", "SSF102886 : 0044813", 
                      "SSF51445 : 0051481", "SSF47413 : 0052264", "TIGR00928 : purB", 
                      "SSF47616 : 0045305", "PF00609 : DAGK_acc", "TIGR01066 : rplM_bact", 
                      "PF01529 : zf-DHHC", "SSF48619 : 0042104", "SSF57288 : 0040974", 
                      "SSF51735 : 0050090", "PF04006 : Mpp10", "SSF75304 : 0052903", 
                      "SSF69705 : 0039834", "SSF81473 : 0037009", "SSF47240 : 0041026", 
                      "PR01179 : ODADCRBXLASE", "SSF50615 : 0037817", "SSF47473 : 0039372", 
                      "SSF52540 : 0052547", "SSF54076 : 0040796", "SSF56219 : 0051655", 
                      "SSF50370 : 0034986", "TIGR03317 : ygfZ_signature", "SSF57667 : 0049610", 
                      "SSF50692 : 0034975", "SSF52540 : 0051582", "SSF47413 : 0050546", 
                      "PF04715 : Anth_synt_I_N", "PF04097 : NIC", "SSF54236 : 0038854", 
                      "SSF49503 : 0040027", "SSF48208 : 0046841", "SSF49899 : 0045853", 
                      "PF10557 : Cullin_Nedd8", "SSF50729 : 0040099", "SSF52242 : 0053374", 
                      "SSF55008 : 0039836", "SSF49998 : 0041758", "SSF49785 : 0041575", 
                      "PF09762 : KOG2701", "SSF57184 : 0048302", "SSF52540 : 0044667", 
                      "SSF52540 : 0044233", "SSF53244 : 0048688", "SSF53901 : 0044093", 
                      "PIRSF001400 :", "SSF46785 : 0048695", "SSF52980 : 0049370", 
                      "SSF55159 : 0045333", "SSF47266 : 0038587", "PF01246 : Ribosomal_L24e", 
                      "SSF50370 : 0042476", "SSF52540 : 0049269", "SSF103025 : 0051157", 
                      "SSF51703 : 0045650", "SSF48695 : 0049254", "SSF50044 : 0044915", 
                      "TIGR01800 : cit_synth_II", "SSF56436 : 0046900", "SSF57501 : 0042265", 
                      "SSF56601 : 0048110", "TIGR01443 : intein_Cterm", "SSF52833 : 0035346", 
                      "SSF49599 : 0040442", "SSF50814 : 0051678", "PD318037 :", "SSF49503 : 0049367", 
                      "TIGR01240 : mevDPdecarb", "PF04597 : Ribophorin_I", "PS51354 : GLUTAREDOXIN_2", 
                      "SSF48726 : 0044545", "SSF55008 : 0046197", "SSF52540 : 0036962", 
                      "SSF57716 : 0041629", "SSF49879 : 0049041", "PD002792 :", "SSF52425 : 0044200", 
                      "SSF55347 : 0045240", "SSF56496 : 0040702", "SSF52833 : 0039616", 
                      "PS51330 : DHFR_2", "SSF50729 : 0052708", "SSF101912 : 0048888", 
                      "SSF100920 : 0049751", "PF01384 : PHO4", "SSF52096 : 0044960", 
                      "SSF54980 : 0041173", "SSF56784 : 0052660", "TIGR00055 : uppS", 
                      "SSF50615 : 0040863", "SSF53474 : 0043089", "TIGR01164 : rplP_bact", 
                      "SSF56796 : 0040204", "SSF54826 : 0041938", "SSF52096 : 0051722", 
                      "SSF100897 : 0037845", "PR00958 : HOMSERKINASE", "SSF53067 : 0051509", 
                      "SSF52833 : 0038196", "SSF48726 : 0035917", "PF07717 : DUF1605", 
                      "SSF53098 : 0051650", "PIRSF005992 :", "SSF52833 : 0046694", 
                      "SSF56425 : 0039665", "SSF51182 : 0048019", "SSF55194 : 0050587", 
                      "PF00622 : SPRY", "SSF55729 : 0038827", "PF04146 : YTH", "SSF54585 : 0044984", 
                      "SSF50969 : 0040893", "SSF52218 : 0035083", "SSF50729 : 0044630", 
                      "SSF48464 : 0039097", "SSF53474 : 0044017", "SSF46785 : 0041931", 
                      "PD065249 :", "SSF49503 : 0041323", "PF01216 : Calsequestrin", 
                      "SSF51351 : 0048109", "SSF54117 : 0037165", "SSF51984 : 0047521", 
                      "SSF57095 : 0044987", "SSF54593 : 0047893", "PF00183 : HSP90", 
                      "SSF46785 : 0053154", "SSF55229 : 0037205", "PD064583 :", "SSF49265 : 0045991", 
                      "PS51382 : SPX", "SSF52954 : 0035004", "PF02436 : PYC_OADA", 
                      "SSF48452 : 0048699", "SSF54373 : 0043212", "SSF48726 : 0035466", 
                      "SSF52833 : 0042674", "PF00566 : TBC", "SSF46997 : 0046525", 
                      "SSF51445 : 0039982", "SSF48726 : 0039627", "TIGR01258 : pgm_1", 
                      "SSF53098 : 0048225", "PR00059 : RIBOSOMALL6", "SSF46689 : 0052798", 
                      "SSF52129 : 0040830", "SSF69349 : 0039861", "SSF52540 : 0043411", 
                      "PF00106 : adh_short", "SSF102860 : 0043747", "SSF102405 : 0053291", 
                      "SSF50494 : 0040887", "SSF46458 : 0047975", "SSF46626 : 0036071", 
                      "PF00488 : MutS_V", "SSF55979 : 0045836", "PF10357 : Kin17_mid", 
                      "PF00659 : POLO_box", "SSF57059 : 0038988", "SSF52374 : 0038030", 
                      "SSF46966 : 0043003", "PS50085 : RAPGAP", "SSF63520 : 0038493", 
                      "SSF53067 : 0051508", "SSF51182 : 0043023", "SSF51206 : 0037768", 
                      "SSF103575 : 0049736", "SSF54984 : 0046714", "SSF55729 : 0050940", 
                      "PS51038 : BAH", "SSF50249 : 0041557", "SSF74650 : 0040478", 
                      "SSF52833 : 0037350", "PS50873 : PEROXIDASE_4", "SSF51971 : 0049990", 
                      "SSF48726 : 0045008", "SSF75217 : 0042076", "SSF53920 : 0038574", 
                      "SSF53271 : 0048249", "SSF48619 : 0042402", "SSF50630 : 0050640", 
                      "PF01035 : DNA_binding_1", "SSF50370 : 0038092", "TIGR00597 : rad10", 
                      "SSF49899 : 0037825", "SSF51206 : 0046856", "SSF57501 : 0040781", 
                      "SSF46626 : 0036634", "PF01242 : PTPS", "SSF47323 : 0040506", 
                      "SSF52540 : 0049757", "SSF54452 : 0047092", "SSF49265 : 0049856", 
                      "SSF56854 : 0036367", "SSF56601 : 0039883", "SSF51430 : 0051795", 
                      "SSF48113 : 0052523", "SSF50104 : 0041642", "SSF53639 : 0036761", 
                      "SSF51735 : 0047294", "SSF51569 : 0048496", "SSF88633 : 0047671", 
                      "SSF74924 : 0048010", "PD317567 :", "PF02769 : AIRS_C", "SSF53383 : 0040897", 
                      "PF03062 : MBOAT", "SSF57667 : 0052205", "SSF57424 : 0037446", 
                      "SSF46609 : 0040123", "SSF47473 : 0042454", "SSF49842 : 0036412", 
                      "SSF52440 : 0035214", "SSF55073 : 0037824", "SSF49265 : 0042060", 
                      "SSF51735 : 0051260", "PF03989 : DNA_gyraseA_C", "SSF57770 : 0043349", 
                      "SSF46767 : 0042887", "SSF51735 : 0048808", "SSF56935 : 0035024", 
                      "TIGR00080 : pimt", "PIRSF005586 :", "PF04191 : PEMT", "SSF52172 : 0049456", 
                      "SSF54001 : 0053117", "SSF53748 : 0044642", "PS50135 : ZF_ZZ_2", 
                      "TIGR02824 : quinone_pig3", "SSF52440 : 0045826", "PF10143 : PhosphMutase", 
                      "PIRSF005378 :", "PR01243 : NUCDPKINASE", "SSF51621 : 0045708", 
                      "SSF54277 : 0046095", "PD003461 :", "SSF46785 : 0045339", "SSF49329 : 0051094", 
                      "PF02792 : Mago_nashi", "SSF46548 : 0047791", "SSF51445 : 0047236", 
                      "SSF81296 : 0040272", "SSF54593 : 0043691", "SSF88633 : 0037208", 
                      "SSF51445 : 0050167", "PF05207 : zf-CSL", "SSF51735 : 0046529", 
                      "SSF57027 : 0040889", "PF03079 : ARD", "SSF53187 : 0051474", 
                      "SSF54001 : 0035021", "PF01795 : Methyltransf_5", "SSF56553 : 0038874", 
                      "SSF54236 : 0044354", "SSF50447 : 0046538", "SSF48619 : 0042058", 
                      "SSF55681 : 0042525", "SSF51735 : 0048107", "SSF57262 : 0043653", 
                      "SSF47781 : 0051684", "PF02687 : FtsX", "SSF54001 : 0045544", 
                      "SSF49265 : 0052283", "SSF53098 : 0048406", "SSF53098 : 0053000", 
                      "SSF48613 : 0041214", "SSF56176 : 0044561", "TIGR01171 : rplB_bact", 
                      "SSF51735 : 0050655", "SSF54713 : 0050904", "SSF48613 : 0047524", 
                      "PF03184 : DDE", "SSF55464 : 0040790", "SSF54358 : 0039915", 
                      "PF07054 : Pericardin_rpt", "SSF52540 : 0042345", "SSF52540 : 0047537", 
                      "PF02207 : zf-UBR", "SSF55753 : 0050504", "SSF47113 : 0047118", 
                      "SSF55856 : 0036191", "SSF56436 : 0042430", "PS51371 : CBS", 
                      "SSF54570 : 0037627", "TIGR02231 : TIGR02231", "PIRSF000443 :", 
                      "SSF47473 : 0045442", "SSF55021 : 0052562", "SSF52540 : 0052832", 
                      "SSF55979 : 0053276", "PS51083 : ZF_HIT", "SSF47095 : 0038255", 
                      "PF00160 : Pro_isomerase", "SSF55681 : 0040152", "SSF51658 : 0051053", 
                      "SSF57095 : 0040748", "SSF53822 : 0036339", "SSF51735 : 0051763", 
                      "SSF50939 : 0044603", "SSF46626 : 0039644", "SSF63862 : 0047356", 
                      "SSF52980 : 0036173", "SSF55486 : 0037283", "PF01416 : PseudoU_synth_1", 
                      "PS51383 : YJEF_C_3", "PF01301 : Glyco_hydro_35", "SSF81508 : 0035493", 
                      "SSF48726 : 0048330", "PF01779 : Ribosomal_L29e", "SSF48726 : 0035585", 
                      "SSF57392 : 0046756", "SSF54160 : 0037964", "SSF57095 : 0044156", 
                      "PF02127 : Peptidase_M18", "TIGR01509 : HAD-SF-IA-v3", "SSF81296 : 0050647", 
                      "SSF51338 : 0053092", "SSF53067 : 0038007", "SSF55257 : 0038873", 
                      "SSF47413 : 0050823", "SSF109640 : 0044637", "SSF53244 : 0037574", 
                      "PIRSF033563 :", "SSF52799 : 0038311", "SSF48666 : 0040633", 
                      "SSF50494 : 0047648", "SSF52540 : 0049301", "SSF47819 : 0047020", 
                      "PF01262 : AlaDh_PNT_C", "TIGR01216 : ATP_synt_epsi", "SSF89447 : 0051298", 
                      "SSF52343 : 0041322", "SSF54826 : 0049412", "SSF50182 : 0045867", 
                      "SSF52518 : 0039738", "SSF51735 : 0037319", "PF07004 : DUF1309", 
                      "PF08837 : DUF1810", "SSF53335 : 0051885", "PF01918 : Alba", 
                      "SSF47170 : 0045165", "SSF52113 : 0039669", "SSF51735 : 0043703", 
                      "PS50931 : HTH_LYSR", "SSF51905 : 0035129", "SSF56300 : 0051479", 
                      "SSF54236 : 0049690", "SSF48508 : 0040840", "SSF56176 : 0037565", 
                      "SSF51905 : 0044941", "SSF48113 : 0039285", "PIRSF000908 :", 
                      "SSF51905 : 0037643", "SSF52172 : 0048231", "SSF46689 : 0046765", 
                      "SSF56436 : 0044613", "PF08089 : Toxin_20", "SSF50814 : 0047302", 
                      "SSF57552 : 0041045", "PF03561 : Allantoicase", "PF04151 : PPC", 
                      "SSF50630 : 0042297", "SSF56672 : 0042660", "SSF51126 : 0048737", 
                      "SSF54791 : 0052225", "SSF52788 : 0046251", "TIGR01662 : HAD-SF-IIIA", 
                      "SSF49265 : 0039422", "SSF56672 : 0040093", "SSF55909 : 0047136", 
                      "PF02093 : Gag_p30", "SSF54076 : 0036667", "SSF81296 : 0038293", 
                      "SSF56672 : 0053016", "SSF52540 : 0044418", "SSF55895 : 0039812", 
                      "SSF57184 : 0048103", "SSF46458 : 0047863", "SSF54768 : 0043879", 
                      "SSF50630 : 0042724", "SSF55021 : 0053150", "SSF52317 : 0049828", 
                      "SSF55666 : 0046448", "PIRSF002155 :", "PF05277 : DUF726", "SSF57059 : 0048034", 
                      "SSF48065 : 0040098", "SSF46774 : 0035817", "SSF48179 : 0037218", 
                      "SSF48464 : 0038769", "SSF50182 : 0048307", "SSF54593 : 0049534", 
                      "SSF47240 : 0048645", "PD039586 :", "PF00318 : Ribosomal_S2", 
                      "SSF54277 : 0047342", "SSF51735 : 0045319", "SSF81296 : 0035054", 
                      "PF00306 : ATP-synt_ab_C", "PR00139 : ASNGLNASE", "SSF55681 : 0049994", 
                      "SSF53067 : 0043896", "SSF50969 : 0053180", "SSF55186 : 0042737", 
                      "SSF48726 : 0045660", "SSF51206 : 0048513", "PF00067 : p450", 
                      "SSF55021 : 0053264", "PF04502 : DUF572", "PF00216 : Bac_DNA_binding", 
                      "PF01392 : Fz", "SSF56112 : 0046210", "PF08022 : FAD_binding_8", 
                      "SSF55681 : 0037215", "SSF63763 : 0038425", "SSF54403 : 0046949", 
                      "SSF57095 : 0048282", "PD351140 :", "SSF47005 : 0036891", "PR00322 : G10", 
                      "SSF47212 : 0045511", "SSF51735 : 0049117", "SSF48498 : 0053066", 
                      "SSF50324 : 0049724", "TIGR01609 : PF_unchar_267", "PS50828 : SMR", 
                      "SSF52799 : 0036941", "SSF57302 : 0042858", "SSF55811 : 0040258", 
                      "TIGR00037 : eIF_5A", "SSF57095 : 0041526", "SSF89623 : 0044504", 
                      "PR01443 : TFIID30KDSUB", "PF01039 : Carboxyl_trans", "PR00719 : LMWPTPASE", 
                      "SSF48726 : 0037371", "SSF49899 : 0041215", "PF04418 : DUF543", 
                      "SSF57196 : 0037636", "SSF56300 : 0046803", "SSF57667 : 0044261", 
                      "SSF100897 : 0042780", "SSF54236 : 0040481", "SSF53697 : 0041529", 
                      "SSF47113 : 0047574", "PF10594 : PP2A_B_subs_rcg", "SSF57362 : 0047876", 
                      "PF01150 : GDA1_CD39", "SSF110019 : 0043331", "SSF50129 : 0042138", 
                      "SSF57630 : 0045402", "SSF48695 : 0041853", "PR01469 : CARBMTKINASE", 
                      "SSF56327 : 0040468", "PF00390 : malic", "SSF48726 : 0040498", 
                      "SSF53218 : 0043851", "SSF52743 : 0038041", "SSF51735 : 0049026", 
                      "SSF51445 : 0039307", "SSF63829 : 0044582", "PF08545 : ACP_syn_III", 
                      "PF09785 : Prp31_C", "SSF56042 : 0043869", "SSF89895 : 0042212", 
                      "SSF57190 : 0040600", "PF00443 : UCH", "SSF54909 : 0047442", 
                      "PF00565 : SNase", "PF01345 : DUF11", "SSF54862 : 0045644", "SSF103481 : 0043518", 
                      "PF02229 : PC4", "SSF63867 : 0044570", "SSF88723 : 0034922", 
                      "SSF50249 : 0050885", "SSF51412 : 0039708", "SSF47473 : 0048467", 
                      "SSF48508 : 0041251", "SSF51445 : 0036006", "PR00456 : RIBOSOMALP2", 
                      "PF00588 : SpoU_methylase", "PF10250 : O-FucT", "SSF54593 : 0043872", 
                      "SSF51430 : 0036175", "PF07726 : AAA_3", "SSF54292 : 0038026", 
                      "SSF48508 : 0042832", "SSF52540 : 0035848", "SSF53182 : 0045701", 
                      "SSF48592 : 0034904", "TIGR00104 : YaeB_AF0241", "PF00563 : EAL", 
                      "SSF49879 : 0052821", "SSF50122 : 0039035", "SSF51905 : 0038200", 
                      "SSF50324 : 0053279", "PF00850 : Hist_deacetyl", "SSF46458 : 0039501", 
                      "SSF53901 : 0044961", "TIGR00108 : eRF", "TIGR00785 : dass", 
                      "SSF51569 : 0038079", "PD008148 :", "SSF55186 : 0044651", "SSF55770 : 0042397", 
                      "PIRSF010052 :", "PF00923 : Transaldolase", "PR00830 : ENDOLAPTASE", 
                      "SSF48264 : 0040482", "PF10499 : Pmp24", "SSF46946 : 0041084", 
                      "SSF54849 : 0045722", "TIGR01235 : pyruv_carbox", "SSF52343 : 0052011", 
                      "SSF81271 : 0048468", "SSF54897 : 0048431", "SSF48619 : 0040881", 
                      "SSF57667 : 0052920", "SSF55811 : 0043363", "SSF56655 : 0047396", 
                      "SSF48619 : 0040288", "SSF46785 : 0040326", "PF00790 : VHS", 
                      "SSF55021 : 0043950", "SSF46785 : 0044986", "PD128332 :", "PF05158 : RNA_pol_Rpc34", 
                      "SSF55729 : 0051420", "SSF53067 : 0044615", "SSF56235 : 0038203", 
                      "SSF82708 : 0044345", "SSF51445 : 0037870", "SSF57783 : 0043045", 
                      "SSF53335 : 0048106", "PS50162 : RECA_2", "SSF54001 : 0044273", 
                      "SSF51366 : 0038428", "SSF51011 : 0045140", "SSF48452 : 0037074", 
                      "SSF56014 : 0035139", "SSF110916 : 0039326", "SSF55347 : 0047085", 
                      "SSF47781 : 0036422", "SSF57196 : 0045804", "SSF55811 : 0037377", 
                      "PS50009 : RASGEF_CAT", "PF06991 : MFAP1_C", "SSF53254 : 0050036", 
                      "SSF51395 : 0050003", "SSF53613 : 0035753", "SSF53383 : 0041674", 
                      "SSF57667 : 0049852", "PS50857 : COX2_CUA", "SSF46785 : 0040517", 
                      "SSF52768 : 0051675", "SSF53474 : 0053348", "SSF81296 : 0042740", 
                      "SSF57567 : 0046191", "SSF47794 : 0045865", "PF03126 : Plus-3", 
                      "SSF51735 : 0046357", "SSF54897 : 0052023", "SSF54285 : 0050525", 
                      "PF09229 : Aha1_N", "PF00023 : Ank", "SSF47807 : 0043994", "SSF50182 : 0040518", 
                      "SSF48576 : 0045617", "SSF48726 : 0045132", "SSF82649 : 0050992", 
                      "SSF50692 : 0049658", "SSF48371 : 0036932", "PD000887 :", "SSF56300 : 0049558", 
                      "SSF57059 : 0048130", "PIRSF006641 :", "SSF55729 : 0051915", 
                      "PF04547 : DUF590", "SSF50156 : 0050835", "SSF54919 : 0047746", 
                      "SSF51905 : 0048364", "TIGR01034 : metK", "SSF51905 : 0046751", 
                      "SSF53187 : 0051428", "PF00312 : Ribosomal_S15", "SSF48726 : 0035574", 
                      "SSF54171 : 0035437", "SSF69340 : 0047855", "SSF57567 : 0036876", 
                      "SSF53790 : 0050110", "SSF51045 : 0036979", "SSF54506 : 0044178", 
                      "SSF47616 : 0045303", "SSF51735 : 0046114", "SSF48619 : 0040846", 
                      "PF04081 : DNA_pol_delta_4", "SSF50386 : 0043176", "SSF110993 : 0042661", 
                      "SSF53335 : 0049778", "PF06582 : DUF1136", "SSF51445 : 0047545", 
                      "PF01077 : NIR_SIR", "PS50896 : LISH", "SSF55257 : 0038879", 
                      "SSF51735 : 0050443", "SSF46785 : 0041732", "SSF57184 : 0040813", 
                      "PIRSF000107 :", "SSF52518 : 0044440", "SSF53822 : 0045291", 
                      "SSF46785 : 0051455", "SSF55979 : 0048781", "SSF48726 : 0044132", 
                      "SSF54593 : 0036909", "SSF53383 : 0044595", "PF01066 : CDP-OH_P_transf", 
                      "SSF55486 : 0047285", "SSF48726 : 0053108", "SSF46561 : 0052976", 
                      "SSF54197 : 0038273", "SSF53597 : 0038580", "SSF81710 : 0038294", 
                      "SSF54928 : 0048984", "SSF81464 : 0035180", "SSF53474 : 0053045", 
                      "SSF103196 : 0050163", "SSF53474 : 0045886", "PF02184 : HAT", 
                      "SSF57716 : 0052192", "SSF56436 : 0037161", "SSF49265 : 0047536", 
                      "SSF54897 : 0047433", "PD020287 :", "SSF53901 : 0043967", "SSF49785 : 0047745", 
                      "PR01854 : BR22PROTEIN", "PF00877 : NLPC_P60", "SSF46938 : 0041875", 
                      "SSF52833 : 0040664", "SSF57302 : 0048780", "SSF50447 : 0039670", 
                      "SSF53383 : 0049524", "PF00018 : SH3_1", "SSF51366 : 0049674", 
                      "SSF89957 : 0048049", "SSF49265 : 0049024", "SSF53098 : 0047793", 
                      "SSF54236 : 0043828", "SSF57774 : 0036771", "SSF54427 : 0038619", 
                      "PF04000 : Sas10_Utp3", "PD028529 :", "SSF51366 : 0036567", "SSF55874 : 0035339", 
                      "SSF54928 : 0052235", "SSF50494 : 0037179", "PIRSF015965 :", 
                      "SSF51197 : 0052657", "SSF51182 : 0044795", "SSF51695 : 0045414", 
                      "SSF51011 : 0041849", "SSF54928 : 0052240", "SSF46966 : 0046217", 
                      "PS51186 : GNAT", "PF00481 : PP2C", "SSF47240 : 0035536", "SSF52799 : 0047943", 
                      "PF07521 : RMMBL", "SSF69118 : 0052335", "PD006086 :", "SSF50465 : 0051768", 
                      "SSF51230 : 0048508", "PF07653 : SH3_2", "SSF49265 : 0049875", 
                      "PF07973 : tRNA_SAD", "PR00121 : NAKATPASE", "PF10498 : IFT57", 
                      "SSF56436 : 0049147", "SSF74650 : 0038722", "SSF48350 : 0050892", 
                      "SSF47954 : 0052578", "SSF53098 : 0039608", "SSF48726 : 0049539", 
                      "SSF51126 : 0048563", "SSF49503 : 0046106", "PF05147 : LANC_like", 
                      "SSF52172 : 0041616", "SSF56436 : 0036989", "SSF81452 : 0040794", 
                      "SSF52821 : 0044085", "SSF53271 : 0050349", "SSF56112 : 0043877", 
                      "SSF53167 : 0046099", "SSF49785 : 0049713", "TIGR01759 : MalateDH-SF1", 
                      "PIRSF006004 :", "PS51258 : MHD1", "PR00073 : COPRGNOXDASE", 
                      "SSF64268 : 0038437", "TIGR00016 : ackA", "SSF50800 : 0042358", 
                      "SSF53850 : 0046557", "SSF55811 : 0038765", "SSF51905 : 0036264", 
                      "SSF55550 : 0048620", "PF00484 : Pro_CA", "SSF56300 : 0039040", 
                      "SSF54826 : 0047650", "SSF48726 : 0046207", "PR00227 : GEMCOATAL1", 
                      "SSF52540 : 0039445", "PF01026 : TatD_DNase", "SSF55455 : 0036996", 
                      "SSF49354 : 0042169", "SSF54184 : 0043332", "SSF55681 : 0042520", 
                      "SSF54919 : 0048362", "SSF57535 : 0037925", "SSF69903 : 0040173", 
                      "SSF51735 : 0046801", "SSF48726 : 0043484", "SSF53335 : 0046840", 
                      "PS50303 : PUM_HD", "SSF51445 : 0035776", "SSF51556 : 0051697", 
                      "SSF52467 : 0051605", "SSF48726 : 0043942", "SSF54637 : 0051794", 
                      "PIRSF016393 :", "SSF55545 : 0042698", "TIGR00587 : nfo", "SSF46934 : 0052414", 
                      "SSF50249 : 0047920", "SSF52833 : 0038178", "SSF46785 : 0049363", 
                      "SSF47473 : 0036594", "SSF75412 : 0039134", "TIGR00607 : rad52", 
                      "PD004231 :", "SSF51569 : 0052334", "PF03998 : Utp11", "SSF56399 : 0042433", 
                      "PF01508 : Paramecium_SA", "PF00753 : Lactamase_B", "SSF51351 : 0049669", 
                      "SSF47781 : 0052275", "SSF55931 : 0040497", "PF04515 : DUF580", 
                      "SSF46894 : 0037483", "SSF54236 : 0050510", "PS50305 : SIRTUIN", 
                      "SSF81383 : 0037752", "PR00623 : HISTONEH4", "SSF48403 : 0039022", 
                      "SSF51197 : 0052654", "PF05026 : DCP2", "SSF81296 : 0039646", 
                      "SSF46626 : 0035912", "SSF50814 : 0040510", "SSF56645 : 0043403", 
                      "SSF56529 : 0038910", "PD004078 :", "PF04536 : DUF477", "PF02889 : Sec63", 
                      "PF00179 : UQ_con", "SSF50182 : 0049770", "SSF56796 : 0048580", 
                      "SSF55931 : 0035523", "SSF53686 : 0037348", "SSF52172 : 0049761", 
                      "SSF52335 : 0042363", "SSF49313 : 0040375", "PF03456 : uDENN", 
                      "SSF54452 : 0037149", "PF01012 : ETF", "PR00380 : KINESINHEAVY", 
                      "SSF54495 : 0051380", "PS50826 : RUN", "SSF48508 : 0037904", 
                      "SSF50911 : 0036793", "SSF51703 : 0046533", "SSF52317 : 0046130", 
                      "SSF46689 : 0046907", "SSF48113 : 0046200", "SSF110296 : 0043715", 
                      "PF07297 : DPM2", "SSF57059 : 0042823", "SSF51971 : 0046057", 
                      "SSF56634 : 0043021", "SSF51445 : 0048402", "PF01476 : LysM", 
                      "PF00415 : RCC1", "SSF88633 : 0035626", "SSF57247 : 0046067", 
                      "SSF57667 : 0052459", "PR00773 : GRPEPROTEIN", "SSF48726 : 0038358", 
                      "SSF52540 : 0037996", "SSF52821 : 0051398", "SSF46458 : 0043839", 
                      "SSF47655 : 0050005", "SSF88633 : 0050118", "SSF52833 : 0053320", 
                      "SSF50249 : 0050994", "SSF54919 : 0048778", "SSF54236 : 0050055", 
                      "SSF81631 : 0037462", "SSF89550 : 0040809", "PF00115 : COX1", 
                      "SSF53335 : 0053087", "SSF56112 : 0038120", "SSF48726 : 0037586", 
                      "SSF50104 : 0047482", "SSF57783 : 0045107", "SSF53474 : 0050563", 
                      "SSF101898 : 0042643", "PIRSF016013 :", "SSF51971 : 0042447", 
                      "SSF55753 : 0049533", "SSF53659 : 0050190", "PF00512 : HisKA", 
                      "SSF81296 : 0047072", "SSF56104 : 0044935", "SSF48726 : 0046149", 
                      "SSF50692 : 0048798", "SSF52317 : 0049495", "PR00052 : FIBRILLARIN", 
                      "SSF48619 : 0045405", "SSF75005 : 0048662", "SSF54452 : 0050385", 
                      "SSF53613 : 0047705", "SSF53474 : 0047317", "SSF75181 : 0040115", 
                      "SSF48695 : 0042003", "SSF81593 : 0041673", "SSF48726 : 0040073", 
                      "SSF52172 : 0046299", "TIGR00628 : ung", "PF00456 : Transketolase_N", 
                      "PF10409 : PTEN_C2", "SSF90112 : 0041811", "SSF52833 : 0045302", 
                      "SSF50978 : 0048759", "SSF54909 : 0041120", "SSF52141 : 0045509", 
                      "TIGR01350 : lipoamide_DH", "SSF47769 : 0046188", "SSF53659 : 0049072", 
                      "PF05190 : MutS_IV", "SSF51182 : 0039319", "SSF52317 : 0047949", 
                      "SSF53901 : 0042062", "SSF51905 : 0041696", "SSF46966 : 0048652", 
                      "SSF82714 : 0039246", "SSF55347 : 0051286", "SSF47819 : 0052106", 
                      "SSF53383 : 0042768", "SSF52972 : 0037237", "SSF57095 : 0039805", 
                      "SSF48619 : 0035595", "SSF50978 : 0041522", "SSF52799 : 0045098", 
                      "SSF52096 : 0052142", "SSF52833 : 0037584", "SSF48726 : 0037695", 
                      "SSF50249 : 0035597", "PD003329 :", "SSF54913 : 0045411", "SSF48726 : 0043307", 
                      "PD080110 :", "SSF56214 : 0037770", "SSF47473 : 0044028", "SSF55811 : 0051092", 
                      "SSF103506 : 0048588", "SSF52954 : 0041420", "SSF51351 : 0044928", 
                      "SSF49723 : 0035891", "SSF53223 : 0038223", "SSF46977 : 0048345", 
                      "SSF56574 : 0035774", "SSF48371 : 0038724", "SSF52283 : 0037438", 
                      "PS50969 : FCP1", "SSF57716 : 0050852", "PD006220 :", "SSF53474 : 0042912", 
                      "SSF57196 : 0040103", "SSF52833 : 0038800", "SSF54236 : 0050750", 
                      "SSF48230 : 0039308", "PF10531 : SLBB", "PS50102 : RRM", "SSF55979 : 0036208", 
                      "SSF50692 : 0046237", "SSF50249 : 0042612", "SSF47266 : 0035538", 
                      "SSF50104 : 0045010", "SSF56854 : 0040971", "SSF55770 : 0045758", 
                      "SSF46785 : 0051528", "SSF57059 : 0038016", "SSF54211 : 0051205", 
                      "SSF57247 : 0049581", "SSF56281 : 0050210", "TIGR01314 : gntK_FGGY", 
                      "PR00834 : PROTEASES2C", "SSF53254 : 0046349", "SSF49749 : 0042129", 
                      "SSF54975 : 0045149", "PS50330 : UIM", "PS50181 : FBOX", "SSF46934 : 0052216", 
                      "SSF54236 : 0050459", "SSF54752 : 0037886", "SSF88633 : 0043670", 
                      "SSF49695 : 0034884", "SSF46785 : 0047161", "SSF50923 : 0046742", 
                      "PR00762 : CLCHANNEL", "SSF52540 : 0053315", "SSF54292 : 0040223", 
                      "SSF56601 : 0036755", "SSF47473 : 0049327", "PS51143 : MT_A70", 
                      "SSF57196 : 0035422", "SSF48726 : 0039010", "SSF52540 : 0053146", 
                      "PF02714 : DUF221", "SSF56399 : 0049322", "SSF48726 : 0037673", 
                      "SSF48726 : 0038423", "SSF52266 : 0037156", "SSF47240 : 0045770", 
                      "SSF50129 : 0035135", "PF08083 : PROCN", "SSF56784 : 0051800", 
                      "SSF51556 : 0047785", "TIGR00813 : sss", "PR00686 : TIFACTORIID", 
                      "SSF47473 : 0040774", "SSF57783 : 0049613", "PR00132 : GLHYDRLASE2", 
                      "SSF54236 : 0038864", "SSF47769 : 0048657", "SSF54593 : 0046043", 
                      "SSF54637 : 0052351", "SSF57095 : 0035571", "SSF48097 : 0036068", 
                      "PD000944 :", "PIRSF005653 :", "SSF54928 : 0050806", "SSF52540 : 0038741", 
                      "SSF50249 : 0038199", "SSF56770 : 0035907", "SSF55957 : 0050632", 
                      "SSF50022 : 0041626", "SSF49303 : 0035553", "SSF48726 : 0049947", 
                      "SSF47473 : 0041056", "SSF54713 : 0046544", "SSF53187 : 0047971", 
                      "SSF53613 : 0050218", "SSF57770 : 0040899", "SSF51344 : 0036818", 
                      "SSF52833 : 0034959", "SSF88633 : 0036267", "SSF53383 : 0043780", 
                      "SSF63411 : 0052686", "SSF89895 : 0041627", "SSF54358 : 0037499", 
                      "SSF47794 : 0043813", "SSF52218 : 0036210", "SSF51735 : 0049943", 
                      "SSF51649 : 0045563", "SSF51905 : 0043211", "PR00395 : RIBOSOMALS2", 
                      "PF02602 : HEM4", "SSF50129 : 0038709", "SSF51045 : 0039636", 
                      "PIRSF000886 :", "SSF46689 : 0039206", "SSF53613 : 0044776", 
                      "SSF50814 : 0050277", "PF05195 : AMP_N", "SSF51735 : 0052085", 
                      "SSF89550 : 0044648", "SSF54117 : 0044136", "SSF52540 : 0041198", 
                      "PD004674 :", "PF04065 : Not3", "SSF57716 : 0052462", "SSF49899 : 0036338", 
                      "SSF51735 : 0046574", "SSF46934 : 0050161", "PD124462 :", "SSF53474 : 0037021", 
                      "SSF52540 : 0038163", "SSF82919 : 0048072", "SSF52954 : 0052344", 
                      "SSF47240 : 0051154", "SSF51182 : 0052595", "PF05154 : TM2", 
                      "SSF53067 : 0035475", "PS50229 : WH1", "SSF51445 : 0052086", 
                      "PIRSF017222 :", "SSF49503 : 0043554", "SSF54277 : 0050144", 
                      "SSF52833 : 0042441", "SSF50789 : 0044926", "SSF51445 : 0038369", 
                      "SSF51366 : 0044692", "PF04227 : Indigoidine_A", "PF06825 : HSBP1", 
                      "SSF50044 : 0044299", "PF00690 : Cation_ATPase_N", "SSF55103 : 0037316", 
                      "SSF52540 : 0040534", "SSF68923 : 0035265", "SSF47323 : 0052383", 
                      "SSF48726 : 0041360", "SSF51011 : 0038122", "SSF53623 : 0036834", 
                      "SSF51735 : 0052722", "SSF53697 : 0049756", "PIRSF000168 :", 
                      "SSF54928 : 0052219", "SSF48508 : 0042831", "PF04055 : Radical_SAM", 
                      "SSF50353 : 0040892", "SSF52418 : 0049963", "PF03439 : Supt5", 
                      "SSF64182 : 0047423", "SSF54001 : 0036067", "SSF54211 : 0044509", 
                      "PD135310 :", "SSF51445 : 0047795", "TIGR00229 : sensory_box", 
                      "SSF50249 : 0036158", "PF08491 : SE", "SSF81321 : 0050980", "PR00339 : PCNACYCLIN", 
                      "SSF81296 : 0037871", "SSF51197 : 0047081", "SSF46689 : 0051641", 
                      "SSF100895 : 0040469", "PD106560 :", "PF01156 : IU_nuc_hydro", 
                      "SSF54928 : 0052245", "SSF57095 : 0045775", "SSF51905 : 0045798", 
                      "SSF88645 : 0036514", "SSF50729 : 0036883", "SSF57262 : 0047229", 
                      "SSF47240 : 0037194", "SSF51445 : 0047766", "PF00017 : SH2", 
                      "PF04100 : Vps53_N", "SSF48726 : 0048926", "PF05990 : DUF900", 
                      "SSF51182 : 0050871", "PR00452 : SH3DOMAIN", "SSF55681 : 0048394", 
                      "SSF51735 : 0038784", "PD011034 :", "SSF51283 : 0049409", "SSF52980 : 0041285", 
                      "SSF47729 : 0042179", "SSF52309 : 0043475", "SSF53850 : 0044520", 
                      "SSF53807 : 0042423", "SSF56281 : 0050726", "SSF55486 : 0047530", 
                      "PD013585 :", "SSF54556 : 0047638", "SSF57716 : 0050854", "PF05705 : DUF829", 
                      "PF10034 : DUF2211", "SSF88645 : 0045196", "PF03564 : DUF1759", 
                      "SSF89155 : 0043531", "PF01880 : Desulfoferrodox", "SSF52518 : 0041403", 
                      "SSF54060 : 0045643", "SSF55469 : 0051556", "SSF51735 : 0047124", 
                      "SSF51206 : 0048600", "SSF46626 : 0038062", "SSF53697 : 0045017", 
                      "SSF50621 : 0053369", "SSF52518 : 0051963", "SSF47413 : 0049180", 
                      "SSF48508 : 0039072", "SSF101690 : 0049101", "SSF54909 : 0048188", 
                      "PD000612 :", "PR00988 : URIDINKINASE", "SSF51161 : 0048541", 
                      "SSF57262 : 0053345", "SSF52540 : 0040920", "SSF51177 : 0037234", 
                      "SSF50475 : 0052782", "SSF46689 : 0043286", "SSF56854 : 0041860", 
                      "SSF54593 : 0051065", "SSF48508 : 0042011", "SSF48113 : 0043633", 
                      "SSF48726 : 0051347", "SSF48113 : 0041122", "SSF51658 : 0052817", 
                      "PIRSF000381 :", "SSF53613 : 0051741", "PF09320 : DUF1977", "SSF51735 : 0040324", 
                      "SSF50104 : 0046771", "TIGR01657 : P-ATPase-V", "PF07524 : Bromo_TP", 
                      "SSF56655 : 0036358", "SSF52833 : 0052802", "SSF49265 : 0037416", 
                      "SSF53383 : 0039733", "PS51039 : ZF_AN1", "SSF48317 : 0042804", 
                      "SSF48179 : 0051872", "SSF49695 : 0038504", "PF02475 : Met_10", 
                      "SSF53178 : 0045428", "SSF50249 : 0046451", "SSF47266 : 0038842", 
                      "PD005541 :", "SSF54637 : 0035729", "SSF52980 : 0036036", "SSF48726 : 0047640", 
                      "SSF54001 : 0047735", "SSF51556 : 0049957", "SSF51604 : 0053189", 
                      "SSF52833 : 0051703", "SSF48371 : 0038439", "PF06541 : DUF1113", 
                      "SSF51126 : 0038586", "PS51292 : ZF_RING_CH", "PD002367 :", "TIGR00524 : eIF-2B_rel", 
                      "SSF46785 : 0038751", "SSF53383 : 0041861", "SSF52009 : 0036441", 
                      "PF07344 : Amastin", "SSF55326 : 0050291", "SSF52467 : 0047672", 
                      "PF07998 : DUF1695", "SSF47413 : 0045765", "SSF51445 : 0041850", 
                      "SSF51011 : 0046335", "SSF54909 : 0051166", "SSF46785 : 0035369", 
                      "SSF48592 : 0039106", "PF03199 : GSH_synthase", "PF01409 : tRNA-synt_2d", 
                      "SSF53955 : 0039756", "PF01171 : ATP_bind_3", "SSF48208 : 0050085", 
                      "SSF54966 : 0049141", "SSF52540 : 0042789", "SSF54928 : 0052223", 
                      "SSF51445 : 0046891", "SSF55681 : 0050706", "SSF53067 : 0051970", 
                      "SSF52540 : 0053350", "PF01926 : MMR_HSR1", "SSF51735 : 0041366", 
                      "SSF47917 : 0043646", "SSF53822 : 0049650", "SSF47413 : 0038966", 
                      "SSF54292 : 0045410", "SSF56112 : 0035157", "SSF57667 : 0050622", 
                      "SSF47170 : 0045350", "PIRSF001480 :", "SSF88633 : 0045357", 
                      "SSF50814 : 0048536", "SSF47616 : 0040520", "PF08392 : FAE1_CUT1_RppA", 
                      "SSF49265 : 0041201", "SSF48498 : 0053097", "SSF56112 : 0049347", 
                      "SSF88713 : 0052092", "PIRSF001555 :", "SSF57184 : 0041270", 
                      "SSF51161 : 0040227", "PF02861 : Clp_N", "SSF55729 : 0040331", 
                      "SSF51445 : 0047754", "PF06814 : Lung_7-TM_R", "PF08485 : Polysacc_syn_2C", 
                      "SSF53955 : 0042163", "SSF51621 : 0048078", "SSF50729 : 0050771", 
                      "SSF54076 : 0043357", "PS50858 : BSD", "SSF46689 : 0043937", 
                      "SSF48726 : 0042555", "PF00121 : TIM", "SSF53448 : 0040882", 
                      "SSF47473 : 0038094", "SSF63411 : 0046660", "PD181906 :", "PR00465 : EP450IV", 
                      "SSF51283 : 0041047", "SSF46689 : 0053202", "SSF47266 : 0035360", 
                      "SSF53383 : 0051993", "SSF52954 : 0044672", "SSF54534 : 0043832", 
                      "SSF47226 : 0045137", "SSF81301 : 0045003", "SSF54637 : 0049346", 
                      "SSF54292 : 0035241", "SSF81790 : 0039331", "SSF48403 : 0047469", 
                      "SSF50249 : 0048514", "SSF54001 : 0046199", "SSF49899 : 0038351", 
                      "SSF57492 : 0045425", "SSF54957 : 0043171", "SSF88713 : 0051128", 
                      "SSF52374 : 0044609", "PF00611 : FCH", "SSF49384 : 0045489", 
                      "SSF53901 : 0053135", "SSF54631 : 0035335", "SSF101912 : 0043620", 
                      "SSF53056 : 0037944", "SSF51735 : 0038853", "PF01916 : DS", "SSF46906 : 0047166", 
                      "SSF81382 : 0037754", "SSF56935 : 0040153", "SSF81301 : 0040957", 
                      "PF07382 : HC2", "SSF48239 : 0036348", "SSF110296 : 0049445", 
                      "SSF55331 : 0044385", "SSF51735 : 0052744", "PR00303 : SECYTRNLCASE", 
                      "SSF53271 : 0041160", "SSF55486 : 0038697", "PS50821 : PAZ", 
                      "SSF81585 : 0043450", "PF00125 : Histone", "SSF81452 : 0042845", 
                      "SSF50814 : 0040896", "SSF56784 : 0052850", "SSF57535 : 0049044", 
                      "SSF49348 : 0048848", "SSF49899 : 0045053", "SSF88633 : 0035266", 
                      "SSF81343 : 0042843", "SSF69695 : 0040287", "SSF52425 : 0036513", 
                      "SSF55021 : 0052153", "SSF51182 : 0051192", "SSF55447 : 0037564", 
                      "SSF56349 : 0034861", "SSF51445 : 0050404", "SSF100895 : 0046016", 
                      "SSF50249 : 0037797", "SSF50729 : 0049677", "SSF47616 : 0038646", 
                      "SSF46785 : 0052755", "PIRSF036580 :", "SSF53335 : 0041444", 
                      "SSF56053 : 0043294", "SSF55205 : 0037963", "SSF49503 : 0036161", 
                      "SSF49695 : 0044983", "PF09122 : DUF1930", "SSF56399 : 0050509", 
                      "SSF54826 : 0039289", "PF09382 : RQC", "SSF51735 : 0046673", 
                      "SSF56436 : 0044448", "PS51196 : SECA_MOTOR_DEAD", "SSF54160 : 0050791", 
                      "PF00270 : DEAD", "SSF49401 : 0052190", "SSF56349 : 0035058", 
                      "SSF69047 : 0043420", "SSF54637 : 0048813", "SSF48726 : 0043412", 
                      "SSF57716 : 0050848", "PD186100 :", "SSF47473 : 0036052", "PIRSF019736 :", 
                      "SSF82199 : 0048228", "SSF51703 : 0047460", "PF03828 : PAP_assoc", 
                      "PD870432 :", "PF01713 : Smr", "PF03381 : CDC50", "SSF47175 : 0035439", 
                      "SSF54285 : 0044162", "SSF53067 : 0048237", "SSF88633 : 0035504", 
                      "SSF57903 : 0037717", "SSF48557 : 0037332", "SSF51735 : 0039788", 
                      "SSF52833 : 0036792", "SSF55239 : 0035764", "SSF55729 : 0049884", 
                      "SSF81296 : 0048348", "SSF48613 : 0050673", "SSF56327 : 0043508", 
                      "SSF50729 : 0039316", "PR00449 : RASTRNSFRMNG", "SSF56808 : 0036019", 
                      "PIRSF029271 :", "SSF46689 : 0052305", "SSF54001 : 0040275", 
                      "SSF55681 : 0042729", "SSF48371 : 0042067", "SSF56059 : 0047408", 
                      "PF00857 : Isochorismatase", "SSF54334 : 0044159", "SSF50353 : 0047368", 
                      "PR00799 : TRANSAMINASE", "SSF88633 : 0035505", "PF04824 : Rad21_Rec8", 
                      "SSF55729 : 0042972", "PF00682 : HMGL-like", "PS50887 : GGDEF", 
                      "SSF53474 : 0041012", "SSF75632 : 0040462", "SSF50203 : 0035767", 
                      "SSF48371 : 0048666", "PS50092 : TSP1", "SSF53901 : 0044096", 
                      "SSF57196 : 0047694", "SSF50353 : 0045337", "SSF101322 : 0043048", 
                      "SSF47616 : 0048787", "SSF88946 : 0043329", "SSF74924 : 0052211", 
                      "SSF48726 : 0039594", "PF01119 : DNA_mis_repair", "PF08543 : Phos_pyr_kin", 
                      "SSF48726 : 0045085", "SSF46458 : 0038560", "SSF51735 : 0049766", 
                      "SSF52540 : 0043923", "SSF54236 : 0040559", "PF00344 : SecY", 
                      "SSF57667 : 0037795", "SSF57095 : 0043673", "SSF48613 : 0048646", 
                      "PD011184 :", "SSF57095 : 0042398", "PF09739 : DUF2044", "SSF63380 : 0042742", 
                      "SSF51905 : 0048200", "SSF53901 : 0050445", "SSF54277 : 0041820", 
                      "SSF49835 : 0042800", "SSF51445 : 0047436", "PF07947 : YhhN", 
                      "SSF57586 : 0041971", "PF04554 : Extensin_2", "SSF53633 : 0053148", 
                      "SSF57095 : 0048671", "SSF57095 : 0048979", "SSF49265 : 0050844", 
                      "PS51144 : ALPHA_CA_2", "SSF53474 : 0036568", "SSF47240 : 0043194", 
                      "SSF53738 : 0040059", "SSF52540 : 0050227", "SSF56300 : 0051688", 
                      "PF05237 : MoeZ_MoeB", "SSF55200 : 0045334", "SSF47266 : 0050703", 
                      "SSF53448 : 0037578", "SSF48557 : 0036521", "SSF57016 : 0045674", 
                      "SSF51395 : 0048029", "SSF51445 : 0046993", "SSF52499 : 0039336", 
                      "SSF109604 : 0053085", "PS50967 : HRDC", "SSF48695 : 0049967", 
                      "SSF54236 : 0046977", "SSF52058 : 0039014", "SSF48726 : 0040007", 
                      "SSF56645 : 0039701", "PF00144 : Beta-lactamase", "SSF82057 : 0040856", 
                      "SSF53807 : 0041206", "SSF53649 : 0042147", "SSF56112 : 0053164", 
                      "SSF46785 : 0045284", "SSF55770 : 0037353", "PF00830 : Ribosomal_L28", 
                      "PF03259 : Robl_LC7", "SSF55681 : 0048309", "SSF54593 : 0053079", 
                      "SSF53187 : 0039698", "SSF81483 : 0036661", "SSF101801 : 0041753", 
                      "TIGR00339 : sopT", "SSF56042 : 0043868", "PS51140 : CUE", "SSF75005 : 0038330", 
                      "PS50133 : FCH", "PD005267 :", "SSF56672 : 0036278", "SSF103575 : 0049403", 
                      "SSF52058 : 0053105", "SSF51161 : 0051363", "SSF51045 : 0036698", 
                      "SSF54236 : 0038082", "SSF47576 : 0035604", "SSF50939 : 0049431", 
                      "SSF55298 : 0042987", "SSF48225 : 0040220", "SSF54236 : 0036845", 
                      "SSF46946 : 0049091", "SSF48726 : 0041909", "SSF48726 : 0044693", 
                      "SSF55486 : 0049313", "SSF52540 : 0048044", "PF01267 : F-actin_cap_A", 
                      "SSF51735 : 0048516", "SSF54928 : 0052238", "SSF81648 : 0042668", 
                      "TIGR00239 : 2oxo_dh_E1", "SSF55961 : 0040573", "SSF54675 : 0042921", 
                      "SSF49265 : 0038104", "SSF56112 : 0036031", "PIRSF000737 :", 
                      "SSF51445 : 0046471", "SSF55120 : 0040245", "SSF50814 : 0041168", 
                      "SSF81296 : 0046167", "SSF57598 : 0035029", "SSF55681 : 0045676", 
                      "PF01288 : HPPK", "SSF54452 : 0043009", "SSF46785 : 0051665", 
                      "SSF53335 : 0043871", "SSF53850 : 0034947", "SSF53807 : 0048271", 
                      "SSF50494 : 0037075", "SSF48619 : 0042187", "SSF52833 : 0034952", 
                      "PS50908 : RWD", "PF01610 : Transposase_12", "PD008480 :", "SSF50923 : 0046971", 
                      "SSF51120 : 0040000", "TIGR00322 : diphth2_R", "SSF54495 : 0044580", 
                      "SSF52833 : 0045514", "SSF54160 : 0046431", "SSF50022 : 0044891", 
                      "SSF51735 : 0035952", "PF00670 : AdoHcyase_NAD", "TIGR01444 : fkbM_fam", 
                      "SSF46955 : 0036272", "SSF52768 : 0051754", "SSF69864 : 0044855", 
                      "SSF50630 : 0038961", "SSF55347 : 0039315", "SSF48537 : 0041911", 
                      "SSF55811 : 0037875", "PF02121 : IP_trans", "SSF50494 : 0049401", 
                      "SSF55945 : 0041039", "SSF51735 : 0038379", "SSF56349 : 0039910", 
                      "SSF51445 : 0049054", "SSF46626 : 0046084", "SSF50630 : 0045161", 
                      "SSF52266 : 0050207", "SSF53649 : 0037136", "SSF52833 : 0045740", 
                      "SSF54416 : 0035221", "SSF51735 : 0036928", "TIGR01703 : hybrid_clust", 
                      "SSF51412 : 0051569", "PD000281 :", "SSF69572 : 0047696", "PF02435 : Glyco_hydro_68", 
                      "SSF81296 : 0037000", "PF10469 : AKAP7_NLS", "SSF51604 : 0035662", 
                      "SSF49899 : 0045632", "SSF54593 : 0040291", "PF05183 : RdRP", 
                      "SSF53335 : 0052182", "SSF51126 : 0047186", "SSF53383 : 0035586", 
                      "TIGR01859 : fruc_bis_ald_", "SSF50939 : 0037197", "SSF51679 : 0040668", 
                      "SSF49417 : 0045080", "PIRSF016478 :", "SSF48726 : 0044276", 
                      "PF03847 : TFIID_20kDa", "SSF74877 : 0040336", "SSF49503 : 0042796", 
                      "SSF47836 : 0038565", "SSF54862 : 0046170", "SSF52540 : 0036718", 
                      "SSF50729 : 0043361", "SSF81296 : 0048082", "PR00368 : FADPNR", 
                      "SSF54909 : 0040613", "PIRSF037736 :", "SSF53383 : 0039207", 
                      "SSF52374 : 0041798", "SSF109604 : 0046668", "SSF46785 : 0043164", 
                      "SSF82607 : 0042469", "SSF81296 : 0042075", "SSF48619 : 0042403", 
                      "SSF51206 : 0052861", "PF03493 : BK_channel_a", "SSF57756 : 0036578", 
                      "TIGR01451 : B_ant_repeat", "SSF57716 : 0040677", "SSF50044 : 0041957", 
                      "SSF51735 : 0038050", "SSF47240 : 0036622", "TIGR03531 : selenium_SpcS", 
                      "SSF47240 : 0051629", "SSF49842 : 0039541", "SSF55120 : 0050102", 
                      "SSF56371 : 0041975", "SSF56436 : 0051365", "SSF47220 : 0043752", 
                      "SSF54862 : 0037837", "SSF52540 : 0036018", "SSF54534 : 0049810", 
                      "SSF48371 : 0047107", "PF06966 : DUF1295", "SSF51182 : 0050074", 
                      "SSF54292 : 0045591", "SSF51905 : 0052313", "SSF57196 : 0040626", 
                      "SSF56112 : 0037714", "SSF81296 : 0038446", "SSF50677 : 0046954", 
                      "PF02383 : Syja_N", "SSF50465 : 0040120", "SSF54403 : 0048317", 
                      "SSF56672 : 0049395", "SSF82026 : 0038350", "SSF110399 : 0049739", 
                      "SSF51445 : 0044281", "SSF56762 : 0038381", "SSF56091 : 0049326", 
                      "SSF46785 : 0045885", "SSF51621 : 0042073", "PF04571 : Lipin_N", 
                      "PD001314 :", "PD042158 :", "SSF55909 : 0051002", "TIGR01607 : PST-A", 
                      "SSF51120 : 0043539", "SSF54631 : 0053232", "SSF102891 : 0043014", 
                      "SSF50447 : 0049290", "SSF53927 : 0050639", "PF06957 : COPI_C", 
                      "SSF55961 : 0051031", "SSF49265 : 0053083", "TIGR02342 : chap_CCT_delta", 
                      "SSF63887 : 0039548", "PF08610 : Pex16", "SSF54368 : 0040496", 
                      "SSF53822 : 0048996", "SSF48498 : 0050080", "SSF54277 : 0038963", 
                      "PIRSF028973 :", "SSF101089 : 0043115", "SSF51087 : 0042010", 
                      "SSF56176 : 0038702", "SSF101353 : 0043262", "SSF55282 : 0039125", 
                      "SSF69572 : 0041383", "SSF52833 : 0051912", "PIRSF022950 :", 
                      "SSF52821 : 0043247", "SSF56645 : 0049407", "SSF46458 : 0035426", 
                      "PF00557 : Peptidase_M24", "PF04158 : Sof1", "SSF63380 : 0046818", 
                      "SSF81296 : 0047489", "SSF55248 : 0044505", "PR00476 : PHFRCTKINASE", 
                      "SSF56436 : 0041727", "TIGR00763 : lon", "SSF51445 : 0050760", 
                      "SSF51395 : 0042110", "SSF47954 : 0047613", "SSF56112 : 0037803", 
                      "PF00632 : HECT", "SSF51569 : 0048453", "SSF64076 : 0039031", 
                      "SSF49599 : 0037650", "PS50802 : OTU", "SSF56801 : 0035109", 
                      "SSF54909 : 0052162", "SSF46458 : 0035323", "SSF57196 : 0049663", 
                      "PD012695 :", "SSF46458 : 0038515", "PS50203 : CALPAIN_CAT", 
                      "SSF56601 : 0047175", "TIGR01499 : folC", "SSF55961 : 0051879", 
                      "SSF51679 : 0037300", "SSF69635 : 0051004", "SSF46785 : 0051170", 
                      "SSF51905 : 0047564", "SSF52799 : 0048076", "SSF101215 : 0044598", 
                      "SSF52440 : 0036617", "PD215945 :", "SSF57603 : 0052163", "SSF55287 : 0036685", 
                      "SSF51735 : 0042505", "SSF88633 : 0046508", "SSF55298 : 0049042", 
                      "SSF54593 : 0044146", "SSF48552 : 0035619", "SSF57567 : 0036088", 
                      "SSF52507 : 0049358", "SSF51905 : 0047565", "SSF51366 : 0041543", 
                      "SSF56436 : 0046789", "PD007661 :", "SSF52440 : 0046561", "SSF55298 : 0048914", 
                      "SSF55753 : 0039551", "PF00474 : SSF", "SSF54518 : 0035881", 
                      "SSF50630 : 0045501", "PR00095 : ANTSNTHASEI", "PF00307 : CH", 
                      "SSF81296 : 0052397", "TIGR00401 : msrA", "TIGR01589 : A_thal_3526", 
                      "SSF50156 : 0044436", "SSF52467 : 0048859", "PF07919 : DUF1683", 
                      "SSF52833 : 0044455", "SSF52374 : 0048275", "SSF57196 : 0046120", 
                      "PF07721 : TPR_4", "SSF52540 : 0043218", "PIRSF000534 :", "SSF46458 : 0040156", 
                      "SSF51430 : 0046098", "PF01380 : SIS", "PF03633 : Glyco_hydro_65C", 
                      "SSF48498 : 0052648", "SSF82784 : 0040616", "SSF47090 : 0051968", 
                      "PS51263 : ADF_H", "TIGR01037 : pyrD_sub1_fam", "SSF48726 : 0044255", 
                      "SSF53067 : 0046015", "SSF48726 : 0038987", "SSF46596 : 0034849", 
                      "SSF47473 : 0035707", "SSF69118 : 0052929", "SSF51197 : 0047027", 
                      "SSF54975 : 0044936", "SSF47364 : 0044892", "SSF56281 : 0044806", 
                      "PF00233 : PDEase_I", "SSF54495 : 0051858", "SSF50814 : 0038129", 
                      "SSF101224 : 0041827", "SSF49842 : 0035820", "SSF52540 : 0039715", 
                      "SSF81767 : 0041440", "PIRSF005067 :", "SSF49452 : 0041432", 
                      "SSF110004 : 0043785", "PS51007 : CYTC", "SSF48425 : 0040263", 
                      "PS51363 : W2", "PR00346 : TISSUEFACTOR", "SSF50998 : 0047890", 
                      "SSF47616 : 0048663", "SSF52313 : 0044773", "PF04810 : zf-Sec23_Sec24", 
                      "SSF54529 : 0042130", "PS50109 : HIS_KIN", "TIGR01328 : met_gam_lyase", 
                      "SSF54826 : 0052918", "SSF55608 : 0035652", "SSF51735 : 0039895", 
                      "SSF48371 : 0049277", "PF00303 : Thymidylat_synt", "SSF52540 : 0036729", 
                      "SSF47175 : 0052148", "SSF54791 : 0044782", "PF08729 : HPC2", 
                      "SSF53182 : 0047403", "PS50069 : CULLIN_2", "SSF50156 : 0043682", 
                      "SSF47413 : 0051249", "SSF51735 : 0038559", "SSF88659 : 0047455", 
                      "SSF46785 : 0047959", "PF01564 : Spermine_synth", "SSF49785 : 0042192", 
                      "SSF52922 : 0049137", "SSF52374 : 0048544", "SSF54373 : 0037068", 
                      "SSF53448 : 0044168", "TIGR00184 : purA", "SSF47819 : 0046279", 
                      "PS51221 : TTL", "SSF53067 : 0051548", "SSF53756 : 0051304", 
                      "PF00698 : Acyl_transf_1", "PF02801 : Ketoacyl-synt_C", "SSF54452 : 0038861", 
                      "SSF57196 : 0046589", "SSF52540 : 0048381", "SSF46689 : 0052655", 
                      "SSF53927 : 0035093", "SSF53613 : 0043278", "SSF50692 : 0047096", 
                      "PS50829 : GYF", "PF06544 : DUF1115", "SSF48113 : 0046223", "PF00795 : CN_hydrolase", 
                      "PS51036 : ZF_A20", "PS01031 : HSP20", "PR00076 : 6PGDHDRGNASE", 
                      "PF05649 : Peptidase_M13_N", "SSF46785 : 0051026", "SSF54511 : 0041029", 
                      "SSF53671 : 0051826", "PF04140 : ICMT", "PR00627 : GTPRANTC4", 
                      "SSF55194 : 0038065", "SSF52788 : 0042188", "SSF57095 : 0041258", 
                      "PF07773 : DUF1619", "SSF89009 : 0042072", "SSF49899 : 0038677", 
                      "PF01717 : Meth_synt_2", "PF05602 : CLPTM1", "SSF53167 : 0050186", 
                      "PF00206 : Lyase_1", "PR00369 : FLAVODOXIN", "SSF52518 : 0040413", 
                      "SSF47266 : 0045298", "SSF57535 : 0046991", "SSF50331 : 0042556", 
                      "SSF52029 : 0048884", "SSF48371 : 0045897", "SSF57850 : 0047624", 
                      "SSF46934 : 0052228", "PF08772 : NOB1_Zn_bind", "SSF46785 : 0052159", 
                      "PF01116 : F_bP_aldolase", "SSF89550 : 0051802", "SSF54236 : 0044597", 
                      "SSF54001 : 0044814", "PF10609 : ParA", "SSF55486 : 0037125", 
                      "PR00926 : MITOCARRIER", "SSF47473 : 0041542", "SSF103111 : 0044510", 
                      "SSF51735 : 0048455", "SSF47027 : 0038513", "TIGR00846 : caca2", 
                      "SSF53032 : 0043078", "SSF46955 : 0042522", "SSF52821 : 0044491", 
                      "SSF57196 : 0049500", "SSF53901 : 0044094", "PR00318 : GPROTEINA", 
                      "PF08389 : Xpo1", "PD016827 :", "SSF46785 : 0035239", "SSF54236 : 0047969", 
                      "SSF46785 : 0039213", "SSF46785 : 0052725", "PF01753 : zf-MYND", 
                      "SSF81442 : 0040791", "SSF56327 : 0053022", "SSF53474 : 0045574", 
                      "SSF48726 : 0037888", "SSF56112 : 0044036", "SSF53067 : 0044999", 
                      "SSF110993 : 0051772", "SSF52540 : 0039426", "PF03629 : DUF303", 
                      "SSF48498 : 0049911", "PF06839 : zf-GRF", "SSF52518 : 0035516", 
                      "SSF48726 : 0044970", "SSF50249 : 0035396", "PF04539 : Sigma70_r3", 
                      "PF05403 : Plasmodium_HRP", "SSF48065 : 0037708", "SSF50331 : 0038498", 
                      "SSF50939 : 0046491", "PF01863 : DUF45", "SSF49899 : 0037978", 
                      "PF08490 : DUF1744", "PF04419 : 4F5", "SSF56601 : 0041126", "SSF46626 : 0040640", 
                      "PF00528 : BPD_transp_1", "SSF48179 : 0037318", "SSF81464 : 0037008", 
                      "SSF56784 : 0039428", "SSF53187 : 0043109", "SSF54826 : 0036853", 
                      "SSF53300 : 0049400", "SSF50978 : 0047024", "PF10235 : Cript", 
                      "SSF53671 : 0037062", "SSF51735 : 0038761", "SSF102824 : 0044644", 
                      "PF03175 : DNA_pol_B_2", "PF08267 : Meth_synt_1", "PF06423 : GWT1", 
                      "SSF52833 : 0041456", "SSF50044 : 0037901", "SSF55729 : 0042108", 
                      "SSF81301 : 0043451", "SSF54719 : 0042186", "PS50254 : REL_2", 
                      "SSF51182 : 0040779", "PD023243 :", "SSF56219 : 0043722", "SSF55957 : 0045552", 
                      "SSF47616 : 0041804", "SSF47220 : 0049191", "TIGR02150 : IPP_isom_1", 
                      "SSF57850 : 0050592", "SSF51735 : 0047965", "SSF57924 : 0040778", 
                      "PF05997 : Nop52", "SSF48371 : 0050417", "SSF55856 : 0040012", 
                      "PF08519 : RFC1", "SSF50044 : 0046960", "SSF46689 : 0045977", 
                      "PF02042 : RWP-RK", "SSF90123 : 0053060", "SSF53223 : 0036518", 
                      "PIRSF000412 :", "SSF51569 : 0037475", "SSF52833 : 0043753", 
                      "SSF53335 : 0052484", "SSF57868 : 0042815", "SSF50630 : 0035359", 
                      "PF01011 : PQQ", "SSF52935 : 0034860", "SSF82153 : 0041721", 
                      "SSF50249 : 0048643", "PIRSF015945 :", "SSF52096 : 0048518", 
                      "SSF55486 : 0046743", "PF09336 : Vps4_C", "SSF54556 : 0040489", 
                      "SSF55469 : 0044736", "SSF81811 : 0040742", "SSF48726 : 0048753", 
                      "PR00875 : MTMOLLUSC", "SSF54427 : 0041822", "SSF56808 : 0035002", 
                      "SSF55620 : 0041300", "SSF54791 : 0044119", "SSF53335 : 0052739", 
                      "SSF54452 : 0040621", "SSF48613 : 0042028", "SSF52540 : 0039136", 
                      "SSF51735 : 0048755", "PIRSF006698 :", "PF03908 : Sec20", "PF02580 : Tyr_Deacylase", 
                      "TIGR01012 : Sa_S2_E_A", "SSF53067 : 0035531", "TIGR01317 : GOGAT_sm_gam", 
                      "SSF57535 : 0051584", "PF04777 : Evr1_Alr", "TIGR00536 : hemK_fam", 
                      "SSF55811 : 0042585", "SSF52467 : 0046541", "SSF51246 : 0044432", 
                      "PIRSF000847 :", "SSF48726 : 0046081", "SSF49309 : 0037872", 
                      "SSF74924 : 0047463", "PR00889 : CALPONIN", "SSF51649 : 0051333", 
                      "SSF53686 : 0044649", "SSF51395 : 0048661", "SSF51395 : 0046599", 
                      "TIGR02343 : chap_CCT_epsi", "SSF53383 : 0047095", "SSF53756 : 0044616", 
                      "SSF52151 : 0048659", "SSF47459 : 0038629", "PF09149 : DUF1935", 
                      "SSF56801 : 0040895", "SSF51569 : 0037423", "SSF53187 : 0047901", 
                      "SSF74650 : 0043394", "SSF48350 : 0041355", "PF08953 : DUF1899", 
                      "PF01909 : NTP_transf_2", "SSF51735 : 0049428", "SSF103243 : 0044422", 
                      "SSF56399 : 0046994", "PD020165 :", "SSF50044 : 0045146", "SSF46785 : 0049308", 
                      "SSF47473 : 0045999", "SSF55770 : 0046690", "SSF50044 : 0044401", 
                      "SSF57302 : 0040232", "SSF55073 : 0050343", "SSF54001 : 0050362", 
                      "SSF51679 : 0037801", "SSF81321 : 0035839", "PF04506 : Rft-1", 
                      "SSF55347 : 0042828", "SSF51445 : 0051370", "SSF55811 : 0047252", 
                      "PR01799 : SFASSEMBLIN", "SSF69255 : 0039860", "PS51189 : FAT", 
                      "SSF56436 : 0051512", "SSF51735 : 0044474", "SSF56784 : 0051324", 
                      "SSF54897 : 0043548", "PF01368 : DHH", "PS50059 : FKBP_PPIASE", 
                      "SSF49367 : 0036410", "SSF54637 : 0042635", "SSF88713 : 0051910", 
                      "PF09468 : RNase_H2-Ydr279", "PF03986 : Autophagy_N", "SSF50182 : 0036253", 
                      "PIRSF019307 :", "SSF55486 : 0035187", "SSF57059 : 0046352", 
                      "SSF82784 : 0044408", "SSF56019 : 0040144", "SSF49899 : 0047966", 
                      "SSF48576 : 0046658", "SSF50475 : 0051356", "SSF51569 : 0035007", 
                      "PF03081 : Exo70", "SSF48726 : 0052251", "SSF54285 : 0049270", 
                      "SSF53748 : 0042919", "SSF53187 : 0052091", "PF10458 : Val_tRNA-synt_C", 
                      "SSF54919 : 0049823", "SSF52343 : 0043660", "SSF56601 : 0046565", 
                      "SSF50475 : 0046143", "PF03738 : GSP_synth", "SSF53271 : 0051755", 
                      "PS51355 : GLUTATHIONE_PEROXID_3", "SSF48690 : 0036819", "PIRSF037913 :", 
                      "SSF55347 : 0041584", "SSF50386 : 0034946", "SSF46785 : 0045833", 
                      "PD017229 :", "SSF52821 : 0049980", "SSF57392 : 0035197", "SSF48498 : 0053236", 
                      "SSF53474 : 0048675", "SSF49723 : 0041912", "SSF54076 : 0041881", 
                      "SSF54556 : 0040069", "SSF52218 : 0049022", "PF00861 : Ribosomal_L18p", 
                      "SSF52980 : 0050355", "SSF54236 : 0047534", "SSF53335 : 0051884", 
                      "SSF50346 : 0042908", "SSF46938 : 0045821", "SSF57016 : 0044359", 
                      "SSF47014 : 0037144", "SSF51395 : 0049708", "PF00888 : Cullin", 
                      "SSF52540 : 0051471", "SSF54637 : 0053052", "SSF52374 : 0038154", 
                      "SSF53067 : 0051254", "SSF49584 : 0042170", "SSF53474 : 0036162", 
                      "SSF52980 : 0051167", "SSF56327 : 0040543", "SSF53271 : 0041991", 
                      "SSF52540 : 0040100", "SSF51366 : 0036628", "SSF51735 : 0047869", 
                      "SSF49401 : 0041231", "PF00995 : Sec1", "SSF47240 : 0039591", 
                      "SSF53720 : 0034877", "PF03159 : XRN_N", "SSF51316 : 0044153", 
                      "SSF69036 : 0039844", "PF01769 : MgtE", "SSF51445 : 0038228", 
                      "SSF54495 : 0044417", "SSF52467 : 0035515", "SSF50677 : 0039070", 
                      "SSF50621 : 0046698", "SSF56112 : 0036014", "PF04757 : Pex2_Pex12", 
                      "PF03447 : NAD_binding_3", "SSF54637 : 0053213", "SSF48619 : 0044463", 
                      "SSF51161 : 0045025", "SSF55931 : 0052392", "SSF51126 : 0043308", 
                      "PF00581 : Rhodanese", "SSF53335 : 0041993", "PR00378 : INOSPHPHTASE", 
                      "SSF49695 : 0035792", "SSF54631 : 0041682", "PF03160 : Calx-beta", 
                      "TIGR02239 : recomb_RAD51", "SSF51735 : 0044853", "PF08265 : YL1_C", 
                      "SSF50475 : 0051690", "PF01283 : Ribosomal_S26e", "SSF47616 : 0052111", 
                      "SSF50044 : 0052732", "PF09818 : ABC_ATPase", "SSF54637 : 0052780", 
                      "SSF51989 : 0048971", "SSF46626 : 0036835", "PS51296 : RIESKE", 
                      "SSF103196 : 0049625", "SSF49899 : 0051198", "PF07729 : FCD", 
                      "SSF54928 : 0048680", "SSF46689 : 0050547", "TIGR00633 : xth", 
                      "PF03517 : ICln_channel", "SSF53098 : 0047514", "SSF50386 : 0046654", 
                      "PF02082 : Rrf2", "TIGR00321 : dhys", "SSF53901 : 0044138", "SSF53474 : 0050682", 
                      "SSF50814 : 0041743", "SSF52129 : 0049359", "SSF88633 : 0046813", 
                      "SSF49401 : 0043084", "SSF47954 : 0035066", "SSF52009 : 0045135", 
                      "SSF51430 : 0043020", "SSF49354 : 0049221", "SSF54593 : 0046737", 
                      "SSF47266 : 0036073", "SSF55331 : 0043460", "SSF53383 : 0045171", 
                      "TIGR00422 : valS", "SSF54076 : 0043315", "SSF49354 : 0048701", 
                      "SSF54556 : 0046257", "PF04664 : OGFr_N", "SSF53098 : 0044246", 
                      "PF00884 : Sulfatase", "PF03319 : EutN_CcmL", "SSF55961 : 0039745", 
                      "SSF51206 : 0048339", "SSF50129 : 0042365", "SSF51905 : 0046972", 
                      "SSF82171 : 0050946", "SSF52172 : 0040078", "SSF56436 : 0035829", 
                      "SSF53697 : 0036561", "SSF56574 : 0042041", "SSF53335 : 0047386", 
                      "SSF46626 : 0037491", "PS50039 : FORK_HEAD_3", "SSF50193 : 0053143", 
                      "SSF48239 : 0047273", "SSF46458 : 0035322", "SSF48619 : 0040922", 
                      "SSF52058 : 0047132", "SSF53659 : 0045173", "SSF53271 : 0049833", 
                      "SSF48726 : 0036114", "PS50855 : COX1", "SSF57667 : 0034824", 
                      "SSF51735 : 0041692", "SSF52540 : 0049577", "SSF50729 : 0052456", 
                      "SSF57667 : 0050841", "PF02516 : STT3", "SSF55620 : 0039328", 
                      "SSF49835 : 0040161", "SSF57059 : 0047289", "PD016033 :", "SSF52283 : 0042915", 
                      "SSF50156 : 0039028", "SSF53807 : 0048164", "SSF48498 : 0052846", 
                      "SSF46626 : 0048389", "SSF51445 : 0046963", "SSF63562 : 0042830", 
                      "SSF48695 : 0045679", "PF03271 : EB1", "SSF51556 : 0047519", 
                      "SSF52210 : 0053297", "PF00069 : Pkinase", "SSF55486 : 0046136", 
                      "SSF53720 : 0047758", "SSF56349 : 0037653", "SSF51445 : 0038355", 
                      "SSF52490 : 0050368", "SSF54001 : 0041650", "SSF51395 : 0047140", 
                      "SSF88723 : 0052984", "SSF56436 : 0042894", "SSF46689 : 0041554", 
                      "SSF47616 : 0035237", "SSF53383 : 0040526", "SSF49899 : 0034923", 
                      "SSF81340 : 0040199", "SSF54117 : 0037458", "SSF49329 : 0046620", 
                      "SSF52540 : 0048706", "SSF50494 : 0035673", "SSF57196 : 0050997", 
                      "SSF74650 : 0043676", "PF01740 : STAS", "SSF52540 : 0051461", 
                      "PF08149 : BING4CT", "SSF48371 : 0051926", "SSF48013 : 0043710", 
                      "SSF53335 : 0047656", "PF00608 : Adeno_shaft", "SSF56935 : 0043833", 
                      "SSF75217 : 0038338", "SSF101391 : 0044500", "PS50071 : HOMEOBOX_2", 
                      "SSF54001 : 0042726", "SSF49265 : 0035254", "SSF51182 : 0048543", 
                      "SSF81321 : 0036704", "SSF53383 : 0036406", "SSF57667 : 0043982", 
                      "SSF54292 : 0052773", "SSF50129 : 0046113", "SSF49401 : 0043083", 
                      "SSF63380 : 0045224", "SSF53383 : 0044523", "SSF81296 : 0046503", 
                      "PF01504 : PIP5K", "PF01327 : Pep_deformylase", "SSF82199 : 0041105", 
                      "PF09174 : Maf1", "SSF52540 : 0050354", "SSF56112 : 0049538", 
                      "SSF47473 : 0045710", "SSF54001 : 0051557", "SSF51556 : 0039191", 
                      "SSF49265 : 0037682", "SSF56281 : 0052141", "PF02317 : Octopine_DH", 
                      "SSF56784 : 0040925", "SSF46997 : 0049457", "SSF54556 : 0039195", 
                      "PD107584 :", "SSF47031 : 0051180", "SSF81648 : 0037289", "SSF52833 : 0047310", 
                      "SSF49354 : 0040738", "SSF52833 : 0036940", "PF05132 : RNA_pol_Rpc4", 
                      "SSF49899 : 0036102", "PF09358 : UBA_e1_C", "SSF50692 : 0046942", 
                      "PIRSF037900 :", "SSF47240 : 0052333", "SSF57184 : 0045987", 
                      "SSF57283 : 0040075", "PS50211 : DENN", "SSF52777 : 0042636", 
                      "SSF47446 : 0042692", "SSF55003 : 0046738", "TIGR00604 : rad3", 
                      "TIGR01236 : D1pyr5carbox1", "SSF51735 : 0051568", "SSF82704 : 0044293", 
                      "SSF51011 : 0043661", "SSF55785 : 0041878", "SSF47413 : 0049316", 
                      "SSF57095 : 0049732", "SSF53686 : 0036788", "SSF50249 : 0048165", 
                      "SSF51206 : 0041923", "SSF52374 : 0038847", "SSF49503 : 0034896", 
                      "SSF53448 : 0042758", "SSF81508 : 0035458", "PD177909 :", "SSF52540 : 0052501", 
                      "PF00168 : C2", "PF00572 : Ribosomal_L13", "SSF47266 : 0049165", 
                      "SSF53623 : 0041699", "SSF48726 : 0039471", "SSF52540 : 0051604", 
                      "SSF49503 : 0040278", "SSF51445 : 0048242", "SSF54001 : 0046317", 
                      "SSF47323 : 0037566", "SSF51395 : 0046721", "SSF55021 : 0053025", 
                      "PD000542 :", "PD000717 :", "PF02772 : S-AdoMet_synt_M", "SSF47364 : 0050537", 
                      "SSF49417 : 0036065", "SSF47266 : 0038736", "SSF55298 : 0050777", 
                      "SSF57184 : 0035640", "SSF48726 : 0045267", "PD116408 :", "SSF57184 : 0048304", 
                      "PF00472 : RF-1", "SSF47336 : 0041257", "SSF46689 : 0043842", 
                      "PF00079 : Serpin", "PF08646 : Rep_fac-A_C", "SSF51182 : 0043569", 
                      "SSF50494 : 0038664", "PF00103 : Hormone_1", "SSF57362 : 0036593", 
                      "SSF47923 : 0037638", "SSF47473 : 0041313", "SSF47802 : 0043449", 
                      "SSF48592 : 0047404", "PIRSF019693 :", "PF02274 : Amidinotransf", 
                      "SSF57840 : 0053071", "SSF51604 : 0049248", "SSF47473 : 0039869", 
                      "SSF100950 : 0043918", "PF01268 : FTHFS", "SSF55961 : 0046586", 
                      "SSF52540 : 0050676", "SSF51604 : 0049748", "SSF49562 : 0053207", 
                      "PIRSF007972 :", "SSF47473 : 0040762", "SSF56784 : 0044796", 
                      "PR01698 : CYTOFMRPINTP", "SSF46785 : 0043473", "SSF49319 : 0053181", 
                      "SSF81923 : 0039929", "SSF51905 : 0035989", "SSF56327 : 0048539", 
                      "SSF57095 : 0035857", "SSF53474 : 0038627", "SSF51445 : 0045913", 
                      "SSF47954 : 0045780", "SSF51182 : 0053269", "SSF55008 : 0035233", 
                      "SSF49503 : 0048739", "PF03987 : Autophagy_act_C", "PF08645 : PNK3P", 
                      "SSF57059 : 0047468", "SSF50104 : 0052497", "SSF50156 : 0044382", 
                      "SSF69065 : 0051639", "PS50097 : BTB", "SSF52833 : 0037970", 
                      "PF00956 : NAP", "SSF47819 : 0052492", "PF10405 : BHD_3", "SSF52980 : 0050442", 
                      "SSF51206 : 0046231", "PF05843 : Suf", "SSF53383 : 0035417", 
                      "SSF48113 : 0043547", "PR00319 : GPROTEINB", "PF03134 : TB2_DP1_HVA22", 
                      "SSF48019 : 0043797", "SSF63380 : 0034954", "SSF54236 : 0050736", 
                      "SSF48726 : 0039960", "TIGR01519 : plasmod_dom_1", "TIGR01387 : cztR_silR_copR", 
                      "SSF50084 : 0040686", "SSF53335 : 0046303", "SSF48498 : 0052849", 
                      "PS51214 : IBB", "SSF57667 : 0048707", "SSF55909 : 0037954", 
                      "SSF52172 : 0041109", "PF03724 : META", "SSF54862 : 0046749", 
                      "SSF51338 : 0052759", "SSF56601 : 0050891", "PS50202 : MSP", 
                      "SSF48695 : 0043690", "SSF55060 : 0042330", "SSF47943 : 0045256", 
                      "PR01745 : DENSEGRNULE2", "SSF82051 : 0044294", "SSF57535 : 0037078", 
                      "SSF55021 : 0051230", "SSF56112 : 0049795", "SSF50447 : 0052543", 
                      "PS50008 : PIPLC_Y_DOMAIN", "PF09761 : DUF2049", "SSF55729 : 0051492", 
                      "SSF52029 : 0045814", "SSF50249 : 0040954", "SSF51197 : 0051173", 
                      "SSF52540 : 0049503", "SSF52540 : 0035786", "SSF52821 : 0044492", 
                      "SSF53187 : 0051172", "SSF50324 : 0041774", "SSF50715 : 0037515", 
                      "SSF53383 : 0047340", "SSF50249 : 0037577", "SSF54001 : 0044004", 
                      "PF04278 : Tic22", "PF05129 : Elf1", "PF01118 : Semialdhyde_dh", 
                      "PS51118 : HTH_HXLR", "SSF52413 : 0046358", "PR00961 : HUDSXLRNA", 
                      "SSF48726 : 0037356", "PF01554 : MatE", "PS50127 : UBIQUITIN_CONJUGAT_2", 
                      "SSF51011 : 0040254", "SSF57667 : 0045613", "SSF53474 : 0046624", 
                      "SSF54862 : 0053368", "SSF50405 : 0036402", "SSF74650 : 0035897", 
                      "SSF49835 : 0044557", "SSF48726 : 0039018", "TIGR00528 : gcvT", 
                      "SSF54928 : 0052248", "SSF51735 : 0052183", "PS51061 : R3H", 
                      "SSF49899 : 0051221", "SSF52156 : 0037976", "SSF51011 : 0038712", 
                      "SSF53850 : 0052806", "SSF46785 : 0050391", "PF00210 : Ferritin", 
                      "SSF56918 : 0040492", "SSF50044 : 0041809", "SSF48726 : 0042639", 
                      "SSF48613 : 0036625", "SSF56574 : 0036689", "SSF53474 : 0045742", 
                      "SSF54913 : 0043040", "SSF47874 : 0036495", "SSF52218 : 0043298", 
                      "PS50600 : ULP_PROTEASE", "SSF53850 : 0037070", "PF07463 : NUMOD4", 
                      "SSF46689 : 0051585", "SSF48726 : 0038965", "SSF51735 : 0035543", 
                      "SSF46689 : 0052647", "SSF53448 : 0044743", "SSF55979 : 0049258", 
                      "SSF89155 : 0041186", "TIGR00788 : fbt", "SSF51445 : 0048117", 
                      "SSF64496 : 0038860", "SSF54616 : 0040368", "TIGR00059 : L17", 
                      "SSF53092 : 0035986", "SSF111423 : 0043237", "SSF52218 : 0053358", 
                      "SSF51695 : 0042686", "SSF50249 : 0039498", "PF04145 : Ctr", 
                      "SSF54966 : 0047000", "PR00619 : GATAZNFINGER", "PR01034 : RIBOSOMALS12", 
                      "PF01207 : Dus", "SSF57652 : 0045525", "SSF46919 : 0036694", 
                      "SSF47203 : 0049821", "SSF89919 : 0039680", "SSF50630 : 0035272", 
                      "SSF54713 : 0043988", "SSF51735 : 0041739", "PIRSF037001 :", 
                      "SSF46626 : 0036086", "SSF51905 : 0036888", "PF07529 : HSA", 
                      "SSF46785 : 0036285", "SSF46689 : 0053365", "SSF53335 : 0037368", 
                      "PS50228 : SUEL_LECTIN", "SSF55200 : 0044020", "SSF57802 : 0045396", 
                      "SSF81995 : 0040753", "SSF55298 : 0048930", "SSF53697 : 0039507", 
                      "SSF49452 : 0042222", "PD022010 :", "SSF57196 : 0041766", "PF06883 : RNA_pol_Rpa2_4", 
                      "SSF55060 : 0040912", "SSF49899 : 0035813", "PF09409 : PUB", 
                      "SSF52166 : 0036499", "PF03179 : V-ATPase_G", "PF05030 : SSXT", 
                      "SSF48097 : 0035044", "SSF56235 : 0042376", "SSF54768 : 0042986", 
                      "SSF54236 : 0041399", "SSF48695 : 0049002", "SSF54236 : 0050488", 
                      "SSF54675 : 0044879", "SSF57501 : 0045468", "SSF54534 : 0042333", 
                      "SSF55190 : 0035692", "SSF53335 : 0037962", "SSF50249 : 0048642", 
                      "SSF51735 : 0039871", "SSF48452 : 0034820", "PF10375 : GRAB", 
                      "SSF54957 : 0034929", "PF05641 : Agenet", "SSF55874 : 0039624", 
                      "SSF52540 : 0038740", "SSF52833 : 0041935", "SSF64268 : 0047856", 
                      "SSF63748 : 0042091", "SSF54117 : 0039434", "SSF47380 : 0041431", 
                      "SSF51182 : 0052088", "PF00199 : Catalase", "SSF57868 : 0036498", 
                      "SSF50118 : 0041330", "SSF53597 : 0039768", "SSF48239 : 0035832", 
                      "SSF53092 : 0035273", "PF02666 : PS_Dcarbxylase", "SSF53187 : 0035108", 
                      "SSF52172 : 0039925", "SSF51445 : 0047025", "SSF53597 : 0053054", 
                      "SSF48726 : 0045219", "SSF46458 : 0037451", "SSF52743 : 0049119", 
                      "SSF56601 : 0046070", "SSF48508 : 0034841", "PF04143 : DUF395", 
                      "PD003052 :", "SSF49899 : 0044424", "SSF55103 : 0050336", "SSF56436 : 0036666", 
                      "SSF89957 : 0043519", "SSF51430 : 0038288", "SSF81271 : 0047548", 
                      "SSF53067 : 0051545", "SSF49785 : 0048786", "SSF47364 : 0048024", 
                      "SSF88633 : 0046843", "SSF51649 : 0045628", "SSF51569 : 0043383", 
                      "PF00255 : GSHPx", "PF01619 : Pro_dh", "SSF101386 : 0050254", 
                      "SSF53383 : 0051323", "SSF64484 : 0038872", "PF07723 : LRR_2", 
                      "SSF47226 : 0050663", "SSF50729 : 0050619", "PF10234 : Cluap1", 
                      "SSF48557 : 0035216", "SSF46626 : 0038388", "PF01179 : Cu_amine_oxid", 
                      "SSF56235 : 0036901", "SSF49313 : 0041310", "SSF55729 : 0048876", 
                      "SSF46689 : 0039205", "SSF57850 : 0039625", "SSF52266 : 0051447", 
                      "SSF49503 : 0035179", "SSF51735 : 0042534", "SSF55608 : 0042194", 
                      "SSF53335 : 0040369", "SSF50494 : 0046995", "SSF88633 : 0043245", 
                      "SSF53335 : 0035645", "SSF48173 : 0044199", "SSF53300 : 0037691", 
                      "SSF75217 : 0041538", "SSF51445 : 0035612", "SSF55008 : 0049047", 
                      "SSF49503 : 0035147", "SSF63380 : 0037342", "SSF53474 : 0044880", 
                      "SSF57716 : 0052126", "SSF54452 : 0042931", "SSF51971 : 0048807", 
                      "PIRSF000368 :", "SSF55909 : 0038456", "SSF46785 : 0036707", 
                      "SSF48371 : 0049892", "PF08752 : Gamma-COP", "PR01248 : TYPE1KERATIN", 
                      "SSF51445 : 0036241", "SSF53649 : 0046522", "SSF54211 : 0043490", 
                      "PF04142 : Nuc_sug_transp", "SSF46458 : 0036117", "SSF46689 : 0044376", 
                      "PR00738 : GLHYDRLASE20", "SSF57184 : 0048104", "SSF48317 : 0042785", 
                      "SSF51621 : 0049923", "SSF55486 : 0051020", "SSF51126 : 0047680", 
                      "SSF57701 : 0042516", "SSF81469 : 0040795", "SSF56601 : 0039859", 
                      "SSF51126 : 0041388", "SSF48726 : 0048995", "PF01248 : Ribosomal_L7Ae", 
                      "PF07719 : TPR_2", "SSF52402 : 0038210", "SSF47587 : 0044402", 
                      "PF00028 : Cadherin", "SSF56235 : 0043433", "SSF55550 : 0038863", 
                      "SSF51419 : 0049144", "SSF56235 : 0039539", "SSF46626 : 0039643", 
                      "SSF56371 : 0040597", "SSF54826 : 0052872", "SSF50621 : 0035464", 
                      "SSF52540 : 0044990", "SSF55920 : 0040193", "SSF47473 : 0043217", 
                      "SSF55729 : 0052754", "SSF56672 : 0039802", "PF01915 : Glyco_hydro_3_C", 
                      "PF08561 : Ribosomal_L37", "SSF50494 : 0041149", "SSF52540 : 0048593", 
                      "SSF46458 : 0036492", "PF01191 : RNA_pol_Rpb5_C", "SSF49265 : 0049023", 
                      "PD111724 :", "SSF50156 : 0044366", "SSF51445 : 0050412", "SSF51735 : 0044691", 
                      "TIGR00442 : hisS", "PF00881 : Nitroreductase", "SSF55068 : 0037519", 
                      "SSF51735 : 0044793", "PF06858 : NOG1", "SSF54909 : 0049743", 
                      "PF00230 : MIP", "PF00406 : ADK", "SSF54534 : 0039784", "SSF53474 : 0046219", 
                      "SSF50494 : 0046722", "SSF51445 : 0038662", "SSF46689 : 0037902", 
                      "SSF47364 : 0043267", "SSF57501 : 0035632", "TIGR01136 : cysKM", 
                      "SSF56672 : 0047595", "SSF54909 : 0048903", "PF01676 : Metalloenzyme", 
                      "SSF57501 : 0039692", "SSF52833 : 0037807", "SSF57302 : 0045235", 
                      "SSF47576 : 0035125", "SSF54556 : 0036706", "SSF56672 : 0045062", 
                      "SSF55387 : 0052778", "TIGR02152 : D_ribokin_bact", "SSF52343 : 0048943", 
                      "SSF56436 : 0051408", "SSF56672 : 0035949", "SSF56496 : 0037859", 
                      "SSF48498 : 0043601", "PF03464 : eRF1_2", "SSF53335 : 0048629", 
                      "PF10269 : Tmemb_185A", "SSF74650 : 0041434", "SSF50939 : 0050026", 
                      "SSF57868 : 0036408", "SSF48168 : 0043301", "SSF50494 : 0035500", 
                      "SSF57247 : 0046320", "SSF48726 : 0045866", "SSF49899 : 0045052", 
                      "SSF50129 : 0040550", "PS50245 : CAP_GLY_2", "SSF48726 : 0038924", 
                      "TIGR01590 : yir-bir-cir_Pla", "PF01282 : Ribosomal_S24e", "SSF52317 : 0052900", 
                      "SSF63446 : 0041862", "SSF53613 : 0044587", "SSF56574 : 0039087", 
                      "SSF51556 : 0051799", "SSF50249 : 0040953", "SSF51679 : 0037305", 
                      "SSF46626 : 0046439", "SSF54862 : 0038361", "PF00646 : F-box", 
                      "SSF52799 : 0038934", "SSF51569 : 0037352", "SSF56601 : 0050370", 
                      "SSF49503 : 0043285", "TIGR01064 : pyruv_kin", "SSF49772 : 0051142", 
                      "SSF46785 : 0046283", "SSF55447 : 0037701", "SSF48208 : 0047123", 
                      "SSF88633 : 0036372", "SSF48371 : 0035342", "SSF54919 : 0048435", 
                      "PF00025 : Arf", "SSF56327 : 0045935", "SSF55136 : 0036288", 
                      "SSF49265 : 0041237", "TIGR00677 : fadh2_euk", "SSF53901 : 0044257", 
                      "SSF55424 : 0039504", "SSF50465 : 0043458", "SSF53659 : 0050255", 
                      "PS50043 : HTH_LUXR_2", "SSF47113 : 0039519", "SSF53774 : 0045589", 
                      "SSF52922 : 0050396", "PF08447 : PAS_3", "SSF47954 : 0044901", 
                      "SSF47473 : 0047377", "SSF47240 : 0044579", "SSF50353 : 0049015", 
                      "SSF101233 : 0041033", "SSF47473 : 0042483", "SSF50465 : 0037247", 
                      "SSF52440 : 0045314", "SSF51004 : 0048978", "SSF52833 : 0049720", 
                      "PR00301 : HEATSHOCK70", "SSF53807 : 0045364", "PF10588 : NADH-G_4Fe-4S_3", 
                      "PIRSF001529 :", "PF00343 : Phosphorylase", "PF04495 : GRASP55_65", 
                      "PIRSF002116 :", "PF10174 : Cast", "PF01658 : Inos-1-P_synth", 
                      "SSF51735 : 0048949", "PF00648 : Peptidase_C2", "SSF46785 : 0040586", 
                      "PF00505 : HMG_box", "SSF54928 : 0050837", "TIGR01760 : tape_meas_TP901", 
                      "PD351532 :", "SSF49899 : 0041755", "SSF81296 : 0047164", "PF00756 : Esterase", 
                      "SSF51735 : 0050212", "SSF53850 : 0039510", "SSF69118 : 0053233", 
                      "PF06696 : Strep_SA_rep", "PF01783 : Ribosomal_L32p", "SSF47616 : 0042080", 
                      "SSF52833 : 0035251", "SSF53155 : 0040918", "SSF54768 : 0049914", 
                      "SSF51735 : 0034891", "PR00633 : RCCNDNSATION", "SSF88633 : 0046507", 
                      "SSF56235 : 0049601", "SSF49899 : 0047399", "PR01210 : GGTRANSPTASE", 
                      "SSF109885 : 0043066", "SSF63451 : 0038495", "SSF47473 : 0052892", 
                      "SSF57850 : 0039284", "PF10537 : WAC_Acf1_DNA_bd", "SSF47802 : 0045992", 
                      "SSF51905 : 0041341", "SSF49749 : 0042128", "SSF55315 : 0036028", 
                      "SSF51735 : 0040666", "SSF49265 : 0050819", "PD006960 :", "SSF51695 : 0041669", 
                      "PIRSF037677 :", "SSF109770 : 0043903", "PD024065 :", "PF01061 : ABC2_membrane", 
                      "SSF50156 : 0050574", "SSF47661 : 0048043", "SSF50494 : 0035283", 
                      "SSF53901 : 0049939", "SSF52540 : 0043061", "SSF51126 : 0047750", 
                      "SSF54160 : 0050533", "PS50214 : DISINTEGRIN_2", "SSF57059 : 0044911", 
                      "SSF52374 : 0035691", "SSF54585 : 0042710", "PF07418 : PCEMA1", 
                      "SSF52540 : 0049080", "SSF53850 : 0045575", "SSF51735 : 0052803", 
                      "SSF54285 : 0037320", "PF03820 : Mtc", "SSF88633 : 0036875", 
                      "SSF53335 : 0051679", "PF04603 : Mog1", "SSF53850 : 0041064", 
                      "SSF57501 : 0046809", "PD871282 :", "SSF55753 : 0035078", "SSF49785 : 0041433", 
                      "PS50253 : COX3", "PD010314 :", "SSF50630 : 0041545", "SSF46458 : 0047071", 
                      "SSF55729 : 0048344", "SSF51338 : 0047518", "SSF46785 : 0042156", 
                      "SSF63380 : 0036118", "SSF51419 : 0044145", "SSF51445 : 0047491", 
                      "SSF46626 : 0037329", "SSF52313 : 0046796", "SSF57362 : 0035017", 
                      "PF01548 : Transposase_9", "SSF57059 : 0041921", "SSF52833 : 0052340", 
                      "SSF55846 : 0040443", "SSF63411 : 0045937", "SSF51430 : 0047570", 
                      "SSF54897 : 0043694", "SSF50475 : 0053043", "SSF47473 : 0037439", 
                      "SSF47616 : 0042386", "PF00300 : PGAM", "SSF52374 : 0048452", 
                      "SSF50044 : 0044386", "SSF50129 : 0039290", "SSF53335 : 0047851", 
                      "PF04815 : Sec23_helical", "PS50040 : EF1G_C", "PF06741 : Ataxin-2_N", 
                      "PIRSF005962 :", "TIGR01135 : glmS", "SSF81271 : 0048368", "SSF48008 : 0038752", 
                      "PF07462 : MSP1_C", "SSF52833 : 0049377", "SSF53383 : 0037039", 
                      "SSF55307 : 0041833", "PF09715 : Plasmod_dom_1", "SSF46946 : 0039898", 
                      "SSF55831 : 0039350", "PF03460 : NIR_SIR_ferr", "SSF56322 : 0038914", 
                      "SSF52096 : 0045251", "SSF52343 : 0038913", "SSF55550 : 0039981", 
                      "SSF74877 : 0040335", "PF04784 : DUF547", "SSF56784 : 0050211", 
                      "SSF54631 : 0051202", "SSF55753 : 0036220", "SSF88713 : 0044323", 
                      "PIRSF002129 :", "PF00838 : TCTP", "SSF49417 : 0046182", "PR01703 : MNSODISMTASE", 
                      "SSF54593 : 0049435", "SSF51569 : 0047183", "SSF49265 : 0042756", 
                      "SSF52540 : 0041207", "SSF55387 : 0037222", "SSF53756 : 0035835", 
                      "SSF52540 : 0039472", "PF10392 : COG5", "PF02245 : Pur_DNA_glyco", 
                      "SSF54334 : 0035768", "SSF57424 : 0039720", "SSF51430 : 0046225", 
                      "PF03805 : CLAG", "SSF46565 : 0046983", "SSF49348 : 0047086", 
                      "PF02099 : Josephin", "PD133617 :", "SSF50729 : 0038365", "SSF54236 : 0052632", 
                      "SSF52540 : 0052549", "SSF55681 : 0047165", "PF07572 : BCNT", 
                      "SSF55961 : 0035723", "SSF48452 : 0051037", "SSF50203 : 0046618", 
                      "SSF52540 : 0052855", "PR00413 : HADHALOGNASE", "SSF54752 : 0045437", 
                      "PF01247 : Ribosomal_L35Ae", "SSF53474 : 0049591", "SSF57196 : 0035939", 
                      "PF04928 : PAP_central", "SSF48208 : 0052638", "SSF54211 : 0050966", 
                      "SSF53633 : 0051807", "SSF46626 : 0035909", "PD006276 :", "TIGR00884 : guaA_Cterm", 
                      "SSF50156 : 0052270", "SSF54236 : 0043567", "SSF51197 : 0038325", 
                      "SSF50386 : 0043175", "SSF100939 : 0039511", "TIGR01963 : PHB_DH", 
                      "SSF56091 : 0043500", "SSF55550 : 0048098", "SSF53613 : 0052784", 
                      "SSF49503 : 0038300", "SSF89957 : 0053086", "SSF53335 : 0050988", 
                      "PF07289 : DUF1448", "PR01405 : TETRPHPHTASE", "SSF53271 : 0041695", 
                      "SSF56281 : 0051022", "SSF57424 : 0041240", "SSF53300 : 0045819", 
                      "SSF52172 : 0050964", "SSF52540 : 0052155", "SSF52096 : 0036954", 
                      "PS50946 : UDENN", "SSF111006 : 0044193", "SSF48201 : 0042472", 
                      "SSF52540 : 0036981", "SSF111038 : 0045027", "SSF47576 : 0046420", 
                      "PF00587 : tRNA-synt_2b", "SSF53187 : 0051954", "SSF53335 : 0037029", 
                      "SSF48726 : 0041960", "SSF88633 : 0045983", "SSF48208 : 0048326", 
                      "SSF52540 : 0052764", "SSF53335 : 0049074", "SSF50022 : 0039622", 
                      "SSF49503 : 0047343", "PD011327 :", "SSF55347 : 0044045", "SSF46626 : 0035864", 
                      "SSF63411 : 0048872", "PD297513 :", "PR00838 : V5ALLERGEN", "SSF47473 : 0042817", 
                      "SSF90209 : 0052121", "SSF46785 : 0047195", "SSF53335 : 0053110", 
                      "SSF54534 : 0044217", "PD041438 :", "SSF54913 : 0038393", "SSF49899 : 0038386", 
                      "SSF52540 : 0044416", "SSF75001 : 0039886", "SSF56796 : 0050240", 
                      "PD004109 :", "SSF57262 : 0045594", "SSF52210 : 0046631", "SSF52440 : 0053120", 
                      "PS51204 : HSA", "PF10475 : DUF2450", "SSF50494 : 0045627", "SSF52540 : 0051156", 
                      "SSF49417 : 0035512", "SSF52172 : 0047296", "SSF53098 : 0035865", 
                      "SSF51735 : 0045645", "SSF109751 : 0044927", "SSF48452 : 0042166", 
                      "SSF50156 : 0044634", "SSF50129 : 0040817", "SSF53850 : 0044498", 
                      "SSF51735 : 0052382", "PF00120 : Gln-synt_C", "SSF54913 : 0047861", 
                      "SSF56300 : 0037943", "SSF54928 : 0050807", "PF04030 : ALO", 
                      "SSF54897 : 0047836", "SSF52540 : 0041874", "SSF56796 : 0047653", 
                      "PD010361 :", "SSF50814 : 0035903", "SSF52518 : 0052103", "PF00024 : PAN_1", 
                      "SSF52833 : 0052452", "SSF46946 : 0039948", "SSF89957 : 0044828", 
                      "SSF53474 : 0042730", "SSF57302 : 0037525", "SSF51735 : 0039364", 
                      "SSF51445 : 0045141", "SSF46458 : 0043551", "SSF51230 : 0046989", 
                      "SSF46689 : 0040485", "SSF51351 : 0048198", "SSF52833 : 0045041", 
                      "SSF50939 : 0050039", "PF01912 : eIF-6", "PIRSF016305 :", "SSF52518 : 0052449", 
                      "PF08712 : Nfu_N", "SSF57440 : 0045401", "PF08555 : DUF1754", 
                      "SSF54001 : 0039705", "PR01466 : ARGDEIMINASE", "TIGR00357 : TIGR00357", 
                      "TIGR00335 : primase_sml", "SSF54117 : 0037111", "PF02902 : Peptidase_C48", 
                      "SSF57027 : 0047102", "PF00380 : Ribosomal_S9", "SSF51445 : 0047190", 
                      "PD338809 :", "SSF74924 : 0052213", "SSF56601 : 0036456", "SSF49842 : 0045607", 
                      "SSF48619 : 0040924", "PIRSF036945 :", "SSF102741 : 0044296", 
                      "SSF53850 : 0051099", "SSF54358 : 0048229", "SSF52540 : 0051450", 
                      "SSF81301 : 0044799", "PS50868 : POST_SET", "PF08721 : TnsA_C", 
                      "PF03406 : Phage_fiber_2", "SSF56371 : 0040749", "SSF81872 : 0039279", 
                      "SSF55658 : 0053142", "SSF56837 : 0049160", "PD089639 :", "SSF74650 : 0036995", 
                      "SSF69118 : 0042190", "SSF57196 : 0047931", "SSF52540 : 0047599", 
                      "SSF46689 : 0053065", "SSF52833 : 0047048", "SSF54928 : 0048682", 
                      "SSF57716 : 0042049", "SSF101089 : 0041906", "TIGR00622 : ssl1", 
                      "SSF54928 : 0052236", "PF04430 : DUF498", "SSF52540 : 0047394", 
                      "SSF55961 : 0045042", "SSF50203 : 0045194", "PF03963 : FlgD", 
                      "SSF53067 : 0051456", "SSF46626 : 0039131", "SSF53067 : 0048322", 
                      "SSF46689 : 0038534", "SSF56024 : 0042591", "SSF48726 : 0039017", 
                      "SSF55464 : 0043928", "SSF49562 : 0036582", "PD329160 :", "PF01237 : Oxysterol_BP", 
                      "PF01868 : UPF0086", "SSF51445 : 0048530", "SSF46785 : 0049276", 
                      "SSF54593 : 0051635", "TIGR01040 : V-ATPase_V1_B", "SSF52047 : 0045099", 
                      "SSF53067 : 0041118", "SSF56209 : 0045155", "PF04152 : Mre11_DNA_bind", 
                      "SSF48695 : 0036657", "SSF82282 : 0042651", "SSF56300 : 0049880", 
                      "SSF54334 : 0044589", "SSF50129 : 0051263", "SSF57802 : 0048398", 
                      "PF09414 : RNA_ligase", "SSF57429 : 0037038", "TIGR01622 : SF-CC1", 
                      "SSF55620 : 0043126", "PD023692 :", "SSF56112 : 0035371", "SSF53383 : 0039341", 
                      "SSF49265 : 0038103", "SSF88802 : 0043892", "SSF54495 : 0051843", 
                      "SSF55729 : 0052342", "SSF50203 : 0039481", "SSF88697 : 0052482", 
                      "PF04934 : MED6", "SSF54593 : 0046521", "SSF51649 : 0053330", 
                      "SSF51096 : 0047311", "SSF50978 : 0046612", "SSF53474 : 0048982", 
                      "SSF50939 : 0051948", "PR01035 : TCRTETA", "SSF50891 : 0051928", 
                      "SSF57501 : 0050683", "SSF53474 : 0037315", "TIGR00131 : gal_kin", 
                      "SSF49265 : 0044313", "TIGR00395 : leuS_arch", "SSF55811 : 0042592", 
                      "SSF53474 : 0040499", "SSF51905 : 0044704", "SSF47113 : 0038978", 
                      "SSF52799 : 0037733", "SSF53335 : 0040964", "TIGR00747 : fabH", 
                      "SSF56112 : 0039686", "SSF49899 : 0035071", "PIRSF001265 :", 
                      "SSF47473 : 0036831", "SSF49503 : 0045803", "SSF47323 : 0038401", 
                      "SSF57829 : 0053069", "SSF53254 : 0036887", "PIRSF002583 :", 
                      "SSF50324 : 0053379", "SSF52218 : 0044042", "SSF53850 : 0035933", 
                      "SSF52096 : 0052604", "SSF49899 : 0048488", "SSF53597 : 0036675", 
                      "SSF52833 : 0045810", "SSF46626 : 0038370", "SSF54862 : 0044015", 
                      "SSF53850 : 0039785", "SSF57392 : 0045187", "PD023269 :", "SSF57716 : 0050856", 
                      "SSF54593 : 0049444", "SSF52172 : 0042891", "SSF56235 : 0039161", 
                      "PF05922 : Inhibitor_I9", "SSF57059 : 0046153", "SSF53187 : 0051496", 
                      "SSF52540 : 0048545", "SSF63817 : 0043027", "SSF50249 : 0046097", 
                      "SSF47699 : 0035496", "TIGR01821 : 5aminolev_synth", "SSF50475 : 0052681", 
                      "SSF53850 : 0040454", "SSF55154 : 0051291", "SSF48065 : 0047812", 
                      "TIGR02801 : tolR", "PF07021 : MetW", "SSF56112 : 0037369", "PF00051 : Kringle", 
                      "PF10238 : Eapp_C", "SSF56235 : 0039872", "SSF57095 : 0046006", 
                      "SSF46689 : 0053176", "SSF53223 : 0040667", "PF04180 : LTV", 
                      "PIRSF017127 :", "SSF50978 : 0041521", "SSF56741 : 0041873", 
                      "SSF57362 : 0036218", "SSF46689 : 0053096", "SSF57095 : 0040271", 
                      "PD004103 :", "PF00656 : Peptidase_C14", "PIRSF015415 :", "PF09507 : CDC27", 
                      "SSF53474 : 0045851", "SSF51366 : 0047101", "SSF54826 : 0052171", 
                      "SSF50129 : 0047181", "SSF48726 : 0052128", "SSF51703 : 0053373", 
                      "SSF56317 : 0039340", "SSF49348 : 0041286", "SSF52833 : 0038157", 
                      "SSF64496 : 0044202", "PR00702 : ACRIFLAVINRP", "SSF54648 : 0043208", 
                      "PIRSF022996 :", "PR00106 : DNAPOLB", "SSF57924 : 0053073", "SSF88633 : 0048466", 
                      "PS51065 : NHR", "SSF47113 : 0040306", "SSF75304 : 0040740", 
                      "SSF52283 : 0039365", "PF06046 : Sec6", "SSF57283 : 0040106", 
                      "PS50941 : CHIT_BIND_I_2", "PR00837 : V5TPXLIKE", "PF00152 : tRNA-synt_2", 
                      "SSF57774 : 0043480", "SSF48576 : 0044266", "SSF52540 : 0042496", 
                      "SSF46689 : 0037176", "SSF46934 : 0050552", "SSF57501 : 0047829", 
                      "TIGR01830 : 3oxo_ACP_reduc", "SSF55424 : 0050962", "SSF50494 : 0040456", 
                      "SSF47413 : 0041990", "SSF51161 : 0038742", "TIGR00216 : ispH_lytB", 
                      "SSF55729 : 0047911", "SSF57889 : 0050894", "PF02524 : KID", 
                      "SSF50630 : 0039397", "SSF55405 : 0036638", "PF01781 : Ribosomal_L38e", 
                      "SSF55961 : 0046430", "SSF56235 : 0040554", "SSF55931 : 0038718", 
                      "SSF52833 : 0046733", "PS51089 : HP", "PF03236 : DUF263", "SSF56112 : 0034801", 
                      "SSF48726 : 0041915", "SSF88633 : 0039030", "PF02622 : DUF179", 
                      "SSF47616 : 0044141", "SSF55961 : 0052379", "SSF57586 : 0053010", 
                      "PS50058 : G_PROTEIN_GAMMA", "SSF48576 : 0048806", "SSF46458 : 0044908", 
                      "SSF46626 : 0046513", "SSF49785 : 0036010", "PIRSF016477 :", 
                      "PIRSF013684 :", "SSF101690 : 0051424", "SSF48208 : 0040233", 
                      "SSF53807 : 0052172", "SSF46689 : 0044899", "SSF47336 : 0035027", 
                      "PF04042 : DNA_pol_E_B", "SSF52540 : 0047756", "SSF47266 : 0045958", 
                      "SSF51096 : 0036484", "SSF88723 : 0041679", "PF10211 : Ax_dynein_light", 
                      "SSF47874 : 0035060", "PR01607 : APYRASEFAMLY", "PF01593 : Amino_oxidase", 
                      "SSF54928 : 0041483", "SSF49785 : 0036212", "SSF50156 : 0044684", 
                      "SSF50156 : 0042844", "PF03200 : Glyco_hydro_63", "SSF53659 : 0045021", 
                      "SSF51735 : 0048585", "SSF53335 : 0049069", "SSF49854 : 0041645", 
                      "SSF49899 : 0041211", "SSF53955 : 0035090", "PF02364 : Glucan_synthase", 
                      "PS51328 : L_LECTIN_LIKE", "PF04981 : NMD3", "PIRSF015665 :", 
                      "SSF101898 : 0049253", "SSF56784 : 0052698", "PR00086 : LLDHDRGNASE", 
                      "SSF56327 : 0038277", "TIGR03400 : 18S_RNA_Rcl1p", "SSF52540 : 0040315", 
                      "SSF53383 : 0044807", "SSF81464 : 0045394", "SSF52317 : 0039993", 
                      "PF02291 : TFIID-31kDa", "SSF55394 : 0037224", "SSF47874 : 0041163", 
                      "SSF52833 : 0051923", "SSF54001 : 0047807", "SSF54292 : 0036703", 
                      "PF05691 : Raffinose_syn", "TIGR02022 : hutF", "SSF56327 : 0047264", 
                      "SSF50249 : 0051294", "SSF47413 : 0050779", "PR01130 : DERENTRNSPRT", 
                      "SSF55846 : 0043801", "PF00313 : CSD", "SSF51395 : 0045246", 
                      "SSF50692 : 0036201", "SSF46458 : 0049698", "SSF55770 : 0046926", 
                      "SSF53335 : 0049171", "PS50026 : EGF_3", "SSF48173 : 0036512", 
                      "TIGR00621 : ssb", "SSF53335 : 0049186", "SSF57630 : 0036323", 
                      "SSF100950 : 0044937", "SSF64182 : 0039854", "SSF48366 : 0035599", 
                      "TIGR01652 : ATPase-Plipid", "SSF49785 : 0038180", "SSF55961 : 0051685", 
                      "SSF55068 : 0037796", "SSF48576 : 0042444", "PD009671 :", "PF02386 : TrkH", 
                      "SSF69635 : 0047737", "SSF46689 : 0044368", "PF04057 : Rep-A_N", 
                      "PF08693 : SKG6", "SSF52743 : 0036337", "SSF50249 : 0045578", 
                      "SSF46924 : 0047307", "SSF100950 : 0051074", "SSF54637 : 0048478", 
                      "SSF57283 : 0038147", "SSF54117 : 0052499", "SSF51445 : 0047591", 
                      "SSF55277 : 0038329", "PF00595 : PDZ", "SSF51735 : 0050869", 
                      "SSF48081 : 0041059", "SSF54117 : 0036062", "SSF55961 : 0044426", 
                      "SSF56112 : 0044907", "TIGR00256 : TIGR00256", "SSF52374 : 0047412", 
                      "SSF54862 : 0035300", "PF10544 : T5orf172", "PF01784 : NIF3", 
                      "SSF52540 : 0046945", "SSF51679 : 0044135", "SSF54556 : 0036855", 
                      "PF00996 : GDI", "SSF51182 : 0047515", "PF00046 : Homeobox", 
                      "SSF49899 : 0042619", "PF01817 : CM_2", "PF00664 : ABC_membrane", 
                      "SSF49265 : 0052310", "SSF51735 : 0035943", "SSF57850 : 0043836", 
                      "SSF46785 : 0049573", "SSF50084 : 0039799", "SSF48452 : 0039276", 
                      "SSF50044 : 0044325", "SSF50814 : 0041496", "SSF57392 : 0035155", 
                      "SSF53850 : 0046370", "SSF54593 : 0051145", "SSF51182 : 0047410", 
                      "SSF47413 : 0050548", "SSF54452 : 0040927", "PF01791 : DeoC", 
                      "PD010430 :", "SSF52540 : 0047420", "SSF56918 : 0039052", "SSF48726 : 0041103", 
                      "SSF55103 : 0046671", "SSF56935 : 0036775", "SSF51735 : 0042425", 
                      "SSF51556 : 0046571", "PF05347 : Complex1_LYR", "PF02022 : Integrase_Zn", 
                      "SSF50729 : 0038849", "SSF88633 : 0037206", "SSF54593 : 0040139", 
                      "PD006052 :", "SSF47370 : 0039744", "TIGR00982 : S23_S12_E_A", 
                      "SSF46785 : 0048042", "SSF54768 : 0052224", "SSF64153 : 0039822", 
                      "SSF50814 : 0041104", "SSF54098 : 0049783", "SSF51649 : 0046999", 
                      "SSF46785 : 0042467", "SSF52172 : 0042177", "SSF52540 : 0051056", 
                      "SSF54719 : 0036081", "SSF52833 : 0044011", "SSF47233 : 0038782", 
                      "SSF56601 : 0049225", "SSF57196 : 0049665", "TIGR00006 : TIGR00006", 
                      "PIRSF019689 :", "SSF54277 : 0039115", "PF00792 : PI3K_C2", "SSF54076 : 0036677", 
                      "SSF55785 : 0046045", "PD004637 :", "SSF54928 : 0052229", "SSF52540 : 0046548", 
                      "PF08442 : ATP-grasp_2", "PR01746 : DENSEGRNULE6", "SSF51735 : 0051264", 
                      "SSF51445 : 0046122", "PR01663 : MCMPROTEIN7", "SSF50715 : 0038262", 
                      "SSF48726 : 0035080", "SSF55550 : 0043094", "SSF51419 : 0038618", 
                      "SSF53150 : 0046450", "SSF50249 : 0038181", "SSF51445 : 0046256", 
                      "PF02134 : UBACT", "PD001544 :", "SSF46785 : 0044507", "SSF52218 : 0051328", 
                      "PF09690 : PYST-C1", "SSF53187 : 0051224", "PS50922 : TLC", "SSF56568 : 0039818", 
                      "SSF89360 : 0043177", "SSF47396 : 0041585", "SSF81296 : 0042695", 
                      "SSF53448 : 0040535", "SSF54001 : 0036721", "SSF52161 : 0037535", 
                      "TIGR00654 : PhzF_family", "SSF54928 : 0049775", "SSF53383 : 0046206", 
                      "SSF57196 : 0042295", "SSF48256 : 0039109", "SSF53383 : 0050076", 
                      "PS51183 : JMJN", "SSF52467 : 0036965", "SSF53850 : 0046378", 
                      "PS51082 : WH2", "SSF54117 : 0042289", "SSF57302 : 0041562", 
                      "SSF51445 : 0035661", "PF00535 : Glycos_transf_2", "SSF54197 : 0043746", 
                      "SSF46458 : 0040509", "SSF54862 : 0035614", "SSF48508 : 0041290", 
                      "SSF49265 : 0045698", "SSF52821 : 0041897", "SSF51395 : 0037115", 
                      "PD208305 :", "PF03398 : DUF292", "SSF53633 : 0052151", "SSF53756 : 0043452", 
                      "SSF53474 : 0049001", "SSF47473 : 0048083", "SSF47836 : 0045323", 
                      "SSF56784 : 0052115", "SSF50630 : 0041040", "SSF81342 : 0037290", 
                      "SSF46609 : 0050424", "SSF54452 : 0035334", "SSF50494 : 0035862", 
                      "SSF52317 : 0043864", "SSF53271 : 0038202", "SSF52317 : 0051592", 
                      "SSF50494 : 0040038", "SSF51445 : 0036917", "SSF90213 : 0041423", 
                      "SSF57302 : 0037447", "TIGR00048 : TIGR00048", "SSF48208 : 0050146", 
                      "PF03937 : DUF339", "PD219741 :", "SSF55486 : 0048880", "SSF51621 : 0047978", 
                      "SSF56784 : 0051764", "SSF47729 : 0038734", "SSF49899 : 0038625", 
                      "PIRSF001788 :", "SSF81624 : 0039949", "SSF51445 : 0048404", 
                      "SSF57095 : 0049899", "SSF53738 : 0039874", "PR00662 : G6PISOMERASE", 
                      "PF01408 : GFO_IDH_MocA", "SSF51445 : 0035424", "SSF46934 : 0036968", 
                      "SSF49899 : 0045543", "SSF57889 : 0050054", "PF01200 : Ribosomal_S28e", 
                      "SSF51971 : 0036017", "SSF54427 : 0041967", "SSF54686 : 0052973", 
                      "PF01027 : UPF0005", "PF04406 : TP6A_N", "SSF50156 : 0050114", 
                      "SSF47413 : 0052016", "SSF47616 : 0035352", "PF05684 : DUF819", 
                      "SSF53720 : 0039937", "PF03665 : UPF0172", "SSF49695 : 0047120", 
                      "SSF53254 : 0048955", "SSF81296 : 0052468", "SSF50044 : 0043573", 
                      "SSF50447 : 0036324", "SSF52540 : 0039041", "SSF54719 : 0050425", 
                      "PF01158 : Ribosomal_L36e", "PF03657 : UPF0113", "SSF52540 : 0039999", 
                      "SSF47413 : 0043143", "SSF103642 : 0043786", "SSF49265 : 0052453", 
                      "PF00176 : SNF2_N", "PF03810 : IBN_N", "SSF52833 : 0051850", 
                      "TIGR01123 : ilvE_II", "PF00905 : Transpeptidase", "SSF55008 : 0042005", 
                      "SSF47220 : 0043751", "SSF53335 : 0043085", "SSF57903 : 0045116", 
                      "PF00339 : Arrestin_N", "PF01042 : Ribonuc_L-PSP", "PF00078 : RVT_1", 
                      "SSF57716 : 0050850", "SSF51182 : 0050937", "SSF74924 : 0052212", 
                      "PR00162 : RIESKE", "PF08614 : ATG16", "SSF52540 : 0042139", 
                      "SSF50692 : 0037182", "SSF63451 : 0047566", "SSF52980 : 0037606", 
                      "SSF55486 : 0035666", "SSF55874 : 0035364", "SSF56176 : 0036445", 
                      "PF00933 : Glyco_hydro_3", "PF00982 : Glyco_transf_20", "PIRSF000850 :", 
                      "SSF52418 : 0048481", "SSF56672 : 0049251", "SSF54358 : 0038031", 
                      "SSF56808 : 0041157", "SSF49265 : 0046817", "PF04096 : Nucleoporin2", 
                      "SSF47220 : 0043748", "PS50819 : INTEIN_ENDONUCLEASE", "SSF51735 : 0047516", 
                      "SSF57440 : 0045529", "SSF53474 : 0039318", "SSF55194 : 0036999", 
                      "SSF51735 : 0045718", "SSF51569 : 0037126", "SSF103580 : 0040071", 
                      "SSF52540 : 0047797", "SSF46626 : 0035454", "PF08514 : STAG", 
                      "SSF51735 : 0036892", "SSF52540 : 0046105", "SSF54358 : 0047800", 
                      "SSF49344 : 0036296", "SSF57392 : 0038424", "TIGR02274 : dCTP_deam", 
                      "SSF75625 : 0040186", "SSF54928 : 0052222", "SSF53901 : 0049940", 
                      "SSF55729 : 0051830", "SSF50814 : 0042384", "SSF49695 : 0042432", 
                      "SSF52540 : 0036961", "SSF48695 : 0037571", "SSF54495 : 0046890", 
                      "SSF52833 : 0039278", "SSF56104 : 0034865", "TIGR00089 : TIGR00089", 
                      "PF00633 : HHH", "SSF56601 : 0047727", "PF01457 : Peptidase_M8", 
                      "SSF55785 : 0048644", "SSF56235 : 0043426", "SSF47175 : 0049289", 
                      "SSF54160 : 0045848", "SSF81296 : 0047990", "SSF46894 : 0040077", 
                      "PF04727 : ELMO_CED12", "PF04068 : RLI", "SSF101173 : 0042540", 
                      "SSF50729 : 0042168", "SSF54768 : 0050800", "SSF53784 : 0042288", 
                      "SSF53271 : 0036900", "SSF55103 : 0046341", "SSF52833 : 0048594", 
                      "PR00892 : RABGDI", "SSF52440 : 0053014", "SSF55174 : 0044787", 
                      "SSF53800 : 0044031", "SSF74650 : 0051369", "SSF54913 : 0040217", 
                      "PF02150 : RNA_POL_M_15KD", "PF04712 : Radial_spoke", "PF03845 : Spore_permease", 
                      "SSF54637 : 0050179", "PF00366 : Ribosomal_S17", "SSF51735 : 0047276", 
                      "SSF55486 : 0045667", "SSF56003 : 0046775", "SSF56112 : 0037668", 
                      "SSF50156 : 0042601", "SSF46557 : 0052572", "PS50909 : GAT", 
                      "SSF102462 : 0049286", "SSF81296 : 0041894", "SSF47240 : 0043805", 
                      "SSF52540 : 0043479", "SSF52540 : 0050350", "SSF55920 : 0042482", 
                      "SSF47113 : 0039520", "TIGR01731 : fil_hemag_20aa", "SSF56801 : 0043886", 
                      "SSF53756 : 0053131", "SSF52777 : 0040386", "SSF51569 : 0050278", 
                      "SSF56436 : 0040504", "PF10564 : MAR_sialic_bdg", "PF03466 : LysR_substrate", 
                      "SSF53474 : 0053336", "PF02492 : cobW", "PF01927 : DUF82", "SSF52080 : 0037538", 
                      "SSF53474 : 0046928", "SSF51366 : 0039781", "SSF46689 : 0047179", 
                      "TIGR00888 : guaA_Nterm", "PF02616 : ScpA_ScpB", "SSF103263 : 0043704", 
                      "SSF53597 : 0044710", "SSF49899 : 0036418", "PF00194 : Carb_anhydrase", 
                      "SSF52343 : 0049711", "SSF46934 : 0048854", "SSF48208 : 0035270", 
                      "PD142783 :", "SSF55347 : 0045036", "PD002815 :", "SSF49309 : 0040274", 
                      "SSF56281 : 0051275", "SSF57667 : 0045293", "SSF47616 : 0051531", 
                      "PF00990 : GGDEF", "SSF54913 : 0049929", "SSF54980 : 0050451", 
                      "SSF46609 : 0038819", "SSF50814 : 0039823", "PR00050 : COLDSHOCK", 
                      "SSF54849 : 0041816", "SSF52540 : 0051952", "SSF55931 : 0050309", 
                      "SSF53335 : 0037939", "PF05652 : DcpS", "SSF53850 : 0052357", 
                      "SSF52833 : 0043030", "SSF51735 : 0036517", "TIGR00755 : ksgA", 
                      "SSF56112 : 0036061", "PF02806 : Alpha-amylase_C", "SSF47802 : 0046345", 
                      "SSF52540 : 0039552", "SSF52518 : 0044102", "PR00704 : CALPAIN", 
                      "SSF50692 : 0037988", "SSF50386 : 0037124", "SSF53218 : 0052822", 
                      "SSF46785 : 0052644", "SSF50814 : 0051470", "SSF55031 : 0050177", 
                      "PF05529 : Bap31", "SSF46785 : 0048817", "SSF55486 : 0049097", 
                      "SSF47240 : 0036546", "SSF48726 : 0037389", "SSF47598 : 0041018", 
                      "SSF55120 : 0044677", "PF02574 : S-methyl_trans", "SSF47233 : 0038562", 
                      "SSF49899 : 0038486", "PF05809 : DUF841", "SSF55486 : 0043489", 
                      "PS50889 : S4", "SSF51445 : 0049705", "SSF51182 : 0036688", "PF03604 : DNA_RNApol_7kD", 
                      "SSF51182 : 0041797", "SSF52821 : 0044241", "SSF81296 : 0037762", 
                      "SSF50729 : 0050722", "TIGR00516 : acpS", "PF08562 : Crisp", 
                      "SSF51230 : 0041726", "SSF81483 : 0037267", "SSF52972 : 0052132", 
                      "SSF52833 : 0046295", "SSF50249 : 0049455", "PF04729 : Anti-silence", 
                      "SSF57716 : 0040006", "SSF50729 : 0052868", "SSF49785 : 0036298", 
                      "SSF51445 : 0048959", "SSF54495 : 0042593", "SSF47226 : 0038885", 
                      "SSF56994 : 0036960", "SSF57716 : 0049245", "SSF81891 : 0040956", 
                      "SSF49329 : 0046366", "SSF51430 : 0045776", "SSF49503 : 0040792", 
                      "SSF55729 : 0051777", "SSF47266 : 0038728", "PD868899 :", "SSF54814 : 0050549", 
                      "PS50171 : ZF_MATRIN", "SSF51569 : 0046461", "SSF50692 : 0052771", 
                      "SSF52540 : 0050449", "PIRSF006157 :", "SSF46929 : 0046216", 
                      "SSF48264 : 0049296", "SSF51011 : 0051974", "SSF51206 : 0047248", 
                      "SSF55486 : 0043304", "SSF54452 : 0039959", "SSF47413 : 0049337", 
                      "SSF55961 : 0049937", "SSF57048 : 0048883", "PF10218 : DUF2054", 
                      "SSF49265 : 0050052", "SSF50692 : 0045381", "SSF50494 : 0041509", 
                      "SSF57059 : 0042824", "PF10516 : SHNi-TPR", "SSF53335 : 0039260", 
                      "SSF47113 : 0038405", "PR00371 : FPNCR", "SSF48726 : 0036352", 
                      "SSF46785 : 0049859", "SSF49329 : 0051255", "SSF54076 : 0035378", 
                      "SSF46689 : 0047361", "SSF54782 : 0035049", "SSF51905 : 0037488", 
                      "SSF49899 : 0043537", "PF00958 : GMP_synt_C", "SSF56112 : 0044090", 
                      "SSF50022 : 0037736", "PIRSF018293 :", "PF01218 : Coprogen_oxidas", 
                      "SSF55729 : 0042973", "SSF57392 : 0037498", "SSF47616 : 0048056", 
                      "SSF52799 : 0051082", "SSF48726 : 0034874", "PIRSF015588 :", 
                      "SSF52799 : 0048567", "PS50051 : MCM_2", "PF01491 : Frataxin_Cyay", 
                      "SSF57392 : 0046326", "SSF52317 : 0035959", "SSF50729 : 0044660", 
                      "SSF68923 : 0040081", "SSF55957 : 0040060", "SSF46689 : 0035741", 
                      "SSF49785 : 0036533", "SSF57868 : 0046327", "SSF49899 : 0053267", 
                      "SSF55781 : 0050183", "SSF53067 : 0047243", "PF01073 : 3Beta_HSD", 
                      "SSF82704 : 0044887", "PF00652 : Ricin_B_lectin", "SSF81296 : 0047946", 
                      "SSF51735 : 0045669", "SSF48113 : 0042766", "PIRSF037093 :", 
                      "PF10366 : Vps39_1", "SSF56327 : 0038278", "SSF56281 : 0051863", 
                      "SSF46689 : 0045634", "SSF56399 : 0039066", "SSF57196 : 0038148", 
                      "SSF109604 : 0043283", "PS50525 : RDRP_SSRNA_NEG_SEG", "SSF49265 : 0037681", 
                      "SSF55979 : 0043401", "SSF57783 : 0047305", "SSF52833 : 0042775", 
                      "SSF52402 : 0051038", "PF09724 : DUF2036", "SSF50939 : 0053303", 
                      "SSF47473 : 0036461", "PR00705 : PAPAIN", "SSF48065 : 0040329", 
                      "PF00095 : WAP", "SSF49785 : 0044551", "SSF56601 : 0048080", 
                      "PF10208 : Armet", "PF00799 : Gemini_AL1", "PF01161 : PBP", "SSF56235 : 0047427", 
                      "SSF56112 : 0044924", "SSF82866 : 0039249", "SSF56574 : 0039630", 
                      "SSF48726 : 0047667", "SSF47113 : 0041190", "SSF52374 : 0049118", 
                      "SSF51649 : 0052386", "SSF54791 : 0045281", "TIGR00094 : TIGR00094", 
                      "SSF47370 : 0046608", "PF10711 : DUF2513", "PF06682 : DUF1183", 
                      "PS50876 : ZF_INTEGRASE", "SSF53474 : 0034943", "SSF57552 : 0037800", 
                      "SSF55797 : 0035964", "SSF55326 : 0043867", "SSF51735 : 0038268", 
                      "SSF49265 : 0043954", "PS50853 : FN3", "SSF53933 : 0034843", 
                      "SSF51735 : 0041205", "PS50859 : LONGIN", "SSF51556 : 0052968", 
                      "SSF46689 : 0049891", "SSF55797 : 0043663", "PIRSF000676 :", 
                      "SSF54593 : 0040292", "PF00575 : S1", "SSF53613 : 0052420", "SSF51735 : 0046123", 
                      "SSF52833 : 0037363", "SSF48726 : 0044716", "SSF48695 : 0048931", 
                      "PR00019 : LEURICHRPT", "SSF50249 : 0034894", "SSF81606 : 0049733", 
                      "SSF55961 : 0050208", "PD105831 :", "PF02893 : GRAM", "PR00991 : 6PFRUCTKNASE", 
                      "SSF53474 : 0048935", "SSF63411 : 0039395", "SSF46458 : 0034966", 
                      "SSF64356 : 0047143", "SSF46689 : 0041779", "SSF53850 : 0047138", 
                      "PF09809 : MRP-L27", "SSF56601 : 0037957", "SSF51735 : 0039360", 
                      "SSF48726 : 0036125", "PS50294 : WD_REPEATS_REGION", "SSF54358 : 0041107", 
                      "SSF50494 : 0037786", "SSF47240 : 0040226", "SSF52540 : 0048702", 
                      "SSF51274 : 0035860", "PD014532 :", "SSF53474 : 0038320", "SSF53335 : 0040327", 
                      "PF08172 : CASP_C", "SSF56112 : 0036141", "SSF109779 : 0044344", 
                      "PD063974 :", "SSF53822 : 0046959", "SSF55486 : 0053341", "PD004443 :", 
                      "SSF56327 : 0037279", "TIGR00464 : gltX_bact", "SSF51905 : 0038285", 
                      "SSF56601 : 0051055", "SSF50249 : 0047028", "PIRSF006487 :", 
                      "SSF55781 : 0040879", "SSF81296 : 0048942", "SSF46689 : 0053235", 
                      "SSF81296 : 0046021", "PF02838 : Glyco_hydro_20b", "SSF55909 : 0045012", 
                      "SSF48600 : 0052736", "SSF56112 : 0039661", "SSF51126 : 0047331", 
                      "SSF46689 : 0038986", "SSF53822 : 0049989", "PF05470 : eIF-3c_N", 
                      "PS51151 : NAC_AB", "SSF57610 : 0043310", "SSF51679 : 0041371", 
                      "SSF54593 : 0043692", "SSF49899 : 0049955", "SSF56574 : 0039580", 
                      "SSF48225 : 0041604", "SSF57903 : 0050470", "PF01923 : Cob_adeno_trans", 
                      "SSF51735 : 0038259", "PF08264 : Anticodon_1", "SSF53448 : 0044656", 
                      "PIRSF016599 :", "PF04676 : CwfJ_C_2", "SSF57059 : 0048000", 
                      "TIGR01077 : L13_A_E", "PS51059 : PARP_CATALYTIC", "PF08701 : GN3L_Grn1", 
                      "PR00144 : DALDHYDRTASE", "SSF69125 : 0040011", "SSF46458 : 0039611", 
                      "SSF47616 : 0045279", "PF00623 : RNA_pol_Rpb1_2", "SSF46626 : 0044968", 
                      "PF05188 : MutS_II", "SSF53383 : 0035870", "SSF51182 : 0037841", 
                      "SSF53067 : 0041901", "SSF88633 : 0045843", "SSF52467 : 0036971", 
                      "SSF53335 : 0040350", "SSF54897 : 0035260", "SSF101790 : 0050059", 
                      "SSF88723 : 0050398", "SSF50346 : 0037265", "SSF47857 : 0035022", 
                      "SSF49265 : 0037852", "PS50003 : PH_DOMAIN", "SSF53271 : 0050151", 
                      "PF07821 : Alpha-amyl_C2", "SSF51735 : 0038814", "SSF54791 : 0039845", 
                      "SSF75553 : 0038317", "SSF50156 : 0041246", "PF00643 : zf-B_box", 
                      "SSF50814 : 0041665", "SSF52218 : 0049652", "SSF47473 : 0049421", 
                      "SSF49899 : 0041102", "SSF48452 : 0046585", "SSF46689 : 0050824", 
                      "SSF54980 : 0050192", "SSF48371 : 0045990", "SSF52833 : 0048146", 
                      "SSF56672 : 0047702", "PF07683 : CobW_C", "PF03849 : Tfb2", "SSF54452 : 0038556", 
                      "SSF57501 : 0035502", "SSF52540 : 0049306", "SSF57196 : 0035158", 
                      "PF03227 : GILT", "SSF52172 : 0036681", "SSF49319 : 0038809", 
                      "SSF55248 : 0036353", "PF08287 : DASH_Spc19", "SSF51182 : 0046787", 
                      "SSF49309 : 0037323", "SSF48576 : 0041185", "SSF52343 : 0049950", 
                      "SSF52374 : 0039171", "SSF46689 : 0050188", "SSF52129 : 0042519", 
                      "SSF46689 : 0052312", "SSF50249 : 0040675", "SSF50985 : 0045691", 
                      "SSF56784 : 0051348", "SSF48034 : 0042821", "SSF47459 : 0043065", 
                      "SSF55681 : 0041634", "SSF46946 : 0037623", "SSF52540 : 0037862", 
                      "SSF54593 : 0042549", "SSF53686 : 0050156", "SSF53300 : 0035198", 
                      "SSF82704 : 0041387", "SSF52540 : 0051648", "PF04855 : SNF5", 
                      "SSF51182 : 0048558", "SSF48508 : 0037660", "SSF53335 : 0044329", 
                      "SSF56784 : 0051058", "SSF81338 : 0037740", "SSF48179 : 0036487", 
                      "SSF81891 : 0044734", "SSF50386 : 0049132", "SSF51412 : 0036942", 
                      "SSF57802 : 0036646", "SSF56854 : 0048479", "PD067159 :", "PIRSF006464 :", 
                      "SSF54236 : 0049903", "PF08153 : NGP1NT", "SSF81502 : 0037294", 
                      "SSF50044 : 0035438", "SSF111069 : 0043421", "PF02883 : Alpha_adaptinC2", 
                      "SSF50630 : 0035765", "PF02752 : Arrestin_C", "SSF54637 : 0039261", 
                      "SSF53623 : 0052866", "SSF51445 : 0046152", "SSF54452 : 0034899", 
                      "PF00613 : PI3Ka", "SSF57667 : 0043976", "SSF52540 : 0044700", 
                      "PF07350 : DUF1479", "SSF50814 : 0040605", "PF02655 : ATP-grasp_3", 
                      "PF07422 : s48_45", "SSF51569 : 0039482", "SSF53474 : 0046793", 
                      "PR00959 : MEVGALKINASE", "SSF56059 : 0046632", "SSF52218 : 0051357", 
                      "SSF50156 : 0050541", "SSF52374 : 0039570", "SSF53955 : 0039740", 
                      "SSF54373 : 0042234", "SSF54928 : 0050565", "SSF53223 : 0034873", 
                      "PF10239 : DUF2465", "PF04118 : Dopey_N", "PF02167 : Cytochrom_C1", 
                      "PF09177 : Syntaxin-6_N", "SSF51604 : 0045216", "SSF50729 : 0045807", 
                      "SSF47576 : 0050621", "SSF53448 : 0038427", "SSF46785 : 0047234", 
                      "SSF50692 : 0044057", "SSF51717 : 0048901", "SSF53271 : 0051163", 
                      "SSF51445 : 0050215", "PF09325 : Vps5", "SSF81799 : 0050518", 
                      "SSF101238 : 0049666", "SSF54416 : 0047870", "SSF57196 : 0046526", 
                      "SSF69819 : 0039380", "SSF54060 : 0044583", "PIRSF000422 :", 
                      "SSF52833 : 0042081", "SSF52540 : 0035174", "SSF54826 : 0049749", 
                      "PD079544 :", "SSF52833 : 0047981", "SSF47413 : 0043448", "SSF54236 : 0050543", 
                      "SSF50104 : 0046770", "SSF48239 : 0048283", "PS51025 : PWI", 
                      "SSF49899 : 0040472", "PIRSF016255 :", "PF01442 : Apolipoprotein", 
                      "SSF51735 : 0045894", "SSF47954 : 0039606", "PF04494 : TFIID_90kDa", 
                      "SSF50814 : 0035164", "SSF55464 : 0037306", "SSF50249 : 0043731", 
                      "SSF55035 : 0036555", "SSF55931 : 0051614", "SSF48726 : 0042748", 
                      "SSF51366 : 0050290", "PF06747 : CHCH", "SSF49879 : 0040092", 
                      "SSF50044 : 0049175", "SSF52833 : 0050617", "SSF55718 : 0039068", 
                      "SSF50729 : 0051204", "TIGR00283 : arch_pth2", "SSF55347 : 0041597", 
                      "SSF52172 : 0036349", "SSF63999 : 0039002", "SSF46785 : 0046435", 
                      "PS50805 : KRAB", "PD000707 :", "PF00107 : ADH_zinc_N", "SSF52025 : 0036380", 
                      "SSF52833 : 0051914", "PF00251 : Glyco_hydro_32N", "SSF46458 : 0052870", 
                      "TIGR00458 : aspS_arch", "SSF46785 : 0052718", "TIGR02346 : chap_CCT_theta", 
                      "SSF48619 : 0037507", "SSF55326 : 0049528", "TIGR00174 : miaA", 
                      "PR00800 : YHDCRBOXLASE", "SSF50370 : 0043032", "SSF55550 : 0045735", 
                      "SSF69349 : 0051627", "SSF55909 : 0044842", "SSF52210 : 0048575", 
                      "SSF54211 : 0043463", "SSF46767 : 0048993", "SSF46689 : 0047429", 
                      "SSF50129 : 0050001", "SSF47807 : 0035343", "SSF53474 : 0038613", 
                      "SSF54719 : 0043745", "SSF54277 : 0037357", "SSF47874 : 0035089", 
                      "PF00570 : HRDC", "PF06437 : ISN1", "SSF51230 : 0042385", "PF07142 : DUF1388", 
                      "SSF57716 : 0044640")

GenesByGoTerm = 
function(
`organism` = 'Entamoeba dispar,Entamoeba histolytica,Entamoeba invadens,Cryptosporidium parvum,Cryptosporidium hominis,Cryptosporidium muris,Giardia Assemblage A isolate WB,Giardia Assemblage B isolate GS,Giardia Assemblage E isolate P15,Encephalitozoon cuniculi,Encephalitozoon intestinalis,Enterocytozoon bieneusi,Plasmodium falciparum,Plasmodium vivax,Plasmodium yoelii,Plasmodium berghei,Plasmodium chabaudi,Plasmodium knowlesi,Toxoplasma gondii,Neospora caninum,Trichomonas vaginalis,Trypanosoma cruzi,Leishmania braziliensis,Leishmania infantum,Leishmania major,Leishmania mexicana,Trypanosoma brucei,Trypanosoma congolense,Trypanosoma vivax', `go_term` = 'GO:0044445', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByGoTerm.json' else 'http://eupathdb.org/eupathdb/webservices/GeneQuestions/GenesByGoTerm.xml', .convert = NULL, .json = TRUE
)
{
     `organism` <- checkValues(`organism`, c("Entamoeba dispar", "Entamoeba histolytica", "Entamoeba invadens", 
                      "Cryptosporidium parvum", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Giardia Assemblage A isolate WB", "Giardia Assemblage B isolate GS", 
                      "Giardia Assemblage E isolate P15", "Encephalitozoon cuniculi", 
                      "Encephalitozoon intestinalis", "Enterocytozoon bieneusi", "Plasmodium falciparum", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium knowlesi", "Toxoplasma gondii", 
                      "Neospora caninum", "Trichomonas vaginalis", "Trypanosoma cruzi", 
                      "Leishmania braziliensis", "Leishmania infantum", "Leishmania major", 
                      "Leishmania mexicana", "Trypanosoma brucei", "Trypanosoma congolense", 
                      "Trypanosoma vivax"), 'organism', TRUE)
     `go_term` <- checkValues(`go_term`, "`GenesByGoTerm.go_term.options`", 'go_term', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "formatted_gene_id", "sequence_id", 
                      "chromosome", "location_text", "strand", "gene_type", "exon_count", 
                      "transcript_length", "cds_length", "product", "protein_length", 
                      "tm_count", "molecular_weight", "isoelectric_point", "ec_numbers_string", 
                      "ortholog_number", "paralog_number", "orthomcl_name", "signalp_scores", 
                      "signalp_peptide", "ann_go_function", "ann_go_process", "ann_go_component", 
                      "pred_go_function", "pred_go_process", "pred_go_component", "organism", 
                      "is_pseudo", "protein_sequence", "transcript_sequence", "cds", 
                      "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "SNPs", "GeneModelDump", "InterPro", "TMHMM", 
                      "LowComplexity", "SignalP", "BlastP", "Genbank", "SageTags", 
                      "Notes", "UserComments", "CommunityExpComments", "EcNumber", 
                      "MassSpec", "GoTerms", "Phenotype", "Y2hInteractions", "Orthologs", 
                      "MetabolicPathways", "TaskComments", "ArrayElements", "TwoChannelDiffExpr", 
                      "ProteinExpression", "Mr4Reagents", "ProteinDatabase", "GeneLinkouts", 
                      "3dPreds", "PdbSimilarities", "Epitopes", "IsolateOverlap"), 'o-tables', TRUE)
    params = list(
                  'organism' = `organism`,
                  'go_term' = `go_term`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

`GenesByGoTerm.go_term.options` = 
  c("GO:0044445", "GO:0044452", "GO:0051020", "GO:0051170", "GO:0001510", 
                      "GO:0001871", "GO:0003924", "GO:0005496", "GO:0005515", "GO:0005794", 
                      "GO:0005886", "GO:0006094", "GO:0006260", "GO:0006298", "GO:0006306", 
                      "GO:0006364", "GO:0006397", "GO:0006457", "GO:0006512", "GO:0006820", 
                      "GO:0006869", "GO:0006955", "GO:0008033", "GO:0008097", "GO:0010467", 
                      "GO:0015074", "GO:0015837", "GO:0016298", "GO:0016301", "GO:0016310", 
                      "GO:0016874", "GO:0016887", "GO:0019842", "GO:0042277", "GO:0042393", 
                      "GO:0042995", "GO:0043233", "GO:0043234", "GO:0048038", "GO:0048278", 
                      "GO:0048475", "GO:0050801", "GO:0000280", "GO:0005102", "GO:0005179", 
                      "GO:0005506", "GO:0005635", "GO:0005657", "GO:0006304", "GO:0006812", 
                      "GO:0006885", "GO:0006952", "GO:0008021", "GO:0008037", "GO:0008270", 
                      "GO:0009451", "GO:0009975", "GO:0009987", "GO:0012506", "GO:0015267", 
                      "GO:0015992", "GO:0016160", "GO:0016592", "GO:0022403", "GO:0022406", 
                      "GO:0030488", "GO:0030904", "GO:0034470", "GO:0042493", "GO:0043022", 
                      "GO:0044427", "GO:0044444", "GO:0044448", "GO:0044451", "GO:0048037", 
                      "GO:0050662", "GO:0075136", "GO:0000154", "GO:0001509", "GO:0003682", 
                      "GO:0003796", "GO:0004053", "GO:0004096", "GO:0004386", "GO:0004518", 
                      "GO:0004872", "GO:0005527", "GO:0005774", "GO:0005801", "GO:0006310", 
                      "GO:0006400", "GO:0006605", "GO:0007596", "GO:0008152", "GO:0009056", 
                      "GO:0009306", "GO:0015031", "GO:0015746", "GO:0016272", "GO:0016311", 
                      "GO:0030126", "GO:0030133", "GO:0032940", "GO:0033279", "GO:0042255", 
                      "GO:0042597", "GO:0043601", "GO:0044430", "GO:0046872", "GO:0048285", 
                      "GO:0051087", "GO:0051169", "GO:0000166", "GO:0000228", "GO:0000278", 
                      "GO:0000439", "GO:0000502", "GO:0001882", "GO:0003674", "GO:0003824", 
                      "GO:0004568", "GO:0005186", "GO:0005507", "GO:0005575", "GO:0006118", 
                      "GO:0006740", "GO:0006791", "GO:0006818", "GO:0006821", "GO:0006950", 
                      "GO:0007030", "GO:0007034", "GO:0007154", "GO:0007600", "GO:0008150", 
                      "GO:0008233", "GO:0008283", "GO:0010876", "GO:0015293", "GO:0015629", 
                      "GO:0015976", "GO:0016032", "GO:0016197", "GO:0016485", "GO:0016597", 
                      "GO:0016787", "GO:0016853", "GO:0019013", "GO:0019239", "GO:0019509", 
                      "GO:0022402", "GO:0022626", "GO:0030127", "GO:0030258", "GO:0031090", 
                      "GO:0031491", "GO:0031497", "GO:0031967", "GO:0043102", "GO:0044424", 
                      "GO:0044429", "GO:0051321", "GO:0051604", "GO:0055080", "GO:0070279", 
                      "GO:0003684", "GO:0003909", "GO:0004396", "GO:0004601", "GO:0004707", 
                      "GO:0004747", "GO:0005509", "GO:0005802", "GO:0006334", "GO:0006342", 
                      "GO:0007165", "GO:0007267", "GO:0007548", "GO:0007626", "GO:0009060", 
                      "GO:0009279", "GO:0012505", "GO:0015297", "GO:0016573", "GO:0018342", 
                      "GO:0019953", "GO:0022610", "GO:0030001", "GO:0030137", "GO:0030259", 
                      "GO:0031410", "GO:0031980", "GO:0032993", "GO:0034204", "GO:0034702", 
                      "GO:0042254", "GO:0042592", "GO:0043039", "GO:0045116", "GO:0051287", 
                      "GO:0055114", "GO:0000103", "GO:0000150", "GO:0003676", "GO:0003896", 
                      "GO:0003951", "GO:0004215", "GO:0004527", "GO:0004803", "GO:0005215", 
                      "GO:0005216", "GO:0005543", "GO:0005576", "GO:0005681", "GO:0005759", 
                      "GO:0006284", "GO:0006338", "GO:0006814", "GO:0006865", "GO:0007033", 
                      "GO:0008013", "GO:0008104", "GO:0009058", "GO:0009611", "GO:0015858", 
                      "GO:0015926", "GO:0016021", "GO:0016209", "GO:0016570", "GO:0016740", 
                      "GO:0016791", "GO:0016836", "GO:0019213", "GO:0019725", "GO:0022414", 
                      "GO:0032991", "GO:0034311", "GO:0034703", "GO:0043414", "GO:0045454", 
                      "GO:0046058", "GO:0046072", "GO:0046075", "GO:0046080", "GO:0046677", 
                      "GO:0051015", "GO:0051258", "GO:0051704", "GO:0051920", "GO:0000441", 
                      "GO:0001522", "GO:0004177", "GO:0004523", "GO:0004526", "GO:0004672", 
                      "GO:0004849", "GO:0005048", "GO:0005261", "GO:0005647", "GO:0005839", 
                      "GO:0006098", "GO:0006629", "GO:0006813", "GO:0008776", "GO:0008829", 
                      "GO:0009308", "GO:0009310", "GO:0015711", "GO:0015929", "GO:0015934", 
                      "GO:0015935", "GO:0016042", "GO:0016211", "GO:0016491", "GO:0016832", 
                      "GO:0030136", "GO:0030662", "GO:0031216", "GO:0031406", "GO:0031974", 
                      "GO:0034061", "GO:0034062", "GO:0034660", "GO:0034728", "GO:0042981", 
                      "GO:0043229", "GO:0043412", "GO:0044454", "GO:0045047", "GO:0046907", 
                      "GO:0048193", "GO:0051235", "GO:0051276", "GO:0055085", "GO:0000151", 
                      "GO:0000172", "GO:0004100", "GO:0004370", "GO:0004532", "GO:0004629", 
                      "GO:0004743", "GO:0005787", "GO:0005798", "GO:0006030", "GO:0006032", 
                      "GO:0006099", "GO:0006108", "GO:0006183", "GO:0006222", "GO:0006228", 
                      "GO:0006241", "GO:0006352", "GO:0006413", "GO:0006414", "GO:0006461", 
                      "GO:0006754", "GO:0006790", "GO:0006873", "GO:0008415", "GO:0009011", 
                      "GO:0009288", "GO:0009435", "GO:0010941", "GO:0015630", "GO:0016421", 
                      "GO:0016462", "GO:0018958", "GO:0019318", "GO:0019320", "GO:0019751", 
                      "GO:0019866", "GO:0022900", "GO:0030131", "GO:0031420", "GO:0031988", 
                      "GO:0032040", "GO:0032774", "GO:0033897", "GO:0035091", "GO:0042256", 
                      "GO:0042623", "GO:0043413", "GO:0030246", "GO:0032392", "GO:0032508", 
                      "GO:0042891", "GO:0044431", "GO:0044459", "GO:0045333", "GO:0046821", 
                      "GO:0046906", "GO:0048878", "GO:0050896", "GO:0051674", "GO:0000036", 
                      "GO:0000287", "GO:0001727", "GO:0002376", "GO:0003678", "GO:0003724", 
                      "GO:0004067", "GO:0004470", "GO:0004519", "GO:0004540", "GO:0004856", 
                      "GO:0005783", "GO:0006259", "GO:0006401", "GO:0006816", "GO:0007088", 
                      "GO:0007268", "GO:0008238", "GO:0008483", "GO:0008865", "GO:0010324", 
                      "GO:0012501", "GO:0016044", "GO:0016070",