IsolateByIsolateId = 
function(
`isolate_id` = 'AF527841', `signature`, `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByIsolateId.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByIsolateId.xml', .convert = NULL, .json = TRUE
)
{
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'isolate_id' = `isolate_id`,
                  'signature' = `signature`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolateByTaxon = 
function(
`strain` = 'Cryptosporidium sp. AHCF-4,Cryptosporidium sp. B1-11,Cryptosporidium sp. B1-36,Cryptosporidium sp. B1-41,Cryptosporidium sp. B2-6,Cryptosporidium sp. B2-7,Cryptosporidium sp. BB23,Cryptosporidium sp. BD1,Cryptosporidium sp. BE20,Cryptosporidium sp. BE5,Cryptosporidium sp. BE6,Cryptosporidium sp. BG5,Cryptosporidium sp. BP1,Cryptosporidium sp. BW3,Cryptosporidium sp. CHB-01,Cryptosporidium sp. CHB-02,Cryptosporidium sp. CHB-03,Cryptosporidium sp. CHB-04,Cryptosporidium sp. CHB-05,Cryptosporidium sp. CHB-06,Cryptosporidium sp. CS15S,Cryptosporidium sp. CSP06,Cryptosporidium sp. CrCZ-27,Cryptosporidium sp. CrIT-20,Cryptosporidium sp. Czech B1,Cryptosporidium sp. Czech B4,Cryptosporidium sp. Ec-14887,Cryptosporidium sp. Eire V zz67,Cryptosporidium sp. Eire VI w37,Cryptosporidium sp. Eire w65.4,Cryptosporidium sp. Eire w65.5,Cryptosporidium sp. GF1,Cryptosporidium sp. GF2,Cryptosporidium sp. GF2_1,Cryptosporidium sp. GF2_2,Cryptosporidium sp. H205,Cryptosporidium sp. HPF-2007,Cryptosporidium sp. K1,Cryptosporidium sp. K4515,Cryptosporidium sp. KLJ-0,Cryptosporidium sp. KLJ-1,Cryptosporidium sp. KLJ-2,Cryptosporidium sp. KLJ-3a,Cryptosporidium sp. KLJ-3b,Cryptosporidium sp. KLJ-5,Cryptosporidium sp. KLJ-6,Cryptosporidium sp. KLJ-7,Cryptosporidium sp. KLJ-8,Cryptosporidium sp. KLJ-9,Cryptosporidium sp. LLX-2003,Cryptosporidium sp. LPHN,Cryptosporidium sp. M16,Cryptosporidium sp. M24,Cryptosporidium sp. M29,Cryptosporidium sp. M30,Cryptosporidium sp. M427,Cryptosporidium sp. M452,Cryptosporidium sp. MNJ-1,Cryptosporidium sp. Marsupial K1,Cryptosporidium sp. Marsupial K2,Cryptosporidium sp. Morro Bay New-1,Cryptosporidium sp. Morro Bay New-2,Cryptosporidium sp. Morro Bay Non-Crypto-1,Cryptosporidium sp. Morro Bay Non-Crypto-2,Cryptosporidium sp. ND59,Cryptosporidium sp. O92,Cryptosporidium sp. O93,Cryptosporidium sp. P111,Cryptosporidium sp. PF1,Cryptosporidium sp. PG1-26,Cryptosporidium sp. Pig 1,Cryptosporidium sp. Q1,Cryptosporidium sp. RFAF1,Cryptosporidium sp. RFAF1_1,Cryptosporidium sp. RFAF1_2,Cryptosporidium sp. RFAF1_3,Cryptosporidium sp. RO-Sh2,Cryptosporidium sp. S2317,Cryptosporidium sp. S45,Cryptosporidium sp. S49,Cryptosporidium sp. SHCF-1,Cryptosporidium sp. SHCF-2,Cryptosporidium sp. SHCF-3,Cryptosporidium sp. SHCF-4,Cryptosporidium sp. SHCF-5,Cryptosporidium sp. SHCF-6,Cryptosporidium sp. SI23,Cryptosporidium sp. Sbey05c,Cryptosporidium sp. Sbld05a,Cryptosporidium sp. Sbld05c,Cryptosporidium sp. Sbld05d,Cryptosporidium sp. Sltl05c,Cryptosporidium sp. Tahvildar/sh55/IRN,Cryptosporidium sp. Tahvildar/sh59/IRN,Cryptosporidium sp. Taiwan A-4,Cryptosporidium sp. Taiwan B2-21,Cryptosporidium sp. UR-2005,Cryptosporidium sp. W10998 SMC-2008,Cryptosporidium sp. WH3,Cryptosporidium sp. WH33,Cryptosporidium sp. WH5,Cryptosporidium sp. azami,Cryptosporidium sp. beaver genotype,Cryptosporidium sp. cat104,Cryptosporidium sp. cat127,Cryptosporidium sp. cat137,Cryptosporidium sp. cat161,Cryptosporidium sp. cat162,Cryptosporidium sp. cat178,Cryptosporidium sp. cat205,Cryptosporidium sp. cat227,Cryptosporidium sp. cat230,Cryptosporidium sp. cat232,Cryptosporidium sp. cat233,Cryptosporidium sp. cat238,Cryptosporidium sp. cat239,Cryptosporidium sp. cat244,Cryptosporidium sp. cat311,Cryptosporidium sp. cat323,Cryptosporidium sp. cat324,Cryptosporidium sp. cat406,Cryptosporidium sp. cat438,Cryptosporidium sp. cat454,Cryptosporidium sp. cat98,Cryptosporidium sp. cervine genotype (W4),Cryptosporidium sp. chipmunk genotype (W17),Cryptosporidium sp. deer mouse genotype I,Cryptosporidium sp. deer mouse genotype II,Cryptosporidium sp. deer mouse genotype III (W1),Cryptosporidium sp. deer mouse genotype IV (W3),Cryptosporidium sp. dogtype_556,Cryptosporidium sp. ex Perameles bougainville,Cryptosporidium sp. ex Phoca hispida,Cryptosporidium sp. ex Struthio camelus 2005,Cryptosporidium sp. g36,Cryptosporidium sp. goose genotype II,Cryptosporidium sp. irani,Cryptosporidium sp. isfahani,Cryptosporidium sp. kn732,Cryptosporidium sp. marsupial genotype II,Cryptosporidium sp. mink genotype,Cryptosporidium sp. muskrat 603,Cryptosporidium sp. muskrat genotype I (W7),Cryptosporidium sp. muskrat genotype II (W16),Cryptosporidium sp. oyster 19,Cryptosporidium sp. p11,Cryptosporidium sp. pig genotype II,Cryptosporidium sp. shrew genotype (W5),Cryptosporidium sp. vole genotype (W15),Cryptosporidium sp. z10,Cryptosporidium sp. z13,Cryptosporidium sp. zoo.195,Cryptosporidium struthionis,Cryptosporidium suis,Cryptosporidium wrairi,environmental samples,unclassified Cryptosporidium,Giardia lamblia,Giardia lamblia ATCC 50803,unclassified Giardia,Plasmodium berghei,Plasmodium berghei str. ANKA,Plasmodium chabaudi,Plasmodium chabaudi adami,Plasmodium chabaudi chabaudi,Plasmodium falciparum,Plasmodium falciparum 3D7,Plasmodium falciparum NF54,Plasmodium knowlesi,Plasmodium reichenowi,Plasmodium vivax,Plasmodium yoelii,Plasmodium yoelii killicki,Plasmodium yoelii nigeriensis,Plasmodium yoelii yoelii,unclassified Plasmodium,Toxoplasma gondii,Neospora caninum,Cryptosporidium andersoni,Cryptosporidium baileyi,Cryptosporidium bovis,Cryptosporidium canis,Cryptosporidium cf. molnari,Cryptosporidium cf. parvum,Cryptosporidium environmental sequence,Cryptosporidium felis,Cryptosporidium fragile,Cryptosporidium galli,Cryptosporidium hominis,Cryptosporidium meleagridis,Cryptosporidium muris,Cryptosporidium parvum,Cryptosporidium parvum Iowa,Cryptosporidium saurophilum,Cryptosporidium serpentis,Cryptosporidium sp.,Cryptosporidium sp. #691,Cryptosporidium sp. 0583K,Cryptosporidium sp. 1040,Cryptosporidium sp. 1041,Cryptosporidium sp. 1170,Cryptosporidium sp. 118b,Cryptosporidium sp. 1196,Cryptosporidium sp. 1453,Cryptosporidium sp. 1457,Cryptosporidium sp. 1665,Cryptosporidium sp. 169a,Cryptosporidium sp. 169c,Cryptosporidium sp. 17a,Cryptosporidium sp. 17b,Cryptosporidium sp. 200a,Cryptosporidium sp. 200b,Cryptosporidium sp. 2040,Cryptosporidium sp. 2041,Cryptosporidium sp. 204a,Cryptosporidium sp. 2162,Cryptosporidium sp. 21a,Cryptosporidium sp. 21b,Cryptosporidium sp. 21g,Cryptosporidium sp. 2622,Cryptosporidium sp. 2879,Cryptosporidium sp. 2879.VT-2.2003,Cryptosporidium sp. 2a,Cryptosporidium sp. 2b,Cryptosporidium sp. 30,Cryptosporidium sp. 3421,Cryptosporidium sp. 351,Cryptosporidium sp. 3568,Cryptosporidium sp. 3726,Cryptosporidium sp. 411,Cryptosporidium sp. 428,Cryptosporidium sp. 43c,Cryptosporidium sp. 499,Cryptosporidium sp. 518,Cryptosporidium sp. 5490,Cryptosporidium sp. 5538,Cryptosporidium sp. 6750,Cryptosporidium sp. 67a,Cryptosporidium sp. 67b,Cryptosporidium sp. 6876,Cryptosporidium sp. 6887,Cryptosporidium sp. 6898,Cryptosporidium sp. 715,Cryptosporidium sp. 750,Cryptosporidium sp. 751,Cryptosporidium sp. 77c,Cryptosporidium sp. 815,Cryptosporidium sp. 886,Cryptosporidium sp. 888,Cryptosporidium sp. 90g,Cryptosporidium sp. 9111,Cryptosporidium sp. 938,Cryptosporidium sp. 944,Cryptosporidium sp. 94a,Cryptosporidium sp. 94b,Cryptosporidium sp. 9870,Cryptosporidium sp. A16,Cryptosporidium sp. A26,Cryptosporidium sp. A29,Cryptosporidium sp. A7,Cryptosporidium sp. AHCF-1,Cryptosporidium sp. AHCF-2,Cryptosporidium sp. AHCF-3', `type` = 'Sequencing Typed,3kChip,Barcode,HD_Array,RFLP Typed', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByTaxon.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByTaxon.xml', .convert = NULL, .json = TRUE
)
{
     `strain` <- checkValues(`strain`, "`IsolateByTaxon.strain.options`", 'strain', TRUE)
     `type` <- checkValues(`type`, c("Sequencing Typed", "3kChip", "Barcode", "HD_Array", "RFLP Typed"
                      ), 'type', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'strain' = `strain`,
                  'type' = `type`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

`IsolateByTaxon.strain.options` = 
  c("Cryptosporidium sp. AHCF-4", "Cryptosporidium sp. B1-11", 
                      "Cryptosporidium sp. B1-36", "Cryptosporidium sp. B1-41", "Cryptosporidium sp. B2-6", 
                      "Cryptosporidium sp. B2-7", "Cryptosporidium sp. BB23", "Cryptosporidium sp. BD1", 
                      "Cryptosporidium sp. BE20", "Cryptosporidium sp. BE5", "Cryptosporidium sp. BE6", 
                      "Cryptosporidium sp. BG5", "Cryptosporidium sp. BP1", "Cryptosporidium sp. BW3", 
                      "Cryptosporidium sp. CHB-01", "Cryptosporidium sp. CHB-02", "Cryptosporidium sp. CHB-03", 
                      "Cryptosporidium sp. CHB-04", "Cryptosporidium sp. CHB-05", "Cryptosporidium sp. CHB-06", 
                      "Cryptosporidium sp. CS15S", "Cryptosporidium sp. CSP06", "Cryptosporidium sp. CrCZ-27", 
                      "Cryptosporidium sp. CrIT-20", "Cryptosporidium sp. Czech B1", 
                      "Cryptosporidium sp. Czech B4", "Cryptosporidium sp. Ec-14887", 
                      "Cryptosporidium sp. Eire V zz67", "Cryptosporidium sp. Eire VI w37", 
                      "Cryptosporidium sp. Eire w65.4", "Cryptosporidium sp. Eire w65.5", 
                      "Cryptosporidium sp. GF1", "Cryptosporidium sp. GF2", "Cryptosporidium sp. GF2_1", 
                      "Cryptosporidium sp. GF2_2", "Cryptosporidium sp. H205", "Cryptosporidium sp. HPF-2007", 
                      "Cryptosporidium sp. K1", "Cryptosporidium sp. K4515", "Cryptosporidium sp. KLJ-0", 
                      "Cryptosporidium sp. KLJ-1", "Cryptosporidium sp. KLJ-2", "Cryptosporidium sp. KLJ-3a", 
                      "Cryptosporidium sp. KLJ-3b", "Cryptosporidium sp. KLJ-5", "Cryptosporidium sp. KLJ-6", 
                      "Cryptosporidium sp. KLJ-7", "Cryptosporidium sp. KLJ-8", "Cryptosporidium sp. KLJ-9", 
                      "Cryptosporidium sp. LLX-2003", "Cryptosporidium sp. LPHN", "Cryptosporidium sp. M16", 
                      "Cryptosporidium sp. M24", "Cryptosporidium sp. M29", "Cryptosporidium sp. M30", 
                      "Cryptosporidium sp. M427", "Cryptosporidium sp. M452", "Cryptosporidium sp. MNJ-1", 
                      "Cryptosporidium sp. Marsupial K1", "Cryptosporidium sp. Marsupial K2", 
                      "Cryptosporidium sp. Morro Bay New-1", "Cryptosporidium sp. Morro Bay New-2", 
                      "Cryptosporidium sp. Morro Bay Non-Crypto-1", "Cryptosporidium sp. Morro Bay Non-Crypto-2", 
                      "Cryptosporidium sp. ND59", "Cryptosporidium sp. O92", "Cryptosporidium sp. O93", 
                      "Cryptosporidium sp. P111", "Cryptosporidium sp. PF1", "Cryptosporidium sp. PG1-26", 
                      "Cryptosporidium sp. Pig 1", "Cryptosporidium sp. Q1", "Cryptosporidium sp. RFAF1", 
                      "Cryptosporidium sp. RFAF1_1", "Cryptosporidium sp. RFAF1_2", 
                      "Cryptosporidium sp. RFAF1_3", "Cryptosporidium sp. RO-Sh2", 
                      "Cryptosporidium sp. S2317", "Cryptosporidium sp. S45", "Cryptosporidium sp. S49", 
                      "Cryptosporidium sp. SHCF-1", "Cryptosporidium sp. SHCF-2", "Cryptosporidium sp. SHCF-3", 
                      "Cryptosporidium sp. SHCF-4", "Cryptosporidium sp. SHCF-5", "Cryptosporidium sp. SHCF-6", 
                      "Cryptosporidium sp. SI23", "Cryptosporidium sp. Sbey05c", "Cryptosporidium sp. Sbld05a", 
                      "Cryptosporidium sp. Sbld05c", "Cryptosporidium sp. Sbld05d", 
                      "Cryptosporidium sp. Sltl05c", "Cryptosporidium sp. Tahvildar/sh55/IRN", 
                      "Cryptosporidium sp. Tahvildar/sh59/IRN", "Cryptosporidium sp. Taiwan A-4", 
                      "Cryptosporidium sp. Taiwan B2-21", "Cryptosporidium sp. UR-2005", 
                      "Cryptosporidium sp. W10998 SMC-2008", "Cryptosporidium sp. WH3", 
                      "Cryptosporidium sp. WH33", "Cryptosporidium sp. WH5", "Cryptosporidium sp. azami", 
                      "Cryptosporidium sp. beaver genotype", "Cryptosporidium sp. cat104", 
                      "Cryptosporidium sp. cat127", "Cryptosporidium sp. cat137", "Cryptosporidium sp. cat161", 
                      "Cryptosporidium sp. cat162", "Cryptosporidium sp. cat178", "Cryptosporidium sp. cat205", 
                      "Cryptosporidium sp. cat227", "Cryptosporidium sp. cat230", "Cryptosporidium sp. cat232", 
                      "Cryptosporidium sp. cat233", "Cryptosporidium sp. cat238", "Cryptosporidium sp. cat239", 
                      "Cryptosporidium sp. cat244", "Cryptosporidium sp. cat311", "Cryptosporidium sp. cat323", 
                      "Cryptosporidium sp. cat324", "Cryptosporidium sp. cat406", "Cryptosporidium sp. cat438", 
                      "Cryptosporidium sp. cat454", "Cryptosporidium sp. cat98", "Cryptosporidium sp. cervine genotype (W4)", 
                      "Cryptosporidium sp. chipmunk genotype (W17)", "Cryptosporidium sp. deer mouse genotype I", 
                      "Cryptosporidium sp. deer mouse genotype II", "Cryptosporidium sp. deer mouse genotype III (W1)", 
                      "Cryptosporidium sp. deer mouse genotype IV (W3)", "Cryptosporidium sp. dogtype_556", 
                      "Cryptosporidium sp. ex Perameles bougainville", "Cryptosporidium sp. ex Phoca hispida", 
                      "Cryptosporidium sp. ex Struthio camelus 2005", "Cryptosporidium sp. g36", 
                      "Cryptosporidium sp. goose genotype II", "Cryptosporidium sp. irani", 
                      "Cryptosporidium sp. isfahani", "Cryptosporidium sp. kn732", 
                      "Cryptosporidium sp. marsupial genotype II", "Cryptosporidium sp. mink genotype", 
                      "Cryptosporidium sp. muskrat 603", "Cryptosporidium sp. muskrat genotype I (W7)", 
                      "Cryptosporidium sp. muskrat genotype II (W16)", "Cryptosporidium sp. oyster 19", 
                      "Cryptosporidium sp. p11", "Cryptosporidium sp. pig genotype II", 
                      "Cryptosporidium sp. shrew genotype (W5)", "Cryptosporidium sp. vole genotype (W15)", 
                      "Cryptosporidium sp. z10", "Cryptosporidium sp. z13", "Cryptosporidium sp. zoo.195", 
                      "Cryptosporidium struthionis", "Cryptosporidium suis", "Cryptosporidium wrairi", 
                      "environmental samples", "unclassified Cryptosporidium", "Giardia lamblia", 
                      "Giardia lamblia ATCC 50803", "unclassified Giardia", "Plasmodium berghei", 
                      "Plasmodium berghei str. ANKA", "Plasmodium chabaudi", "Plasmodium chabaudi adami", 
                      "Plasmodium chabaudi chabaudi", "Plasmodium falciparum", "Plasmodium falciparum 3D7", 
                      "Plasmodium falciparum NF54", "Plasmodium knowlesi", "Plasmodium reichenowi", 
                      "Plasmodium vivax", "Plasmodium yoelii", "Plasmodium yoelii killicki", 
                      "Plasmodium yoelii nigeriensis", "Plasmodium yoelii yoelii", 
                      "unclassified Plasmodium", "Toxoplasma gondii", "Neospora caninum", 
                      "Cryptosporidium andersoni", "Cryptosporidium baileyi", "Cryptosporidium bovis", 
                      "Cryptosporidium canis", "Cryptosporidium cf. molnari", "Cryptosporidium cf. parvum", 
                      "Cryptosporidium environmental sequence", "Cryptosporidium felis", 
                      "Cryptosporidium fragile", "Cryptosporidium galli", "Cryptosporidium hominis", 
                      "Cryptosporidium meleagridis", "Cryptosporidium muris", "Cryptosporidium parvum", 
                      "Cryptosporidium parvum Iowa", "Cryptosporidium saurophilum", 
                      "Cryptosporidium serpentis", "Cryptosporidium sp.", "Cryptosporidium sp. #691", 
                      "Cryptosporidium sp. 0583K", "Cryptosporidium sp. 1040", "Cryptosporidium sp. 1041", 
                      "Cryptosporidium sp. 1170", "Cryptosporidium sp. 118b", "Cryptosporidium sp. 1196", 
                      "Cryptosporidium sp. 1453", "Cryptosporidium sp. 1457", "Cryptosporidium sp. 1665", 
                      "Cryptosporidium sp. 169a", "Cryptosporidium sp. 169c", "Cryptosporidium sp. 17a", 
                      "Cryptosporidium sp. 17b", "Cryptosporidium sp. 200a", "Cryptosporidium sp. 200b", 
                      "Cryptosporidium sp. 2040", "Cryptosporidium sp. 2041", "Cryptosporidium sp. 204a", 
                      "Cryptosporidium sp. 2162", "Cryptosporidium sp. 21a", "Cryptosporidium sp. 21b", 
                      "Cryptosporidium sp. 21g", "Cryptosporidium sp. 2622", "Cryptosporidium sp. 2879", 
                      "Cryptosporidium sp. 2879.VT-2.2003", "Cryptosporidium sp. 2a", 
                      "Cryptosporidium sp. 2b", "Cryptosporidium sp. 30", "Cryptosporidium sp. 3421", 
                      "Cryptosporidium sp. 351", "Cryptosporidium sp. 3568", "Cryptosporidium sp. 3726", 
                      "Cryptosporidium sp. 411", "Cryptosporidium sp. 428", "Cryptosporidium sp. 43c", 
                      "Cryptosporidium sp. 499", "Cryptosporidium sp. 518", "Cryptosporidium sp. 5490", 
                      "Cryptosporidium sp. 5538", "Cryptosporidium sp. 6750", "Cryptosporidium sp. 67a", 
                      "Cryptosporidium sp. 67b", "Cryptosporidium sp. 6876", "Cryptosporidium sp. 6887", 
                      "Cryptosporidium sp. 6898", "Cryptosporidium sp. 715", "Cryptosporidium sp. 750", 
                      "Cryptosporidium sp. 751", "Cryptosporidium sp. 77c", "Cryptosporidium sp. 815", 
                      "Cryptosporidium sp. 886", "Cryptosporidium sp. 888", "Cryptosporidium sp. 90g", 
                      "Cryptosporidium sp. 9111", "Cryptosporidium sp. 938", "Cryptosporidium sp. 944", 
                      "Cryptosporidium sp. 94a", "Cryptosporidium sp. 94b", "Cryptosporidium sp. 9870", 
                      "Cryptosporidium sp. A16", "Cryptosporidium sp. A26", "Cryptosporidium sp. A29", 
                      "Cryptosporidium sp. A7", "Cryptosporidium sp. AHCF-1", "Cryptosporidium sp. AHCF-2", 
                      "Cryptosporidium sp. AHCF-3")

IsolateByHost = 
function(
`specific_host` = 'Mammals - Human', `type` = 'Sequencing Typed,3kChip,Barcode,HD_Array,RFLP Typed', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByHost.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByHost.xml', .convert = NULL, .json = TRUE
)
{
     `specific_host` <- checkValues(`specific_host`, c("Alpaca", "Amphibians", "Antelope", "Bandicoot", "Bears", "Birds", 
                      "Camel", "Cat", "Central Bearded Dragon", "Chicken", "Chipmunk", 
                      "Clam", "Cow", "Coyote", "Deer", "Dog", "Duck", "Elk", "Ferret", 
                      "Finch", "Fox", "Goat", "Goose", "Guinea Pig", "Horse", "Iguana", 
                      "Kangaroo", "Koala", "Lamb", "Leopard Gecko", "Mallard", "Mammals - Human", 
                      "Mammals - Non Human", "Marginated Tortoise", "Marsupial", "Mollusks", 
                      "Monitors", "Monkey", "Mouse", "Muskrat", "Mussel", "Ostrich", 
                      "Other Amphibian", "Other Bird", "Other Mammal", "Oyster", "Pig", 
                      "Possom", "Possum", "Quail", "Rabbit", "Rat", "Reindeer", "Reptiles", 
                      "Rodent", "Seal", "Sheep", "Skunk", "Snakes", "Squirrel", "Tortoise", 
                      "Turkey", "Unknown", "Vole", "Water Buffalo", "Wildebeest", "Woodcock", 
                      "Yak", "Beaver", "Bison", "Chimpanzee", "Dolphin", "Fish", "Gazelle", 
                      "Gull", "Lemur", "Moose", "Shark", "Arthropods", "Mosquito", 
                      "Bear", "Boar", "Buffalo", "Cougar", "Dove", "Jaguar", "Otter", 
                      "Raccoon", "Sparrow", "Toucan"), 'specific_host', TRUE)
     `type` <- checkValues(`type`, c("Sequencing Typed", "3kChip", "Barcode", "HD_Array", "RFLP Typed"
                      ), 'type', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'specific_host' = `specific_host`,
                  'type' = `type`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolateByIsolationSource = 
function(
`isolation_source` = 'Unknown', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByIsolationSource.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByIsolationSource.xml', .convert = NULL, .json = TRUE
)
{
     `isolation_source` <- checkValues(`isolation_source`, c("Unknown", "Feces", "Other Source", "Water", "Blood", "Placenta", 
                      "Brain"), 'isolation_source', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'isolation_source' = `isolation_source`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolateByProduct = 
function(
`product` = '5\'-AMP-activated protein kinase, gamma-1 subunit', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByProduct.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByProduct.xml', .convert = NULL, .json = TRUE
)
{
     `product` <- checkValues(`product`, "`IsolateByProduct.product.options`", 'product', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'product' = `product`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

`IsolateByProduct.product.options` = 
  c("5'-AMP-activated protein kinase, gamma-1 subunit", "5'-methylthioadenosine nucleosidase, S-adenosylhomocysteine nucleosidase", 
                      "6-phosphogluconate dehydrogenase, decarboxylating", "70 kDa peptidylprolyl isomerase, putative", 
                      "A-type flavoprotein lateral transfer candidate", "AAA family ATPase", 
                      "ABC transporter", "ABC transporter ABCA.1, putative", "ABC transporter family protein", 
                      "ABC transporter, ATP-binding protein", "ABC transporter, ATP-binding protein, putative", 
                      "ABC transporter, putative", "ABC-type multidrug transport system, ATPase component", 
                      "ABC-type transport system ATP-binding chain, putative", "ADP-ribosylation factor", 
                      "APC11, cyclin metabolism", "ARF GAP", "ARF2", "ARF3", "ARID1 AT-rich interaction domain", 
                      "ARID2 AT-rich interaction domain", "ARL protein, putative", 
                      "ARL1", "ARL2", "ATP binding protein associated with cell differentiation, putative", 
                      "ATP-binding cassette protein 5", "ATP-binding protein", "ATP-dependent Clp protease ATP-binding subunit ClpB", 
                      "ATP-dependent DNA helicase recQ", "ATP-dependent RNA helicase", 
                      "ATP-dependent RNA helicase A", "ATP-dependent RNA helicase DHR1, putative", 
                      "ATP-dependent RNA helicase HAS1, putative", "ATP-dependent RNA helicase p47, putative", 
                      "ATP-dependent RNA helicase p54, putative", "ATP-dependent RNA helicase-like protein", 
                      "ATP/GTP binding protein, putative", "ATPase", "ATPase of the PP-loop superfamily implicated in cell cycle control, putative", 
                      "ATPase, AAA family", "ATPases of the PP-loop superfamily", "Acetyl-CoA acetyltransferase", 
                      "Acetyl-CoA carboxylase/pyruvate carboxylase fusion protein, putative", 
                      "Acetyl-CoA synthetase", "Acid phosphatase surE", "Acid sphingomyelinase-like phosphodiesterase 3b precursor", 
                      "Acidic ribosomal protein P0", "Actin", "Actin related protein", 
                      "Acyl-CoA synthetase", "Adaptor protein complex large chain subunit BetaA", 
                      "Adenine phosphoribosyltransferase", "Adenylate cyclase", "Adenylate kinase", 
                      "Alanine aminotransferase, putative", "Alanyl dipeptidyl peptidase", 
                      "Alanyl-tRNA synthetase", "Alcohol dehydrogenase", "Alcohol dehydrogenase 3 lateral transfer candidate", 
                      "Alcohol dehydrogenase lateral transfer candidate", "Aldose reductase", 
                      "Alpha adaptin", "Alpha mitochondrial protein peptidase like protein", 
                      "Alpha-1 giardin", "Alpha-10 giardin", "Alpha-11 giardin", "Alpha-12 giardin", 
                      "Alpha-13 giardin", "Alpha-14 giardin", "Alpha-15 giardin", "Alpha-16 giardin", 
                      "Alpha-17 giardin", "Alpha-18 giardin", "Alpha-19 giardin", "Alpha-2 giardin", 
                      "Alpha-3 giardin", "Alpha-4 giardin", "Alpha-5 giardin", "Alpha-6 giardin", 
                      "Alpha-7.1 giardin", "Alpha-7.2 giardin", "Alpha-7.3 giardin", 
                      "Alpha-8 giardin", "Alpha-9 giardin", "Alpha-SNAP, putative", 
                      "Alpha-snap", "Alpha-tubulin", "Amino acid permease, putative", 
                      "Amino acid transporter family", "Amino acid transporter system N2, putative", 
                      "Amino acid transporter, putative", "Aminoacyl-histidine dipeptidase", 
                      "Angio-associated migratory cell protein", "Ankyrin 1", "Ankyrin repeat protein", 
                      "Arginine deiminase", "Arginyl-tRNA synthetase", "Arsenical pump-driving ATPase", 
                      "Asparagine synthase, putative", "Asparaginyl-tRNA synthetase", 
                      "Aspartate aminotransferase, cytoplasmic", "Aspartyl-tRNA synthetase", 
                      "AstB/chuR-related protein", "Aurora kinase", "Axonemal p66.0", 
                      "Axoneme central apparatus protein", "Axoneme-associated protein GASP-180", 
                      "BC2-ORF2", "BC2-ORF3", "BUB3", "Bardet-Biedl syndrome 4 protein-like protein", 
                      "Basal body protein", "Basic, immunoglobulin-like variable motif-containing protein", 
                      "Bet3-like protein", "Bet5-like protein", "Beta adaptin", "Beta tubulin", 
                      "Beta-giardin", "Biglycan precursor", "Bip", "Block of proliferation 1", 
                      "Branched-chain amino acid aminotransferase lateral transfer candidate", 
                      "Brix domain containing protein", "Bystin", "C4 group specific protein", 
                      "CAMP-dependent protein kinase regulatory chain", "CAMP-specific 3',5'-cyclic phosphodiesterase 4B", 
                      "CCAAT-binding transcription factor subunit A", "CCAAT-binding transcription factor subunit C", 
                      "CCAAT-box-binding transcription factor", "CCR4-NOT transcription complex, subunit 7", 
                      "CDC19", "CDC5-like protein", "CDC50", "CDC72", "CDC8", "CDP-diacylglycerol-glycerol-3-phosphate 3-phosphatidyltransferase", 
                      "CDP-diacylglycerol-inositol 3-phosphatidyltransferase", "CEGP1 protein", 
                      "CGI-35 protein, putative", "CHL1-like protein", "CTP synthase", 
                      "CTP synthase/UTP-ammonia lyase", "CXC-rich protein", "Caffeine-induced death protein 1-like protein", 
                      "Calcineurin B subunit", "Calmodulin", "Calmodulin antisense orf", 
                      "Caltractin", "Carbamate kinase", "Casein kinase II beta chain", 
                      "Cathepsin B precursor", "Cathepsin B-like cysteine proteinase 3 precursor", 
                      "Cathepsin L precursor", "Cathepsin L-like protease", "Cation efflux family protein", 
                      "Cation-transporting ATPase 2, putative", "Cell division control protein 48", 
                      "Centrin", "Centromere/microtubule binding protein CBF5", "Ceramide glucosyltransferase", 
                      "Cgi67 serine protease precursor-like protein", "Chaperone protein DnaJ", 
                      "Chaperone protein DnaK HSP70", "Chaperone protein dnaJ", "Chaperonin 60", 
                      "Chorein", "Chromodomain helicase-DNA-binding protein, putative", 
                      "Ciliary dynein heavy chain 11", "Clathrin heavy chain", "Cleavage and polyadenylation specificity factor, 73 kDa subunit", 
                      "Cleavage stimulation factor 50K chain", "ClpB protein", "Clusterin associated protein 1, putative", 
                      "Coatomer alpha subunit", "Coatomer beta subunit", "Coatomer beta' subunit", 
                      "Coatomer delta subunit", "Coatomer gamma subunit", "Coatomer zeta subunit", 
                      "Coiled-coil protein", "Collagen alpha 1 chain precursor", "Copine", 
                      "Copine I", "Copper-transporting P-type ATPase", "Cyclin A", 
                      "Cyclin B-like protein", "Cyclin fold protein 1, putative", "Cyclin-dependent kinases regulatory subunit", 
                      "Cyst wall protein 1", "Cyst wall protein 2", "Cyst wall protein 3", 
                      "Cysteine desulfurase", "Cysteine protease", "Cysteinyl-tRNA synthetase", 
                      "Cytidine deaminase", "Cytochrome B5, outer mitochondrial membrane", 
                      "Cytosine deaminase, putative", "Cytosolic HSP70", "D-tyrosyl-tRNA deacylase", 
                      "D4Ertd196e protein-like protein", "DEAD box RNA helicase Vasa", 
                      "DGTP triphosphohydrolase", "DHHC-type zinc finger domain-containing protein", 
                      "DINP protein human, muc B family", "DNA damage repair protein", 
                      "DNA helicase", "DNA helicase HCS1", "DNA helicase RecQ", "DNA ligase", 
                      "DNA methyltransferase", "DNA pol epsilon, sub B", "DNA pol/primase, large sub", 
                      "DNA pol/primase, small sub", "DNA polymerase alpha subunit A", 
                      "FEN-1 nuclease", "FKBP-type peptidyl-prolyl cis-trans isomerase", 
                      "Farnesyl diphosphate synthase", "Fatty acid elongase 1", "Fe-hydrogenase-1", 
                      "Ferredoxin Fd1, Fd2", "Ferredoxin Fd3", "Fibrillarin-like pre-rRNA processing protein Narcisi et al", 
                      "FixW protein, putative", "Flagella associated protein", "Flap structure-specific endonuclease", 
                      "Flavohemoprotein B5+B5R", "Flavohemoprotein lateral transfer candidate", 
                      "Fructosamine-3-kinase", "Fructose-bisphosphate aldolase", "FtsJ cell division protein, putative", 
                      "FtsJ-like protein", "Furin precursor putative serine protease", 
                      "G beta-like protein GBL", "G1 to S phase transition protein 1, putative", 
                      "G2/mitotic-specific cyclin B", "GA binding protein beta-1 chain", 
                      "GARP-like protein 1", "GARP-like protein 2", "GARP-like protein 3", 
                      "GARP-like protein 4", "GPI-anchor transamidase, putative", "GTL3 aka MD0260", 
                      "GTOR", "GTP-binding nuclear protein RAN/TC4", "GTP-binding protein", 
                      "GTP-binding protein ARD-1, putative", "GTP-binding protein Sar1", 
                      "GTP-binding protein, putative", "Gamma adaptin", "Gamma giardin", 
                      "Gamma tubulin", "Gamma tubulin ring complex", "Giardia trophozoite antigen GTA-1", 
                      "Giardia trophozoite antigen GTA-2", "GlcNAc-PI synthesis protein", 
                      "Glucoamylase S1/S2 precursor", "Glucokinase", "Glucosamine 6-phosphate N-acetyltransferase", 
                      "Glucosamine-6-phosphate deaminase", "Glucosamine-6-phosphate isomerase, putative", 
                      "Glucose 6-phosphate N-acetyltransferase", "Glucose-6-phosphate 1-dehydrogenase", 
                      "Glucose-6-phosphate isomerase", "Glutamate synthase", "Glutamate-cysteine ligase", 
                      "Glutamate-rich WD-repeat protein", "Glutaminyl-tRNA synthetase", 
                      "Glutaredoxin-related protein", "Glutathione synthetase, putative", 
                      "Glyceraldehyde 3-phosphate dehydrogenase", "Glycerol kinase", 
                      "Glycerol-3-phosphate dehydrogenase", "Glycine-, glutamate-, thienylcyclohexylpiperidine-binding protein", 
                      "Glycine-rich protein", "Glycogen phosphorylase", "Glycogen synthase, putative", 
                      "Glycosyltransferase family 28", "Glycyl-tRNA synthetase", "Gmyb11", 
                      "Golgi/cell cycle associated protein, putative", "Gp49, putative", 
                      "Grp94/Hsp90", "Guanine phosphoribosyltransferase", "Guanylate kinase", 
                      "H-SHIPPO 1", "HAM1 protein", "HIT family protein", "HRT1-like protein", 
                      "HSP70 subfamily B suppressor 1", "HZGJ", "Haloacid dehalogenase-like hydrolase family", 
                      "Heat shock 70kD protein binding protein", "Heat shock protein 70", 
                      "Heat shock protein HSP 90-alpha", "Heat-shock protein, putative", 
                      "Helicase", "Helicase-related protein", "Hemoglobin and proliferation regulated protein", 
                      "HesB domain-containing protein", "Hexose transporter", "High cysteine membrane protein EGF-like", 
                      "High cysteine membrane protein Group 1", "High cysteine membrane protein Group 2", 
                      "High cysteine membrane protein Group 3", "High cysteine membrane protein Group 4", 
                      "High cysteine membrane protein Group 5", "High cysteine membrane protein Group 6", 
                      "High cysteine membrane protein TMK-like", "High cysteine membrane protein VSP-like", 
                      "High cysteine non-variant cyst protein", "High cysteine protein", 
                      "Histidinol-phosphatase, putative", "Histidyl-tRNA synthetase", 
                      "Histone H2A", "Histone H2B", "Histone H3", "Histone H4", "Histone acetyltransferase Elp3", 
                      "Histone acetyltransferase GCN5", "Histone acetyltransferase MYST2", 
                      "DNA polymerase delta, catalytic subunit", "DNA polymerase epsilon, catalytic subunit", 
                      "DNA polymerase, putative", "DNA repair and recombination protein Rhp26p", 
                      "DNA repair helicase TFIIH P90", "DNA repair protein RAD51", 
                      "DNA repair protein RAD52", "DNA topoisomerase III", "DNA-damage inducible protein DDI1-like", 
                      "DNA-dependent ATPase, putative", "DNA-directed RNA polymerase I 13.1 kDa polypeptide", 
                      "DNA-directed RNA polymerase II RPB6", "DNA-directed RNA polymerase II largest subunit RPB1", 
                      "DNA-directed RNA polymerase III subunit 22.9 kDa polypeptide", 
                      "DNA-directed RNA polymerase RPB10", "DNA-directed RNA polymerase RPB2", 
                      "DNA-directed RNA polymerase RPB3", "DNA-directed RNA polymerase subunit A'", 
                      "DNA-directed RNA polymerase subunit B", "DNA-directed RNA polymerase subunit B'", 
                      "DNA-directed RNA polymerase subunit D", "DNA-directed RNA polymerases I and III 16 kDa polypeptide", 
                      "DRAP deaminase", "DRE4 protein", "DRL1 protein", "DUB-1", "Degreening related gene dee76 protein", 
                      "Delta giardin", "Delta tubulin", "Deoxyguanosine kinase/deoxyadenosine kinase subunit, putative", 
                      "Deoxyhypusine synthase, putative", "Deoxynucleoside kinase", 
                      "Deoxyribonuclease, TatD family", "Deoxyribose-phosphate aldolase lateral transfer candidate", 
                      "Dephospho-CoA kinase", "Derlin-like protein", "Developmentally regulated GTP-binding protein 1", 
                      "Dicer", "Dihydrouridine synthase, putative", "Dimethyladenosine transferase", 
                      "DinF protein", "Dipeptidyl-peptidase I precursor", "Dipeptidyl-peptidase III", 
                      "Diphosphomevalonate decarboxylase", "Diphthine synthase", "Dmc1b", 
                      "Dolichol-phosphate mannosyltransferase, putative", "Dual specificity phosphatase Cdc25, putative", 
                      "Dual specificity phosphatase, catalytic", "Dual specificity protein phosphatase 12", 
                      "Dual specificity protein phosphatase CDC14A", "Dual-specificity protein phosphatase", 
                      "Dynamin", "Dynein binding protein, putative", "Dynein heavy chain", 
                      "Dynein heavy chain like", "Dynein heavy chain, putative", "Dynein intermediate chain", 
                      "Dynein light chain", "Dynein light intermediate chain", "Dynein regulatory complex", 
                      "Dynein-like protein", "E04F6.2 like protein", "E3 ubiquitin ligase for Rad6p required for the ubiquitination of histone H2B", 
                      "EB1", "EH domain binding protein epsin 2", "ELKS", "ENC6 protein", 
                      "ER lumen protein retaining receptor", "ERP1", "ERP2", "ERP3", 
                      "Elongation factor 1-alpha", "Elongation factor 1-gamma", "Elongation factor 2", 
                      "Elongation initiation factor 5C", "Embryo-related protein", 
                      "Encystation-specific protease", "Encystation-specific secretory granule protein-1", 
                      "Endonuclease III", "Endonuclease/Exonuclease/phosphatase", "Endothelin-converting enzyme 2", 
                      "Enolase", "Epsilon tubulin", "Ethanolamine kinase, putative", 
                      "Eukaryotic initiation factor 4A", "Eukaryotic peptide chain release factor subunit 1", 
                      "Eukaryotic translation initiation factor 1A", "Eukaryotic translation initiation factor 2 alpha subunit", 
                      "Eukaryotic translation initiation factor 2 beta subunit", "Eukaryotic translation initiation factor 3 subunit 2", 
                      "Eukaryotic translation initiation factor 5", "Eukaryotic translation initiation factor 5A", 
                      "Exonuclease", "Exonuclease 1", "Exosome complex exonuclease, putative", 
                      "Extracellular nuclease, putative", "FAD synthetase", "18S small subunit ribosomal RNA", 
                      "26S ribosomal RNA", "5.8S rRNA | ITS1 | 18S rRNA", "56 kDa transmembrane protein", 
                      "A135 protein; CpCCp1/Cpa135", "AOX1;alternative oxidase; possible fungal or bacterial origin; 2 transmembrane regions", 
                      "ATP-binding cassette protein", "DNA topoisomerase II", "DNAJ-like protein", 
                      "Dbp9p; eIF4A-1-family RNA SFII helicase; DEXDc+HELICc", "Gal/GalNAc binding lectin", 
                      "Hsp60", "MIF4G", "NifU-related protein", "P-type ATpase3 cation transport ATpase; signal peptide", 
                      "RNA-dependent RNA polymerase", "TTA repeat", "Unknown", "WD repeat protein", 
                      "acetyl-coenzyme A synthetase", "actin", "alternative oxidase", 
                      "calcium/calmodulin dependent protein kinase with a kinase domain and 4 calmodulin like EF hands", 
                      "capsid protein", "cdc2-like protein kinase", "dihydrofolate reductase-thymidylate synthase;DHFR-TS", 
                      "elongation factor 1-alpha", "glycerophosphodiester phosphodiesterase-like protein", 
                      "gp40/gp15; gp60", "heat shock 70 (HSP70) protein", "hydroxyproline-rich glycoprotein", 
                      "hypothetical protein", "immunodominant antigen Cp23", "immunodominant protein CpGP34 precursor", 
                      "internal transcribed spacer", "lactate dehydrogenase; adjacent gene encodes predicted malate dehydrogenase", 
                      "large low complexity protein", "large low complexity protein with signal peptide; within large locus of signal peptide containing...", 
                      "malate dehydrogenase; adjacent gene encodes predicted lactate dehydrogenase", 
                      "microsatellite ML2 type ML2-176", "mucins", "multiprotein bridging factor type 1 like transcriptional co-activator", 
                      "oocyst wall protein", "polythreonine protein", "pyruvate;ferredoxin oxidoreductase/NADPH-cytochrome P450 reductase PNO", 
                      "retinitis pigmentosa GTPase regulator", "ribonucleotide reductase R2 subunit", 
                      "serine repeat antigen", "similar to hydroxyproline-rich glycoprotein", 
                      "sporozoite cysteine-rich protein; possible", "sporozoite surface antigen P23", 
                      "superoxide dismutase", "tRNA/rRNA methyltransferase-like protein; putative", 
                      "telomeric repeat", "thioredoxin peroxidase-like protein", "thrombospondin domain containing protein", 
                      "translation initiation factor", "tubulin", "zinc protease; possible", 
                      "1,4-alpha-glucan branching enzyme", "14-3-3 protein", "18S ribosomal RNA", 
                      "2,3-bisphosphoglycerate-independent phosphoglycerate mutase", 
                      "20S proteasome alpha subunit 1", "20S proteasome alpha subunit 2", 
                      "20S proteasome alpha subunit 3", "20S proteasome alpha subunit 4", 
                      "20S proteasome alpha subunit 5", "20S proteasome alpha subunit 6", 
                      "20S proteasome alpha subunit 7", "26S protease regulatory subunit 6A", 
                      "26S protease regulatory subunit 6B", "26S protease regulatory subunit 7", 
                      "26S protease regulatory subunit 8", "26S proteasome ATPase subunit S4, putative", 
                      "26S proteasome non-ATPase regulatory subunit 2", "26S proteasome non-ATPase regulatory subunit 6", 
                      "26S proteasome non-ATPase regulatory subunit 7", "26S proteasome regulatory subunit, putative", 
                      "3' exoribonuclease, putative", "3-hydroxy-3-methylglutaryl-coenzyme A reductase", 
                      "4-alpha-glucanotransferase", "4-alpha-glucanotransferase, amylo-alpha-1,6-glucosidase", 
                      "4-methyl-5-thiazole monophosphate biosynthesis enzyme", "5' nucleotidase family protein", 
                      "5'-3' deoxyribonucleotidase, putative", "5'-3' exoribonuclease 2", 
                      "5'-AMP-activated protein kinase, beta-1 subunit", "Trichohyalin", 
                      "Triosephosphate isomerase, cytosolic", "Tryptophanyl-tRNA synthetase", 
                      "Tubby superfamily protein", "Tubulin specific chaperone B", 
                      "Tubulin specific chaperone D", "Tubulin specific chaperone E", 
                      "Tubulin tyrosine ligase", "Tubulin, small gamma tubulin complex gcp2", 
                      "Type II inositol-1,4,5-trisphosphate 5-phosphatase precursor", 
                      "Tyrosyl-tRNA synthetase", "U2 small nuclear ribonucleoprotein A' putative", 
                      "U2 small nuclear ribonucleoprotein A', putative", "U2 small nuclear ribonucleoprotein B, putative", 
                      "U3 small nucleolar RNA interacting protein, putative", "U3 small nucleolar RNA-associated protein 11, putative", 
                      "U3 small nucleolar ribonucleoprotein protein IMP3, putative", 
                      "U3 small nucleolar ribonucleoprotein protein IMP4, putative", 
                      "U3 small nucleolar ribonucleoprotein protein MPP10, putative", 
                      "U5 small nuclear ribonucleoprotein 200 kDa helicase, putative", 
                      "U6 snRNA-associated Sm-like protein LSm2, putative", "U6 snRNA-associated Sm-like protein LSm3, putative", 
                      "UBC2, putative", "UBC3", "UBCE14", "UDP-N-acetylglucosamine pyrophosphorylase", 
                      "UDP-N-acetylglucosamine-dolichyl-phosphateN-acetylglucosaminephosphotransferase", 
                      "UDP-glucose 4-epimerase", "UPL-1", "UTP-glucose-1-phosphate uridylyltransferase", 
                      "Ubiquitin", "Ubiquitin carboxyl-terminal hydrolase 14", "Ubiquitin carboxyl-terminal hydrolase 4", 
                      "Ubiquitin fusion degradation protein 1", "Ubiquitin protein, putative", 
                      "Ubiquitin-activating enzyme E1 1", "Ubiquitin-conjugating enzyme E1", 
                      "Ubiquitin-conjugating enzyme E2-17 kDa", "Ubiquitin-conjugating enzyme E2-17 kDa 3", 
                      "Ubiquitin-conjugating enzyme E2-21.2 kDa", "Ubiquitin-conjugating enzyme E2-28.4 kDa", 
                      "Ubiquitin-protein ligase E3A", "Ubiquitin/ribosomal protein CEP52", 
                      "Undecaprenyl pyrophosphate synthase", "Uracil phosphoribosyltransferase", 
                      "Uridine kinase", "UsoAp", "V-SNARE", "VATPase", "VSP", "VSP AS12", 
                      "VSP AS8", "VSP S8", "VSP with INR", "VSP, putative", "Vacuolar ATP synthase 16 kDa proteolipid subunit", 
                      "Vacuolar ATP synthase catalytic subunit A", "Vacuolar ATP synthase subunit B", 
                      "Vacuolar ATP synthase subunit C", "Vacuolar ATP synthase subunit D", 
                      "Vacuolar ATP synthase subunit H", "Vacuolar ATP synthase subunit d", 
                      "Vacuolar protein sorting 11", "Vacuolar protein sorting 26, putative", 
                      "Vacuolar protein sorting 29", "Vacuolar protein sorting 35", 
                      "Vacuolar proton-ATPase subunit, putative", "Valine-tRNA ligase", 
                      "Variant-specific surface protein", "Variant-specific surface protein VSP4A1 precursor", 
                      "WD-40 repeat protein", "WD-40 repeat protein family", "WD-containing protein", 
                      "WD-repeat domain 17 isoform 1", "WD-repeat membrane protein", 
                      "WD-repeat membrane protein, putative", "WD-repeat protein", 
                      "WD-repeat protein 5", "WD-repeat protein BING4", "WRKY transcription factor 4, putative", 
                      "Wos2 protein", "Xaa-Pro dipeptidase", "Xenotropic and polytropic murine leukemia virus receptor", 
                      "Yip", "Yip interacting protein, putative", "Yip paralog", "ZPR1", 
                      "Zinc finger domain", "Zinc finger protein", "Zinc finger protein, putative", 
                      "Zinc transporter domain", "ZipA", "[2Fe-2S] ferredoxin", "hemagglutinin protein-like protein", 
                      "mRNA capping enzyme alpha subunit", "tRNA 2-methylthioadenosine synthase", 
                      "tRNA delta2-isopentenylpyrophosphate transferase", "tRNA dihydrouridine synthase, putative", 
                      "tRNA intron endonuclease, putative", "tRNA methyltransferase subunit, putative", 
                      "tRNA-Gln", "tRNA-nucleotidyltransferase, putative", "tRNA-ribosyltransferase, putative", 
                      "tRNA/rRNA cytosine-C5-methylase", "tumor suppressor protein-like protein", 
                      "1-deoxy-D-xylulose 5-phosphate reductoisomerase", "10b antigen, putative", 
                      "14-3-3 protein, putative", "18s rRNA A-type", "235 kDa rhoptry protein", 
                      "25 kDa ookinete surface antigen precursor (pfs25)", "28 kDa ookinete surface protein", 
                      "28 kDa ookinete surface protein, putative", "3'-5' exonuclease domain containing protein", 
                      "3-oxoacyl-[acyl-carrier-protein] synthase i/ii, putative", "40S ribosomal protein S8e, putative", 
                      "41-2 protein antigen precursor", "5'-3' exoribonuclease, putative", 
                      "6-phosphofructokinase", "60S Acidic ribosomal protein P2", "60S ribosomal protein L34-A, putative", 
                      "60S ribosomal protein L35, putative", "ABC transporter(CT family), PfMRP", 
                      "ABC transporter, (CT family)", "ADP-ribosylation factor-like protein", 
                      "ATP-dependent Clp protease subunit, putative", "ATP-dependent RNA helicase, putative", 
                      "Adenylate and Guanylate cyclase catalytic domain containing protein", 
                      "BIR protein", "C-13 antigen", "CAF1 family ribonuclease, putative", 
                      "CCAAT-binding transcription factor, putative", "CPSF (cleavage and polyadenylation specific factor), subunit A, putative", 
                      "CSP and TRAP-related protein (CTRP)", "CW-type zinc finger domain-containing protein", 
                      "Cell division control protein 2 homolog", "Cg1 protein", "Cg2 protein", 
                      "Cytochrome b, putative", "DEAD/DEAH box ATP-dependent RNA helicase, putative", 
                      "DNA GyrAse a-subunit, putative", "DNA helicase, putative", "DNA polymerase alpha", 
                      "DNA polymerase alpha, putative", "DNA polymerase delta catalytic subunit", 
                      "DNA polymerase delta catalytic subunit, putative", "DNA-directed RNA polymerase II 13.3 kDa polypeptide, putative", 
                      "DNA-directed RNA polymerase II largest subunit, putative", "DNA-directed RNA polymerase II, putative", 
                      "Duffy receptor precursor", "Elongation factor 1 alpha, putative", 
                      "Erythrocyte membrane protein, putative", "F-actin capping protein, alpha subunit, putative", 
                      "Fe-superoxide dismutase", "Fructose-bisphosphate aldolase class-I", 
                      "GTP-binding nuclear protein, putative", "Gbph2", "HVA22/TB2/DP1 family protein, putative", 
                      "Heat shock protein", "L-lactate dehydrogenase", "Liver stage antigen 3 precursor, putative", 
                      "MAEBL, putative", "MO15-related protein kinase Pfmrk", "MSP4/5", 
                      "MSP7-like protein", "MSP8-like protein", "Mature parasite-infected erythrocyte surface antigen (MESA) o", 
                      "Mature parasite-infected erythrocyte surface antigen (MESA) or PfEMP2", 
                      "Merozoite Surface Protein 7 precursor, MSP7", "Merozoite Surface Protein 8, MSP8", 
                      "Merozoite surface protein 10, MSP10", "Merozoite surface protein 3, putative", 
                      "Myb1 protein", "PBS lyase HEAT-like repeat domain protein", 
                      "PF70 protein", "PFG377 protein", "POM1, putative", "Peptidase family C50, putative", 
                      "Pf 11-1 protein", "PfEMP1", "PfRab1a", "PfRhop148,Rhoptry protein", 
                      "Phist protein (Pf-fam-b)", "Plasmodium falciparum membrane protein pf12 precursor", 
                      "Plasmodium falciparum reticulocyte binding protein 2, homolog b", 
                      "Plasmodium falciparum trophozoite antigen r45-like protein", 
                      "Protein phosphatase 2C, putative", "Histone acetyltransferase type B subunit 2", 
                      "Histone deacetylase", "Histone methyltransferase HMT1", "Histone methyltransferase HMT2", 
                      "Histone methyltransferase MYST1", "Hop1", "HpaII tiny fragments locus 9c", 
                      "Hybrid cluster protein lateral transfer candidate", "Hydrolase, haloacid dehalogenase-like family", 
                      "Hydrolase, putative", "Hydroxyacylglutathione hydrolase", "Hydroxymethylglutaryl-CoA synthase", 
                      "Hypothetical 59.1 kDa protein in RPOA3 5 prime region", "IFT complex A", 
                      "IFT complex B", "Impact-like protein", "Importin beta-3 subunit", 
                      "Inorganic polyphosphate/ATP-NAD kinase, putative", "Inositol 5-phosphatase 4", 
                      "Inositol hexakisphosphate kinase", "Inositol-3-phosphate synthase", 
                      "Intracellular protein transport protein USO1", "Intraflagellar transport particle protein IFT88", 
                      "Intraflagellar transport protein component IFT74/72", "Isoleucyl-tRNA synthetase", 
                      "Isopentenyl-diphosphate delta-isomerase 1", "Isoprenylcysteine carboxyl methyltransferase", 
                      "KRR1", "Katanin", "Kelch repeat-containing protein", "Kinase", 
                      "Kinase, AGC AKT", "Kinase, AGC MAST", "Kinase, AGC NDR", "Kinase, AGC PKA", 
                      "Kinase, CAMK CAMK1", "Kinase, CAMK CAMKL", "Kinase, CAMK unique", 
                      "Kinase, CAMKK", "Kinase, CDC7", "Kinase, CK1 Casein kinase", 
                      "Kinase, CMGC CDK", "Kinase, CMGC CDKL", "Kinase, CMGC CK2", 
                      "Kinase, CMGC CLK", "Kinase, CMGC CMGC-GL1", "Kinase, CMGC DYRK", 
                      "Kinase, CMGC GSK", "Kinase, CMGC MAPK", "Kinase, CMGC RCK", 
                      "Kinase, CMGC SRPK", "Kinase, NAK", "Kinase, NEK", "Kinase, NEK-GL-like", 
                      "Kinase, NEK-frag", "Kinase, NEK-like", "Kinase, Nek-like", "Kinase, PEK", 
                      "Kinase, PLK", "Kinase, SCY1", "Kinase, STE Dicty2", "Kinase, STE STE11", 
                      "Kinase, STE STE20", "Kinase, TTK", "Kinase, ULK", "Kinase, Uni1", 
                      "Kinase, VPS15", "Kinase, Wee", "Kinase, Wnk", "Kinase, putative", 
                      "Kinesin like protein", "Kinesin-1", "Kinesin-13", "Kinesin-14", 
                      "Kinesin-16", "Kinesin-2", "Kinesin-3", "Kinesin-4", "Kinesin-5", 
                      "Kinesin-6", "Kinesin-6 like", "Kinesin-7", "Kinesin-8", "Kinesin-9", 
                      "Kinesin-associated protein", "Kinesin-like protein", "Kinesin-related protein", 
                      "L-asparaginase", "L-serine dehydratase", "LEK1", "La ribonucleoprotein, putative", 
                      "Lecithin-cholesterol acyl transferase, putative", "Leucine carboxyl methyltransferase", 
                      "Leucine-rich repeat protein", "Leucine-rich repeat protein 1 virus receptor protein", 
                      "Leucyl-tRNA synthetase", "Lipopolysaccharide-responsive and beige-like anchor protein", 
                      "Liver stage antigen-like protein", "Long chain fatty acid CoA ligase 4", 
                      "Long chain fatty acid CoA ligase 5", "Long chain fatty acid CoA ligase, putative", 
                      "Long-flagella protein, kinase, CMGC RCK", "Low molecular weight protein-tyrosine-phosphatase", 
                      "Lysophosphatidic acid acyltransferase, putative", "Lysophosphatidic acid phosphatase", 
                      "Lysosomal acid phosphatase precursor", "Lysyl-tRNA synthetase", 
                      "MCM2", "MCM3", "MCM4", "MCM5", "MCM6", "MCM7", "MCT-1 protein-like protein", 
                      "MDR protein-like protein", "MDR-type permease", "MRP-like ABC transporter", 
                      "MYG1 protein", "Macrophage migration inhibitory factor", "Maebl, putative", 
                      "Maf-like protein yhdE", "Major facilitator family transporter", 
                      "Malate dehydrogenase", "Malic enzyme", "Manganese-dependent inorganic pyrophosphatase, putative", 
                      "Mannose-1-phosphate guanyltransferase", "Mannosyltransferase", 
                      "Mechanosensory abnormality MEC-17-like protein", "Median body protein", 
                      "Membrane protein", "Membrane protein, putative", "Met-10+ protein", 
                      "Metal-dependent hydrolase", "Metal-dependent hydrolase related to alanyl-tRNA synthetase", 
                      "Metal-dependent phosphoesterases, putative", "Metallo-beta-lactamase superfamily protein", 
                      "Metalloprotease, insulinase family", "Methionine aminopeptidase", 
                      "Methionyl-tRNA synthetase", "Methyltransferase like 2", "Methyltransferase, putative", 
                      "Mevalonate kinase", "Microsomal signal peptidase 18 kDa subunit", 
                      "Midasin", "Minor histocompatibility antigen H13", "Mismatch repair protein", 
                      "Mitogen-activated protein kinase kinase kinase 1", "Mitotic control protein dis3", 
                      "Mitotic spindle checkpoint protein MAD2", "Mlh1-like protein", 
                      "Mlh2-like protein", "Mnd1", "Mob1-like protein", "Molybdenum cofactor sulfurase", 
                      "Molybdopterin biosynthesis MoeB protein", "Mre11", "Mre11, putative", 
                      "Msh2-like protein", "Mu adaptin", "Mucin-like protein", "Multidrug resistance ABC transporter ATP-binding and permease protein", 
                      "Multidrug resistance protein B", "Multidrug resistance-associated protein 1", 
                      "Multidrug resistance-associated protein Mrp2", "MutT/nudix family protein", 
                      "Myb 1-like protein", "N-acetyltransferase-like protein", "N-terminal acetyltransferase complex ARD1 subunit, putative", 
                      "N2,N2-dimethylguanosine tRNA methyltransferase, putative", "NAD-dependent histone deacetylase Sir2", 
                      "NADH oxidase", "NADH oxidase lateral transfer candidate", "NADP-specific glutamate dehydrogenase", 
                      "NADPH oxidoreductase, putative", "NH3-dependent NAD+ synthetase", 
                      "NOD3 protein, putative", "NSF", "NYD-SP28 protein", "Na+ driven multidrug efflux pump", 
                      "Neurogenic locus Notch protein precursor", "Neurogenic locus notch-like protein", 
                      "Nicotinamide-nucleotide adenylyltransferase", "Nicotinate phosphoribosyltransferase", 
                      "Nif3-related protein", "NifU-like protein", "Nin one binding protein-like protein", 
                      "Nitric oxide synthase, inducible", "Nitroreductase Fd-NR2", 
                      "Nitroreductase family protein", "Nitroreductase family protein fused to ferredoxin domain Fd-NR1", 
                      "Non ATPase subunit MPR1 of 26S proteasome", "Nonsense-mediated mRNA decay protein 3", 
                      "Notch 2, putative", "Notchless", "Nuclear ATP/GTP-binding protein", 
                      "Nuclear LIM interactor-interacting factor 1", "Nucleolar GAR1-like protein, putative", 
                      "Nucleolar GTP-binding protein 1, putative", "Nucleolar GTP-binding protein 2", 
                      "Nucleolar GTPase", "Nucleolar protein NOP2", "Nucleolar protein NOP5", 
                      "Nucleolar protein family A, member 2", "Nucleoside diphosphate kinase", 
                      "Nucleoside-diphosphate-sugar epimerases", "Nucleotide-binding head-stalk protein, putative", 
                      "Nucleotide-binding protein 1", "O-linked GlcNAc transferase", 
                      "O-sialoglycoprotein endopeptidase", "Orc1/CDC6", "Orc4", "Ornithine carbamoyltransferase", 
                      "Ornithine cyclodeaminase", "Ornithine decarboxylase", "Oxidoreductase, short chain dehydrogenase/reductase family", 
                      "P115, putative", "P24, putative", "P60 katanin", "PHD finger protein 15", 
                      "PRIP-interacting protein PIPMT", "Pantothenate kinase 4", "Partner of Nob1", 
                      "PcnA", "Pelo protein", "Peptide methionine sulfoxide reductase msrA", 
                      "Peptide methionine sulfoxide reductase msrB", "Peptidyl-prolyl cis-trans isomerase B precursor", 
                      "Peptidyl-tRNA hydrolase", "Periodic tryptophan protein 1, putative", 
                      "Periodic tryptophan protein 2-like protein", "Peroxiredoxin 1", 
                      "Peter pan protein", "Phenylalanyl-tRNA synthetase alpha chain", 
                      "Phenylalanyl-tRNA synthetase beta chain", "Phosphatase", "Phosphatase 1 regulatory subunit, putative", 
                      "Phosphatase similar to the C-terminal domain of histone macroH2A1", 
                      "Phosphatase subunit gene g4-1", "Phosphatase, putative", "Phosphatidate cytidylyltransferase", 
                      "Phosphatidyl synthase", "Phosphatidylinositol 4-kinase", "Phosphatidylinositol transfer protein alpha isoform", 
                      "Phosphatidylinositol-3,4,5-trisphosphate 3-phosphatase", "Phosphatidylinositol-4-phosphate 5-kinase, putative", 
                      "Phosphatidylinositol-glycan biosynthesis, class O protein", 
                      "Phosphatidylserine decarboxylase proenzyme", "Phosphoacetylglucosamine mutase", 
                      "Phosphoenolpyruvate carboxykinase", "Phosphoglycerate kinase", 
                      "Phosphoglycolate phosphatase", "Phosphoinositide-3-kinase, catalytic, alpha polypeptide", 
                      "Phosphoinositide-3-kinase, class 3", "Phospholipase B", "Phospholipid-transporting ATPase IA, putative", 
                      "Phospholipid-transporting ATPase IIB, putative", "Phosphomannomutase-2", 
                      "Phosphoprotein phosphatase 2A regulatory subunit", "Phosphorylase B kinase gamma catalytic chain", 
                      "Phosphorylated CTD interacting factor PCIF1", "Phosphotyrosyl phosphatase activator protein, putative", 
                      "Piwi-protein, putative", "Plant adhesion molecule 1", "Plasma membrane calcium-transporting ATPase 2", 
                      "Pms1-like protein", "Polyadenylate-binding protein, putative", 
                      "Potassium-transporting ATPase alpha chain 1", "Prefoldin subunit 2", 
                      "Prefoldin subunit 3, putative", "Preimplantation protein 3", 
                      "Prenylated synaptobrevin/VAMP, putative", "Prenyltransferase", 
                      "Programmed cell death protein-like protein", "Prolyl-tRNA synthetase", 
                      "Proprotein convertase subtilisin/kexin type 5 precursor", "Prostate cancer susceptibility protein-like protein", 
                      "Proteasome subunit beta type 1", "Proteasome subunit beta type 2", 
                      "Proteasome subunit beta type 3", "Proteasome subunit beta type 4 precursor", 
                      "Proteasome subunit beta type 5 precursor", "Proteasome subunit beta type 7 precursor", 
                      "Proteasome subunit beta type 9 precursor", "Protein 21.1", "Protein 21.1, putative", 
                      "Protein 21.4", "Protein 21.6", "Protein BAP28", "Protein C21orf2", 
                      "Protein F10G7.1", "Protein F17L21.10", "Protein F54C1.5", "Protein LRP16", 
                      "Protein disulfide isomerase PDI1", "Protein disulfide isomerase PDI2", 
                      "Protein disulfide isomerase PDI3", "Protein disulfide isomerase PDI4", 
                      "Protein disulfide isomerase PDI5", "Protein kinase", "Protein kinase gPK1", 
                      "Protein kinase, putative", "Protein phosphatase 2A B' regulatory subunit Wdb1", 
                      "Protein phosphatase 2A regulatory subunit, putative", "Protein phosphatase 2C", 
                      "Protein phosphatase 2C-like protein", "Protein phosphatase PP2A regulatory subunit A", 
                      "Protein phosphatase PP2A regulatory subunit B", "Protein phosphatase methylesterase-1", 
                      "Protein phosphatases PP1 regulatory subunit SDS22", "Protein required for cell viability", 
                      "Protein required for cell viability, possible role in assembly of the ribosome", 
                      "Protein transport protein Sec7", "Protein tyrosine phosphatase", 
                      "Protein tyrosine phosphatase-like protein", "Pseudouridine synthase, putative", 
                      "Pseudouridylate synthase 1", "Pseudouridylate synthase, putative", 
                      "Pseudouridylates U2 snRNA at position 35", "Pumilio-family RNA-binding protein, putative", 
                      "Purine nucleoside phosphorylase lateral transfer candidate", 
                      "Purine permease-related protein", "Putative serine/threonine-protein kinase", 
                      "Pyrazinamidase/nicotinamidase", "Pyridoxamine 5-phosphate oxidase, putative", 
                      "Pyrophosphate-fructose 6-phosphate 1-phosphotransferase alpha subunit", 
                      "Pyruvate kinase", "Pyruvate, phosphate dikinase", "Pyruvate-flavodoxin oxidoreductase", 
                      "Pyruvate-formate lyase-activating enzyme lateral transfer candidate", 
                      "RAD50 DNA repair protein, putative", "RAN binding protein 1", 
                      "RAS-related", "RER1-like protein-retention of ER proteins", 
                      "RIO1-like protein", "RNA 3'-terminal phosphate cyclase-like protein", 
                      "RNA binding protein", "RNA binding protein, putative", "RNA binding putative", 
                      "RNA helicase", "RNA helicase, putative", "RNA methylase, putative", 
                      "RNA polymerase AI large subunit", "RNA polymerase I subunit A43", 
                      "RNA polymerase II subunit Rpb11", "RNA polymerase II subunit Rpb12", 
                      "RNA polymerase II subunit Rpb5a", "RNA polymerase II subunit Rpb5b", 
                      "RNA polymerase II subunit Rpb8", "RNA polymerase III subunit C11", 
                      "RNA polymerase III subunit C34", "RNA-dependent helicase p68, putative", 
                      "RNA-directed RNA polymerase, putative", "RNase L inhibitor", 
                      "RNase P RNA component", "RRNA biogenesis protein RRP5", "RTCB PROTEIN", 
                      "Rab GDI", "Rab geranylgeranyltransferase", "Rab11", "Rab1a", 
                      "Rab2a", "Rab2b", "Rab32, putative", "RabA", "RabB", "RabF", 
                      "Rac/Rho-like protein", "Radial-spoke protein", "Reductase, putative", 
                      "Regulator of nonsense transcripts 1-like protein", "Replication factor C, sub 2", 
                      "Replication factor C, subunit 1", "Replication factor C, subunit 3", 
                      "Replication factor C, subunit 4", "Replication factor C, subunit 5", 
                      "Retinoic acid induced 17-like protein", "Reverse transcriptase/endonuclease", 
                      "Reverse transcriptase/endonuclease, putative", "Rho GAP, putative", 
                      "Rho GDI", "Riboflavin kinase, FMN adenylyltransferase", "Ribokinase", 
                      "Ribonuclease", "Ribonuclease H", "Ribonuclease HI, large sub", 
                      "Ribonuclease P protein subunit, putative", "Ribonuclease, putative", 
                      "Ribose 5-phosphate isomerase", "Ribose-phosphate pyrophosphokinase", 
                      "Ribosomal large subunit pseudouridine synthase D", "Ribosomal polymerase II subunit RPB7", 
                      "Ribosomal protein L10", "Ribosomal protein L10a", "Ribosomal protein L11", 
                      "Ribosomal protein L12", "Ribosomal protein L13", "Ribosomal protein L13a", 
                      "Ribosomal protein L14", "Ribosomal protein L15", "Ribosomal protein L17", 
                      "Ribosomal protein L18", "Ribosomal protein L18a", "Ribosomal protein L19", 
                      "Ribosomal protein L2", "Ribosomal protein L21", "Ribosomal protein L23", 
                      "Ribosomal protein L23A", "Ribosomal protein L24", "Ribosomal protein L24A", 
                      "Ribosomal protein L26", "Ribosomal protein L27", "Ribosomal protein L27a", 
                      "Ribosomal protein L3", "Ribosomal protein L30", "Ribosomal protein L31B", 
                      "Ribosomal protein L32", "Ribosomal protein L34", "Ribosomal protein L35", 
                      "Ribosomal protein L35a", "Ribosomal protein L36-1", "Ribosomal protein L37", 
                      "Ribosomal protein L37a", "Ribosomal protein L4", "Ribosomal protein L44", 
                      "Ribosomal protein L5", "Ribosomal protein L7", "Ribosomal protein L7Ae", 
                      "Ribosomal protein L7a", "Ribosomal protein L9", "Ribosomal protein P1B", 
                      "Ribosomal protein S10B", "Ribosomal protein S11", "Ribosomal protein S12", 
                      "Ribosomal protein S13", "Ribosomal protein S14", "Ribosomal protein S15", 
                      "Ribosomal protein S15A", "Ribosomal protein S16", "Ribosomal protein S17", 
                      "Ribosomal protein S18", "Ribosomal protein S2", "Ribosomal protein S20", 
                      "Ribosomal protein S21", "Ribosomal protein S23", "Ribosomal protein S24", 
                      "Ribosomal protein S26", "Ribosomal protein S27", "Ribosomal protein S28", 
                      "Ribosomal protein S29A", "Ribosomal protein S3", "Ribosomal protein S3a", 
                      "Ribosomal protein S4", "Ribosomal protein S5", "Ribosomal protein S6", 
                      "Ribosomal protein S7", "Ribosomal protein S8", "Ribosomal protein S9", 
                      "Ribosomal protein SA", "Ribosome biogenesis protein BMS1", "Ribosome biogenesis protein Brix", 
                      "Ribosome biogenesis protein NEP1, putative", "Ribosome biogenesis protein Nop10", 
                      "Ribosome subunit biogenesis protein NIP7", "Ribulose-phosphate 3-epimerase", 
                      "Ripening regulated protein DDTFR19", "Rrm3p helicase", "S-adenosylmethionine synthetase", 
                      "S-adenosylmethionine-dependent methyltransferase, putative", 
                      "SALP-1", "SKD1 protein", "SMC1 beta-like protein", "SMC3-like protein", 
                      "SMC4-like protein", "SMC6 protein", "SOF1 protein", "SOH1 protein, putative", 
                      "SPEF1-like protein", "SRP GTPase", "STU2-like protein", "SUA5 protein", 
                      "SacB", "Sda1, severe depolymerization of actin", "Sec1 vATPase", 
                      "Sec1, putative", "Sec1, putative; TM region", "Sec13", "Sec20, putative", 
                      "Sec23", "Sec24", "Sec24-like", "Sec31", "Sec61-alpha", "Sec61-gamma", 
                      "Sentrin", "Sentrin specific protease, putative", "Separase", 
                      "Ser/Thr phosphatase", "Ser/Thr phosphatase 2A, 65kDa reg sub A", 
                      "Ser/Thr phosphatase 2C, putative", "Ser/Thr phosphatase PP2A-2 catalytic subunit", 
                      "Ser/Thr protein kinase", "Ser/Thr protein kinase pkwA, putative", 
                      "Ser/Thr protein phosphatase 2A, 72/130 kDa reg sub B", "Ser/Thr protein phosphatase 2B catalytic subunit, alpha isoform", 
                      "Ser/Thr protein phosphatase PP1-1", "Ser/Thr protein phosphatase PP1-alpha 2 catalytic subunit", 
                      "Serine palmitoyltransferase 1", "Serine palmitoyltransferase 2", 
                      "Serine peptidase, putative", "Serine-pyruvate aminotransferase", 
                      "Serine/Threonine protein phosphatase", "Serine/Threonine protein phosphatase, putative", 
                      "Serine/Threonine-protein kinase pkwA, putative", "Serine/threonine protein kinase", 
                      "Serine/threonine protein phosphatase 4", "Serine/threonine protein phosphatase 5", 
                      "Serine/threonine protein phosphatase 7", "Serine/threonine protein phosphatase PP-X isozyme 2", 
                      "Serine/threonine protein phosphatase PP1 isozyme 7", "Serologically defined colon cancer antigen 1", 
                      "Serpin 1", "Seryl-tRNA synthetase", "Set-2, putative", "Seven transmembrane protein 1", 
                      "Sgs1 DNA helicase, putative", "Sgt1-like protein", "Short-chain dehydrogenase, putative", 
                      "Shwachman-Bodian-Diamond syndrome protein-like protein", "Sigma adaptin", 
                      "Signal recognition particle 68kDa", "Signal recognition particle receptor", 
                      "Sir2 family protein", "Sirtuin type 2", "Sjogren's syndrome nuclear autoantigen 1-like protein", 
                      "Small glutamine-rich tetratricopeptide repeat-containing protein", 
                      "Small nuclear ribonucleoprotein B, putative", "Small nuclear ribonucleoprotein F, putative", 
                      "Small nuclear ribonucleoprotein Sm D2, putative", "Small nuclear ribonucleoprotein Sm D3, putative", 
                      "SnRNP Sm-like protein, putative", "Socius", "Sodium/hydrogen exchanger 3", 
                      "Spastin", "Sperm-associated WD-repeat protein", "Spindle pole body protein, putative", 
                      "Spindle pole protein, putative", "Spindle protein, putative", 
                      "Splicesome-associated protein", "Splicing factor 3A subunit 2", 
                      "Splicing factor 3B subunit, putative", "Splicing factor U2AF subunit, putative", 
                      "Splicing factor-like protein, putative", "Spo11 Type II DNA topoisomerase VI subunit A", 
                      "Src-associated protein-like protein", "Stress-induced-phosphoprotein 1", 
                      "Sugar kinase, putative", "Sugar transport family protein", "Sugar-proton symporter", 
                      "Sun/nucleolar protein family protein", "Suppressor of actin 1", 
                      "Surface protein", "Synaptic glycoprotein SC2", "Synaptobrevin-like protein", 
                      "Syntaxin 16", "Syntaxin 18", "Syntaxin 1A", "Syntaxin-like protein 1", 
                      "T-complex protein-10", "TAR RNA loop binding protein, putative", 
                      "TATA-binding protein-like factor", "TBP-interacting protein TIP49", 
                      "TCP-1 chaperonin subunit alpha", "TCP-1 chaperonin subunit beta", 
                      "TCP-1 chaperonin subunit epsilon", "TCP-1 chaperonin subunit eta", 
                      "TCP-1 chaperonin subunit gamma", "TCP-1 chaperonin subunit theta", 
                      "TCP-1 chaperonin subunit zeta", "TFIIH P34", "TFIIH P44", "TFIIH basal transcription factor complex helicase subunit", 
                      "TM efflux prot", "TMP-1 protein", "TMP52", "TMP55", "TP53 regulating kinase", 
                      "TRAPPC2, putative", "TRAPPC4/Trs23-like protein", "TRAPPC5/Trs31", 
                      "TRP domain containing protein", "Telomerase catalytic subunit", 
                      "Tem-1-like protein", "Tenascin precursor", "Tenascin-37", "Tenascin-X", 
                      "Tenascin-X precursor", "Tenascin-like", "Tetratricopeptide repeat protein", 
                      "Thioredoxin reductase", "Thiosulfate sulfurtransferase", "Threonine dehydratase lateral transfer candidate", 
                      "Threonyl-tRNA synthetase", "Thymidine kinase", "Thymus-specific serine protease precursor", 
                      "Tip elongation aberrant protein 1", "Topoisomerase I-related protein", 
                      "Topoisomerase II", "Transcription factor IIIB 70 kDa subunit BRF", 
                      "Transcription factor RRN3", "Transcription factor TFIIS", "Transcription factor, putative", 
                      "Transcription regulatory protein SNF2", "Transcriptional activator, putative", 
                      "Transcriptional regulator ATRX, putative", "Transcriptional regulator, Sir2 family", 
                      "Transcriptional repressor NOT4Hp, putative", "Transducin", "Transducin/WD-40 repeat protein family", 
                      "Transglutaminase/protease, putative", "Transitional endoplasmic reticulum ATPase", 
                      "Transketolase", "Translation elongation factor", "Translation initiation factor", 
                      "Translation initiation factor 2 gamma subunit", "Translation initiation factor 6", 
                      "Translation initiation factor IF-2, putative", "Translation initiation factor eIF-2B alpha subunit", 
                      "Translation initiation factor eIF-2B delta subunit", "Translation initiation factor eIF-4A, putative", 
                      "Translation initiation inhibitor", "Translational activator GCN1", 
                      "Translationally controlled tumor protein-like protein", "dihydroorotate dehydrogenase, putative", 
                      "dihydropteroate synthetase", "dihydropteroate synthetase, putative", 
                      "dihydrouridine synthase, putative", "duffy receptor, beta form precursor", 
                      "duffy-binding protein", "dynamin protein, putative", "early transcribed membrane protein (ETRAMP)", 
                      "early transcribed membrane protein 10.1, etramp 10.1", "early transcribed membrane protein 10.2, etramp 10.2", 
                      "early transcribed membrane protein 4, ETRAMP4", "endoplasmic reticulum-resident calcium binding protein", 
                      "enolase, putative", "erthrocyte binding protein (alpha)", "erythrocyte binding antigen", 
                      "erythrocyte binding antigen 140", "erythrocyte binding antigen-175", 
                      "erythrocyte binding protein", "erythrocyte binding protein 1", 
                      "erythrocyte membrane antigen 1", "erythrocyte membrane protein 1 (PfEMP1)", 
                      "erythrocyte membrane protein 1 (PfEMP1) pseudogene", "erythrocyte membrane protein 1 (PfEMP1), truncated", 
                      "erythrocyte membrane protein 1 (PfEMP1)-like protein", "erythrocyte membrane protein 1(PfEMP-1) pseudogene", 
                      "erythrocyte membrane protein 1, PfEMP1", "erythrocyte membrane-associated antigen", 
                      "erythrocyte membrane-associated antigen, putative", "erythrocyte membrane-associated giant protein antigen 332", 
                      "eukaryotic aspartyl protease, putative,pepsinogen, putative", 
                      "eukaryotic translation initation factor 4 gamma, putative", 
                      "eukaryotic translation initiation factor subunit eIF2A, putative", 
                      "exported serine/threonine protein kinase", "falcipain-2 precursor, putative", 
                      "fork head domain protein, putative", "fructose 1,6-bisphosphate aldolase, putative", 
                      "fructose-bisphosphate aldolase", "fructose-bisphosphate aldolase 2", 
                      "fructose-bisphosphate aldolase, putative", "gamma-glutamylcysteine synthetase, putative", 
                      "gluatamate dehydrogenase, putative", "glutamate-rich protein", 
                      "glutathione reductase", "glyceraldehyde-3-phosphate dehydrogenase", 
                      "glyceraldehyde-3-phosphate dehydrogenase, putative", "glycerol-3-phosphate dehydrogenase, putative", 
                      "glycophorin-binding protein 130 precursor", "heat shock protein 40, type II", 
                      "heat shock protein 86 family protein", "heat shock protein 90", 
                      "heat shock protein, putative", "hexose transporter", "high mobility group protein", 
                      "high molecular weight rhoptry protein 3", "histamine-releasing factor, putative", 
                      "histidine rich protein II, hrpii", "histidine-rich protein II", 
                      "histidine-rich protein III", "histidine-rich protein iii, hrpiii", 
                      "histone H2A variant, putative", "histone H4, putative", "hsp60", 
                      "hsp70 interacting protein, putative", "hydroxymethylpterin pyrophosphokin", 
                      "hydroxymethylpterin pyrophosphokinase-dihydropteroate synthetase, putati", 
                      "hydroxymethylpterin pyrophosphokinase-dihydropteroate synthetase, putative", 
                      "hypothetical malaria antigen", "hypothetical protein, conserved", 
                      "hypothetical protein, conserved in Apicomplexan species", "initiation factor 2 subunit family, putative", 
                      "interspersed repeat antigen, putative", "iron-sulfur subunit of succinate dehydrogenase", 
                      "isoleucine - tRNA ligase, putative", "karyopherin beta, putative", 
                      "kinesin, putative", "kinesin-like protein, putative", "knob associated histidine-rich protein", 
                      "knob-associated histidine-rich protein", "lactate dehydrogenase", 
                      "liver stage antigen 1", "liver stage antigen 3", "macrophage migration inhibitory factor", 
                      "major blood-stage surface antigen Pv200", "malaria antigen", 
                      "membrane associated histidine-rich protein, MAHRP-1", "membrane protein pf12 precursor, putative", 
                      "merozoite adhesive erythrocytic binding protein", "merozoite surface protein", 
                      "merozoite surface protein 1", "merozoite surface protein 1 precursor", 
                      "merozoite surface protein 1, precursor", "merozoite surface protein 10, putative", 
                      "merozoite surface protein 2 precursor", "merozoite surface protein 3", 
                      "merozoite surface protein 3 (MSP3), putative", "merozoite surface protein 3 alpha (MSP3a)", 
                      "merozoite surface protein 3 beta (MSP3b)", "merozoite surface protein 4", 
                      "merozoite surface protein 4, putative", "merozoite surface protein 4/5", 
                      "merozoite surface protein 5", "merozoite surface protein 6", 
                      "merozoite surface protein 7 (MSP7)", "merozoite surface protein 7 (MSP7), putative", 
                      "merozoite surface protein 8, putative", "merozoite surface protein precursor", 
                      "merozoite surface protein, putative", "merozoite-associated tryptophan-rich antigen, putative", 
                      "methyltransferase-like protein, putative", "minchromosome maintenance (MCM) complex subunit, putative", 
                      "mitochondrial carrier protein, putative", "mitogen-activated protein kinase", 
                      "mitogen-activated protein kinase 2, putative", "monosaccharide transporter, putative", 
                      "multidrug resistance protein", "multidrug resistance protein (mdr1)", 
                      "multidrug resistance protein 2 (heavy metal transport family)", 
                      "multidrug resistance protein, putative", "normocyte-binding protein 1, pseudogene", 
                      "oligosaccharyl transferase STT3 subunit, putative", "ookinete surface antigen-like protein Pfs28", 
                      "ookinete surface protein Pvs25", "origin recognition complex subunit 1", 
                      "osmiophilic body protein", "para-aminobenzoic acid synthetase", 
                      "pbs36 homologue", "pepsinogen, putative", "peptidyl-prolyl cis-trans isomerase precursor", 
                      "pf47", "phosphatidylethanolamine-binding protein, putativ", 
                      "phosphatidylinositol transfer protein, putative", "phosphoglycerate mutase, putative", 
                      "phospholipase, putative", "phosphoribosylpyrophosphate synthetase", 
                      "plasmodium falciparum gamete antigen 27/25", "pre-mRNA splicing factor, putative", 
                      "prohibitin, putative", "protein disulfide isomerase, putative", 
                      "protein kinase", "protein kinase 1", "protein kinase Crk2", 
                      "protein phosphatase, putative", "pseudogene, rifin, degenerate, putative", 
                      "pseudogene, stevor, putative", "putative impotin alpha 1b", 
                      "reticulocyte binding protein 2 homolog a", "reticulocyte binding protein, putative", 
                      "reticulocyte-binding protein, putative", "rhoptry neck protein 2, putative", 
                      "rhoptry protein", "rhoptry protein 2, putative", "rhoptry protein-related", 
                      "rhoptry-associated membrane antigen, RAMA", "rhoptry-associated protein 1, RAP1", 
                      "rhoptry-associated protein 1, putative", "rhoptry-associated protein 2, RAP2", 
                      "rhoptry-associated protein 3, RAP3", "rhoptry-associated protein, putative", 
                      "ribonucleoside-diphosphate reductase large chain", "ribonucleoside-diphosphate reductase, large subunit", 
                      "ribonucleotide reductase small subunit", "ribosomal phosphoprotein P0", 
                      "rifin", "rifin (3D7-rifT3-5)", "rifin pseudogene", "rifin, pseudogene", 
                      "rifin, putative,truncated, pseudogene", "rifin, truncated", 
                      "ring-infected erythrocyte surface antigen", "s-adenosylmethionine synthetase, putative", 
                      "RNA pseudouridylate synthase domain-containing protein, putative", 
                      "Rhoptry kinase family protein ROP2A (incomplete catalytic triad)", 
                      "SRS domain-containing protein", "SRS domain-containing protein,SRS29B, putative", 
                      "SRS12A", "SRS12D", "SRS15B", "SRS19B (= SRS 8)", "SRS19C (= SRS7)", 
                      "SRS29B (= SAG1, P30)", "SRS34A (= SAG2A, P22)", "SRS36B (= SAG5D)", 
                      "SRS36C (= SAG5A)", "SRS36D (= SAG5C)", "SRS40A", "SRS40D", "SRS49C (= SAG2D)", 
                      "SRS49D (= SAG2C)", "SRS57 (= SAG3, P43)", "actin, putative", 
                      "bifunctional dihydrofolate reductase-thymidylate synthase (DHFR-TS)", 
                      "cathepsin L-like thiolproteinase, putative", "conserved hypothetical protein", 
                      "cyst matrix protein", "cyst matrix protein, putative", "dense granule protein 3", 
                      "dense granule protein 5 precursor, putative", "dense granule protein 7", 
                      "dense granule protein, putative", "dynein 1-beta heavy chain, flagellar inner arm I1 complex, putative", 
                      "elongation factor Tu", "granule antigen protein GRA6", "granule antigen protein GRA6, putative", 
                      "heat shock protein 70, putative", "large subunit ribosomal RNA", 
                      "major surface antigen p30", "malate dehydrogenase, putative", 
                      "microneme protein 3 (MIC3)", "microneme protein MIC3", "microneme protein,  putative", 
                      "myosin A, putative", "nucleolar phosphoprotein nucleolin, putative", 
                      "patched transmembrane domain-containing protein, putative", 
                      "peroxisomal catalase", "serine/threonine-protein kinase, putative", 
                      "small subunit ribosomal RNA", "tubulin alpha chain", "tubulin alpha chain, putative", 
                      "uracil phosphoribosyltransferase", "uracil phosphoribosyltransferase, putative", 
                      "serine hydroxymethyltransferase", "serine repeat antigen 1", 
                      "serine repeat antigen 1, putative", "serine repeat antigen 6", 
                      "serine/threonine protein kinase, putative", "sexual stage surface protein Pvs28", 
                      "sodium/hydrogen exchanger, Na , H  antiporter", "sodium/hydrogen exchanger, Na+, H+ antiporter", 
                      "spindle pole body protein, putative", "sporozoite surface protein 2", 
                      "sporozoite surface protein 2, putative", "starp antigen", "steroid dehydrogenase, putative", 
                      "stevor", "stevor (3D7-stevorT3-2)", "stevor pseudogene", "stevor, degenerate, putative", 
                      "stevor, pseudogene", "stevor, putative", "syntaxin, putative", 
                      "thioredoxin-like redox-active protein, putative", "thrombospondin-related protein 3 precursor, putative", 
                      "thymidylate synthase, putative", "transcription factor with AP2 domain(s), putative", 
                      "transcription initiation factor TFIIB, putative", "transcription initiation factor TFiid, TATA-binding protein", 
                      "transcriptional activator ADA2, putative", "transcriptional regulator, putative", 
                      "translation elongation factor Tu", "transmission blocking target antigen precursor", 
                      "transmission-blocking target antigen Pfs230, putative", "transmission-blocking target antigen s230 precursor", 
                      "transporter, putative", "triose-phosphate isomerase", "trophozoite antigen r45-like protein,truncated", 
                      "trophozoite stage antigen", "tryptophan-rich antigen", "tryptophan-rich antigen (Pv-fam-a)", 
                      "tryptophan/threonine-rich antigen", "tubulin beta chain", "tubulin beta chain, fragment", 
                      "tubulin beta chain, putative", "ubiquitin carboxyl-terminal hydrolase, putative", 
                      "ubiquitin-protein ligase e3, putative", "ubiquitin-specific protease-1, putative", 
                      "up-regulated in infective sporozoites", "valine -- tRNA ligase, putative", 
                      "valine-tRNA ligase", "var (3D7-varT3-2)", "var-like protein", 
                      "variable surface protein Vir10, truncated, putative", "variable surface protein Vir10-related", 
                      "variable surface protein Vir14, putative", "variable surface protein Vir14, truncated, putative", 
                      "variable surface protein Vir17, putative", "variable surface protein Vir21, putative", 
                      "variable surface protein Vir21, truncated, putative", "variable surface protein Vir22, putative", 
                      "variable surface protein Vir22, truncated, putative", "variable surface protein Vir26, putative", 
                      "variable surface protein Vir26-like, truncated", "variable surface protein Vir3, truncated, putative", 
                      "variable surface protein Vir32, putative", "variable surface protein Vir32/4, putative", 
                      "variable surface protein Vir35, putative", "variable surface protein Vir4, putative", 
                      "variable surface prtoein Vir14, truncated, putative", "von Willebrand factor A-domain-related protein, putative", 
                      "zinc finger C-x8-C-x5-C-x3-H type, putative", "zinc finger, RAN binding protein, putative", 
                      "1,4-alpha-glucan branching enzyme, putative", "28 kDa antigen, putative", 
                      "ATP-binding cassette, sub-family C, member 1", "Actin, related", 
                      "Bradyzoite surface protein, putative", "C2 domain-containing protein, putative", 
                      "CAM kinase, CDPK family", "CAM kinase, SNF1/AMK1 family ToxPK1", 
                      "DNA ligase, putative", "DNA polymerase alpha catalytic subunit, putative", 
                      "Enolase (EC 4.2.1.11), related", "GRA9 protein, putative", "Heat shock protein 70, related", 
                      "P35 surface protein, putative", "QF122 antigen", "RIF pseudogene, RIFIN pseudogene", 
                      "RNA helicase-1", "RNA polymerase A/beta'/A'' subunit, putative", 
                      "RNA-helicase, putative", "Rab1b, GTPase", "RhopH3", "Ribonucleotide reductase, small chain", 
                      "S-antigen", "SERA-3", "SET domain protein, putative", "SICAvar-like antigen", 
                      "SNF2 helicase, putative", "Sarcoplasmic and endoplasmic reticulum Ca-ATPase, putative", 
                      "Small_Subunit_rRNA", "StevoR", "Thrombospondin-related anonymous protein, TRAP", 
                      "UDP-galactose transporter, putative", "V-type H( )-translocating pyrophosphatase, putative", 
                      "VAR C, pseudogene", "VARC pseudogene", "WD domain, G-beta repeat-containing protein", 
                      "actin I", "acyl carrier protein 4, chloroplast precursor, putative", 
                      "acyl-CoA synthetase, PfACS11", "adenylosuccinate lyase, putative", 
                      "alpha tubulin 1", "alveolin, putative", "antigen 332, putative", 
                      "apical membrane antigen 1", "apical membrane antigen 1,", "apical membrane antigen 1,  AMA1", 
                      "apical membrane antigen 1, putative", "apical membrane antigen-1", 
                      "apical merozoite antigen 1", "aquaglyceroporin, putative", "arginase, putative", 
                      "asparagine-rich antigen", "asparagine-rich antigen Pfa35-2", 
                      "asparagine-rich antigen Pfa55-14", "asparagine-rich protein, putative", 
                      "aspartic protease PM4, putative", "bifunctional dihydrofolate reductase-thym", 
                      "bifunctional dihydrofolate reductase-thymidylate synth", "bifunctional dihydrofolate reductase-thymidylate synthase", 
                      "bifunctional dihydrofolate reductase-thymidylate synthase 1, putative", 
                      "bifunctional dihydrofolate reductase-thymidylate synthase, putative", 
                      "biotin carboxylase subunit of acetyl CoA carboxylase, putative", 
                      "blood stage antigen 41-3 precursor", "cAMP-dependent protein kinase regulatory subunit", 
                      "calcineurin B subunit isoform 1, putative", "calcium-transporting ATPase", 
                      "calmodulin", "cation-transporting ATPase 1", "cdc-2 related kinase 1", 
                      "cdc-2 related kinase 3", "cdc2-related kinase 2", "cdc2-related kinase 2, putative", 
                      "cdk7, putative", "cell division cycle ATPase, putative", "cg1 protein", 
                      "chabaupain 1", "chaperonin, cpn60", "chitinase, putative", "chloroquine resistance transporter", 
                      "chloroquine resistance transporter, putative", "cholinephosphate cytidylyltransferase", 
                      "chromodomain-helicase-DNA-binding protein 1 homolog, putative", 
                      "cir1 protein", "circumsporozoite (CS) protein", "circumsporozoite (CS) protein precursor", 
                      "circumsporozoite protein precursor, putative", "circumsporozoite protein precursor-related", 
                      "circumsporozoite protein, putative", "circumsporozoite-", "circumsporozoite-related antigen", 
                      "cloroquine resistance associated protein Cg4, putative", "clustered-asparagine-rich protein", 
                      "conserved Plasmodium membrane protein, unknown function", "conserved Plasmodium protein, unknown function", 
                      "conserved protein, unknown function", "cyclase-associated protein", 
                      "cyclin, putative", "cyclin2 related protein, putative", "cysteine protease, putative", 
                      "cysteine proteinase precursor", "cysteine proteinase, putative", 
                      "cysteine repeat modular protein, putative", "cysteine-rich surface protein", 
                      "cytidine and deoxycytidylate deaminase, putative", "cytochrome b", 
                      "cytochrome c oxidase subunit 1", "cytoplasmic translation machinery associated protein, putative", 
                      "cytoskeleton associated protein, putative")

IsolateByGenotypeNumber = 
function(
`genotype` = '1', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByGenotypeNumber.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByGenotypeNumber.xml', .convert = NULL, .json = TRUE
)
{
     `genotype` <- checkValues(`genotype`, c("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", 
                      "13", "14", "15", "17", "18", "19", "21", "23", "24", "25", "26", 
                      "28", "29", "30", "35", "38", "39", "42", "43", "44", "46", "47", 
                      "49", "52", "54", "60", "62", "66", "70", "72", "73", "74", "76", 
                      "77", "79", "80", "83", "84", "87", "90", "91", "95", "96", "97", 
                      "98", "99", "100", "101", "104", "105", "110", "112", "113", 
                      "115", "118", "119", "120", "122", "126", "127", "128", "130", 
                      "131", "132", "133", "137", "139", "141"), 'genotype', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight", "gene_type"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'genotype' = `genotype`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolateByRFLPGenotype = 
function(
`rflp_protein_SAG1` = 'Don\'t Care', `rflp_protein_53_SAG2` = 'Don\'t Care', `rflp_protein_alt_SAG2` = 'Don\'t Care', `rflp_protein_SAG3` = 'Don\'t Care', `rflp_protein_BTUB` = 'Don\'t Care', `rflp_protein_GRA6` = 'Don\'t Care', `rflp_protein_c22-8` = 'Don\'t Care', `rflp_protein_c29-2` = 'Don\'t Care', `rflp_protein_L358` = 'Don\'t Care', `rflp_protein_PK1` = 'Don\'t Care', `rflp_protein_Apico` = 'Don\'t Care', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByRFLPGenotype.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByRFLPGenotype.xml', .convert = NULL, .json = TRUE
)
{
     `rflp_protein_SAG1` <- checkValues(`rflp_protein_SAG1`, c("Don't Care", "I", "II", "II or III", "u-1"), 'rflp_protein_SAG1', FALSE)
     `rflp_protein_53_SAG2` <- checkValues(`rflp_protein_53_SAG2`, c("Don't Care", "I", "II", "III", "nd"), 'rflp_protein_53_SAG2', FALSE)
     `rflp_protein_alt_SAG2` <- checkValues(`rflp_protein_alt_SAG2`, c("Don't Care", "I", "II", "III", "nd"), 'rflp_protein_alt_SAG2', FALSE)
     `rflp_protein_SAG3` <- checkValues(`rflp_protein_SAG3`, c("Don't Care", "I", "II", "III"), 'rflp_protein_SAG3', FALSE)
     `rflp_protein_BTUB` <- checkValues(`rflp_protein_BTUB`, c("Don't Care", "I", "II", "III"), 'rflp_protein_BTUB', FALSE)
     `rflp_protein_GRA6` <- checkValues(`rflp_protein_GRA6`, c("Don't Care", "I", "II", "III"), 'rflp_protein_GRA6', FALSE)
     `rflp_protein_c22-8` <- checkValues(`rflp_protein_c22-8`, c("Don't Care", "I", "II", "III", "u-1", "u-2"), 'rflp_protein_c22-8', FALSE)
     `rflp_protein_c29-2` <- checkValues(`rflp_protein_c29-2`, c("Don't Care", "I", "II", "III", "nd", "u-1"), 'rflp_protein_c29-2', FALSE)
     `rflp_protein_L358` <- checkValues(`rflp_protein_L358`, c("Don't Care", "I", "II", "III"), 'rflp_protein_L358', FALSE)
     `rflp_protein_PK1` <- checkValues(`rflp_protein_PK1`, c("Don't Care", "I", "II", "III", "nd", "u-1", "u-2", "u-3"), 'rflp_protein_PK1', FALSE)
     `rflp_protein_Apico` <- checkValues(`rflp_protein_Apico`, c("Don't Care", "I", "II", "III", "nd"), 'rflp_protein_Apico', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight", "gene_type"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'rflp_protein_SAG1' = `rflp_protein_SAG1`,
                  'rflp_protein_53_SAG2' = `rflp_protein_53_SAG2`,
                  'rflp_protein_alt_SAG2' = `rflp_protein_alt_SAG2`,
                  'rflp_protein_SAG3' = `rflp_protein_SAG3`,
                  'rflp_protein_BTUB' = `rflp_protein_BTUB`,
                  'rflp_protein_GRA6' = `rflp_protein_GRA6`,
                  'rflp_protein_c22-8' = `rflp_protein_c22-8`,
                  'rflp_protein_c29-2' = `rflp_protein_c29-2`,
                  'rflp_protein_L358' = `rflp_protein_L358`,
                  'rflp_protein_PK1' = `rflp_protein_PK1`,
                  'rflp_protein_Apico' = `rflp_protein_Apico`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolateByStudy = 
function(
`study` = 'Subgenotype analysis of Cryptosporidium parvum isolates from humans and animals in Japan using the 60kDa glycoprotein gene sequences', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByStudy.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByStudy.xml', .convert = NULL, .json = TRUE
)
{
     `study` <- checkValues(`study`, "`IsolateByStudy.study.options`", 'study', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'study' = `study`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

`IsolateByStudy.study.options` = 
  c("Subgenotype analysis of Cryptosporidium parvum isolates from humans and animals in Japan using the 60kDa glycoprotein gene sequences", 
                      "Cryptosporidium parvum Izatnagar isolate small subunit ribosomal RNA gene", 
                      "PCRMediated Recombination between Cryptosporidium spp of Lizards and Snakes", 
                      "Molecular diagnosis of Cryptosporidiosis in northwest England UK", 
                      "Molecular diagnosis of Cryptosporidiosis in northern Iran", 
                      "Genotype and subtype analyses of Cryptosporidium isolates from dairy calves and humans in Ontario", 
                      "Biological Studies and Molecular Characterization of a Cryptosporidium Isolate from OstrichesStruthio camelus", 
                      "Distribution of Cryptosporidium subtypes in humans and domestic and wild ruminants in Portugal", 
                      "Multilocus Genotyping of Cryptosporidium sp Isolates from Human Immunodeficiency VirusInfected Individuals in South India", 
                      "Molecular characterization of Danish Cryptosporidium parvum isolates", 
                      "Occurrence and molecular characterization of Cryptosporidium spp in mammals and reptiles at the Lisbon Zoo", 
                      "Preliminary molecular characterization of Cryptosporidium parvum isolates of wildlife rodents from Poland", 
                      "Gene Analysis of Cryptosporidium parvum HNJ1 Strain Isolated in Japan", 
                      "Cryptosporidium parvum changchunca 18S ribosomal RNA gene", 
                      "Genotypes of cryptosporidium species infecting furbearing mammals differ from those of species infecting humans", 
                      "Molecular characterization of Cryptosporidium from various hosts", 
                      "Cryptosporidium parvum glycoprotein 60gp60 gene sequence", "Mitochondrialtype ironsulfur cluster biosynthesis genesIscS and IscU in the apicomplexan Cryptosporidium parvum", 
                      "Genotype of Cryptosporidium parvum that caused an outbreak of cryptosporidiosis in Hokkaido in 2002", 
                      "Gastrointestinal cryptosporidiosis in a puppy", "Molecular analysis of Cryptosporidium species isolated from HIVinfected patients in Thailand", 
                      "Host adaptation and hostparasite coevolution in Cryptosporidium implications for taxonomy and public health", 
                      "Molecular analysis of the 18S rRNA gene fragment of Cryptosporidium parasites from persons living in Kenya Malawi Brazil UK and Vietnam in relation to HIV infection", 
                      "Sequence variation in immunodominant antigen genes of 2 predominant genotypes of Cryptosporidium parvum", 
                      "Molecular and phylogenetic characterisation of Cryptosporidium from birds", 
                      "Genomic sequences in Cryptosporidium parvum selected from a genomic library", 
                      "Genomic sequences in Cryptosporidium parvum selected using a human minisatellite probe", 
                      "Cryptosporidium genotypes and subtypes in lambs and goat kids in Spain", 
                      "Cryptosporidium Giardia and Enterocytozoon bieneusi in cats from BogotaColombia and genotyping of isolates", 
                      "Evidence supporting zoonotic transmission of Cryptosporidium spp in Wisconsin", 
                      "Cryptosporidium sp 18S small subunit ribosomal RNA gene isolated from human in Iran", 
                      "Prevalence and molecular characterisation of Cryptosporidium and Giardia in lambs and goat kids in Belgium", 
                      "Antigenic differences within the Cryptosporidium hominis and Cryptosporidium parvum surface proteins P23 and GP900 defined by monoclonal antibody reactivity", 
                      "Detection and molecular characterization of Cryptosporidium bovislike isolate from a newborn lamb in Spain", 
                      "Cryptosporidium sp in drinking water of rural sites in Switzerland", 
                      "Cryptosporidium species of domestic animals sold at a public market in Rio de Janeiro Brazil", 
                      "Genomic sequences in Cryptosporidium parvum from a selected genomic library", 
                      "Multilocus sequence typing and genetic structure of Cryptosporidium hominis from children in Kolkata India", 
                      "Distribution of Cryptosporidium parvum subtypes in calves in eastern United States", 
                      "Cryptosporidium sp HSP70 gene isolate from sheep of Iran", "Genetic Characterization of a Cryptosporidium isolate from a deer in China based on different gene locis", 
                      "New species of Cryptosporidium Tyzzer 1907Apicomplexa from amphibian host morphology biology and phylogeny", 
                      "Molecular and epidemiological investigations of cryptosporidiosis in Cuban children", 
                      "Contemporary identification of previously reported novel Cryptosporidium isolates reveals Cryptosporidium bovis and the cervine genotype in sheepOvis aries", 
                      "Cryptosporidium in farmed animals the detection of a novel isolate in sheep", 
                      "Cryptosporidiosis in two alpacaLama pacos holdings in the SouthWest of England", 
                      "High prevalence of Cryptosporidium bovis and the deerlike genotype in calves compared to mature cows in beef cowcalf operations", 
                      "Cryptosporidium GP60 genotypes from humans and domesticated animals in Australia North America and Europe", 
                      "A practical and costeffective mutation scanningbased approach for investigating genetic variation in Cryptosporidium", 
                      "Occurrence and PCRRFLP Diagnosis of Cryptosporidium felis and Cryptosporidium canis in an Animal Shelter in Nova Iguacu Rio de Janeiro Brazil", 
                      "Genotype and subtype analyses of Cryptosporidium isolates from cattle in Hungary", 
                      "The concentration variability of Cryptosporidium spp in the Tone River Japan determined by quenching probe PCRQProbe PCR and denaturing gradient gel electrophoresisDGGE", 
                      "Isolation of Cryptosporidium andersoni Kawatabi type in a slaughterhouse in the northern island of Japan", 
                      "Survey of Cryptosporidium parvum genotypes in humans from the UK by mutation scanning analysis of a heat shock protein gene region", 
                      "Genetic polymorphism at the betatubulin locus among human and animal isolates of Cryptosporidium parvum", 
                      "Sources and species of Cryptosporidium oocysts in the Wachusett Reservoir watershed", 
                      "Molecular characterisation of Cryptosporidium isolates from humans in Slovenia", 
                      "Phylogenetic analysis of Cryptosporidium isolates from captive reptiles using 18S rDNA sequence data and random amplified polymorphic DNA analysis", 
                      "New genotypes and factors associated with Cryptosporidium detection in musselsMytilus spp along the California coast", 
                      "Sheep may not be an important zoonotic reservoir for Cryptosporidium and Giardia parasites", 
                      "Phylogenomic evidence supports past endosymbiosis intracellular and horizontal gene transfer in Cryptosporidium parvum", 
                      "Phylogenetic relationships of Cryptosporidium parasites based on the 70kilodalton heat shock proteinHSP70 gene", 
                      "Identification of organellar structures in Cryptosporidium parvum possible location for extranuclear genomes", 
                      "Genetic diversity within Cryptosporidium parvum and related Cryptosporidium species", 
                      "Direct evidence for cyanideinsensitive quinol oxidasealternative oxidase in apicomplexan parasite Cryptosporidium parvum phylogenetic and therapeutic implications", 
                      "An evaluation of molecular diagnostic tools for the detection and differentiation of humanpathogenic Cryptosporidium spp", 
                      "Subgenotype Analysis of Cryptosporidium Isolates from Humans Cattle and Zoo Ruminants in Portugal", 
                      "Molecular Characterization of Isolates of Waterborne Cryptosporidium spp Collected during an Outbreak of Gastroenteritis in South Burgundy France", 
                      "Morphologic host specificity and molecular characterization of a Hungarian Cryptosporidium meleagridis isolate", 
                      "Sequence differences in the diagnostic target region of the oocyst wall protein gene of Cryptosporidium parasites", 
                      "Validation of serologic methods for epidemiologic investigation of outbreaks caused by different strains of Cryptosporidium parvum", 
                      "Molecular and morphologic characterization of a Cryptosporidium genotype identified in lemurs", 
                      "Genetic analysis of a Cryptosporidium parvum human genotype 1 isolate passaged through different host species", 
                      "Identification of Multiple Genotypes of Cryptosporidium meleagridis in Birds and Humans", 
                      "DNA fingerprinting of Cryptosporidium parvum isolates using amplified fragment length polymorphismAFLP", 
                      "The initiation translation factor eIF4A of Cryptosporidium parvum is encoded by two distinct mRNA forms and shows DNA sequence polymorphism distinguishing genotype 1 and 2 isolates", 
                      "Further characterisation of Cryptosporidium meleagridis from humans molecular analysis and description of affected patients", 
                      "Identification of species and sources of Cryptosporidium oocysts in storm waters with a smallsubunit rRNAbased diagnostic and genotyping tool", 
                      "CP2 gene as a useful viability marker for Cryptosporidium parvum", 
                      "Occurrence of Cryptosporidium sp in snakes in Japan", "Cryptosporidium muris in a Texas canine population", 
                      "Genetic markers differentiate C parvum isolates", "Genetic charcterization of Cryptosporidium Spp among children with diarrhea in Tehran and Qazvin provinces Iran", 
                      "Multilocus genetic analysis of Cryptosporidium in naturally contaminated bivalve molluscs", 
                      "PCR amplification and sequence analyses of ITS1 rDNA from Cryptosporidium andersoni in dairy cattle", 
                      "Molecular and Spatial Epidemiology of Cryptosporidiosis in Children in a Semiurban Community in South India", 
                      "Occurrence of Cryptosporidium and Giardia in suckling piglets in Norway", 
                      "ClamsCorbicula fluminea as bioindicators of fecal contamination with Cryptosporidium and Giardia spp in freshwater ecosystems in California", 
                      "Molecular Characterization of Cryptosporidium in Cattle", "Thrombospondin related protein in Cryptosporidium", 
                      "Detection of a single Cryptosporidium oocyst from an archived slide using laser capture microscopy", 
                      "Cryptosporidium oocysts in musselsMytilus edulis from NormandyFrance", 
                      "Novel Cryptosporidium based on 18S rRNA from species of Spermophilus in CaliforniaS beldingi S beecheyi and S lateralis", 
                      "Genotyping and phenotyping Cryptosporidium baileyi a model for characterization of Cryptosporidium species and genotypes", 
                      "Phylogenetic analysis of Cryptosporidium isolated from China based on the smallsubunit rRNA gene locus", 
                      "Sequence of the 18S rRNA gene and ITS1 from a human isolate of Cryptosporidium parvum", 
                      "Molecular taxonomy of the genus Cryptosporidium", "Isolation sequence and molecular karyotype analysis of the actin gene of Cryptosporidium parvum", 
                      "Phylogenetic Analysis of the Hypervariable Region of the 18S rRNA Gene of Cryptosporidium Oocysts in Feces of Canada GeeseBranta canadensis Evidence for Five Novel Genotypes", 
                      "Molecular Surveillance of Cryptosporidium spp in Raw Wastewater in Milwaukee Implications for Understanding Outbreak Occurrence and Transmission Dynamics", 
                      "Identification and characterization of Cryptosporidium spp Giardia duodenalis and Enterocytozoon bieneusi in wastewater and sludge samples in Tunis", 
                      "A comparison of Cryptosporidium subgenotypes from several geographic regions", 
                      "Genetic characterization of Cryptosporidium isolates from ringed sealsPhoca hispida in Northern Quebec Canada", 
                      "Cryptosporidiosis in Jeddah city Saudi Arabia", "Survey of Cryptosporidium parvum genotypes in humans from the United Kingdom by mutation scanning analysis of a heat shock protein gene region", 
                      "Characterisation of small double stranded RNA molecule in Cryptosporidium hominis Cryptosporidium felis and Cryptosporidium meleagridis", 
                      "Differences in clinical manifestations among Cryptosporidium species and subtypes in HIVinfected persons in Lima Peru", 
                      "Distribution of cryptosporidium genotypes in storm event water samples from three watersheds in New York", 
                      "Biological Studies and Molecular Characterization of a Cryptosporidium Isolate from ostrichesStruthio camelus", 
                      "Molecular characterization of Cryptosporidium isolates from humans and animals in Iran", 
                      "The role of CDPK1 during initial life stages of Cryptosporidium", 
                      "Cryptosporidium speciesmarsupial genotype isolated from a western barred bandicootPerameles bougainville Western Australia", 
                      "Isolation and partial characterization of Cryptosporidium sporozoite and oocyst wall recombinant proteins", 
                      "Phylogenetic relationships among isolates of Cryptosporidium evidence for several new species", 
                      "Genetic and phenetic characterization of Cryptosporidium baileyi", 
                      "Phylogenetic analysis of Cryptosporidium isolates from China based on the hsp70 gene", 
                      "Phylogenetic analysis of Cryptosporidium isolated from China based on the 18S rRNA gene locus", 
                      "Identification of the Cryptosporidium isolate from chickens in Japan by sequence analyses", 
                      "Cryptosporidium parvum sporozoites deposit trails of 11A5 antigen during gliding locomotion and shed 11A5 antigen during invasion of MDCK cells in vitro", 
                      "Animal propagation and genomic survey of a genotype 1 isolate of Cryptosporidium parvum", 
                      "Presence of doublestranded RNAs in human and calf isolates of Cryptosporidium parvum", 
                      "A microsatellite marker reveals population heterogeneity within human and animal genotypes of cryptosporidium parvum", 
                      "Telomeric sequences of Cryptosporidium parvum", "Biallelic polymorphism in the intron region of the betatubulin gene of Cryptosporidium parasites", 
                      "Simultaneous identification of multiple antigenic peptides from Cryptosporidium parvum sporozoites by screening a histidinetag expression library", 
                      "HostAdapted Cryptosporidium spp in Canada GeeseBranta canadensis", 
                      "Characterization of a mitochondrionlike organelle in Cryptosporidium parvum", 
                      "Molecular and Biological Characterization of a Cryptosporidium molnariLike Isolate from a GuppyPoecilia reticulata", 
                      "Molecular analysis of the 18S rRNA gene of Cryptosporidium parasites from patients with or without human immunodeficiency virus infections living in Kenya Malawi Brazil the United Kingdom and Vietnam", 
                      "Characterization of Cryptosporidium meleagridis of Human Origin Passaged through Different Host Species", 
                      "Molecular Epidemiological Analysis of Cryptosporidium Isolates from Humans and Animals by Using a Heteroduplex Mobility Assay and Nucleic Acid Sequencing Based on a Small DoubleStranded RNA Element", 
                      "Characteristics of a Novel Type of Bovine Cryptosporidium", 
                      "Differentiating human from animal isolates of Cryptosporidium parvum", 
                      "Phylogenetic Analysis of Cryptospoiridum Based on Nuclear Encoded Mitochondrial Gene Locus", 
                      "Molecular characterization of Cryptosporidium spp from children in Kolkata India", 
                      "Cryptosporidium parvum 18S rRNA", "Identification of a type II topoisomerase gene from Cryptosporidium parvum", 
                      "Presence of heterogeneous copies of the small subunit rRNA gene in Cryptosporidium parvum human and marsupial genotypes and Cryptosporidium felis", 
                      "Morphological and genetic characterisation of Cryptosporidium oocysts from domestic cats", 
                      "Molecular cloning and expression analysis of a Cryptosporidium parvum gene encoding a new member of the thrombospondin family", 
                      "Isolation of a novel and specific repetitive DNA sequence of Cryptosporidium parvum", 
                      "Isolation of elongation factor 1alpha gene from Cryptosporidium parvum", 
                      "DNA probe and PCR detection of Cryptosporidium parvum compared to immunofluorescence assay", 
                      "Phylogenetic analysis of Cryptosporidium parasites based on the smallsubunit rRNA gene locus", 
                      "Genetic Characterization and Transmission Cycles of Cryptosporidium Species Isolated from Humans in New Zealand", 
                      "Polymorphisms in the superoxide dismutaseFeSOD of Cryptosporidium parvum", 
                      "Evolution of Cryptosporidium parvum Lactate Dehydrogenase from Malate Dehydrogenase by a Very Recent Event of Gene Duplication", 
                      "Molecular Epidemiology of Cryptosporidiosis in Children in Malawi", 
                      "Genetic diversity of Cryptosporidium spp in cattle in Michigan implications for understanding the transmission dynamics", 
                      "Nucleotide changes within three Cryptosporidium parvum surface protein encoding genes differentiate genotype I from genotype II isolates", 
                      "A multilocus genotypic analysis of Cryptosporidium meleagridis", 
                      "Cryptosporidium muris from a human HIV positive patient from Kenya", 
                      "Polymorphisms in the betatubulin gene of Cryptosporidium parvum differentiate between isolates based on animal host but not geographic origin", 
                      "Cryptosporidium parvum infection in wildlife in New York state", 
                      "Molecular epidemiology and population substructure of Cryptosporidium hominis in children in Kenya", 
                      "Genotypes and subtypes of Cryptosporidium spp in neonatal calves in Northern Ireland", 
                      "Unique Cryptosporidium population in HIVinfected persons Jamaica", 
                      "Detection of Cryptosporidium DNA in Feces of Cats and Dogs in the United States", 
                      "Distribution of Cryptosporidium species in sheep in the UK", 
                      "Distribution of Cryptosporidium parvum subtypes in calves in Germany", 
                      "Cryptosporidium from tortoises Genetic characterisation phylogeny and zoonotic implications", 
                      "Detection and species identification of Cryptosporidium from Taiwan feeding animals", 
                      "Geographic Linkage and Variation in Cryptosporidium hominis", 
                      "The CPA135 gene as a marker to identify the four major cryptosporidium species infecting humans", 
                      "Sequence analysis of 18S rDNA fragments from Philippine Cryptosporidium isolates", 
                      "Investigation of potential zooanthroponotic transmission of cryptosporidiosis and giardiasis through agricultural use of reclaimed wastewater", 
                      "Cryptosporidium p30 a GalactoseNAcetylgalactosaminespecific Lectin Mediates Infection in Vitro", 
                      "Genotypic characterization and phylogenetic analysis of Cryptosporidium sp from domestic animals in Brazil", 
                      "Subtype analysis of Cryptosporidium parvum isolates from calves on farms around Belgrade Serbia and Montenegro using the 60 kDa glycoprotein gene sequences", 
                      "Cryptosporidium in farm animals from Tunisian communities", 
                      "An imported case of mixedinfection with Giardia and Cryptosporidium parasites in Japan", 
                      "Antigenic variation in Giardia lamblia is regulated by RNA interference", 
                      "Characterization of factors favoring the expression of soluble protozoan tubulin proteins in Escherichia coli", 
                      "Targeting of proteins to the nuclei of Giardia lamblia", "Allelic variation in Giardia intestinalis and implications for sex", 
                      "Isolation and characterization of a NADPdependent glutamate dehydrogenase gene from the primitive eucaryote Giardia lamblia", 
                      "Evidence for unusually short tubulin mRNA leaders and characterization of tubulin genes in Giardia lamblia", 
                      "Divergence of triosephosphate isomerase gene and protein sequences between independent Giardia lamblia isolates", 
                      "Cloning and restriction enzyme mapping of ribosomal DNA of Giardia duodenalis Giardia ardeae and Giardia muris", 
                      "Genotyping of Giardia intestinalis from domestic and wild animals in Japan using glutamete dehydrogenase gene sequencing", 
                      "Genotyping of Giardia intestinalis from human fecal samples from Palestine showed unexpected assemblage B mixed infection", 
                      "A Characterization of the Population and WithinHost Diverity of Plasmodium falciparum and Plasmodium vivax in the Peruvian Amazon", 
                      "Natural selection maintains a stable polymorphism at the circumsporozoite protein locus of Plasmodium falciparum in a low endemic area", 
                      "Molecular characterisation of drugresistant Plasmodium falciparum from Thailand", 
                      "Sequence variation of ookinete surface proteins Pvs25 and Pvs28 of Plasmodium vivax isolates from Southern Mexico and their association to local anophelines infectivity", 
                      "Plasmodium vivax sexual stage antigen gene polymorphism", "Rhop3 protein conservation among Plasmodium species and induced protection against lethal P yoelii and P berghei challenge", 
                      "Genetic diversity of dihydrofolate reductasethymidylate synthase gene from Korea isolates", 
                      "Sequence diversity of serine repeat antigen gene exon II of Plasmodium falciparum in worldwide collected wild isolates", 
                      "Plasmodium vivax recent world expansion and genetic identity to Plasmodium simium", 
                      "Overproduction of lactate dehydrogenase from Plasmodium falciparum opens a route to new antimalarials", 
                      "Complete gene map of the plastidlike DNA of the malaria parasite Plasmodium falciparum", 
                      "Molecular cloning and characterization of a second calciumdependent protein kinase of Plasmodium falciparum", 
                      "PfKIN an SNF1 type protein kinase of Plasmodium falciparum predominantly expressed in gametocytes", 
                      "Plasmodium falciparum liver stage antigen1 is well conserved and contains potent B and T cell determinants", 
                      "Structure of the RESA gene of Plasmodium falciparum", "Polymorphism in TRAP Nterminal region of Plasmodium falciparum in Indian isolates", 
                      "Sequence variations in the Plasmodium vivax dihydrofolate reductasethymidylate synthase gene and their relationship with pyrimethamine resistance", 
                      "Malaria parasites contain two identical copies of an elongation factor 1 alpha gene", 
                      "Plasmodium vivax ortholog of secreted protein with altered thrombospondin repeat domain", 
                      "Plasmodium falciparum isolate G1 merozoite surface protein 1MSP1", 
                      "Characterization of PfMyb1 transcription factor during erythrocytic development of 3D7 and F12 Plasmodium falciparum clones", 
                      "Identification and initial characterization of three novel cyclinrelated proteins of the human malaria parasite Plasmodium falciparum", 
                      "Gene structure and ookinete expression of the chitinase genes of Plasmodium vivax and Plasmodium yoelii", 
                      "The Plasmodium vivax homolog of the ookinete adhesive micronemal protein CTRP", 
                      "Posttranslational generation of constitutively active cores from larger phosphatases in the malaria parasite Plasmodium falciparum implications for proteomics", 
                      "Mutually exclusive expression of Plasmodium falciparum 3 genes is developmentally controlled at the level of transcription initiation", 
                      "Developmental regulation of a Plasmodium gene involves the generation of stagespecific 5 untranslated sequences", 
                      "Genomic representation of var gene sequences in Plasmodium falciparum field isolates from different geographic regions", 
                      "Allelic forms of the knob associated histidinerich protein gene of Plasmodium falciparum", 
                      "Sequence variation of the hydroxymethyldihydropterin pyrophosphokinase dihydropteroate synthase gene in lines of the human malaria parasite Plasmodium falciparum with differing resistance to sulfad...", 
                      "Isolation and expression of a gene specifying a cdc2like protein kinase from the human malaria parasite Plasmodium falciparum", 
                      "The calmodulin gene of Plasmodium falciparum is not amplified or overexpressed in chloroquine resistant or sensitive isolates", 
                      "Transmission vaccine candidate Pvs28 Korean isolate", "The analysis of Plasmodium vivax Duffy receptor binding domain gene sequence from resurgent Korea isolates", 
                      "Misclassification of Drug Failures in Plasmodium falciparum Clinical Trials in Southeast Asia", 
                      "Diagnostic Difficulties with Plasmodium knowlesi Infection in Humans", 
                      "African apes as reservoirs of Plasmodium falciparum and the origin and diversification of the Laverania subgenus", 
                      "Phylogenetic and structural information on glyceraldehyde3phosphate dehydrogenaseG3PDH in Plasmodium provides functional insights", 
                      "Positive Selection on epitopes and recombination have shaped the haplotype structure of the ligand domain of Plasmodium vivax Duffy Binding Protein", 
                      "Chloroquine resistant Plasmodium vivax in vitro characterisation and association with molecular polymorphisms", 
                      "Polymorphism patterns in Duffybinding protein among Thai Plasmodium vivax isolates", 
                      "Wide variation in microsatellite sequences within each Pfcrt mutant haplotype", 
                      "Plasmodium vivax dhfr and dhps mutations in isolates from Madagascar and therapeutic response to sulfadoxinepyrimethamine", 
                      "Analysis of drug resistance genes in Plasmodium falciparum Indian isolates", 
                      "Analysis of dihydrofolate reductaseDHFR and dihydropteroate synthaseDHPS genes of Plasmodium vivax from Bikaner India", 
                      "Origins of sequence diversity in the malaria vaccine candidate merozoite surface protein2MSP2 in Amazonian isolates of Plasmodium falciparum", 
                      "Alteration in host cell tropism limits the efficacy of immunization with a surface protein of malaria merozoites", 
                      "Sequence variations in the genes encoding dihydropteroate synthase and dihydrofolate reductase and clinical response to sulfadoxinepyrimethamine in patients with acute uncomplicated falciparum malaria", 
                      "The Plasmodium HU homolog which binds the plastid DNA sequenceindependent manner is essential for the parasites survival", 
                      "Characterization of the pfmdr2 gene for Plasmodium falciparum", 
                      "A monkeys tale the origin of Plasmodium vivax as a human malaria parasite", 
                      "Molecular cloning of a novel asparaginerich protein gene from Plasmodium falciparum", 
                      "Amplification cloning and sequence analysis of the gene Gp185 of Plasmodium falciparum isolate FCC1HN", 
                      "Morphologic host specificity and genetic characterization of a European Cryptosporidium andersoni isolate", 
                      "PCRRFLP Analysis of a DNA Diagnosis 452 bp Fragment Discriminates Between C parvum and C meleagridis and Between C parvum isolates of Human and Animal Origin", 
                      "The cloning and sequence analysis of alpha and beta tubulin from Cryptosporidium parvum", 
                      "Analysis of sequence diversity at the highly polymorphic Cpgp4015 locus among Cryptosporidium isolates from human immunodeficiency virusinfected children in South Africa", 
                      "Genetic diversity of Cryptosporidium isolates from Thai patients", 
                      "Molecular characterization of a Cryptosporidium isolate from a black bear", 
                      "Cryptosporidium parvum infection involving novel genotypes in wildlife from lower New York State", 
                      "Molecular Characterization of the Cryptosporidium parvum IOWA Isolate Kept in Different Laboratories", 
                      "Genetic diversity within Cryptosporidium hominis and Cryptosporidium parvum from imported and autochtonous cases of human cryptosporidiosis in the United Kingdom", 
                      "Prevalence and genetic characterization of Cryptosporidium isolates from common brushtail possumsTrichosurus vulpecula adapted to urban settings", 
                      "Molecular characterization of the Cryptosporidium cervine genotype from a sika deerCervus nippon Temminck in Zhengzhou China and literature review", 
                      "Classification of Cryptosporidium species from patients with sporadic cryptosporidiosis by use of sequencebased multilocus analysis following mutation scanning", 
                      "Genetic diversity and zoonotic potential of Cryptosporidium parvum causing foal diarrhea", 
                      "Biological and molecular characterization of Cryptosporidium canis isolated in China", 
                      "Genotyping of Cryptosporidium from HIV patients and from cattle in Thailand after comparative detection by AFS and PCR", 
                      "Subtype analysis of Cryptosporidium isolates from humans and calves in Slovenia", 
                      "Multilocus analysis of Cryptosporidium hominis and Cryptosporidium parvum from sporadic and outbreakrelated human cases and C parvum from sporadic cases in livestock in the UK", 
                      "The prevalence of Cryptosporidium species and subspecies in human fecal samples in Ireland", 
                      "Genotypic Characterization of Cryptosporidium in Southern Michigan Surface Waters", 
                      "Molecular characterization of Cryptosporidium isolates from pigs in Zaragozanortheastern Spain", 
                      "Natural infection with zoonotic subtype of Cryptosporidium parvum in CapybaraHydrochoerus hydrochaeris from Brazil", 
                      "Cryptosporidium and Giardia in MarineForaging River OttersLontra canadensis From the Puget Sound Georgia Basin Ecosystem", 
                      "Three drinkingwaterassociated cryptosporidiosis outbreaks Northern Ireland", 
                      "Cryptosporidium andersoni strain AnhuiCA 18S ribosomal RNA gene", 
                      "Direct Submission", "Phylogenetic analysis implicates birds as an important source of Cryptosporidium spp oocysts in agricultural watersheds", 
                      "Characterization of Cryptosporidium canis isolated in Japan", 
                      "The Identification of Cryptosporidium Species by PCRRFLP Analysis of the 18S rRNA Gene", 
                      "Polyphasic typing of Cryptosporidium baileyi a suggested model for characterization of cryptosporidia", 
                      "Cryptosporidium struthionis nsp from ostrichesStruthio camelus", 
                      "Genetic characterization of Cryptosporidium isolates from Bangladeshi children with diarrhea", 
                      "Cloning and sequence analysis of a highly polymorphic Cryptosporidium parvum gene encoding a 60kilodalton glycoprotein and characterization of its 15 and 45kilodalton zoite surface antigen products", 
                      "Sequence of the internal transcribed spacer 1 of the rRNA unit of Cryptosporidium baileyi", 
                      "Cryptosporidium parvum genomic library sequencing using a novel screening approach", 
                      "Isolation of the gene coding for elongation factor1alpha in Cryptosporidium parvum", 
                      "Potential antifolate resistance determinants and genotypic variation in the bifunctional dihydrofolate reductasethymidylate synthase gene from human and bovine isolates of Cryptosporidium parvum", 
                      "PCRRFLP analysis of the Cryptosporidium oocyst wall proteinCOWP gene discriminates between C wrairi and C parvum and between C parvum isolates of human and animal origin", 
                      "Characterization and immunolocalization of a Cryptosporidium protein containing a repeated amino acid motif", 
                      "Development of a PCR protocol for sensitive detection of Cryptosporidium oocysts in water samples", 
                      "Small Subunit rRNA Sequence of Cryptosporidium wrairiguinea pig isolate", 
                      "Prevalence and agerelated variation of Cryptosporidium species and genotypes in dairy calves", 
                      "Zoonotic species of Cryptosporidium are as prevalent as the anthroponotic in HIVinfected patients in Thailand", 
                      "The Cryptosporidium oocyst wall protein is a member of a multigene family and has a homolog in Toxoplasma", 
                      "A redescription of Cryptosporidium galli Pavlasek 1999Apicomplexa Cryptosporidiidae from birds", 
                      "Intraisolate variation of Cryptosporidium parvum small subunit ribosomal RNA genes from human hosts in England", 
                      "A population genetic study of the Cryptosporidium parvum human genotype parasites", 
                      "Molecular phylogeny and evolutionary relationships of Cryptosporidium parasites at the actin locus", 
                      "Cryptosporidium isolated from mouse feces", "Cloning of the eIF4A translation initiation factor gene of Cryptosporidium parvum", 
                      "Cryptosporidium parvum functional complementation of a parasite transcriptional coactivator CpMBF1 in yeast", 
                      "Large sequence variation at two microsatellite loci in Cryptosporidium parvum isolates from Italy", 
                      "Unusual Cryptosporidium species recovered from human faeces first description of Cryptosporidium felis and Cryptosporidiumdog type from patients in England", 
                      "Giardia duodenalis and Cryptosporidium Spp in the Intestinal Contents of Ringed SealsPhoca hispida and Bearded SealsErignathus barbatus in Nunavik Quebec Canada", 
                      "A New Species of CryptosporidiumApicomplexa Cryptosporidiidae from Eastern Grey KangaroosMacropus giganteus", 
                      "Development of a Multilocus Sequence Typing Tool for Cryptosporidium hominis", 
                      "Cryptosporidium 18SrDNA isolated from a river in Japan", "Subgenotype analysis of Cryptosporidium isolates from humans and cattle in Slovenia using the 60 kDa glycoprotein gene sequences", 
                      "Biological and molecular characterization of a Cryptosporidium isolate from ostriches and genetical analysis of hostadapted Cryptosporidium sp in avians", 
                      "Molecular epidemiology of Cryptosporidium in humans and cattle in The Netherlands", 
                      "Multilocus phylogenetic analysis of Cryptosporidium andersoniApicomplexa isolated from a bactrian camelCamelus bactrianus in China", 
                      "Phylogenetic analysis of Cryptosporidium parasites based on different gene loci", 
                      "First report of the Cryptosporidium pig genotype II in immunocompetent human patient", 
                      "Cryptosporidium meleagridis isolated from HIVinfected woman in Poland", 
                      "Transmission Dynamics of Cryptosporidium Infection in a Natural Population of NonHuman Primates at Polonnaruwa Sri Lanka", 
                      "Prevalence of Cryptosporidium species in intensively farmed pigs in Ireland", 
                      "Adaptation of Cryptosporidium oocysts to different excystation conditions", 
                      "Cryptosporidium parvum from dairy calves at the Rural University of Rio de Janeiro", 
                      "Molecular identification of a Cryptosporidium saurophilum from corn snakeElaphe guttata guttata", 
                      "Molecular characterization of a Cryptosporidium isolate from a banded mongoose Mungos mungo", 
                      "Tracking Host Sources of Cryptosporidium spp in Raw Water for Improved Health Risk Assessment", 
                      "Cryptosporidium hominis Infection of the Human Respiratory Tract", 
                      "Cryptosporidium parvum partial 18S rRNA gene isolate BH6", "Molecular diagnosis of Cryptosporidiosis in northwest EnglandUK", 
                      "Sample prevalence and molecular characterisation of Cryptosporidium andersoni within a dairy herd in the United Kingdom", 
                      "Methods to identify pig Cryptosporidia", "Genetic analysis of Cryptosporidium from 2414 humans with diarrhoea in England between 1985 and 2000", 
                      "Mixed Cryptosporidium Infections and HIV", "Cryptosporidium parvum Infections in Bergen Norway during an Extensive Outbreak of Waterborne Giardiasis in Autumn and Winter 2004", 
                      "Molecular identification of Cryptosporidium spp in animal and human hosts from the Czech Republic", 
                      "PCR cloning and nucleotide sequence determination of the 18S rRNA genes and internal transcribed spacer 1 of the protozoan parasites Cryptosporidium parvum and Cryptosporidium muris", 
                      "Sequence and PCRRFLP analysis of the internal transcribed spacers of the rDNA repeat unit in isolates of Cryptosporidium from different hosts", 
                      "Genotyping of Cryptosporidium isolates from Chamelea gallina clams in Italy", 
                      "Cryptosporidium meleagridis from humans molecular analysis and description of affected patients", 
                      "Molecular characterization of Cryptosporidium sp isolated from northern Alaskan caribouRangifer tarandus", 
                      "Identification of multiple genotypes of Cryptosporidium meleagridis in birds and humans", 
                      "Cryptosporidium parvum bovine genotype thrombospondinrelated adhesive proteinTRAPC2 gene", 
                      "Cryptosporidium parvum PCRRFLP analysis of the TRAPC1thrombospondinrelated adhesive protein of Cryptosporidium1 gene discriminates between two alleles differentially associated with parasite isolat...", 
                      "The identification and characterisation of an unusual genotype of Cryptosporidium from human faeces as Cryptosporidium meleagridis", 
                      "The idetification of Cryptosporidium parvum subtype by PCRRFLP and sequence using COWP and 18S rRNA gene", 
                      "Cryptosporidium sp 18S small subunit ribosomal RNA gene isolated from sheep in Iran", 
                      "Genotyping of Cryptosporidium spp from environmental samples as source of information of species dispersion in the environment", 
                      "Multilocus sequence typing of Cryptosporidium found in a cohort of Dutch patients with diarrhea", 
                      "Genotyping of Giardia and Cryptosporidium from dogs and cats in Germany", 
                      "Prevalence and genotyping of Cryptosporidium species from farm animals in Mongolia", 
                      "Prevalence and Genetic Analysis of Cryptosporidium in Cattle Farms in Eastern China", 
                      "Multilocus analysis of Cryptosporidium hominis and Cryptosporidium parvum from sporadic and outbreakrelated human cases and Cryptosporidium parvum from sporadic cases in livestock in the UK", 
                      "Cryptosporidiosis in two regions of Saudi Arabia", "Comparison of method 1623 and cell culturePCR for detection of Cryptosporidium spp in source waters", 
                      "Cryptosporidium genotypes in wildlife from a New York watershed", 
                      "Molecular characterization of Cryptosporidium from animal sources in Qinghai province of China", 
                      "Detection and genotyping of Cryptosporidium from brown ratsRattus norvegicus captured in an urban area of Japan", 
                      "Molecular and phylogenetic characterization of Cryptosporidium and Giardia from pigs and cattle in Denmark", 
                      "Derivation of Cryptosporidium hominis clones", "Unique endemicity of cryptosporidiosis in children in kuwait", 
                      "Characterization of a Cryptosporidium isolate from water buffaloBubalus bubalis by sequencing of a fragment of the Cryptosporidium oocyst wall protein geneCOWP", 
                      "Molecular diagnosis of Cryptosporidiosis in central Iran", "Identification of novel Cryptosporidium genotypes from Avian Hosts", 
                      "Rapid and sensitive detection of single cryptosporidium oocysts from archived glass slides", 
                      "Identification of Cpgp4015 Type Ib as the Predominant Allele in Isolates of Cryptosporidium spp from a Waterborne Outbreak of Gastroenteritis in South Burgundy France", 
                      "Phylogenetic Analysis of Cryptosporidium Parasites Based on Different Gene Locus", 
                      "Sequence polymorphism in the betatubulin gene reveals heterogeneous and variable population structures in Cryptosporidium parvum", 
                      "Comparing DNA sequence between California isolates of Cryptosporidium parvum", 
                      "Molecular analysis of the 18S rRNA gene fragment of Cryptosporidium parasites from people living in Kenya Malawi Brazil UK and Vietnam in relation to HIV infection", 
                      "Electrophoretic analysis of genetic variability within Cryptosporidium parvum from imported and autochthonous cases of human cryptosporidiosis in the United Kingdom", 
                      "Epidemiology of intestinal parasites in relation to HIV with special reference to Cryptosporidium", 
                      "Cryptosporidium parvum glycoprotein 60gp60 gene sequnece", "Cryptosporidium parvum 18S rRNA partial gene sequence", 
                      "Genetic diversity of Cryptosporidium spp in captive reptiles", 
                      "Microsatellite analysis of Cryptosporidium hominis and C parvum in Portugal a preliminary study", 
                      "Genotyping of Cryptosporidium spp isolated from human stool samples in Switzerland", 
                      "Intraspecies Polymorphism of Cryptosporidium parvum Revealed by PCRRestriction Fragment Length PolymorphismRFLP and RFLPSingleStrand Conformational Polymorphism Analyses", 
                      "Identification of Novel Cryptosporidium Genotypes from the Czech Republic", 
                      "Identification of a Novel Cryptosporidium Genotype in Pigs", 
                      "Molecular characterization of ribonucleotide reductase from Cryptosporidium parvum", 
                      "Novel cryptosporidium genotypes in sporadic cryptosporidiosis cases first report of human infections with a cervine genotype", 
                      "Expression of the highly polymorphic Cryptosporidium parvum Cpgp4015 gene in genotype I and II isolates", 
                      "Ribosomal RNA gene organization in Cryptosporidium parvum", 
                      "Cryptosporidium Species and Subtypes and Clinical Manifestations in Children Peru", 
                      "The polymorphic mucin antigens CpMuc4 and CpMuc5 are integral to Cryptosporidium parvum infection in vitro", 
                      "Wide geographic distribution of Cryptosporidium bovis and the deerlike genotype in bovines", 
                      "Subtype analysis of Cryptosporidium isolates from children in Uganda", 
                      "Prevalence and multilocus genotyping of Cryptosporidium and Giardia in nonoutbreak related cases of diarrhea", 
                      "Biological and molecular characterization of a cryptosporidium isolate from ostriches and genetical analysis of hostadapted Cryptosporidium spp in avians", 
                      "Prevalence and molecular characterization of Cryptosporidium spp in cattle in Qazvin province Iran", 
                      "Molecular characterization of a new genotype of Cryptosporidium from American minksMustela vison in China", 
                      "Molecular characterization of Cryptosporidium isolates from pigs at slaughterhouses in South Bohemia Czech Republic", 
                      "Infectivity pathogenicity and genetic characteristics of mammalian gastric Cryptosporidium spp in domestic ruminants", 
                      "Prevalence and phylogenetic analysis of cryptosporidium in pigs in eastern china", 
                      "Molecular identification of Cryptosporidium spp from fecal samples of felines canines and bovines in the state of Sao Paulo Brazil", 
                      "Molecular analysis of Cryptosporidium species of cattle origin around water resources in Malaysia", 
                      "Molecular characterisation of Giardia duodenalis in captive nonhuman primates reveals mixed assemblage A and B infections and novel polymorphisms", 
                      "Ultrastructural localization of giardins to the edges of disk microribbons of Giarida lamblia and the nucleotide and deduced protein sequence of alpha giardin", 
                      "Multilocus genotyping of Giardia duodenalis reveals striking differences between assemblages A and B", 
                      "Genotyping of Giardia isolates from Swedish animals", "Occurrence and genotype characterization of Giardia duodenalis in goat kids from the Canary Islands Spain", 
                      "Molecular identification of Giardia spp in humans and animals in Western Poland", 
                      "Giardia infections in Cuban children genotypes circulating in a rural population", 
                      "LNA probes in a realtime TaqMan PCR assays for genotyping of Giardia duodenalis in wastewaters", 
                      "Detection and comparison of giardiavirusGLV from different assemblages of Giardia duodenalis", 
                      "Genotyping of Giardia duodenalis from Southern Brown Howler MonkeysAlouatta clamitans from Brazil", 
                      "The role of aquatic birds in the dissemination of human pathogenic Giardia duodenalis cysts and Cryptosporidium oocysts in Hungary", 
                      "Isolation characterization and expression of the gene encoding cytidine triphosphate synthetase from Giardia intestinalis", 
                      "High intragenotypic diversity of Giardia duodenalis in dairy cattle on three farms", 
                      "Analysis of vsp72like sequences in Giardia intestinalis", "Guanine nucleotidebinding proteins in the intestinal parasite Giardia lamblia Isolation of a gene encoding an approximately 20kDa ADPribosylation factor", 
                      "Phylogenetic meaning of the kingdom concept an unusual ribosomal RNA from Giardia lamblia", 
                      "The molecular epidemiology of giardiasis in southwest London", 
                      "Genotype characterization of Giardia duodenalis isolated from water samples collected from a zoo", 
                      "Molecular characterization of Giardia isolates from calves and humans in a region in which dairy farming has recently intensified", 
                      "Genotyping of Giardia isolates from humans in Japan using the small subunit ribosomal RNA and glutamate dehydrogenase gene sequences", 
                      "Detection and genotyping of Giardia duodenalis in Oreto riverSicily Southern Italy", 
                      "Genetic exchange within and between assemblages of Giardia intestinalis", 
                      "The vacuolar proteolipid of Giardia evolution of VFAATPase function reflections on the prokaryoteeukaryote transition", 
                      "Genetic polymorphism of the Iranian isolates of Giardia lamblia", 
                      "Molecular characterization of Giardia intestinalis haplotypes in marine animals variation and zoonotic potential", 
                      "Detection of Assemblage A Giardia duodenalis and Eimeria spp in alpacas on two Maryland farms", 
                      "Occurrence and molecular characterization of Cryptosporidium and Giardia in captive wild ruminants in Belgium", 
                      "Primary structure of a putative adenylate kinase gene of Giardia lamblia", 
                      "Detection and genotyping of Giardia isolated from recreational lake water in Malaysia", 
                      "Regulation of cyst wall protein promoters by Myb2 in Giardia lamblia", 
                      "Limitations of TPI and BG subgenotyping for characterization of human Giardia duodenalis isolates", 
                      "Characterization of a UPF1 gene involved in nonsensemediated mRNA decay in Giardia lamblia", 
                      "Identification of genotypes of Giardia intestinalis isolates from a human and calf in Japan", 
                      "Role of calcium signaling in excystation of the earlydiverging eukaryote Giardia lamblia", 
                      "Genomic minimalism in the early diverging intestinal parasite Giardia lamblia", 
                      "The assemblage A genotype of Giardia in ferret might be ferret specific", 
                      "Characterization of cytidine triphosphate synthetase involved in the pyrimidine salvage pathway of a human intestinal parasite Giardia intestinalis", 
                      "Analysis of the geographical distribution of genotypes of Giardia intestinalis by polymerase chain reaction", 
                      "Allelespecific expression of a variantspecific surface proteinVSP of Giardia lamblia", 
                      "Characterization of a Giardia lamblia variantspecific surface proteinVSP gene from isolate GSM and estimation of the VSP gene repertoire size", 
                      "Incomplete nonsensemediated mRNA decay in Giardia lamblia", 
                      "Zoonotic genotype of Giardia intestinalis detected in a ferret", 
                      "Molecular epidemiology of giardiasis in southwest London", "Molecular identification of Giardia sp in humans and animals in western Poland", 
                      "LNA probes in a realtime TaqMan PCR assay for genotyping of Giardia duodenalis in wastewaters", 
                      "Identification of developmentally regulated transcripts in Giardia lamblia by differential mRNA display", 
                      "The 3 terminal region of a gene encoding a cysteinerich surface protein in Giardia duodenalis", 
                      "Classification of subgroups of Giardia lamblia based upon ribosomal RNA gene sequence using the polymerase chain reaction", 
                      "A novel Mybrelated protein involved in transcriptional activation of encystation genes in Giardia lamblia", 
                      "Epidemiology and multilocus genotyping of Cryptosporidium and Giardia in nonoutbreak related cases of diarrhea", 
                      "Multilocus typing of Giardia duodenalis human isolates of cases imported from tropical areas", 
                      "Evaluation of alphatubulin as antigenic and molecular probes to detect Giardia lamblia", 
                      "Giardia lamblia Immunogenicity and intracellular distribution of GHSP115 a member of the Giardia headstalk family of proteins", 
                      "Identification of 11 new tRNAs from the primitive eukaryote Giardia lamblia", 
                      "Molecular characterization of Giardia intestinalis and Cryptosporidium isolated from peninsular Malaysian aborigine", 
                      "Identification of genotypes of Giardia intestinalis of human isolates in Egypt", 
                      "Atypical Initiator Elements in Giardia lamblia", "Molecular tools for the study of recurrent giardiasis", 
                      "Molecular genetic analysis of Giardia intestinalis isolates at the glutamate dehydrogenase locus", 
                      "Giardia lamblia mRNA for elongation factor 2", "Molecular identification of Giardia spp in humans and animals in western Poland", 
                      "Mapping variation in chromosome homologues of different Giardia strains", 
                      "Complementation of an Escherichia coli glycolysis mutant by Giardia lamblia triosephosphate isomerase", 
                      "Genotyping of the Giardia intestinalis isolates from dogs in Osaka City Japan", 
                      "The Santigen of Plasmodium falciparum Palo Alto represents a new Santigen serotype", 
                      "Molecular analysis of Plasmodium falciparum hexokinase", "Point mutations in the dihydrofolate reductasethymidylate synthase gene as the molecular basis for pyrimethamine resistance in Plasmodium falciparum", 
                      "Does biased gene conversion influence polymorphism in the circumsporozoite proteinencoding gene of Plasmodium vivax", 
                      "Application of RealTime PCR for Detection of pfcrt Single Nucleotide Polymorphisms in Plasmodium falciparum in Southeast Iran", 
                      "Plasmodium falciparum gene encoding a protein similar to the 78kDa rat glucoseregulated stress protein", 
                      "Molecular cloning and sequencing of the merozoite surface antigen 2 gene from Plasmodium falciparum strain FCC1HN and expression of the gene in mycobacteria", 
                      "Characterization of antigenexpressing Plasmodium falciparum cDNA clones that are reactive with parasite inhibitory antibodies", 
                      "A Plasmodium falciparum antigen containing clusters of asparagine residues", 
                      "Integral membrane protein located in the apical complex of Plasmodium falciparum", 
                      "Sequence variation in Santigen genes of Plasmodium falciparum", 
                      "A role for immune responses against nonCS components in the crossspecies protection induced by immunization with irradiated malaria sporozoites", 
                      "Regulation and trafficking of three distinct 18 S ribosomal RNAs during development of the malaria parasite", 
                      "Plasmodium liver stage developmental arrest by depletion of a protein at the parasitehost interface", 
                      "Implication of a Plasmodium falciparum gene in the switch between asexual reproduction and gametocytogenesis", 
                      "Low malaria prevalence seasonal changes and genetic complexity of Plasmodium vivax infections in Sri Lanka", 
                      "Point mutations in the Plasmodium falciparum cg2 gene polymorphism of the kappa repeat region and their relationship with chloroquine resistance", 
                      "High complexity of Plasmodium vivax infections in Papua New Guinean children", 
                      "Mosaic organization and heterogeneity in frequency of allelic recombination of the Plasmodium vivax merozoite surface protein1 locus", 
                      "Ageacquired immunity to a Plasmodium vivax invasion ligand the duffy binding protein", 
                      "High level of conservation in Plasmodium vivax merozoite surface protein 4PvMSP4", 
                      "Plasmodium vivax 18S rRNA genes from BrazilRondonia Acrelandia and Sri LankaKataragama", 
                      "Plasmodium falciparum merozoite surface protein 6 is a dimorphic antigen", 
                      "Construction of eukaryotic expression plasmid and sequence analysis of ABRA gene of Plasmodium falciparum acidic basic repeat antigen ABRA", 
                      "Genetic polymorphism of merozoite surface protein 7MSP7 of Plasmodium vivax", 
                      "Association between particular polymorphic residues on apical membrane antigen 1AMA1 and platelet levels in patients with vivax malaria", 
                      "Molecular genetic characterization of the merozoite surface protein 1 Gene of Plasmodium vivax from reemerging Korean isolates", 
                      "Plasmodium falciparum drugtransporter gene transcripts tuning with cell cycle after mefloquine exposure", 
                      "Mutations in the P falciparum digestive vacuole transmembrane protein PfCRT and evidence for their role in chloroquine resistance", 
                      "MAHRP1 a novel Plasmodium falciparum histidinerich protein binds ferriprotoporphyrin IX and localizes to the Maurers clefts", 
                      "Cloning and sequence analysis of GDH gene of Plasmodium falciparum isolate FCC1HN", 
                      "Cloning and sequence characterisation of falcipain2 from Plasmodium falciparum Gombak A strain", 
                      "Isolation and identification of the replication factor C subunit 2 gene from the human malaria parasite Plasmodium falciparum", 
                      "Isolation and characterisation of a cAMPdependent protein kinase catalytic subunit gene from Plasmodium falciparum", 
                      "Identification of the Plasmodium chabaudi homologue of merozoite surface proteins 4 and 5 of Plasmodium falciparum", 
                      "The putative gene for the first enzyme of glutathione biosynthesis in Plasmodium berghei and Plasmodium falciparum", 
                      "Molecular characterization of the second mitogenactivated protein kinase gene from the human malaria parasite Plasmodium falciparum", 
                      "Molecular interactions between Anopheles stephensi midgut cells and Plasmodium berghei the time bomb theory of ookinete invasion of mosquitoes", 
                      "Tcell epitope polymorphisms of the Plasmodium falciparum circumsporozoite protein among field isolates from Sierra Leone agedependent haplotype distribution", 
                      "Structure and function of a Gactin sequestering protein with a vital role in malaria oocyst development inside the mosquito vector", 
                      "The rodent malaria parasite Plasmodium berghei does not contain a typical Otype small subunit ribosomal RNA gene", 
                      "Identification of the transcription initiation site of the asexually expressed rRNA genes of the malaria parasite Plasmodium berghei", 
                      "Molecular cloning characterization and localization of PfPK4 an eIF2alpha kinaserelated enzyme from the malarial parasite Plasmodium falciparum", 
                      "Primary structure of a novel ookinete surface protein from Plasmodium berghei", 
                      "Nucleotide sequence of the Plasmodium berghei circumsporozoite protein gene from the ANKA clone 234L", 
                      "unknown", "The sequence of Stype SSU rRNA from Plasmodium yoelii yoelii and detection of parasite within mosquito", 
                      "Cloning and expression of genomic DNA sequences coding for putative erythrocyte membraneassociated antigens of Plasmodium falciparum", 
                      "Multicharacter population study of the vir subtelomeric multigene superfamily of Plasmodium vivax a major human malaria parasite", 
                      "Extensive heterozygosity at four microsatellite loci flanking Plasmodium vivax dihydrofolate reductase gene", 
                      "Plasmodium falciparum from Para stateBrazil shows adequate in vitro response to artemisinin derivatives and absence of the S769N mutation in the SERCAtype PfATPase6", 
                      "Population genomics of the immune evasionvar genes of Plasmodium falciparum", 
                      "Variable SNP density in aspartylprotease genes of the malaria parasite Plasmodium falciparum", 
                      "Global genetic diversity and evolution of var genes associated with placental and severe childhood malaria", 
                      "Plasmodium falciparum biochemical characterization of the cysteine protease falcipain2", 
                      "Rare Congolese Plasmodium falciparum DHFR alleles", "Genetic diversity of merozoite surface protein 1 of Plasmodium vivax isolates in South Korea", 
                      "Polymorphism of the vaccine candidate Merozoite surface protein1 of Plasmodium falciparum in field isoaltes", 
                      "Structural metal dependency of the arginase from the human malaria parasite Plasmodium falciparum", 
                      "Strong diversifying selection on domains of the Plasmodium falciparum apical membrane antigen 1 gene", 
                      "Realtime in vivo analysis of malaria ookinete locomotion and mosquito midgut invasion", 
                      "Polymorphism studies of ribosomal phosphoprotein in Indian field isolates of plasmodium falciparum", 
                      "Effect of var gene disruption on switching in Plasmodium falciparum", 
                      "Plasmodium cysteine repeat modular proteins 14 complex proteins with roles throughout the malaria parasite life cycle", 
                      "Variation among circumsporozoite protein genes from rodent malarias", 
                      "The structure of the calmodulin gene of Plasmodium falciparum", 
                      "Strainspecific immunity may drive adaptive polymorphism in the merozoite surface protein 1 of the rodent malaria parasite Plasmodium chabaudi", 
                      "Molecular Cloning and Sequence Analysis for the Gene of Lactate Dehydrogenase from Plasmodium vivaxHainan Strain", 
                      "Comparison of two members of a multigene family coding for highmolecular mass rhoptry proteins of Plasmodium yoelii", 
                      "Analysis of Plasmodium vivax merozoite surface protein1 gene sequences from resurgent Korean isolates", 
                      "Characteristics of MSP1 genes in Plasmodium vivax Korean isolates", 
                      "Cloning and Sequence analysis of HRPIII gene of Plasmodium falciparum", 
                      "Sequence of actin I gene of Plasmodium falciparumisolate FCC1HN", 
                      "Molecular typing of Plasmodium falciparum from Giemsastained blood smears confirms nosocomial malaria transmission", 
                      "Antigenic and sequence diversity at the Cterminus of the merozoite surface protein1 from rodent malaria isolates and the binding of protective monoclonal antibodies", 
                      "DRAMATIC DIFFERENCE IN DIVERSITY BETWEEN PLASMODIUM FALCIPARUM AND PLASMODIUM VIVAX RETICULOCYTE BINDINGLIKE GENES", 
                      "Comparative structural analysis and kinetic properties of lactate dehydrogenases from the four species of human malarial parasites", 
                      "Plasmodium falciparum polymorphism in regions II and III of the knobassociated histidinerich protein gene from two areas of different endemicity", 
                      "Cloning of FEN1 from Plasmodium falciparum HNFCC1", "Characterization of a membraneassociated rhoptry protein of Plasmodium falciparum", 
                      "Sequence analysis of the MSP 1 gene of Plasmodium falciparum isolates from Hainan China", 
                      "Partial sequence of circumsporozoite protein gene", "Complex transcription from the extrachromosomal DNA encoding mitochondrial functions of Plasmodium yoelii", 
                      "Plasmepsin 4 the food vacuole aspartic proteinase found in all Plasmodium spp infecting man", 
                      "Nucleotide sequence of the MESApp300PfEMP2 gene of the Honduras ICDC isolate of the human malaria parasite Plasmodium falciparum", 
                      "Cloning and characterization of Plasmodium falciparum homologs of nuclear import factors karyopherin alpha and karyopherin beta", 
                      "Apical location of a novel EGFlike domaincontaining protein of Plasmodium falciparum", 
                      "Partial nucleotide sequence and organisation of extrachromosomal plastidlike DNA in Plasmodium berghei", 
                      "Identification of a region of PfEMP1 that mediates adherence of Plasmodium falciparum infected erythrocytes to CD36 conserved function with variant sequence", 
                      "Protein phosphatase beta a putative type2A protein phosphatase from the human malaria parasite Plasmodium falciparum", 
                      "Genetic restriction in two conserved regions of Plasmodium falciparum EBA1751t", 
                      "Evidence of crosscontamination among laboratory lines of Plasmodium berghei", 
                      "Pfmrk a MO15related protein kinase from Plasmodium falciparum Gene cloning sequence stagespecific expression and chromosome localization", 
                      "Pgs28 belongs to a family of epidermal growth factorlike antigens that are targets of malaria transmissionblocking antibodies", 
                      "Plasmodium vivaxrecombination between potential allelic types of the merozoite surface protein MSP1 in parasites isolated from patients", 
                      "Plasmodium vivax favored gene frequencies of the merozoite surface protein1 and the multiplicity of infection in a malaria endemic region", 
                      "Gene encoding a deubiquitinating enzyme is mutated in artesunate and chloroquineresistant rodent malaria parasites", 
                      "Genetic polymorphism of merozoite surface protein 2MSP2 of Iranian Plasmodium falciparum strains", 
                      "A subfamily of common and highly conserved Plasmodium falciparum var genes", 
                      "DNA sequencing of circumsporozoite protein genes of Plasmodium vivax from four different countries in west Pacific region comparative study on the flank sequences", 
                      "Sequence of the Cterminal region of merozoite surface protein1MSP1 in fieldderived Plasmodium falciparum", 
                      "Plasmodium vivax MCQR1 multidrug resistance genemdr1", "A Plasmodium falciparum antigen located in stippled structures at the host eryhtrocyte cytoplasm", 
                      "Characterisation of the Carbamoyl Phosphate Synthetase Gene from Plasmodium falciparum", 
                      "Polymorphisms of the Plasmodium vivax microneme protein1", "Allelic variation in the circumsporozoite protein of Plasmodium falciparum from Thai field isolates", 
                      "Stagedependent localization of a novel gene product of the malaria parasite Plasmodium falciparum", 
                      "The novel Plasmodium falciparum sporozoite surface antigen MB2 An immune target for malaria vaccine development", 
                      "High prevalence of human antibodies to recombinant Duffy bindinglike alpha domains of the Plasmodium falciparuminfected erythrocyte membrane protein 1 in semiimmune adults compared to that in nonim...", 
                      "Plasmodium berghei thrombospondinrelated protein 3", "Analysis of CSP gene subtype of South Korea", 
                      "In vivo and in vitro derived Palo Alto lines of Plasmodium falciparum are genetically unrelated", 
                      "Homologous genes encode two distinct histidinerich proteins in a cloned isolate of Plasmodium falciparum", 
                      "Antigenic diversity in Thai Plasmodium vivax circumsporozoite proteins", 
                      "Recent independent evolution of msp1 polymorphism in Plasmodium vivax and related simian malaria parasites", 
                      "Structural polymorphism and diversifying selection on the pregnancy malaria vaccine candidate VAR2CSA", 
                      "Isolation and chromosomal mapping of the human B29 gene", "Plasmodium falciparum chloroquine resistance marker gene", 
                      "Identification of a Plasmodium falciparum gene encoding a putative cell division cycle component", 
                      "Plasmodium falciparum aldolase gene structure and localization", 
                      "Analysis of polymorphic regions of Plasmodium vivax Duffy binding protein of Korean isolates", 
                      "Expression and characterization of a 326 kDa tryptophanrich protein associated with asexual blood stages of Plasmodium vivax", 
                      "Genetic structure of Plasmodium vivax isolates from two malaria endemic areas in Afghanistan", 
                      "Two classes of plantlike vacuolartype Hpyrophosphatases in malaria parasites", 
                      "Unique Insert Sequences Within Carbamoyl Phosphate Synthetase II Gene From Plasmodium berghei and Plasmodium chabaudi", 
                      "Novel Point Mutations in the Dihydrofolate Reductase Gene of Plasmodium vivax Evidence for Sequential Selection by Drug Pressure", 
                      "Plasmodium falciparum Genetic Diversity of Cterminal region of MSP1 in isolates from Indian SubContinent", 
                      "The extent of nucleotide polymorphism is highly variable across a 3kb region on Plasmodium falciparum chromosome 2", 
                      "Sequence heterogeneity of the merozoite surface protein1 geneMSP1 of Plasmodium vivax wild isolates in southeastern Iran", 
                      "Plasmodium falciparum IgG subclass antibody response to merozoite surface protein1 among Amazonian gold miners in relation to infection status and disease expression", 
                      "Comparative analysis of molecular variation between Plasmodium falciparum and P reichenowi maebl gene", 
                      "Population strucuture and genetic diversity of Plasmodium vivax Duffy binding protein gene", 
                      "Plasmodium vivax merozoite surface protein PvMSP3 beta is radically polymorphic through mutation and large insertions and deletions", 
                      "Comparison of falcipain 2 gene sequence among multiple strains of Plasmodium falciparum", 
                      "Nucleotide sequence polymorphism at the apical membrane antigen1 locus reveals population history of Plasmodium vivax in Thailand", 
                      "Sexual stagespecific expression of a third calciumdependent protein kinase from Plasmodium falciparum", 
                      "dxs as a potential target for antimalerial drugs", "Sequence of Plasmodium falciparum MO15related protein kinase Pfmrk gene", 
                      "COS cell expression cloning of Pfg377 a Plasmodium falciparum gametocyte antigen associated with osmiophilic bodies", 
                      "A central role for P4845 in malaria parasite male gamete fertility", 
                      "Genetics of mefloquine resistance in the rodent malaria parasite Plasmodium chabaudi", 
                      "Characterization of a Plasmodium falciparum erythrocytebinding protein paralogous to EBA175", 
                      "Construction of eukaryote expression vector of phosphocholine cytidylyltransferase from Plasmodium falciparum", 
                      "Molecular characterization and ultrastructural localization of Plasmodium falciparum Hsp 60", 
                      "Characterization of a novel LCCL domaincontaining protein family expressed during the sexual stage of the Plasmodium life cycle", 
                      "Sequence of P falciparum gene for RAP2 protein", "Plasmodium falciparum allelic variation in the merozoite surface protein 1 gene in wild isolates from southern Vietnam", 
                      "Alu elements in a Plasmodium vivax antigen gene", "Characterization and complete nucleotide sequence of a 58S ribosomal RNA gene from Plasmodium falciparum", 
                      "Blood and sporozoite stagespecific small subunit ribosomal RNAencoding genes of the human malaria parasite Plasmodium vivax", 
                      "Establishing a physical map of chromosome4 of Plasmodium falciparum", 
                      "Mitochondrial DNA of the human malarial parasite Plasmodium falciparum", 
                      "Transition of Plasmodium vivax ribosome types corresponds to sporozoite differentiation in the mosquito", 
                      "Phylogenetic position of Blastocystis hominis and of stramenopiles inferred from multiple molecular sequence data", 
                      "Variations in the Cterminal repeats of the knobassociated histidinerich protein of Plasmodium falciparum", 
                      "Plasmodium vivax sexual stage antigen genes polymorphism", "Bottleneck effects on vaccinecandidate antigen diversity of malaria parasites in Thailand", 
                      "Conservation of the rhoptry protein Rhop3 among human and rodent Plasmodium species and its potential as a malaria vaccine candidate", 
                      "Sympatric Plasmodium falciparum isolates from Venezuela have structured var gene repertoires", 
                      "Analysis of stagespecific transcription in plasmodium falciparum reveals a set of genes exclusively transcribed in ring stage parasites", 
                      "A genefamily encoding small exported proteins is conserved across Plasmodium genus", 
                      "V1S target PF100018", "Differential transcriptome profiling identifies Plasmodium genes encoding preerythrocytic stagespecific proteins", 
                      "Sequence diversity of the erythrocyte membrane antigen 1 in various strains of Plasmodium chabaudi", 
                      "Effect of a MSP2 vaccine on msp2 genotypes of subsequent Plasmodium falciparum infections", 
                      "Molecular cloning of CTPphosphocholine cytidylyltransferase from Plasmodium falciparum", 
                      "Plasmodium knowlesi secondary processing of the malaria merozoite surface protein1", 
                      "Identification of proteins from Plasmodium falciparum that are homologous to reticulocyte binding proteins in Plasmodium vivax", 
                      "Structural Functional and Antigenic Analysis of PfEMP1 the Major Variant Surface Antigen of P falciparum Infected Erythrocytes", 
                      "A novel Plasmodium falciparum gene coding for an asparaginrich protein", 
                      "Structure and polymorphism of the upstream region of the pfg2725 gene transcriptionally regulated in gametocytogenesis of Plasmodium falciparum", 
                      "Sequence diversity and secondary structure predictions for the introns of the highly conserved Ag15 gene of Plasmodium falciparum", 
                      "Characterisation of the Cdc2related kinase 2 gene from Plasmodium knowlesi and P berghei", 
                      "Molecular cloning and characterization of a putative glutathione reductase gene the PfGR2 gene from Plasmodium falciparum", 
                      "Isolation of a third member of the Plasmodium falciparum glycophorinbinding protein gene family", 
                      "A large multigene family expressed during the erythrocytic schizogony of Plasmodium falciparum", 
                      "Cloning of a Ca2ATPase gene of Plasmodium falciparum and comparison with vertebrate Ca2ATPases", 
                      "Population structure and genetic diversity of Plasmodium vivax Duffy binding protein gene", 
                      "Human naturally acquired Plasmodium knowlesi infection from Kalimantan Indonesia", 
                      "Studies on Plasmodium knowlesi in Malaysian Borneo", "Plasmodium berghei PHIST domain containing protein", 
                      "DHPS of Plasmodium falciparum", "WARP gene in old world Plasmodium vivax isolates a regional Transmission Blocking VaccineTBV candidate", 
                      "On the Diversity of Malaria Parasites in African Apes and the Origin of Plasmodium falciparum from Bonobos", 
                      "Ookinete surface protein Pvs25 from Plasmodium vivax Korean isolate", 
                      "Differential selective pressures on the merozoite surface protein 2 locus of Plasmodium falciparum in a low endemic area", 
                      "Amplification and sequencing of antigen marker genes of the malarial parasite", 
                      "Plasmodium vivax sequence polymorphism and effect of natural selection at apical membrane antigen 1PvAMA1 among Indian population", 
                      "Studies on P knowlesi infections in Malaysian Borneo", "Nucleotide sequence polymorphism in the gene encoding erythrocyte bindinglike protein EBL1 in Kenyan Plasmodium falciparum field isolates", 
                      "Epitope mapping and topographic analysis of VAR2CSA DBL3X involved in P falciparum placental sequestration", 
                      "Molecular screening of Plasmodium falciparum resistance to artemisinin from Mbita region in Kenya", 
                      "Analysis of a cationtransporting ATPase of Plasmodium falciparum", 
                      "Plasmodium falciparum merozoite surface protein 2", "Genetic diversity in the block 2 region of the merozoite surface protein 1MSP1 of Plasmodium falciparum Potential problems with using block 2 as a molecular epidemiological marker", 
                      "Antigenic variation in malaria a 3 genomic alteration associated with the expression of a P knowlesi variant antigen", 
                      "Isolation of three distinct parasite populations expressing different circumsporozoite proteins from the Philippine strain of Plasmodium knowlesi", 
                      "The polymorphic subtelomeric regions of Plasmodium falciparum chromosomes contain arrays of repetitive sequence elements", 
                      "Nucleotide sequence of Plasmodium chabaudiadami DS MSP119", 
                      "Frequent and persistent asymptomatic Plasmodium falciparum infections in African infants characterized by multilocus genotyping", 
                      "Minimal variation in Pfs16 a novel protein located in the membrane of gametes and sporozoites of Plasmodium falciparum", 
                      "Glycolytic pathway of the human malaria parasite Plasmodium falciparum primary sequence analysis of the gene encoding 3phosphoglycerate kinase and chromosomal mapping studies", 
                      "Genetic mapping of the duffy binding proteinDBP ligand domain of Plasmodium vivax from unstable malaria region in the Middle East", 
                      "Two imported cases of malarial infection in Osaka City", "Cloning and sequencing of the gene for the ironsulfur subunit of succinate dehydrogenase of Plasmodium falciparum isolate FCC1HN", 
                      "Analysis of Plasmodium vivax merozoite surface protein gene sequence from resurgent Korean isolates", 
                      "Analysis of the structural diversity of Plasmodium falciparum merozoite surface protein 2MSP2 in Gambia", 
                      "Identification expression localization and serological characterization of a tryptophanrich antigen from the human malaria parasite Plasmodium vivax", 
                      "Construction of a prokaryotic expression plasmid and sequence analysis of the Pfs40 gene of Plasmodium falciparum HAINAN isolate", 
                      "Sequence diversity and molecular evolution of the merozoite surface antigen 2 of Plasmodium falciparum", 
                      "Plasmodium falciparum Rapid Turnover of var Gene Transcripts in vivo During Natural Nonsymptomatic Infections", 
                      "Analysis of genetic diversity at the ironcontaining superoxide dismutase locus in Plasmodium falciparum wild isolates", 
                      "Two Plasmodium falciparum genes express merozoite proteins that are related to Plasmodium vivax and Plasmodium yoelii adhesive proteins involved in host cell selection and invasion", 
                      "A Plasmodium heat shock protein of the Hsp20acrystallin family expressed in sexual and sporogonic life stages", 
                      "Sequences similar to genes for two mitochondrial proteins and portions of ribosomal RNA in tandemly arrayed 6kilobasepair DNA of a malarial parasite", 
                      "Sequence diversity and evolution of the malaria vaccine candidate merozoite surface protein1MSP1 of Plasmodium falciparum", 
                      "Investigation of the fibrillarin gene in the human malaria parasite Plasmodium falciparum", 
                      "Cloning and crossspecies comparison of the thrombospondinrelated anonymous proteinTRAP gene from Plasmodium knowlesi Plasmodium vivax and Plasmodium gallinaceum", 
                      "Cloning and sequence analysis of two different members of the HSP70 family from Plasmodium berghei", 
                      "Circumsporozoite proteinCSP PvSK1 from Plasmodium vivax South Korean isolate", 
                      "Genotyping and sequence analysis of glutamate rich proteinGLURP gene of Plasmodium falciparum isolates from Sistan and Bluchistan Iran", 
                      "Genotyping and sequence analysis of merozoite surface protein 1MSP1 block 2 of Plasmodium falciparum isolates from Sistan and Bluchistan Iran", 
                      "Sequence polymorphism in two novel Plasmodium vivax ookinete surface proteins Pvs25 and Pvs28 that are malaria transmissionblocking vaccine candidates", 
                      "Dihydrofolate Reductase I164L Mutation in Plasmodium falciparum Madagascar", 
                      "Low levels of polymorphism in the untranslated regions of three highly polymorphic genes in the human malaria parasite Plasmodium falciparum", 
                      "Analysis of singlenucleotide polymorphisms in the crto and mdr1 genes of Plasmodium vivax among chloroquineresistant isolates from the Brazilian Amazon region", 
                      "Identification of a novel allele family in block 2 of P falciparum merozoite surface protein 1", 
                      "Sequence variation in the circumsporozoite protein gene of Plasmodium vivax appears to be regionally biased", 
                      "Isolation of alpha and betatubulin genes of Plasmodium falciparum using a single oligonucleotide probe", 
                      "Analysis of CSP subtype of Plasmodium vivax in Korea", "Cloning the P falciparum gene encoding PfEMP1 a malarial variant antigen and adherence receptor on the surface of parasitized human erythrocytes", 
                      "Mechanisms of pyrimethamine resistance in two different strains of Plasmodium berghei", 
                      "Molecular variation in a novel polymorphic antigen associated with Plasmodium falciparum merozoites", 
                      "Molecular Biology of Pyrimidine Biosynthesis in the Human Malarial Parasite Plasmodium falciparum", 
                      "The gene encoding DNA polymerase alpha from Plasmodium falciparum", 
                      "A new member of the Plasmodium falciparum family of asparaginerich proteins", 
                      "Plasmodium falciparum molecular analysis of a putative protective antigen the thermostable 96kDa protein", 
                      "Lack of crossreactivity between variant T cell determinants from malaria circumsporozoite protein", 
                      "Analysis of elongation factor Tutuf A of apicoplast from Indian Plasmodium vivax isolates", 
                      "Genotyping and Sequencing Analysis of Merozoite surface Protein 2 of Plasmodium falciparum isolates from Hainan Province", 
                      "Plasmodium berghei and Plasmodium chabaudi Molecular cloning and characterization of the nuclear GTPase RanTC4", 
                      "Genetic diversity in the major merozoite surface antigen of Plasmodium falciparum high prevalence of a third polymorphic form detected in strains derived from malaria patients", 
                      "Genetic diversity in the major merozoite surface antigen of Plasmodium falciparum High prevalence of a third polymorphic form detected in strains derived from malaria patients", 
                      "Sequence comparison of allelic forms of the Plasmodium falciparum merozoite surface antigen MSA2", 
                      "Characterisation of the dihydrofolate reductasethymidylate synthetase gene from human malaria parasites highly resistant to pyrimethamine", 
                      "Circumsporozoite protein of Plasmodium berghei gene cloning and identification of the immunodominant epitopes", 
                      "Circumsporozoite gene of a Plasmodium falciparum strain from Thailand", 
                      "Identification of a polymorphic Plasmodium vivax microsatellite marker", 
                      "Analysis of adhesive domains from the A4VAR Plasmodium falciparum erythrocyte membrane protein1 identifies a CD36 binding domain", 
                      "Molecular cloning and partial sequence of a 58 kilobase pair repetitive DNA from Plasmodium falciparum", 
                      "Nucleotide sequence of a Plasmodium falciparum stress protein with similarity to mammalian 78kDa glucoseregulated protein", 
                      "The origin of malignant malaria", "Sequence of Plasmodium berghei glutathione reductase gene", 
                      "Sequencing and homologous analysis of the lactate hydrogenase gene from Plasmodium falciparumFCC1HN", 
                      "Demonstration of alternative splicing of a premRNA expressed in the blood stage form of Plasmodium falciparum", 
                      "Partial sequences of three new asparaginerich blood stage proteins of Plasmodium falciparum", 
                      "Human Plasmodium knowlesi infections in young children in central Vietnam", 
                      "Structural features of the large subunit rRNA expressed in Plasmodium falciparum sporozoites that distinguish it from the asexually expressed subunit rRNA", 
                      "The ribosomal DNA loci in Plasmodium falciparum accumulate mutations independently", 
                      "The structure of the large subunit rRNA expressed in blood stages of Plasmodium falciparum", 
                      "Pfgig A novel gene implicated by targeted gene disruption in the level of gametocyte production in Plasmodium falciparum isolate 3D7", 
                      "PfADA2 a Plasmodium falciparum homologue of the transcriptional coactivator ADA2 and its in vivo association with the histone acetyltransferase PfGCN5", 
                      "Genetic diversity of Plasmodium vivax Cterminal MSP1p42 in Sri Lanka", 
                      "The high molecular mass rhoptry protein RhopH1 is coded by a member of the CLAG multigene family in Plasmodium falciparum and P yoelii", 
                      "Cloning and expression of the glutamic acidrich protein gene of Plasmodium falciparum isolate FCC1HN", 
                      "Novel dhps and pfcrt polymorphisms in Plasmodium falciparum detected by heteroduplex tracking assay", 
                      "Polymorphism analysis of Plasmodium vivax merozoite surface protein 1Pvmsp1 gene from different malaria endemic area of China", 
                      "Molecular evolution and intragenic recombination of the merozoite surface protein MSP3alpha from the malaria parasite Plasmodium vivax in Thailand", 
                      "Polymorphism in the gene encoding the Pfs4845 antigen of Plasmodium falciparum XI Asembo Bay Cohort Project", 
                      "A study of genetic diversity in the gene encoding the circumsporozoite proteinCSP of Plasmodium falciparum from different transmission areasXVI Asembo Bay Cohort Project", 
                      "Variant proteins of Plasmodium vivax are not clonally expressed in natural infections", 
                      "Host switch leads to emergence of Plasmodium vivax malaria in humans", 
                      "Merozoite surface protein 45 provides protection against lethal challenge with a heterologous malaria parasite strain", 
                      "Cloning and characterization of a Plasmodium falciparum FCC1HN isloate serinerepeat antigen protein gene SERA", 
                      "Construction of eukaryotic expression plasmid and structure analysis of STARP gene of Plasmodium falciparum Hainan isolate", 
                      "Sequence of Plasmodium falciparum gene for surface protein Pfs25", 
                      "Evolution of Plasmodium vivax merozoite surface protein3 gene from Korea isolates1996 to 2006", 
                      "Plasmodium knowlesi in Human Indonesian Borneo", "Polymorphism at the apical membrane antigen 1 locus reflects the world population history of Plasmodium vivax", 
                      "GTP cyclohydrolase I gene of Plasmodium yoelii yoelii", "Repeat structures in a Plasmodium falciparum proteinMESA that binds human erythrocyte protein 41", 
                      "The Plasmodium vivax homologues of merozoite surface proteins 4 and 5 from Plasmodium falciparum are expressed at different locations in the merozoite", 
                      "Erythrocyte Binding domain of MAEBLM1 from Plasmodium vivax", 
                      "Plasmodium yoelii cloning and characterization of the gene encoding for the mitochondrial heat shock protein 60", 
                      "Close linkage of three merozoite surface protein genes on chromosome 2 of Plasmodium falciparum", 
                      "The GAM1 gene is not good as a polymorphic marker in Korean isolates of Plasmodium vivax", 
                      "Variation in the thrombospondinrelated adhesive proteinTRAP gene of Plasmodium falciparum from Thai field isolates", 
                      "P vivax MSP1", "A novel 70kDa Triton X114soluble antigen of Plasmodium falciparum that contains interspeciesconserved epitopes", 
                      "Direct sequencing of enzymatically amplified DNA of alleles of the merozoite surface antigen MSA1 gene from the malaria parasite Plasmodium falciparum", 
                      "Development of a DNA diagnostic probe for the detection of the human malarial parasite Plasmodium falciparum", 
                      "Sequence conservation in the Cterminal part of the precursor to the major merozoite surface proteinsMSP1 of Plasmodium falciparum from field isolates", 
                      "A Plasmodium falciparum aminopeptidase gene belonging to the M1 family of zincmetallopeptidases is expressed in erythrocytic stages", 
                      "Recombinant putative glutathione reductase of Plasmodium falciparum exhibits thioredoxin reductase activity", 
                      "Plasmodium falciparum further characterization of putative cation ATPases", 
                      "Polymorphism of the vaccine candidate Merozoite surface protein1 of Plasmoidum falciparum in Indian isolates", 
                      "Polymorphism of the vaccine candidate Merozoite surface protein1 in Indian isoaltes", 
                      "Plasmodium falciparum kroxlike gene", "A study of selected Plasmodium yoelii messenger RNAs during hepatocyte infection", 
                      "Resistance to a protein farnesyltransferase inhibitor in Plasmodium falciparum", 
                      "Expression of var genes located within polymorphic subtelomeric domains of Plasmodium falciparum chromosomes", 
                      "A rapid genotyping method for the vivax malaria transmissionblocking vaccine candidates Pvs25 and Pvs28", 
                      "Plasmodium faciparum pgh1", "Allelic polymorphism in the Plasmodium vivax dihydrofolate reductasePvdhfr gene among Indian isolates", 
                      "Assessing the genetic diversity of the aldolase genes of Plasmodium falciparum and Plasmodium vivax and its potential effect on performance of aldolasedetecting rapid diagnostic tests", 
                      "LSA3 a conserved preerythrocytic malaria antigen can induce protection in chimpanzees", 
                      "Intraerythrocytic polyubiquitin expression in Plasmodium falciparum is subjected to developmental and heatshock control", 
                      "Isolation expression and characterization of the gene for an ADPribosylation factor from the human malaria parasite Plasmodium falciparum", 
                      "Gene inactivation of Pf111 of Plasmodium falciparum by chromosome breakage and healing identification of a gametocytespecific protein with a potential role in gametogenesis", 
                      "Characterization of Plasmodium vivax isolates based on MSP1 gene in southern parts of Iran", 
                      "Extensive genetic diversity in the Plasmodium falciparum NaH exchanger 1 transporter protein implicated in quinine resistance", 
                      "Genetic polymorphism in exon2 of 55 kDa Plasmodium vivax Tryptophanrich antigen genePvTRAg55 in clinical isolates", 
                      "Evidence for clonal propagation of Plasmodium vivax in Korea Changes of circumsporzoite protein gene from 1953 to 2003", 
                      "Short report rare Plasmodium falciparum merozoite surface protein 1 19kdamsp119 haplotypes identified in Mali using highthroughput genotyping methods", 
                      "Sequence analysis of the Cterminal region of merozoite surface protein1MSP1 in field isolates of Plasmodium falciparum from Iran", 
                      "Population structure of the genes encoding the polymorphic P falciparum apical membrane antigen 1 implications for vaccine design", 
                      "The phylogeny of rodent malaria parasites simultaneous analysis across three genomes", 
                      "Expression purification and characterization of the immunological response to a 40kilodalton Plasmodium vivax tryptophanrich antigen", 
                      "Genetic diversity and selection at the Plasmodium vivax apical membrane antigen1PvAMA1 locus in a Sri Lankan population", 
                      "Plasmodium vivax genetic diversity of the apical membrane antigen1AMA1 in isolates from India", 
                      "Plasmodium vivax dihydropteroate synthasedhps gene mutations fron the Indian field isolates", 
                      "Analysis of drug resistance genes of Plasmodium falciparum in isolates from Bikaner India", 
                      "Transcription of multiple var genes by individual trophozoitestage Plasmodium falciparum cells expressing a chondroitin sulphate A binding phenotype", 
                      "Plasmodium falciparum genetic diversity of Cterminal region of MSP1 in isolates from Indian subcontinent", 
                      "Plasmodium falciparum DBL1 var sequence analysis in field isolates from central Brazil", 
                      "Antibodies against merozoite surface proteinMSP119 are a major component of the invasioninhibitory response in individuals immune to malaria", 
                      "Comparison of the carboxyterminal cysteinerich domain of the merozoite surface protein1 from several strains of Plasmodium yoelii", 
                      "Structure of the gene encoding the circumsporozoite protein of Plasmodium yoelii A rodent model for examining antimalarial sporozoite vaccines", 
                      "Strain variation in the circumsporozoite protein gene of Plasmodium falciparum", 
                      "Swedish traveller with Plasmodium knowlesi malaria after visiting Malaysian Borneo", 
                      "Structure of the E8 gene encoding a high molecular mass rhoptry protein of Plasmodium yoelii", 
                      "Genetic diversity of the F2 domain of Plasmodium falciparum erythrocyte binding antigen and the clinical outcome of malaria in the Kassena Nankana District", 
                      "Antigenic drift and immune selection acting on merozoite surface protein 119 and merozoite surface protein 2 in independent field isolates of Plasmodium falciparum", 
                      "Lack of sequence diversity in the gene encoding merozoite surface protein 5 of Plasmodium falciparum", 
                      "Polymorphisms within Tcell epitopes of preerythrocytic stage antigens of Plasmodium falciparum isolates", 
                      "Plasmodium falciparum msp2 allelic variants", "Evidence for the importance of genetic structuring to the structural and functional specialization of the Plasmodium falciparum var gene family", 
                      "Novel target antigens of the variantspecific immune response to Plasmodium falciparum identified by differential screening of an expression library", 
                      "Expression and characterisation of a Plasmodium falciparum protein containing domains homologous to sarcalumenin and a tyrosine kinase substrate eps15", 
                      "Construction and immunogenicity of DNA vaccine plasmids encoding four Plasmodium vivax candidate vaccine antigens", 
                      "Ten families of variant genes encoded in subtelomeric regions of multiple chromosomes of Plasmodium chabaudi a malaria species that undergoes antigenic variation in the laboratory mouse", 
                      "Cloning and expression of plasmepsins from the human malaria parasites Plasmodium vivax Plasmodium ovale and Plasmodium malariae", 
                      "Genotypes of merozoite surface protein 2 in Tanzania", "Molecular analysis of Plasmodium vivax relapses using the MSP1 molecule as a genetic marker", 
                      "The complete sequence of Plasmodium berghei merozoite surface protein1 and its inter and intraspecies variability", 
                      "Characterisation of the gene encoding an unusually divergent TATAbinding proteinTBP from the extremely ATrich human malaria parasite Plasmodium falciparum", 
                      "Extensive polymorphism in the plasmodium vivax merozoite surface coat protein MSP3alpha is limited to specific domains", 
                      "Sequence analysis of apical membrane antigen I from a Plasmodium falciparum isolate collected from Mengpeng Township Yunnan Province", 
                      "Second form in a segment of the merozoite surface protein 1 gene of Plasmodium vivax among isolates from RondoniaBrazil", 
                      "Plasmodium falciparum characterization of gene R45 encoding a trophozoite antigen containing a central block of six amino acid repeats", 
                      "Allelic dimorphismassociated restriction of recombination in Plasmodium falciparum msp1", 
                      "Comparison between microscopy and seminested multiplex PCR in diagnosis of Plasmodium falciparum and vivax in south and southeastern Iran", 
                      "Characterization of Plasmodium berghei ribosomal phosphoprotein P0", 
                      "Evolutionary relationships of conserved cysteinerich motifs in adhesive molecules of malaria parasites", 
                      "Plasmodium vivax cloning and expression of a major bloodstage surface antigen", 
                      "Dimorphism of the C terminus of the Plasmodium vivax merozoite surface protein 1", 
                      "Merozoite surface protein 3 and protection against malaria in Aotus nancymai monkeys", 
                      "Conservation of repeating structures in the PfEMP2MESA protein of Plasmodium falciparum", 
                      "Plasmodium falciparum intragenic recombination and nonrandom associations between polymorphic domains of the precursor to the major merozoite surface antigens", 
                      "Conserved sequences flank variable tandem repeats in two Santigen genes of Plasmodium falciparum", 
                      "Aldolase activity of a Plasmodium falciparum protein with protective properties", 
                      "Amplification of the multidrug resistance gene in some chloroquineresistant isolates of P falciparum", 
                      "Structure of the knob proteinKP gene of Plasmodium falciparum", 
                      "cDNA cloning of 18sUrRNA of Plasmodium yoelii 265 BY", "Gene conversion events generate diversity within the multicopy variant antigen gene families of Plasmodium falciparum", 
                      "Characterization of amino acid variation at strategic positions in parasite and human proteases for selective inhibition of falcipains in Plasmodium falciparum", 
                      "Origin of malignant malaria parasitesPlasmodium falciparum in the chimpanzeePan troglodytes", 
                      "Antibody responses to infections with strains of Plasmodium falciparum expressing diverse forms of merozoite surface protein 2", 
                      "Circumsporozoite protein of Plasmodium vivax gene cloning and characterization of the immunodominant epitope", 
                      "A 24 bp cisacting element essential for the transcriptional activity of Plasmodium falciparum CDPdiacylglycerol synthase gene promoter", 
                      "Two new genotypes of Plasmodium vivax circumsporozoite protein found in the Republic of Korea", 
                      "Sequence diversity and antigenic polymorphism in the Plasmodium yoelii p235 high molecular mass rhoptry proteins and their genes", 
                      "Immunization of Rhesus Macaques by Priming with DNA Plasmids Encoding Four P knowlesi Antigens and Rhesus GranulocyteMonocyte Colony Stimulating Factor and Boosting with Recombinant CanaryPox Virus", 
                      "Structure of the gene of knobassociated histidine rich protein of Plasmodium falciparum isolate FCC1HN", 
                      "Immune responses in mice induced by primeboost schemes of the Plasmodium falciparum apical membrane antigen 1PfAMA1based DNA protein and recombinant modified vaccinia Ankara vaccines", 
                      "Contrasting signatures of selection on the Plasmodium falciparum erythrocyte binding antigen gene family", 
                      "Sequence analysis of Plasmodium falciparum MSP5", "Plasmodium vivax putative neutral housekeeping genes from BrazilRondonia Acrelandia and Sri LankaKataragama", 
                      "Plasmodium vivax allele variants of the mdr1 gene do not associate with chloroquine resistance among isolates from Brazil Papua and monkeyadapted strains", 
                      "Analysis of Polymorphic Regions of Plasmodium vivax Merozoite Surface Protein 1ICB45 of Korean isolates", 
                      "Genetic diversity of Plasmodium vivax from Korean isolates", 
                      "Plasmodium vivax resistance to chloroquine in Madagascar clinical efficacy and polymorphisms in pvmdr1 and pvcrto genes", 
                      "Cloning and expression of the mature parasiteinfected erythrocyte surface antigen gene of Plasmodium falciparum isolate FCC1HN", 
                      "The chitinase PfCHT1 from the human malaria parasite Plasmodium falciparum lacks proenzyme and chitinbinding domains and displays unique substrate preferences", 
                      "Amplification of pfmdr 1 associated with mefloquine and halofantrine resistance in Plasmodium falciparum from Thailand", 
                      "The analysis of Plasmodium vivax AMA1 gene sequences from reemerging Korean isolates", 
                      "Chloroquine resistance in rodent malaria The roles of the chloroquine resistance transportercrt and multidrug resistancemdr1 homologs", 
                      "Isolation of the DNA replication factor C subunit 1 gene from the human malaria parasite Plasmodium falciparum", 
                      "PfRFC3 a subunit of replication factor C complex from the human malaria parasite Plasmodium falciparum", 
                      "Molecular characterization of Plasmodium falciparum Sadenosylmethionine synthetase", 
                      "Genetic diversity of the Plasmodium vivax merozoite surface protein5 locus from diverse geographic origins", 
                      "The partial sequence of the Plasmodium yoelii yoelii 28S ribosomal RNA gene", 
                      "A long range restriction map of chromosome 5 of Plasmodium berghei demonstrates a chromosome specific symmetrical subtelomeric organisation", 
                      "Plasmodium falciparum AARP1 a giant protein containing repeated motifs rich in asparagine and aspartate residues is associated with the infected erythrocyte membrane", 
                      "Nine duplicated tRNA genes on the plastidlike DNA of the malaria parasite Plasmodium falciparum", 
                      "Sequence and organization of large subunit rRNA genes from the extrachromosomal 35 kb circular DNA of the malaria parasite Plasmodium falciparum", 
                      "Heterogeneity at the 5 end of the circumsporozoite protein gene of Plasmodium falciparum is due to a previously undescribed repeat sequence", 
                      "A family of cation ATPaselike molecules from Plasmodium falciparum", 
                      "Immunogenic compositions comprising liver stage malarial antigens", 
                      "Roles of conserved and allelic regions of the major merozoite surface proteingp195 in immunity against Plasmodium falciparum", 
                      "Biomolecular archaeology of malaria", "Complete nucleotide sequence of the 6 kb element and conserved cytochrome b gene sequences among Indian isolates of Plasmodium falciparum", 
                      "Random distribution of mixed species malaria infections in Papua New Guinea", 
                      "Prospective identification of malaria parasite genes under balancing selection", 
                      "Plasmodium vivax asexual stage antigen genes polymorphism", 
                      "Plasmodium falciparum and Plasmodium vivax Infections in the Peruvian Amazon propagation of complex multiple alleletype infections without superinfection", 
                      "Sequence diversity study in antigenic sites of rhoptry proteins RAP1 RAP2 and RhopH3 along with micronemal protein AMA1", 
                      "Genetic diversity of Plasmodium vivax in Tibet", "Evidence for diversifying selection on erythrocytebinding antigens of Plasmodium falciparum and P vivax", 
                      "etramps a new Plasmodium falciparum gene family coding for developmentally regulated and highly charged membrane proteins located at the parasitehost cell interface", 
                      "3D7a target PF100018", "Genetic diversity of dihydrofolate reductasethymidylate synthase from Korea isolates", 
                      "Sequence analysis of carboxy terminus domain of Pv200 protein from clinical isolates of Plasmodium vivax from Iran", 
                      "Sequence polymorphisms in the receptorbinding domain of Plasmodium falciparum EBA175 implications for malaria vaccine development", 
                      "Evolutionary relationships between 15 Plasmodium species from new and old world primatesincluding humans an 18S rDNA cladistic analysis", 
                      "Evolutionary origin of P simium", "Phylogenetic analysis of the Plasmodium vivax circumsporozoite protein gene sequence from resurgent Korean isolates", 
                      "Determination of the DNA and aminoacid sequences of lactate dehydrogenase gene from Plasmodium falciparum strains K1 and PF FCBR A route to the design of new antimalarials", 
                      "High sequence diversity and evidence of balancing selection in the Pvmsp3alpha gene of Plasmodium vivax in the Venezuelan Amazon", 
                      "Organisation and expression of small subunit ribosomal RNA genes encoded by a 35kilobase circular DNA in Plasmodium falciparum", 
                      "Genetic variations of the dihydrofolate reductase gene of Plasmodium vivax in Mandalay Division Myanmar", 
                      "Highlevel expression of Plasmodium vivax apical membrane antigen 1AMA1 in Pichia pastoris strong immunogenicity in Macaca mulatta immunized with P vivax AMA1 and adjuvant SBAS2", 
                      "A second glutamate dehydrogenase in Plasmodium falciparum", 
                      "A direct and rapid sequencing strategy for the Plasmodium falciparum antigen gene gp190MSA1", 
                      "Plasmodium falciparum glutathione reductase exhibits sequence similarities with the human host enzyme in the core structure but differs at the ligandbinding sites", 
                      "Phylogenetic analysis of the rpoB gene from the plastidlike DNA of Plasmodium falciparum", 
                      "Cloning of the glucose 6phosphate dehydrogenase gene from Plasmodium falciparum", 
                      "Molecular characterisation and stagespecific expression of proliferating cell nuclear antigenPCNA from the malarial parasite Plasmodium falciparum", 
                      "Polymorphism of the vaccine candidate Merozoite surface protein1 of Plasmodium falciparum in Indian isolates", 
                      "Polymorphism of the vaccine candidate merozoite surface protein1 of Indian isolates", 
                      "Plasmodium falciparum myb2 gene", "The Plasmodium falciparum intermediate compartmentspecific GTPase Rab1A is expressed throughout the parasites lifecycle and is recognised by natural infection sera", 
                      "Cloning of heat shock protein DnaJ homologue pfj2 from Plasmodium falciparum", 
                      "Interallelic recombination in the Plasmodium vivax merozoite surface protein 1 gene among Indian and Colombian isolates", 
                      "Sickle cells alters Plasmodium falciparum genomic DNA", "Characterization of UDPgalactose transporter like in Plasmodium falciparum", 
                      "Effect of the malaria vaccine Combination B on merozoite surface antigen 2 diversity", 
                      "High polymorphism in Plasmodium vivax merozoite surface protein5MSP5", 
                      "A large gene family for putative variant antigens shared by human and rodent malaria parasites", 
                      "Characterisation of Plasmodium berghei subtilisine like protease 2", 
                      "The putative gammaglutamylcysteine synthetase from Plasmodium falciparum contains large insertions and a variable tandem repeat", 
                      "Characterization and cloning of the gene encoding the vacuolar membrane protein EXP2 from Plasmodium falciparum", 
                      "Molecular characterization of the glutathione peroxidase gene of the human malaria parasite Plasmodium falciparum", 
                      "Isolation of alphatubulin genes from the human malaria parasite Plasmodium falciparum sequence analysis of alphatubulin", 
                      "Conservation of antigen components from two recombinant hybrid proteins protective against malaria", 
                      "Pfnhe1 polymorphism in South Vietnam", "Multiple roles of Plasmodium actin capping protein during life cycle progression of the malaria parasite", 
                      "Rapid Dissemination of Plasmodium falciparum Drug Resistance Despite Strictly Controlled Antimalarial Use", 
                      "Extensive Genetic Diversity in the Plasmodium falciparum NaH Exchanger 1 Transporter Protein Implicated in Quinine Resistance", 
                      "Polymorphism study of rhoptry associated membrane antigenRAMA gene of Plasmodium falciparuma putative vaccine candidate", 
                      "Genetic diversity of PfNHE1 in worldwide isolates with different susceptibility to quinine", 
                      "Transcribed var Genes Associated with Placental Malaria in Malawian Women", 
                      "A gene coding for a highmolecular mass rhoptry protein of Plasmodium yoelii", 
                      "The polymorphic Pf332 gene of Plasmodium falciparum is subtelomerically located on chromosome 11 and encodes an erythrocyte membraneassociated giant protein", 
                      "GrpE the essential regulatory factor for prokaryotetype Hsp70 is absent from the plastid of the human malaria parasite Plasmodium falciparum", 
                      "Novel point mutations in sulfadoxine resistance genes of Plasmodium falciparum from India", 
                      "Identifying and characterising the Plasmodium falciparum merozoite surface protein 10 Plasmodium vivax homologue", 
                      "Identification of the Plasmodium vivax mdrlike genepvmdr1 and analysis of singlenucleotide polymorphisms among isolates from different areas of endemicity", 
                      "Sequence of Plasmodium falciparum aldolaseP41 gene", "Sequence of Plasmodium falciparum putative phosphatidylethanolaminebinding proteinPPBP gene", 
                      "Genetic diversity in the Cterminal 42 kDa region of merozoite surface protein1 of Plasmodium vivaxPvMSP142 among Indian isolates", 
                      "Functional interdependence of the DBLbeta domain and c2 region for binding of the Plasmodium falciparum variant antigen to ICAM1", 
                      "Plasmodium Falciparum Secrete a Homolog of the Human Cytokine Macrophage Migration Inhibitory Factor", 
                      "Mutations in the cytochrome b gene of Plasmodium berghei conferring resistance to atovaquone", 
                      "Passive immunization with antibodies against a conserved domain of human mouse and monkey malaria parasites suppresses parasitemia in a lethal Plasmodium berghei model", 
                      "Genotyping and sequence analysis of merozoite surface protein 1MSP1 block 4 of Plasmodium falciparum isolates from Sistan and Bluchistan Iran", 
                      "A putative protein serinethreonine phosphatase from Plasmodium falciparum contains a large Nterminal extension and five unique inserts in the catalytic domain", 
                      "Isolation and functional characterization of two distinct sexualstagespecific promoters of the human malaria parasite Plasmodium falciparum", 
                      "Evidence for distinct prototype sequences within the Plasmodium falciparum Pf60 multigene family", 
                      "Allelic modifications of the cg2 and cg1 genes do not alter the chloroquine response of drugresistant Plasmodium falciparum", 
                      "Merozoite surface protein3 a malaria protein inducing antibodies that promote Plasmodium falciparum killing by cooperation with blood monocytes", 
                      "Erythrocyte binding protein homologues of rodent malaria parasites", 
                      "Gene sequence tags from Plasmodium falciparum genomic DNA fragments prepared by thegenease activity of mung bean nuclease", 
                      "A novel 40kDa membraneassociated EFhand calciumbinding protein in Plasmodium falciparum", 
                      "Plasmodium falciparum characterization of a 07kbp moderately repetitive sequence", 
                      "Immunization against Plasmodium chabaudi malaria using combined formulations of apical membrane antigen1 and merozoite surface protein1", 
                      "Identification and characterization of the protective hepatocyte erythrocyte protein 17 kDa gene of Plasmodium yoelii homolog of Plasmodium falciparum exported protein 1", 
                      "Molecular cloning and characterization of the Plasmodium falciparum cytidine triphosphate synthetase gene", 
                      "Molecular cloning of a gene from Plasmodium falciparum that codes for a protein sharing motifs found in adhesive molecules from mammals and plasmodia", 
                      "Genetic structure of Plasmodium falciparum field isolates in eastern and northeastern India", 
                      "Genotyping of C terminal region of 19 kDa fragment of merozoite surface protein 1msp1 of Plasmodium falciparum in Iran", 
                      "Identification and Molecular Characterisation of Malaria Parasites of Macaques in Kapit Sarawak", 
                      "Detecting the human mix infection of Plasmodium knowlesi and other Plasmodium", 
                      "Expression and purification of a Plasmodium vivax antigen PvTARAg55 tryptophan and alaninerich antigen and its immunological responses in human subjects", 
                      "Sequence variation at four flanking microsatellite loci of Plasmodium vivax dihydrofolate reductasedhfr gene and their correlation with pyrimethamine resistance", 
                      "Population diversity and antibody selective pressure to Plasmodium falciparum MSP1 block2 locus in an African malariaendemic setting", 
                      "Restricted Tcell epitope diversity in the circumsporozoite protein from Plasmodium falciparum populations prevalent in Iran", 
                      "Plasmodium falciparum sequence analysis of the gene encoding the Cterminus region of the merozoite surface protein1 a potential malaria vaccine antigen in Iranian clinical isolates", 
                      "Sequence diversity and evolutionary dynamics of the dimorphic antigen merozoite surface protein6 and other Msp genes of Plasmodium falciparum", 
                      "Sequence diversity and natural selection at domain I of the apical membrane antigen 1 among Indian Plasmodium falciparum populations", 
                      "Evidence of nonneutral polymorphism in Plasmodium falciparum gamete surface protein genes Pfs47 and Pfs4845", 
                      "Plasmodium vivax dhfr and dhps mutations in isolates from Madagascar and therapeutic response to sulphadoxinepyrimethamine", 
                      "Molecular diagnosis of malaria species and strains in Papua New Guinea", 
                      "Plasmodium vivax dhfr and dhps mutations in isolates from Madagascar and therapeutic response to suphadoxinepyrimethamine", 
                      "A comparative study of the genetic diversity of the 42kDa fragment of the merozoite surface protein 1 in Plasmodium falciparum and P vivax", 
                      "Differential prevalence of plasmodium infections and cryptic Plasmodium knowlesi malaria in humans in Thailand", 
                      "Plasmodium vivax dihydrofolate reductasedhfr gene mutations among Indian isolates", 
                      "Receptor binding domain of EBA175 of Plasmodium falciparum field isolateIndia", 
                      "Strain polymorphism of Plasmodium falciparum transmissionblocking target antigen Pfs230", 
                      "Cloning of the Plasmodium vivax Duffy receptor", "A family of erythrocyte binding proteins of malaria parasites", 
                      "Cloning sequence determination and regulation of the ribonucleotide reductase subunits from Plasmodium falciparum a target for antimalarial therapy", 
                      "Plasmodium vivax merozoite surface proteins3beta and3gamma share structural similarities with P vivax merozoite surface protein3alpha and define a new gene family", 
                      "Polymorphisms in the genes are linked to ChloroquineResistant Plasmodium falciparum in China", 
                      "Two alleles of the 175kilodalton Plasmodium falciparum erythrocyte binding antigen", 
                      "Countrywide assessment of the genetic polymorphism in Plasmodium falciparum and Plasmodium vivax antigens detected with rapid diagnostic tests for malaria", 
                      "Genetic variation among Plasmodium vivax isolates adapted to nonhuman primates and the implication for vaccine development", 
                      "Functional and immunological characterization of a duffy bindinglike gamma domain from Plasmodium falciparum erythrocyte membrane protein1 expressed by a placental isolate", 
                      "Merozoite surface proteins 4 and 5 of Plasmodium knowlesi have differing cellular localisation and association with lipid rafts", 
                      "Isolation and sequencing of the pfs25 gene from the PFD3YN isolate of Plasmodium falciparum", 
                      "Var gene diversity in Plasmodium falciparum is generated by frequent recombination events", 
                      "Cloning and sequencing of the membrane protein Pf7 gene of Plasmodium falciparum isolate FCC1HN", 
                      "Minimal variation in the Pfs28 ookinete antigen from Philippine field isolates of Plasmodium falciparum", 
                      "Structural basis for parasitespecific functions of the divergent profilin of Plasmodium falciparum", 
                      "Polymorphism analysis of Plasmodium vivax merozoite surface protein 1 gene from different area", 
                      "Plasmodium falciparum extensive polymorphism in merozoite surface antigen 2 alleles in an area with endemic malaria in Papua New Guinea", 
                      "The adhesion of Plasmodium falciparuminfected erythrocytes to chondroitin sulfate A is mediated by P falciparum erythrocyte membrane protein 1", 
                      "Identification of a novel Plasmodium yoelii yoelii gene umsl1", 
                      "Submicroscopic Plasmodium falciparum infections and multiplicity of infection in matched peripheral placental and umbilical cord blood samples from Gabonese women", 
                      "dxr as a potential target for antimalarial drugs", "The immunogenicity and protective efficacy of Plasmodium falciparum AMA1 DNA vaccines", 
                      "Plasmodium berghei identification of an mdrlike gene associated with drug resistance", 
                      "Identical alleles of Plasmodium falciparum merozoite surface protein 2 found in distant geographic areas and times", 
                      "Sequence diversity of the merozoite surface protein 1 of Plasmodium falciparum in clinical isolates from the Kilombero District Tanzania", 
                      "An amino terminal intron indicates that transcripts for the Plasmodium falciparum Golgi network marker Rab6 do not encode alternative amino termini", 
                      "Limited sequence polymorphism in the Plasmodium falciparum merozoite surface protein 3", 
                      "Conservation of structure and function of the erythrocytebinding domain of Plasmodium falciparum EBA175", 
                      "Immunological responses to a 398kDa Plasmodium vivax tryptophanrich antigenPvTRAg398 among humans", 
                      "Sequence analysis of the apical membrane antigen1 genesama1 of Plasmodium yoelii yoelii and Plasmodium berghei", 
                      "Identification and cloning of a locus of serine repeat antigenserarelated genes from Plasmodium vivax", 
                      "Diversity of the vaccine candidate AMA1 of Plasmodium falciparum", 
                      "Genetic polymorphism of the Duffy receptor binding domain of Plasmodium vivax in Colombian wild isolates", 
                      "A novel 11residue coiledcoil motif predicts a histidine zipper", 
                      "Analysis of Plasmodium falciparum AMA1 from Indian isolates", 
                      "Sequence analysis upstream of the gene encoding the precursor to the major merozoite surface antigens of Plasmodium yoelii", 
                      "Characterization of PfDYN2 a dynaminlike protein of Plasmodium falciparum expressed in schizonts", 
                      "Genotyping of C terminal region of 19 kDa merozoite surface protein 1 of Plasmodium falciparum from Iran", 
                      "Recognition of variant Rifin antigens by human antibodies induced during natural Plasmodium falciparum infections", 
                      "Functional characterization of a redundant Plasmodium TRAP family invasin TRAPlike protein by aldolase binding and a genetic complementation test", 
                      "Functional characterization of TLP1 a novel member of the TRAPfamily of Plasmodium", 
                      "Congenicity and genetic polymorphism in cloned lines derived from a single isolate of a rodent malaria parasite", 
                      "Patterns of polymorphism in genomic regions flanking three highly polymorphic surface antigens in Plasmodium falciparum", 
                      "Gene structure and expression of a Plasmodium falciparum 220kDa protein homologous to the Plasmodium vivax reticulocyte binding proteins", 
                      "Highly conserved plasmepsins IV and V of Plasmodium vivax Potential antimalarial drug targets", 
                      "Plasmodium falciparum a homologue of paminobenzoic acid synthetase", 
                      "Vivax malaria presenting with cerebral malaria and convulsions", 
                      "Genetic polymorphism and effect of natural selection at domain I of apical membrane antigen1AMA1 in Plasmodium vivax isolates from Myanmar", 
                      "Sequence diversity in rodent malaria of the Pfs28 ookinete surface antigen homologs", 
                      "Structure of sporozoite surface protein 2 gene of Plasmodium falciparum isolate FCC1HN", 
                      "Mutations in AntifolateResistanceAssociated Genes dhfr and dhps in Plasmodium vivax Isolates from Malaria Endemic Countries", 
                      "Primary structure and sexual stagespecific expression of a LAMMER protein kinase of Plasmodium falciparum", 
                      "Molecular cloning and characterization of replication factor C subunit 4 gene from Plasmodium falciparum", 
                      "Cloning and sequencing of the membrane protein Pf12 gene of Plasmodium falciparum isolate FCC1HN", 
                      "Characterisation of PfSec61 a Plasmodium falciparum homologue of a component of the translocation machinery at the endoplasmic reticulum membrane of eukaryotic cells", 
                      "Molecular characterization of Plasmodium vivax clinical isolates in Pakistan and Iran using pvmsp1 pvmsp3alpha and pvcsp genes as molecular markers", 
                      "Plasmodium falciparum domain mediating adhesion to chondroitin sulfate A a receptor for human placental infection", 
                      "Sequence diversity of serine repeat anitgen gene exon II of Plasmodium falciparum in worldwide collected wild isolates", 
                      "Structure and superstructure of Plasmodium falciparum subtelomeric regions", 
                      "Proof of intragenic recombination in Plasmodium falciparum", 
                      "The Plasmodium falciparum liver stage antigen LSA1 is well conserved and harbors major B and Tcell epitopes", 
                      "Antimalaria vaccines", "Long insertions within telomeres contribute to chromosome size polymorphism in Plasmodium berghei", 
                      "Use of Plasmodium vivax merozoite surface protein 1 gene sequence analysis in the investigation of an introduced malaria case in Italy", 
                      "Plasmodium yoelii pid gene", "Direct PCR amplification and sequence analysis of extrachromosomal Plasmodium DNA from dried blood spots", 
                      "Plasmodium falciparum generation of a cDNA library enriched in sporozoitespecific transcripts by directional tag subtractive hybridization", 
                      "vir gene repertoire from BrazilRondonia Acrelandia and Sri LankaKataragama", 
                      "High prevalence and fixation of Plasmodium vivax dhfrdhps mutations related to sulfadoxinepyrimethamine resistance in French Guiana", 
                      "Molecular epidemiology of malaria in Cameroon XXV In vitro activity of fosmidomycin and its derivatives against fresh clinical isolates and sequence analysis of 1deoxyDxylulose 5phosphate reductois...", 
                      "Evidence for negative selection on the gene encoding rhoptryassociated protein 1RAP1 in Plasmodium spp", 
                      "Genetic diversity in the Block 2 region of the merozoite surface protein 1MSP1 of Plasmodium falciparum additional complexity and selection and convergence in fragment size polymorphism", 
                      "Population structure analysis of Plasmodium vivax in areas of iran with different malaria endemicity", 
                      "Plasmodium berghei alphatubulin II a role in both male gamete formation and asexual blood stages", 
                      "Genetic diversity in the merozoite surface protein gene of Plasmodium falciparum in endemic region of Iran", 
                      "Apparent absence of atovaquoneproguanil resistance in 477 Plasmodium falciparum isolates from untreated French travellers", 
                      "Complex mutations in a high proportion of microsatellite loci from the protozoan parasite Plasmodium falciparum", 
                      "Succinate dehydrogenase in Plasmodium falciparum mitochondria molecular characterization of the SDHA and SDHB genes for the catalytic subunits the flavoproteinFp and ironsulfurIp subunits", 
                      "Complete nucleotide sequence of the Plasmodium vivax 6 kb element", 
                      "DNA polymerase delta gene sequences from Plasmodium falciparum indicate that this enzyme is more highly conserved than DNA polymerase alpha", 
                      "Polymorphism in TRAPN terminal region of Plasmodium falciparum in Indian isolates", 
                      "Cloning and characterization of heat shock protein DnaJ homologues from Plasmodium falciparum and comparison with ring infected erythrocyte surface antigen", 
                      "Analysis of Plasmodium vivax hexose transporters and characterization of a parasitocidal inhibitor", 
                      "Integrated genetic and physical maps of Plasmodium falciparum", 
                      "Stable SNPs in malaria antigen genes in isolated populations", 
                      "Blocking of transmission to mosquitoes by antibody to Plasmodium vivax malaria vaccine candidates Pvs25 and Pvs28 despite antigenic polymorphism in field isolates", 
                      "Comparative characterization of hexose transporters of Plasmodium knowlesi Plasmodium yoelii and Toxoplasma gondii highlights functional differences within the apicomplexan family", 
                      "Geographic patterns of diversity in the major surface antigenvar genes of Plasmodium falciparum", 
                      "Mapping and transcriptional analysis of var sequences in Plasmodium falciparum laboratory isolate A4", 
                      "Identification of a conserved Plasmodium falciparum var gene implicated in malaria in pregnancy", 
                      "Comparative analysis of Plasmodium reichenowi and P falciparum erythrocytebinding proteins reveals selection to maintain polymorphism in the erythrocytebinding region of EBA175", 
                      "Genetic Polymorphism of merozoite surface antigen 2MSA2 of Indian Plasmodium falciparum strains", 
                      "A Plasmodium falciparum protein kinase with two unusually large kinase inserts", 
                      "Sexualstagespecific RNA expression of a new Plasmodium falciparum gene detected by in situ hybridisation", 
                      "A new blood stage antigen of Plasmodium falciparum highly homologous to the serinestretch protein SERP", 
                      "Cycle DNA sequencing withalpha35SdATP demonstrates polymorphism of a surface antigen in malaria parasites from Sri Lankan patients", 
                      "Cloning and characterization of a Plasmodium falciparum gene encoding a novel highmolecular weight host membraneassociated protein PfEMP3", 
                      "AMINO ACID MUTATIONS IN PLASMODIUM VIVAX DHFR AND DHPS FROM SEVERAL GEOGRAPHICAL REGIONS AND SUSCEPTIBILITY TO ANTIFOLATE DRUGS", 
                      "Sequence coding for a sexual stage specific protein of Plasmodium falciparum", 
                      "Genetic diversity of Plasmodium vivax Duffy binding protein under low transmission and unstable malaria in Sri Lanka", 
                      "Fixation of two punctual mutations associated with resistance to chloroquine in endemic regions of Colombia", 
                      "Analysis of von Willebrand factor A domainrelated proteinWARP polymorphism in temperate and tropical Plasmodium vivax field isolates", 
                      "Plasmodium vivax synonymous substitution frequencies evolution and population structure deduced from diversity in AMA 1 and MSP 1 genes", 
                      "Genetic Diversity of Plasmodium vivax Apical Membrane Antigen1 Domain II in Sri Lanka and the Ensuing Strain Specific Immunity", 
                      "High proportion of mixedspecies Plasmodium infections in India revealed by PCR diagnostic assay", 
                      "Molecular surveillance of Plasmodium vivax dhfr and dhps mutations in isolates from Afghanistan", 
                      "The malaria candidate vaccine liver stage antigen3 is highly conserved in Plasmodium falciparum isolates from diverse geographical areas", 
                      "Polymorphism in var genes of Plasmodium falciparum isolates belonging to different geographical regions", 
                      "Contrasting evolutionary histories of three merozoite surface antigens of the human malaria parasite Plasmodium falciparum", 
                      "High immunogenecity and erythrocytebinding activity in the tryptophanrich domainTRD of the 74kDa Plasmodium vivax alaninetryptophanrich antigenPvATRAg74", 
                      "Genetic diversity of transmission blocking vaccine candidatePvs25 and Pvs28 antigen in Plasmodium vivax clinical isolates from Iran", 
                      "The large diverse gene family var encodes proteins involved in cytoadherence and antigenic variation of Plasmodium falciparuminfected erythrocytes", 
                      "A Plasmodium falciparum gene encoding a high mobility group protein box", 
                      "The Duffy receptor family of Plasmodium knowlesi is located within the micronemes of invasive malaria merozoites", 
                      "Expression of the RESA gene in Plasmodium falciparum isolate FCR3 is prevented by a subtelomeric deletion", 
                      "Mutations in Plasmodium falciparum cytochrome b that are associated with atovaquone resistance are located at a putative drugbinding site", 
                      "Structure of a Plasmodium chabaudi acidic phosphoprotein that is associated with the host erythrocyte membrane", 
                      "The circumsporozoite protein gene from NF54 a Plasmodium falciparum isolate used in malaria vaccine trials", 
                      "Plasmodium falciparum polymorphism in the MSP1 gene in Indian isolates and predominance of certain alleles in cerebral malaria", 
                      "Efficacy of vaccines containing rhoptryassociated proteins RAP1 and RAP2 of Plasmodium falciparum in Saimiri boliviensis monkeys", 
                      "Plasmodium falciparum infection elicits both variantspecific and crossreactive antibodies against variant surface antigens", 
                      "Analysis of the Plasmodium vivax multidrug resistance gene sequence", 
                      "Novel antigen of Plasmodium falciparum crossreactive with Plasmodium yoelii", 
                      "Sequence of cyclophilincyppfl gene of Plasmodium falciparumisolate FCC1HN", 
                      "Low temperature soluble expression of Plasmodium vivax lactate dehydrogenasePvLDH and its biochemical characterization", 
                      "msp2 genotyping", "A screen for stagespecific gene expression in Plasmodium oocyst sporozoites", 
                      "A reticulocytebinding protein complex of Plasmodium vivax merozoites", 
                      "Polymorphisms within Tcell epitopes of preerythrocytic stage antigen of Plasmodium falciparum isolates", 
                      "Plasmodium vivaxSouth Korea strain circumsporozoite protein gene Cloning and characterization of repeat region and 3end", 
                      "A family of chimeric erythrocyte binding proteins of malaria parasites", 
                      "Molecular epidemiology of Plasmodium vivax malaria in northern part of Iran", 
                      "Phylogeny of Plasmodium vivax and related primate malaria parasites inferred from apicoplastcoded genes", 
                      "The histone H4 gene of Plasmodium falciparum is developmentally transcribed in asexual parasites", 
                      "Partial nucleotide sequence of an antigen which binds to antipp300 monoclonal antibodies", 
                      "New tools to identify var sequence tags and clone fulllength genes using typespecific primers to Duffy bindinglike domains", 
                      "Identification and Characterization of a Conserved StageSpecific Gene Product of Plasmodium falciparum Recognized by Parasite Growth Inhibitory Antibodies", 
                      "A longitudinal study of typespecific antibody responses to Plasmodium falciparum merozoite surface protein1 in an area of unstable malaria in Sudan", 
                      "Molecular analysis of the cytoadherence phenotype of a Plasmodium falciparum field isolate that binds intercellular adhesion molecule1", 
                      "Conservation of structural motifs and antigenic diversity in the Plasmodium falciparum merozoite surface protein3MSP3", 
                      "Regular initiation of translation of Plasmodium berghei aldolase2 after premRNA splicing", 
                      "Molecular characterization of chloroquine resistance transporter gene in a nonresistant species of Plasmodium berghei", 
                      "Merozoite surface protein 8 of Plasmodium falciparum contains two epidermal growth factorlike domains", 
                      "Polymorphism of the TRAP gene of Plasmodium falciparum", "An S antigen gene from Plasmodium falciparum contains a novel repetitive sequence", 
                      "Characterization of a highmolecularweight phosphoprotein synthesized by the human malarial parasite Plasmodium falciparum", 
                      "Intrageneric conservation and limited interstrain variation in a protective minor surface antigen of Plasmodium knowlesi merozoites", 
                      "Plasmodium falciparum gene structure and hydropathy profile of the major merozoite surface antigengp195 of the UgandaPalo Alto isolate", 
                      "The primary structure of Plasmodium falciparum DNA polymerase delta is similar to drug sensitive deltalike viral DNA polymerases", 
                      "Sequence of the circumsporozoite gene of Plasmodium berghei ANKA clone and NK65 strain", 
                      "Diversity of circumsporozoite antigen genes from two strains of the malarial parasite Plasmodium knowlesi", 
                      "Evolution of the immunodominant domain of the circumsporozoite protein gene from Plasmodium vivax Implications for vaccines", 
                      "Sequence of the immunodominant epitope for the surface protein on sporozoites of Plasmodium vivax", 
                      "Switches in expression of Plasmodium falciparum var genes correlate with changes in antigenic and cytoadherent phenotypes of infected erythrocytes", 
                      "Evaluation of immunogenicity of an oral Salmonella vaccine expressing recombinant Plasmodium berghei merozoite surface protein1", 
                      "Fluorescent Plasmodium berghei sporozoites and preerythrocytic stages a new tool to study mosquito and mammalian host interactions with malaria parasites", 
                      "A new blood stage antigen of Plasmodium falciparum transported to the erythrocyte surface", 
                      "Infectivityassociated changes in the transcriptional repertoire of the malaria parasite sporozoite stage", 
                      "Molecular cloning and characterization of the mcm5 gene from the human malaria parasite Plasmodium falciparum", 
                      "The DNA polymerase delta promoter from Plasmodium falciparum contains an unusually long 5 untranslated region and intrinsic DNA curvature", 
                      "Gene polymorphism of Plasmodium falciparum merozoite surface proteins 4 and 5", 
                      "Plasmodium falciparum analysis of transcribed var gene sequences in natural isolates from the Brazilian Amazon region", 
                      "An analysis of genetic diversity within the ligand domains of the Plasmodium falciparum ebl1 gene", 
                      "Sequence of blood stage rhoptry associated protein1RAP1 of Plasmodium falciparum", 
                      "Cloning and analysis of the RESA2 gene a DNA homologue of the ringinfected erythrocyte surface antigen gene of Plasmodium falciparum", 
                      "Susceptibility of Plasmodium falciparum isolates to doxycycline is associated with pftetQ sequence polymorphisms and pftetQ and pfmdt copy numbers", 
                      "Extreme Polymorphism in a Malaria Vaccine Antigen is Associated with Clinical Illness Vaccine Development Implications", 
                      "Emergence of new alleles of the MSP3alpha gene in Plasmodium vivax isolates from Korea", 
                      "Cloning and characterization of a novel multicopy repetitive sequence of Plasmodium falciparum REP51", 
                      "von Willebrand Factor A domainrelated protein a novel microneme protein of the malaria ookinete highly conserved throughout Plasmodium parasites", 
                      "Functional equivalence of structurally distinct ribosomes in the malaria parasite Plasmodium berghei", 
                      "Amendment", "Plasmodium vivax housekeeping gene polymorphism", 
                      "Characterization of a Plasmodium chabaudi gene encoding a protein with glutamaterich tandem repeats", 
                      "Plasmodium falciparum Translationally Controlled Tumor ProteinPfTCTP Polymorphism in Sickle Cell Trait", 
                      "Malaria among Jarawasthe primitive and hostile tribe of Andaman and Nicobar Islands India", 
                      "RNA helicaserelated genes of Plasmodium falciparum and Plasmodium cynomolgi", 
                      "An atypical mitogenactivated protein kinaseMAPK homologue expressed in gametocytes of the human malaria parasite Plasmodium falciparum Identification of a MAPK signature", 
                      "Polymorphism of the precursor for the major surface antigens of Plasmodium falciparum merozoites studies at the genetic level", 
                      "Plasmodium falciparum variations within the Cterminal region of merozoite surface antigen1", 
                      "Two major phosphoproteins of Plasmodium falciparum are heat shock proteins", 
                      "A vaccine candidate from the sexual stage of human malaria that contains EGFlike domains", 
                      "Allele frequencybased analyses robustly map sequence sites under balancing selection in a malaria vaccine candidate antigen", 
                      "Plasmodium yoelii genes encoding cdc2related and mitogenactivated protein kinases", 
                      "A chimeric Plasmodium falciparum Pfnbp2bPfnbp2a gene originated during asexual growth", 
                      "Root of the Eukaryota tree as inferred from combined maximum likelihood analyses of multiple molecular sequence data", 
                      "Allelic dimorphism in the merozoite surface protein3alpha in Korean isolates of Plasmodium vivax", 
                      "Naturally acquired Plasmodium knowlesi malaria in human Thailand", 
                      "PfLDHtargeted highthroughput screening platform of antimalarial drugs", 
                      "Population structure and adaptive evolution of Plasmodium falciparum apical membrane antigen1pfAMA1 gene implications for its vaccine design", 
                      "Differential evidence of natural selection on two leading sporozoite stage malaria vaccine candidate antigens", 
                      "Plasmodium falciparum Merozoite Surface Protein 3 Is a Target of AlleleSpecific Immunity and Alleles Are Maintained by Natural Selection", 
                      "Variation in the expression of a Plasmodium falciparum protein family implicated in erythrocyte invasion", 
                      "PfSUB2 a second subtilisinlike protein in Plasmodium falciparum merozoites", 
                      "P falciparum rosetting mediated by a parasitevariant erythrocyte membrane protein and complementreceptor 1", 
                      "Cloning and characterization of a novel Plasmodium falciparum sporozoite surface antigen STARP", 
                      "Isolation and characterization of a chaperonin60 gene of the human malaria parasite Plasmodium falciparum", 
                      "Circumsporozoite protein gene diversity among temperate and tropical Plasmodium vivax isolates from Iran", 
                      "Practical PCR genotyping protocols for Plasmodium vivax using Pvcs and Pvmsp1", 
                      "Geographical structure and sequence evolution as inferred from the Plasmodium falciparum Santigen locus", 
                      "An unusual recent expansion of the Cterminal domain of RNA polymerase II in primate malaria parasites features a motif otherwise found only in mammalian polymerases", 
                      "Analysis of kappa and omega repeats of the cg2 gene and chloroquine susceptibility in isolates of Plasmodium falciparum from subSaharan Africa", 
                      "Point mutations in Plasmodium vivax dihydrofolate reductase gene among southern isolates of Iran", 
                      "Characterization of a nonmitochondrial type I phosphatidylserine decarboxylase in Plasmodium falciparum", 
                      "Structure and expression of an adhesive proteinlike molecule of mosquito invasivestage malarial parasite", 
                      "The cloning and expression of Pfacs1 a Plasmodium falciparum fatty acyl coenzyme A synthetase1 targeted to the host erythrocyte cytoplasm", 
                      "Plasmodium falciparum structural and functional domains of the matureparasiteinfected erythrocyte surface antigen", 
                      "Lineagespecific positive selection at the merozoite surface protein 1msp1 locus of Plasmodium vivax and related simian malaria parasites", 
                      "Gene sequencing of phosphocholine cytidylytransferase from Plasmodium falciparum", 
                      "Limited polymorphism in Plasmodium falciparum sexualstage antigens", 
                      "Plasmodium falciparum asparagine and aspartate rich protein 2 is an evolutionary conserved protein whose repeats identify a new family of parasite antigens", 
                      "Amplification by polymerase chain reaction of Plasmodium falciparum DNA from Giemsastained thin blood smears", 
                      "Differential antibody recognition of FC27like Plasmodium falciparum merozoite surface protein MSP2 antigens which lack 12 amino acid repeats", 
                      "Plasmodium falciparum a region of polymorphism in the 3 end of the gene for the ringinfected erythrocyte surface antigen", 
                      "Structural and antigenic polymorphism of the 35 to 48kilodalton merozoite surface antigenMSA2 of the malaria parasite Plasmodium falciparum", 
                      "Primary amino acid sequence of the carboxylterminal region of the merozoite surface proteinMSP1 of plasmodium falciparum Vetnam Oak knollFVO strain", 
                      "High sequence conservation of protective epitopes in the Plasmodium falciparum vaccinecandidate LSA3", 
                      "Plasmodium falciparum dihydroorotate dehydrogenase gene", "Allelic lineages of the merozoite surface protein 3 gene in Plasmodium reichenowi and Plasmodium falciparum", 
                      "Unexpected variation in Pvs28 malaria transmissionblocking vaccine antigen of Plasmodium vivax but not in Pvs25", 
                      "Allelic diversity and naturally acquired allelespecific antibody responses to Plasmodium falciparum apical membrane antigen 1 in Kenya", 
                      "Single Nucleotide Polymorphisms Putatively Neutral DNA Markers and Population Genetic Parameters in Indian Plasmodium vivax Isolates", 
                      "An enlarged largest subunit of Plasmodium falciparum RNA polymerase II defines conserved and variable RNA polymerase domains", 
                      "HB3 target PF100018", "Dd2 target PF100018", "Effect of amplicon length and adenosinethymidine content on sybr green copy number estimates during realtime PCR", 
                      "Ancient common ancestry of the merozoite surface protein 1 of Plasmodium vivax as inferred from its homologue in Plasmodium knowlesi", 
                      "Dramatic difference in diversity between Plasmodium falciparum and Plasmodium vivax reticulocyte bindinglike genes", 
                      "Origins of antigenic diversity in Plasmodium falciparum when meiotic recombination is rare", 
                      "Amplification of the multidrug resistance gene pfmdr1 in Plasmodium falciparum has arisen as multiple independent events", 
                      "Structure of Plasmodium falciparum liver stage antigen1", "Plasmodium falciparum variations in the Cterminal cysteinerich region of the merozoite surface protein1 in field samples among Indian isolates", 
                      "A Plasmodium falciparum gene encoding a heat shocklike antigen related to the rat 78 Kd glucoseregulated protein", 
                      "Variation in the gene encoding a major merozoite surface antigen of the human malaria parasite Plasmodium falciparum", 
                      "Isolation of a gene coding ef1alpha from the human malaria parasite Pfalciparum", 
                      "Molecular characterisation of Plasmodium reichenowi apical membrane antigen1AMA1 comparison with P falciparum AMA1 and antibodymediated inhibition of red cell invasion", 
                      "Hypervariability in a leading P vivax malaria vaccine candidate the merozoite surface protein 1", 
                      "Polymorphism of the vaccine candiate Merozoite surface protein1 of Plasmodium falciparum in Indian isolates", 
                      "Polymorpism of the vaccine candidate merozoite surface protein of plasmodium falciparum in Indian isolates", 
                      "Highlevel expression of the malaria bloodstage vaccine candidate Plasmodium falciparum apical membrane antigen 1 and induction of antibodies that inhibit erythrocyte invasion", 
                      "PfPO conserved region among Indian isolates", "Genotyping of P falciparum isolate from Ledong Hainan Province China", 
                      "Genotyping of P falciparum isolate from Tengchong Yunnan Province China", 
                      "Genotyping of P falciparum isolate from Ruili Yunnan Province China", 
                      "Highthroughput identification of the predominant malaria parasite clone in complex blood stage infections using a multiSNP molecular haplotyping assay", 
                      "Mutually exclusive expression of Plasmodium falciparum var genes is developmentally controlled at the level of transcription initiation", 
                      "Extensive proteolytic processing of the malaria parasite merozoite surface protein 7 during biosynthesis and parasite release from erythrocytes", 
                      "Diversity of Plasmodium falciparum vaccine candidate merozoite surface protein 4MSP4 in a natural population", 
                      "Phylogenetic analysis of the Plasmodium vivax circumsporozoite protein gene sequence from resurgent Korea isolate", 
                      "Phylogenetic analysis of circumsporozoite protein gene sequences from Plasmodium vivax isolates in the Republic of Korea", 
                      "Allelic variation in the cg2 gene does not correlate with chloroquine resistance among Indian Plasmodium falciparum isolates", 
                      "Cloning of Plasmodium falciparum protein disulfide isomerase homologue by affinity purification using the antiplasmodial inhibitor 14bis3Ncyclohexyl methylaminopropylpiperazine", 
                      "A chromatinassociated protein is encoded in a genomic region highly conserved in the Plasmodium genus", 
                      "The complete sequence of the gene for the knobassociated histidinerich protein from Plasmodium falciparum", 
                      "The 111 gene of Plasmodium falciparum codes for distinct fast evolving repeats", 
                      "pfmdr2 confers heavy metal resistance to Plasmodium falciparum", 
                      "Geographic structuring of the Plasmodium falciparum Sarcoendoplasmic reticulum Ca2 ATPasePfSERCA gene diversity", 
                      "Var genes in a Chinese isolate", "African great apes are natural hosts of multiple related malaria species including Plasmodium falciparum", 
                      "Association of microsatellite variations of Plasmodium falciparum NaH exchangerPfnhe1 gene with reduced in vitro susceptibility to quinine lack of confirmation in clinical isolates from Africa", 
                      "Plasmodium knowlesi malaria in Vietnam some clarifications", 
                      "Genetic polymorphism in 32 kDa Plasmodium vivax Tryptophanrich antigen genePvTRAg32in clinical isolates", 
                      "Allelic polymorphism and antibody responses to Plasmodium falciparum PfMSP1 block2 at the community level a complex relationship", 
                      "Studies on Plasmodium knowlesi infections in Malaysian Borneo", 
                      "ama1 genes of sympatric Plasmodium vivax and P falciparum from Venezuela differ significantly in genetic diversity and recombination frequency", 
                      "The primaquine tolerant phenotype of Plasmodium vivax isolates from the South West Pacific region is shared between genotypically diverse organisms", 
                      "Predicted and observed alleles of Plasmodium falciparum merozoite surface protein1MSP1 a potential malaria vaccine antigen", 
                      "The molecular cloning and DNA sequence analysis of Plasmodium falciparum erythrocyte membrane protein 1", 
                      "Protective immune responses to apical membrane antigen 1 of Plasmodium chabaudi involve recognition of strainspecific epitopes", 
                      "Plasmodium falciparum in vitro characterization and human infectivity of a cloned line", 
                      "Two novel alleles within subfamilies of the merozoite surface antigen 2MSA2 of Plasmodium falciparum", 
                      "Several novel membraneassociated plasmodium falciparum antigens cloned by expression in COS cells", 
                      "Plasmodium falciparum limited genetic diversity of MSP2 in isolates circulating in Brazilian endemic areas", 
                      "The sequence of the p82 rhoptry protein is highly conserved between two Plasmodium falciparum isolates", 
                      "The dihydrofolate reductase domain of rodent malarias point mutations and pyrimethamine resistance", 
                      "Evaluation of the genetic polymorphism of Plasmodium falciparum P126 proteinSERA or SERP and its influence on naturally acquired specific antibody responses in malariainfected individuals living in...", 
                      "Circumsporozoite proteinCSP PvSK2 from Plasmodium vivax South Korean isolate", 
                      "SadenosylLhomocysteine hydrolase from Plasmodium falciparum structure evolution and interactions with inhibitors", 
                      "Cloning and characterization of a Plasmodium falciparum cyclophilin gene that is stagespecifically expressed", 
                      "Genetic diversity of the DBLalpha region in Plasmodium falciparum var genes among AsiaPacific isolates", 
                      "Analysis of the Plasmodium vivax apical membrane antigen1 gene from reemerging Korean isolates", 
                      "A novel Plasmodium falciparum erythrocyte binding protein2EBP2BAEBL involved in erythrocyte receptor binding", 
                      "Sequence analysis of the apical membrane antigen IAMA1 of Plasmodium vivax", 
                      "Documentation of Plasmodium vivax malaria parasite in Gabon West Africa", 
                      "Primary structure and expression of the dihydropteroate synthetase gene of Plasmodium falciparum", 
                      "Molecular characterization of chloroquine resistance transporter gene in a resistant species of Plasmodium berghei", 
                      "Genotyping and sequence analysis of Pvmsp1 of Plasmodium vivax isolates from China", 
                      "Cloning and characterization of a vacuolar ATPase A subunit homologue from Plasmodium falciparum", 
                      "Structure and expression of the gene for Pv200 a major bloodstage surface antigen of Plasmodium vivax", 
                      "Proteolytic processing of the Plasmodium falciparum merozoite surface protein1 produces a membranebound fragment containing two epidermal growthl factorlike domains", 
                      "Structural diversity in the Plasmodium falciparum merozoite surface antigen 2", 
                      "The impact of virulence and genetic diversity in Plasmodium chabaudi AMA1 on vaccination with AMA1 protein", 
                      "Reactivity profile of human anti82kilodalton rhoptry protein antibodies generated during natural infection with Plasmodium falciparum", 
                      "Comparative genomics in Plasmodium a tool for the identification of genes and functional analysis", 
                      "Plasmodium falciparumHNFCC1 cg1 gene", "Cloning studies on the gene coding for Llactate dehydrogenase of Plasmodium falciparum", 
                      "Circumsporozoite protein heterogeneity in the human malaria parasite Plasmodium vivax", 
                      "Primary structure of a Plasmodium falciparum malaria antigen located at the merozoite surface and within the parasitophorous vacuole", 
                      "Enhancement or inhibition of Plasmodium falciparum erythrocyte reinvasion in vitro by antibodies to an asparagine rich protein", 
                      "Molecular characterization of a Plasmodium falciparum gene that is differentially expressed during development", 
                      "Large deletions result from breakage and healing of P falciparum chromosomes", 
                      "First cases of P knowlesi in Viet Nam", "SURFIN is a polymorphic antigen expressed on Plasmodium falciparum merozoites and infected erythrocytes", 
                      "Immunological characterization of MSP1 42 from Indian Plasmodium falciparum alleles", 
                      "Malaria parasites can develop stable resistance to artemisinin but lack mutations in candidate genes atp6encoding the sarcoplasmic and endoplasmic reticulum Ca2 ATPase tctp mdr1 and cg10", 
                      "Gene encoding erythrocyte binding ligand linked to blood stage multiplication rate phenotype in Plasmodium yoelii yoelii", 
                      "The age of the human malaria parasite Plasmodium vivax", "Selective upregulation of a single distinctly structured var gene in chondroitin sulphate Aadhering Plasmodium falciparum involved in pregnancyassociated malaria", 
                      "Genetic diversity of Plasmodium falciparum histidinerich protein 2PfHRP2 and its effect on the performance of PfHRP2based rapid diagnostic tests", 
                      "Polymorphism in the gene encoding the apical membrane antigen1AMA1 of Plasmodium falciparum X Asembo Bay Cohort Project", 
                      "Genetic diversity of Plasmodium vivax isolates from Azerbaijan", 
                      "Sequence variation in the Tcell epitopes of the Plasmodium falciparum circumsporozoite protein among field isolates is temporally stable a 5year longitudinal study in southern Vietnam", 
                      "Identification of an MCM4 homologue expressed specifically in the sexual stage of Plasmodium falciparum", 
                      "Characterization of a redoxactive 21 kDa protein from the malaria parasite Plasmodium falciparum", 
                      "Growth of Toxoplasma gondii is inhibited by aryloxyphenoxypropionate herbicides targeting acetylCoA carboxylase", 
                      "Characterization of three genes encoding enzymes of the folate biosynthetic pathway in Plasmodium falciparum", 
                      "Global sequence variation in the histidinerich protein 2 of Plasmodium falciparum implications for performance of rapid diagnostic tests for malaria", 
                      "Partial Sequence Analysis of Merozoite Surface Proteine3 Alpha Gene in Plasmodium vivax Isolates from Malarious Areas of Iran", 
                      "Sequencing and homology analysis of the glutamate dehydrogenase gene from Plasmodium falciparumFCC1HN", 
                      "Characterization of the flap endonuclease 1 homolog from the human malaria parasite Plasmodium falciparum", 
                      "Sequence determination of exp1 gene of Plasmodium falciparum isolate FCC1HN", 
                      "Sequence of blood stage TATAbinding proteinTBP gene of Plasmodium falciparumisolate FCC1HN", 
                      "Cloning of a Plasmodium falciparum gene related to the human 60kDa heat shock protein", 
                      "Plasmodium falciparum multidrug resistance protein 1 and artemisininbased combination therapy in Africa", 
                      "Plasmodium falciparum var sequence taq sites", "Sequence diversity in the aminoterminal 47 kDa fragment of the Plasmodium falciparum serine repeat antigen", 
                      "Interallelic recombination in the merozoite surface protein 1MSP1 gene of Plasmodium vivax from Thai isolates", 
                      "Merozoite surface antigen 2MSA2 gene of Plasmodium falciparum strains from India", 
                      "The 5 coding region of the Plasmodium falciparum circumsporozoite protein gene is a focus for deletion and insertion events", 
                      "A new polymorphic marker for PCR typing of Plasmodium vivax parasites", 
                      "Sequence of the small subunit ribosomal RNA gene expressed in the bloodstream stages of Plasmodium berghei evolutionary implications", 
                      "Heterogeneity and expression of the Plasmodium falciparum 58S ribosomal RNA genes", 
                      "Highly conserved genes and their use to generate probes and primers for detection of microorganisms", 
                      "Plasmodium falciparum krueppellike gene", "Conservation and heterogeneity of the glutamaterich proteinGLURP among field isolates and laboratory lines of Plasmodium falciparum", 
                      "Differential transcriptional regulation of P falciparum 5S ribosomal RNA gene copies via upstream sequences", 
                      "Activation of a Plasmodium falciparum cdc2related kinase by heterologous p25 and cyclin H Functional characterization of a P falciparum cyclin homologue", 
                      "The evolutionary origin of the 35 kb circular DNA of Plasmodium falciparum new evidence supports a possible rhodophyte ancestry", 
                      "Polymorphisms in erythrocyte binding antigens 140 and 181 affect function and binding but not receptor specificity in Plasmodium falciparum", 
                      "Plasmodium falciparum Merozoite Surface Protein1 Block 1633 kDa and Block 1719 kDa Genetic Diversity with Correlative AntiPfMSP119kD Immune Response Analysis", 
                      "Geographical structure of diversity and differences between symptomatic and asymptomatic infections for Plasmodium falciparum vaccine candidate AMA1", 
                      "Genetic diversity in the msp2 gene of Plasmodium falciparum from endemic region of Iran", 
                      "Plasmodium falciparum the repetitive MSA1 surface protein of the RO71 isolate is recognized by mouse antibody against the nonrepetitive repeat block of RO33", 
                      "Allelic dimorphism in a surface antigen gene of the malaria parasite Plasmodium falciparum", 
                      "The gene encoding topoisomerase II from Plasmodium falciparum", 
                      "Characterization of irondependent endogenous superoxide dismutase of Plasmodium falciparum", 
                      "Plasmodium falciparum Recombination within the Cterminal region of merozoite surface antigen1", 
                      "A naturally occuring gene encoding the major surface antigen precursor P190 of plasmodium falciparum lacks tripeptide repeats", 
                      "Merozoite surface protein sequence from the Camp strain of the human malaria parasite Plasmodium falciparum", 
                      "Polymorphism of the vaccine candidate merozoite surface protein1 of Plasmodium falciparum in Indian isolates", 
                      "Glutathione synthetase of Plasmodium falciparum", "A subtilisinlike protein in secretory organelles of Plasmodium falciparum merozoites", 
                      "Genetic distance in housekeeping genes between Plasmodium falciparum and Plasmodium reichenowi and within P falciparum", 
                      "Plasmodium falciparum associated with severe childhood malaria preferentially expresses PfEMP1 encoded by group A var genes", 
                      "Amplification of pfmdr 1 associated with chloroquine resistance in Plasmodium falciparum isolate from Hainan China", 
                      "Patterns of gene recombination shape var gene repertoires in Plasmodium falciparum comparisons of geographically diverse isolates", 
                      "Repetitive sequences upstream of the pfg2725 gene determine polymorphism in laboratory and natural lines of Plasmodium falciparum", 
                      "Comparison of introns in a cdc2homologous gene within a number of Plasmodium species", 
                      "Plasmodium falciparum Genetic polymorphism of Merozoite surface antigenMSA2 gene of strains from India", 
                      "Plasmodium falciparum Genetic polymorphism of Metozoite Surface AntigenMSA2 gene of strains from India", 
                      "Molecular cloning of a Plasmodium falciparum gene interrupted by 15 introns encoding a functional primase 53 kDa subunit as demonstrated by expression in a baculovirus system", 
                      "tRNA genes transcribed from the plastidlike DNA of Plasmodium falciparum", 
                      "Isolation of a novel glutamine alanine rich protein from Plasmodium beghei", 
                      "Molecular cloning genomic structure and localization in a blood stage antigen of Plasmodium falciparum characterized by a serine stretch", 
                      "Cloning and characterisation of a Plasmodium falciparum homologue of the RanTC4 signal transducing GTPase involved in cell cycle control", 
                      "Plasmodium falciparum drug resistance in Madagascar facing the spread of unusual pfdhfr and pfmdr1 haplotypes and the decrease of dihydroartemisinin susceptibility", 
                      "Human Plasmodium knowlesi infection detected by rapid diagnostic tests for malaria", 
                      "Antigenic Diversity of the Plasmodium vivax Circumsporozoite Protein in West Colombian Isolates Parasites", 
                      "First detection case in Spain by real time PCR of Plasmodium knowlesi in a traveller from Southeast Asia case report", 
                      "Molecular epidemiology of Plasmodium vivax in the State of Amazonas Brazil", 
                      "Extense variant gene family repertoire overlap in Western Amazon Plasmodium falciparum isolates", 
                      "Allelic dimorphism of Plasmodium vivax gam1 in the Indian subcontinent", 
                      "Positive selection on the Plasmodium falciparum sporozoite threonineasparaginerich protein analysis of isolates mainly from low endemic areas", 
                      "Polymorphism in the dimorphic antigen MSP6 in Plasmodium falciparum and comparison with other MSP1associated merozoite surface antigens", 
                      "Cloning sequence and expression of the lactate dehydrogenase gene from the human malaria parasite Plasmodium vivax", 
                      "Antibodies against conformational epitopes of merozoite surface protein8 protect against lethal but not nonlethal Plasmodium yoelii malaria", 
                      "Paraaminobenzoic acid synthetase is not required for growth of Plasmodium berghei", 
                      "Intragenic recombination in the 3 portion of the merozoite surface protein 1 gene of Plasmodium vivax", 
                      "Structure and expression of the Plasmodium falciparum SERA gene", 
                      "Intergenic recombination within the Duffy Binding Microneme ProteinMP1 Family of Plasmodium knowlesi", 
                      "The surface variant antigens of Plasmodium falciparum contain crossreactive epitopes", 
                      "Mutations in the multidrug resistanceMDR gene of Plasmodium falciparum isolate FCC1HN", 
                      "Cloning of the triosephosphate isomerase gene of Plasmodium falciparum and expression in Escherichia coli", 
                      "Analysis of variation in PF83 an erythrocytic merozoite vaccine candidate antigen of Plasmodium falciparum", 
                      "Multiple infections and unusual distribution of block 2 of the MSA1 gene of Plasmodium falciparum detected in west African clinical isolates by polymerase chain reaction analysis", 
                      "Cloning metabolic pathway genes by complementation in Escherichia coli Isolation and expression of Plasmodium falciparum glucose phosphate isomerase", 
                      "A Plasmodium falciparum blood stage antigen highly homologous to the glycophorin binding protein GBP", 
                      "Analysis of MSA1 diversity in Plasmodium chabaudi chabaudi strains", 
                      "A calpain unique to alveolates is essential in Plasmodium falciparum and its knockdown reveals an involvement in preSphase development", 
                      "Characterization of the merozoite surface protein 45 gene of Plasmodium berghei and Plasmodium yoelii", 
                      "Molecular cloning of a gene encoding a 20S proteasome beta subunit from Plasmodium falciparum", 
                      "ICAM1 binding site on parasite variant antigen PfEMP1 in cytoadherent Plasmodium falciparum clone A4tres", 
                      "Shotgun DNA microarrays for identifying stagespecific gene expression in Plasmodium falciparum", 
                      "Cloning and characterization of the merozoite surface antigen 1 gene of Plasmodium berghei", 
                      "Sequence of Plasmodium falciparum secreted polymorphic antigen gene", 
                      "Highthroughput sequence typing of Tcell epitope polymorphisms in Plasmodium falciparum circumsporozoite protein", 
                      "Cloning and sequencing of the genes coding for the histidinerich protein II of Plasmodium falciparum", 
                      "stevor and rif are Plasmodium falciparum multicopy gene families which potentially encode variant antigens", 
                      "A malaria membrane skeletal protein is essential for normal morphogenesis motility and infectivity of sporozoites", 
                      "Differential recognition of Plasmodium falciparum merozoite surface protein 2 variants by antibodies from malaria patients in Brazil", 
                      "Identification of an endoplasmic reticulumresident calciumbinding protein with multiple EFhand motifs in asexual stages of Plasmodium falciparum", 
                      "Expressed var genes are found in Plasmodium falciparum subtelomeric regions", 
                      "An unexpected 5 untranslated intron in the P falciparum genes for histidinerich proteins II and III", 
                      "A putative Plasmodium falciparum exported serinethreonine protein kinase", 
                      "Temporal variation of the merozoite surface protein2 gene of Plasmodium falciparum", 
                      "NYVACPf7 a poxvirusvectored multiantigen multistage vaccine candidate for Plasmodium falciparum malaria", 
                      "Transcription mapping of a 100 kb locus of Plasmodium falciparum identifies an intergenic region in which transcription terminates and reinitiates", 
                      "Common surfaceantigen var genes of limited diversity expressed by Plasmodium falciparum placental isolates separated by time and space", 
                      "Compartmentalization of genes coding for immunodominant antigens to fragile chromosome ends leads to dispersed subtelomeric gene families and rapid gene evolution in Plasmodium falciparum", 
                      "Limited RAP1 sequence diversity in field isolates of Plasmodium falciparum", 
                      "A Plasmodium chabaudi protein contains a repetitive region with a predicted spectrinlike structure", 
                      "A novel P falciparum gene with homology to HSP70", "Plasmodium falciparum enhanced soluble expression purification and biochemical characterization of lactate dehydrogenase", 
                      "Plasmodium knowlesi in humans macaques and mosquitoes in peninsular Malaysia", 
                      "Immunogenicity of a recombinant malaria vaccine candidate domain III of AMA1 ectodomain from Indian P falciparum alleles", 
                      "Cloning and analysis of the gene encoding the 230kilodalton merozoite surface antigen of Plasmodium yoelii", 
                      "Gametocytedominant expression of a novel Ptype ATPase in Plasmodium yoelii", 
                      "Sequence variations in the nonrepetitive regions of the liver stagespecific antigen1LSA1 of Plasmodium falciparum from field isolates", 
                      "Multiple genes code for highmolecularmass rhoptry proteins of Plasmodium yoelii", 
                      "Analysis of stagespecific transcripts of the Plasmodium falciparum serine repeat antigenSERA gene and transcription from the SERA locus", 
                      "Natural variation within the principal adhesion domain of the Plasmodium vivax duffy binding protein", 
                      "Genetic diversity of Plasmodium falciparum in Myanmar", "Mutation in pfmdr1 gene in chloroquineresistant Plasmodium falciparum isolates Southeast Iran", 
                      "Primary sequences of pvmdr1 and pvcrto genes from chloroquine sensitive and chloroquine resistance Brazilian isolates", 
                      "Sequence of blocks 3 and 4 of the MSA1 gene of Plasmodium falciparum clone 3D7", 
                      "Further characterization of a 58 kDa Plasmodium berghei phosphoprotein as a cochaperone", 
                      "Phylogenetic analysis of the genus Plasmodium based on the gene encoding adenylosuccinate lyase", 
                      "Properties of the Plasmodium falciparum homologue of a protective vaccine candidate of Plasmodium yoelii", 
                      "The 3 portion of the gene for a Plasmodium yoelii merozoite surface antigen encodes the epitope recognized by a protective monoclonal antibody", 
                      "Structural diversity in the 45kilodalton merozoite surface antigen of Plasmodium falciparum", 
                      "The epitope of a protective monoclonal antibody occurs in a region of microheterogeneity in Plasmodium chabaudi", 
                      "Amplification of a gene related to mammalian mdr genes in drugresistant Plasmodium falciparum", 
                      "Characterization of a Plasmodium falciparum epitope recognized by a monoclonal antibody with broad isolate and species specificity", 
                      "Structure of the FIRA gene of Plasmodium falciparum", "Sequence variation in putative functional domains of the circumsporozoite protein of Plasmodium falciparum Implications for vaccine development", 
                      "Distribution and characterisation of the 235 kDa rhoptry multigene family within the genomes of virulent and avirulent lines of Plasmodium yoelii", 
                      "Cloning and sequence analysis of a conserved gene from Plasmodium falciparum", 
                      "Molecular phylogenetic analysis of MSP1 gene from North Korean refugee", 
                      "Structure of the gene encoding the immunodominant surface antigen on the sporozoite of the human malaria parasite Plasmodium falciparum", 
                      "Nucleotide sequence and expression of a betatubulin gene from Plasmodium falciparum a malarial parasite of man", 
                      "Structure of the apical membrane antigen IAMA1 of Plasmodium chabaudi", 
                      "Characterization of a histidinerich protein related gene from Plasmodium falciparum", 
                      "Plasmodium vivax partial msp1 gene for merozoite surface protein 1 isolate from South Korea", 
                      "Identification of a novel gene encoding DNA replication licensing factor MCM2 homolog from the human malaria parasite Plasmodium falciparum", 
                      "Identification of PfPKCI1 a putative protein kinase C interacting protein 1 from the human malaria parasite Plasmodium falciparum", 
                      "Molecular cloning and sequencing of the circumsporozoite protein gene from Plasmodium falciparum strain FCC1HN and expression of the gene in Mycobacteria", 
                      "Multistage multiantigen heterologous prime boost vaccine for Plasmodium knowlesi malaria provides partial protection in rhesus macaques", 
                      "Cloning and structure of apical membrane antigen 1AMA1 gene of Plasmodium falciparum isolate FCC1HN", 
                      "A large focus of naturally acquired Plasmodium knowlesi infections in human beings", 
                      "Comparison of efficacies of cysteine protease inhibitors against five strains of Plasmodium falciparum", 
                      "Molecular cloning and sequence analysis of major merozoite surface antigengp195gene of Plasmodium falciparum isolate FCC1HN", 
                      "Diversity and prevalence of the Cterminal region of Plasmodium falciparum merozoite surface protein 1 in China", 
                      "Amplification cloning and sequence analysis of a SSUrRNA gene fragment of Plasmodium vivax isolates from Yunnan Province", 
                      "In vitro amplification cloning and sequence analysis of GLURP gene of Plasmodium falciparum isolate FCC1HN", 
                      "Polymorphism of Plasmodium vivax apical membrane antigen1 from Thailand", 
                      "Isolation of the 104kDa heat shock protein from Plasmodium falciparum", 
                      "New repeat unit and hot spot of recombination in FC27type alleles of the gene coding for Plasmodium falciparum merozoite surface protein 2", 
                      "A novel means of generating cDNA libraries from trace quantities of RNA and subsequent identification of the Plasmodium falciparum ribosomal P2 protein", 
                      "Cloning and expression of the thrombospondin related adhesive protein gene of Plasmodium berghei", 
                      "Genetic diversity in the Plasmodium falciparum NaH exchanger1 transporter protein of isolates from the Republic of Congo", 
                      "Characterisation of the rhoph2 gene of Plasmodium falciparum and Plasmodium yoelii", 
                      "Ioslation characterisation and expression of the gene coding phosphoribosylpyrophosphate synthetase from Plasmodium falciparum", 
                      "Stagespecific expression of a Plasmodium falciparum protein related to the eukaryotic mitogenactivated protein kinases", 
                      "Monkey malaria in a European traveler returning from Malaysia", 
                      "Sequence of the gene encoding the Nterminal portion of the Plasmodium yoelii yoelii 17XL merozoite surface protein1MSP1", 
                      "Gene cloning of circumsporozoite proteinCSP II gene from Plasmodium falciparumFCC1HN", 
                      "Limited polymorphism of the vaccine candidate merozoite surface protein 4 of Plasmodium falciparum", 
                      "Plasmodium falciparum the pfmdr2 protein is not overexpressed in chloroquineresistant isolates of the malaria parasite", 
                      "Nucleotide sequence analysis and epitope mapping of the merozoite surface protein 1 from Plasmodium chabaudi chabaudi AS", 
                      "Amino acid changes linked to pyrimethamine resistance in the dihydrofolate reductasethymidylate synthase gene of Plasmodium falciparum", 
                      "Molecular cloning and localization of an abundant novel protein of Plasmodium berghei", 
                      "Identification of the CCR5Delta32 HIV resistance allele and new mutations of the CCR5 gene in different Tunisian populations", 
                      "Fourteen polymorphic microsatellite DNA markers for the human malaria parasite Plasmodium vivax", 
                      "Geographical patterns of allelic diversity in the Plasmodium falciparum malariavaccine candidate merozoite surface protein2", 
                      "Characterization of Plasmodium falciparum sporozoite surface protein 2", 
                      "Interspersed repetitive DNA from Plasmodium falciparum", "Characterisation and sequence of a protective rhoptry antigen from Plasmodium falciparum", 
                      "Characterization of the gene encoding the largest subunit of Plasmodium falciparum RNA polymerase III", 
                      "Genes for Plasmodium falciparum surface antigens cloned by expression in COS cells", 
                      "Identification of a common Plasmodium epitopeCPE recognised by a panspecific inhibitory monoclonal antibody", 
                      "Isolation from a Plasmodium chabaudi chromosome 7 specific library of a novel gene encoding a protein with multiple GGMP repeats homologous to hsp70", 
                      "Molecular cloning and sequence analysis of the Plasmodium falciparum dihydrofolate reductasethymidylate synthase gene", 
                      "Mononeme a new secretory organelle in Plasmodium falciparum merozoites identified by localization of rhomboid1 protease", 
                      "Structural features of Plasmodium cytochrome b that may underlie susceptibility to 8aminoquinolines and hydroxynaphthoquinones", 
                      "Possible chloroquineresistance gene in Plasmodium falciparum", 
                      "Aldolase genes of Plasmodium species", "Molecular cloning and structure analysis of the Plasmodium falciparum erythrocyte membraneassociated giant protein Ag332Pf332 gene", 
                      "Construction and identfication of fulllength cDNA library of Plasmodium falciparumHNFCC1", 
                      "Precursor to the major merozoite surface antigen of Plasmodium yoelii cloning and sequencing of the middle 19kb region", 
                      "Stagespecific expression and genomic organization of the actin genes of the malaria parasite Plasmodium falciparum", 
                      "Extremely diverged actin proteins in Plasmodium falciparum", 
                      "Completing the hypusine pathway in Plasmodium", "Multiple var2csatype PfEMP1var genes located at different chromosomal loci occur in many Plasmodium falciparum isolates", 
                      "Molecular characterization of the largest subunit of Plasmodium falciparum RNA polymerase I", 
                      "Identification of a second proliferating cell nuclear antigen in the human malarial pathogen Plasmodium falciparum", 
                      "The erythrocyte binding motif of plasmodium vivax duffy binding protein is highly polymorphic and functionally conserved in isolates from Papua New Guinea", 
                      "Evidence for different mechanisms of chloroquine resistance in 2 Plasmodium species that cause human malaria", 
                      "Cloning and sequence analysis of 3 region of liver stage antigen1 gene of Plasmodium falciparum isolate FCC1HN", 
                      "Single amino acid substitution in Plasmodium yoelii erythrocyte ligand determines its localization and controls parasite virulence", 
                      "Plasmodium vivax Duffy binding protein a modular evolutionary proposal", 
                      "Antigenic crossreactivity between different alleles of the Plasmodium falciparum merozoite surface protein 2", 
                      "Pfcrt and Pfmdr1 Alleles Associated with Chloroquine Resistance in Plasmodium falciparum from Guyana South America", 
                      "Evaluation of the antigenic diversity of placentabinding Plasmodium falciparum variants and the antibody repertoire among pregnant women", 
                      "Polymorphism in Plasmodium vivax MSA1 genethe result of intragenic recombinations", 
                      "The SouthAmerican Plasmodium falciparum var gene repertoire is limited highly shared and lacks several antigenic types", 
                      "Cloning and sequence analysis of LDH gene of Plasmodium falciparum isolate FCC1HN", 
                      "Identification and characterization of falcilysin a metallopeptidase involved in hemoglobin catabolism within the malaria parasite Plasmodium falciparum", 
                      "Plasmodium falciparum homologue of the vacuolar protonpumping pyrophosphatase of plants", 
                      "Characterisation of the gene encoding adenylosuccinate lyase of Plasmodium falciparum", 
                      "A Plasmodium falciparum Apical Membrane Antigen1AMA1 gene apparently generated by intragenic recombination", 
                      "A Plasmodium falciparum apical membrane antigen1AMA1 gene apparently generated by intragenic recombination", 
                      "Structure of the gene for Plasmodium falciparum isolate FCC1HN transmission blocking target antigen Pfs230", 
                      "Amplification of pvmdr1 and pvcrto genes of Plasmodium vivax isolates from different areas of endemicity", 
                      "Sequence variation in the nonrepeat region of the Plasmodium falciparum glutamate rich proteinGLURP from Brazil Senegalese and Burmese field isolates and from laboratory strains", 
                      "Molecular epidemiology of Plasmodium vivax malaria a study on different isolates following the occurrence of an Italian indigenous case", 
                      "Sequence and length polymorphism of a major malaria vaccine candidate analysed following DNA amplification", 
                      "Plasmodium falciparum var sequence tag sites", "DNA sequence of the gene encoding a Plasmodium falciparum malaria candidate vaccine antigen", 
                      "Minimal variation in the transmissionblocking vaccine candidate Pfs4845 of the human malaria parasite Plasmodium falciparum", 
                      "Sequence conservation of a functional domain of erythrocyte binding antigen 175 in Plasmodium falciparum", 
                      "A plasma membranetype Ca2ATPase colocalizes with a vacuolar Hpyrophosphatase to acidocalcisomes of Toxoplasma gondii", 
                      "Actin in the parasite Toxoplasma gondii is encoded by a single copy gene ACT1 and exists primarily in a globular form", 
                      "Algae or protozoa phylogenetic position of euglenophytes and dinoflagellates as inferred from mitochondrial sequences", 
                      "Toxoplasma gondii structure and characterization of the 26S ribosomal RNA and peptidyl transferase domain", 
                      "Structural characteristics of the Toxoplasma ribosome", "Detection of Toxoplasma gondii oocysts in water sample concentrates by realtime PCR", 
                      "Cloning of cDNAs encoding a 28 kilodalton antigen of Toxoplasma gondii", 
                      "Surface antigens of Toxoplasma gondii variations on a theme", 
                      "A family of repeated DNA sequences in Toxoplasma gondii cloning sequence analysis and use in strain characterization", 
                      "Molecular characterization of Neospora caninum sequences from a Korean isolate", 
                      "Molecular cloning complete sequence of the small subunit ribosomal RNA coding region and phylogeny of Toxoplasma gondii", 
                      "Cloning and expression of GRA4 sequence of Toxoplasma gondii", 
                      "High Resolution Typing of Toxoplasma gondii Using Microsatellite Loci", 
                      "Identification and expression analysis of ABC proteinencoding genes in Toxoplasma gondii Toxoplasma gondii ATPbinding cassette superfamily", 
                      "The identification of a sequence related to apicomplexan enolase from Sarcocystis neurona", 
                      "Biological and molecular characterization of a Toxoplasma gondii strain obtained from a freeliving jaguarPanthera onca in French Guiana", 
                      "Evidence for a single origin of the 35 kb plastid DNA in Apicomplexans", 
                      "Identification and characterisation of a regulatory region in the Toxoplasma gondii hsp70 genomic locus", 
                      "cDNA cloning and expression of UDPNacetylDgalactosaminepolypeptide Nacetylgalactosaminyltransferase T1 from Toxoplasma gondii", 
                      "Cloning expression and purification of new Toxoplasma gondii antigens", 
                      "Comparison of two DNA targets for the diagnosis of Toxoplasmosis by realtime PCR using fluorescence resonance energy transfer hybridization probes", 
                      "Dog shedding oocysts of Neospora caninum PCR diagnosis and molecular phylogenetic approach", 
                      "Toxoplasma gondii catalase are there peroxisomes in toxoplasma", 
                      "Toxoplasma gondii virulence markers identified by random amplified polymorphic DNA polymerase chain reaction", 
                      "Effects of sequence alignment and structural domains of ribosomal DNA on phylogeny reconstruction for the protozoan family sarcocystidae", 
                      "Transplacental toxoplasmosis in naturallyinfected whitetailed deer isolation and genetic characterization of Toxoplasma gondii from fetuses of different gestational ages", 
                      "Toxoplasma gondii in red foxVulpes vulpes in Poland", "Genotype of Toxoplasma gondii Korean isolate KI1", 
                      "Expression characterization and serological reactivity of a 41 kDa excretedsecreted antigenESA from Toxoplasma gondii", 
                      "Toxoplasma gondii dense granule protein 3GRA3 is a type I transmembrane protein that possesses a cytoplasmic dilysineKKXX endoplasmic reticulumER retrieval motif", 
                      "Transmission of Toxoplasma clues from the study of sea otters as sentinels of Toxoplasma gondii flow into the marine environment", 
                      "Genomic and cDNA sequence of Toxoplasma gondii hypoxanthinexanthineguanine phosphoribosyl transferase enzymeHXGPRTase", 
                      "Toxoplasma gondii 5S ribosomal RNA gene and 5S18S ribosomal RNA intergenic spacer region", 
                      "Molecular characterization of a 65kilodalton Toxoplasma gondii antigen expressed abundantly in the matrix of tissue cysts", 
                      "ITS1 of Neospora caninumSweB1 strain", "Detection of Neospora caninum DNA by the polymerase chain reaction", 
                      "Characterisation of a canine European isolate of Neospora caninum", 
                      "Investigation of Neospora caninum Hammondia heydorni and Toxoplasma gondii in slaughtered beef cattle from Bahia Brazil", 
                      "A pseudouridine synthase homologue is critical to cellular differentiation in Toxoplasma gondii", 
                      "Intervacuolar transport and unique topology of GRA14 a novel dense granule protein in Toxoplasma gondii", 
                      "The role of ATPbinding cassetteABC proteins in protozoan parasites", 
                      "Hammondia heydorni evidence of genetic diversity among isolates from dogs", 
                      "Transmission of Neospora caninum between wild and domestic animals", 
                      "Cryptosporidium parvum Phylogenomic evidence for organelle loss intracellular and horizontal gene transfer", 
                      "Identification and partial characterization of an ATPbinding cassetteABC transporterencoding gene in Toxoplasma gondii", 
                      "Shedding of Neospora caninum oocysts by dogs fed tissues from naturally infected water buffaloesBubalus bubalis from Brazil", 
                      "Cloning and characterization of MIC3 adhesin from Toxoplasma gondii strain RHSSI", 
                      "The SAG5 locus of Toxoplasma gondii encodes three novel proteins belonging to the SAG1 family of surface antigens", 
                      "Toxoplasma gondii identification of a developmentally regulated family of genes related to SAG2", 
                      "Fatal outbreak of human toxoplasmosis along the Maroni River epidemiological clinical and parasitological aspects", 
                      "A new perspective on and reassessment of SAG2 locus as the tool for genetic analysis of Toxoplasma gondii isolates", 
                      "Polymorphic secreted kinases are key virulence factors in toxoplasmosis", 
                      "Cloning and characterization of a bradyzoitespecifically expressed genehsp30bag1 of Toxoplasma gondii related to genes encoding small heatshock proteins of plants", 
                      "Secreted serinethreonine kinases in Toxoplasma", "Biologic morphologic and molecular characterisation of Neospora caninum isolates from littermate dogs", 
                      "Identification and expression analysis of ABC proteinencoding genes in Toxoplasma gondii", 
                      "Comparison of the large subunit ribosomal DNA of Neospora and toxoplasma and development of a new genetic marker for their differentiation based on the D2 domain", 
                      "The toxoplasma micronemal protein MIC4 is an adhesin composed of six conserved apple domains", 
                      "Molecular typing of Toxoplasma gondii strains by GRA6 gene sequence analysis", 
                      "The major 36 kDa Neospora caninum tachyzoite surface protein is closely related to the major Toxoplasma gondii surface antigen", 
                      "Gene sequence and transcription differences in 70 kDa heat shock protein correlate with murine virulence of Toxoplasma gondii", 
                      "Nuclearencoded proteins target to the plastid in Toxoplasma gondii and Plasmodium falciparum", 
                      "Isolation and molecular characterization of the bifunctional hydroxymethyldihydropterin pyrophosphokinasedihydropteroate synthase gene from Toxoplasma gondii", 
                      "Phylogeny of the large extrachromosomal DNA of organisms in the phylum Apicomplexa", 
                      "Identification of two alleles in the GRA4 locus of Toxoplasma gondii determining a differential epitope which allows discrimination of type I versus type II and III strains", 
                      "A Bip Homologue in Toxoplasma gondii A Protozoan HSP70 Gene with Multiple Introns", 
                      "Toxoplasma gondii antigens", "Molecular structure of a Toxoplasma gondii dense granule antigenGRA 5 associated with the parasitophorous vacuole membrane", 
                      "Molecular cloning of the Toxoplasma gondii sag4 gene encoding an 18 kDa bradyzoite specific surface protein", 
                      "Neospora caninum specific oligonucleotide primers for the detection of braincyst DNA of experimentally infected nude mice by the polymerase chain reactionPCR", 
                      "The Toxoplasma gondii rhoptry protein ROP 2 is inserted into the parasitophorous vacuole membrane surrounding the intracellular parasite and is exposed to the host cell cytoplasm", 
                      "The phylogeny of Neospora caninum", "Molecular characterization of a dense granule antigenGra 2 associated with the network of the parasitophorous vacuole in Toxoplasma gondii", 
                      "Two additional SAG1related sequences immediately upstream of BRS4", 
                      "Cloning and expression of major surface antigen 1 of Toxoplasma gondii GJS strain and its immuogenicity analysis", 
                      "Characterisation of Toxoplasma gondii isolates using polymerase chain reactionPCR and restriction fragment length polymorphismRFLP of the noncoding Toxoplasma gondiiTGRgene sequences", 
                      "Genotyping studies of Toxoplasma gondii isolates from Africa revealed that the archetypal clonal lineages predominate as in North America and Europe", 
                      "Molecular cloning and sequence of Neospora caninum bradyzoite BAG1 antigen", 
                      "In vitro susceptibility of various genotypic strains of Toxoplasma gondii to pyrimethamine sulfadiazine and atovaquone", 
                      "Identification and expression analysis of ABC proteinencoding genes family in Toxoplasma gondii", 
                      "Cloning and characterization of the malate dehydrogenase gene from Toxoplasma gondii", 
                      "Transcriptional regulation of two stagespecifically expressed genes in the protozoan parasite Toxoplasma gondii", 
                      "DNA polymorphisms associated with murine virulence of Toxoplasma gondii identified by RAPDPCR", 
                      "T gondii dense granules protein GRA9", "Role of Cytokines and Major Histocompatibility Complex Restriction in Mouse Resistance to Infection with a Natural Recombinant StrainType IIII of Toxoplasma gondii", 
                      "Biosynthesis of glycosylphosphatidylinositol is essential to the survival of the protozoan parasite Toxoplasma gondii", 
                      "De novo pyrimidine biosynthesis is required for virulence of Toxoplasma gondii", 
                      "Physical characterisation of the plastid DNA in Neospora caninum", 
                      "Characterization of the Oregon isolate of Neospora sp from a horse", 
                      "Toxoplasma gondii genotyping of strains from Brazilian AIDS patients with cerebral toxoplasmosis by multilocus PCRRFLP markers", 
                      "Primary structure of the dihydrofolate reductasethymidylate synthase gene from Toxoplasma gondii", 
                      "Pglycoprotein inhibitors modulate accumulation and efflux of xenobiotics in extra and intracellular Toxoplasma gondii", 
                      "Molecular and Histopathological Study on Aborted Fetal Tissues", 
                      "Development of a PCR Method on Clinical Diagnose of Toxoplasma gondii", 
                      "PCR amplification cloning and sequencing analyses of ITS and 58S of rDNA from Toxoplasma gondii", 
                      "Recent expansion of Toxoplasma through enhanced oral transmission", 
                      "Isolation characterization and expression of a GRA2 homologue from Neospora caninum", 
                      "Molecular cloning sequencing and expression of a serine proteinase inhibitor gene from Toxoplasma gondii", 
                      "Differentiation of Neospora hughesi from Neospora caninum based on their immunodominant surface antigen SAG1 and SRS2", 
                      "Sequence evidence for an altered genetic code in the Neospora caninum plastid", 
                      "Conservation of the Plasmodium falciparum sporozoite surface protein gene STARP in field isolates and distinct species of Plasmodium", 
                      "Plasmodium falciparum PCNA Physical and functional mapping of the transcription start sites", 
                      "Wide distribution of the variant form of the human malaria parasite Plasmodium vivax", 
                      "Amplification of pfmdr1 associated with mefloquine and halofantrine resistance in Plasmodium falciparum from Thailand", 
                      "Cloning and structural analysis of the gene for cAMPdependent protein kinase catalytic subunit from Plasmodium yoelii", 
                      "The population structure of Plasmodium falciparum and Plasmodium vivax during an epidemic of malaria in the Eastern Highlands of Papua New Guinea", 
                      "Molecular cloning and characterization of Plasmodium falciparum transportin", 
                      "Toward a highresolution Plasmodium falciparum linkage map polymorphic markers from hundreds of simple sequence repeats", 
                      "Analysis of the SAG5 locus reveals a distinct genomic organisation in virulent and avirulent strains of Toxoplasma gondii", 
                      "Isolation and characterization of a bovine isolate of Neospora caninum with low virulence", 
                      "Isolation and genetic characterization of Neospora caninum from asymptomatic calves in Spain", 
                      "Secondary structures and features of the 18S 58S and 26S ribosomal RNAs from the Apicomplexan parasite Toxoplasma gondii", 
                      "Toxoplasma gondii Chennai isolate dense granule antigen 5GRA5 gene", 
                      "PCR Amplification Cloning and Sequencing Analyses of a 529bp repetitive fragment from Toxoplasma gondii", 
                      "Cloning and expression of microneme protein 3 of Toxoplasma gondii GJS strain and its immunogenicity analysis", 
                      "Detection of Toxoplasma gondii and Neospora caninum in sparrowsPasser domesticus in the Northeast of Brazil", 
                      "Functional characterization of an alternativelactate dehydrogenaselike malate dehydrogenase in Plasmodium falciparum", 
                      "First isolation of Neospora caninum from an aborted bovine fetus in Spain", 
                      "The Toxoplasma gondii rhoptry protein ROP4 is secreted into the parasitophorous vacuole and becomes phosphorylated in infected cells", 
                      "Genotypic characterization of Toxoplasma gondii Portuguese strains isolated from humans", 
                      "Isolation and molecular characterization of Neospora caninum in cattle in New Zealand", 
                      "Cloning and characterization of Toxoplasma gondii strain RHSSI bradyzoitespecific promoter hsp30bag1", 
                      "Unusual abundance of atypical strains associated with human ocular toxoplasmosis", 
                      "A dibasic motif in the tail of a class XIV apicomplexan myosin is an essential determinant of plasma membrane localization", 
                      "Subcellular localization of acetylCoA carboxylase in the apicomplexan parasite Toxoplasma gondii", 
                      "Homologous recombination and gene replacement at the dihydrofolate reductasethymidylate synthase locus in Toxoplasma gondii", 
                      "First identification of Neospora caninum infection in aborted bovine foetuses in China", 
                      "Characterization of the first Polish isolate of Neospora caninum from cattle", 
                      "Protein disulfide isomerase of Toxoplasma gondii is targeted by mucosal IgA antibodies in humans", 
                      "The MIC1 microneme protein of Toxoplasma gondii contains a duplicated receptorlike domain and binds to host cell surface", 
                      "Variation of the internal transcribed spacer 1 sequence within individual strains and among different strains of Neospora caninum", 
                      "Severe pneumonia during primary infection with an atypical strain of Toxoplasma gondii in an immunocompetent young man", 
                      "Evolutionary and demographic history of Plasmodium knowlesi", 
                      "Analysis of chloroquine resistance genes in Plasmodium vivax isolates from Bikaner Rajasthan", 
                      "Extensive heterozygosity in flanking microsatellites of Plasmodium falciparum NaH exchangerpfnhe1 gene among Indian isolates", 
                      "Genotyping of 12 P falciparum inhouse strains", "The Santigen of Plasmodium falciparum repertoire and origin of diversity", 
                      "Allelic variants of the Plasmodium falciparum merozoite surface antigen 2MSA2 in a geographically restricted area of Irian Jaya", 
                      "Conservation and antigenicity of erythrocyte binding antigen 175 in Plasmodium falciparum isolate FCC1HN", 
                      "Primary structure of the merozoite surface antigen 1 of Plasmodium vivax reveals sequences conserved between different Plasmodium species", 
                      "Role for the Plasmodium sporozoitespecific transmembrane protein S6 in parasite motility and efficient malaria transmission", 
                      "Characterization of UvrD homolog of Plasmodium falciparum", 
                      "Extended antigenic haplotyping of Plasmodium falciparum field isolates shows marked complexity", 
                      "Construction of eukaryotic expression recombinant plasmid and sequence analysis of p413 gene of Plasmodium falciparum isolate FCC1HN", 
                      "Naturally acquired inhibitory antibodies to Plasmodium vivax are shortlived and allelespecific following a single malaria infection", 
                      "Identification of a Plasmodium falciparum intercellular adhesion molecule1 binding domain a parasite adhesion trait implicated in cerebral malaria", 
                      "Plasmodium falciparum phosphoenolpyruvate carboxykinase is developmentally regulated in gametocytes", 
                      "Sequence of Plasmodium falciparum encoding Pfg2725", "Rifins a second family of clonally variant proteins expressed on the surface of red cells infected with Plasmodium falciparum", 
                      "Plasmodium vivax circumsporozoite protein gene", "Plasmodium histone acetyltransferasePfHAT", 
                      "GTP cyclohydrolase I gene of Plasmodium knowlesi", "Plasmodium vivax merozoite surface protein3 contains coiledcoil motifs in an alaninerich central domain", 
                      "Cloning and sequenceing of the gene encoding the sexualstage target antigen Pfs25 of Plasmodium falciparum south China isolate FCC1HN", 
                      "A study of var gene transcription in vitro using universal var gene primers", 
                      "A Plasmodium falciparum homologue of Plasmodium vivax reticulocyte binding proteinPvRBP1 defines a trypsinresistant erythrocyte invasion pathway", 
                      "Recombinant Duffy bindinglikealpha domains of Plasmodium falciparum erythrocyte membrane protein 1 elicit antibodies in rats that recognise conserved epitopes", 
                      "Sequence diversity in the aminoterminal region of the malariavaccine candidate serine repeat antigen in natural Plasmodium falciparum populations", 
                      "Plasmodium falciparum parasites with short forms of chromosome 9 express var genes and PfEMP1 protein", 
                      "Research note HLA degenerate Tcell epitopes from Plasmodium falciparum liver stagespecific antigen 1LSA1 are highly conserved in isolates from geographically distinct areas", 
                      "The circumsporozoite protein of Plasmodium chabaudi contains a large preregion I repeat domain", 
                      "Stagespecific expression of 1433 in asexual bloodstage Plasmodium", 
                      "Intracluster recombination and var transcription switches in the antigenic variation of Plasmodium falciparum", 
                      "Merozoite surface protein 1 Block 2 regionMAD20like type", "Complex polymorphisms in an approximately 330 kDa protein are linked to chloroquineresistant P falciparum in Southeast Asia and Africa", 
                      "The adenosine transporter of Toxoplasma gondii Identification by insertional mutagenesis cloning and recombinant expression", 
                      "Description of a new Neospora speciesProtozoa Apicomplexa Sarcocystidae", 
                      "Characterization of a dense granule antigen of Toxoplasma gondiiGRA6 associated to the network of the parasitophorous vacuole", 
                      "Isolation and biological characterisation of a new isolate of Neospora caninum from an asymptomatic calf in Brazil", 
                      "Upstream elements required for expression of nucleoside triphosphate hydrolase genes of Toxoplasma gondii", 
                      "Evaluation of recombinant proteins of Neospora caninum as vaccine candidatesin a mouse model", 
                      "Rapid nucleotide sequence analysis of the small subunit ribosomal RNA of Toxoplasma gondii evolutionary implications for the Apicomplexa", 
                      "Partial cds of GRA 1 gene of Toxoplasma gondii RH strain", "Genetic diversity among sea otter isolates of Toxoplasma gondii", 
                      "Isolation and genotyping of Toxoplasma gondii from Ugandan chickens reveals frequent multiple infections", 
                      "Selection of polymorphic peptides from GRA6 and GRA7 sequences of Toxoplasma gondii strains to be used in serotyping", 
                      "An elongation factor encoded by the toxoplasma gondii putative plastid", 
                      "Success and virulence in Toxoplasma as the result of sexual recombination between two distinct ancestries", 
                      "Novel organization and sequences of glutaminedependent carbamoyl phosphate synthetase II in Toxoplasma gondii", 
                      "A novel cyclin dependent kinase from toxoplasma gondii", "Rapid and sensitive identification of Neospora caninum by in vitro amplification of the internal transcribed spacer 1", 
                      "Standardization and application of PCR based RFLP and DNA sequencing for detection and genotyping of Toxoplasma gondii on intra ocular specimens of ocular toxoplasmosis patients", 
                      "Bradyzoitespecific gene expression in Toxoplasma gondii requires minimal genomic elements", 
                      "Antigenspecificp30 mouse CD8 T cells are cytotoxic against Toxoplasma gondiiinfected peritoneal macrophages", 
                      "Cloning of a Cathepsin Llike thiolproteinase of Toxoplasma gondii", 
                      "Smallsubunit rDNA sequencing of the Italian bovine Neospora caninum isolateNCPV1 strain", 
                      "A polymorphism in a DNA polymerase alpha gene intron differentiates between murine virulent and avirulent strains of Toxoplasma gondii", 
                      "Analysis of the rpoB gene product of Toxoplasma gondii", "Identification of two protein serinethreonine kinase genes and molecular cloning of a SNF1 type protein kinase gene from Toxoplasma gondii", 
                      "Molecular characterization of a 23kilodalton major antigen secreted by Toxoplasma gondii", 
                      "Genomic and corrected cDNA sequence of the P28 gene from Toxoplasma gondii", 
                      "Detection of Hammondia heydorni and related coccidiaNeospora caninum and Toxoplasma gondii in goats slaughtered in Bahia Brazil", 
                      "Molecular typing of Toxoplasma gondii strains by GRA7 gene sequence analysis", 
                      "Isolation and characterization of a Toxoplasma gondii strain obtained from a freeliving jaguarPanthera onca in French Guiana", 
                      "Surface antigenSAG1 gene a tool for genotyping Toxoplasma gondii strains", 
                      "Plasmid immunization protects against vertical transmission of Neospora caninum in mice", 
                      "Isolation and characterization of bovine Neospora in NSW", "Isolation of Neospora caninum genes detected during a chronic murine infection", 
                      "Standardization and application of PCRbased RFLP and DNA sequencing for detection and genotyping of Toxoplasma gondii on intraocular specimens of ocular toxoplasmosis patients", 
                      "ChickensGallus domesticus are natural intermediate hosts of Neospora caninum", 
                      "Standardization and application of PCR based RFLP and DNA sequencing for detection and genotyping of Toxoplasma gondii on intraocular specimens of ocular toxoplasmosis patients", 
                      "Toxoplasma rhoptry proteins", "Molecular phylogenetic analysis in Hammondialike organisms based on partial Hsp70 coding sequences", 
                      "Nc5 gene of Neospora caninum partial sequence", "Molecular Characterization of Toxoplasma gondii from Bird Hosts", 
                      "Preliminary studies on genotypes of Toxoplasma gondii isolates from mainland China", 
                      "The prevalence of Neospora caninum and coinfection with Toxoplasma gondii by PCR analysis in naturally occurring mammal populations", 
                      "Characterization biosynthesis and fate of ROP7 a ROP2 related rhoptry protein of Toxoplasma gondii", 
                      "A family of dispersed DNA elements that contain GAA repeats in Toxoplasma gondii", 
                      "Isolation of developmentally regulated genes from Toxoplasma gondii by a gene trap with the positive and negative selectable marker hypoxanthinexanthineguanine phosphoribosyltransferase", 
                      "GRA7 an excretory 29 kDa Toxoplasma gondii dense granule antigen released by infected host cells", 
                      "Sequence analysis and comparison of ribosomal DNA from bovine Neospora to similar coccidial parasites", 
                      "Molecular comparison of Neospora caninum oocyst isolates from naturally infected dogs with cell culturederived tachyzoites of the same isolates using nested polymerase chain reaction to amplify mic...", 
                      "Multilocus microsatellite analysis reveals extensive genetic diversity in Neospora caninum", 
                      "Construction of eukaryotic expression vector for GRA6 gene from Toxoplasma gondii GJS strain and expression of the gene in BHK21 cells", 
                      "Neospora caninum detection in wild rabbits and investigation of coinfection with Toxoplasma gondii by PCR analysis", 
                      "Characterization of a family of MAR domain containing proteins in Toxoplasma gondii", 
                      "Seronegative conversion in four Neospora caninuminfected cows with a low rate of transplacental transmission", 
                      "Toxoplasma gondii isolate RH surface antigen P22 5flanking sequence", 
                      "Oglycosylation in Toxoplasma gondii identification and analysis of a family of UDPGalNAcpolypeptide Nacetylgalactosaminyltransferases", 
                      "TgM2AP Participates in Toxoplasma gondii Invasion of Host Cells and is Tightly Associated With the Adhesive Protein TgMIC2", 
                      "First isolation of Neospora caninum from naturallyinfected buffaloes from Brazil", 
                      "A green algal apicoplast ancestor", "Targeting of soluble proteins to the rhoptries and micronemes in Toxoplasma gondii", 
                      "Toxoplasma gondii cyclic GMPdependent kinase chemotherapeutic targeting of an essential parasite protein kinase", 
                      "Strain typing of Toxoplasma gondii comparison of antigencoding and housekeeping genes", 
                      "Characterization of the Oregon isolate of Neospora hughesi from a horse", 
                      "Sequence of the Neospora caninum plastid DNA", "Phylogenetic analysis based on fulllength large subunit ribosomal RNA gene sequence comparison reveals that Neospora caninum is more closely related to Hammondia heydorni than to Toxoplasma gondii", 
                      "Avirulent isolate of neospora caninum and its uses", "Neospora caninumlike oocysts observed in feces of freeranging red foxesVulpes vulpes and coyotesCanis latrans", 
                      "Isolation and characterisation of a genomic clone encoding a cdc2related kinase of Toxoplasma gondii", 
                      "Polymorphism of the SOD1 gene encoding ironcontaining superoxide dismutase between and within Toxoplasma gondii", 
                      "The rop2 family of toxoplasma gondii rhoptry proteins proteomic and genomic characterization", 
                      "Molecular cloning organellar targeting and developmental expression of mitochondrial chaperone HSP60 in Toxoplasma gondii", 
                      "Molecular cloning expression analysis and iron metal cofactor characterisation of a superoxide dismutase from Toxoplasma gondii", 
                      "NcP36 complete genomic sequence", "ROP 4 of Toxoplasma gondii", 
                      "Genomic and cDNA sequence of Toxoplasma gondii uracil phosphoribosyl transferase enzyme", 
                      "Molecular genetic analysis of Toxoplasma gondii", "Molecular characterisation of an expressed sequence tag locus of Toxoplasma gondii encoding the micronemal protein MIC2", 
                      "Sequence of a small subunit rRNA gene of Toxoplasma gondii and its use in phylogenetic analysis", 
                      "The phylogeny of Neospora caninum and Toxoplasma gondii based on ribosomal RNA sequences", 
                      "Genetic diversity amongst isolates of Neospora caninum and the development of a multiplex assay for the detection of distinct strains", 
                      "Multilocus microsatellite analysis of Neospora caninum from Iran", 
                      "Physical and genetic mapping of cloned ribosomal DNA from Toxoplasma gondii primary and secondary structure of the 5S gene", 
                      "Occurrence of Toxoplasma gondii and Hammondia hammondi oocysts in the faeces of cats from Germany and other European countries", 
                      "Use of GRA6derived synthetic polymorphic peptides in an immunoenzymatic assay to serotype Toxoplasma gondii in human serum samples collected from three continents", 
                      "Direct and sensitive detection of a pathogenic protozoan Toxoplasma gondii by polymerase chain reaction", 
                      "Identification and disruption of a rhoptrylocalized homologue of sodium hydrogen exchangers in Toxoplasma gondii", 
                      "Isolation of Neospora caninum from naturally infected whitetailed deerOdocoileus virginianus", 
                      "An unusual genotype of Toxoplasma gondii is common in California sea ottersEnhydra lutris nereis and is a cause of mortality", 
                      "The microneme protein MIC3 of Toxoplasma gondii is a secretory adhesin that binds to both the surface of the host cells and the surface of the parasite", 
                      "rRNA gene sequence heterogeneity among Toxoplasma gondii strains", 
                      "Neosporosis in Beagle dogs clinical signs diagnosis treatment isolation and genetic characterization of Neospora caninum", 
                      "Molecular characterization of TgMIC5 a proteolytically processed antigen secreted from the micronemes of Toxoplasma gondii", 
                      "Neospora caninum isolate NcGER1 microsatellite MS5", "Just one cross appears capable of dramatically altering the population biology of a eukaryotic pathogen like Toxoplasma gondii", 
                      "Protection of mice from fatal Toxoplasma gondii infection by immunization with p30 antigen in liposomes", 
                      "Genetic diversity clonality and sexuality in Toxoplasma gondii", 
                      "Immunization with native surface protein NcSRS2 induces a Th2 immune response and reduces congenital Neospora caninum transmission in mice", 
                      "Phylogenetic congruence of Sarcocystis neurona Dubey et al 1991Apicomplexa Sarcocystidae in the United States based on sequence analysis and restriction fragment length polymorphismRFLP", 
                      "Development of a stable episomal shuttle vector for Toxoplasma gondii", 
                      "Cloning of developmentally regulated genes in Toxoplasma gondii by promotertrap insertional mutagenesis", 
                      "First report of Neospora caninumassociated bovine abortion in Austria", 
                      "Investigations on the molecular phylogeny of Besnoitia species and the genetic relationships between Besnoitia of cattle wildebeest and goats", 
                      "Characterisation of a novel interspersed Toxoplasma gondii DNA repeat with potential uses for PCR diagnosis and PCRRFLP analysis", 
                      "Identification of a 200 to 300fold repetitive 529 bp DNA fragment in Toxoplasma gondii and its use for diagnostic and quantitative PCR", 
                      "Insertional tagging of at least two loci associated with resistance to adenine arabinoside in Toxoplasma gondii and cloning of the adenosine kinase locus", 
                      "Characterization of the gene encoding the catalytic subunit of the DNA polymerase alpha from Toxoplasma gondii", 
                      "The expression of Toxoplasma proteins in Neospora caninum and the identification of a gene encoding a novel rhoptry protein", 
                      "Molecular analysis of ribosomal genes of virulent and avirulent strains of Toxoplasma gondii"
                      )

IsolateByCountry = 
function(
`country` = 'Africa,Asia,Australia,Belgium,Brazil,Canada,Chile,China,Colombia,Cuba,Cyprus,Czech Republic,Denmark,Ecuador,Egypt,Europe,France,Germany,Hungary,India,Iran,Ireland,Italy,Jamaica,Japan,Kenya,Kuwait,Lithuania,Malawi,Malaysia,Mexico,Mongolia,N. America,Nepal,Netherlands,Norway,Oceania/Australia,Peru,Poland,Portugal,S. America,Saudi Arabia,Serbia,Slovenia,South Africa,Spain,Sri Lanka,Switzerland,Taiwan,Thailand,Tunisia,Uganda,United Kingdom,Unknown,Usa,Vietnam,Israel,Palestine,Sweden,Afghanistan,Azerbaijan,Bangladesh,Benin,Burkina,Burma (Myanmar),Burundi,Cambodia,Cameroon,Cape Verde,Central African Republic,Chad,Comoros,Congo (Dem. Rep.),East Timor,El Salvador,Equatorial Guinea,Gabon,Gambia,Ghana,Guinea,Guinea-Bissau,Guyana,Haiti,Honduras,Indonesia,Korea (North),Korea (South),Liberia,Madagascar,Mali,Mozambique,Namibia,Niger,Nigeria,Pakistan,Papua New Guinea,Philippines,Republic Of Cote D\'Ivoire,Senegal,Sierra Leone,Solomon Islands,Sudan,Suriname,Tanzania,Togo,Turkey,Vanuatu,Venezuela,Yemen,Zambia,Zimbabwe,Barbados,Congo,Costa Rica,Panama,St. Kitts And Nevis,Uruguay', `type` = 'Sequencing Typed,3kChip,Barcode,HD_Array,RFLP Typed', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByCountry.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByCountry.xml', .convert = NULL, .json = TRUE
)
{
     `country` <- checkValues(`country`, c("Africa", "Asia", "Australia", "Belgium", "Brazil", "Canada", 
                      "Chile", "China", "Colombia", "Cuba", "Cyprus", "Czech Republic", 
                      "Denmark", "Ecuador", "Egypt", "Europe", "France", "Germany", 
                      "Hungary", "India", "Iran", "Ireland", "Italy", "Jamaica", "Japan", 
                      "Kenya", "Kuwait", "Lithuania", "Malawi", "Malaysia", "Mexico", 
                      "Mongolia", "N. America", "Nepal", "Netherlands", "Norway", "Oceania/Australia", 
                      "Peru", "Poland", "Portugal", "S. America", "Saudi Arabia", "Serbia", 
                      "Slovenia", "South Africa", "Spain", "Sri Lanka", "Switzerland", 
                      "Taiwan", "Thailand", "Tunisia", "Uganda", "United Kingdom", 
                      "Unknown", "Usa", "Vietnam", "Israel", "Palestine", "Sweden", 
                      "Afghanistan", "Azerbaijan", "Bangladesh", "Benin", "Burkina", 
                      "Burma (Myanmar)", "Burundi", "Cambodia", "Cameroon", "Cape Verde", 
                      "Central African Republic", "Chad", "Comoros", "Congo (Dem. Rep.)", 
                      "East Timor", "El Salvador", "Equatorial Guinea", "Gabon", "Gambia", 
                      "Ghana", "Guinea", "Guinea-Bissau", "Guyana", "Haiti", "Honduras", 
                      "Indonesia", "Korea (North)", "Korea (South)", "Liberia", "Madagascar", 
                      "Mali", "Mozambique", "Namibia", "Niger", "Nigeria", "Pakistan", 
                      "Papua New Guinea", "Philippines", "Republic Of Cote D'Ivoire", 
                      "Senegal", "Sierra Leone", "Solomon Islands", "Sudan", "Suriname", 
                      "Tanzania", "Togo", "Turkey", "Vanuatu", "Venezuela", "Yemen", 
                      "Zambia", "Zimbabwe", "Barbados", "Congo", "Costa Rica", "Panama", 
                      "St. Kitts And Nevis", "Uruguay"), 'country', TRUE)
     `type` <- checkValues(`type`, c("Sequencing Typed", "3kChip", "Barcode", "HD_Array", "RFLP Typed"
                      ), 'type', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'country' = `country`,
                  'type' = `type`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolateByAuthor = 
function(
`author` = 'Xiao', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByAuthor.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolateByAuthor.xml', .convert = NULL, .json = TRUE
)
{
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'author' = `author`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolatesBySimilarity = 
function(
`BlastDatabaseType` = 'Transcripts', `BlastAlgorithm` = 'blastn', `BlastDatabaseOrganism` = 'Entamoeba histolytica DS4', `BlastQuerySequence`, `-e` = '10', `-v` = '50', `-b` = '50', `-filter` = 'yes', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolatesBySimilarity.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolatesBySimilarity.xml', .convert = NULL, .json = TRUE
)
{
     `BlastDatabaseType` <- checkValues(`BlastDatabaseType`, c("Transcripts", "Proteins", "Genome", "ORF", "EST", "Assemblies", 
                      "Isolates", "Genome Survey Sequences"), 'BlastDatabaseType', FALSE)
     `BlastAlgorithm` <- checkValues(`BlastAlgorithm`, c("blastn", "blastp", "blastx", "tblastn", "tblastx"), 'BlastAlgorithm', FALSE)
     `BlastDatabaseOrganism` <- checkValues(`BlastDatabaseOrganism`, c("Entamoeba histolytica DS4", "Entamoeba histolytica HM-1:CA", 
                      "Entamoeba histolytica KU27", "Entamoeba histolytica KU48", "Entamoeba histolytica KU50", 
                      "Entamoeba histolytica MS96", "Entamoeba histolytica HM-1:IMSS", 
                      "Entamoeba dispar SAW760", "Entamoeba invadens IP1", "Encephalitozoon intestinalis", 
                      "Encephalitozoon cuniculi GB-M1", "Enterocytozoon bieneusi H348", 
                      "Nematocida parisii", "Octosporea bayeri OER-3-3", "Leishmania major", 
                      "Leishmania major strain SD 75.1", "Leishmania infantum", "Leishmania braziliensis", 
                      "Leishmania tarentolae", "Crithidia fasciculata", "Trypanosoma brucei gambiense", 
                      "Trypanosoma brucei Lister strain 427", "Trypanosoma brucei TREU927", 
                      "Trypanosoma cruzi strain Esmeraldo", "Trypanosoma cruzi CL Brener Esmeraldo-like", 
                      "Trypanosoma cruzi CL Brener Non-Esmeraldo-like", "Trypanosoma cruzi unassigned contigs (strain CL Brener)", 
                      "Leishmania mexicana", "Trypanosoma congolense", "Trypanosoma vivax", 
                      "Theileria parva", "Theileria annulata", "Plasmodium berghei", 
                      "Plasmodium chabaudi", "Plasmodium falciparum", "Plasmodium falciparum mitochondrial", 
                      "Plasmodium falciparum plastid", "Plasmodium gallinaceum", "Plasmodium knowlesi", 
                      "Plasmodium reichenowi", "Plasmodium vivax", "Plasmodium vivax mitochondrial", 
                      "Plasmodium yoelii", "Toxoplasma gondii TgCkUg2", "Toxoplasma gondii GT1", 
                      "Toxoplasma gondii ME49", "Toxoplasma gondii VEG", "Toxoplasma gondii RH (chr Ia and chr Ib)", 
                      "Toxoplasma gondii apicoplast", "Neospora caninum", "Cryptosporidium parvum", 
                      "Cryptosporidium parvum Chr6", "Cryptosporidium hominis", "Cryptosporidium muris", 
                      "Cryptosporidium Isolates minus Reference", "Cryptosporidium Reference Isolates", 
                      "All Giardia Isolates", "Plasmodium Barcode Isolates", "Plasmodium Popset/Genbank Isolates", 
                      "All Toxoplasma Isolates", "Giardia Assemblage A isolate WB", 
                      "Giardia Assemblage B isolate GS", "Giardia Assemblage E isolate P15", 
                      "Trichomonas vaginalis"), 'BlastDatabaseOrganism', TRUE)
     `-filter` <- checkValues(`-filter`, c("yes", "no"), '-filter', FALSE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'BlastDatabaseType' = `BlastDatabaseType`,
                  'BlastAlgorithm' = `BlastAlgorithm`,
                  'BlastDatabaseOrganism' = `BlastDatabaseOrganism`,
                  'BlastQuerySequence' = `BlastQuerySequence`,
                  '-e' = `-e`,
                  '-v' = `-v`,
                  '-b' = `-b`,
                  '-filter' = `-filter`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}

IsolatesByTextSearch = 
function(
`wdk_record_type` = 'isolate', `project_id` = 'CryptoDB', `text_expression` = 'Cryptosporidium hominis', `text_fields` = 'Organism', `o-fields` = 'NULL', `o-tables` = 'NULL', ..., .url = if(.json) 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolatesByTextSearch.json' else 'http://eupathdb.org/eupathdb/webservices/IsolateQuestions/IsolatesByTextSearch.xml', .convert = NULL, .json = TRUE
)
{
     `project_id` <- checkValues(`project_id`, c("CryptoDB", "PlasmoDB", "ToxoDB", "GiardiaDB", "TrichDB", "TriTrypDB"
                      ), 'project_id', FALSE)
     `text_fields` <- checkValues(`text_fields`, c("Organism", "Description", "Product", "Strain", "Host", "Note", 
                      "Isolation Source", "Geographic Location", "Reference", "Gene overlap"
                      ), 'text_fields', TRUE)
    if(!missing(`o-fields`)) `o-fields` <- checkValues(`o-fields`, c("all", "none", "primary_key", "pcr_primers", "country", "organism", 
                      "strain", "specific_host", "isolation_source", "description", 
                      "note", "product", "data_type", "collected_by", "length", "external_db_name", 
                      "external_db_version", "sequence", "wdk_weight", "fields_matched", 
                      "max_score"), 'o-fields', TRUE)
    if(!missing(`o-tables`)) `o-tables` <- checkValues(`o-tables`, c("all", "none", "Reference", "GeneOverlap", "IsolateComments", 
                      "ProteinSequence", "organism", "description", "product", "host", 
                      "note", "isolation_source", "geographic_location", "SNP"), 'o-tables', TRUE)
    params = list(
                  'wdk_record_type' = `wdk_record_type`,
                  'project_id' = `project_id`,
                  'text_expression' = `text_expression`,
                  'text_fields' = `text_fields`
                )
    
    if(!missing(`o-fields`))
       params[['o-fields']] = `o-fields`
    if(!missing(`o-tables`))
       params[['o-tables']] = `o-tables`
    
    ans = getForm(.url, .params = params, ...)
    if(is.null(.convert) && .json) return(fromJSON(ans))
    if(!is.null(.convert))
       .convert(ans)
    else if(!is.null(type <- attr(ans, 'Content-Type')) && type == 'text/json')
       convertJSON(ans)
    else
       ans
}
