\name{orfsbymassspec}
\alias{OrfsByMassSpec}
\title{Find open reading frames that have evidence of expression based on peptides identified in sporozoites by MS/MS analysis.}
\description{Find <i>Cryptosporidium</i>, <i>GiardiaDB</i> and <i>Toxoplasma</i> open reading frames that have evidence of expression based on peptides identified by MS/MS analysis. NOTE: This query only returns ORFs that contain peptides that could not be mapped onto an annotated gene model overlapping with the ORF.
             <p>See the related <a href="showQuestion.do?questionFullName=GeneQuestions.GenesByMassSpec"><b>Genes with Mass Spec. Evidence</b></a> query to find gene models which have mapped MS/MS peptides.open reading frames that have evidence of expression 

            <br><hr>
             <p><b><i>C. parvum</i></b>
             <br><sup><b>1</b></sup>
   <!-- description by J. Wastling -->
             <i> S.J. Sanderson, D. Xia, H. Prieto, J. Yates, M. Heiges. J. Kissinger & J.M. Wastling (submitted). <b>Contact: Jonathan Wastling for details (<a href="mailto:j.wastling@liv.ac.uk">j.wastling@liv.ac.uk</a>)</b></i>.
             <br>Mass spectrometry data were obtained from two-dimensional gel electrophoretic protein separations, one-dimensional gel LC-MS/MS and 
             MudPIT analysis of a sporozoite/oocyst excystation mixture of <i>Cryptosporidium parvum</i>.  A total of approximately 3,500 protein 
             hits were obtained resulting in 1,252 non-redundant protein identifications. In addition a further 100 hits were obtained to sequences 
             which matched a predicted open reading frame, but for which no gene model currently exists. In total these protein identifications 
             represent nearly one third of the entire predicted proteome of <i>C. parvum</i>, although it is unlikely that the entire proteome 
             from all life-stages will be expressed at any one time.
             <br>
             <sup><b>2</b></sup> <i>
             William J. Snelling<sup>A</sup>, Qishan Lin<sup>B</sup>, John E. Moore<sup>C</sup>, B. Cherie Millar<sup>D</sup>, 
             Fabio Tosini<sup>D</sup>, Edoardo Pozio<sup>D</sup>, James S.G. Dooley<sup>A</sup>, and Colm J. Lowery<sup>A</sup><br> 
             <sup>A</sup>Centre for Molecular Biosciences, School of Biomedical Sciences, University of Ulster, Cromore Road, Coleraine, County 
             Londonderry, N. Ireland, BT52 1SA. <sup>B</sup>UAlbany Proteomics Facility, Centre for Functional Genomics, University of Albany, 
             One Discovery Drive, Rensselaer, NY 12144. <sup>C</sup>Northern Ireland Public Health Laboratory, Department of Bacteriology, 
             Belfast City Hospital, Belfast, N. Ireland, BT9 7AD. <sup>D</sup>Department of Infectious, Parasitic, and Immunomediated 
             Diseases, Istituto Superiore di Sanit&#224;, Rome, Italy.<br> 
             <a href="http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids=17124246"> Proteomics analysis and protein expression during sporozoite excystation of Cryptosporidium parvum (Coccidia, Apicomplexa). Mol. Cell Proteomics 2007 Feb;6(2):346-55 </a></i>
             <br>
             <sup><b>3</b></sup>
   <!-- description by Andras Fiser -->
             <i>Joseph M. Dybas, Carlos J. Madrid-Aliste, Fa-Yun Che, Edward Nieves, Louis M. Weiss, Kami Kim, Andr&#225;s Fiser and Ruth Hogue Angeletti<br>
             <a href="http://toro.aecom.yu.edu/biodefense/">Einstein Biodefense Proteomics Research Center</a><br>
             Albert Einstein College of Medicine, 1300 Morris Park Avenue, Bronx, NY 10461, USA</i><br>
             <a href="http://www.fiserlab.org/biodefense">Fiser Lab</a><br><br>
             Enriched cytoskeletal and membrane fractions were separated by 1D-SDS-PAGE or 2D gel electrophoresis. The bands/spots were digested with trypsin. The resulting peptides analyzed by nanoLC-MS/MS on a ThermoFinnigan linear ion trap (LTQ) mass spectrometer.  MASCOT was used to search the merged DTA mass spectrometry data file against the appropriate database to obtained unique peptide hits.  In order to extend the dynamic range of the membrane fractions, high pH sodium carbonate was used to remove the peripheral membrane proteins. For a few experiments, the remaining cytosolic fractions were also analyzed. 
<br>
             <sup><b>4</b></sup>
   <!-- description for Belinda ferrari data -->
             <i>Data provided by Belinda Ferrari and Quach Truong at the Department of Biological Sciences, Macquarie University, Sydney, Australia.</i><br><br>
Subcellular proteomic analysis of <i>C. parvum</i> oocysts. Proteome analysis was carried out on two components of the oocyst after excystation. (1) the proteins identified in the sporozoites and (2) the proteins identified belonging to residual oocyst wall.  Furthermore, proteome analysis was also carried on the intact oocyst.  Consequently, the aim of this study was to identify proteins unique to each subcellular component, and also to identify proteins shared between fractions.
            <br><br>
            <p><b><i>G. lamblia</i></b>
            <br>WB (genome project strain) Giardia lamblia grown axenically in TYI-S-33 medium supplemented with bile salts.  Adherent trophozoites were harvested during log-phase growth (60-70\% confluent) and proteins extracted in 8M Urea and SDS.  1 mg of extracted protein was digested with sequencing-grade modified trypsin and fractionated via strong cation exchange chromatography into 90 fractions.  Each fraction was run via C-18 reverse phase chromatography and analyzed using an LTQ ProteomeX ion trap mass spectrometer (Thermo Finnigan).  Peptide assignments were made using SEQUEST, and the individual runs were compiled using DTASelect.
             <p><i>Daniel M. Ratner, Michael Lubrano, Martin Steffen, John Samuelson. University of Washington, Department of Bioengineering.</i>
             <p>Protocol adapted from Jaffe, J.D., Berg, H.C, Church, G. M. Proteogenomic mapping as a complementary method to perform genome annotation. <i>Proteomics</i>, <b>2004</b>, 4, 59-7
            <p>See the related <a href="showQuestion.do?questionFullName=OrfQuestions.OrfsByMassSpec"><b>ORFs with Mass Spec. Evidence</b></a> query to find genomic open reading frames which have mapped MS/MS peptides that do not correspond to current gene models.
            <br><br>
            <p><b><i>T. gondii</i></b>
             <br><sup>1</sup> 
<i>Dong Xia, Sanya J Sanderson, Andrew R Jones, Judith H Prieto, John R Yates III, Elizabeth Bromley, Fiona M Tomley, Kalpana Lal, Robert E Sinden, Brian P Brunk, David S Roos and Jonathan M Wastling. (July 2008) The proteome of Toxoplasma gondii: integration with the genome provides novel insights into gene expression and annotation.</i> <a href="http://genomebiology.com/2008/9/7/R116" target="new">Genome Biology, 2008 <b>9</b>:R116</a>.
             <br>Mass spectrometry data were obtained from one-dimensional gel LC-MS/MS and MudPIT analysis of Toxoplasma gondii tachyzoites. 6,546 protein hits were obtained resulting in 2217 non-redundant protein identifications. A further 318 hits were obtained to sequences which matched 226 predicted open reading frames for which no gene model currently exists.  Additionally, 163 gene predictions were hit that did not have an overlapping gene model to which at least 50\% of the peptides could be mapped.  In total these protein identifications from one stage represent nearly one third of the entire predicted proteome of T. gondii.
             <br><i>Bradley PJ, Ward C, Cheng SJ, Alexander DL, Coller S, Coombs GH, Dunn JD, Ferguson DJ, Sanderson SJ, Wastling JM,Boothroyd JC. 
             Proteomic analysis of rhoptry organelles reveals many novel constituents for host-parasite interactions in Toxoplasma gondii. 
             J Biol Chem. 2005 Oct 7;280(<b>40</b>):34245-58</i>
             <br><sup>2</sup><i>Hu K, Johnson J, Florens L, Fraunholz M, Suravajjala S, DiLullo C, Yates JR, Roos DS, Murray JM. (2006) 
	     Cytoskeletal Components of an Invasion Machine - The Apical Complex of Toxoplasma gondii. PLoS Pathog <b>2</b>:121-138.</i><br>
             1,887 protein hits were obtained resulting in 1,166 non-redundant protein identifications. A further 498 hits were obtained to sequences which matched 446 predicted open reading frames for which no gene model currently exists.  
             <br>Taken together, these two datasets result in 8,433 protein hits to 2,436 non-redundant Toxoplasma proteins and 816 hits to 634 non-redundant ORFs that contain peptides that couldn't be mapped to annotated proteins. With the additional evidence from the predicted gene models, nearly 40\% of the predicted proteome from T. gondii is represented.  The data provide evidence that often corroborates the annotated gene models and in some instances the peptides mapping to ORFs and predicted gene models provide evidence for alternatives to the current annotations.
             <br><sup>3</sup>
    <!-- description by Andras Fiser -->
             <i>Joseph Dybas, Dmitry Rykunov, Carlos Madrid, Edward Nieves, Fa-Yun Che, Hui Xiao, Kami Kim, Louis Weiss, Ruth Hogue Angeletti, Andr&#225;s Fiser (<a href="http://toro.aecom.yu.edu/biodefense/">Einstein Biodefense Proteomics Research Center</a>)</i>
             <br>Enriched cytoskeletal and membrane fractions of T. gondii were separated by 1D-SDS-PAGE or 2D gel electrophoresis.  The bands/spots were digested with trypsin. The resulting peptides analyzed by nanoLC-MS/MS on a ThermoFinnigan linear ion trap (LTQ) mass spectrometer.  MASCOT was used to search the merged DTA mass spectrometry data file against the appropriate database to obtained unique peptide hits.  In order to extend the dynamic range of the membrane fractions, high pH sodium carbonate was used to remove the peripheral membrane proteins. For a few experiments, the remaining cytosolic fractions were also analyzed. A total of 2604 proteins were identified by mass spectrometry in T. gondii to date. The 2604 predicted proteins cluster into 1534 groups of overlapping gene predictions that were identified by 14455 mass spectrometry peptide hits that gave an average 13.2\% sequence coverage.
             <br><sup>4</sup>
   <!-- description by Andras Fiser -->
             <i> Vern Carruthers </i>
             <br>Carruthers lab analyzed a large cohort of freely released Toxoplasma secretory proteins by using two complementary methodologies, two-dimensional electrophoresis/mass spectrometry and liquid chromatography/electrospray ionization-tandem mass spectrometry (MudPIT, shotgun proteomics). <a href="http://www.ncbi.nlm.nih.gov/pubmed/16002397">J Biol Chem. 2005 Oct 7;280(40):34233-44.</a>
             <br><sup>5</sup>
   <!-- description by Andras Fiser -->
             <i>Silvia Moreno </i>
             <br>The samples were prepared by Silvia Moreno's laboratory at the University of Georgia, Athens, GA and analyzed by James Thompson and  John  Yates, III  at The Scripps Research Institute, La Jolla, CA
             <br>}
\arguments{
\item{orf_ms_assay}{Experiments
Provide one or more values. Use comma as a delimter.}
\item{min_sequence_count}{Use this parameter to set a minimum for the number of unique peptide sequences found that must match a gene in order for it to be returned by the query. Roughly speaking this parameter provides a measure of the abundance of the protein product in question, at least within a particular experiment.}
\item{min_spectrum_count}{Use this parameter to set a minimum for the number of mass spectra found that must match a gene in order for it to be returned by the query. Roughly speaking this parameter provides a measure of the abundance of the protein product in question, at least within a particular experiment.}
\item{o-fields}{Single valued attributes of the feature.
Provide one or more values. Use comma as a delimter.}
\item{o-tables}{Multi-valued attributes of the feature.
Provide one or more values. Use comma as a delimter.}
\item{.convert}{a logical value or a function that controls how the result of the method is returned. If this is a function, the character string or raw vector is passed to this function and it converts it appropriately. If this is a logical value and \code{TRUE}, then we attempt to convert the result based on its Content-Type returned by the Web server.  If this is \code{FALSE}, the value from the Web server is returned as is.}
\item{.url}{the URL for the Web request. This defaults to the correct value, but can be specified by the caller if the method is available at a different URL, e.g. locally or in a mirror server.}
\item{.json}{a logical value controlling whether to use the JSON or the XML version of the method}}
\value{text/xml
text/plain}
\author{}

