library(Rffi)
setClass('utsname', representation('sysname' = 'character', 'nodename' = 'character', 'release' = 'character', 'version' = 'character', 'machine' = 'character'))
setClass('utsnameRef', contains = 'RCStructReference')
setMethod('$', 'utsnameRef', makeClosure(function(x, name) 
{
getStructField(x, name, .utsname.FFIType)
}, '.utsname.FFIType' = structType(list('sysname' = stringArrayType(256), 'nodename' = stringArrayType(256), 'release' = stringArrayType(256), 'version' = stringArrayType(256), 'machine' = stringArrayType(256)))))
setAs('utsnameRef', 'utsname', function(from) as(from@ref, 'utsname'))
setAs('externalptr', 'utsnameRef', function(from) new('utsnameRef', ref = from))
setAs('externalptr', 'utsname', makeClosure(function(from) setSlots( getStructValue(from, .utsname.FFIType), new('utsname')), '.utsname.FFIType' = structType(list('sysname' = stringArrayType(256), 'nodename' = stringArrayType(256), 'release' = stringArrayType(256), 'version' = stringArrayType(256), 'machine' = stringArrayType(256)))))
setGeneric('utsname', function(`sysname`, `nodename`, `release`, `version`, `machine`, .obj = new('utsname')) standardGeneric('utsname'))
setMethod('utsname', 'ANY', function(`sysname`, `nodename`, `release`, `version`, `machine`, .obj = new('utsname')) {
if(!missing(`sysname`))  .obj@`sysname` = as(`sysname`, 'character')
if(!missing(`nodename`))  .obj@`nodename` = as(`nodename`, 'character')
if(!missing(`release`))  .obj@`release` = as(`release`, 'character')
if(!missing(`version`))  .obj@`version` = as(`version`, 'character')
if(!missing(`machine`))  .obj@`machine` = as(`machine`, 'character')
.obj})
setMethod('utsname', 'externalptr', function(`sysname`, `nodename`, `release`, `version`, `machine`, .obj = new('utsname')) as(`sysname`, 'utsname'))
setMethod('utsname', 'utsnameRef', function(`sysname`, `nodename`, `release`, `version`, `machine`, .obj = new('utsname')) as(`sysname`, 'utsname'))
setGeneric('utsnameRef', function(x) standardGeneric('utsnameRef'))
setMethod('utsnameRef', 'externalptr', function(x) new('utsnameRef', ref = x))
setMethod('utsnameRef', 'missing', makeClosure(function(x) new('utsnameRef', ref = alloc(.utsname.FFIType)), '.utsname.FFIType' = structType(list('sysname' = stringArrayType(256), 'nodename' = stringArrayType(256), 'release' = stringArrayType(256), 'version' = stringArrayType(256), 'machine' = stringArrayType(256)))))
setMethod('names', 'utsnameRef', function(x) c('sysname', 'nodename', 'release', 'version', 'machine'))
