\name{genTUInterface}
\alias{genTUInterface}
\alias{genCode}
\alias{genCode,EnumerationDefinition-method}
\alias{genCode,ResolvedTypeReference-method}
\alias{genCode,StructDefinition-method}
\alias{genCode,TypedefDefinition-method}
\title{Generate R code to interface to routines and data structure in C code}
\description{
  The \code{genTUInterface} function works on routines and data
  structures  and generates R code  to invoke those routines and
  access the data structures and their fields.
  The function by default reads the entire translation unit
  and finds the functions and data structures declared/defined in the
  TU. It then generates code to interface to all of them.
}
\usage{
genTUInterface(fileName, tu = parseTU(fileName),
               filter = character(), funcs = getRoutines(tu, filter),
               ds = getDataStructures(tu, filter),
               pattern,
               useClosure = TRUE, useGlobalFFIType = useClosure,
               useGlobalCIF = useClosure, putGlobalsInLoad = useGlobalCIF,
               genDoc = !missing(paramDocs), paramDocs = list(), ...)
genCode(x, name = "", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{fileName}{the name of the TU file. This is not the C source
    code, but the file generated by calling gcc/g++ with the
    -fdump-translation-unit flag.}
  \item{tu}{the parsed translation unit, created by calling
    \code{parseTU} on the TU file.  This can be passed instead of the
    file name if the caller has already parsed the TU and done some
    operations on it before generating the code.
   }
  \item{filter}{a character vector giving the names of files to identify
    which  routines and data structures  are of interested.
     This is passed as the \code{files} argument to \code{getRoutines}
     and \code{dataStructures}.
    See \code{pattern} also.}
  \item{funcs}{the TU nodes identifying the routines of interest.}
  \item{ds}{the TU nodes identifying the data structures of interest.}
  \item{pattern}{a regular expression that is used to identify the
    routines and data structures of interest based on their names.
    For example, we might look for all routines and data structures
    starting with "pcap", i.e. "^pcap".  This is an alternative to \code{filter} to
    identify the routines and data structures for which we want to
    generate interface code. }

  \item{x}{the object for which to generate code}
%  \item{\dots}{additional parameters that can be defined by methods}
  \item{name}{the name of the code object being created, i.e. the
    variable or class name}
  \item{useClosure}{a logical value that is passed onto
             \code{\link{createRFunc}} and
	     \code{\link{defStructClass}}.}
  \item{useGlobalFFIType}{a logical value that is passed onto
    \code{\link{defStructClass}}.}
  \item{useGlobalCIF}{a logical value that is passed onto
    each call to \code{\link{createRFunc}}.}
  \item{putGlobalsInLoad}{a logical value. Currently not used, but
  intended to control whether the creation of the global CIFs and FFI
  type are put into a .onLoad function so they can be evaluated
  when coad is loaded, not when it is installed, leading to nil-pointers
  when that code is actually loaded.
  }
  \item{genDoc}{a logical which controls whether the documenation is generated.
   If you specify any documentation content via \code{paramDocs}, you do not have to specify a 
   value for this parameter.
  }
  \item{paramDocs}{ one can specify a parameter paramDocs which should be a named list
   with names identifying the function. Each element provides one or more character strings
   for a parameter in the function. This allows us to override the default documentation for
   some parameters.}
  \item{\dots}{additional parameters that are passed on to \code{genDocumentation}.
  }
}
\value{
  A list containing the generated code.
  This can be written to a file or parsed and evaluated in an R
  session
}

\author{
Duncan Temple Lang
}

\seealso{
  \code{\link{defStructClass}}
  \code{\link{createRFunc}}
}
\examples{
\donttest{
  tu.file = system.file("TU", "utsname", "utsname.c.001t.tu", package = "RGCCTUFFI")
  code = genTUInterface(tu.file, pattern = "utsname|uname")

      # now we can evaluate/load/define the code in this R session
  define(code)

      # and now we can call it.
  u = utsnameRef()
  uname(u)

  names(u)
  u[]
  u$sysname
}


\dontrun{
    # we can write the code to a file so we can use it in a different R
    # session
  cat("library(Rffi)",
       unlist(code),
      sep = "\n",
      file = "utsnameCode.R")
}

}

\keyword{interface}
\keyword{programming}
