\name{getClassMethods}
\alias{getClassMethods}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Get descriptions for all  methods in a C++ class}
\description{
  This method iterates over the nodes within the translation unit
  array that are referenced from the class definition node
  via the 'fncs' attribute in the node.
  It creates a basic description of the method, capturing
  the node identifiers for the parameters, return type, etc.
  To make use of these, they must be resolved at a later point.
  (See \code{\link{resolveType}}.)
}
\usage{
getClassMethods(def, accessMode = c("public", "protected"), existingClasses = list(),
                dropArtificial = TRUE, dropOperators = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{def}{the node in the translation unit that gives the
    definition for the class of interest.
  }
  \item{accessMode}{a vector identifying whether public, protected
    and/or private methods should be processed.
    If this is non-empty, the \code{access} attribute of a method node
    is compared to the elements in this list and if it matches
    it is included in the return. If this is empty, all method nodes
    are processed.
  }
  \item{existingClasses}{currently ignored. This is intended to be a
    repository or catalog of resolved type definitions to avoid them
    being re-processed.
  }
  \item{dropArtificial}{a logical value indicating whether to
    discard methods that are identified as "artificial", i.e.
    generated by the compiler rather than explicitly defined in the
    code.}
  \item{dropOperators}{(logical) include or omit any C++ operator
    methods such as \code{operator() +}.}
  \item{\dots}{additional arguments passed to \code{\link{nodeIterator}}
    and hence possibly onto the function that processes each visited node.}
}
\value{
  A list with an element for each method declared within the class.
  The names of the methods are used as names for the list elements.
  
  Each element describes the corresponding method and is of class
  \code{NativeClassMethod}, a simple S3-style class.
  Each such element has the following fields:
  \item{returnType}{the index of the node in the translation unit
  the defines the type of the return value from the method.}
  \item{parameters}{a list of parameters (which may have names for the
    elements), each giving the index of the nodes defining the parameter.
  }
  \item{index}{the index of the node defining this method}
  \item{name}{a character vector giving the name of the method.}
}
\references{http://www.omegahat.org/RGCCTranslationUnit}
\author{Duncan Temple Lang <duncan@wald.ucdavis.edu>}

\seealso{
  \code{\link{readTU}}
  \code{\link{getClassNodes}}

  \code{\link{resolveType}}
}
\examples{

}

\keyword{interface}
\keyword{programming}

