\name{getFields}
\alias{getFields}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Find the TU nodes for fields or slots in a class or struct or union}
\description{
  This function follows the chain of translation unit
  nodes to collect the nodes defining fields within
  a C/C++ container object such as a \code{struct} or \code{union}
  or a C++ class.
  It is called with the TU node identifying the class or struct/union
  definition, and the function then traverses the linked nodes
  using \code{nodeIterator}.
  It can distinguish between public and/or protected fields
  which can be useful in different contexts,
  e.g. when creating regular accessors or generating derived classes
  whose methods can "see" protected fields.
}
\usage{
getFields(def, access = c("public", "protected"), existingClasses = list(),
           artificial = FALSE)
}
\arguments{
  \item{def}{a TU node identifying the container definition, i.e.
    a GCC::Node::type_decl or GCC::Node::record_type
    or a node identifying a field or variable declaration
    within a container.
    Passing a field or var declaration causes the function
    to iterate over the fields from that point on.
    This could be useful if one want to skip over
    certain fields, e.g. the first field in a
    C struct when it is being used as a 
    primitive inheritance technique.

    This value is passed to \code{field.decl} to
    find the first field.
  }
  \item{access}{a character vector specifying
    whether we are interested in public and/or protected
    fields. These are matched against the access attribute
    within the processed TU field/var nodes.
    This uses partial matching and so, for example,
    "pro" or "pri" would suffice.
    If this is either the empty character vector
    (i.e. \code{character()})
    or \code{NA}, all fields are returned.
    This is equivalent to \code{c("public", "protected", "private")}. 
  }
  \item{existingClasses}{unused}
  \item{artificial}{a logical value indicating whether to include
    (\code{TRUE}) or discard artificial fields that are generated by the
    compiler and not explicitly part of the structure as programmed.}
}
\value{
  A list containing the translation unit nodes
  corresponding to the fields of interest.
}
\references{ }
\author{Duncan Temple Lang}
\seealso{
 \code{\link{parseTU.Perl}}
 \code{\link{nodeIterator}}
 \code{\link{as.field.decl}}
}
\examples{
library(RGCCTranslationUnit)
p = parseTU(system.file("examples", "shapes.cc.t00.tu", package = "RGCCTranslationUnit"))
klasses = getClassNodes(p, "shapes")

    # Get all fields in the Shape class
 getFields(klasses[["Shape"]], character())

    # Get the public and protected fields in the Shape class
 getFields(klasses[["Shape"]])

 getFields(klasses[["Circle"]])

    # all fields, i.e. the private radius
 getFields(klasses[["Circle"]], character())
}
\keyword{programming}
\keyword{interface}
\concept{meta-programming}

