\name{parseTU}
\alias{parseTU}
\alias{parseTU.Perl}
\alias{parseTUOriginalTree}
\alias{readTU}
\alias{setLanguage}
\title{Read a Translation Unit file into memory.}
\description{
  This function provides a high-level interface to the
  Perl tools to process a translation unit graph
  and bring it into memory.
  The result is a Perl array of GCC::Node
  node types that describe the entities within the original source code.
  This array can be indexed by position from within R and
  the individual nodes can be processed in various ways.

  This function tolerates mis-specified file names
  allowing one to specify the name of the C/C++ source file
  or one with a ".tu" extension instead of the
  ".t00.tu" extension generated by more modern/up-to-date
  versions of GCC.  In other words,
  if the TU file is named \code{abc.cc.tu},
  the caller can specify the file name as
  \code{abc.cc}, \code{abc.cc.tu} or
  \code{abc.cc.t00.tu}. This forces the function to determine
  which extension is being used and not the caller.
  

  One can set the source language as "C" or "C++" when creating the
  parser  with \code{parseTU}, but \code{setLanguage} also allows one
  to set it after the parser has been created and the parsing performed.

  \code{parseTUOriginalTree} reads the type of file generated with the
  gcc/g++ command line  flag -fdump-tree-original-raw which results in a
  file with multiple, separate TUs for each routine in the original
  source. Each TU has its own set of nodes, numbered starting from 1 and
  so must be treated separately.
  This function returns a list of objects obtained by calling
  \code{parseTU} on each of the separate sub-TUs using \code{asText = TRUE}.
  
}
% serializedExtension = ".ser",
\usage{
parseTU(filename, language = NA, typedefs = NULL, asText = FALSE)
setLanguage(parser, language = NA)
parseTUOriginalTree(fileName)
}
\arguments{
  \item{filename, fileName}{the name of the file containing the translation unit.}
% serializedExtension is from the Perl parser.
% \item{serializedExtension}{a string giving the file extension that the function will use to see if a 
%   previously serialized version of the \code{GCC::TranslationUnit::Parser} has been saved in the
%   file given by \code{paste(fileName, serializedExtension, sep = "")}.
%   This allows one to specify the raw TU file name, e.g. \code{source.c.tu}
%   and have a serialized version of the parser as \code{source.c.tu.ser}.
%   If this is \code{""} or an empty character vector, the function  will work
%   directly from \code{fileName}.
%   If the serialized version is available but fails to load (due e.g.,
%    incompatible Perl module versions), the function will continue
%   and use the raw TU dump in \code{fileName}.
%
%   One can serialize an instance of the parser using
%   \code{p = parseTU("myFile.c.tu") ; p$save("myFile.c.tu.ser")},
%   or use the \code{store} method from the \code{Storable} Perl module,
%   e.g.   with
%   \code{.PerlPackage("Storable");
%         .Perl("store", tu, "autoGenerate/wx.cpp.tu.ser")}
%
%   The serialized version should be much faster to load.
%   Working with a dump of the entire wxWidgets header files,
%   the raw data on some of  my  machines takes 25 seconds to load;
%   the serialized version takes between 3 and 4 seconds.
%
%   Unfortunately, some problems seem to arise when using the serialized version.
%   More work is needed to understand and overcome these.  Your mileage may vary.
% }
  \item{language}{a string such as "C" or "C++" which tells the parser
    and, more specifically, code that uses the contents of parsed nodes
    that the original code from which the translation unit was generated
    was actually C code even if g++ was used to generate the tu file.
    This influences how, for example, structs are resolved,
    being \code{\link{StructDefinition-class}} for C code rather than
    \code{\link{C++ClassDefinition-class}} for C++ code.}
  \item{typedefs}{an optional \code{DefinitionContainer} object that can be passed by the caller to 
     initialize the \code{DefinitionContainer} within the parser object and which is used to resolve nodes.}
  \item{parser}{the parser object returned from a call to
    \code{parseTU}.}
  \item{asText}{a logical value indicating whether the \code{fileName}
    is the name of a file containing the translation unit (\code{FALSE})
    or if \code{fileName} is the actual contents of the TU ( \code{FALSE})
    as read from a  file by an R command (e.g. \code{\link[base]{readLines}})}
  }
\details{
  This uses the Perl GCCTranslationUnit module to read the translation
  unit
  and uses the \code{RSPerl} package to initiate this action
  and provide access to the resulting array.
}
\value{
  A reference to a Perl array
  which is of class \code{GCC::TranslationUnit::Parser}.
 This S3-style class has  methods in R that make it 
 easier to work with and treat more like a regular R
 list.    It allows indexing by
  position 
  or node name
 (taking into account the first element) ,
 and provides lapply/sapply methods for 
  looping over the elements and applying a function to each node.
 See \code{\link{GCC::TranslationUnit::Parser-class}} for more information.
}
\references{http://www.omegahat.org/RGccTranslationUnit}
\author{Duncan Temple Lang <duncan@wald.ucdavis.edu>}


\seealso{
  \code{\link{getAllDeclarations}}
  \code{\link{getGlobalVariables}}
  \code{\link{getFunctions}}
  \code{\link{getClassNodes}}  

  \code{\link{nodeIterator}}
}
\examples{
  tu = parseTU(system.file("examples", "myFun.cpp.tu", package = "RGCCTranslationUnit"))
  tu = parseTU(system.file("examples", "foo.c", package = "RGCCTranslationUnit"), language = "C")

    # Number of nodes in the translation unit
  .PerlLength(tu)
  class(tu)
  getRoutines(tu)
}
\keyword{interface}
\keyword{programming}

