setClass("BucketFrame", contains = 'data.frame',
           representation(name = "character"))



setClass("OAuth2PermissionToken", contains = "character")
setClass("OAuth2AuthorizationToken",
           representation(access_token = "character",
                          refresh_token = "character",
                          expiration = "POSIXct"
                          ))

setAs("character", "OAuth2PermissionToken",
      function(from)
         new("OAuth2PermissionToken", from))


setAs("OAuth2PermissionToken", "OAuth2AuthorizationToken",
      function(from) {
         now = Sys.time()
         tmp = getAuthorizationToken(from)
      })

setAs("character", "OAuth2AuthorizationToken",
       function(from) {
          if(grepl("^4/", from))
             as(new("OAuth2PermissionToken", from), "OAuth2AuthorizationToken")
          else
             stop("This is not a permission token")
    })

makeAuthorizationToken =
function(info, time = Sys.time())
{
   ans = new("OAuth2AuthorizationToken")
   ans@expiration =  time + info$expires_in
   ans@access_token = info$access_token
   ans@refresh_token = info$refresh_token
   
   ans
}
       

################

setClass("BasicACLDataFrame", contains = "data.frame")
setClass("ACLDataFrame", contains = "BasicACLDataFrame",
          representation(owner = "character"))
setClass("ACLDocument", contains = "XMLInternalDocument")
