GenericACL =
  c('project-private', 'private', 'public-read', 'public-read-write',
     'authenticated-read', 'bucket-owner-read', 'bucket-owner-full-control')

genericACL =
function(str)
{
  i = pmatch(str, GenericACL)
  if(is.na(i))
     stop("cannot match access control string ", str)

  GenericACL[i]
}



getScopeType =
  # getScopeType("duncan@google.com")
  # getScopeType('computing-statistics-curricula@googlegroups.com')
  # getScopeType("84fac329bceSAMPLE777d5d22b8SAMPLE77d85ac2SAMPLE2dfcf7c4adf34da46")
function(scope)
{
   if(nchar(scope) == 64 && !grepl( "[^[a-zA-Z0-9]]", scope))
       "UserById"
   else if(grepl("@googlegroups.com", scope))
      'GroupByEmail'
   else if(grepl("@google.com", scope))
      'UserByEmail'
   else if(scope == 'AllAuthenticatedUsers' || scope == 'AllUsers')
      scope
   else
      stop('scope ', scope, ' is not recognized as a scope yet')
}

accessList =
  # Should be accessFrame
  #
function(..., owner = NA)
{
   els = list(...)
   tmp = data.frame(permission = unlist(els),
                    scope = names(els),
                    type =  sapply(names(els), getScopeType))

   new("ACLDataFrame", tmp)
}

createACLDoc =
  #
  # a =  accessList("duncan@google.com" = "full",
  #              'computing-statistics-curricula@googlegroups.com' = "write",
  #              "84fac329bceSAMPLE777d5d22b8SAMPLE77d85ac2SAMPLE2dfcf7c4adf34da46" = "read")
  # createACLDoc( acl = a, owner = "00b4903a97f8e92544e2b4ed4781d9c280240153f95b068940955770edc6aaee")
  #
function(..., acl = accessList(...), owner = NULL)
{

   doc = newXMLDoc()
   root = newXMLNode("AccessControlList", parent = doc)

   if(is.null(owner) && is(acl, "ACLDataFrame"))
      owner = acl@owner
   
   if(!is.null(owner) && !is.na(owner))
     newXMLNode("Owner",
                 newXMLNode("ID", owner),
                 newXMLNode("Name"),
                parent = root)
   
   entries = newXMLNode("Entries", parent = root)
   mapply(makeACLEntryNode,
           acl$permission, acl$scope, as.character(acl$type), MoreArgs = list(parent = entries))

   doc
}

makeACLEntryNode =
function( permission, who, type, parent = NULL)
{
  e = newXMLNode("Entry", parent = parent)
  newXMLNode("Permission", mapPermission(permission), parent = e)
  sc = newXMLNode("Scope", attrs = c(type = type), parent = e)
    tag = switch(type,
                   UserById = 'ID',
                   UserByEmail = 'EmailAddress',
                   GroupById = 'ID',
                   GroupByEmail = 'EmailAddress'
                 )
    newXMLNode(tag, who, parent = sc)
    newXMLNode("Name", parent = sc)
  e
}

mapPermission =
function(what)
{
   match.arg(toupper(what), c("FULL_CONTROL", "READ", "WRITE"))
}

if(FALSE) {
  a =  accessList("duncan@google.com" = "full",
                  'computing-statistics-curricula@googlegroups.com' = "write",
                 "84fac329bceSAMPLE777d5d22b8SAMPLE77d85ac2SAMPLE2dfcf7c4adf34da46" = "read")
}

aclDocToFrame =
function(doc)
{
  r = xmlRoot(doc)
  owner = structure(xmlValue(r[["Owner"]][["ID"]]), names = xmlValue(r[["Owner"]][["Name"]]))
  entry = getNodeSet(doc, "//Entry")
browser()  
  tmp = data.frame(permission = sapply(entry, function(x) xmlValue(x[["Permission"]])),
                   scope = sapply(entry, getScopeValue),
                   name = sapply(entry, function(x) xmlValue(x[["Scope"]][["Name"]])),
                   type = sapply(entry, function(x) xmlGetAttr(x[["Scope"]], "type")))
  ans = new("ACLDataFrame", tmp)
  ans@owner = owner
  ans

}

getScopeValue =
function(node)
{
   i = which(names(node) != "name")
   xmlValue(node[[i]])
}

setAs("XMLInternalDocument", "ACLDataFrame", aclDocToFrame)
