makeHeader =
function(token, projectID = getOption('Google.storage.ID'), meta = FALSE, shortID = FALSE, addDate = TRUE)
{
   hdr = character()
   token = as(token, "OAuth2AuthorizationToken")
   hdr['Authorization'] = sprintf("OAuth %s", token@access_token)
   if(!is.na(projectID))
      hdr['x-goog-project-id'] = if(shortID) gsub("\\..*", "", projectID) else projectID

   if(addDate)
      hdr['Date'] = format(Sys.time(), "%B, %d %b %Y %H:%M:%S %Z")
   
   hdr[if(meta) 'x-goog-meta-x-goog-api-version' else 'x-goog-api-version'] = '2'
   hdr
}

parseBucketInfo =
function(txt, asDataFrame = TRUE, ...)
{
  if(asDataFrame) {
     doc = xmlParse(txt)
     ans = xmlToDataFrame(nodes = getNodeSet(doc, "//aws:Contents", "aws"), ...)
     ans$LastModified = as.POSIXct(strptime(as.character(ans$LastModified), "%Y-%m-%dT%H:%M:%S"))
     ans
  } else {
     xmlToList(txt)
     # els = tmp[ names(tmp) == "Contents"]
     # do.call(rbind, els)
  }
}
