\name{download}
\alias{download}
\alias{upload}
\alias{copy}
\title{Download, upload or copy an object in Google storage}
\description{
  These functions allow one to retrieve the content of an object
  in Google Storage or to create/update an object by uploading local content
  from a file or memory to a bucket.
  Additionally, we can copy an object to another object in the storage
  cloud without having to download it and then upload it again.
  This allows us to build a simple rename/move function.
}
\usage{
download(token, key, binary = NA, curl = getCurlHandle(), ..., projectID = getOption("Google.storage.ID"))
upload(token, key, content, type = NA, access = NA,
          curl = getCurlHandle(), ..., projectID = getOption('Google.storage.ID'))  
copy(token, fromKey, toKey, curl = getCurlHandle(), ...)
}
\arguments{
  \item{token}{the authorization token. See \code{\link{getAuth}} and \code{\link{getPermission}}}
  \item{key}{the identity of the object, i.e. its bucket and name in the
    form "bucketName/objectName".}
  \item{content}{the name of a file or a raw vector or an object of
    class as \code{AsIs}.  The latter two allow one to specify the
    content in memory rather than in a file.}
  \item{type}{a string giving the MIME type for the content. This is
    important as it is stored with the content and allows downloading of
    the content to understand the format of the content, e.g. XML, HTML,
    JSON, PNG, JPEG, etc.}  
  \item{fromKey,toKey}{the identity/paths of the objects to copy and
    where to copy it to.}
  \item{binary}{a logical value that controls whether the content of the
  object being downloaded should be treated as binary content or as
  text.}
  \item{access}{a string defining one of the basic access privileges
    that can be set when uploading content.  If this is \code{NA}, no
    ACL is set and the default is used by Google Storage}
  \item{curl}{an optional existing curl handle that is used for the HTTP
  requests in this operation}
  \item{\dots}{additional parameters that are passed to \code{\link[RCurl]{curlPerform}}}
  \item{projectID}{the Google project ID string}
}
\value{
  upload returns \code{TRUE} if successful.

  download returns the content as either a character string or a raw
  vector if the content is binary (or unknown).
}
\references{
 \url{http://code.google.com/apis/storage/docs/getting-started.html}
}
\author{
Duncan Temple Lang
}

\seealso{
  \code{\link{getAuth}}
  \code{\link{listBucket}},   \code{\link{removeBucket}}
}
\examples{
\dontrun{

   options(Google.storage.ID = '123457891011.apps.googleusercontent.com',
            Google.storage.Secret = 'itsASecret')
   token = getPermission('full')
       # cut and paste the string from the Web browser into R
   aa = getAuth(token)

   makeBucket(aa, "rgoogstorage")

   upload(aa, "rgoogstorage/abc",  I("This is text"), "text/text")
   download(aa, "rgoogstorage/abc")

   copy(aa,  "rgoogstorage/abc", "rgoogstorage/defgh")
   listBucket(aa, "rgoogstorage")
}
}
\keyword{programming}
\keyword{data} 
