\name{getACL}
\alias{getACL}
\alias{setACL}
\title{Query and set access permissions for Google Storage buckets and objects}
\description{
 These functions allow us to query the access permissions of a google
 storage  bucket or object and also  to set the permissions.
 To query the access, use \code{getACL}.
 There are two ways to set permissions. One is to specify the access
 parameter when one uploads an object. This allows us to use one of the
 standard permissions. See the object \code{RGoogleStorage:::GenericACL}.

}
\usage{
getACL(token, key, curl = getCurlHandle(), ..., projectID = getOption("Google.storage.ID"))
setACL(token, key, access, owner = NULL, curl = getCurlHandle(), ...)  
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{token}{the authorization token. See \code{\link{getAuth}} and \code{\link{getPermission}}}
  \item{key}{the identity of the object, i.e. its bucket and name in the
    form "bucketName/objectName".}  
  \item{curl}{an optional existing curl handle that is used for the HTTP
    requests in this operation}
  \item{access}{an object describing the collection of permissions. This
  ultimatly ends up being converted to an XML document. It can be the
  XML document, a list identifying the scope or a data frame}
  \item{\dots}{additional parameters that are passed to \code{\link[RCurl]{curlPerform}}}
  \item{projectID}{the Google project ID string}
  \item{owner}{the ID of the owner of the bucket given as a string.}
}
\value{
  \code{getACL} returns an object of class \code{ACLDataFrame}.
  This is a data frame with 3 columns giving the permission string, the
  target of the scope (e.g. Google email, Google user ID, Google group
  ID or email, ...),
  the type of the scope target.
  Additionally, the \code{ACLDataFrame} contains an \code{owner}
  slot giving the ID of the owner of the object.
}
\references{
  \url{http://code.google.com/apis/storage/docs/accesscontrol.html}
}
\author{
Duncan Temple Lang
}
\seealso{
  \code{\link{upload}} and   \code{\link{download}}.  
}
\examples{

\dontrun{

   options(Google.storage.ID = '123457891011.apps.googleusercontent.com',
            Google.storage.Secret = 'itsASecret')
   token = getPermission('full')
       # cut and paste the string from the Web browser into R
   aa = getAuth(token)

   makeBucket(aa, "rgoogstorage")

   getACL(aa, "rgoogstorage")
}

}
\keyword{programming}
\keyword{data} 

