\name{listBucket}
\alias{listBucket}
\alias{removeBucket}
\alias{makeBucket}
\title{Operations for buckets}
\description{
  These functions allow us to create and delete buckets or to list the
  contents of a bucket.
}
\usage{
listBucket(token, bucket, curl = getCurlHandle(), ..., projectID = getOption("Google.storage.ID"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{token}{the authorization token. See \code{\link{getAuth}} and \code{\link{getPermission}}}
  \item{bucket}{the identity of the object, i.e. its bucket and name in the
    form "bucketName/objectName".}
  \item{curl}{an optional existing curl handle that is used for the HTTP
  requests in this operation}
  \item{\dots}{additional parameters that are passed to \code{\link[RCurl]{curlPerform}}}
  \item{projectID}{the Google project ID string}  
}
\value{
  listBucket returns a data frame with a row for each entry in the bucket
  and with variables giving the key/name of the object,
  time last modified, ETag, Size, StorageClass and Owner.

  
  makeBucket and removeBucket return \code{TRUE} if successful.
}
\references{
 Google Storage API \url{http://code.google.com/apis/storage/docs/getting-started.html} 
}
\author{
Duncan Temple Lang
}

\seealso{
  \code{\link{getPermission}} and \code{\link{getAuth}}.
  \code{\link{upload}} and   \code{\link{download}}.
}
\examples{

\dontrun{
  makeBucket(aa, "phase7")
  upload(aa, "phase7/tmp", I("This is a string"))
  download(aa, "phase7/tmp", binary = FALSE)
}

}

\keyword{data}
\keyword{programming}

