
\name{commentTable}
\alias{commentTable}
\alias{commentNodes}
\alias{comments}

\title{Access the comments in the document}

\description{These functions allow the caller to retrieve information about the comments in an Office Open document.
We can get just the content of the comments, or the contents along with meta-information
such as the date and author, or the XML nodes representing the comments.
The last of these is useful if we want to programmatically modify the comments.
     }

\usage{
commentTable(doc)
commentNodes(doc)
comments(doc, op = xmlValue)
}

\arguments{\item{doc}{}\item{op}{}}

\value{
     \code{comments}
    returns a character vector giving the contents of the comments.
    
     \code{commentTable}
    returns a data frame with as many rows as there are comments.
The data frame has 4 variables: 
 
 \item{id}{the identifier for the author}
 \item{author}{the name of the author}
 \item{date}{the date the comment was changed and of class POSIXct.}
 \item{value}{the text content of the comment}
     \code{commentNodes}
    returns a list of XMLInternalElementNode objects.
     }

\references{}

\seealso{\code{\link[RWordXML]{wordDoc}}}

  \author{Duncan Temple Lang \email{duncan@wald.ucdavis.edu}
}
 
\examples{
  
     file = system.file("SampleDocs", "WordEg.docx", package = "ROOXML")
if(require(RWordXML)) {
     doc = wordDoc(file)
     comments(doc)

     commentTable(doc)

     commentNodes(doc)
}
        
}

\keyword{documentation}
