<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:r="http://www.r-project.org"
		xmlns:s="http://cm.bell-labs.com/stat/S4"
		xmlns:c="http://www.C.org"
                xmlns:python="http://www.python.org"
                xmlns:perl="http://www.perl.org"
		xmlns:vb="http://www.visualbasic.com"
		xmlns:omegahat="http://www.omegahat.org"
                xmlns:bioc="http://www.bioconductor.org"
                xmlns:java="http://www.java.com"
		xmlns:statdocs="http://www.statdocs.org"
		xmlns:gtk="http://www.gtk.org"
		xmlns:com="http://www.microsoft.com"
		xmlns:sh="http://www.shell.org"
		exclude-result-prefixes="s r c python bioc gtk com sh java omegahat perl vb statdocs"
                version="1.0">

<!-- Customization layer -->

<!-- Use 'chunk.xsl' in line below to chunk files. -->
<!-- 
<xsl:import href="http://docbook.sourceforge.net/release/xsl/current/html/docbook.xsl"/>
 -->

<xsl:import href="defs.xsl"/>
<xsl:import href="SLanguage.xsl"/>
<xsl:import href="COM.xsl"/>
<xsl:import href="xml.xsl"/>
<xsl:import href="gtk.xsl"/>


<xsl:param name="codebox" select="0"/>

<xsl:param name="html.stylesheet" select="'S.css'"/> <!-- doc:type='string'  -->
<xsl:param name="generate.section.toc.level" select="0"/>  <!--  doc:type='int'/> -->
<xsl:param name="generate.toc" select="0"/>  <!--  doc:type='int'/> -->
<xsl:param name="rhelp.dir" select="''" />

<xsl:template name="code">
 <table border="{$codebox}">
 <tr align="left"><th>
 <xsl:if test="@xml:id"><xsl:element name="a"><xsl:attribute name="name"><xsl:value-of select="@xml:id"/></xsl:attribute></xsl:element></xsl:if>
 <pre class="{$class}" align="left">
   <xsl:apply-templates/>
 </pre>
 </th></tr>
</table>
<br/>
</xsl:template>

<!-- In SLanguage.xsl (the same)
<xsl:template name="var">
  <b class="${class}"><xsl:apply-templates/></b>
</xsl:template>
-->


<xsl:template name="keyword">
  <b class="${class}"><xsl:apply-templates/></b>
</xsl:template>

<xsl:template name="type">
  <i class="{$class}"><xsl:apply-templates/></i>
</xsl:template>


<xsl:template match="r:func[@name]|s:func[@name]|s:method[@name]">
  <i>
  <xsl:element name="a">
   <xsl:attribute name="href"><xsl:value-of select="$rhelp.dir"/><xsl:value-of select="@name"/>.html</xsl:attribute>
   <xsl:value-of select="@name"/>()
  </xsl:element>
  </i>
</xsl:template>


<xsl:template match="r:func|s:func|s:method" name="func">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href"><xsl:value-of select="$rhelp.dir"/><xsl:value-of select="."/>.html</xsl:attribute>
<!-- <xsl:value-of select="name(.)"/>("<xsl:value-of select="."/>") -->

   <xsl:apply-templates/>()
  </xsl:element>
  </i>
</xsl:template>

<xsl:template match="s:functionDef|s:function|r:function" name="funcDef">
  <xsl:call-template name="code">
    <xsl:with-param name="class">s</xsl:with-param>
  </xsl:call-template>
</xsl:template>


<xsl:template match="r:arg|s:arg">
 <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="r:slot|s:slot">
  <i class="slot"><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="r:namespace">
 <b class="namespace"><xsl:apply-templates/></b>
</xsl:template>

<xsl:template match="c:routine|c:method">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href"><xsl:value-of select="name(.)"/>("<xsl:value-of select="."/>")</xsl:attribute>
   <xsl:apply-templates/>
  </xsl:element>
  </i>
</xsl:template>


<xsl:template match="s:field|r:field">
  <i><xsl:apply-templates/></i>
</xsl:template>


<xsl:template match="r:pkg|r:package|s:package|s:library">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href">s:package("<xsl:value-of select="."/>")</xsl:attribute>
   <xsl:apply-templates/>
  </xsl:element>
  </i>
</xsl:template>



<xsl:template match="omegahat:package">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href">http://www.omegahat.org/<xsl:value-of select="."/></xsl:attribute>
   <xsl:apply-templates/>
  </xsl:element>
  </i>
</xsl:template>


<xsl:template match="statdocs:package">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href">http://www.statdocs.org/<xsl:value-of select="."/></xsl:attribute>
   <xsl:apply-templates/>
  </xsl:element>
  </i>
</xsl:template>



<xsl:template match="bioc:package">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href">http://www.bioconductor.org/<xsl:value-of select="."/></xsl:attribute>
   <xsl:apply-templates/>
  </xsl:element>
  </i>
</xsl:template>


<!-- Perhaps change the name here to html unless we know we can deal 
     with XML files all the way. -->
<xsl:template match="r:include">
 <xsl:element name="a">
  <xsl:attribute name="href"><xsl:value-of select="doc"/>#<xsl:value-of select="@ref"/></xsl:attribute>
  <xsl:value-of select="@ref"/>
 </xsl:element>
</xsl:template>

<xsl:template match="s:class|r:class|c:class|java:class|com:class|com:interface">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href"><xsl:value-of select="$rhelp.dir"/><xsl:value-of select="."/>-class.html</xsl:attribute>
   <xsl:apply-templates/>
  </xsl:element>
  </i>
</xsl:template>


<xsl:template match="s:class[@file]|r:class[@file]">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href"><xsl:value-of select="$rhelp.dir"/><xsl:value-of select="@file"/>-class.html</xsl:attribute>
   <xsl:apply-templates/>
  </xsl:element>
  </i>
</xsl:template>


<xsl:template match="s:class[@name]|r:class[@name]">
 <i>
  <xsl:element name="a">
   <xsl:attribute name="href"><xsl:value-of select="$rhelp.dir"/><xsl:value-of select="@name"/>-class.html</xsl:attribute>
   <xsl:value-of select="@name"/>
  </xsl:element>
  </i>
</xsl:template>



<xsl:template match="@*"> <xsl:value-of select="."/></xsl:template>

<xsl:template match="hr|sub|sup|i|object|param|table|tr|td|th|h1|h2|h3|h4|h5|h6|code|form|font|html|head|body|OBJECT|PARAM|br|option|select|optgroup|input">
 <xsl:element name="{name(.)}">
  <xsl:for-each select="@*">
   <xsl:copy />
  </xsl:for-each>
   <xsl:apply-templates />
 </xsl:element>
</xsl:template>

<xsl:template match="key">
 <b><xsl:apply-templates /></b>
</xsl:template>


<xsl:template match="s:prompt">
 <b>&gt;</b>
</xsl:template>

<xsl:template match="s:output|r:output">
 <pre class="output"><xsl:apply-templates/></pre>
</xsl:template>


<xsl:template match="directory">
  <xsl:call-template name="inline.monoseq"/>/
</xsl:template>

</xsl:stylesheet>
