if(FALSE) {
   # We get these from RAutoGenRunTime
setClass("RNativeReference", representation(ref = "externalptr"))
setClass("RCReference", contains = "RNativeReference")
setClass("RCStructReference", contains = "RCReference")
}

setClass("FFIType", contains = "RCReference")
setClass("ScalarFFIType", contains = "FFIType")
setClass("StructFFIType", representation(fieldNames = "character"), contains = "FFIType")
setClass("PointerFFIType", contains = "FFIType")
setClass("SEXPFFIType", contains = "PointerFFIType")
setClass("VoidFFIType", contains = "FFIType")
setClass("StringFFIType", contains = "ScalarFFIType")
setClass("FixedLengthStringFFIType", contains = "StringFFIType")

setClass("ArrayFFIType", representation(length = "integer", elType = "FFIType"), contains = "ScalarFFIType")

setOldClass("NativeSymbol")

setClass("AddressOf", contains = "RCReference")

setAs("FFIType", "externalptr",
       function(from)
        from@ref)

UseSimpleCRunTime = TRUE

if(!UseSimpleCRunTime) {
setAs("RCReference", "externalptr",
       function(from)
        from@ref)

setMethod("[", c("RCStructReference"),
          function(x, i, j, ...) {
             sapply(unlist(c(i, ...)), function(id) x[[id]])
          })

setMethod("[", c("RCStructReference", "missing"),
          function(x, i, j, ...) {
             sapply(names(x), function(id) x[[id]])
          })


setMethod("[[", c("RCStructReference", "character"),
          function(x, i, j, ...) {
             do.call(`$`, list(x, i))
          })
}          
           
