\name{xsltCallTemplate}
\alias{xsltCallTemplate}
\title{Allow R to invoke an XSL template}
\description{
  This function allows the R programmer to identify and
  invoke an XSL template on a particular XML node,
  passing parameters in the invocation that can be used
  to customize the behavior of the template.
  The template can be identified as a node or by name
  or XPath query string.
}
\usage{
xsltCallTemplate(ctx, node, template, ..., .params = list(...))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ctx}{the \code{XMLXPathParserContext}
    object that is passed to an R function
    that is called from the XSL transformation.
    Such an R function must be registered with
    XSLT as an extension function, typically using
    \code{\link{addXSLTFunctions}}   and must
    be an object of (S3) class \code{XSLContextFunction}
    created by a call to \code{\link{xsltContextFunction}}.}
  \item{node}{ the \code{XMLInternalNode} object
    on which the template is to be applied.
  }
  \item{template}{
    the template which is to be called.
    This can be an \code{XMLInternalNode}
    object either obtained from
    the XSL stylesheet document,
    or the name (character string) of a template which is then
    used in a call to \code{\link[XML]{getNodeSet}}
    to find the node by matching the \code{name} attribute.
    Alternatively, this can be a general XPath
    expression which will be passed to \code{\link[XML]{getNodeSet}}.
  }
  \item{\dots}{one or more named parameter values
    which are passed in the call as \code{xsl:param}
    name-value pairs.
    At present, these should be strings. In the future,
    we will be able to support node sets and tree fragments.
   This form is useful for interactive use where the individual
   parameters are known at the time of the call as separate elements.
  }
  \item{.params}{a list of the named parameter values.
    This is the programmatic version of \dots
    which facilitates passing the values when they are computed
    rather than specified manually/interactively in the call.
  }
}
\details{
  This calls libxslt's xsltCallTemplate, but does a lot of work
  to construct the pre-compiled information for the templates.
}
\value{
  \code{NULL}.
  The purpose of calling this function is for the side effect
  of creating content in the target/output document being
  generated by the XSL transformation.
}
\references{
 \url{http://www.w3.org/Style/XSL}      
 \url{http://www.xmlsoft.org/XSLT}
}
\author{ Duncan Temple Lang}

\seealso{
 \code{\link{addXSLTFunctions}}
 \code{\link{xsltContextFunction}}
 \code{\link{xsltApplyStyleSheet}}

  For an example, see
  applyTemplates.R,   applyTemplates.xsl
  and   applyTemplates.xml in the examples directory.  
}
\examples{

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{IO}
\keyword{programming}

