\name{checkValues}
\alias{checkValues}
\title{Check user-supplied values are from set of permissable values}
\description{
  This function may be used in code generated by reading the WADL
  and is for cases where a parameter in the REST method
  has a fixed set of possible values. This function verifies
  that the user-supplied values are in this set and raises
  an error otherwise.

  In the future, it may return corrected values.
}
\usage{
checkValues(value, options, varName = deparse(value), repeating = FALSE)
}
\arguments{
  \item{value}{a character vector of the user-supplied values.}
  \item{options}{the set of permitted values; a character vector}
  \item{varName}{the name of the variable being matched. Potentially
    used in the error message.}
  \item{repeating}{whether we can have more than one value in
    \code{value},   i.e. the method allows several values rather than
    just one.}
}
\value{
  The expanded  version of \code{value},
  i.e. with any abbreviations  replaced by their full form from
  \code{options}.
}
\references{

}
\author{
Duncan Temple Lang
}
\seealso{
 \code{\link[base]{match.arg}}
}
\examples{
 checkValues("Jan", c("January", "February", "March"))

 try(checkValues("Jn", c("January", "February", "March"), "month"))
}
\keyword{programming}
\keyword{interface}

