RSXMLHandlers <-
function()
{
  array <- function(x, attrs) {
    tmp <- unlist(xmlChildren(x)) 
    names(tmp) <- NULL
   tmp
  }
  Double <- function(x, attrs) {
    as.numeric(xmlValue(x[[1]]))
  }
  Integer <- function(x, attrs) {
    as.integer(xmlValue(x[[1]]))
  }
  Logical <- function(x, attrs) {
    as.logical(xmlValue(x[[1]]))
  }

  String <- function(x, attrs) {
   xmlValue(x[[1]])
  }

  Factor <- function(x, attrs) {
    factor(x[["values"]][[1]])
  }

Factor <-
function(x)
{
  vals <- x[["values"]][[1]]
  levs <- x[["levels"]]

  ordered <- as.logical(xmlAttrs(x)["ordered"])
  if(is.null(ordered) || length(ordered) == 0)
    ordered <- F

  if(is.null(levs))
    f <- factor(unlist(vals), ordered = ordered)
  else
    f <- factor(vals, levels = unlist(levs[[1]]), ordered = ordered)
     

 f
}

  List <- function(x, attrs) {
    tmp <- xmlApply(x, function(x) x[[1]])
    names(tmp) <- NULL

    tmp
  }

 namedArray <- function(x) {
   idx <- seq(1, by=2, length=xmlSize(x)/2)
   val <- unlist(x[idx+1])
   names(val) <- unlist(x[idx])

  val
 }

 namedlist <- function(x) {
   attrs <- xmlAttrs(x)
   idx <- seq(1, by=2,length= as.integer(attrs["length"]))
   val <- lapply(x[idx+1], function(x) x[[1]])
   names(val) <- unlist(x[idx])

   val  
 }


  Name <- function(x, attrs) {
   if(xmlSize(x) > 0)
     xmlValue(x[[1]])
   else
     ""
  }

  Rownames <- function(x, attrs) {
   x[[1]]
  }

 
  Matrix <- function(x) {
    attrs <- xmlAttrs(x)
    matrix(x[[1]],as.integer(attrs["nrow"]), as.integer(attrs["ncol"]),byrow=as.logical(attrs["byrow"]))
  }

  DataFrame <- function(x) {
    l <- x[[1]]
    val <- as.data.frame(lapply(l, function(z) if(is.list(z)){ I(z)} else z))

    if(!is.null(x[["rownames"]]))
      rownames(val) <- x[["rownames"]]

    val
  }

  
  timeseries <- function(x) {
    a <- xmlAttrs(x)
    ts(x[[1]], start=as.numeric(a["start"]), end=as.numeric(a["end"]),
               frequency=as.numeric(a["frequency"]))
  }


  Symbol <- function(x) {
    as.name(xmlValue(x[[1]]))
  }

  Caller <- function(x) {
    x[[1]]
  }

  Call <- function(x) {
     # this is slightly cheating. It assumes the structure
     # of a call to be a list. We should use do.call
     # Otherwise, we can do some trickery with escaping the
     # arguments to the call so they are not evaluated and remain
     # symbolic.
   k <- do.call("call", list(as.character(x[[1]])))
   args <- xmlChildren(x[[2]])
   n <- length(args)
   tmp <- vector("list", n+1)
   if(n > 0)
     k[2:(n+1)] <- args

   k
  }

  args <- function(x) {
   els <- xmlChildren(x)
   argNames <-  sapply(els, function(x) xmlAttrs(x)["name"])
     # Note that we use an alist() so that we can handle missing
     # entries which correspond to arguments that have no default value.
     # Need to get a handle to a missing element of an alist()
   fake <- alist(a=)
   args <- alist()
   for(i in els) {
     name <- xmlAttrs(i)["name"]
     if(xmlSize(i) > 0)
       args[[name]] <- i[[1]][[1]]
     else
       args[[name]] <- fake[[1]]
   }

   args
  }

  Function <- function(x) {
    f <- function(){}
    formals(f) <- x[[1]]
    body(f) <- x[[2]][[1]]
      # This needs to keep a stack of environments
      # and pull the one off the top. And this is where we need
      # the closure.
    environment(f) <- .GlobalEnv

   f
  }


  For <- function(x) {
   e <- call("for")
   e[[2]] <- x[["index"]][[1]]
   e[[3]] <- x[["elements"]][[1]]
   e[[4]] <- x[["loop"]][[1]]

   e
  }

  Assign <- function(x){
    e <- call("<-")
    e[[2]] <- x[[1]]
    e[[3]] <- x[[2]]

   e
  }


  return(list(array = array, namedArray=namedArray, double = Double, integer = Integer, 
              logical = Logical, 
              factor=Factor, character=String, string=String, list=List, 
              name=Name, rownames=Rownames,
              namedlist = namedlist,
              matrix=Matrix, dataframe = DataFrame, timeseries=timeseries,
              symbol=Symbol, caller=Caller, call=Call,
              "function"=Function, args=args,
              "for"=For, 
              "assign"=Assign
              ))
}

fromXML.object <-
function(x, attrs) {
   x[[1]]
}

addHandlers <-
function(.to=list(), .from=RSXMLHandlers(), ...,.env = NULL)
{
#  args <- list(...)
  args <- c(.from, list(...))
  for(i in names(args)) {
    f <- args[[i]]
    if(!is.null(.env))
      environment(f) <- .env
    .to[[i]] <- f
  }

 .to
}
