

writeXML <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{
 invisible(UseMethod("writeXML"))
}

writeXML.default <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{

 if(length(class(x)) > 0)
   return(writeXML.object(x, con, ...))

# name <- paste("writeXML", typeof(x), sep=".")
 name <- paste("writeXML", data.class(x), sep=".")

 if(exists(name, mode="function")) {
   f <- get(name, mode="function")
   val <- f(x, con, ...)
 } else if(is.integer(x)) {
   val <-  lapply(x, function(i, con, ...) { con$addTag("integer", i); T} , con=con, ...)
 } else if(!is.na(match(mode(x), c("integer", "numeric", "character", "logical")))) {
   val <- lapply(x, function(i, con, tag, ...) { con$addTag(tag, i); T} , con=con, tag=mode(x), ...)
 } else if(typeof(x) == "NULL") {
   val <- con$addTag("null")
 } else {
   name <- paste("writeXML", typeof(x), sep=".")
   if(exists(name, mode="function")) {
     f <- get(name, mode="function")
     val <- f(x, con, ...)
   } else
      stop(paste("No method for writeXML", typeof(x)))
 }

 invisible(return(val))
}



writeXML.vector <-
function(x, con, ...)
{
 n <- names(x)
 if(!is.null(n))
   tagName <- "namedArray"
 else
   tagName <- "array"

 con$addTag(tagName, attrs=c(type=typeof(x),size=length(x)), close=F)
 for(i in 1:length(x)) {
   if(!is.null(n))
    con$addTag("name", n[i])
   con$addTag(typeof(x),as.character(x[i]))
 }
 con$addEndTag(tagName)

 invisible(con)
}


writeXML.integer <-
function(x, con, ...)
{
 writeXML.vector(x, con, ...)
}

writeXML.character <- writeXML.integer
writeXML.logical <- writeXML.integer
writeXML.numeric <- writeXML.integer
writeXML.double <- writeXML.integer


writeXML.list <-
#
# Write the representation of an S list
# to the XML connection.
#
#
function(x, con,  ...)
{
 isNamed <- (length(names(x)) > 0)
 tag <- ifelse(isNamed, "namedlist", "list")

 con$addTag(tag, attrs=c(length=length(x)), close=F)
 for(i in 1:length(x)) {
   if(isNamed) {
    con$addTag("name", names(x)[i])
   }
    con$addTag("element", close=F)
       writeXML(x[[i]], con, ...)
    con$addEndTag("element")
 }

 con$addEndTag(tag)

 invisible(con)
}

writeXML.object <-
#
# Writes a general S3 object, i.e. one with a 
# non-null class() value. 
# This just writes out the names of the named
# elements of x. 
# Doesn't handle non-named lists yet
#
function(x, con, ...)
{
 classes <- class(x)
 con$addTag("object", attrs=c(type=classes[1]), close=F)
 for(i in names(x)) {
   con$addTag("slot", attrs=c(name=i), close=F)
    writeXML(x[[i]], con, ...)
   con$addEndTag("slot")
 }
   
 if(length(classes) > 1) {
   con$addTag("classes", attrs=c(length=length(classes)))
   sapply(classes, function(x, con, ...) {
                          con$addTag("class", x)
                       }, con, ...)
   con$addEndTag("classes")
 }

  con$addEndTag("object")

 invisible(con)
}

writeXML.matrix <-
function(x, con, ...)
{
 con$addTag("matrix", attrs=c(nrow=nrow(x),ncol=ncol(x),type=typeof(x),byrow=F), close=F)
 writeXML(as.vector(x), con)
 n <- dimnames(x)
 if(!is.null(rownames(x))) {
    con$addTag("rownames", close=F)
    xmlWrite(rownames(x), con=con)
    con$addEndTag("rownames")
 }
 if(!is.null(colnames(x))) {
    con$addTag("colnames", close=F)
    xmlWrite(colnames(x), con=con)
    con$addEndTag("colnames")
 }
    
 con$addEndTag("matrix")

 invisible(con)
}

writeXML.data.frame <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{
 con$addTag("dataframe", attrs=c(nrow=nrow(x),ncol=ncol(x)), close=F)
 writeXML(as.list(x), con)
 con$addTag("rownames", close=F)
 writeXML(rownames(x), con)
 con$addEndTag("rownames")
 con$addEndTag("dataframe")

 invisible(con) 
}

writeXML.ts <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{
 con$addTag("timeseries", 
            attrs=c(size=length(x),frequency=frequency(x),start=start(x)[1],end=end(x)[1]),close=F)
 if(mode(x)=="list")
   writeXML(as.list(x), con)
 else
   writeXML(as.vector(x), con)

 con$addEndTag("timeseries")

 invisible(con) 
}

writeXML.AsIs <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{
 invisible(writeXML(unclass(x), con))
}


writeXML.POSIXct <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{

}
writeXML.POSIXlt <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{

}

writeXML.table <-
function()
{

}


writeXML.table <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{
 con$addTag("multidimtable", close=F)
 invisible(con)
}


writeXML.table <-
function(x, con=xmlOutputBuffer(nameSpace="rs", nsURI="http://www.omegahat.org/RS"), ...)
{
 con$addTag("multidimtable", close=F)
# convert to matrix? For xtabs, makes sense.
 invisible(con)
}


writeXML.closure <-
function(x, con, ...)
{
 is.missing.arg <- function(arg) typeof(arg) == "symbol" && deparse(arg) == ""
 args <- formals(x)
 con$addTag("function", close=F)
 con$addTag("args", attrs=c(length=length(args)), close=F)
 for(i in names(args)) {
   con$addTag("arg", attrs=c(name=i), close=F)
   if(!is.missing.arg(args[[i]])) {
     con$addTag("value", close=F)
     writeXML(args[[i]], con, ...)
     con$addEndTag("value")
   }
   con$addEndTag("arg")
 }
 con$addEndTag("args")

 b <- body(x)
 if(length(b) > 1)
    bodyLen <- length(body(x))-1
 else
    bodyLen <- 1

 con$addTag("body", attrs=c(length=bodyLen), close = F)
   writeXML(b, con, ...)
 con$addEndTag("body")
 con$addEndTag("function")

 invisible(con)
}

writeXML.language <-
function(x, con, ...)
{
 if(x[[1]] == "if") {
   writeXML.if(x, con, ...)
 } else if(x[[1]] == "{") {
   for(i in 2:length(x))
     writeXML(x[[i]], con, ...)
 } else if(x[[1]] == "for") {
   writeXML.for(x, con, ...)
 } else if(isLogicalExpression(x)) {
   writeXML.logicalExpr(x, con, ...)
 } else if(isComparator(x)) {
   writeXML.comparator(x, con, ...)
 } else if(x[[1]] == "while") {
   writeXML.while(x, con, ...)
 } else if(x[[1]] == "break" || x[[1]] == "next") {
   con$addTag(x[[1]])
 } else if(x[[1]] == "<-") {
   con$addTag("assign", close=F)
   writeXML(x[[2]], con, ...)
   writeXML(x[[3]], con, ...)
   con$addEndTag("assign")
 } else if(x[[1]] == "repeat") {
   con$addTag("repeat", close=F)
   writeXML(x[[2]], con, ...)
   con$addEndTag("repeat")
 } else if(x[[1]] == "return") {
   con$addTag("return", close=F)
    if(length(x) > 1)
     writeXML(x[[2]], con, ...)
   con$addEndTag("return")
 } else if(mode(x) == "call") {
   writeXML.call(x, con, ...)
 } 

 invisible(con)
}

writeXML.if <-
function(x, con, ...)
{
 con$addTag("if", close=F)
 
  con$addTag("cond", close=F)
    writeXML(x[[2]], con, ...)
  con$addEndTag("cond")
  if(length(x) > 2) {
    con$addTag("action", close=F)
     writeXML(x[[3]], con, ...)
    con$addEndTag("action")
  }
  if(length(x) == 4) {
    con$addTag("else", close=F)
     writeXML(x[[4]], con, ...)
    con$addEndTag("else")
  }

 con$addEndTag("if")

 invisible(con)
}


writeXML.for <-
function(x, con, ...)
{
 con$addTag("for", close=F)
 
  con$addTag("index", close=F)
    writeXML(x[[2]], con, ...)
  con$addEndTag("index")

  con$addTag("elements", close=F)
     writeXML(x[[3]], con, ...)
  con$addEndTag("elements")

   con$addTag("loop", close=F)
     writeXML(x[[4]], con, ...)
   con$addEndTag("loop")

 con$addEndTag("for")

 invisible(con)
}


writeXML.while <-
function(x, con, ...)
{
 con$addTag("while", attrs = c(doWhile= (x[[1]] == "do")), close=F)
 
  con$addTag("cond", close=F)
    writeXML(x[[2]], con, ...)
  con$addEndTag("cond")

  con$addTag("loop", close=F)
     writeXML(x[[3]], con, ...)
  con$addEndTag("loop")

 con$addEndTag("while")

 invisible(con)
}

writeXML.symbol <-
function(x, con, ...)
{
 con$addTag("symbol", as.character(x))
 invisible(con)
}

specialCalls <- c("<-"="assign", "for"="for", "while"="while")

isSpecialCall <- function(x)  {
 callName <- as.character(x[[1]])
 if(!is.na(match(callName, names(specialCalls)))) {
   return(get(paste("writeXML", specialCalls[callName], sep=".")))
 }

 NULL
}

writeXML.assign <- function(x, con, ...) 
{
   con$addTag("assign", close=F)
   writeXML(x[[2]], con, ...)
   writeXML(x[[3]], con, ...)
   con$addEndTag("assign")
 invisible(con)
}

writeXML.call <-
function(x, con, ...)
{
 if(isLogicalExpression()) {
   return(writeXML.logicalExpr(x, con, ...))
 } else if(isComparator(x)) {
   writeXML.comparator(x, con, ...)
 } else if(!is.null( f <- isSpecialCall(x))) {
   return(f(x, con, ...))
 }

  con$addTag("call", attrs=c(numArgs=length(x)-1), close=F)
   con$addTag("caller", close=F)
    writeXML(x[[1]], con, ...)
   con$addEndTag("caller")

  con$addTag("arguments", close=F)


     # Don't make this a x[2:length(x)]
     # or x[-1]. Infinite loop results.
   argNames <- names(x)

 if(length(x) > 1) {
   for(i in seq(2, length=length(x)-1)) {
    if(!is.null(argNames) && argNames[i] != "")
     con$addTag("namedArg", attrs=c(name=argNames[i]), close=F)

    writeXML(x[[i]], con, ...)

    if(!is.null(argNames) && argNames[i] != "")
     con$addEndTag("namedArg")
   }
 }

  con$addEndTag("arguments")
  con$addEndTag("call")

 invisible(con)
}

isLogicalExpression <-
function(x, ...)
{
 if(is.expression(x))
  x <- x[[1]]

  !is.na(match(as.character(x[[1]]), c("&", "&&", "|", "||")))
}


writeXML.logicalExpr <-
function(x, con, ...)
{
 logicalTags <- c("&" ="elementAnd", "&&"="logicalAnd", 
                  "|" ="elementOr", "||"="logicalOr") 

  tag <- logicalTags[as.character(x[[1]])]

  con$addTag(tag, close=F)

  writeXML(x[[2]], con, ...)
  writeXML(x[[3]], con, ...)

  con$addEndTag(tag)
}

isComparator <-
function(x, ...)
{
 if(is.expression(x))
  x <- x[[1]]

 !is.na(match(as.character(x[[1]]), c("<", ">", "<=", ">=", "==", "!=")))
}

writeXML.comparator <-
function(x, con, ...)
{
 logicalTags <- c("<" ="lessThan", ">"="greaterThan", 
                  "<=" = "lessThanEqual", ">="="greaterThanEqual",
                  "==" = "equal", "!=" = "notEqual") 

  tag <- logicalTags[as.character(x[[1]])]

  con$addTag(tag, close=F)

  writeXML(x[[2]], con, ...)
  writeXML(x[[3]], con, ...)

  con$addEndTag(tag) 
}

writeXML.builtin <-
#
# for primitives 
#
function(x, con, ...)
{
 con$addTag("builtin", attrs=c(name=getPrimitiveName(x)), close=F)
}


writeXML.special <-
#
# for primitives 
#
function(x, con, ...)
{
 con$addTag("special", attrs=c(name=getPrimitiveName(x)), close=F)
}


writeXML.environment <-
#
# for primitives 
#
function(x, con, ...)
{
 con$addTag("environment", attrs=c(name=getPrimitiveName(x)), close=F)
}

getPrimitiveName <-
function(obj)
{
 .Call("RXML_getPrimitiveName", obj)
}
