fromXML.longitudinal <-
function(x)
{
 v <- list(times=x[["times"]][[1]], cov=x[["cov"]][[1]])
 class(v) <- "longitudinal"
 v
}

toString.longitudinal <-
function(x, width, ...)
{
  paste("lgtdl(length=",length(x$times),")",sep="") 
# paste(paste(x$times, x$cov,sep="="), collapse=", ")
}

writeXML.longitudinal <-
function(x, con=xmlOutputBuffer(name="rs", nsURI="/foo/bar"), ...)
{
 con$addTag("longitudinal", attrs=c(size=length(x$times)),
             close=F) 
  con$addTag("times", close=F)
   writeXML(x$times, con)
  con$addEndTag("times")
  con$addTag("cov", close=F)
   writeXML(x$cov, con)
  con$addEndTag("cov")
 con$addEndTag("longitudinal")

 invisible(con)
}

longitudinal <-
function(cov, times=1:length(cov))
{
 o <- list(times=times, cov=cov)
 class(o) <- "longitudinal"

 o
}

testLgtdl <- (function() {
  lgtdl.a <- longitudinal(rnorm(3))
  lgtdl.b <- longitudinal(rnorm(3), seq(2, by=3, length=3))
  lgtdl.c <- longitudinal(rnorm(5), seq(2, by=2, length=5))
  lgtdl.d <- longitudinal(rnorm(4), seq(1, by=5, length=4))

  longFrame <- data.frame(age=c(66,63, 45, 83),
                         measure=I(list(lgtdl.a, lgtdl.b, lgtdl.c, lgtdl.d)))


  con <- writeXML(longFrame)
  con$value()
  newLongFrame <- readXMLObject(con)

  ok <- all.equal(longFrame, newLongFrame)

  return(longFrame=longFrame, newLongFrame=newLongFrame, ok=ok, con=con)
}
)()





