\name{fromXML}
\alias{fromXML.default}
\title{Reads S object from XML representation}
\description{
 This function is responsible for reading an XML
tree from the specified source (src) and converting
it into an S object.
}
\usage{
fromXML(src, handlers = list("rs"=RSXMLHandlers()), DOM = T, asTree=T, checkURI=F, defaultNameSpace="rs", ...)
}
\arguments{
  \item{src}{}
  \item{handlers}{}
  \item{DOM}{}
  \item{asTree}{}
  \item{checkURI}{}
  \item{defaultNameSpace}{}
  \item{\dots}{}
}
\details{
 This function is responsible for reading an XML
 tree from the specified source (src) and converting
 it into an S object. The idea is quite general and works
 as follows.  The XML document contains XML elements
 which are identified by a tag name and an optional namespace 
 identifier.  For each of these elements, we attempt to convert
 the corresponding XML node by looking for a handler function.
 These can be specified in the call to this readXMLObject function
 and/or found in the S search path. 
 To specify the handlers locally, one specifies the handlers for each of
 the different XML namespaces in the document and within each of these,
 a list of functions identified by name corresponding to the tag name. 
 When a node is being converted, we look in these local handlers
 first by namespace and then in the default name space (i.e. currently no name)

 If we do not find a local handler, we start looking for one in the S
 search path. We do this is in a special way. First, we are looking for 
 a function named "fromXML.tagName", where we replace tagName with the actual
 name of the XML element being processed. Rather than looking for it anywhere,
 we look for it in the following places and in the following order.
  1. We look in the package identified by the value of the namespace
     associated with the node's namespace identifier. In other words, 
     we find the URI corresponding to the namespace of the node and see if
     it identifies a handler. It can do this in two ways: a) the last element of 
     the URI can identify a package; b) the URI is  a document
     which contains code for the handlers. 
     a) The URI can identify a package via the last element such as 
         http://www.cran.org/R/ctest
     gives us the `ctest' package and        
         http://www.cran.org/R/ctest?major_version=2
     would identify any minor version of the ctest package with 
     a major version number of 2. This requires further exploration.

     b) We can attempt to resolve the URI and determine if it contains
     code for the handlers for this language. We control this with the
     `checkURI' argument. Specifying false for this argument avoids the 
     overhead of performing potentially time-consuming downloads of URLs.

  2. We use the namespace identifier from the node to identify a package
    in the search path. If such a package has already been loaded into the 
    session, we look in there for the handler function for this node.


  3. Finally, we look for the handler function anywhere in the search path 
     elements.
     

 When we find a match, we use that function and call it with the given
 node. If no match is found in any of these locations, we use the default
 "fromXML" function which itselfs look for a suitable method for the XML
 node being processed using the regular S3 method dispatching.

}
\value{
  ~Describe the value returned
  If it is a LIST, use
  \item{comp1 }{Description of `comp1'}
  \item{comp2 }{Description of `comp2'}
  ...
}
\references{\url{http://www.omegahat.org/RSXML}}
\author{Duncan Temple Lang, Robert Gentleman}


\seealso{
\code{\link{fromXML.object}}
\code{\link{readXMLObject}}
\code{\link{fromXML}}
}

\examples{

}
\keyword{IO}
\keyword{data}

