\name{isLogicalExpression}
\alias{isLogicalExpression}
\title{Whether an call is a logical operator}
\description{
 This function determines whether the specifed 
expression is a call to one of the logical 
operators  \code{&}, \code{&&}, \code{|}, \code{||}.
}
\usage{
isLogicalExpression(x, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{the \code{call} object which is to be examined to determine
 if it is a logical function. This can also be an \code{expression}
 object in which case only the first element is examined.}
  \item{\dots}{unused}
}
\details{
 This looks at the ``function'' being called
in the expression to determine if it is
one of the \code{&}, \code{&&}, \code{|}, \code{||}.
}
\value{
 A logical value indicating whether the specified
object represents a logical expression.
}

\references{\url{http://www.omegahat.org/RSXML}}
\author{Duncan Temple Lang, Robert Gentleman}

\seealso{
\code{\link{readXMLObject}}
}

\examples{
  # TRUE
 isLogicalExpression(quote( x & y))
 isLogicalExpression(quote( x && y))

  # FALSE
 isLogicalExpression(quote( x < y))
 isLogicalExpression(quote(foo(x)))
}
\keyword{language}
