\name{writeXML}
\alias{writeXML}
\alias{writeXML.builtin}
\alias{writeXML.default}
\alias{writeXML.AsIs}
\alias{writeXML.call}
\alias{writeXML.closure}
\alias{writeXML.vector}
\alias{writeXML.character}
\alias{writeXML.logical}
\alias{writeXML.integer}
\alias{writeXML.numeric}
\alias{writeXML.double}
\alias{writeXML.list}
\alias{writeXML.matrix}
\alias{writeXML.data.frame}
\alias{writeXML.closure}
\alias{writeXML.comparator}
\alias{writeXML.environment}
\alias{writeXML.logicalExpr}
\alias{writeXML.POSIXct}
\alias{writeXML.POSIXlt}
\alias{writeXML.object}
\alias{writeXML.language}
\alias{writeXML.ts}
\alias{writeXML.while}
\alias{writeXML.for}
\alias{writeXML.if}
\alias{writeXML.special}
\alias{writeXML.symbol}
\alias{writeXML.table}

\title{Write an XML representation of an object to an XML connection}
\description{
 This writes an XML representation of the specified object
to the XML connection by ``marking up'' the structure and elements
of the object.
}
\usage{
writeXML(x, con, ...)
}
\arguments{
  \item{x}{the object to be represented.}
  \item{con}{the connection to which the representation should be written.
This is a special type of object that supports
\code{addTag}, \code{addEndTag}, etc. 
and writes the XML representation to a buffer of some sort
(e.g. a file, string, generic connection, etc.) }
  \item{\dots}{any other arguments that control the creation
of the XML representation and are passed on to methods.}
}
\details{
This uses a general and user-level extensible
mechanism to find methods to create XML representations
for each of the different data types in S
and user-defined data types.
}
\value{
 The connection object which was passed as the second argument.
The point of this is that it may be a closure instance
that contains the XML representation.
For example, if the value of a call to 
\code{\link{xmlOutputBuffer}} is passed,
its \code{value} method returns the string containing the XML representation.
}
\references{\url{http://www.omegahat.org/RSXML}}
\author{Duncan Temple Lang, Robert Gentleman}

\seealso{
\code{\link{readXMLObject}}
\code{\link{xmlOutputBuffer}}
}

\examples{
 con <- xmlOutputBuffer(nameSpace="rs")
 a <- c(T,F,T)
 invisible(writeXML(a,con))
 v <- readXMLObject(con$value(), asText=T)
 all(a == v)

  # a simple list
 con <- writeXML(list(rnorm(4),letters[1:3]))
 readXMLObject(con$value(),asText=T)

  #
 con <- writeXML(list(a=rnorm(4),b=letters[1:3]))
 readXMLObject(con$value(),asText=T)


  # a named list with a (partially named) list as one of its elements (e)
 con <- xmlOutputBuffer(nameSpace="rs")
 a <- list(a=letters[1:3], b=rnorm(4), c=c(T,F),d=1:3, e=list(1:2,w=1))
 invisible(writeXML(a,con))
 all.equal(readXMLObject(con$value(), asText=T), a)


   # Writing to a connection (file).
  tmp <- tempfile()
  f <- file(tmp, open="w")
  invisible(writeXML(a, xmlOutputBuffer(nameSpace="rs", buf=f)))
  readXMLObject(tmp)
}
\keyword{IO}
\keyword{data}
\keyword{file}